/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import kd.epm.emr.business.template.serializer.ISerializerConstant;
import kd.epm.emr.common.spread.sheet.Cell;
import kd.epm.emr.common.spread.sheet.ISheet;
import kd.epm.emr.common.spread.sheet.StyleCell;
import kd.epm.epbs.common.util.ObjectSerialUtil;

public class SheetSerializer
implements ISerializerConstant {
    protected JsonGenerator jsonGenerator;
    protected SerializerProvider serializerProvider;

    public void setJsonGenerator(JsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
    }

    public void setSerializerProvider(SerializerProvider serializerProvider) {
        this.serializerProvider = serializerProvider;
    }

    public void serialize(ISheet sheet) throws IOException, JsonProcessingException {
        this.writeSheets(sheet);
    }

    protected void writeSheets(ISheet sheet) throws IOException {
        this.jsonGenerator.writeStringField("sheetname", sheet.getSheetName());
        this.jsonGenerator.writeNumberField("vars", sheet.getValueAreaRowStart());
        this.jsonGenerator.writeNumberField("vacs", sheet.getValueAreaColStart());
        this.jsonGenerator.writeNumberField("drs", sheet.getDimRowStart());
        this.jsonGenerator.writeNumberField("dcs", sheet.getDimColStart());
        this.jsonGenerator.writeNumberField("rmrs", sheet.getRealMaxRows());
        this.jsonGenerator.writeNumberField("rmcs", sheet.getRealMaxCols());
        this.jsonGenerator.writeBooleanField("idc", sheet.isIsdatachanged());
        this.jsonGenerator.writeBooleanField("isc", sheet.isStyleCell());
        if (sheet.getSheetDefaults() != null) {
            this.jsonGenerator.writeObjectFieldStart("defaults");
            sheet.getSheetDefaults().forEach((k, v) -> {
                if (k != null && v != null) {
                    try {
                        this.jsonGenerator.writeStringField(k, String.valueOf(v));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            this.jsonGenerator.writeEndObject();
        }
        this.writeTable(sheet.getTable());
    }

    protected void writeTable(List<List<Cell>> table) throws IOException {
        this.jsonGenerator.writeArrayFieldStart("tb");
        table.forEach(row -> {
            try {
                this.jsonGenerator.writeStartArray();
                row.forEach(cell -> {
                    try {
                        this.writeCell((Cell)cell);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                this.jsonGenerator.writeEndArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        this.jsonGenerator.writeEndArray();
    }

    protected void writeCell(Cell cell) throws IOException {
        this.jsonGenerator.writeStartObject();
        if (cell != null) {
            if (cell.isFloatCell()) {
                this.jsonGenerator.writeNumberField("ifc", 1);
            }
            if (cell.getValue() != null) {
                this.writeCellData(cell);
            }
            if (cell.getUserObject() != null && cell.getUserObject().size() > 0) {
                this.writeUserObject(cell);
            }
            if (cell.getFormula() != null) {
                this.jsonGenerator.writeStringField("f", cell.getFormula());
            }
            if (cell.isChangeVal()) {
                this.jsonGenerator.writeNumberField("c", 1);
            }
            if (cell instanceof StyleCell) {
                if (((StyleCell)cell).getTextIndent() != 0) {
                    this.jsonGenerator.writeNumberField("ti", ((StyleCell)cell).getTextIndent());
                }
                if (((StyleCell)cell).getFormatter() != null) {
                    this.jsonGenerator.writeStringField("fm", ((StyleCell)cell).getFormatter());
                }
                if (((StyleCell)cell).getFont() != null) {
                    this.jsonGenerator.writeStringField("ft", ((StyleCell)cell).getFont());
                }
            }
        }
        this.jsonGenerator.writeEndObject();
    }

    protected void writeUserObject(Cell cell) throws IOException {
        if (cell.getUserObject() == null || cell.getUserObject().size() == 0) {
            return;
        }
        if (cell.isFloatCell() && cell.getUserObject("scope") != null) {
            this.jsonGenerator.writeStringField("ub", ObjectSerialUtil.toByteSerialized((Object)cell.getUserObject()));
        } else {
            this.jsonGenerator.writeObjectFieldStart("ub");
            cell.getUserObject().forEach((K, V) -> {
                try {
                    this.serializerProvider.defaultSerializeField(K, V, this.jsonGenerator);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            this.jsonGenerator.writeEndObject();
        }
    }

    protected void writeCellData(Cell cell) throws IOException {
        if (cell.getValue() != null) {
            if (10 == cell.getVariant().getVt() || 9 == cell.getVariant().getVt()) {
                this.jsonGenerator.writeNumberField("v", (BigDecimal)cell.getValue());
            } else {
                this.jsonGenerator.writeArrayFieldStart("v");
                this.jsonGenerator.writeNumber(cell.getVariant().getVt());
                this.jsonGenerator.writeString(cell.getVariant().toString());
                this.jsonGenerator.writeEndArray();
            }
        }
    }
}

