/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Iterator;
import kd.epm.emr.business.template.ITemplateModel;
import kd.epm.emr.business.template.TemplateModel;
import kd.epm.emr.business.template.dimension.DefaultDimension;
import kd.epm.emr.business.template.pagedim.DefaultPageDimensionEntry;
import kd.epm.emr.business.template.pagedim.IPageDimensionEntry;
import kd.epm.emr.business.template.serializer.ISerializerConstant;
import kd.epm.emr.business.template.viewpointdim.DefaultViewPointDimensionEntry;
import kd.epm.emr.common.template.EmrDefaultDimMember;
import kd.epm.epbs.common.model.IDimensionMember;

public class TemplateModelDeserializer
extends JsonDeserializer
implements ISerializerConstant {
    public ITemplateModel readTemplateModel(JsonNode rootNode) {
        ITemplateModel templateModel = TemplateModel.getInstance();
        this.readInfo(rootNode, templateModel);
        this.readViewEntry(rootNode, templateModel);
        this.readPageEntry(rootNode, templateModel);
        return templateModel;
    }

    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode rootNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        return this.readTemplateModel(rootNode);
    }

    protected void readInfo(JsonNode rootNode, ITemplateModel templateModel) {
        if (rootNode == null) {
            return;
        }
        JsonNode bizmodelId = rootNode.get("bmi");
        templateModel.setBizModelId(null != bizmodelId && !bizmodelId.isNull() ? Long.valueOf(bizmodelId.asLong()) : null);
    }

    private void readPageEntry(JsonNode rootNode, ITemplateModel fixTemplateModel) {
        if (rootNode == null || rootNode.get("pme") == null) {
            return;
        }
        Iterator viewnodes = rootNode.get("pme").elements();
        while (viewnodes != null && viewnodes.hasNext()) {
            JsonNode viewnode = (JsonNode)viewnodes.next();
            IPageDimensionEntry pageDimensionEntry = this.readOnePageEntry(viewnode);
            fixTemplateModel.addPagemembentry(pageDimensionEntry);
        }
    }

    private IPageDimensionEntry readOnePageEntry(JsonNode viewnode) {
        DefaultPageDimensionEntry pageentry = new DefaultPageDimensionEntry();
        JsonNode viewNumber = viewnode.get("vn");
        JsonNode viewId = viewnode.get("vi");
        pageentry.setViewNumber(null != viewNumber && !viewNumber.isNull() ? viewNumber.asText() : null);
        pageentry.setViewId(null != viewId && !viewId.isNull() ? Long.valueOf(viewId.asLong()) : null);
        DefaultDimension dimension = new DefaultDimension();
        dimension.setNumber(viewnode.get("dimnum").asText());
        dimension.setId(viewnode.get("dimid").asLong());
        pageentry.setDimension(dimension);
        JsonNode memberNode = viewnode.get("mem");
        if (memberNode == null) {
            return pageentry;
        }
        Iterator membernodes = memberNode.elements();
        while (membernodes != null && membernodes.hasNext()) {
            JsonNode membernode = (JsonNode)membernodes.next();
            EmrDefaultDimMember dimMember = new EmrDefaultDimMember();
            dimMember.setNumber(membernode.get("dmnum").asText());
            if (membernode.get("pmnum") != null) {
                dimMember.setParentNum(membernode.get("pmnum").asText());
            }
            dimMember.setScope(membernode.get("scp").asInt());
            dimMember.setType(membernode.get("dmt").asText());
            dimMember.setId(Long.valueOf(membernode.get("dmid").asLong()));
            viewNumber = membernode.get("vn");
            viewId = membernode.get("vi");
            dimMember.setViewNumber(null != viewNumber && !viewNumber.isNull() ? viewNumber.asText() : null);
            dimMember.setViewId(null != viewId && !viewId.isNull() ? Long.valueOf(viewId.asLong()) : null);
            pageentry.addOneMember((IDimensionMember)dimMember);
        }
        return pageentry;
    }

    private void readViewEntry(JsonNode rootNode, ITemplateModel fixTemplateModel) {
        this.readViewEntry(rootNode, fixTemplateModel, "vpe");
    }

    private void readViewEntry(JsonNode rootNode, ITemplateModel fixTemplateModel, String prefix) {
        if (rootNode == null || rootNode.get(prefix) == null) {
            return;
        }
        Iterator entrys = rootNode.get(prefix).elements();
        while (entrys != null && entrys.hasNext()) {
            JsonNode entry = (JsonNode)entrys.next();
            DefaultViewPointDimensionEntry viewentry = new DefaultViewPointDimensionEntry();
            EmrDefaultDimMember member = new EmrDefaultDimMember();
            JsonNode dimMember = entry.get("dmnum");
            JsonNode dimMemberType = entry.get("dmt");
            JsonNode dimMemberId = entry.get("dmid");
            JsonNode viewNumber = entry.get("vn");
            JsonNode viewId = entry.get("vi");
            member.setNumber(null != dimMember ? dimMember.asText() : null);
            member.setType(null != dimMemberType ? dimMemberType.asText() : null);
            member.setId(null != dimMemberId ? Long.valueOf(dimMemberId.asLong()) : null);
            member.setViewNumber(null != viewNumber && !viewNumber.isNull() ? viewNumber.asText() : null);
            member.setViewId(null != viewId && !viewId.isNull() ? Long.valueOf(viewId.asLong()) : null);
            DefaultDimension dimension = new DefaultDimension();
            dimension.setNumber(entry.get("dimnum").asText());
            dimension.setId(entry.get("dimid").asLong());
            viewentry.setDimension(dimension);
            viewentry.setMember((IDimensionMember)member);
            if (!"vpe".equals(prefix)) continue;
            fixTemplateModel.addViewpointmembentry(viewentry);
        }
    }
}

