/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import kd.epm.emr.business.template.ITemplateModel;
import kd.epm.emr.business.template.TemplateModel;
import kd.epm.emr.business.template.pagedim.IPageDimensionEntry;
import kd.epm.emr.business.template.serializer.ISerializerConstant;
import kd.epm.emr.business.template.serializer.SheetSerializer;
import kd.epm.emr.business.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.epbs.common.model.DefaultDimMember;
import kd.epm.epbs.common.model.IDimensionMember;
import kd.epm.epbs.common.util.IDUtils;
import org.apache.commons.lang3.StringUtils;

public class TemplateModelSerializer
extends JsonSerializer
implements ISerializerConstant {
    private JsonGenerator jsonGenerator;
    SerializerProvider serializerProvider;
    private SheetSerializer sheetSerializer = new SheetSerializer();

    public void setJsonGenerator(JsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
    }

    public void setSerializerProvider(SerializerProvider serializerProvider) {
        this.serializerProvider = serializerProvider;
    }

    public void serialize(Object obj) throws IOException {
        this.serialize(obj, this.jsonGenerator, this.serializerProvider);
    }

    public void serialize(Object obj, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (jsonGenerator != null && serializerProvider != null && obj instanceof TemplateModel) {
            this.jsonGenerator = jsonGenerator;
            this.serializerProvider = serializerProvider;
            this.sheetSerializer.setJsonGenerator(jsonGenerator);
            this.sheetSerializer.setSerializerProvider(serializerProvider);
            TemplateModel templateModel = (TemplateModel)obj;
            this.writeViewEntry(templateModel.getViewpointmembentry());
            this.writePageEntry(templateModel.getPagemembentry());
            this.writeInfo(templateModel);
        }
    }

    protected void writeInfo(ITemplateModel templateModel) throws IOException {
        if (IDUtils.isNotNull((Long)templateModel.getBizModelId())) {
            this.jsonGenerator.writeNumberField("bmi", templateModel.getBizModelId().longValue());
        }
    }

    protected void writePageEntry(List<IPageDimensionEntry> pagemembentrys) throws IOException {
        if (pagemembentrys == null || pagemembentrys.size() == 0) {
            return;
        }
        this.jsonGenerator.writeArrayFieldStart("pme");
        for (IPageDimensionEntry pagemembentry : pagemembentrys) {
            this.jsonGenerator.writeStartObject();
            this.writeOnePageEntry(pagemembentry);
            this.jsonGenerator.writeEndObject();
        }
        this.jsonGenerator.writeEndArray();
    }

    protected void writeViewEntry(List<IViewPointDimensionEntry> viewpointmembentry) throws IOException {
        this.writeOneDimEntry(viewpointmembentry, "vpe");
    }

    protected void writeOneDimEntry(List<IViewPointDimensionEntry> entrys, String prefix) throws IOException {
        if (entrys == null || entrys.size() == 0) {
            return;
        }
        this.jsonGenerator.writeArrayFieldStart(prefix);
        for (IViewPointDimensionEntry entry : entrys) {
            if (entry == null) continue;
            this.jsonGenerator.writeStartObject();
            if (entry.getDimension() != null) {
                this.jsonGenerator.writeStringField("dimnum", entry.getDimension().getNumber());
                this.jsonGenerator.writeNumberField("dimid", entry.getDimension().getId().longValue());
            }
            if (entry.getMember() != null) {
                this.jsonGenerator.writeStringField("dmnum", entry.getMember().getNumber());
                this.jsonGenerator.writeStringField("dmt", entry.getMember().getType());
                this.jsonGenerator.writeNumberField("dmid", entry.getMember().getId().longValue());
                this.jsonGenerator.writeStringField("vn", entry.getMember().getViewNumber());
                this.jsonGenerator.writeNumberField("vi", entry.getMember().getViewId().longValue());
            }
            this.jsonGenerator.writeEndObject();
        }
        this.jsonGenerator.writeEndArray();
    }

    protected void writeOnePageEntry(IPageDimensionEntry pagemembentry) throws IOException {
        this.jsonGenerator.writeStringField("dimnum", pagemembentry.getDimension().getNumber());
        this.jsonGenerator.writeNumberField("dimid", pagemembentry.getDimension().getId().longValue());
        if (pagemembentry.getViewNumber() != null) {
            this.jsonGenerator.writeStringField("vn", pagemembentry.getViewNumber());
        }
        if (pagemembentry.getViewId() != null) {
            this.jsonGenerator.writeNumberField("vi", pagemembentry.getViewId().longValue());
        }
        if (pagemembentry.getMembers() != null && pagemembentry.getMembers().size() > 0) {
            this.jsonGenerator.writeArrayFieldStart("mem");
            for (IDimensionMember member : pagemembentry.getMembers()) {
                if (member == null || member.getNumber() == null) continue;
                this.jsonGenerator.writeStartObject();
                this.jsonGenerator.writeStringField("dmnum", member.getNumber());
                if (StringUtils.isNotEmpty((CharSequence)member.getParentNum())) {
                    this.jsonGenerator.writeStringField("pmnum", member.getParentNum());
                }
                if (member instanceof DefaultDimMember) {
                    if (member.getType() != null) {
                        this.jsonGenerator.writeStringField("dmt", member.getType());
                    }
                    if (member.getLongNumber() != null) {
                        this.jsonGenerator.writeStringField("dmlnum", member.getLongNumber());
                    }
                    if (member.getViewNumber() != null) {
                        this.jsonGenerator.writeStringField("vn", member.getViewNumber());
                    }
                    if (member.getViewId() != null) {
                        this.jsonGenerator.writeNumberField("vi", member.getViewId().longValue());
                    }
                }
                this.jsonGenerator.writeNumberField("scp", member.getScope());
                this.jsonGenerator.writeNumberField("dmid", member.getId().longValue());
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeEndArray();
        }
    }
}

