/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template.service;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.dimension.IDimension;
import kd.epm.emr.business.template.quote.QuoteTypeEnum;
import kd.epm.epbs.business.model.f7.MemberF7Parameter;
import kd.epm.epbs.common.model.IBaseEntry;
import kd.epm.epbs.common.model.IDimensionMember;
import kd.epm.epbs.common.model.PropertyEntry;
import kd.epm.epbs.common.model.PropertyValueEntry;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.model.bean.relation.RelationModelBean;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.Pair;
import org.apache.commons.collections4.CollectionUtils;

public interface ITemplateMemberService {
    public Long getModelId();

    public void setModelId(Long var1);

    public Set<String> getDefPageDims();

    public Set<String> getDefRankDims();

    public String getDefDimMember(String var1, String var2);

    public ViewBean getDefView(String var1, Long var2);

    public List<IDimension> getAllDims(Long var1);

    public IDimension getDimension(String var1);

    public IDimensionMember getDimMember(String var1, String var2, Long var3);

    public IDimensionMember getDimMember(String var1, String var2, Long var3, Long var4);

    public String getPropertyEntity();

    public List<PropertyEntry> getAllPropertys(Long var1, List<String> var2);

    public PropertyValueEntry getPropertyValue(String var1, String var2, Long var3);

    default public Set<String> getAllPropertyRefDimNumbers(Long bizModelId) {
        List<PropertyEntry> allPropertys = this.getAllPropertys(bizModelId, null);
        if (null == allPropertys) {
            return Sets.newHashSet();
        }
        return allPropertys.stream().map(e -> e.getRefDimNumber()).collect(Collectors.toSet());
    }

    public Map<String, List<PropertyEntry>> getMemberProperties(String var1, Set<String> var2);

    public Map<String, Map<String, String>> getMemberPropValues(String var1, Set<Pair<String, String>> var2);

    public Map<String, Map<String, String>> getVarMap(Long var1);

    public IBaseEntry getVar(String var1, String var2, Long var3);

    public Long getViewId(String var1, String var2);

    public ViewBean getView(Long var1);

    default public IBaseEntry getMemberEntry(QuoteTypeEnum type, String dimNumber, Long memberId, Object viewIdOrNumber) {
        return this.getMemberEntry(type, dimNumber, null, memberId, this.buildView(viewIdOrNumber));
    }

    default public IBaseEntry getMemberEntry(QuoteTypeEnum type, String dimNumber, String memberNumber, Object viewIdOrNumber) {
        return this.getMemberEntry(type, dimNumber, memberNumber, null, this.buildView(viewIdOrNumber));
    }

    default public IBaseEntry getMemberEntry(QuoteTypeEnum type, String dimNumber, String memberNumber, Long memberId, Pair<Long, String> view) {
        PropertyValueEntry member = null;
        switch (type) {
            case MEMBER: {
                if (null != view) {
                    Long viewId = IDUtils.isNotNull((Long)((Long)view.p1)) ? (Long)view.p1 : this.getViewId(dimNumber, (String)view.p2);
                    member = this.getDimMember(dimNumber, memberNumber, memberId, viewId);
                    break;
                }
                member = this.getDimMember(dimNumber, memberNumber, memberId);
                break;
            }
            case PROPERTY: {
                member = this.getPropertyValue(dimNumber, memberNumber, memberId);
                break;
            }
            case VAR: {
                member = this.getVar(dimNumber, memberNumber, memberId);
                break;
            }
        }
        return member;
    }

    default public void fillMemberEntry(String dimNumber, Long viewId, List<IDimensionMember> dimMembers) {
        if (StringUtils.isEmpty((String)dimNumber) || CollectionUtils.isEmpty(dimMembers) || IDUtils.isNull((Long)viewId)) {
            return;
        }
        for (IDimensionMember dimensionMember : dimMembers) {
            String dimMemberNumber = dimensionMember.getNumber();
            if (StringUtils.isEmpty((String)dimMemberNumber)) continue;
            QuoteTypeEnum type = QuoteTypeEnum.getByValule(dimensionMember.getType());
            IBaseEntry entry = this.getMemberEntry(type, dimNumber, dimMemberNumber, (Object)(dimensionMember.getViewId() != null ? dimensionMember.getViewId() : viewId));
            dimensionMember.setId(null != entry ? entry.getId() : null);
            dimensionMember.setName(null != entry ? entry.getName() : null);
        }
    }

    default public void fillMemberEntry(String dimNumber, String viewNumber, List<IDimensionMember> dimMembers) {
        if (StringUtils.isEmpty((String)dimNumber) || CollectionUtils.isEmpty(dimMembers) || StringUtils.isEmpty((String)viewNumber)) {
            return;
        }
        this.fillMemberEntry(dimNumber, this.getViewId(dimNumber, viewNumber), dimMembers);
    }

    default public Pair<Long, String> buildView(Object viewIdOrNumber) {
        if (viewIdOrNumber instanceof Long && IDUtils.isNotNull((Long)((Long)viewIdOrNumber))) {
            return Pair.onePair((Object)((Long)viewIdOrNumber), null);
        }
        if (viewIdOrNumber instanceof String) {
            return Pair.onePair(null, (Object)((String)viewIdOrNumber));
        }
        return null;
    }

    public Map<Long, BizModelBean> getBizModelMap();

    public String getBizModelNumber(Long var1);

    public Long getBizModelId(String var1);

    public BizModelBean getBizModel(Long var1);

    public RelationModelBean getRelationModel(Long var1);

    public RelationModelBean getRelationModel(String var1);

    public String getCubeNumber(Long var1);

    public void openMultiF7(IDimension var1, MemberF7Parameter var2, CloseCallBack var3, IFormView var4);

    public void openSingleF7(IDimension var1, MemberF7Parameter var2, CloseCallBack var3, IFormView var4);

    public void openSingleF7ForAreaView(IDimension var1, MemberF7Parameter var2, CloseCallBack var3, IFormView var4);

    public void openSingleF7ForSpread(String var1, IDimension var2, MemberF7Parameter var3, CloseCallBack var4, IFormView var5);

    public Pair<String, List<Map<String, String>>> f7ClosedCallBack(String var1, Object var2);

    public String getMultiF7Results(List<Map<String, String>> var1);

    public MemberF7Parameter getMemberF7Parameter(long var1);

    public MemberF7Parameter getMemberF7Parameter(String var1);

    public MemberF7Parameter getMemberF7Parameter(String var1, long var2);
}

