/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.Tuple;
import kd.epm.emr.business.template.TemplateInfo;
import kd.epm.emr.business.template.quote.TemplateMemberQuote;
import kd.epm.emr.business.template.service.ITemplateMemberRef;
import kd.epm.epbs.business.model.memberref.IMemberRef;
import kd.epm.epbs.business.model.memberref.MemberRefResult;
import kd.epm.epbs.business.model.memberref.RefBean;
import kd.epm.epbs.common.enums.model.RefBizTypeEnum;
import kd.epm.epbs.common.util.IDUtils;
import org.apache.commons.collections4.CollectionUtils;

public abstract class TemplateMemberRef<T extends TemplateInfo>
implements IMemberRef,
ITemplateMemberRef<T> {
    public MemberRefResult check(long modelId, long dimensionId, List<Long> memberIds, boolean isPropValue) {
        List<Long> memIds = memberIds.stream().filter(e -> IDUtils.isNotNull((Long)e)).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(memIds)) {
            TemplateInfo template = this.getTemplateInfo();
            List<TemplateMemberQuote> quotes = this.getMemberQuoteService().queryTemplateMemberQuoteByMember(template.getMemberQuoteEntityNumber(), memIds, null);
            if (CollectionUtils.isNotEmpty(quotes)) {
                Map<Long, Tuple<String, String>> templateMap = this.getTemplateService().getTemplateNumberName(template.getDataEntityNumber(), quotes.stream().map(e -> e.getTemplateId()).collect(Collectors.toSet()));
                ArrayList hasRefList = Lists.newArrayListWithExpectedSize((int)16);
                HashSet uniqueSet = Sets.newHashSetWithExpectedSize((int)16);
                for (TemplateMemberQuote quote : quotes) {
                    String ukey = String.join((CharSequence)"_", IDUtils.toString((Object)quote.getMemberId()), IDUtils.toString((Object)quote.getTemplateId()));
                    Tuple<String, String> tpl = templateMap.get(quote.getTemplateId());
                    if (!uniqueSet.add(ukey) || null == tpl) continue;
                    hasRefList.add(new RefBean(quote.getMemberId().longValue(), (String)tpl.item1, (String)tpl.item2));
                }
                return MemberRefResult.fail((List)hasRefList);
            }
        }
        return MemberRefResult.success();
    }

    public RefBizTypeEnum getMemberRefBizType() {
        return RefBizTypeEnum.TEMPLATE;
    }
}

