/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.common.MembersKey;
import kd.bos.olap.dataSources.CommandInfo;
import kd.bos.olap.dataSources.FixedDimension;
import kd.bos.olap.dataSources.OlapCommand;
import kd.bos.olap.dataSources.OlapConnection;
import kd.bos.olap.dataSources.OlapDataWriter;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.bos.trace.TraceConfig;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.tracer.MemSpanTrace;
import kd.epm.emr.business.template.ReportContext;
import kd.epm.emr.business.template.service.IOlapService;
import kd.epm.epbs.business.olap.FacTabFieldDefEnum;
import kd.epm.epbs.business.olap.OlapServiceHelper;
import kd.epm.epbs.business.olap.SQLBuilder;
import kd.epm.epbs.business.olap.VerifyResult;
import kd.epm.epbs.business.olap.bean.MDResultSet;
import kd.epm.epbs.business.olap.bean.MDResultSetReader;
import kd.epm.epbs.common.util.OlapManagerHelper;
import kotlin.Pair;

public class OlapServiceImpl
implements IOlapService {
    private ReportContext context;

    public OlapServiceImpl(ReportContext context) {
        this.context = context;
    }

    public ReportContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VerifyResult saveData(SaveCommandInfo info, CellSet cellSets, boolean isNeedMonitorDataStatus, boolean isNeedHandleCurrency) {
        VerifyResult vr = null;
        this.handleOlapScale(info, cellSets, isNeedHandleCurrency);
        try {
            vr = this.saveCore(info, cellSets);
            this.dataMonitor(info, cellSets, isNeedMonitorDataStatus);
        }
        catch (Exception e) {
            HashMap<String, String> cellDim = new HashMap<String, String>(16);
            try {
                for (FixedDimension fixedDimension : info.getFixedDimensions()) {
                    cellDim.put(fixedDimension.getName(), fixedDimension.getValue());
                }
                List dims = info.getDimensions();
                String fMoney = FacTabFieldDefEnum.FIELD_MONEY.getField();
                for (String measure : info.getMeasures()) {
                    Iterator it = cellSets.getMetricEntries(fMoney);
                    while (it.hasNext()) {
                        Pair entry = (Pair)it.next();
                        MembersKey key = (MembersKey)entry.getFirst();
                        for (int i = 0; i < dims.size(); ++i) {
                            cellDim.put((String)dims.get(i), key.get(i).toString());
                        }
                    }
                }
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
            }
            finally {
                logger.info("saveData Error: \n" + cellDim);
            }
            logger.error((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"olap\u4fdd\u5b58\u5931\u8d25\uff0c%s", (String)"OlapServiceImpl_0", (String)"epm-emr-business", (Object[])new Object[0]), e.getMessage()));
        }
        return vr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VerifyResult saveCore(SaveCommandInfo info, CellSet cellSets) {
        VerifyResult vr = null;
        if (cellSets.getCount() <= 0) {
            return vr;
        }
        this.handleCellSetAndCheck(info, cellSets);
        vr = this.verifyDataFlowControl(info, cellSets);
        if (cellSets.getCount() <= 0) {
            return vr;
        }
        OlapDataWriter writer = null;
        this.enhanceOlapCommandWithAudit((CommandInfo)info);
        OlapConnection conn = this.getOlapConnection();
        try {
            conn.Open();
            OlapCommand cmd = new OlapCommand(conn, (CommandInfo)info);
            this.setTraceId((CommandInfo)info, false);
            writer = cmd.CreateWriter();
            try (MemSpanTrace span = MemSpanTrace.create((String)"olap", (String)"save");
                 TraceSpan ts = Tracer.create((String)"olap", (String)"save");
                 Auditable audit = Audit.audit((String)"olap_cost", (Object[])new Object[]{"save", info});){
                if (Tracer.isTracing() && TraceConfig.isTypeEnable((String)"olap")) {
                    ts.addTag("sql", info.toString());
                }
                ts.addTag("route", this.getContext().getCubeNum());
                ts.addTag("count", String.valueOf(cellSets.getCount()));
                this.checkIsSetSource((CommandInfo)info);
                cellSets.Save(writer);
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        return vr;
    }

    @Override
    public void handleOlapScale(SaveCommandInfo info, CellSet cellSets, boolean isNeedHandleCurrency) {
        this.handleDefaultOlapScale(info, cellSets);
    }

    @Override
    public void dataMonitor(Object info, CellSet cellSets, boolean isNeedMonitorDataStatus) {
    }

    @Override
    public void handleCellSetAndCheck(SaveCommandInfo info, CellSet cellSets) {
    }

    @Override
    public VerifyResult verifyDataFlowControl(SaveCommandInfo info, CellSet cellSets) {
        return new VerifyResult();
    }

    @Override
    public Map<String, Object> queryData(SelectCommandInfo queryInfo) {
        return OlapServiceHelper.queryData((SelectCommandInfo)queryInfo, (String)this.getContext().getCubeNum(), (Long)this.getContext().getModelId());
    }

    private void handleDefaultOlapScale(SaveCommandInfo info, CellSet cellSets) {
        String fMoney = FacTabFieldDefEnum.FIELD_MONEY.getField();
        for (String measure : info.getMeasures()) {
            if (!measure.equals(fMoney)) {
                return;
            }
            Iterator it = cellSets.getMetricEntries(fMoney);
            while (it.hasNext()) {
                BigDecimal bigDecimal;
                Pair entry = (Pair)it.next();
                MembersKey key = (MembersKey)entry.getFirst();
                Object value = entry.getSecond();
                if (!(value instanceof BigDecimal) || (bigDecimal = (BigDecimal)value).scale() <= 15) continue;
                value = bigDecimal.setScale(15, RoundingMode.HALF_UP);
                cellSets.set(this.getCoordinates(key), fMoney, value);
            }
        }
    }

    public String[] getCoordinates(MembersKey key) {
        int count = key.getCount();
        String[] coordinates = new String[count];
        for (int i = 0; i < count; ++i) {
            coordinates[i] = key.getKey(i);
        }
        return coordinates;
    }

    @Override
    public MDResultSet queryData(SQLBuilder sql, boolean multiMeasure) {
        return OlapServiceHelper.queryData((SQLBuilder)sql, (boolean)multiMeasure);
    }

    @Override
    public MDResultSetReader queryDataReader(SQLBuilder sql) {
        return OlapServiceHelper.queryDataReader((SQLBuilder)sql, (String)this.getContext().getCubeNum(), (long)this.getContext().getModelId());
    }

    @Override
    public void enhanceOlapCommandWithAudit(CommandInfo commandInfo) {
    }

    @Override
    public void setTraceId(CommandInfo commandInfo, boolean setOpInfo) {
    }

    @Override
    public void checkIsSetSource(CommandInfo info) {
    }

    public MDResultSet getMDResultSet() {
        return new MDResultSet();
    }

    public MDResultSetReader getMDResultSetReader() {
        return new MDResultSetReader();
    }

    protected OlapConnection getOlapConnection() {
        return OlapManagerHelper.getOlapConnection((String)this.getContext().getCubeNum(), (Long)this.getContext().getModelId());
    }
}

