/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template.service.impl;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.service.ITemplateCatalogService;
import kd.epm.emr.business.template.service.ITemplateService;
import kd.epm.emr.business.template.service.impl.TemplateServiceImpl;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.LanguageUtil;
import org.apache.commons.collections4.CollectionUtils;

public class TemplateCatalogServiceImpl
implements ITemplateCatalogService {
    public static ITemplateCatalogService getInstance() {
        return new TemplateCatalogServiceImpl();
    }

    public ITemplateService getTemplateService() {
        return TemplateServiceImpl.getInstance(null);
    }

    public DynamicObject createCatalogRootDyn(String entityNumber, Long modelId) {
        DynamicObject newCatalogRoot = ORM.create().newDynamicObject(entityNumber);
        Long rootId = DBServiceHelper.genGlobalLongId();
        newCatalogRoot.set("id", (Object)rootId);
        newCatalogRoot.set("model", (Object)modelId);
        newCatalogRoot.set("number", (Object)"root");
        newCatalogRoot.set("longnumber", (Object)"root");
        MultiLangEnumBridge name = new MultiLangEnumBridge(ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"TemplateCatalogServiceImpl_0", (String)"epm-emr-business", (Object[])new Object[0]), "TemplateCatalogServiceImpl_1", "epm-emr-business");
        newCatalogRoot.set("name", LanguageUtil.getValue((String)name.getDescription(), (String)name.getResourceID(), (String)name.getSystemType()));
        newCatalogRoot.set("status", (Object)"C");
        newCatalogRoot.set("enable", (Object)"1");
        newCatalogRoot.set("level", (Object)"1");
        newCatalogRoot.set("isleaf", (Object)"1");
        newCatalogRoot.set("catalogtype", (Object)"0");
        newCatalogRoot.set("masterid", (Object)rootId);
        newCatalogRoot.set("creator", (Object)RequestContext.get().getCurrUserId());
        return newCatalogRoot;
    }

    @Override
    public void createCatalogRoot(String entityNumber, Long modelId) {
        block15: {
            if (IDUtils.isNull((Long)modelId) || StringUtils.isEmpty((String)entityNumber)) {
                return;
            }
            String lockKey = String.join((CharSequence)"_", entityNumber, IDUtils.toString((Object)modelId));
            try (DLock lock = DLock.create((String)("epbs/createCatalogRoot/" + lockKey));){
                if (lock.tryLock(5000L)) {
                    if (!QueryServiceHelper.exists((String)entityNumber, (QFilter[])new QFilter("model", "=", (Object)modelId).toArray())) {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.createCatalogRootDyn(entityNumber, modelId)});
                    }
                    break block15;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u7e41\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"TemplateCatalogServiceImpl_1", (String)"epm-emr-business", (Object[])new Object[0]));
            }
        }
    }

    @Override
    public int getCurrentSequence(String entityNumber, Long modelId, Long parentId) {
        QFilter model = new QFilter("model", "=", (Object)modelId);
        QFilter parent = new QFilter("parent", "=", (Object)parentId);
        QFilter[] filters = new QFilter[]{model, parent};
        int result = 0;
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)entityNumber, (String)"sequence", (QFilter[])filters, (String)"sequence desc", (int)1);
        if (CollectionUtils.isNotEmpty((Collection)dcs)) {
            result = ((DynamicObject)dcs.get(0)).getInt("sequence");
            ++result;
        }
        return result;
    }

    @Override
    public void deleteCatalog(String entityNumber, List<Long> delCatalogIds, String templateEntityNumber) {
        if (CollectionUtils.isEmpty(delCatalogIds)) {
            return;
        }
        Long catalogId = delCatalogIds.get(0);
        QFilter filter = new QFilter("id", "=", (Object)catalogId);
        DynamicObject catalog = QueryServiceHelper.queryOne((String)entityNumber, (String)"parent", (QFilter[])filter.toArray());
        if (null == catalog) {
            return;
        }
        Long newCatalogId = catalog.getLong("parent");
        if (delCatalogIds.contains(newCatalogId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b0\u5206\u7c7bID\u5b58\u5728\u4e8e\u5220\u9664ID\u96c6\u5408\u4e2d\u3002", (String)"TemplateCatalogServiceImpl_2", (String)"epm-emr-business", (Object[])new Object[0]));
        }
        try (TXHandle required = TX.required((String)"deleteCatalog");){
            try {
                filter = new QFilter("id", "in", delCatalogIds);
                DeleteServiceHelper.delete((String)entityNumber, (QFilter[])filter.toArray());
                this.getTemplateService().updateTemplateCatalog(templateEntityNumber, delCatalogIds, newCatalogId);
            }
            catch (Exception ex) {
                required.markRollback();
                throw ex;
            }
        }
    }

    @Override
    public void swapCatalogSeq(String entityNumber, Long catalogId, Long swapCatalogId) {
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)entityNumber, (String)"sequence", (QFilter[])new QFilter("id", "in", (Object)Sets.newHashSet((Object[])new Long[]{catalogId, swapCatalogId})).toArray());
        if (dyns.length == 2) {
            int swapSeq0 = dyns[0].getInt("sequence");
            int swapSeq1 = dyns[1].getInt("sequence");
            dyns[0].set("sequence", (Object)swapSeq1);
            dyns[1].set("sequence", (Object)swapSeq0);
            SaveServiceHelper.save((DynamicObject[])dyns);
        }
    }
}

