/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template.service.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.quote.TemplateMemberQuote;
import kd.epm.emr.business.template.service.ITemplateMemberQuoteService;
import org.apache.commons.collections4.CollectionUtils;

public class TemplateMemberQuoteServiceImpl
implements ITemplateMemberQuoteService {
    private static final Log log = LogFactory.getLog(TemplateMemberQuoteServiceImpl.class);

    public static ITemplateMemberQuoteService getInstance() {
        return new TemplateMemberQuoteServiceImpl();
    }

    @Override
    public void saveTemplateMemberQuote(String entityNumber, List<TemplateMemberQuote> quotes) {
        if (CollectionUtils.isEmpty(quotes)) {
            return;
        }
        DynamicObjectType objectType = ORM.create().newDynamicObject(entityNumber).getDynamicObjectType();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(quotes.size());
        for (TemplateMemberQuote quote : quotes) {
            DynamicObject dyn = new DynamicObject(objectType);
            dyn.set("model", (Object)quote.getModelId());
            dyn.set("bizmodel", (Object)quote.getBizModelId());
            dyn.set("dimension", (Object)quote.getDimensionId());
            dyn.set("member", (Object)quote.getMemberId());
            dyn.set("type", (Object)quote.getType());
            dyn.set("template", (Object)quote.getTemplateId());
            dyn.set("usetype", (Object)quote.getUseType());
            dyn.set("range", (Object)quote.getRange());
            dyn.set("view", (Object)quote.getViewId());
            dyn.set("dseq", (Object)quote.getSeq());
            list.add(dyn);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    @Override
    public void saveTemplateMemberQuote(String entityNumber, Long templateId, List<TemplateMemberQuote> quotes) {
        this.deleteTemplateMemberQuote(entityNumber, Lists.newArrayList((Object[])new Long[]{templateId}));
        this.saveTemplateMemberQuote(entityNumber, quotes);
    }

    @Override
    public void deleteTemplateMemberQuote(String entityNumber, Collection<Long> templateIds) {
        DeleteServiceHelper.delete((String)entityNumber, (QFilter[])new QFilter("template", "in", templateIds).toArray());
    }

    @Override
    public DynamicObjectCollection queryTemplateMemberQuote(String entityNumber, QFilter filter) {
        String selectFields = "bizmodel, dimension, member, type, usetype, range, view, dseq, template";
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)entityNumber, (String)selectFields, (QFilter[])filter.toArray());
        return dyns;
    }

    @Override
    public List<TemplateMemberQuote> queryTemplateMemberQuoteByTempalte(String entityNumber, Collection<Long> templateIds, Collection<String> usetypes) {
        QFilter filter = new QFilter("template", "in", templateIds);
        if (CollectionUtils.isNotEmpty(usetypes)) {
            filter.and("usetype", "in", usetypes);
        }
        DynamicObjectCollection dyns = this.queryTemplateMemberQuote(entityNumber, filter);
        return dyns.stream().map(e -> this.buildTemplateMemberQuote((DynamicObject)e)).collect(Collectors.toList());
    }

    @Override
    public List<TemplateMemberQuote> queryTemplateMemberQuoteByMember(String entityNumber, Collection<Long> memberIds, Collection<String> types) {
        QFilter filter = new QFilter("member", "in", memberIds);
        if (CollectionUtils.isNotEmpty(types)) {
            filter.and("type", "in", types);
        }
        DynamicObjectCollection dyns = this.queryTemplateMemberQuote(entityNumber, filter);
        return dyns.stream().map(e -> this.buildTemplateMemberQuote((DynamicObject)e)).collect(Collectors.toList());
    }

    @Override
    public List<TemplateMemberQuote> queryTemplateMemberQuoteByBizModel(String entityNumber, Collection<Long> bizModelIds, Collection<String> types) {
        QFilter filter = new QFilter("bizmodel", "in", bizModelIds);
        if (CollectionUtils.isNotEmpty(types)) {
            filter.and("type", "in", types);
        }
        DynamicObjectCollection dyns = this.queryTemplateMemberQuote(entityNumber, filter);
        return dyns.stream().map(e -> this.buildTemplateMemberQuote((DynamicObject)e)).collect(Collectors.toList());
    }

    @Override
    public TemplateMemberQuote buildTemplateMemberQuote(DynamicObject dyn) {
        Long templateId = dyn.getLong("template");
        Long bizModelId = dyn.getLong("bizmodel");
        Long dimId = dyn.getLong("dimension");
        Long memId = dyn.getLong("member");
        String type = dyn.getString("type");
        String usetype = dyn.getString("usetype");
        String range = dyn.getString("range");
        Long view = dyn.getLong("view");
        int seq = dyn.getInt("dseq");
        return new TemplateMemberQuote(null, templateId, bizModelId, dimId, memId, type, usetype, range, view, seq);
    }

    @Override
    public boolean existMember(String entityNumber, Long memberId, String type) {
        QFilter filter = new QFilter("member", "=", (Object)memberId);
        if (StringUtils.isNotEmpty((String)type)) {
            filter.and("type", "=", (Object)type);
        }
        return QueryServiceHelper.exists((String)entityNumber, (QFilter[])filter.toArray());
    }
}

