/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.business.template.service.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.ITemplateModel;
import kd.epm.emr.business.template.TemplateInfo;
import kd.epm.emr.business.template.TemplateModel;
import kd.epm.emr.business.template.TemplateSheet;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.dimension.DefaultDimension;
import kd.epm.emr.business.template.dimension.IDimension;
import kd.epm.emr.business.template.headerarea.IHeaderInfo;
import kd.epm.emr.business.template.headerarea.IHeaderObject;
import kd.epm.emr.business.template.pagedim.DefaultPageDimensionEntry;
import kd.epm.emr.business.template.pagedim.IPageDimensionEntry;
import kd.epm.emr.business.template.quote.QuoteTypeEnum;
import kd.epm.emr.business.template.quote.QuoteUseTypeEnum;
import kd.epm.emr.business.template.quote.TemplateMemberQuote;
import kd.epm.emr.business.template.service.ITemplateMemberQuoteService;
import kd.epm.emr.business.template.service.ITemplateMemberService;
import kd.epm.emr.business.template.service.ITemplateService;
import kd.epm.emr.business.template.service.impl.TemplateMemberQuoteServiceImpl;
import kd.epm.emr.business.template.viewpointdim.DefaultViewPointDimensionEntry;
import kd.epm.emr.common.template.EmrDefaultDimMember;
import kd.epm.epbs.common.enums.RangeEnum;
import kd.epm.epbs.common.enums.model.BizModelTypeEnum;
import kd.epm.epbs.common.model.IBaseEntry;
import kd.epm.epbs.common.model.IDimensionMember;
import kd.epm.epbs.common.model.IViewInfo;
import kd.epm.epbs.common.model.PropertyEntry;
import kd.epm.epbs.common.model.bean.BaseBean;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.model.bean.relation.FieldBean;
import kd.epm.epbs.common.model.bean.relation.RelationModelBean;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.ReflectUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;

public class TemplateServiceImpl
implements ITemplateService {
    private static final Log log = LogFactory.getLog(TemplateServiceImpl.class);
    protected ITemplateMemberService templateMemberService;
    protected ITemplateMemberQuoteService templateMemberQuoteService;

    public static ITemplateService getInstance(ITemplateMemberService templateMemberService) {
        return new TemplateServiceImpl(templateMemberService);
    }

    private TemplateServiceImpl(ITemplateMemberService templateMemberService) {
        this.templateMemberService = templateMemberService;
        this.templateMemberQuoteService = TemplateMemberQuoteServiceImpl.getInstance();
    }

    public ITemplateMemberQuoteService getMemberQuoteService() {
        return this.templateMemberQuoteService;
    }

    public ITemplateMemberService getTemplateMemberService() {
        return this.templateMemberService;
    }

    @Override
    public void updateTemplateCatalog(String entityNumber, Collection<Long> oldCatalogIds, Long newCatalogId) {
        Object[] dyns = BusinessDataServiceHelper.load((String)entityNumber, (String)"templatecatalog", (QFilter[])new QFilter("templatecatalog", "in", oldCatalogIds).toArray());
        if (ArrayUtils.isNotEmpty((Object[])dyns)) {
            for (Object d : dyns) {
                d.set("templatecatalog", (Object)newCatalogId);
            }
            SaveServiceHelper.save((DynamicObject[])dyns);
        }
    }

    @Override
    public <T extends TemplateInfo> void saveTemplate(T template, List<TemplateMemberQuote> quotes) {
        if (null == template) {
            return;
        }
        List<String> msg = this.validateMemberQuote(quotes);
        if (CollectionUtils.isNotEmpty(msg)) {
            throw new KDBizException(org.apache.commons.lang3.StringUtils.join(msg, (String)"\n"));
        }
        BusinessDataWriter.delete((String)template.getDataEntityNumber(), (QFilter[])new QFilter("id", "=", (Object)template.getId()).toArray());
        if (template.getCreatorId() == 0L) {
            template.setCreatorId(RequestContext.get().getCurrUserId());
        }
        if (template.getEffectivedate() == null) {
            template.setEffectivedate(new Date());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{template.genDynamicObject()});
        this.getMemberQuoteService().saveTemplateMemberQuote(template.getMemberQuoteEntityNumber(), template.getId(), quotes);
    }

    @Override
    public <T extends TemplateInfo> void deleteTemplate(Class<T> clazz, Collection<Long> templateIds) {
        TemplateInfo template = (TemplateInfo)((Object)ReflectUtils.newInstance(clazz));
        try (TXHandle required = TX.required((String)"deleteTemplate");){
            try {
                DeleteServiceHelper.delete((String)template.getDataEntityNumber(), (QFilter[])new QFilter("id", "in", templateIds).toArray());
                this.getMemberQuoteService().deleteTemplateMemberQuote(template.getMemberQuoteEntityNumber(), templateIds);
            }
            catch (Exception ex) {
                required.markRollback();
                throw ex;
            }
        }
    }

    @Override
    public <T extends TemplateInfo> T getSimpleTemplateInfo(Class<T> clazz, Long templateId) {
        return this.getTemplateInfo(clazz, templateId, true);
    }

    @Override
    public <T extends TemplateInfo> T getTemplateInfo(Class<T> clazz, Long templateId, boolean onlyBaseInfo) {
        TemplateInfo templateBaseInfo = (TemplateInfo)((Object)ReflectUtils.newInstance(clazz));
        templateBaseInfo.genModel(templateId, onlyBaseInfo);
        return (T)((Object)templateBaseInfo);
    }

    @Override
    public <T extends TemplateInfo> List<T> getSimpleTemplateInfo(Class<T> clazz, QFilter[] filters, String orderBy, int top) {
        return this.getSimpleTemplateInfo(clazz, null, filters, orderBy, top);
    }

    @Override
    public <T extends TemplateInfo> List<T> getSimpleTemplateInfo(Class<T> clazz, String selectProperties, QFilter[] filters, String orderBy, int top) {
        TemplateInfo templateBaseInfo = (TemplateInfo)((Object)ReflectUtils.newInstance(clazz));
        if (StringUtils.isEmpty((String)selectProperties)) {
            selectProperties = String.join((CharSequence)",", templateBaseInfo.getBaseInfoFields());
        }
        DynamicObject[] dynas = BusinessDataServiceHelper.load((String)templateBaseInfo.getDataEntityNumber(), (String)selectProperties, (QFilter[])filters, (String)orderBy, (int)top);
        ArrayList<TemplateInfo> list = new ArrayList<TemplateInfo>(dynas.length);
        for (DynamicObject dyna : dynas) {
            TemplateInfo t = (TemplateInfo)((Object)ReflectUtils.newInstance(clazz));
            list.add(t.genModel(dyna, true));
        }
        return list;
    }

    @Override
    public <T extends TemplateInfo> ITemplateModel<T> getTemplateModel(Class<T> clazz, Long templateId) {
        T template = this.getTemplateInfo(clazz, templateId, false);
        return this.getTemplateModel(template);
    }

    @Override
    public <T extends TemplateInfo> ITemplateModel<T> getTemplateModel(String className, Long templateId) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Object template = this.getTemplateInfo(clazz, templateId, false);
        return this.getTemplateModel((T)((Object)template));
    }

    @Override
    public <T extends TemplateInfo> ITemplateModel<T> getTemplateModel(T template) {
        ITemplateModel<T> templateModel = TemplateModel.getInstance();
        templateModel.setTemplateBaseInfo(template);
        templateModel.setBizModelId(this.getTemplateMemberService().getBizModelId(templateModel.getBizModel()));
        this.loadViewAndPageDimsByQuote(templateModel);
        this.fillDimMemberNumber(templateModel);
        return templateModel;
    }

    @Override
    public <T extends TemplateInfo> void fillDimMemberNumber(ITemplateModel<T> templateModel) {
        if (null == templateModel || null == this.getTemplateMemberService()) {
            return;
        }
        List<IDimension> allDims = this.getTemplateMemberService().getAllDims(templateModel.getBizModelId());
        Map<Long, IDimension> dims = allDims.stream().collect(Collectors.toMap(e -> e.getId(), e -> e));
        templateModel.getViewpointmembentry().stream().filter(e -> null != e.getDimension()).forEach(e -> {
            IDimension dim = (IDimension)dims.get(e.getDimension().getId());
            if (null != dim) {
                e.getDimension().setNumber(dim.getNumber());
                e.getDimension().setMemberModel(dim.getMemberModel());
                e.getDimension().setName(dim.getName());
                this.setDimMember(e.getMember(), e.getDimension().getNumber());
            }
        });
        templateModel.getPagemembentry().stream().filter(e -> null != e.getDimension()).forEach(e -> {
            IDimension dim = (IDimension)dims.get(e.getDimension().getId());
            if (null != dim) {
                e.getDimension().setNumber(dim.getNumber());
                e.getDimension().setMemberModel(dim.getMemberModel());
                e.getDimension().setName(dim.getName());
                e.getMembers().forEach(m -> this.setDimMember((IDimensionMember)m, e.getDimension().getNumber()));
                if (CollectionUtils.isNotEmpty(e.getMembers())) {
                    e.setViewId(e.getMembers().get(0).getViewId());
                    e.setViewNumber(e.getMembers().get(0).getViewNumber());
                }
            }
        });
    }

    protected void setDimMember(IDimensionMember m, String dimNumber) {
        IDimensionMember member;
        if (null != m && StringUtils.isEmpty((String)m.getNumber()) && (member = (IDimensionMember)this.getTemplateMemberService().getMemberEntry(QuoteTypeEnum.getByValule(m.getType()), dimNumber, m.getId(), (Object)m.getViewId())) != null) {
            m.setNumber(member.getNumber());
            m.setParentNum(member.getParentNum());
            m.setViewNumber(member.getViewNumber());
        }
    }

    @Override
    public <T extends TemplateInfo> void fillDimMemberId(ITemplateModel<T> templateModel, ISheetManager sheetManager) {
        if (null == sheetManager || null == templateModel || null == this.getTemplateMemberService()) {
            return;
        }
        List<IDimension> allDims = this.getTemplateMemberService().getAllDims(templateModel.getBizModelId());
        ArrayList allPropertys = this.getTemplateMemberService().getAllPropertys(null, null);
        allPropertys = null != allPropertys ? allPropertys : Lists.newArrayList();
        Map<String, IDimension> dims = allDims.stream().collect(Collectors.toMap(e -> e.getNumber(), e -> e, (k1, k2) -> k1));
        Map<String, PropertyEntry> propertys = allPropertys.stream().collect(Collectors.toMap(e -> e.getNumber(), e -> e, (k1, k2) -> k1));
        List<IDataAreaSetting> areaRanges = sheetManager.getAreaRanges();
        ArrayList rankHeaders = Lists.newArrayList();
        for (IDataAreaSetting areaRange : areaRanges) {
            areaRange.getAreaViewpointmembentry().stream().filter(e -> null != e.getMember()).forEach(e -> {
                IDimension dimension = this.getTemplateMemberService().getDimension(e.getDimension().getNumber());
                e.getDimension().setId(null != dimension ? dimension.getId() : null);
                IBaseEntry member = this.getTemplateMemberService().getMemberEntry(QuoteTypeEnum.MEMBER, e.getDimension().getNumber(), e.getMember().getNumber(), (Object)e.getMember().getViewNumber());
                e.getMember().setId(null != member ? member.getId() : null);
                if (member instanceof IViewInfo) {
                    e.getMember().setViewId(((IViewInfo)member).getViewId());
                }
            });
            rankHeaders.clear();
            rankHeaders.addAll(areaRange.getRowHeaders());
            rankHeaders.addAll(areaRange.getColHeaders());
            rankHeaders.forEach(e -> {
                QuoteTypeEnum typeEnum = QuoteTypeEnum.getByHeaderInfoType(e.getType());
                e.setId(this.getEntryId(typeEnum, e.getNumber(), dims, propertys));
                e.getHeaderObjects().stream().filter(member -> null != member && StringUtils.isNotEmpty((String)member.getNumber())).forEach(m -> {
                    IBaseEntry member = this.getTemplateMemberService().getMemberEntry(QuoteTypeEnum.getByValule(m.getType()), e.getNumber(), m.getNumber(), (Object)m.getViewNumber());
                    if (null != member) {
                        m.getObjects().put("id", member.getId());
                        if (member instanceof IViewInfo) {
                            m.setViewId(((IViewInfo)member).getViewId());
                        }
                    }
                });
            });
            if (null == areaRange.getRelationAreaInfo() || !MapUtils.isNotEmpty(areaRange.getRelationAreaInfo().getMemberScopes())) continue;
            areaRange.getRelationAreaInfo().getMemberScopes().entrySet().forEach(e -> {
                IDimension dim = ((IPageDimensionEntry)e.getValue()).getDimension();
                ((IPageDimensionEntry)e.getValue()).setViewId(this.getTemplateMemberService().getViewId(dim.getNumber(), ((IPageDimensionEntry)e.getValue()).getViewNumber()));
                if (null != dim && StringUtils.isNotEmpty((String)dim.getNumber())) {
                    IDimension dimension = this.getTemplateMemberService().getDimension(dim.getNumber());
                    ((IPageDimensionEntry)e.getValue()).getDimension().setId(null != dimension ? dimension.getId() : null);
                }
                ((IPageDimensionEntry)e.getValue()).getMembers().stream().filter(member -> null != member).forEach(member -> member.setViewId(((IPageDimensionEntry)e.getValue()).getViewId()));
                this.getTemplateMemberService().fillMemberEntry(((IPageDimensionEntry)e.getValue()).getDimension().getNumber(), ((IPageDimensionEntry)e.getValue()).getViewNumber(), ((IPageDimensionEntry)e.getValue()).getMembers());
            });
        }
    }

    protected Long getEntryId(QuoteTypeEnum typeEnum, String number, Map<String, IDimension> dims, Map<String, PropertyEntry> propertys) {
        Long id = null;
        if (typeEnum == QuoteTypeEnum.MEMBER) {
            IDimension dimension = this.getTemplateMemberService().getDimension(number);
            id = null != dimension ? dimension.getId() : null;
        } else if (typeEnum == QuoteTypeEnum.PROPERTY) {
            id = this.getPropertyId(propertys, number);
        }
        return id;
    }

    protected Long getPropertyId(Map<String, PropertyEntry> propertys, String propertyNumber) {
        PropertyEntry d = propertys.get(propertyNumber);
        return null != d ? d.getId() : null;
    }

    @Override
    public <T extends TemplateInfo> void loadViewAndPageDimsByQuote(ITemplateModel<T> templateModel) {
        T template = templateModel.getTemplateBaseInfo();
        templateModel.getViewpointmembentry().clear();
        templateModel.getPagemembentry().clear();
        HashMap pageMap = Maps.newHashMap();
        List<TemplateMemberQuote> quotes = this.getMemberQuoteService().queryTemplateMemberQuoteByTempalte(((TemplateInfo)((Object)template)).getMemberQuoteEntityNumber(), Lists.newArrayList((Object[])new Long[]{template.getId()}), Sets.newHashSet((Object[])new String[]{QuoteUseTypeEnum.VIEW.getValue(), QuoteUseTypeEnum.PAGE.getValue()}));
        quotes = quotes.stream().sorted(Comparator.comparing(s -> s.getSeq())).collect(Collectors.toList());
        for (TemplateMemberQuote quote : quotes) {
            Long dimId = quote.getDimensionId();
            Long memId = quote.getMemberId();
            String type = quote.getType();
            String range = quote.getRange();
            Long viewId = quote.getViewId();
            QuoteUseTypeEnum useTypeEnum = QuoteUseTypeEnum.getByValule(quote.getUseType());
            if (useTypeEnum == QuoteUseTypeEnum.VIEW) {
                DefaultViewPointDimensionEntry ventry = new DefaultViewPointDimensionEntry();
                ventry.setDimension(new DefaultDimension(dimId, null, null, null));
                ventry.setMember((IDimensionMember)new EmrDefaultDimMember(memId, null, null, Integer.parseInt(range)));
                ventry.getMember().setType(type);
                ventry.getMember().setViewId(viewId);
                templateModel.addViewpointmembentry(ventry);
                continue;
            }
            if (useTypeEnum != QuoteUseTypeEnum.PAGE) continue;
            IPageDimensionEntry pentry = (IPageDimensionEntry)pageMap.get(dimId);
            if (null == pentry) {
                pentry = new DefaultPageDimensionEntry();
                templateModel.addPagemembentry(pentry);
                pentry.setDimension(new DefaultDimension(dimId, null, null, null));
                pageMap.put(dimId, pentry);
            }
            if (!IDUtils.isNotNull((Long)memId)) continue;
            EmrDefaultDimMember member = new EmrDefaultDimMember(memId, null, null, Integer.parseInt(range));
            member.setType(type);
            member.setViewId(viewId);
            pentry.addOneMember((IDimensionMember)member);
            pentry.setViewId(viewId);
        }
    }

    @Override
    public <T extends TemplateInfo> List<TemplateMemberQuote> buildMemberQuote(ITemplateModel<T> templateModel, ISheetManager sheetManager) {
        this.fillDimMemberId(templateModel, sheetManager);
        Long modelId = ((TemplateInfo)((Object)templateModel.getTemplateBaseInfo())).getModelId();
        Long templateId = templateModel.getTemplateBaseInfo().getId();
        Long bizModelId = templateModel.getBizModelId();
        ArrayList list = Lists.newArrayList();
        AtomicInteger inc = new AtomicInteger(0);
        if (IDUtils.isNotNull((Long)bizModelId)) {
            TemplateMemberQuote quote = new TemplateMemberQuote(modelId, templateId, bizModelId, null, null, QuoteTypeEnum.BIZMODEL.getValue(), QuoteUseTypeEnum.BIZMODEL.getValue(), RangeEnum.ONLY.getIndStr(), 0L, 0);
            list.add(quote);
        }
        templateModel.getViewpointmembentry().forEach(e -> list.add(this.buildMemberQuoteItem(QuoteUseTypeEnum.VIEW, modelId, templateId, bizModelId, e.getDimension(), e.getMember(), inc)));
        templateModel.getPagemembentry().forEach(e -> {
            if (CollectionUtils.isNotEmpty(e.getMembers())) {
                e.getMembers().forEach(member -> list.add(this.buildMemberQuoteItem(QuoteUseTypeEnum.PAGE, modelId, templateId, bizModelId, e.getDimension(), (IDimensionMember)member, inc)));
            } else {
                list.add(this.buildMemberQuoteItem(QuoteUseTypeEnum.PAGE, modelId, templateId, bizModelId, e.getDimension(), null, inc));
            }
        });
        HashSet uniqueSet = Sets.newHashSet();
        List<IDataAreaSetting> areaRanges = sheetManager.getAreaRanges();
        areaRanges.forEach(area -> {
            area.getAreaViewpointmembentry().stream().filter(e -> null != e.getMember()).forEach(e -> {
                TemplateMemberQuote quote = this.buildMemberQuoteItem(QuoteUseTypeEnum.AREAVIEW, modelId, templateId, bizModelId, e.getDimension(), e.getMember(), null);
                if (uniqueSet.add(this.getUniqueKey(quote))) {
                    list.add(quote);
                }
            });
            area.getRowHeaders().forEach(e -> e.getHeaderObjects().stream().filter(member -> null != member && StringUtils.isNotEmpty((String)member.getNumber())).forEach(member -> {
                TemplateMemberQuote quote = this.buildMemberQuoteItem(QuoteUseTypeEnum.ROW, modelId, templateId, bizModelId, (IHeaderInfo)e, (IHeaderObject)member, null);
                if (uniqueSet.add(this.getUniqueKey(quote))) {
                    list.add(quote);
                }
            }));
            area.getColHeaders().forEach(e -> e.getHeaderObjects().stream().filter(member -> null != member && StringUtils.isNotEmpty((String)member.getNumber())).forEach(member -> {
                TemplateMemberQuote quote = this.buildMemberQuoteItem(QuoteUseTypeEnum.COL, modelId, templateId, bizModelId, (IHeaderInfo)e, (IHeaderObject)member, null);
                if (uniqueSet.add(this.getUniqueKey(quote))) {
                    list.add(quote);
                }
            }));
            if (null != area.getRelationAreaInfo()) {
                RelationModelBean relationModelBean = this.getTemplateMemberService().getRelationModel(this.getTemplateMemberService().getBizModelId(area.getRelationAreaInfo().getRelationModel()));
                area.getRelationAreaInfo().getCols().forEach(e -> {
                    TemplateMemberQuote quote;
                    FieldBean fieldBean = (FieldBean)relationModelBean.getFieldBeanMap().get(e);
                    if (null != fieldBean && uniqueSet.add(this.getUniqueKey(quote = this.buildMemberQuoteItem(QuoteUseTypeEnum.COL, modelId, templateId, relationModelBean.getId(), fieldBean.getId(), null)))) {
                        list.add(quote);
                    }
                });
                if (MapUtils.isNotEmpty(area.getRelationAreaInfo().getMemberScopes())) {
                    area.getRelationAreaInfo().getMemberScopes().entrySet().forEach(e -> ((IPageDimensionEntry)e.getValue()).getMembers().stream().filter(member -> null != member && StringUtils.isNotEmpty((String)member.getNumber())).forEach(member -> {
                        TemplateMemberQuote quote = this.buildMemberQuoteItem(QuoteUseTypeEnum.COL, modelId, templateId, (Long)relationModelBean.getId(), ((IPageDimensionEntry)e.getValue()).getDimension(), (IDimensionMember)member, null);
                        if (uniqueSet.add(this.getUniqueKey(quote))) {
                            list.add(quote);
                        }
                    }));
                }
            }
        });
        return list;
    }

    protected TemplateMemberQuote buildMemberQuoteItem(QuoteUseTypeEnum useType, Long modelId, Long templateId, Long bizModelId, IDimension dim, IDimensionMember dimMember, AtomicInteger inc) {
        Long memberId = null != dimMember ? dimMember.getId() : null;
        Long viewId = null != dimMember ? dimMember.getViewId() : null;
        String type = null != dimMember ? dimMember.getType() : QuoteTypeEnum.MEMBER.getValue();
        type = null != type ? type : QuoteTypeEnum.MEMBER.getValue();
        String range = null != dimMember ? String.valueOf(dimMember.getScope()) : RangeEnum.ONLY.getIndStr();
        int seq = null != inc ? inc.getAndIncrement() : 0;
        TemplateMemberQuote quote = new TemplateMemberQuote(modelId, templateId, IDUtils.toLong((Object)bizModelId), dim.getId(), IDUtils.toLong((Object)memberId), type, useType.getValue(), range, IDUtils.toLong((Object)viewId), seq);
        return quote;
    }

    protected TemplateMemberQuote buildMemberQuoteItem(QuoteUseTypeEnum useType, Long modelId, Long templateId, Long bizModelId, IHeaderInfo dim, IHeaderObject dimMember, AtomicInteger inc) {
        Long memberId = (Long)dimMember.getObjects().remove("id");
        Long viewId = dimMember.getViewId();
        QuoteTypeEnum typeEnum = QuoteTypeEnum.getByValule(dimMember.getType());
        String type = null != typeEnum ? typeEnum.getValue() : "";
        String range = RangeEnum.ONLY.getIndStr();
        int seq = null != inc ? inc.getAndIncrement() : 0;
        TemplateMemberQuote quote = new TemplateMemberQuote(modelId, templateId, IDUtils.toLong((Object)bizModelId), dim.getId(), IDUtils.toLong((Object)memberId), type, useType.getValue(), range, IDUtils.toLong((Object)viewId), seq);
        return quote;
    }

    protected TemplateMemberQuote buildMemberQuoteItem(QuoteUseTypeEnum useType, Long modelId, Long templateId, Long relaModelId, Long fieldId, AtomicInteger inc) {
        Long viewId = 0L;
        String type = QuoteTypeEnum.FIELD.getValue();
        String range = RangeEnum.ONLY.getIndStr();
        int seq = null != inc ? inc.getAndIncrement() : 0;
        TemplateMemberQuote quote = new TemplateMemberQuote(modelId, templateId, relaModelId, 0L, fieldId, type, useType.getValue(), range, IDUtils.toLong((Object)viewId), seq);
        return quote;
    }

    protected String getUniqueKey(TemplateMemberQuote quote) {
        return Joiner.on((String)"_").join((Object)quote.getDimensionId(), (Object)IDUtils.toLong((Object)quote.getMemberId()), new Object[]{quote.getRange(), quote.getViewId(), quote.getType(), quote.getUseType()});
    }

    @Override
    public Map<Long, Tuple<String, String>> getTemplateNumberName(String entityNumber, Collection<Long> templateIds) {
        ArrayList selects = Lists.newArrayList((Object[])new String[]{"number", "name"});
        DynamicObjectCollection list = this.queryTemplateDyns(entityNumber, templateIds, selects);
        return list.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> Tuple.create((Object)e.getString("number"), (Object)e.getString("name")), (k1, k2) -> k1));
    }

    @Override
    public DynamicObjectCollection queryTemplateDyns(String entityNumber, Collection<Long> templateIds, List<String> selects) {
        QFilter filter = new QFilter("id", "in", templateIds);
        selects.add("id");
        String selectFields = String.join((CharSequence)",", selects);
        return QueryServiceHelper.query((String)entityNumber, (String)selectFields, (QFilter[])new QFilter[]{filter});
    }

    @Override
    public Map<Long, List<TemplateSheet>> getTemplateSheet(String entityNumber, Collection<Long> templateIds, List<String> selects) {
        DynamicObject[] templateDyns = BusinessDataServiceHelper.load((String)entityNumber, (String)String.join((CharSequence)",", selects), (QFilter[])new QFilter("id", "in", templateIds).toArray());
        HashMap<Long, List<TemplateSheet>> templateSheets = new HashMap<Long, List<TemplateSheet>>(templateIds.size());
        for (DynamicObject t : templateDyns) {
            templateSheets.put((Long)t.getPkValue(), new TemplateSheet(entityNumber).loadDynaObject(t.getDynamicObjectCollection("sheetentry"), () -> entityNumber));
        }
        return templateSheets;
    }

    @Override
    public void updateViewpoint(String templateEntityNumber, String memberQuoteEntityNumber, Long modelId, Long bizModelId, Map<BaseBean, Tuple<Long, Long>> dimAndMember) {
        if (IDUtils.isNull((Long)modelId) || IDUtils.isNull((Long)bizModelId) || MapUtils.isEmpty(dimAndMember)) {
            return;
        }
        List<TemplateMemberQuote> bizModelQuotes = this.getMemberQuoteService().queryTemplateMemberQuoteByBizModel(memberQuoteEntityNumber, Lists.newArrayList((Object[])new Long[]{bizModelId}), Lists.newArrayList((Object[])new String[]{QuoteTypeEnum.BIZMODEL.getValue()}));
        if (CollectionUtils.isEmpty(bizModelQuotes)) {
            return;
        }
        List<Long> templateIds = bizModelQuotes.stream().map(e -> e.getTemplateId()).collect(Collectors.toList());
        Map<Long, List<TemplateSheet>> templateSheets = this.getTemplateSheet(templateEntityNumber, templateIds, Lists.newArrayList((Object[])new String[]{"sheetentry.sheetparams"}));
        List<TemplateMemberQuote> dimQuotes = this.getMemberQuoteService().queryTemplateMemberQuoteByTempalte(memberQuoteEntityNumber, templateIds, Sets.newHashSet((Object[])new String[]{QuoteUseTypeEnum.VIEW.getValue(), QuoteUseTypeEnum.PAGE.getValue()}));
        Map<Long, Set> tplDimMap = dimQuotes.stream().collect(Collectors.groupingBy(e -> e.getTemplateId())).entrySet().stream().collect(Collectors.toMap(e -> (Long)e.getKey(), e -> ((List)e.getValue()).stream().map(i -> i.getDimensionId()).collect(Collectors.toSet())));
        ArrayList newQuoteList = Lists.newArrayList();
        for (Map.Entry<Long, List<TemplateSheet>> entry : templateSheets.entrySet()) {
            Long templateId = entry.getKey();
            TemplateSheet tplSheet = entry.getValue().get(0);
            List rowcol = (List)tplSheet.getParam("rowcolDims");
            Set dimIds = tplDimMap.get(templateId);
            if (null == dimIds) {
                dimIds = Sets.newHashSet();
            }
            int seq = dimIds.size();
            for (Map.Entry<BaseBean, Tuple<Long, Long>> dimmember : dimAndMember.entrySet()) {
                String dimNumber = dimmember.getKey().getNumber();
                Long dimId = dimmember.getKey().getId();
                Long memberId = (Long)dimmember.getValue().item1;
                Long viewId = (Long)dimmember.getValue().item2;
                if (rowcol.contains(dimNumber) || dimIds.contains(dimId)) continue;
                TemplateMemberQuote quote = new TemplateMemberQuote(modelId, templateId, bizModelId, dimId, memberId, QuoteTypeEnum.MEMBER.getValue(), QuoteUseTypeEnum.VIEW.getValue(), RangeEnum.ONLY.getIndStr(), viewId, seq++);
                newQuoteList.add(quote);
            }
        }
        this.getMemberQuoteService().saveTemplateMemberQuote(memberQuoteEntityNumber, newQuoteList);
    }

    @Override
    public List<Long> getTemplateIdsByBusinessDomain(String entityNumber, Long modelId, Collection<Long> businessDomainIds) {
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        filter.and("businessdomain", "in", businessDomainIds);
        return QueryServiceHelper.query((String)entityNumber, (String)"id", (QFilter[])filter.toArray()).stream().map(e -> e.getLong("id")).collect(Collectors.toList());
    }

    @Override
    public List<String> validateMemberQuote(List<TemplateMemberQuote> quotes) {
        LinkedList<String> msg = new LinkedList<String>();
        if (CollectionUtils.isNotEmpty(quotes)) {
            Long modelId = quotes.get(0).getModelId();
            HashSet<Long> bizModelIds = new HashSet<Long>();
            HashMap<Long, Set> bizModelDims = new HashMap<Long, Set>();
            HashMap<Long, Set> viewMems = new HashMap<Long, Set>();
            for (TemplateMemberQuote quote : quotes) {
                if (IDUtils.isNotNull((Long)quote.getBizModelId())) {
                    bizModelIds.add(quote.getBizModelId());
                    if (IDUtils.isNotNull((Long)quote.getDimensionId())) {
                        Set dimIds2 = bizModelDims.putIfAbsent(quote.getBizModelId(), bizModelDims.computeIfAbsent(quote.getBizModelId(), f -> new HashSet()));
                        dimIds2.add(quote.getDimensionId());
                    }
                }
                if (!IDUtils.isNotNull((Long)quote.getViewId()) || !IDUtils.isNotNull((Long)quote.getMemberId())) continue;
                Set memIds2 = viewMems.putIfAbsent(quote.getViewId(), viewMems.computeIfAbsent(quote.getViewId(), f -> new HashSet()));
                memIds2.add(quote.getMemberId());
            }
            if (IDUtils.isNotNull((Long)modelId)) {
                EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
                Map bizModelMap = modelCache.getBizModelMap();
                bizModelIds.forEach(e -> {
                    if (!bizModelMap.containsKey(e)) {
                        msg.add(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b%s\u4e0d\u5b58\u5728\u3002", (String)"TemplateServiceImpl_0", (String)"epm-emr-business", (Object[])new Object[]{e}));
                    }
                });
                bizModelDims.forEach((bizModelId, dimIds) -> {
                    BizModelBean bizModelBean = (BizModelBean)bizModelMap.get(bizModelId);
                    if (bizModelBean != null && BizModelTypeEnum.MUITL == bizModelBean.getBizModelType()) {
                        Set dims = bizModelBean.getDimensions();
                        for (Long d : dimIds) {
                            if (dims.contains(d)) continue;
                            msg.add(ResManager.loadKDString((String)"\u7ef4\u5ea6%1$s\u5728\u4e1a\u52a1\u6a21\u578b%2$s\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"TemplateServiceImpl_1", (String)"epm-emr-business", (Object[])new Object[]{d, bizModelBean.getNameString()}));
                        }
                    }
                });
                viewMems.forEach((viewId, memIds) -> {
                    ViewBean viewBean = modelCache.getViewById(viewId.longValue());
                    if (viewBean != null) {
                        for (Long m : memIds) {
                            MemberBean mb = EpbsMemberCacheHelper.get((long)modelId, (long)viewBean.getDimensionId()).getMember(m.longValue());
                            if (mb == null) {
                                msg.add(ResManager.loadKDString((String)"\u6210\u5458%s\u4e0d\u5b58\u5728\u3002", (String)"TemplateServiceImpl_2", (String)"epm-emr-business", (Object[])new Object[]{m}));
                                continue;
                            }
                            if (IDUtils.equals((Object)mb.getViewId(), (Object)viewId)) continue;
                            msg.add(ResManager.loadKDString((String)"\u6210\u5458%1$s\u5728\u89c6\u56fe%2$s\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"TemplateServiceImpl_3", (String)"epm-emr-business", (Object[])new Object[]{mb.getNameString(), viewBean.getNameString()}));
                        }
                    } else {
                        msg.add(ResManager.loadKDString((String)"\u89c6\u56fe%s\u4e0d\u5b58\u5728\u3002", (String)"TemplateServiceImpl_4", (String)"epm-emr-business", (Object[])new Object[]{viewId}));
                    }
                });
            }
        }
        return msg;
    }
}

