/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.dataperm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.epm.emr.business.model.f7.EmrMemberF7Parameter;
import kd.epm.emr.common.model.cache.EmrMemberCache;
import kd.epm.emr.common.model.cache.EmrMemberCacheHelper;
import kd.epm.emr.common.model.cache.EmrModelCache;
import kd.epm.emr.common.model.cache.EmrModelCacheHelper;
import kd.epm.emr.formplugin.template.f7.TplTreeF7Context;
import kd.epm.emr.formplugin.template.f7.VersionTplTreeBuilder;
import kd.epm.emr.formplugin.template.helper.TemplateVersionHelper;
import kd.epm.epbs.business.member.f7.NewF7Utils;
import kd.epm.epbs.business.permission.bean.PermMemberBean;
import kd.epm.epbs.business.permission.bean.TabManagerBean;
import kd.epm.epbs.business.permission.data.AuthSetDetailBean;
import kd.epm.epbs.business.permission.util.DataRoleUtils;
import kd.epm.epbs.common.enums.AuthTypeEnum;
import kd.epm.epbs.common.enums.AuthTypeTabEnum;
import kd.epm.epbs.common.enums.ShowTypeEnum;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.PropValueBean;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.model.cache.EpbsPropCacheHelper;
import kd.epm.epbs.common.tree.TreePropEnum;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.formplugin.model.memberf7.bean.EpbsSelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.bean.MultiF7Result;
import kd.epm.epbs.formplugin.permission.data.DataRoleRightAuthPlugin;
import org.apache.commons.lang3.StringUtils;

public class EmrDataPermF7Plugin
extends DataRoleRightAuthPlugin {
    private static final String VIEW_DIM = "view_dim";

    private EmrMemberF7Parameter getMemberF7Parameter(Long modelId, String dimNumber) {
        return new EmrMemberF7Parameter(modelId, dimNumber);
    }

    protected void formatFillDatas(TabManagerBean tab, List<List<PermMemberBean>> list) {
        List details = tab.getAuthSetRowBean().getDetails();
        HashMap<String, Map> map = new HashMap<String, Map>(16);
        long modelId = this.getModelId();
        EmrModelCache emrModelCache = EmrModelCacheHelper.get((long)modelId);
        DimensionBean dim = null;
        EmrMemberCache emrMemberCache = null;
        boolean hasBiz = tab.getAuthType() == AuthTypeEnum.BIZ.getType() || tab.getAuthType() == AuthTypeEnum.ADMIN.getType() && tab.getBizId() == AuthTypeTabEnum.ADMIN_BIZ.getBizId();
        for (int i = 0; i < details.size(); ++i) {
            if (i != 0 || !hasBiz) {
                dim = emrModelCache.getDimension(((AuthSetDetailBean)details.get(i)).getDimNumber());
                if (dim == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ef4\u5ea6\u3010%s\u3011\u4e0d\u5b58\u5728\u3002", (String)"EmrDataPermF7Plugin_2", (String)"epm-emr-formplugin", (Object[])new Object[]{((AuthSetDetailBean)details.get(i)).getDimNumber()}));
                    continue;
                }
                emrMemberCache = EmrMemberCacheHelper.get((long)modelId, (long)dim.getId());
            }
            for (List<PermMemberBean> beans : list) {
                PermMemberBean bean = beans.get(i);
                if (!StringUtils.isNotEmpty((CharSequence)bean.getEntityNumber()) || !StringUtils.isNotEmpty((CharSequence)bean.getDimnumber())) continue;
                if (bean.getEntityNumber().equals("emr_templateentity") || bean.getEntityNumber().equals("emr_templatecatalog")) {
                    map.computeIfAbsent(bean.getEntityNumber(), k -> new HashMap(16)).computeIfAbsent(IDUtils.toLong((Object)bean.getMemberid()), k1 -> new ArrayList(10)).add(bean);
                    continue;
                }
                if (emrMemberCache == null) continue;
                MemberBean member = emrMemberCache.getMember(IDUtils.toLong((Object)bean.getMemberid()).longValue());
                if (member != null) {
                    bean.setName(member.getNameString());
                    long viewId = member.getViewId();
                    ViewBean view = EmrModelCacheHelper.get((long)this.getModelId()).getViewById(viewId);
                    bean.setViewName(view.getNameString());
                    continue;
                }
                PropValueBean prop = EpbsPropCacheHelper.get((long)modelId, (long)dim.getId()).getPropValue(IDUtils.toLong((Object)bean.getMemberid()).longValue());
                if (prop != null) {
                    bean.setName(prop.getNameString());
                }
                bean.setDisableFields(new String[]{"range_dim" + i});
            }
        }
        if (!map.isEmpty()) {
            map.forEach((entityNum, ids) -> {
                if (entityNum.equals("emr_templateentity")) {
                    Collection<DynamicObject> tpls = TemplateVersionHelper.versionControlFilter(entityNum, new QFilter("group", "in", ids.keySet()).toArray());
                    if (CollectionUtils.isNotEmpty(tpls)) {
                        tpls.forEach(dy -> ((List)ids.get(dy.getLong("group"))).forEach(a -> a.setName(dy.getString("name"))));
                    }
                } else {
                    QueryServiceHelper.query((String)entityNum, (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", ids.keySet())}).forEach(dy -> ((List)ids.get(dy.getLong("id"))).forEach(a -> a.setName(dy.getString("name"))));
                }
            });
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        block9: {
            int entryRowCount;
            int rowIndex;
            int colIndex;
            String actionId;
            block10: {
                super.closedCallBack(closedCallBackEvent);
                actionId = closedCallBackEvent.getActionId();
                if (!actionId.startsWith("number_dim") || closedCallBackEvent.getReturnData() == null) break block9;
                colIndex = EmrDataPermF7Plugin.getIndex((String)actionId);
                rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
                entryRowCount = this.getModel().getEntryRowCount("entryentity");
                if (!this.isBizSetColumn(actionId)) break block10;
                AuthSetDetailBean bean = this.getDimNumberMap(colIndex);
                if (!bean.getDimNumber().equals("tplentity")) break block9;
                DynamicObjectCollection dys = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
                int createRowCount = rowIndex + dys.size() - entryRowCount;
                if (createRowCount > 0) {
                    this.getModel().batchCreateNewEntryRow("entryentity", createRowCount);
                }
                for (int i = 0; i < dys.size(); ++i) {
                    int index = i + rowIndex;
                    PermMemberBean permMemberBean = new PermMemberBean();
                    permMemberBean.setName(((DynamicObject)dys.get(i)).getString("name"));
                    permMemberBean.setDimnumber(((DynamicObject)dys.get(i)).getString("number"));
                    permMemberBean.setMemberid(((DynamicObject)dys.get(i)).getString("id"));
                    permMemberBean.setEntityNumber(((DynamicObject)dys.get(i)).getString("extfield"));
                    if ("emr_templateentity".equals(permMemberBean.getEntityNumber())) {
                        DynamicObject dy = QueryServiceHelper.queryOne((String)permMemberBean.getEntityNumber(), (String)"id,name,number,group", (QFilter[])new QFilter("id", "=", (Object)IDUtils.toLong((Object)permMemberBean.getMemberid())).toArray());
                        if (dy == null) {
                            throw new KDException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6570\u636e\uff0c\u53ef\u80fd\u5df2\u7ecf\u5220\u9664\u3002", (String)"EmrDataPermF7Plugin_1", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                        }
                        permMemberBean.setMemberid(dy.getString("group"));
                    }
                    this.fillEntryRowValue(permMemberBean, colIndex, index);
                }
                break block9;
            }
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData instanceof MultiF7Result) {
                MultiF7Result res = (MultiF7Result)returnData;
                List listSelectedRows = ((MultiF7Result)returnData).getSelectedMemberList();
                int createRowCount = rowIndex + listSelectedRows.size() - entryRowCount;
                if (createRowCount > 0) {
                    this.getModel().batchCreateNewEntryRow("entryentity", createRowCount);
                }
                List selectedMemberList = res.getSelectedMemberList();
                AuthSetDetailBean detailBean = this.getDimNumberMap(EmrDataPermF7Plugin.getIndex((String)actionId));
                EmrMemberCache memberCache = EmrMemberCacheHelper.get((long)this.getModelId(), (String)detailBean.getDimNumber());
                EmrModelCache emrModelCache = EmrModelCacheHelper.get((long)this.getModelId());
                for (int i = 0; i < listSelectedRows.size(); ++i) {
                    int index = i + rowIndex;
                    EpbsSelectedMember selectedMember = (EpbsSelectedMember)selectedMemberList.get(i);
                    PermMemberBean permMemberBean = new PermMemberBean();
                    permMemberBean.setName(selectedMember.getName());
                    permMemberBean.setDimnumber(selectedMember.getNumber());
                    permMemberBean.setScope(selectedMember.getScope());
                    permMemberBean.setMemberid(selectedMember.getId() + "");
                    if ("1".equals(selectedMember.getType())) {
                        String dimNumber = detailBean.getDimNumber();
                        MemberBean member = memberCache.getMember(selectedMember.getId().longValue());
                        ViewBean view = emrModelCache.getViewById(member.getViewId());
                        permMemberBean.setViewName(view.getNameString());
                        DimensionBean dimension = emrModelCache.getDimension(dimNumber);
                        long dimTypeId = dimension.getDimTypeId();
                        permMemberBean.setEntityNumber(EmrModelCacheHelper.get((long)this.getModelId()).getDimTypeById(dimTypeId).getMemberTreemodel());
                    } else {
                        permMemberBean.setEntityNumber("emr_propertydefinedvalue");
                        permMemberBean.setDisableFields(new String[]{"range_dim" + EmrDataPermF7Plugin.getIndex((String)actionId)});
                    }
                    this.fillEntryRowValue(permMemberBean, colIndex, index);
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (key.startsWith("number_dim")) {
            long modelId = this.getModelId();
            int index = EmrDataPermF7Plugin.getIndex((String)key);
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            PermMemberBean permMemberBean = DataRoleUtils.transformMemberBean((DynamicObject)this.getModel().getEntryRowEntity("entryentity", rowIndex), (int)index);
            AuthSetDetailBean detailBean = this.getDimNumberMap(index);
            String dimNumber = detailBean.getDimNumber();
            if (this.isBizSetColumn(key)) {
                Collection<DynamicObject> tpldys;
                TplTreeF7Context tplTreeContext = new TplTreeF7Context("emr_templatecatalog");
                tplTreeContext.setTplEntityNumber("emr_templateentity");
                tplTreeContext.setqFilters(new QFilter("model", "=", (Object)this.getModelId()).toArray());
                tplTreeContext.setRootName(ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"EmrDataPermF7Plugin_3", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                tplTreeContext.setOrderby("sequence");
                tplTreeContext.setEntityQfilter(new QFilter("model", "=", (Object)this.getModelId()));
                tplTreeContext.addTreeBooleanProp(true, new TreePropEnum[]{TreePropEnum.TREEVIEW_Multi});
                tplTreeContext.addTreeBooleanProp(false, new TreePropEnum[]{TreePropEnum.DEFAULT_SELECT_ROOT});
                tplTreeContext.setFocusTreeId(permMemberBean.getMemberid());
                if (tplTreeContext.getTplEntityNumber().equals(permMemberBean.getEntityNumber()) && !CollectionUtils.isEmpty(tpldys = TemplateVersionHelper.versionControlFilter(tplTreeContext.getTplEntityNumber(), new QFilter[]{new QFilter("group", "=", (Object)IDUtils.toLong((Object)permMemberBean.getMemberid()))}))) {
                    tpldys.forEach(e -> tplTreeContext.setFocusTreeId(e.getString("id")));
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("emr_template_f8_inh");
                formShowParameter.setCustomParam("contextcache", (Object)ObjectSerialUtil.toByteSerialized((Object)((Object)tplTreeContext)));
                formShowParameter.setCustomParam("treeBuilderClassName", (Object)VersionTplTreeBuilder.class.getName());
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setParentPageId(this.getView().getPageId());
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
                this.getView().showForm(formShowParameter);
                return;
            }
            EmrMemberF7Parameter f7Param = this.getMemberF7Parameter(modelId, dimNumber);
            f7Param.setOrderBy("longnumber");
            f7Param.setShowCustomProperty(true);
            f7Param.setEnableView(true);
            f7Param.setShowType(ShowTypeEnum.NUMNAME.getValue());
            f7Param.setMultiSelect(true);
            if (StringUtils.isNotEmpty((CharSequence)permMemberBean.getMemberid())) {
                try {
                    Long memberId = IDUtils.toLong((Object)permMemberBean.getMemberid());
                    if ("emr_propertydefinedvalue".equals(permMemberBean.getEntityNumber())) {
                        f7Param.setSelectId(memberId);
                    } else {
                        MemberBean member = EmrMemberCacheHelper.get((long)this.getModelId(), (String)dimNumber).getMember(memberId.longValue());
                        f7Param.setViewId(Long.valueOf(member.getViewId()));
                        f7Param.setSelectId(memberId);
                        HashMap<Long, Integer> values = new HashMap<Long, Integer>();
                        values.put(memberId, permMemberBean.getScope());
                        f7Param.setSelectIds(values);
                    }
                }
                catch (Exception e2) {
                    DataRoleUtils.LOG.error((Throwable)e2);
                }
            }
            NewF7Utils.openF8((IFormView)this.getView(), (AbstractMemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, key));
        }
    }
}

