/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.memberf7;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.epm.emr.business.model.f7.EmrMemberF7Parameter;
import kd.epm.epbs.business.member.f7.NewF7Utils;
import kd.epm.epbs.business.model.f7.MemberF7Parameter;
import kd.epm.epbs.common.enums.RangeEnum;
import kd.epm.epbs.common.enums.model.DimTypeEnum;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.QFBuilder;
import kd.epm.epbs.formplugin.member.f7.F7CommonUtils;
import kd.epm.epbs.formplugin.member.f7.SelectedMember;
import kd.epm.epbs.formplugin.member.f7.face.IMemberF7Parameter;
import kd.epm.epbs.formplugin.model.memberf7.face.IEpbsSelectedF7Cache;

public class EmrMemberFloatF7
extends AbstractFormPlugin
implements BeforeF7SelectListener,
IMemberF7Parameter,
IEpbsSelectedF7Cache {
    protected MemberF7Parameter f7Parameter = null;

    public void initialize() {
        super.initialize();
        this.f7Parameter = (MemberF7Parameter)this.loadF7Parameter(this.getView(), this.getPageCache());
        this.addClickListeners(new String[]{"btn_sure"});
        this.addClickListeners(new String[]{"btn_remove", "btn_clearselected"});
        BasedataEdit parent = (BasedataEdit)this.getControl("parent");
        if (parent != null) {
            parent.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        MemberF7Parameter f7Param = this.getF7Parameter();
        if (f7Param != null) {
            boolean isCusDim = this.isCusDim();
            this.getModel().getDataEntity().set("chkfloat", (Object)f7Param.isFloat());
            this.getModel().getDataEntity().set("chkaddnew", (Object)f7Param.isFloatAddNew());
            if (f7Param.isFloatAddNew() && isCusDim) {
                this.getModel().setValue("parent", (Object)f7Param.getFloatParentId());
            }
            this.visibleScope(f7Param.isFloat());
            this.visibleAddNew(f7Param.isFloat() && isCusDim, f7Param.isFloatAddNew());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        switch (e.getProperty().getName()) {
            case "chkfloat": {
                this.propertyChanged_chk_float(e);
                break;
            }
            case "chkaddnew": {
                this.propertyChanged_chk_addNew(e);
            }
        }
    }

    protected void propertyChanged_chk_float(PropertyChangedArgs e) {
        F7CommonUtils.get().clearMemberRange(this.getView(), this.getModel(), this.getPageCache());
        MemberF7Parameter f7Param = this.getF7Parameter();
        f7Param.setSelectIds(new ArrayList());
        this.cacheF7Parameter(this.getPageCache(), (AbstractMemberF7Parameter)f7Param);
        boolean selected = (Boolean)e.getChangeSet()[0].getNewValue();
        if (selected) {
            this.enableFloat();
        } else {
            this.disabledFloat();
        }
    }

    protected void enableFloat() {
        this.visibleScope(true);
        this.visibleAddNew(this.isCusDim(), false);
    }

    protected void disabledFloat() {
        this.getModel().setValue("chkaddnew", (Object)Boolean.FALSE);
        this.getModel().setValue("showscope", (Object)String.valueOf(RangeEnum.ONLY.getIndex()));
        this.getModel().setValue("parent", null);
        this.visibleScope(false);
        this.visibleAddNew(false, false);
    }

    protected void propertyChanged_chk_addNew(PropertyChangedArgs e) {
        boolean selected = (Boolean)e.getChangeSet()[0].getNewValue();
        this.enabledAddNew(selected);
        if (!selected) {
            this.getModel().setValue("parent", null);
        }
    }

    protected void enabledAddNew(boolean isEnable) {
        this.getView().setEnable(Boolean.valueOf(isEnable), new String[]{"parent"});
    }

    protected void visibleAddNew(boolean isShow, boolean isFloatAddNew) {
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"chkaddnew", "parent"});
        this.getView().setEnable(Boolean.valueOf(isShow), new String[]{"chkaddnew"});
        this.getView().setEnable(Boolean.valueOf(isFloatAddNew), new String[]{"parent"});
    }

    protected void visibleScope(boolean isShow) {
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"showscope", "scope"});
        this.getView().setEnable(Boolean.valueOf(isShow), new String[]{"showscope", "scope"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        switch (evt.getProperty().getName()) {
            case "parent": {
                this.beforeF7Select_parent(evt);
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        String clickKey = ((Control)evt.getSource()).getKey();
        if ("btn_sure".equals(clickKey)) {
            Boolean isFloatAddNew = (Boolean)this.getModel().getValue("chkaddnew");
            DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
            if (isFloatAddNew.booleanValue() && parent == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b0\u589e\u6210\u5458\u7684\u4e0a\u7ea7\u6210\u5458\u3002", (String)"EmrMemberFloatF7_1", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        } else if ("btn_remove".equals(clickKey)) {
            this.beforeClick_remove(evt);
        }
    }

    public void click(EventObject evt) {
        String clickKey;
        super.click(evt);
        switch (clickKey = ((Control)evt.getSource()).getKey()) {
            case "btn_clearselected": {
                this.click_clearSelected(evt);
            }
        }
    }

    protected void beforeClick_remove(BeforeClickEvent evt) {
        EntryGrid entryGrid;
        int[] rows;
        DynamicObject parent = (DynamicObject)this.getModel().getValue("parent");
        if (parent != null && (rows = (entryGrid = (EntryGrid)this.getControl("entryentity")).getSelectRows()) != null && rows.length > 0) {
            for (int rowIndex : rows) {
                DynamicObject member = this.getModel().getEntryRowEntity("entryentity", rowIndex);
                if (member == null || parent.getLong("id") != member.getLong("memberid")) continue;
                this.getModel().setValue("parent", null);
                break;
            }
        }
    }

    protected void click_clearSelected(EventObject evt) {
        this.getModel().setValue("parent", null);
    }

    protected void beforeF7Select_parent(BeforeF7SelectEvent evt) {
        MemberF7Parameter f7Param = this.getF7Parameter();
        String noneMember = EpbsModelCacheHelper.get((long)f7Param.getModelId()).getDimensionById(f7Param.getDimensionId().longValue()).getNoneMemberNumber();
        LinkedHashMap selected = this.getSelectedIdsFromCache(this.getPageCache());
        HashSet<String> memberNums = new HashSet<String>(selected.size());
        for (SelectedMember select : selected.values()) {
            if (!"1".equals(select.getType())) continue;
            memberNums.add(select.getNumber());
        }
        memberNums.remove(noneMember);
        if (memberNums.isEmpty()) {
            evt.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u7ef4\u5ea6\u6210\u5458\uff08\u4e0d\u5305\u542b\u4e0d\u533a\u5206\u6210\u5458\uff09\u3002", (String)"EmrMemberFloatF7_2", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return;
        }
        MemberF7Parameter parentF7Param = this.getMemberF7Parameter(f7Param.getModelId(), f7Param.getDimensionId());
        parentF7Param.setEnableView(false);
        parentF7Param.setMultiSelect(false);
        parentF7Param.setViewId(f7Param.getViewId());
        parentF7Param.setReturnClassName(ListSelectedRow.class.getName());
        QFBuilder builder = new QFBuilder();
        builder.add("number", "in", memberNums);
        builder.add("number", "!=", (Object)noneMember);
        parentF7Param.addCustomCommFilter(builder.toFilter());
        NewF7Utils.openF7((BeforeF7SelectEvent)evt, (AbstractMemberF7Parameter)parentF7Param);
    }

    protected boolean isCusDim() {
        DimTypeBean dimTypeBean = EpbsModelCacheHelper.get((long)this.getF7Parameter().getModelId()).getDimTypeByDimensionId(this.getF7Parameter().getDimensionId().longValue());
        return DimTypeEnum.Custom.getValue().equals(dimTypeBean.getType());
    }

    public MemberF7Parameter getF7Parameter() {
        String version;
        if (this.f7Parameter != null && (version = this.getF7ParamVersion(this.getPageCache())) != null && Long.valueOf(version).compareTo(this.f7Parameter.getVersion()) != 0) {
            this.f7Parameter = null;
        }
        if (this.f7Parameter == null) {
            this.f7Parameter = (EmrMemberF7Parameter)this.getF7FromCache(this.getPageCache());
            if (this.f7Parameter == null) {
                this.f7Parameter = new EmrMemberF7Parameter();
            }
            this.f7Parameter.check();
            this.f7Parameter.loadData();
        }
        return this.f7Parameter;
    }

    public MemberF7Parameter getMemberF7Parameter(Long modelId, Long dimensionId) {
        return new EmrMemberF7Parameter(modelId, dimensionId);
    }

    public void destory() {
        super.destory();
    }
}

