/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.model;

import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.epbs.business.model.dimension.DimensionServiceHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.ModelBean;
import kd.epm.epbs.common.cache.model.ModelCacheHelper;
import kd.epm.epbs.common.enums.DefaultDimensionEnum;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.model.bean.DimTypeBean;
import kd.epm.epbs.common.model.cache.DimTypeCache;
import kd.epm.epbs.common.model.cache.DimTypeCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;
import kd.epm.epbs.formplugin.bd.model.ModelEditPlugin;

public class EmrModelEditPlugin
extends ModelEditPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean issuccess = e.getOperationResult().getValidateResult().isSuccess();
        if (e.getSource() instanceof Save && issuccess) {
            Long modelId = (Long)this.getModel().getValue("id");
            String cacheType = this.getPageCache().get("type_cache");
            if (!StringUtils.isBlank((CharSequence)cacheType)) {
                this.saveDefaultDim(modelId);
            }
        }
    }

    private void saveDefaultDim(Long modelId) {
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        ModelBean model = modelCache.getModel();
        DimTypeCache dimTypeCache = DimTypeCacheHelper.get();
        for (DefaultDimensionEnum value : DefaultDimensionEnum.values()) {
            DynamicObject dimension = BusinessDataServiceHelper.newDynamicObject((String)this.getMetaDataEntity(this.getView(), "epbs_dimension"));
            dimension.set("name", (Object)value.getName());
            dimension.set("number", (Object)value.getNumber());
            dimension.set("shortnumber", (Object)value.getShortNumber());
            dimension.set("type", (Object)"3");
            dimension.set("issysdimension", (Object)"1");
            dimension.set("model", (Object)modelId);
            DimTypeBean dimType = dimTypeCache.getDimType(model.getSrcAppNum(), value.getType());
            if (dimType == null) continue;
            dimension.set("dtypeid", (Object)dimType.getId());
            DimensionServiceHelper.saveData((DynamicObject)dimension);
            String appNum = ModelCacheHelper.getModel((long)modelId).getSrcAppNum().toLowerCase(Locale.ENGLISH);
            OperationLogUtil.writeLog((String)appNum, (String)this.getMetaDataEntity(this.getView(), "epbs_dimension"), (IOperationTypeInfo)OperationTypeEnum.SAVE, (MultiLangEnumBridge)OperationMsgUtil.getSaveSucTipWithNumber((String)dimension.getString("number")));
        }
    }
}

