/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.report;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Button;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.F7ItemFillBackArgs;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.epm.emr.business.template.CellInfo;
import kd.epm.emr.business.template.FloatCellInfo;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.ITemplateModel;
import kd.epm.emr.business.template.ObjectConvertUtils;
import kd.epm.emr.business.template.ReportContext;
import kd.epm.emr.business.template.SequenceInfo;
import kd.epm.emr.business.template.TemplateInfo;
import kd.epm.emr.business.template.TemplateModelJSONUtil;
import kd.epm.emr.business.template.arearangedim.IRowColDimensionEntry;
import kd.epm.emr.business.template.headerarea.IHeaderObject;
import kd.epm.emr.business.template.pagedim.IPageDimensionEntry;
import kd.epm.emr.business.template.service.ITemplateMemberService;
import kd.epm.emr.business.template.service.ITemplateService;
import kd.epm.emr.business.template.service.impl.TemplateServiceImpl;
import kd.epm.emr.business.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.emr.common.spread.common.variant.Variant;
import kd.epm.emr.common.spread.domain.Domain;
import kd.epm.emr.common.spread.domain.PageDimDomain;
import kd.epm.emr.common.spread.domain.ViewPointDimDomain;
import kd.epm.emr.common.spread.domain.view.FilterView;
import kd.epm.emr.common.spread.domain.view.SpreadSelector;
import kd.epm.emr.common.spread.domain.view.event.EventConstant;
import kd.epm.emr.common.spread.domain.view.event.NotifyEvent;
import kd.epm.emr.common.spread.domain.view.js.SpreadProperties;
import kd.epm.emr.common.spread.model.DimMember;
import kd.epm.emr.common.spread.model.IDimMember;
import kd.epm.emr.common.spread.model.IDimension;
import kd.epm.emr.common.spread.model.StatusBarModel;
import kd.epm.emr.common.spread.sheet.Cell;
import kd.epm.emr.common.spread.sheet.ISheet;
import kd.epm.emr.common.template.EmrDefaultDimMember;
import kd.epm.emr.formplugin.report.IReportConstant;
import kd.epm.emr.formplugin.report.helper.FloatLogicHelper;
import kd.epm.emr.formplugin.report.helper.PlatformBean;
import kd.epm.emr.formplugin.report.helper.SpreadMemberHelper;
import kd.epm.emr.formplugin.report.impl.AutoFloatServiceImpl;
import kd.epm.emr.formplugin.report.impl.MDDataHandlerServiceImpl;
import kd.epm.emr.formplugin.report.impl.ReportDataRefreshServiceImpl;
import kd.epm.emr.formplugin.report.multi.IReportTabModelDataProvider;
import kd.epm.emr.formplugin.report.multi.ReportCacheService;
import kd.epm.emr.formplugin.report.multi.ReportModelTypeEnum;
import kd.epm.emr.formplugin.report.multi.ReportTabInfo;
import kd.epm.emr.formplugin.report.multi.ReportTabManager;
import kd.epm.emr.formplugin.report.multi.ReportTabModel;
import kd.epm.emr.formplugin.spread.AskExcuteInfo;
import kd.epm.emr.formplugin.spread.ISheetModelSupplier;
import kd.epm.emr.formplugin.spread.SpreadBasePlugin;
import kd.epm.emr.formplugin.spread.SpreadClientInvoker;
import kd.epm.emr.formplugin.spread.SpreadEasyInvoker;
import kd.epm.emr.formplugin.template.helper.MarkSpecialCellHelper;
import kd.epm.emr.formplugin.template.helper.TemplateAreaManagerHelper;
import kd.epm.emr.formplugin.template.helper.TemplateVersionHelper;
import kd.epm.epbs.business.member.f7.NewF7Utils;
import kd.epm.epbs.business.model.f7.MemberF7Parameter;
import kd.epm.epbs.business.olap.VerifyResult;
import kd.epm.epbs.business.page.model.Area;
import kd.epm.epbs.business.page.model.BaseEditElement;
import kd.epm.epbs.business.page.model.Element;
import kd.epm.epbs.business.page.model.Page;
import kd.epm.epbs.business.page.model.VectorElement;
import kd.epm.epbs.business.rules.webapi.RuleExecuteServiceHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.cache.EpbsThreadCache;
import kd.epm.epbs.common.enums.DataTypeEnum;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.model.IDimensionMember;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.model.bean.relation.FieldBean;
import kd.epm.epbs.common.model.bean.relation.RelationModelBean;
import kd.epm.epbs.common.model.bean.relation.RelationTypeEnum;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;
import kd.epm.epbs.formplugin.EpbsBaseFunction;
import kd.epm.epbs.formplugin.IPageCacheProxy;
import kd.epm.epbs.formplugin.ISupportPageCacheProxy;
import kd.epm.epbs.formplugin.model.memberf7.bean.MultiF7Result;
import kd.epm.epbs.formplugin.pageinteraction.DynamicPage;
import kd.epm.epbs.formplugin.pageinteraction.MainPage;
import kd.epm.epdm.common.util.LongUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractReportProcessPlugin<T extends TemplateInfo>
extends SpreadBasePlugin
implements BeforeF7SelectListener,
MainPage,
ISheetModelSupplier,
DynamicPage,
EpbsBaseFunction,
ISupportPageCacheProxy,
IReportConstant {
    private ReportCacheService cacheService;
    private ReportTabManager manager;
    private ReportTabModel currTabModel;
    protected ITemplateModel<T> templateModel;
    protected ISheetManager sm;
    private List<kd.epm.emr.business.template.dimension.IDimension> allDims;
    protected static final String ALLDIMS_KEY = "allDims";
    protected AutoFloatServiceImpl floatService;
    protected ReportDataRefreshServiceImpl refreshService;
    protected MDDataHandlerServiceImpl dataHandlerService;
    protected SpreadEasyInvoker easyInvoker;
    protected ITemplateService templateService;
    private IPageCache pageCacheProxy = null;
    private IPageCacheProxy.PageCacheProxy proxy;
    private boolean isCacheSpreadModel = false;

    public SpreadEasyInvoker getEasyInvoker(boolean isCreate) {
        if (this.easyInvoker == null || isCreate) {
            this.easyInvoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
            this.easyInvoker.setBatch(true);
        }
        return this.easyInvoker;
    }

    public AutoFloatServiceImpl getFloatService(boolean isCreate) {
        if (this.floatService == null || isCreate) {
            this.floatService = new AutoFloatServiceImpl(this.getSheetManager(), this.getReportContext(), this);
        }
        return this.floatService;
    }

    public ReportDataRefreshServiceImpl getRefreshService(boolean isCreate) {
        if (this.refreshService == null || isCreate) {
            this.refreshService = new ReportDataRefreshServiceImpl();
        }
        return this.refreshService;
    }

    public MDDataHandlerServiceImpl getDataHandlerService(boolean isCreate) {
        if (this.dataHandlerService == null || isCreate) {
            this.dataHandlerService = new MDDataHandlerServiceImpl(this.getReportContext());
        }
        return this.dataHandlerService;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.cacheService = new ReportCacheService(this.getPageCache(), this.getTabModelDataProvider());
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        Tab reporttab = (Tab)this.getControl("reporttab");
        if (reporttab != null) {
            reporttab.addTabSelectListener(this::reportTabSelected);
        }
        this.initAreaValueOrListener(this.getPage(this.getView()), true);
        this.initSpreadListener();
    }

    public void registSpreadShortcutKey() {
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), this.getSpreadKey(), "reportDataSave", "D", true, true, true);
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), this.getSpreadKey(), "showCellInfo", "F9", true, true, true);
    }

    protected void setSpreadCommonStyle() {
        this.easyInvoker = this.getEasyInvoker(true);
        this.easyInvoker.addContextMenuItem("showCellInfo", ResManager.loadKDString((String)"\u7ef4\u5ea6\u53ca\u5b57\u6bb5\u4fe1\u606f", (String)"AbstractReportProcessPlugin_0", (String)"epm-emr-formplugin", (Object[])new Object[0]), new String[]{"viewport"});
        this.easyInvoker.setWorksheetOptions(SpreadProperties.SetWorkSheetOptions.CLIPBOARDOPTIONS.k(), 1);
        this.easyInvoker.startToInvoke();
    }

    public void showCellInfo() {
        CellInfo cellInfo = new CellInfo(this.getSelectorStartRow(), this.getSelectorStartCol(), this.getSheetManager(), this.getReportContext());
        if (!cellInfo.isMDCell()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u7ef4\u5ea6\u7ec4\u5408\u5355\u5143\u683c\u3002", (String)"AbstractReportProcessPlugin_1", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter formparam = new FormShowParameter();
        formparam.setFormId("epbs_crossdiminfo");
        formparam.setCaption(ResManager.loadKDString((String)"\u7ef4\u5ea6\u53ca\u5b57\u6bb5\u4fe1\u606f", (String)"AbstractReportProcessPlugin_0", (String)"epm-emr-formplugin", (Object[])new Object[0]));
        formparam.setParentPageId(this.getView().getPageId());
        formparam.getOpenStyle().setShowType(ShowType.Modal);
        formparam.setCustomParam("showmessage", (Object)cellInfo.getAllDimMemberMessage());
        this.getView().showForm(formparam);
    }

    protected void addOneMeniItem(SpreadEasyInvoker invoker) {
    }

    protected void initSpreadListener() {
        this.registerBeforeEvent(EventConstant.ActionName.UPDATE_VALUE, this::beforeUpdateCellValue);
        this.registerAfterEvent(EventConstant.ActionName.CELL_SELECT, this::invokeCellSelect);
        this.registerAfterEvent(EventConstant.ActionName.UPDATE_VALUE, this::afterUpdateCellValue);
        this.registerAfterEvent(EventConstant.ActionName.UPDATE_MULVALUE, this::afterMulUpdateCellValue);
    }

    public void afterMulUpdateCellValue(NotifyEvent notifyEvent) {
        if (this.getPageCache().get("update_value_fail") != null) {
            this.getPageCache().remove("update_value_fail");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u591a\u7ef4\u6570\u636e\u533a\u57df\uff0c\u4e0d\u652f\u6301\u586b\u5165\u975e\u6570\u503c\u5185\u5bb9\u3002", (String)"AbstractReportProcessPlugin_2", (String)"epm-emr-formplugin", (Object[])new Object[0]));
        }
    }

    public void beforeUpdateCellValue(NotifyEvent e) {
        CellInfo cellInfo;
        Cell cell = (Cell)e.getSource();
        int r = cell.getRow();
        int c = cell.getCol();
        Variant variant = new Variant(e.getParam());
        if (!variant.isNumeric() && (cellInfo = new CellInfo(r, c, this.getSheetManager(), this.getReportContext())).isMDCell()) {
            e.setCancel(true);
            this.getPageCache().put("update_value_fail", "true");
            this.mergeInvokeUpdateValueCommands(SpreadEasyInvoker.packedUpdateCellMap(r, c, null));
        }
    }

    protected void afterUpdateCellValue(NotifyEvent e) {
        Cell cell = (Cell)e.getSource();
        int r = cell.getRow();
        int c = cell.getCol();
        FloatCellInfo floatCellInfo = this.getSheetManager().getFloatCellInfo(r, c);
        if (floatCellInfo != null && StringUtils.isNotEmpty((CharSequence)floatCellInfo.getDimNum())) {
            MemberF7Parameter f7Parameter;
            String dimNum = floatCellInfo.getDimNum();
            Object val = this.getEffectiveSheet().getCell(r, c).getValue();
            List<Object> members = new ArrayList<IDimMember>(16);
            if (val != null && (f7Parameter = this.getCellF7Parameter(floatCellInfo)) != null) {
                ORM orm = ORM.create();
                int top = 20;
                String memberModel = EpbsThreadCache.getMemberTreeModelByDimNum((long)this.getModelId(), (String)dimNum);
                QFilter qFilter = f7Parameter.listFilter().toFilter();
                QFilter qfNumberName = new QFilter("number", "=", (Object)(val + "")).or(new QFilter("name", "=", (Object)(val + "")));
                DataSet ds = orm.queryDataSet(this.getClass().getName(), memberModel, "id,number,name,parent.number", new QFilter[]{qFilter, qfNumberName}, "id,number,name", top);
                DynamicObjectCollection queryCollection = orm.toPlainDynamicObjectCollection(ds);
                if (CollectionUtils.isNotEmpty((Collection)queryCollection)) {
                    members = FloatLogicHelper.memberIdToDimMembers(this.getModelId(), floatCellInfo.getDimNum(), Collections.singletonList(((DynamicObject)queryCollection.get(0)).getLong("id")));
                } else if (floatCellInfo.isRelation()) {
                    RelationModelBean relationModelBean = this.getFloatService(true).getRelationModel(floatCellInfo.getRelationAreaInfo().getRelationModel());
                    FieldBean fieldBean = (FieldBean)relationModelBean.getFieldBeanMap().get(floatCellInfo.getFieldNum());
                    if (fieldBean == null || fieldBean.isConnect()) {
                        val = null;
                    }
                } else {
                    val = null;
                }
            }
            if (CollectionUtils.isEmpty(members)) {
                members = Collections.singletonList(new DimMember(null, val == null ? null : val.toString(), null, FloatLogicHelper.dimNumToIDimension(this.getModelId(), dimNum)));
            }
            this.getFloatService(true).fillFloatMembers(members, floatCellInfo);
        }
    }

    protected void invokeCellSelect(NotifyEvent e) {
        this.setReportStatusBar(e);
    }

    protected void setReportStatusBar(NotifyEvent e) {
        StatusBarModel statusBarModel = new StatusBarModel();
        CellInfo cellInfo = new CellInfo(this.getSelectorStartRow(), this.getSelectorStartCol(), this.getSheetManager(), this.getReportContext());
        statusBarModel.setCellNameStr(cellInfo.getRCDimMemberMessage(true));
        SpreadClientInvoker.invokeSetDisplayContent(this.getClientViewProxy(), this.getSpreadKey(), statusBarModel);
    }

    protected void reportTabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        this.getPageCache().put("tabkey_selected", tabKey);
        this.switchTab(tabKey);
        this.getReportTabInfoManager().setSelectReportTabInfo(tabKey);
        this.cacherReportTabManager();
        this.loadReport();
    }

    protected void switchTab(String targTabKey) {
        this.cacheCurrentTabModel();
        this.getReportTabInfoManager().setSelectReportTabInfo(targTabKey);
        this.initCurrentTabModel(targTabKey);
        this.resetModel2Null();
        this.cacherReportTabManager();
    }

    private void resetModel2Null() {
        this.templateModel = null;
        this.sm = null;
    }

    protected void initCurrentTabModel(String tabKey) {
        ReportTabInfo tab = this.getReportTabInfoManager().searchTab(tabKey);
        this.currTabModel = this.cacheService.getReportTabModel(tab);
        this.currTabModel.reInitSheetManager();
    }

    protected ReportTabModel getCurrentTabModel() {
        if (this.currTabModel == null) {
            this.currTabModel = this.cacheService.getReportTabModel(this.getCurrentReportTabInfo());
        }
        this.currTabModel.setPageCache(this.getPageCache());
        return this.currTabModel;
    }

    protected void resetCurrTabModel() {
        this.currTabModel = null;
        this.cacheService.release(this.getCurrentReportTabInfo().getTabKey());
    }

    public ReportTabInfo getCurrentReportTabInfo() {
        return this.getReportTabInfoManager().getCurrSelectReportTabInfo();
    }

    protected void cacheCurrentTabModel() {
        if (this.currTabModel == null) {
            return;
        }
        if (this.getCurrentReportTabInfo() != null && this.getSheetManager() != null) {
            this.getCurrentTabModel().setSheetManager(this.getSheetManager());
            this.getCurrentTabModel().setTemplateModel(this.getTemplateModel());
            this.cacheService.cacheReportTabModel(this.getCurrentTabModel());
        }
    }

    protected void loadReport() {
        try {
            this.initReportTabInfo();
            this.contructReportTab();
            this.initPageViewPanel();
            this.setReportSpreadJson();
            this.refreshReport();
            this.setFloatF7Cell();
            MarkSpecialCellHelper.dealSpecialCells(this.getView(), this.getSpreadKey(), this.getSheetManager(), true, false);
        }
        catch (KDBizException ex) {
            throw new KDBizException(ex.getMessage());
        }
        finally {
            this.getView().hideLoading();
        }
    }

    protected void setReportSpreadJson() {
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.getClientViewProxy(), this.getSpreadKey(), this.getCurrentTabModel().getSpreadJson());
        this.setSpreadCommonStyle();
        this.registSpreadShortcutKey();
    }

    protected void refreshReport() {
        if (this.isNotCompletePageDimMember() || this.getReportContext() == null) {
            return;
        }
        this.getFloatService(true).autoFloat();
        this.getRefreshService(true).reflesh(this.getSheetManager(), null, this.getReportContext());
        this.easyInvoker = this.getEasyInvoker(true);
        this.getSheetManager().getSheet().iteratorCells(cell -> {
            if (cell.isChangeVal()) {
                this.easyInvoker.updataValue(cell.getRow(), cell.getCol(), cell.getValue());
                cell.setChangeVal(false);
            }
        });
        this.easyInvoker.startToInvoke();
        this.getFloatService(true).clearNoDataRowOrColsForFloat();
        this.cacheSheetManager();
    }

    public boolean isNotCompletePageDimMember() {
        return this.getSheetManager().getFilterView().getPageDomain().getDimensions().stream().anyMatch(d -> CollectionUtils.isEmpty((Collection)d.getMembers()));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        String dimNum = this.getDimNumBySign(name);
        if (dimNum != null) {
            DynamicObject memberDyo = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (memberDyo == null) {
                memberDyo = (DynamicObject)e.getChangeSet()[0].getOldValue();
                this.getModel().setValue(e.getProperty().getName(), memberDyo.get("id"));
            } else {
                this.rebuildReport();
            }
            this.setDynaFilter2SpreadFilter(memberDyo, memberDyo.getLong("view.id"));
            this.cacheSheetManager();
            this.refreshReport();
            this.setFloatF7Cell();
            MarkSpecialCellHelper.dealSpecialCells(this.getView(), this.getSpreadKey(), this.getSheetManager(), true, false);
        }
    }

    protected void rebuildReport() {
        this.sm = null;
        this.getCurrentTabModel().reInitSheetManager();
        this.getPageCache().remove(this.getCurrentTabModel().getCacheKey() + "_spreadserial");
        this.setReportSpreadJson();
    }

    public void setDynaFilter2SpreadFilter(DynamicObject member, long viewId) {
        IDimension dim = ObjectConvertUtils.toIDimension((DynamicObject)member.getDynamicObject("dimension"));
        IDimMember m = ObjectConvertUtils.toDimMember((DynamicObject)member, (IDimension)dim);
        ViewBean viewBean = EpbsThreadCache.findViewBeanById((long)this.getModelId(), (long)viewId);
        if (viewBean != null) {
            m.setViewNumber(viewBean.getNumber());
            m.setViewId(Long.valueOf(viewId));
        }
        dim.addMember(m);
        if (this.getSheetManager().getFilterView().getPageDomain().containsDimension(dim)) {
            this.getSheetManager().getFilterView().changePageDim(dim);
        } else if (this.getSheetManager().getFilterView().getFilterDomain().containsDimension(dim)) {
            this.getSheetManager().getFilterView().changeFilterDim(dim);
        }
    }

    protected void setFloatF7Cell() {
        new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey()).invokeF7OrLockCell(this.getSheetManager(), true);
    }

    public void spreadF7Click(LinkedHashMap<String, Object> params) {
        if (params != null) {
            Integer row = (Integer)params.get("r");
            Integer col = (Integer)params.get("c");
            this.cacheSpreadF7Selector(row, col);
            MemberF7Parameter f7Param = this.getCellF7Parameter(row, col);
            if (f7Param != null) {
                NewF7Utils.openF7((IFormView)this.getView(), (AbstractMemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "cellF7"));
            }
        }
    }

    private MemberF7Parameter getCellF7Parameter(FloatCellInfo floatCellInfo) {
        MemberF7Parameter f7Param = null;
        if (floatCellInfo != null) {
            IRowColDimensionEntry pe;
            String dimNum = floatCellInfo.getDimNum();
            String fieldNum = null;
            String relationModel = null;
            if (floatCellInfo.isRelation()) {
                fieldNum = floatCellInfo.getFieldNum();
                relationModel = floatCellInfo.getRelationAreaInfo().getRelationModel();
                pe = (IPageDimensionEntry)floatCellInfo.getRelationAreaInfo().getMemberScopes().get(floatCellInfo.getFieldNum());
            } else {
                pe = floatCellInfo.getRowColDimEntry();
            }
            if (StringUtils.isNotEmpty((CharSequence)dimNum)) {
                MemberBean mb;
                f7Param = this.getTemplateMemberService().getMemberF7Parameter(dimNum);
                f7Param.setEnableView(true);
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
                List<Long> viewIds = new ArrayList<Long>(16);
                if (pe != null && CollectionUtils.isNotEmpty((Collection)pe.getMembers())) {
                    qFilters.add(this.addMemberRangeFilter((IPageDimensionEntry)pe));
                    viewIds = SpreadMemberHelper.getViewIdsFromMemberScope(this.getModelId(), dimNum, pe.getMembers());
                }
                if (floatCellInfo.isRelation()) {
                    this.addRelationDimFilter(relationModel, fieldNum, qFilters, viewIds);
                } else if (CollectionUtils.isEmpty(viewIds)) {
                    viewIds = SpreadMemberHelper.getViewIdsByDimNum(dimNum, this.getModelId(), this.getBizModelId());
                }
                IHeaderObject ho = floatCellInfo.getHeaderObject();
                if (ho != null && StringUtils.isNotEmpty((CharSequence)ho.getViewNumber()) && (mb = EpbsThreadCache.findMemberBeanByNum((long)this.getModelId(), (String)dimNum, (String)ho.getViewNumber(), (String)ho.getNumber())) != null) {
                    f7Param.setSelectId(Long.valueOf(mb.getId()));
                    f7Param.setViewId(Long.valueOf(mb.getViewId()));
                }
                SpreadMemberHelper.addViewQFilterForF7Param(f7Param, qFilters, viewIds, true);
                f7Param.setCutTree(false);
            }
        }
        return f7Param;
    }

    protected MemberF7Parameter getCellF7Parameter(Integer row, Integer col) {
        return this.getCellF7Parameter(this.getSheetManager().getFloatCellInfo(row.intValue(), col.intValue()));
    }

    public void addRelationDimFilter(String relationModel, String fieldNum, List<QFilter> qFilters, List<Long> viewIds) {
        RelationModelBean relationModelBean = this.getTemplateMemberService().getRelationModel(relationModel);
        FieldBean fieldBean = (FieldBean)relationModelBean.getFieldBeanMap().get(fieldNum);
        if (fieldBean != null) {
            List<Object> ids = new ArrayList(16);
            if (RelationTypeEnum.DIMLIB == fieldBean.getTypeEnum() && CollectionUtils.isNotEmpty((Collection)fieldBean.getMemberScopes())) {
                qFilters.add(SpreadMemberHelper.getMemberRangeFilter(this.getModelId(), fieldBean.getDimension().getNumber(), fieldBean.getMemberScopes()));
                ids = SpreadMemberHelper.getViewIdsFromMemberScope(this.getModelId(), fieldBean.getDimension().getNumber(), fieldBean.getMemberScopes());
            } else if (RelationTypeEnum.MODEL == fieldBean.getTypeEnum() && CollectionUtils.isNotEmpty((Collection)fieldBean.getDimension().getViewIds())) {
                ids = fieldBean.getDimension().getViewIds();
            }
            if (CollectionUtils.isEmpty(viewIds) && CollectionUtils.isNotEmpty(ids)) {
                viewIds.addAll(ids);
            }
        }
    }

    public QFilter addMemberRangeFilter(IPageDimensionEntry pageEntry) {
        return SpreadMemberHelper.getPageDimFilter(pageEntry, this.getModelId());
    }

    public void spreadF7LookUpData(LookUpDataArgs args) {
        int row = args.getR();
        int col = args.getC();
        this.cacheSpreadF7Selector(row, col);
        MemberF7Parameter f7Parameter = this.getCellF7Parameter(row, col);
        if (f7Parameter != null) {
            String dimNum = f7Parameter.getDimensionNumber();
            String entityName = EpbsThreadCache.getMemberTreeModelByDimNum((long)this.getModelId(), (String)dimNum);
            SpreadMemberHelper.spreadF7lookUpData(this.getClientViewProxy(), this.getSpreadKey(), args, entityName, f7Parameter.listFilter().toFilter());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "cellF7": {
                this.cellF7CallBack(closedCallBackEvent);
            }
        }
    }

    @Override
    public ISheetManager getSheetManager() {
        if (this.sm == null) {
            this.sm = this.getCurrentTabModel().getSheetManager();
            this.initSpreadFilter(this.sm);
        }
        return this.sm;
    }

    public void cacheSheetManager() {
        this.cacheSheetManager(this.getSheetManager());
    }

    @Override
    public void cacheSheetManager(ISheetManager sheetManager) {
        this.isCacheSpreadModel = true;
        this.getCurrentTabModel().setSheetManager(sheetManager);
    }

    protected String getCommonFilterDimensionInfo() {
        return (String)this.getFormCustomParam("FilterDimensinInfo");
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit bs = (BasedataEdit)e.getSource();
        String methodName = PlatformBean.getOpMethod();
        if ("spreadf7".equals(bs.getKey())) {
            e.getFormShowParameter().setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cellF7"));
        } else if ("getLookupList".equalsIgnoreCase(methodName)) {
            this.fillListShowParameter((ListShowParameter)e.getFormShowParameter(), bs);
        } else if ("click".equals(methodName) || "showMore".equals(methodName)) {
            this.openSingleF7Form(bs);
            e.setCancel(true);
        }
    }

    public void fillListShowParameter(ListShowParameter showParameter, BasedataEdit basedataEdit) {
        MemberF7Parameter f7Parameter = this.getPageDimF7ParamBySign(basedataEdit.getKey());
        showParameter.getListFilterParameter().setFilter(f7Parameter.listFilter().toFilter());
    }

    protected IPageDimensionEntry getPageDimensionByDimNum(String dimNum) {
        for (IPageDimensionEntry pageEntry : this.getTemplateModel().getPagemembentry()) {
            if (!pageEntry.getDimension().getNumber().equals(dimNum)) continue;
            return pageEntry;
        }
        return null;
    }

    public void openSingleF7Form(BasedataEdit basedataEdit) {
        String sign = basedataEdit.getKey();
        String dimNum = this.getDimNumBySign(sign);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, sign);
        this.getTemplateMemberService().openSingleF7(this.getDimByNumber(dimNum), this.getPageDimF7ParamBySign(sign), closeCallBack, this.getView());
    }

    protected void cellF7CallBack(ClosedCallBackEvent evt) {
        if (evt.getReturnData() instanceof MultiF7Result) {
            List<IDimMember> dimMembers;
            FloatCellInfo floatCellInfo;
            MultiF7Result result = (MultiF7Result)evt.getReturnData();
            SpreadSelector selector = this.getSpreadF7Selector();
            if (selector != null && CollectionUtils.isNotEmpty((Collection)result.getSelectedMemberList()) && (floatCellInfo = this.getSheetManager().getFloatCellInfo(selector.getStartRow(), selector.getStartCol())) != null && CollectionUtils.isNotEmpty(dimMembers = FloatLogicHelper.selectMemberToDimMembers(this.getModelId(), result, floatCellInfo))) {
                this.getFloatService(true).fillFloatMembers(dimMembers, floatCellInfo);
                this.cacheSheetManager();
            }
        }
    }

    public void setSpreadF7Item(F7ItemFillBackArgs arg) {
        List<IDimMember> members;
        int r = arg.getR();
        int c = arg.getC();
        FloatCellInfo floatCellInfo = this.getSheetManager().getFloatCellInfo(r, c);
        if (floatCellInfo != null && floatCellInfo.getDimNum() != null && CollectionUtils.isNotEmpty(members = FloatLogicHelper.memberIdToDimMembers(this.getModelId(), floatCellInfo.getDimNum(), Collections.singletonList(arg.getId())))) {
            this.getFloatService(true).fillFloatMembers(members, floatCellInfo);
            this.cacheSheetManager();
        }
    }

    public void initSpreadFilter(ISheetManager sm) {
        if (sm.getFilterView() == null) {
            ViewPointDimDomain view = new ViewPointDimDomain();
            PageDimDomain page = new PageDimDomain();
            IDimension dim = null;
            IDimMember member = null;
            String filterDimensinInfo = this.getCommonFilterDimensionInfo();
            JSONObject dims = new JSONObject();
            if (StringUtils.isNotEmpty((CharSequence)filterDimensinInfo)) {
                dims = JSONObject.parseObject((String)filterDimensinInfo);
            }
            for (IViewPointDimensionEntry v : this.getTemplateModel().getViewpointmembentry()) {
                dim = ObjectConvertUtils.toIDimension((kd.epm.emr.business.template.dimension.IDimension)v.getDimension());
                member = ObjectConvertUtils.toDimMember((IDimensionMember)v.getMember(), (IDimension)dim);
                member.setId(v.getMember().getId().longValue());
                member.setViewId(v.getMember().getViewId());
                dim.addMember(member);
                view.addDimension(dim);
            }
            for (IViewPointDimensionEntry v : this.getTemplateModel().getPagemembentry()) {
                dim = ObjectConvertUtils.toIDimension((kd.epm.emr.business.template.dimension.IDimension)v.getDimension());
                String entityNumber = v.getDimension().getMemberModel();
                if (dims.containsKey((Object)entityNumber)) {
                    JSONObject item = (JSONObject)dims.get((Object)entityNumber);
                    EmrDefaultDimMember emrDefaultDimMember = new EmrDefaultDimMember();
                    emrDefaultDimMember.setName(item.getString("name"));
                    emrDefaultDimMember.setNumber(item.getString("number"));
                    member = ObjectConvertUtils.toDimMember((IDimensionMember)emrDefaultDimMember, (IDimension)dim);
                } else {
                    member = this.loadPageMemberByTemplate(dim, (IPageDimensionEntry)v);
                }
                if (member != null) {
                    dim.addMember(member);
                }
                page.addDimension(dim);
            }
            sm.setFilterView(new FilterView(view, page, null));
            this.cacheSheetManager();
        }
    }

    public IDimMember loadPageMemberByTemplate(IDimension dim, IPageDimensionEntry entry) {
        IDimMember member = null;
        if (CollectionUtils.isNotEmpty((Collection)entry.getMembers())) {
            MemberBean memberBean;
            IDimensionMember m = (IDimensionMember)entry.getMembers().get(0);
            AtomicLong memberId = new AtomicLong(0L);
            SpreadMemberHelper.getMemberRangeItem(dim.getNumber(), m, this.getModelId()).matchItems(c -> {
                if (memberId.get() != 0L) {
                    return;
                }
                memberId.set(c.getId());
            });
            if (memberId.get() != 0L && (memberBean = EpbsThreadCache.findMemberBeanById((long)this.getModelId(), (String)dim.getNumber(), (long)memberId.get())) != null) {
                member = ObjectConvertUtils.memBeanToDimMember((MemberBean)memberBean, (IDimension)dim, (String)m.getViewNumber());
                member.setId(memberBean.getId());
            }
            if (member == null) {
                member = ObjectConvertUtils.toDimMember((IDimensionMember)m, (IDimension)dim);
                member.setId(m.getId().longValue());
                member.setViewNumber(m.getViewNumber());
            }
        }
        return member;
    }

    public void initPageViewPanel() {
        Page page = new Page();
        Area commArea = new Area("fieldsetpanelap");
        this.addVectorAp(commArea, "show_more", "kdfont kdfont-shouqi7");
        this.addVectorAp(commArea, "show_less", "kdfont kdfont-zhankai4");
        Area moreArea = new Area("morefieldsetpanel");
        List<String> dims = this.getDimsForFlexPanelAp();
        this.addDimF7Display(commArea, moreArea, false, (Domain)this.getSheetManager().getFilterView().getPageDomain(), dims);
        this.addDimF7Display(commArea, moreArea, true, (Domain)this.getSheetManager().getFilterView().getViewPointDomain(), dims);
        this.addDimF7Display(commArea, moreArea, false, (Domain)this.getSheetManager().getFilterView().getFilterDomain(), dims);
        this.addVectorAp(commArea, "refresh_currentpage", "kdfont kdfont-shuaxin4");
        page.addArea(commArea);
        page.addArea(moreArea);
        this.setPage(this.getView(), page);
        page.updatePage(this.getView());
        this.initAreaValueOrListener(page, false);
        this.dealFieldPanelapLogic();
    }

    private void dealFieldPanelapLogic() {
        boolean isDisplayMore = this.isTrueFlagInCache("has_display_more");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{isDisplayMore ? "show_more" : "show_less"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{isDisplayMore ? "show_less" : "show_more"});
        this.getView().setVisible(Boolean.valueOf(isDisplayMore), new String[]{"morefieldsetpanel"});
    }

    protected void addVectorAp(Area commArea, String key, String fontClass) {
        VectorElement vectorElement = new VectorElement(key, fontClass);
        vectorElement.setCustomStyle(f -> {
            VectorAp newfilap = (VectorAp)f;
            newfilap.setStyle(this.getVectorStyle());
            newfilap.setForeColor("#0000ff");
            newfilap.setFontSize(12);
        });
        commArea.addElement((Element)vectorElement);
    }

    private Style getVectorStyle() {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("10px");
        margin.setLeft("10px");
        margin.setTop("5px");
        margin.setRight("-10px");
        style.setMargin(margin);
        return style;
    }

    private Style getDefaultStyle() {
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("1px");
        margin.setLeft("20px");
        margin.setTop("1px");
        margin.setBottom("10px");
        style.setMargin(margin);
        return style;
    }

    protected void initAreaValueOrListener(Page page, boolean isListener) {
        if (isListener) {
            this.addClickListeners(new String[]{"show_more", "show_less", "refresh_currentpage"});
        }
        if (!isListener) {
            this.getModel().beginInit();
        }
        AtomicBoolean flag = new AtomicBoolean(false);
        page.getAreaList().forEach(a -> a.getElementListList().forEach(e -> {
            if ("show_more".equals(e.getSign()) || "show_less".equals(e.getSign()) || "refresh_currentpage".equals(e.getSign())) {
                return;
            }
            flag.set(true);
            if (isListener) {
                BasedataEdit basedataEdit = (BasedataEdit)this.getControl(e.getSign());
                basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            } else {
                long id = this.getIdBySing(e.getSign(), "memberid");
                if (id != 0L) {
                    this.setValue(e.getSign(), id);
                }
            }
        }));
        if (!flag.get()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fieldsetpanelap", "morefieldsetpanel"});
            return;
        }
        if (!isListener) {
            this.getModel().endInit();
            this.getView().updateView("fieldsetpanelap");
            this.getView().updateView("morefieldsetpanel");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        switch (itemKey = evt.getItemKey()) {
            case "btn_save": {
                this.syncDataAndSave();
                break;
            }
            case "btn_refresh": {
                this.refreshReport();
                break;
            }
        }
    }

    protected void saveOlapData() {
        if (this.isNotCompletePageDimMember() || this.getReportContext() == null) {
            return;
        }
        VerifyResult verifyResult = this.getDataHandlerService(true).save(this.getSheetManager());
        if (verifyResult != null && !verifyResult.isEmpty()) {
            throw new KDBizException(verifyResult.toString());
        }
        Map ruleResult = RuleExecuteServiceHelper.executeBizRules((long)this.getModelId(), (long)this.getTemplateId());
        if (MapUtils.isNotEmpty((Map)ruleResult)) {
            throw new KDBizException(ruleResult.values().toString());
        }
    }

    public void syncDataAndSave() {
        this.getEasyInvoker(true).invokeCallBack("invokeSaveEvent");
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u5904\u7406\u4e2d...", (String)"AbstractReportProcessPlugin_3", (String)"epm-emr-formplugin", (Object[])new Object[0])));
    }

    protected abstract DataTypeEnum getCellDataType(Map<String, String> var1);

    public ISheet getEffectiveSheet() {
        return this.getSheetManager().getSheet();
    }

    public void invokeSaveEvent() {
        try {
            if (this.validateBeforeActionSave()) {
                this.saveOlapData();
                this.afterSaveReportData();
                this.writeSaveLog();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractReportProcessPlugin_4", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                SpreadMemberHelper.updateCellsNotChange(this.getSheetManager());
                this.setModified(false);
                this.refreshReport();
                this.cacheCurrentTabModel();
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        finally {
            this.endSave();
        }
    }

    protected void afterSaveReportData() {
        this.cacheSheetManager();
    }

    protected boolean validateBeforeActionSave() {
        return true;
    }

    protected void endSave() {
        this.getView().hideLoading();
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Button)evt.getSource()).getKey()) {
            case "show_more": 
            case "show_less": {
                this.cacheTrueOrFalseFlag("has_display_more", "show_more".equals(key));
                this.dealFieldPanelapLogic();
                break;
            }
            case "refresh_currentpage": {
                this.refreshReport();
            }
        }
    }

    protected String getDimNumBySign(String sign) {
        return this.getStringBySign(sign, "dimnum");
    }

    protected String getStringBySign(String sign, String suffix) {
        return this.getPageCache().get(this.getPageCaheKeyBySign(sign, suffix));
    }

    protected long getIdBySing(String sign, String suffix) {
        return LongUtil.toLong((String)this.getPageCache().get(this.getPageCaheKeyBySign(sign, suffix)));
    }

    protected void cacheBySign(String sign, String suffix, Object val) {
        if (val != null && StringUtils.isNotEmpty((CharSequence)val.toString())) {
            this.getPageCache().put(this.getPageCaheKeyBySign(sign, suffix), val.toString());
        } else {
            this.getPageCache().remove(this.getPageCaheKeyBySign(sign, suffix));
        }
    }

    public List<String> getDimsForFlexPanelAp() {
        return new ArrayList<String>();
    }

    protected String sugarF7Key(String memberEntityNumber, String dimNumber) {
        return String.join((CharSequence)"!", memberEntityNumber, dimNumber).toLowerCase(Locale.ENGLISH);
    }

    protected void addDimF7Display(Area commArea, Area moreArea, boolean isLock, Domain domain, List<String> dims) {
        if (domain == null || CollectionUtils.isEmpty((Collection)domain.getDimensions())) {
            return;
        }
        for (IDimension d : domain.getDimensions()) {
            String dimNum = d.getNumber();
            if (StringUtils.isEmpty((CharSequence)dimNum)) {
                return;
            }
            String sign = this.sugarF7Key(d.getUqCode(), dimNum);
            BaseEditElement element = new BaseEditElement(d.getName(), sign, d.getUqCode());
            if (isLock) {
                element.setLock("new,edit,view");
            }
            if (!d.getMembers().isEmpty()) {
                this.cacheBySign(sign, "memberid", ((IDimMember)d.getMembers().get(0)).getId());
                this.cacheBySign(sign, "viewid", ((IDimMember)d.getMembers().get(0)).getViewId());
            }
            this.cacheBySign(sign, "dimnum", dimNum);
            element.setCustomStyle(f -> {
                FieldAp newfilap = (FieldAp)f;
                newfilap.setQuickAddNew(false);
                newfilap.setFireUpdEvt(true);
                newfilap.setFieldTextAlign("center");
                newfilap.setTextAlign("left");
                newfilap.setAlignSelf("center");
                newfilap.setWidth(new LocaleString("200px"));
                newfilap.setLabelWidth(new LocaleString(12 * d.getName().length() + "px"));
                newfilap.setFieldFontSize(12);
                newfilap.setFontSize(12);
                newfilap.setLabelDirection("h");
                newfilap.setHeight(new LocaleString("20px"));
                newfilap.setStyle(this.getDefaultStyle());
            });
            if (dims.contains(dimNum)) {
                commArea.addElement((Element)element);
                continue;
            }
            moreArea.addElement((Element)element);
        }
    }

    protected void initReportTabInfo() {
        ReportTabInfo tabInfo = new ReportTabInfo(this.getTemplateId().toString(), this.getTemplateModel().getTemplateBaseInfo().getNameString(), "reportId", this.getTemplateId());
        tabInfo.setSelected(true);
        this.getReportTabInfoManager().addReportTabInfo(tabInfo);
        this.cacherReportTabManager();
    }

    protected ReportModelTypeEnum getLoadReportModelType() {
        return ReportModelTypeEnum.REPORT;
    }

    protected void cacherReportTabManager() {
        this.cacheService.cacheReportTabInfoManager(this.getReportTabInfoManager());
    }

    private void contructReportTab() {
        TabAp tabap = new TabAp();
        tabap.setKey("reporttab");
        tabap.setName(new LocaleString("reporttab"));
        tabap.setGrow(0);
        ArrayList<String> keys = new ArrayList<String>();
        Iterator<ReportTabInfo> it = this.getReportTabInfoManager().iterator();
        while (it.hasNext()) {
            ReportTabInfo tab = it.next();
            TabPageAp page = new TabPageAp();
            page.setKey(tab.getTabKey());
            page.setName(new LocaleString(tab.getTabName()));
            keys.add(page.getKey());
            tabap.getItems().add(page);
            tab.setSelected(true);
        }
        Map features = tabap.createControl();
        HashMap<String, String> busyTips = new HashMap<String, String>(1);
        busyTips.put("zh_CN", ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u4e2d\uff0c\u8bf7\u7a0d\u540e...", (String)"AbstractReportProcessPlugin_5", (String)"epm-emr-formplugin", (Object[])new Object[0]));
        features.put("busyTip", busyTips);
        this.getView().updateControlMetadata("reporttab", features);
        HashMap<String, Boolean> closeMap = new HashMap<String, Boolean>();
        closeMap.put("closable", true);
        keys.forEach(key -> this.getView().updateControlMetadata(key, closeMap));
    }

    protected ReportTabManager getReportTabInfoManager() {
        if (this.manager != null) {
            return this.manager;
        }
        this.manager = this.cacheService.getReportTabInfoManager();
        if (this.manager == null) {
            this.manager = new ReportTabManager();
        }
        return this.manager;
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadReport();
        ((SplitContainer)this.getControl("showsplitcontainerap")).hidePanel(SplitDirection.down, true);
    }

    public ITemplateModel<T> getTemplateModel() {
        if (this.templateModel == null) {
            String str = this.getPageCache().get("MULTISHEET_TEMPLATE_MODEL");
            if (StringUtils.isNotEmpty((CharSequence)str)) {
                this.templateModel = (ITemplateModel)this.deSerializedBytes(str);
            } else {
                this.templateModel = this.getTemplateService().getTemplateModel(this.getTemplateClass(), this.getTemplateId());
                this.getPageCache().put("templateClass", this.getTemplateClass().getName());
                this.getPageCache().put("templateMemberServiceClass", this.getTemplateMemberService().getClass().getName());
                this.getPageCache().put("KEY_MODEL_ID", this.getModelId() + "");
                this.cacheTemplateModel();
            }
        }
        return this.templateModel;
    }

    public void cacheTemplateModel() {
        if (this.templateModel != null) {
            this.getPageCache().put("MULTISHEET_TEMPLATE_MODEL", this.toByteSerialized(this.templateModel));
        }
    }

    protected Long getTemplateId() {
        return IDUtils.toLong((Object)this.getFormCustomParam("KEY_TEMPLATE_ID"));
    }

    public ITemplateService getTemplateService() {
        if (null == this.templateService) {
            this.templateService = TemplateServiceImpl.getInstance((ITemplateMemberService)this.getTemplateMemberService());
        }
        return this.templateService;
    }

    public Class<T> getTemplateClass() {
        return this.getClazz(0);
    }

    @Override
    public String getSpreadKey() {
        return "report";
    }

    protected abstract IReportTabModelDataProvider getTabModelDataProvider();

    public abstract ITemplateMemberService getTemplateMemberService();

    public Long getBizModelId() {
        return IDUtils.toLong((Object)this.getTemplateModel().getBizModelId());
    }

    protected List<kd.epm.emr.business.template.dimension.IDimension> getAllDims() {
        return this.getTemplateMemberService().getAllDims(this.getBizModelId());
    }

    protected List<kd.epm.emr.business.template.dimension.IDimension> getAllDimsCache() {
        if (CollectionUtils.isEmpty(this.allDims)) {
            String seria = this.getPageCache().get(ALLDIMS_KEY);
            if (StringUtils.isNotEmpty((CharSequence)seria)) {
                this.allDims = (List)ObjectSerialUtil.deSerializedBytes((String)seria);
            } else {
                this.allDims = this.getAllDims();
                this.getPageCache().put(ALLDIMS_KEY, ObjectSerialUtil.toByteSerialized(this.allDims));
            }
        }
        return this.allDims;
    }

    protected kd.epm.emr.business.template.dimension.IDimension getDimByNumber(String dimNumber) {
        List<kd.epm.emr.business.template.dimension.IDimension> allDims = this.getAllDimsCache();
        if (allDims != null) {
            for (kd.epm.emr.business.template.dimension.IDimension d : allDims) {
                if (!d.getNumber().equals(dimNumber)) continue;
                return d;
            }
        }
        return null;
    }

    protected MemberF7Parameter getPageDimF7ParamBySign(String sign) {
        String dimNum = this.getDimNumBySign(sign);
        MemberF7Parameter f7Param = this.getPageDimF7Param(dimNum);
        Object object = this.getValue(sign);
        if (object != null && object instanceof DynamicObject) {
            DynamicObject dyo = (DynamicObject)object;
            f7Param.setSelectId(Long.valueOf(dyo.getLong("id")));
        }
        return f7Param;
    }

    protected MemberF7Parameter getPageDimF7Param(String dimNum) {
        MemberF7Parameter p = this.getTemplateMemberService().getMemberF7Parameter(dimNum);
        IPageDimensionEntry pageDimensionEntry = this.getPageDimensionByDimNum(dimNum);
        List<Long> views = new ArrayList<Long>(16);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        if (pageDimensionEntry != null && CollectionUtils.isNotEmpty((Collection)pageDimensionEntry.getMembers())) {
            qFilters.add(this.addMemberRangeFilter(pageDimensionEntry));
            views = SpreadMemberHelper.getViewIdsFromMemberScope(this.getModelId(), dimNum, pageDimensionEntry.getMembers());
        }
        p.setBizModelId(this.getBizModelId().longValue());
        SpreadMemberHelper.addViewQFilterForF7Param(p, qFilters, views, false);
        return p;
    }

    public IPageCache getPageCache() {
        if (this.isOpenPageCacheProxy()) {
            if (this.pageCacheProxy == null) {
                IPageCacheProxy.PageCacheProxy proxy2 = new IPageCacheProxy.PageCacheProxy(super.getPageCache());
                this.pageCacheProxy = proxy2.getProxy();
                this.proxy = proxy2;
                this.getView().addService(IPageCache.class, (Object)this.pageCacheProxy);
            }
            return this.pageCacheProxy;
        }
        return super.getPageCache();
    }

    public void pushCache() {
        this.forcePushCache();
    }

    protected void forcePushCache() {
        if (this.proxy != null) {
            this.beforeDestroy();
            this.proxy.pushCache();
        }
    }

    protected void beforeDestroy() {
        if (this.isCacheSpreadModel) {
            this.getCurrentTabModel().cache();
        }
        this.isCacheSpreadModel = false;
    }

    public boolean isOpenPageCacheProxy() {
        return true;
    }

    public void destory() {
        if (this.isOpenPageCacheProxy() && this.proxy != null) {
            this.forcePushCache();
            this.getView().addService(IPageCache.class, (Object)this.proxy.getOriginalPageCache());
        }
        super.destory();
    }

    @Override
    public void rowColOperationCheck(NotifyEvent notifyEvent) {
        try {
            TemplateAreaManagerHelper.rowColOperationCheck(notifyEvent, this.getSheetManager(), true, s -> this.getFloatService(false).getRelationModel((String)s));
        }
        catch (Exception e) {
            notifyEvent.setCancel(true);
            this.getView().showTipNotification(e.getMessage());
        }
    }

    @Override
    public void updateRowAndCol(AskExcuteInfo askExcuteInfo) {
        askExcuteInfo.setRev(true);
        super.updateRowAndCol(askExcuteInfo);
    }

    public void markSpecialCells(AskExcuteInfo askExcuteInfo, boolean isMark) {
        FloatLogicHelper.markSpecialCells(this.getSheetManager(), this.getEasyInvoker(true), askExcuteInfo, isMark);
    }

    @Override
    public void adjustMultiAreaSetting(AskExcuteInfo askExcuteInfo) {
        this.markSpecialCells(askExcuteInfo, false);
        TemplateAreaManagerHelper.adjustMultiAreaSetting(new HashSet<SequenceInfo>(), this.getSheetManager(), askExcuteInfo, true);
    }

    @Override
    public void updateRowAndCol2View(IClientViewProxy view, String spreadKey, AskExcuteInfo excuteinfo) {
        super.updateRowAndCol2View(view, spreadKey, excuteinfo);
        this.markSpecialCells(excuteinfo, true);
    }

    public void reportDataSave() {
        String smInfo = TemplateModelJSONUtil.toJsonSheetManager((ISheetManager)this.getSheetManager());
        StringBuilder data = new StringBuilder(smInfo);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("epbs_textmsg");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("msg", (Object)data.toString());
        this.getView().showForm(formShowParameter);
    }

    protected boolean isModified() {
        return this.isTrueFlagInCache("is_modify");
    }

    protected void setModified(boolean isModified) {
        this.cacheTrueOrFalseFlag("is_modify", isModified);
    }

    public ReportContext getReportContext() {
        return new ReportContext(this.getModelId(), this.getBizModelId().longValue());
    }

    protected void writeSaveLog() {
        TemplateInfo template = this.getTemplateModel().getTemplateBaseInfo();
        String version = TemplateVersionHelper.formatVersionNumber(template.getVersionNumber());
        OperationTypeEnum op = OperationTypeEnum.SAVE;
        this.writeLog((IOperationTypeInfo)op, OperationMsgUtil.getSaveSucTipWithNumber((String)template.getNumber()));
    }
}

