/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.form.IPageCache;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.EmrTemplateInfo;
import kd.epm.emr.business.template.ITemplateModel;
import kd.epm.emr.business.template.ReportContext;
import kd.epm.emr.business.template.service.ITemplateMemberService;
import kd.epm.emr.common.model.cache.EmrModelCacheHelper;
import kd.epm.emr.common.spread.model.IDimMember;
import kd.epm.emr.common.spread.model.IDimension;
import kd.epm.emr.formplugin.report.AbstractReportProcessPlugin;
import kd.epm.emr.formplugin.report.multi.IReportTabModelDataProvider;
import kd.epm.emr.formplugin.report.multi.ReportTabInfo;
import kd.epm.emr.formplugin.report.multi.ReportTabModel;
import kd.epm.emr.formplugin.template.service.EmrTemplateMemberService;
import kd.epm.epbs.common.cache.EpbsThreadCache;
import kd.epm.epbs.common.enums.DataTypeEnum;
import kd.epm.epbs.common.enums.model.DimTypeEnum;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.relation.RelationBaseEntityObject;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.formplugin.model.memberf7.bean.EpbsSelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.bean.MultiF7Result;
import org.apache.commons.collections4.CollectionUtils;

public class EmrReportProcessPlugin
extends AbstractReportProcessPlugin<EmrTemplateInfo> {
    @Override
    protected DataTypeEnum getCellDataType(Map<String, String> dimMembers) {
        return DataTypeEnum.DEFAULT;
    }

    @Override
    protected IReportTabModelDataProvider getTabModelDataProvider() {
        return new EmrReportTabModelDataProvider();
    }

    @Override
    public ITemplateMemberService getTemplateMemberService() {
        return EmrTemplateMemberService.getInstance(this.getModelId());
    }

    @Override
    public List<String> getDimsForFlexPanelAp() {
        ArrayList<String> dims = new ArrayList<String>(16);
        LinkedList dimensions = new LinkedList(this.getSheetManager().getFilterView().getPageDomain().getDimensions());
        dimensions.addAll(this.getSheetManager().getFilterView().getViewPointDomain().getDimensions());
        for (IDimension dimension : dimensions) {
            dims.add(dimension.getNumber());
            if (dims.size() != 4) continue;
            break;
        }
        return dims;
    }

    private Set<String> getDimNumsByDimType(DimTypeEnum dimTypeEnum) {
        HashSet<String> mainEntityNums = new HashSet<String>(16);
        List dimensionBeans = EmrModelCacheHelper.get((long)this.getModelId()).getDimensionsByDimType(dimTypeEnum);
        if (CollectionUtils.isNotEmpty((Collection)dimensionBeans)) {
            dimensionBeans.forEach(d -> mainEntityNums.add(d.getNumber()));
        }
        return mainEntityNums;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        MultiF7Result multiF7Result;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.isNotEmpty((String)this.getDimNumBySign(actionId)) && (multiF7Result = (MultiF7Result)closedCallBackEvent.getReturnData()) != null && CollectionUtils.isNotEmpty((Collection)multiF7Result.getSelectedMemberList())) {
            this.cacheBySign(actionId, "viewid", multiF7Result.getViewId());
            List selectedMembers = multiF7Result.getSelectedMemberList();
            this.cacheBySign(actionId, "memberid", ((EpbsSelectedMember)selectedMembers.get(0)).getId());
            this.setValue(actionId, ((EpbsSelectedMember)selectedMembers.get(0)).getId());
        }
    }

    @Override
    public ReportContext getReportContext() {
        ReportContext context = new ReportContext(this.getModelId(), this.getBizModelId().longValue());
        Set<String> mainEntityDimNums = this.getDimNumsByDimType(DimTypeEnum.Entity);
        LinkedList dimensions = new LinkedList(this.getSheetManager().getFilterView().getPageDomain().getDimensions());
        dimensions.addAll(this.getSheetManager().getFilterView().getViewPointDomain().getDimensions());
        HashMap<String, RelationBaseEntityObject> map = new HashMap<String, RelationBaseEntityObject>(16);
        for (IDimension d : dimensions) {
            if (!mainEntityDimNums.contains(d.getNumber()) || !CollectionUtils.isNotEmpty((Collection)d.getMembers())) continue;
            IDimMember member = (IDimMember)d.getMembers().get(0);
            MemberBean memberBean = EpbsThreadCache.findMemberBeanByNum((long)this.getModelId(), (String)d.getNumber(), (String)member.getViewNumber(), (String)member.getNumber());
            if (memberBean == null) continue;
            RelationBaseEntityObject object = new RelationBaseEntityObject();
            object.loadSimpleDynamicObject(memberBean);
            map.put(d.getNumber(), object);
        }
        context.setMainDimMemMap(map);
        context.setTemplateNum(((EmrTemplateInfo)this.getTemplateModel().getTemplateBaseInfo()).getNumber());
        context.setSheetName(this.getSheetManager().getSheet().getSheetName());
        return context;
    }

    class EmrReportTabModelDataProvider
    implements IReportTabModelDataProvider {
        EmrReportTabModelDataProvider() {
        }

        @Override
        public ReportTabModel query4Cache(ReportTabInfo tab, IPageCache cache) {
            ReportTabModel reportTabModel = new ReportTabModel(tab.getTabKey(), cache);
            ITemplateModel template = EmrReportProcessPlugin.this.getTemplateService().getTemplateModel(EmrReportProcessPlugin.this.getTemplateClass(), IDUtils.toLong((Object)tab.getTemplateId()));
            String spreadSerial = null;
            String spreadJson = null;
            boolean isFromTemplateModel = false;
            if (StringUtils.isEmpty(spreadJson)) {
                spreadJson = template.getTemplateBaseInfo().getSpreadJson();
                spreadSerial = template.getTemplateBaseInfo().getData();
                isFromTemplateModel = true;
            }
            reportTabModel.initReportTabModel(spreadJson, spreadSerial, null, !isFromTemplateModel);
            reportTabModel.setTemplateModel(template);
            return reportTabModel;
        }
    }
}

