/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.report.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import kd.bos.cache.ThreadCache;
import kd.epm.emr.business.template.FloatCellInfo;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.ObjectConvertUtils;
import kd.epm.emr.business.template.QuickFloatBean;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.areasetting.IFloatInfo;
import kd.epm.emr.business.template.headerarea.IHeaderInfo;
import kd.epm.emr.business.template.headerarea.IHeaderObject;
import kd.epm.emr.common.spread.model.IDimMember;
import kd.epm.emr.common.spread.model.IDimension;
import kd.epm.emr.common.spread.sheet.Cell;
import kd.epm.emr.common.spread.sheet.ISheet;
import kd.epm.emr.common.template.Tuple;
import kd.epm.emr.common.template.enums.FloatMemberDisplayEnum;
import kd.epm.emr.common.template.enums.FloatTypeEnum;
import kd.epm.emr.common.template.enums.RowColExcuteEnum;
import kd.epm.emr.formplugin.report.cache.MatchFloatOrRelationAreaInfo;
import kd.epm.emr.formplugin.report.cache.MemberGroupKey;
import kd.epm.emr.formplugin.spread.AskExcuteInfo;
import kd.epm.emr.formplugin.spread.SpreadEasyInvoker;
import kd.epm.emr.formplugin.template.helper.MarkSpecialCellHelper;
import kd.epm.emr.formplugin.template.helper.SequenceSettingHelper;
import kd.epm.epbs.business.olap.bean.Row;
import kd.epm.epbs.common.cache.EpbsThreadCache;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.util.RangeModel;
import kd.epm.epbs.formplugin.model.memberf7.bean.MultiF7Result;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class FloatLogicHelper {
    public static Map<MemberGroupKey, List<Row>> groupRowMap(List<String> fixDim, List<Row> rows) {
        if (rows.isEmpty()) {
            return new LinkedHashMap<MemberGroupKey, List<Row>>();
        }
        int[] colIndeies = new int[fixDim.size()];
        for (int i = 0; i < fixDim.size(); ++i) {
            colIndeies[i] = rows.get(0).getColIndex(fixDim.get(i));
        }
        LinkedHashMap<MemberGroupKey, List<Row>> rowMap = new LinkedHashMap<MemberGroupKey, List<Row>>(16);
        rows.forEach(r -> rowMap.computeIfAbsent(MemberGroupKey.create(colIndeies, r), k -> new ArrayList(16)).add(r));
        return rowMap;
    }

    public static void groupHeaders(List<IHeaderInfo> headerInfos, Map<String, Integer> indexMap, Map<String, IHeaderInfo> headerInfoMap, boolean isDim) {
        int index = 0;
        for (IHeaderInfo header : headerInfos) {
            if (isDim && header.isDimension() || !isDim && !header.isDimension()) {
                indexMap.put(header.getNumber(), index);
                headerInfoMap.put(header.getNumber(), header);
            }
            ++index;
        }
    }

    public static void fixOriginalRange(ISheetManager sm, boolean isFromReport) {
        sm.getAreaRanges().forEach(m -> {
            if (!isFromReport || StringUtils.isEmpty((CharSequence)m.getOriginalAreaRange())) {
                m.setOriginalAreaRange(m.getAreaRange());
            }
            RangeModel rangeModel = new RangeModel(m.getAreaRange());
            if (CollectionUtils.isNotEmpty((Collection)m.getFloatInfos())) {
                m.getFloatInfos().forEach(f -> {
                    if (!isFromReport || StringUtils.isEmpty((CharSequence)f.getOriginalRange())) {
                        f.setOriginalRange(m.getFloatRange(f, rangeModel).getAreaRangeStr());
                    }
                });
            }
        });
    }

    public static AskExcuteInfo getAskExcuteInfo(boolean isRow, boolean isAdd, List<Integer> datas, boolean isCon, IDataAreaSetting m, IFloatInfo f, boolean isExport) {
        AskExcuteInfo askExcuteInfo = FloatLogicHelper.getAskExcuteInfo(isRow, isAdd, datas, isCon);
        FloatLogicHelper.cacheMatchFloatOrRelationAreaInfos(m, f, askExcuteInfo.getMethod(), datas, isExport);
        return askExcuteInfo;
    }

    public static AskExcuteInfo getAskExcuteInfo(boolean isRow, boolean isAdd, List<Integer> datas, boolean isCon) {
        RowColExcuteEnum excuteEnum;
        int operation;
        if (isRow) {
            operation = 0;
            excuteEnum = isAdd ? RowColExcuteEnum.INSERTROW : RowColExcuteEnum.DELETEROW;
        } else {
            operation = 1;
            excuteEnum = isAdd ? RowColExcuteEnum.INSERTCOL : RowColExcuteEnum.DELETECOL;
        }
        AskExcuteInfo excuteInfo = new AskExcuteInfo(operation, excuteEnum, datas);
        excuteInfo.setCon(isCon);
        excuteInfo.setRev(true);
        return excuteInfo;
    }

    public static String getDisplayValue(FloatMemberDisplayEnum displayEnum, String number, String name, String simpleName) {
        String value = null;
        if (StringUtils.isEmpty((CharSequence)simpleName)) {
            simpleName = name;
        }
        switch (displayEnum) {
            case NUMBER: {
                value = number;
                break;
            }
            case NAME: {
                value = name;
                break;
            }
            case NAMEANDNUMBER: {
                value = name + " " + number;
                break;
            }
            case NUMBERANDNAME: {
                value = number + " " + name;
                break;
            }
            case SIMPLENAME: {
                value = simpleName;
                break;
            }
            case NUMBERANDSIMPLENAME: {
                value = number + " " + simpleName;
                break;
            }
            case SIMPLENAMEANDNUMBER: {
                value = simpleName + " " + number;
                break;
            }
        }
        return value;
    }

    public static List<Integer> getHasValueNotCompleteMemRC(ISheetManager sm, IDataAreaSetting m, IFloatInfo f) {
        QuickFloatBean qfb = new QuickFloatBean(m, f);
        ArrayList<Integer> dataList = new ArrayList<Integer>(16);
        int offset = qfb.getSOffset();
        for (int i = qfb.getStart(); i <= qfb.getEnd(); ++i) {
            if (FloatLogicHelper.isNotCompleteMemRC(qfb.getHeaderInfos(), offset) && FloatLogicHelper.isExitDataFromWholeRC(qfb, sm.getSheet(), i)) {
                dataList.add(i);
            }
            ++offset;
        }
        return dataList;
    }

    private static boolean isNotCompleteMemRC(List<IHeaderInfo> infos, int offset) {
        return infos.stream().anyMatch(info -> info.isDimension() && (CollectionUtils.isEmpty((Collection)info.getHeaderObjects()) || info.getHeaderObjects().get(offset) == null || StringUtils.isEmpty((CharSequence)((IHeaderObject)info.getHeaderObjects().get(offset)).getNumber())));
    }

    public static List<Integer> getHasMemNotValueRC(ISheet sheet, IDataAreaSetting m, IFloatInfo f) {
        ArrayList<Integer> list = new ArrayList<Integer>(16);
        QuickFloatBean quickFloatBean = new QuickFloatBean(m, f);
        int offset = quickFloatBean.getSOffset();
        for (int i = quickFloatBean.getStart(); i <= quickFloatBean.getEnd(); ++i) {
            if (FloatLogicHelper.isExitHeaderMember(quickFloatBean.getHeaderInfos(), offset) && !FloatLogicHelper.isExitDataFromWholeRC(quickFloatBean, sheet, i)) {
                list.add(i);
            }
            ++offset;
        }
        return list;
    }

    private static boolean isExitDataFromWholeRC(QuickFloatBean qfb, ISheet sheet, int fIndex) {
        for (int j = qfb.getOtherStart(); j <= qfb.getOtherEnd(); ++j) {
            Cell cell = sheet.getCell(qfb.isRowFloat() ? fIndex : j, qfb.isRowFloat() ? j : fIndex, false);
            if (cell == null || cell.getValue() == null || !StringUtils.isNotEmpty((CharSequence)cell.getValue().toString())) continue;
            return true;
        }
        return false;
    }

    private static boolean isExitHeaderMember(List<IHeaderInfo> infos, int offset) {
        return infos.stream().anyMatch(info -> info.isDimension() && CollectionUtils.isNotEmpty((Collection)info.getHeaderObjects()) && info.getHeaderObjects().get(offset) != null && StringUtils.isNotEmpty((CharSequence)((IHeaderObject)info.getHeaderObjects().get(offset)).getNumber()));
    }

    public static IDimension dimNumToIDimension(long modelId, String dimNum) {
        DimensionBean dimBean = EpbsModelCacheHelper.get((long)modelId).getDimension(dimNum);
        return ObjectConvertUtils.dimBeanToIDimension((DimensionBean)dimBean);
    }

    public static List<IDimMember> memberIdToDimMembers(long modelId, String dimNum, List<Long> ids) {
        ArrayList<IDimMember> dimMembers = new ArrayList<IDimMember>(16);
        IDimension dimension = FloatLogicHelper.dimNumToIDimension(modelId, dimNum);
        ids.forEach(id -> {
            ViewBean vb;
            MemberBean memberBean = EpbsThreadCache.findMemberBeanById((long)modelId, (String)dimNum, (long)id);
            if (memberBean != null && (vb = EpbsThreadCache.findViewBeanById((long)modelId, (long)memberBean.getViewId())) != null) {
                dimMembers.add(ObjectConvertUtils.memBeanToDimMember((MemberBean)memberBean, (IDimension)dimension, (String)vb.getNumber()));
            }
        });
        return dimMembers;
    }

    public static List<IDimMember> selectMemberToDimMembers(long modelId, MultiF7Result result, FloatCellInfo floatCellInfo) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        List selectedMembers = result.getSelectedMemberList();
        selectedMembers.forEach(s -> ids.add(s.getId()));
        return FloatLogicHelper.memberIdToDimMembers(modelId, floatCellInfo.getDimNum(), ids);
    }

    public static void clearThreadCacheForExport() {
        FloatLogicHelper.cacheMatchFloatOrRelationAreaInfos(null, "matchfloatorrelationareainfo");
        FloatLogicHelper.cacheMatchFloatOrRelationAreaInfos(null, "matchareainfosforexport");
    }

    public static void cacheMatchAreaInfosForExport(MatchFloatOrRelationAreaInfo areaInfo) {
        if (areaInfo != null) {
            List<MatchFloatOrRelationAreaInfo> matchAreaInfosForExport = FloatLogicHelper.getMatchAreaInfosForExport();
            matchAreaInfosForExport.add(areaInfo);
            FloatLogicHelper.cacheMatchFloatOrRelationAreaInfos(matchAreaInfosForExport, "matchareainfosforexport");
        }
    }

    public static List<MatchFloatOrRelationAreaInfo> getMatchAreaInfosForExport() {
        return (List)ThreadCache.get((Object)"matchareainfosforexport", () -> new ArrayList(16));
    }

    public static void cacheMatchFloatOrRelationAreaInfos(List<MatchFloatOrRelationAreaInfo> infos, String cacheKey) {
        if (CollectionUtils.isNotEmpty(infos)) {
            ThreadCache.put((Object)cacheKey, infos);
        } else {
            ThreadCache.remove((Object)cacheKey);
        }
    }

    public static void cacheMatchFloatOrRelationAreaInfos(IDataAreaSetting m, IFloatInfo f, RowColExcuteEnum rowColExcuteEnum, List<Integer> datas, boolean isExport) {
        MatchFloatOrRelationAreaInfo matchFloatOrRelationAreaInfo = f != null ? new MatchFloatOrRelationAreaInfo(m, f, rowColExcuteEnum) : new MatchFloatOrRelationAreaInfo(m, rowColExcuteEnum);
        matchFloatOrRelationAreaInfo.setRowOrCols(datas);
        if (isExport) {
            FloatLogicHelper.cacheMatchAreaInfosForExport(matchFloatOrRelationAreaInfo);
        } else {
            FloatLogicHelper.cacheMatchFloatOrRelationAreaInfos(Collections.singletonList(matchFloatOrRelationAreaInfo), "matchfloatorrelationareainfo");
        }
    }

    public static List<MatchFloatOrRelationAreaInfo> matchFloatOrRelationArea(ISheetManager sm, AskExcuteInfo askExcuteInfo) {
        return (List)ThreadCache.get((Object)"matchfloatorrelationareainfo", () -> {
            ArrayList<MatchFloatOrRelationAreaInfo> mfras = new ArrayList<MatchFloatOrRelationAreaInfo>(16);
            ArrayList<Integer> datas = new ArrayList<Integer>(askExcuteInfo.getOperationdata());
            ArrayList<AskExcuteInfo.BatchOperateInfo> batchOperateInfos = new ArrayList<AskExcuteInfo.BatchOperateInfo>(askExcuteInfo.getBatchOperationData().getBatchOperateInfos());
            boolean isRow = askExcuteInfo.getOperation() == 0;
            for (IDataAreaSetting m : sm.getAreaRanges()) {
                MatchFloatOrRelationAreaInfo mfraInfo;
                if (CollectionUtils.isEmpty(datas) && CollectionUtils.isEmpty(batchOperateInfos)) break;
                RangeModel rangeModel = new RangeModel(m.getAreaRange());
                if (m.isRelation()) {
                    if (!isRow) continue;
                    mfraInfo = new MatchFloatOrRelationAreaInfo(m, askExcuteInfo.getMethod());
                    FloatLogicHelper.fillRowOrCols(datas.iterator(), batchOperateInfos.iterator(), mfraInfo, arg_0 -> ((RangeModel)rangeModel).isRowInArea(arg_0));
                    if (!CollectionUtils.isNotEmpty(mfraInfo.getRowOrCols())) continue;
                    mfras.add(mfraInfo);
                    continue;
                }
                if (!CollectionUtils.isNotEmpty((Collection)m.getFloatInfos())) continue;
                for (IFloatInfo f : m.getFloatInfos()) {
                    RangeModel floatRange = m.getFloatRange(f, rangeModel);
                    mfraInfo = new MatchFloatOrRelationAreaInfo(m, f, askExcuteInfo.getMethod());
                    FloatLogicHelper.fillRowOrCols(datas.iterator(), batchOperateInfos.iterator(), mfraInfo, index -> isRow && FloatTypeEnum.COL != f.getFloatType() && floatRange.isRowInArea(index.intValue()) || !isRow && FloatTypeEnum.ROW != f.getFloatType() && floatRange.isColInArea(index.intValue()));
                    if (!CollectionUtils.isNotEmpty(mfraInfo.getRowOrCols())) continue;
                    mfras.add(mfraInfo);
                }
            }
            return mfras;
        });
    }

    private static void fillRowOrCols(Iterator<Integer> iterator, Iterator<AskExcuteInfo.BatchOperateInfo> batchIterator, MatchFloatOrRelationAreaInfo mfraInfo, Predicate<Integer> predicate) {
        ArrayList<Integer> datas = new ArrayList<Integer>(16);
        while (iterator.hasNext()) {
            Integer data = iterator.next();
            if (!predicate.test(data)) continue;
            datas.add(data);
            iterator.remove();
        }
        while (batchIterator.hasNext()) {
            AskExcuteInfo.BatchOperateInfo batchOperateInfo = batchIterator.next();
            int start = batchOperateInfo.getOprtPosition();
            if (!predicate.test(start)) continue;
            for (int i = 0; i < batchOperateInfo.getSize(); ++i) {
                datas.add(start);
            }
            batchIterator.remove();
        }
        if (CollectionUtils.isNotEmpty(datas)) {
            mfraInfo.setRowOrCols(datas);
        }
    }

    public static void markSpecialCells(ISheetManager sm, SpreadEasyInvoker easyInvoker, AskExcuteInfo askExcuteInfo, boolean isMark) {
        List<MatchFloatOrRelationAreaInfo> matchFloatOrRelationAreaInfos = FloatLogicHelper.matchFloatOrRelationArea(sm, askExcuteInfo);
        if (CollectionUtils.isNotEmpty(matchFloatOrRelationAreaInfos)) {
            boolean isDealPoint = false;
            if (RowColExcuteEnum.INSERTROW == askExcuteInfo.getMethod() || RowColExcuteEnum.INSERTCOL == askExcuteInfo.getMethod()) {
                if (isMark) {
                    matchFloatOrRelationAreaInfos.forEach(info -> {
                        List<Integer> rowOrCols = info.getRowOrCols();
                        int start = rowOrCols.get(0);
                        int end = rowOrCols.get(0) + rowOrCols.size() - 1;
                        Tuple tuple = null;
                        if (info.isRelation()) {
                            tuple = info.getAreaSetting().getRelationFloatRanges(start, end);
                        } else if (info.getFloatInfo() != null) {
                            tuple = info.getAreaSetting().getFloatDimRanges(info.getFloatInfo(), start, end);
                        }
                        if (tuple != null) {
                            easyInvoker.doF7OrLockCell(true, (List)tuple.k);
                            easyInvoker.doF7OrLockCell(false, (List)tuple.v);
                        }
                    });
                }
                isDealPoint = true;
            }
            if (isDealPoint || isMark) {
                MarkSpecialCellHelper.markSpecialCells(matchFloatOrRelationAreaInfos, easyInvoker, isMark);
            }
            SequenceSettingHelper.markSeqAreaCells(sm, isMark, easyInvoker);
            easyInvoker.startToInvoke();
        }
        if (isMark) {
            FloatLogicHelper.cacheMatchFloatOrRelationAreaInfos(null, "matchfloatorrelationareainfo");
        }
    }
}

