/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.report.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.pagedim.IPageDimensionEntry;
import kd.epm.emr.formplugin.report.helper.PlatformBean;
import kd.epm.emr.formplugin.spread.SpreadClientInvoker;
import kd.epm.epbs.business.model.f7.MemberF7Parameter;
import kd.epm.epbs.common.cache.EpbsThreadCache;
import kd.epm.epbs.common.enums.RangeEnum;
import kd.epm.epbs.common.enums.model.DimTypeEnum;
import kd.epm.epbs.common.member.range.MemberRangeItem;
import kd.epm.epbs.common.model.IDimensionMember;
import kd.epm.epbs.common.model.PropertyValueEntry;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.BizModelDimBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import org.apache.commons.collections4.CollectionUtils;

public class SpreadMemberHelper {
    public static QFilter getPageDimFilter(IPageDimensionEntry pageEntry, long modelId) {
        return SpreadMemberHelper.getMemberRangeFilter(modelId, pageEntry.getDimension().getNumber(), pageEntry.getMembers());
    }

    public static List<Long> getViewIdsFromMemberScope(long modelId, String dimNum, List<IDimensionMember> dimensionMembers) {
        ArrayList<Long> ids = new ArrayList<Long>(16);
        if (CollectionUtils.isNotEmpty(dimensionMembers)) {
            dimensionMembers.forEach(m -> {
                ViewBean viewBean = EpbsThreadCache.findViewBeanByNum((long)modelId, (String)dimNum, (String)m.getViewNumber());
                if (viewBean != null) {
                    ids.add(viewBean.getId());
                }
            });
        }
        return ids;
    }

    public static QFilter getMemberRangeFilter(long modelId, String dimNum, List<IDimensionMember> dimensionMembers) {
        QFilter qFilter = null;
        if (CollectionUtils.isEmpty(dimensionMembers)) {
            return qFilter;
        }
        for (IDimensionMember member : dimensionMembers) {
            MemberRangeItem item = SpreadMemberHelper.getMemberRangeItem(dimNum, member, modelId);
            if (qFilter == null) {
                qFilter = item.buildFilterByScope();
                continue;
            }
            qFilter.or(item.buildFilterByScope());
        }
        return qFilter;
    }

    public static MemberRangeItem getMemberRangeItem(String dimNum, IDimensionMember member, long modelId) {
        PropertyValueEntry propertyValue = member.getPropertyValue();
        MemberRangeItem item = propertyValue == null ? new MemberRangeItem(modelId, dimNum, member.getViewNumber(), member.getNumber(), RangeEnum.getRangeByVal((int)member.getScope()), true) : new MemberRangeItem(modelId, dimNum, member.getViewNumber(), propertyValue.getPropNum(), propertyValue.getNumber(), RangeEnum.getRangeByVal((int)member.getScope()), true);
        return item;
    }

    public static void spreadF7lookUpData(IClientViewProxy clientViewProxy, String spreadKey, LookUpDataArgs args, String entityName, QFilter qFilter) {
        DynamicObjectCollection dynamicObjects = SpreadMemberHelper.querySpreadF7LookUpData(args, qFilter, entityName);
        SpreadClientInvoker.invokeSetLookupData(clientViewProxy, spreadKey, PlatformBean.packageF7lookUpData(args, dynamicObjects));
    }

    protected static DynamicObjectCollection querySpreadF7LookUpData(LookUpDataArgs args, QFilter qFilter, String entityNum) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
        qFilters.add(qFilter);
        qFilters.add(new QFilter("name", "like", (Object)(args.getLeft() + args.getValue().trim() + args.getRight())).or(new QFilter("number", "like", (Object)(args.getLeft() + args.getValue().trim() + args.getRight()))));
        ORM orm = ORM.create();
        int top = 20;
        if (StringUtils.isNotBlank((Object)args.getCountEnd())) {
            top = args.getCountEnd();
        }
        DataSet ds = orm.queryDataSet("querySpreadF7LookUpData", entityNum, "id,number,name,view.id,view.number", qFilters.toArray(new QFilter[0]), "number", top);
        return orm.toPlainDynamicObjectCollection(ds, args.getCountStart() - 1, top);
    }

    public static List<Long> getViewIdsByDimNum(String dimNum, long modelId, long dimBizModelId) {
        BizModelDimBean bizModelDimBean;
        List<Long> viewIds = new ArrayList<Long>(16);
        EpbsModelCache modelCache = EpbsModelCacheHelper.get((long)modelId);
        DimensionBean dimension = modelCache.getDimension(dimNum);
        BizModelBean bizModelBean = modelCache.getBizModelById(dimBizModelId);
        if (dimension != null && bizModelBean != null && (bizModelDimBean = (BizModelDimBean)bizModelBean.getDimMap().get(dimension.getId())) != null) {
            viewIds = bizModelDimBean.getViewIds();
        }
        return viewIds;
    }

    public static QFilter getViewQFilter(List<Long> ids) {
        QFilter qFilter = new QFilter("1", "=", (Object)0);
        if (CollectionUtils.isNotEmpty(ids)) {
            qFilter = new QFilter("view", "in", ids);
        }
        return qFilter;
    }

    public static void addViewQFilterForF7Param(MemberF7Parameter f7Param, List<QFilter> qFilters, List<Long> viewIds, boolean isNotDC) {
        DimTypeEnum dimTypeEnum;
        if (CollectionUtils.isEmpty(viewIds) && f7Param.getBizModelId() != 0L) {
            viewIds = SpreadMemberHelper.getViewIdsByDimNum(f7Param.getDimensionNumber(), f7Param.getModelId(), f7Param.getBizModelId());
        }
        if (CollectionUtils.isNotEmpty(viewIds)) {
            f7Param.setViewFilterList(viewIds);
            qFilters.add(SpreadMemberHelper.getViewQFilter(viewIds));
        }
        if (isNotDC && DimTypeEnum.Currency == (dimTypeEnum = EpbsModelCacheHelper.get((long)f7Param.getModelId()).getDimTypeEnumByDimNumber(f7Param.getDimensionNumber()))) {
            qFilters.add(new QFilter("number", "!=", (Object)"DC"));
        }
        if (CollectionUtils.isNotEmpty(qFilters)) {
            f7Param.addCustomCommFilter(qFilters);
        }
    }

    public static void updateCellsNotChange(ISheetManager sm) {
        sm.getSheet().iteratorCells(cell -> cell.setChangeVal(false));
    }
}

