/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.report.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.headerarea.IHeaderObject;
import kd.epm.emr.business.template.service.ITranNumberService;
import kd.epm.emr.common.spread.domain.Domain;
import kd.epm.epbs.business.olap.SQLBuilder;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class TranNumberHelper {
    public static final String SPLIT_MEMBER = "|";

    public static String getCombineKey(List<String> keys) {
        return String.join((CharSequence)SPLIT_MEMBER, keys);
    }

    public static String getCombineKey(ITranNumberService service, IDataAreaSetting dataAreaSetting, int row, int col) {
        List<String> membs = TranNumberHelper.getRowColDimMembs(service, dataAreaSetting, row, col);
        if (CollectionUtils.isEmpty(membs)) {
            return null;
        }
        return TranNumberHelper.getCombineKey(membs);
    }

    public static List<String> getRowColDimMembs(ITranNumberService service, IDataAreaSetting dataAreaSetting, int row, int col) {
        ArrayList<String> keys = new ArrayList<String>(16);
        Map cellMember = dataAreaSetting.getCellMember(row, col);
        TranNumberHelper.fillCombineKeys(keys, cellMember, dataAreaSetting.getRowColDims(), service);
        if (keys.size() != dataAreaSetting.getRowColDims().size()) {
            return null;
        }
        return keys;
    }

    public static void fillCombineKeys(List<String> keys, Map<String, IHeaderObject> cellMember, List<String> dims, ITranNumberService service) {
        dims.forEach(r -> {
            IHeaderObject headerObject = (IHeaderObject)cellMember.get(r);
            if (headerObject != null && StringUtils.isNotEmpty((CharSequence)headerObject.getNumber())) {
                keys.add(service.getTranNumber(r, headerObject));
            }
        });
    }

    public static void addFilterFromDomain(SQLBuilder sql, Domain domain, List<String> dims, ITranNumberService service) {
        HashSet memberSets = new HashSet(16);
        domain.getDimensions().forEach(d -> {
            String dimNum = d.getNumber();
            dims.add(dimNum);
            d.getMembers().forEach(m -> {
                if (StringUtils.isNotEmpty((CharSequence)m.getNumber())) {
                    memberSets.add(service.getTranNumber(m));
                }
            });
            if (CollectionUtils.isNotEmpty((Collection)memberSets)) {
                sql.addFilter(dimNum, memberSets.toArray(new String[0]));
                memberSets.clear();
            }
        });
    }

    public static List<String> addPageAndViewFilter(SQLBuilder sql, ISheetManager sm, ITranNumberService service) {
        ArrayList<String> dims = new ArrayList<String>(16);
        TranNumberHelper.addFilterFromDomain(sql, (Domain)sm.getFilterView().getPageDomain(), dims, service);
        TranNumberHelper.addFilterFromDomain(sql, (Domain)sm.getFilterView().getViewPointDomain(), dims, service);
        return dims;
    }

    public static void addAreaViewpointFilter(SQLBuilder sql, IDataAreaSetting m, ITranNumberService service) {
        m.getAreaViewpointmembentry().forEach(v -> sql.addFilter(v.getDimension().getNumber(), new String[]{service.getTranNumber(v.getDimension().getNumber(), v.getMember())}));
    }

    public static Map<String, Set<String>> getFixMemberFromHeader(IDataAreaSetting m, ITranNumberService service) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(16);
        m.getCompleteFixMemberMap().forEach((k, v) -> v.forEach(o -> result.computeIfAbsent((String)k, h -> new HashSet()).add(service.getTranNumber(k, o))));
        return result;
    }
}

