/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.report.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.form.IPageCache;
import kd.epm.emr.business.template.FloatCellInfo;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.QuickFloatBean;
import kd.epm.emr.business.template.ReportContext;
import kd.epm.emr.business.template.SequenceInfo;
import kd.epm.emr.business.template.arearangedim.IRowColDimensionEntry;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.areasetting.IFloatInfo;
import kd.epm.emr.business.template.headerarea.HeaderObject;
import kd.epm.emr.business.template.headerarea.IHeaderInfo;
import kd.epm.emr.business.template.headerarea.IHeaderObject;
import kd.epm.emr.business.template.helper.ReportMDDataHelper;
import kd.epm.emr.business.template.pagedim.IPageDimensionEntry;
import kd.epm.emr.business.template.relation.RelationAreaInfo;
import kd.epm.emr.business.template.service.ITranNumberService;
import kd.epm.emr.business.template.service.impl.TranNumberServiceImpl;
import kd.epm.emr.common.spread.model.IDimMember;
import kd.epm.emr.common.spread.sheet.Cell;
import kd.epm.emr.common.spread.sheet.ISheet;
import kd.epm.emr.common.spread.util.CellUserObjectHelper;
import kd.epm.emr.common.template.enums.FloatExpandTypeEnum;
import kd.epm.emr.common.template.enums.FloatMemberDisplayEnum;
import kd.epm.emr.common.template.enums.FloatTypeEnum;
import kd.epm.emr.formplugin.report.AbstractReportProcessPlugin;
import kd.epm.emr.formplugin.report.cache.DataTypeCacheInfo;
import kd.epm.emr.formplugin.report.cache.MemberGroupKey;
import kd.epm.emr.formplugin.report.cache.NoPluginCache;
import kd.epm.emr.formplugin.report.cache.ResultPage;
import kd.epm.emr.formplugin.report.cache.ResultPageManager;
import kd.epm.emr.formplugin.report.helper.DimGroupKey;
import kd.epm.emr.formplugin.report.helper.FloatLogicHelper;
import kd.epm.emr.formplugin.report.helper.MemberDataTypeHelper;
import kd.epm.emr.formplugin.report.helper.TranNumberHelper;
import kd.epm.emr.formplugin.report.impl.FloatDataProviderServiceImpl;
import kd.epm.emr.formplugin.report.service.floatreport.IAutoFloatService;
import kd.epm.emr.formplugin.report.service.floatreport.IFloatDataProviderService;
import kd.epm.emr.formplugin.spread.AskExcuteInfo;
import kd.epm.emr.formplugin.spread.SpreadDataModel;
import kd.epm.emr.formplugin.spread.SpreadEasyInvoker;
import kd.epm.emr.formplugin.template.helper.DimPropertyHelper;
import kd.epm.emr.formplugin.template.helper.TemplateAreaManagerHelper;
import kd.epm.epbs.business.olap.bean.MDResultSet;
import kd.epm.epbs.business.olap.bean.Row;
import kd.epm.epbs.business.relation.model.RdResultSet;
import kd.epm.epbs.business.relation.model.RdRow;
import kd.epm.epbs.common.cache.EpbsThreadCache;
import kd.epm.epbs.common.model.IDimensionMember;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.MemberPropBean;
import kd.epm.epbs.common.model.bean.PropBean;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.model.bean.relation.FieldBean;
import kd.epm.epbs.common.model.bean.relation.RelationModelBean;
import kd.epm.epbs.common.model.bean.relation.RelationModelBeanProvider;
import kd.epm.epbs.common.model.bean.relation.RelationTypeEnum;
import kd.epm.epbs.common.model.cache.EpbsPropCacheHelper;
import kd.epm.epbs.common.util.ICell;
import kd.epm.epbs.common.util.RangeModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class AutoFloatServiceImpl
implements IAutoFloatService {
    protected IFloatDataProviderService providerService;
    protected ISheetManager sm;
    private ReportContext context;
    protected AbstractReportProcessPlugin plugin;
    private IPageCache pageCache;
    private SpreadEasyInvoker invoker;
    private boolean isNextPage = false;
    private ResultPageManager resultPageManager;
    private Map<String, DataTypeCacheInfo> dataTypeMap;
    public ITranNumberService service;

    public ITranNumberService getTranNumberService() {
        if (this.service == null) {
            this.service = new TranNumberServiceImpl(this.getContext());
        }
        return this.service;
    }

    public AutoFloatServiceImpl(ISheetManager sm, ReportContext context, AbstractReportProcessPlugin plugin) {
        this.sm = sm;
        this.context = context;
        this.plugin = plugin;
        FloatLogicHelper.clearThreadCacheForExport();
    }

    public AutoFloatServiceImpl(ISheetManager sm, ReportContext context, NoPluginCache pageCache) {
        this.sm = sm;
        this.context = context;
        this.pageCache = pageCache;
        FloatLogicHelper.clearThreadCacheForExport();
    }

    public ReportContext getContext() {
        return this.context;
    }

    public IFloatDataProviderService getFloatDataProviderService() {
        if (this.providerService == null) {
            this.providerService = new FloatDataProviderServiceImpl(this.getContext());
        }
        return this.providerService;
    }

    public IPageCache getPageCache() {
        if (this.pageCache == null && this.plugin != null) {
            this.pageCache = this.plugin.getPageCache();
        }
        return this.pageCache;
    }

    public Map<String, DataTypeCacheInfo> getDataTypeMap() {
        if (this.dataTypeMap == null) {
            this.setDataTypeMap();
        }
        return this.dataTypeMap;
    }

    public void setDataTypeMap() {
        this.dataTypeMap = MemberDataTypeHelper.getAllDataType(this.getModelId(), this.getPageCache());
    }

    public long getModelId() {
        return this.getContext().getModelId();
    }

    @Override
    public void autoFloat() {
        if (this.checkAndPrepareData()) {
            return;
        }
        Map<String, MDResultSet> resultSetMap = this.getFloatDataProviderService().queryMDResultSetForReport(this.sm);
        Map<String, RdResultSet> relationDataMap = this.getFloatDataProviderService().queryRelationData(this.sm);
        this.sm.getAreaRanges().forEach(m -> {
            this.autoFloatRelationDataArea((IDataAreaSetting)m, relationDataMap);
            if (m.isRelation() || !m.isCompleteFixDim()) {
                return;
            }
            m.getFloatInfos().forEach(f -> {
                List<Row> rows;
                List floatDimNums = f.getDims(false);
                if (CollectionUtils.isNotEmpty((Collection)f.getSortDimInfos())) {
                    this.clearFloatMemberAndValue((IDataAreaSetting)m, (IFloatInfo)f);
                }
                if (CollectionUtils.isEmpty(rows = this.getFloatDataProviderService().getResultRowByFloatArea(this.sm, resultSetMap, (IDataAreaSetting)m, (IFloatInfo)f, this.getDataTypeMap())) && this.isNoRecord(resultSetMap, (IDataAreaSetting)m, (IFloatInfo)f) && this.exitHistoryFloatData((IDataAreaSetting)m, (IFloatInfo)f)) {
                    this.clearNoValueRowOrCol((IDataAreaSetting)m, (IFloatInfo)f);
                    return;
                }
                ThreadCache.put((Object)"autoflaot_key", (Object)"1");
                this.checkAndFloatData(floatDimNums, rows, (IDataAreaSetting)m, (IFloatInfo)f);
                QuickFloatBean qfb = new QuickFloatBean(m, f);
                this.refreshPropertyValue((IDataAreaSetting)m, (IFloatInfo)f, qfb.getSOffset(), qfb.getEOffset());
            });
        });
        if (this.resultPageManager != null) {
            this.resultPageManager.cacheManager(this.getPageCache());
        }
    }

    public void checkAndFloatData(List<String> floatDims, List<Row> rows, IDataAreaSetting m, IFloatInfo f) {
        if (!m.isCompleteFixDim()) {
            return;
        }
        IFloatDataProviderService dataProviderService = this.getFloatDataProviderService();
        if (!this.isNextPage) {
            this.filterRowsForHideDim(rows, m, f);
            rows = dataProviderService.filterByFixMembers(rows, m, f);
            QuickFloatBean qfb = new QuickFloatBean(m, f);
            if (CollectionUtils.isEmpty(rows)) {
                this.initEasyInvoker(true);
                this.clearRangeModelCellValue(qfb.getFloatDataRange());
                this.startToInvoke();
                return;
            }
            if (this.getPageSizeSetting() != -1) {
                this.clearFloatMemberAndValue(m, f);
            } else {
                this.initEasyInvoker(true);
                this.clearRangeModelCellValue(qfb.getFloatDataRange());
                this.startToInvoke();
            }
            rows = dataProviderService.sortRowsBySortSetting(rows, m, f);
            if (this.getPageSizeSetting() != -1) {
                this.getPageRowMap(rows, f, floatDims, false);
            }
            if (this.checkHasFloat(m, f, rows)) {
                return;
            }
            rows = this.sortRows(rows, f);
        }
        Map<MemberGroupKey, List<Row>> rowMap = this.getPageRowMap(rows, f, floatDims, true);
        if (this.getPageSizeSetting() != -1 && MapUtils.isEmpty(rowMap) && this.plugin != null) {
            return;
        }
        rows.clear();
        for (Map.Entry<MemberGroupKey, List<Row>> entry : rowMap.entrySet()) {
            rows.addAll((Collection<Row>)entry.getValue());
        }
        DimGroupKey dimGroupKey = new DimGroupKey(floatDims);
        int insert2Index = this.findStart2insertIndex(f, m);
        this.insertRank(insert2Index, rowMap.size(), m, f);
        RangeModel floatRange = m.getFloatRange(f, new RangeModel(m.getAreaRange()));
        this.initEasyInvoker(true);
        for (MemberGroupKey key : rowMap.keySet()) {
            this.updateSheetModel(key, insert2Index, floatRange, dimGroupKey, m, f);
            ++insert2Index;
        }
        this.updateFloatNumberFormSheet();
        this.startToInvoke();
        this.clearNoValueRowOrCol2(rowMap.size());
    }

    protected void clearNoValueRowOrCol2(int dataSize) {
    }

    protected void updateFloatNumberFormSheet() {
    }

    private void updateSheetModel(MemberGroupKey dimlist, int startIndex, RangeModel floatRange, DimGroupKey dimkey, IDataAreaSetting m, IFloatInfo f) {
        QuickFloatBean qfb = new QuickFloatBean(m, f);
        boolean isRowFloat = qfb.isRowFloat();
        List headerInfos = qfb.getHeaderInfos();
        int row = 0;
        int col = 0;
        int offset = 0;
        int curOffset = startIndex - qfb.getDStart();
        if (isRowFloat) {
            row = startIndex;
        } else {
            col = startIndex;
        }
        HashMap<String, Integer> indexMap = new HashMap<String, Integer>(16);
        HashMap<String, IHeaderInfo> headerInfoMap = new HashMap<String, IHeaderInfo>(16);
        FloatLogicHelper.groupHeaders(headerInfos, indexMap, headerInfoMap, true);
        FloatMemberDisplayEnum displayEnum = FloatMemberDisplayEnum.getEnumByNumber((String)f.getMemberDisplay());
        for (IRowColDimensionEntry entry : f.getPartition().getRowColDimensionEntries()) {
            String dimNum = entry.getDimension().getNumber();
            String memNum = dimlist.getValue(dimkey.getIndex(dimNum)).toString();
            offset = (Integer)indexMap.get(dimNum);
            if (isRowFloat) {
                col = floatRange.getX_start() + offset;
            } else {
                row = floatRange.getY_start() + offset;
            }
            IHeaderInfo headerInfo = (IHeaderInfo)headerInfoMap.get(dimNum);
            HeaderObject headerObject = new HeaderObject(true, memNum, entry.getViewNumber());
            this.fillSingleFloatMember(entry.getDimension().getNumber(), (IHeaderObject)headerObject, this.sm.getSheet().getCell(row, col), displayEnum);
            headerInfo.getHeaderObjects().set(curOffset, headerObject);
        }
    }

    public void insertRank(int start2insert, int size, IDataAreaSetting m, IFloatInfo f) {
        int end;
        QuickFloatBean qfb = new QuickFloatBean(m, f);
        RangeModel rangeModel = qfb.getFloatRange();
        int n = end = qfb.isRowFloat() ? rangeModel.getY_end() : rangeModel.getX_end();
        if ((size -= end - start2insert + 1) > 0) {
            this.doAskExcuteInfo(this.getAskExcuteInfo(qfb.isRowFloat(), true, this.getInsertDatas(size, start2insert), true, m, f));
        }
    }

    public AskExcuteInfo getAskExcuteInfo(boolean isRow, boolean isAdd, List<Integer> datas, boolean isCon, IDataAreaSetting m, IFloatInfo f) {
        return FloatLogicHelper.getAskExcuteInfo(isRow, isAdd, datas, isCon, m, f, this.plugin == null);
    }

    public Map<String, Map<String, Map<String, String>>> collectMemMsg(List<Row> rows, IFloatInfo f) {
        HashMap<String, Map<String, Map<String, String>>> result = new HashMap<String, Map<String, Map<String, String>>>(16);
        return result;
    }

    public int findStart2insertIndex(IFloatInfo f, IDataAreaSetting m) {
        QuickFloatBean qfb = new QuickFloatBean(m, f);
        int start = qfb.getDStart();
        List headerInfos = qfb.getHeaderInfos();
        List dims = qfb.getDimNums();
        ArrayList<String> mems = new ArrayList<String>(16);
        for (int i = qfb.getEOffset(); i >= qfb.getSOffset(); --i) {
            mems.clear();
            for (IHeaderInfo info : headerInfos) {
                IHeaderObject headerObject;
                if (!info.isDimension() || !CollectionUtils.isNotEmpty((Collection)info.getHeaderObjects()) || (headerObject = (IHeaderObject)info.getHeaderObjects().get(i)) == null || !StringUtils.isNotEmpty((CharSequence)headerObject.getNumber())) continue;
                mems.add(headerObject.getNumber());
            }
            if (mems.size() != dims.size()) continue;
            return start + i;
        }
        return qfb.getStart();
    }

    public Integer getPageSizeSetting() {
        return -1;
    }

    private Map<MemberGroupKey, List<Row>> getPageRowMap(List<Row> rows, IFloatInfo f, List<String> floatDimNums, boolean isGetPageData) {
        if (this.resultPageManager == null) {
            int pageSize = this.getPageSizeSetting();
            this.resultPageManager = ResultPageManager.getOrInitResultPageManager(pageSize, this.getPageCache());
        }
        if (this.resultPageManager.get(f.getOriginalRange()) == null) {
            Map<MemberGroupKey, List<Row>> allRowMap = FloatLogicHelper.groupRowMap(floatDimNums, rows);
            ResultPage resultPage = new ResultPage(allRowMap);
            this.resultPageManager.putIfAbsent(f.getOriginalRange(), resultPage);
        }
        Map<MemberGroupKey, List<Row>> rowMap = new HashMap<MemberGroupKey, List<Row>>(16);
        if (isGetPageData) {
            rowMap = this.resultPageManager.getNextPageRows(f.getOriginalRange());
        }
        return rowMap;
    }

    @Override
    public List<Row> specialFilterRows(List<Row> rows, List<String> floatDims) {
        return rows;
    }

    @Override
    public void refreshPropertyValue(IDataAreaSetting m, IFloatInfo f, int sOffset, int eOffset) {
        HashMap<String, IHeaderInfo> dimHeaderInfoMap;
        if (m.isRelation()) {
            return;
        }
        QuickFloatBean qfb = new QuickFloatBean(m, f);
        List headerInfos = qfb.getHeaderInfos();
        Map<Integer, String> map = DimPropertyHelper.groupProIndexToDimMap(headerInfos, dimHeaderInfoMap = new HashMap<String, IHeaderInfo>(16));
        if (MapUtils.isEmpty(map) || MapUtils.isEmpty(dimHeaderInfoMap)) {
            return;
        }
        map.forEach((k, v) -> {
            IHeaderInfo proInfo = (IHeaderInfo)headerInfos.get((int)k);
            IHeaderInfo dimInfo = (IHeaderInfo)dimHeaderInfoMap.get(v);
            if (dimInfo == null || proInfo == null) {
                return;
            }
            String dimNum = dimInfo.getNumber();
            for (int i = sOffset; i <= eOffset; ++i) {
                int c;
                int r;
                List memberPropList;
                MemberBean memberBean;
                IHeaderObject headerObject = (IHeaderObject)dimInfo.getHeaderObjects().get(i);
                String proVal = null;
                if (headerObject != null && StringUtils.isNotEmpty((CharSequence)headerObject.getViewNumber()) && (memberBean = this.findMemberBeanByNum(dimNum, headerObject.getViewNumber(), headerObject.getNumber())) != null && CollectionUtils.isNotEmpty((Collection)(memberPropList = EpbsPropCacheHelper.get((long)this.getModelId(), (String)dimNum).getMemberPropList(memberBean.getId())))) {
                    for (MemberPropBean propBean : memberPropList) {
                        PropBean prop = EpbsPropCacheHelper.get((long)this.getModelId(), (String)dimNum).getProp(propBean.getPropertyId());
                        if (!proInfo.getNumber().equals(prop.getNumber())) continue;
                        proVal = propBean.getPropValue();
                        if (propBean.getPropValueBean() == null) break;
                        proVal = propBean.getPropValueBean().getNameString();
                        break;
                    }
                }
                if (qfb.isRowFloat()) {
                    r = qfb.getDStart() + i;
                    c = qfb.getOtherFStart() + k;
                } else {
                    r = qfb.getOtherFStart() + k;
                    c = qfb.getDStart() + i;
                }
                this.sm.getSheet().getCell(r, c).setValue(proVal);
                this.getSpreadEasyInvoker().updataValue(r, c, proVal);
            }
        });
        this.startToInvoke();
    }

    protected List<Row> sortRows(List<Row> rows, IFloatInfo f) {
        List floatDims = f.getDims(true);
        if (CollectionUtils.isEmpty((Collection)f.getSortDimInfos())) {
            rows.sort((v1, v2) -> {
                for (String dimNum : floatDims) {
                    String mem02;
                    String mem01 = v1.getString(dimNum);
                    if (mem01.compareTo(mem02 = v2.getString(dimNum)) == 0) continue;
                    return mem01.compareTo(mem02);
                }
                return 0;
            });
        }
        return this.specialFilterRows(rows, floatDims);
    }

    public void filterRowsForHideDim(List<Row> rows, IDataAreaSetting m, IFloatInfo f) {
    }

    public boolean checkHasFloat(IDataAreaSetting m, IFloatInfo f, List<Row> rowslimitfix) {
        Map<MemberGroupKey, List<Row>> mapData = null;
        ArrayList<Integer> delDatas = new ArrayList<Integer>(16);
        QuickFloatBean qfb = new QuickFloatBean(m, f);
        boolean gobyfilter = false;
        List headerInfos = qfb.getHeaderInfos();
        List dims = qfb.getDimNums();
        int sOffset = qfb.getSOffset();
        int eOffset = qfb.getEOffset();
        int index = qfb.getDStart();
        ITranNumberService service = this.getTranNumberService();
        HashMap<String, IHeaderObject> headerInfoMap = new HashMap<String, IHeaderObject>(16);
        ArrayList<String> members = new ArrayList<String>(16);
        ArrayList<Object> mems = new ArrayList<Object>(16);
        this.initEasyInvoker(true);
        for (int i = eOffset; i >= sOffset; --i) {
            headerInfoMap.clear();
            members.clear();
            mems.clear();
            ReportMDDataHelper.fillHeaderObject((List)headerInfos, (int)i, headerInfoMap);
            TranNumberHelper.fillCombineKeys(members, headerInfoMap, dims, service);
            if (dims.size() != members.size()) continue;
            gobyfilter = true;
            if (mapData == null) {
                mapData = FloatLogicHelper.groupRowMap(dims, rowslimitfix);
            }
            mems.addAll(members);
            List<Row> rowList = mapData.remove(MemberGroupKey.create(mems));
            if (!CollectionUtils.isEmpty(rowList)) continue;
            delDatas.add(index + i);
        }
        if (CollectionUtils.isNotEmpty(delDatas)) {
            int size = qfb.getOriFSize() - (qfb.getfSize() - delDatas.size());
            if (size > 0) {
                this.doAskExcuteInfo(this.getAskExcuteInfo(qfb.isRowFloat(), true, this.getInsertDatas(size, index + eOffset), true, m, f));
            }
            this.doAskExcuteInfo(this.getAskExcuteInfo(qfb.isRowFloat(), false, delDatas, false, m, f));
        }
        if (gobyfilter) {
            if (MapUtils.isEmpty(mapData)) {
                return true;
            }
            rowslimitfix.clear();
            mapData.forEach((k, v) -> rowslimitfix.addAll((Collection<Row>)v));
        }
        return false;
    }

    private List<Integer> getInsertDatas(int size, int endDataIndex) {
        ArrayList<Integer> datas = new ArrayList<Integer>(16);
        for (int i = 0; i < size; ++i) {
            datas.add(endDataIndex);
        }
        return datas;
    }

    private void doAskExcuteInfo(AskExcuteInfo askExcuteInfo) {
        if (this.plugin != null) {
            this.plugin.updateRowAndCol(askExcuteInfo);
            SpreadDataModel.adjustSheet(askExcuteInfo, this.sm);
        } else {
            this.adjustSheetModelAndJs(askExcuteInfo);
        }
    }

    protected void initEasyInvoker(boolean isBatch) {
        if (this.getSpreadEasyInvoker() != null) {
            this.getSpreadEasyInvoker().setBatch(isBatch);
        }
    }

    protected void startToInvoke() {
        if (this.getSpreadEasyInvoker() != null) {
            this.getSpreadEasyInvoker().startToInvoke();
        }
    }

    protected void clearNoValueRowOrCol(IDataAreaSetting m, IFloatInfo floatInfo) {
        int index;
        int end;
        int start;
        ArrayList<Integer> delIndexs = new ArrayList<Integer>(16);
        boolean isRowFloat = true;
        if (floatInfo != null) {
            QuickFloatBean qfb = new QuickFloatBean(m, floatInfo);
            delIndexs = new ArrayList(16);
            start = qfb.getStart();
            end = qfb.getEnd();
            index = start + qfb.getOriFSize() - 1;
            isRowFloat = qfb.isRowFloat();
        } else {
            RangeModel rangeModel = new RangeModel(m.getAreaRange());
            RangeModel oriRangeModel = new RangeModel(m.getOriginalAreaRange());
            start = rangeModel.getY_start();
            end = rangeModel.getY_end();
            index = start + oriRangeModel.getRowSize() - 1;
        }
        for (int i = end; i > index; --i) {
            delIndexs.add(i);
        }
        if (CollectionUtils.isNotEmpty(delIndexs)) {
            this.doAskExcuteInfo(this.getAskExcuteInfo(isRowFloat, false, delIndexs, true, m, floatInfo));
        }
        this.clearFloatMemberAndValue(m, floatInfo);
    }

    public void adjustSheetModelAndJs(AskExcuteInfo excuteInfo) {
        SpreadDataModel.adjustSheet(excuteInfo, this.sm);
        TemplateAreaManagerHelper.adjustMultiAreaSetting(new HashSet<SequenceInfo>(), this.sm, excuteInfo, true);
    }

    protected boolean checkAndPrepareData() {
        FloatLogicHelper.fixOriginalRange(this.sm, true);
        if (this.getPageCache() != null) {
            ResultPageManager.clearCache(this.getPageCache());
        }
        return !this.sm.hasFloatAreaRange() || this.getContext() == null;
    }

    public SpreadEasyInvoker getSpreadEasyInvoker() {
        if (this.plugin != null && this.invoker == null) {
            this.invoker = new SpreadEasyInvoker(this.plugin.getClientViewProxy(), this.plugin.getSpreadKey());
        }
        return this.invoker;
    }

    protected void clearFloatMemberAndValue(IDataAreaSetting m, IFloatInfo floatInfo) {
        List headerInfos;
        int eOffset;
        int sOffset;
        this.initEasyInvoker(true);
        if (floatInfo != null) {
            QuickFloatBean qfb = new QuickFloatBean(m, floatInfo);
            this.clearRangeModelCellValue(qfb.getFloatDataRange());
            this.clearRangeModelCellValue(qfb.getFloatRange());
            sOffset = qfb.getSOffset();
            eOffset = qfb.getEOffset();
            headerInfos = qfb.getHeaderInfos();
        } else {
            RangeModel rangeModel = new RangeModel(m.getAreaRange());
            sOffset = 0;
            eOffset = rangeModel.getRowSize() - 1;
            headerInfos = m.getColHeaders();
            this.clearRangeModelCellValue(rangeModel);
        }
        this.startToInvoke();
        headerInfos.forEach(h -> {
            if (h.isDimension()) {
                List headerObjects = h.getHeaderObjects();
                for (int i = sOffset; i <= eOffset; ++i) {
                    headerObjects.set(i, new HeaderObject(true, null, null));
                }
            }
        });
    }

    private void clearRangeModelCellValue(RangeModel rangeModel) {
        this.sm.getSheet().iteratorRangeCells(rangeModel, false, cell -> {
            if (cell.getValue() != null) {
                cell.setValue(null);
                cell.setChangeVal(false);
                cell.clearAllUserObject();
                if (this.getSpreadEasyInvoker() != null) {
                    this.getSpreadEasyInvoker().updataValue((ICell)cell, null);
                }
            }
        });
    }

    private boolean isNoRecord(Map<String, MDResultSet> resultSetMap, IDataAreaSetting m, IFloatInfo floatInfo) {
        MDResultSet resultSet = resultSetMap.get(floatInfo.getOriginalRange());
        return resultSet == null || resultSet.getCount() <= 0;
    }

    private boolean exitHistoryFloatData(IDataAreaSetting m, IFloatInfo floatInfo) {
        QuickFloatBean qfb = new QuickFloatBean(m, floatInfo);
        int offset = qfb.getSOffset();
        List headers = qfb.getHeaderInfos();
        if (CollectionUtils.isNotEmpty((Collection)headers)) {
            ArrayList<String> members = new ArrayList<String>(16);
            for (IHeaderInfo headerInfo : headers) {
                IHeaderObject h;
                if (!headerInfo.isDimension() || !(h = (IHeaderObject)headerInfo.getHeaderObjects().get(offset)).isFloat() || !StringUtils.isNotEmpty((CharSequence)h.getNumber())) continue;
                members.add(this.getTranNumberService().getTranNumber(headerInfo.getNumber(), h));
            }
            return qfb.getDimNums().size() == members.size();
        }
        return false;
    }

    public void clearNoDataRowOrColsForFloat() {
        this.sm.getAreaRanges().forEach(m -> {
            if (CollectionUtils.isNotEmpty((Collection)m.getFloatInfos())) {
                m.getFloatInfos().forEach(f -> {
                    if (FloatExpandTypeEnum.ALL == FloatExpandTypeEnum.getEnumByNumber((String)f.getExpandType())) {
                        return;
                    }
                    QuickFloatBean quickFloatBean = new QuickFloatBean(m, f);
                    List<Integer> hasMemNotValueRC = FloatLogicHelper.getHasMemNotValueRC(this.sm.getSheet(), m, f);
                    if (hasMemNotValueRC.isEmpty()) {
                        return;
                    }
                    if (quickFloatBean.getfSize() == hasMemNotValueRC.size()) {
                        hasMemNotValueRC.remove(0);
                    }
                    this.doAskExcuteInfo(this.getAskExcuteInfo(quickFloatBean.isRowFloat(), false, hasMemNotValueRC, false, (IDataAreaSetting)m, (IFloatInfo)f));
                    quickFloatBean = new QuickFloatBean(m, f);
                    ArrayList<Integer> insertDatas = new ArrayList<Integer>(16);
                    for (int i = quickFloatBean.getfSize(); i < quickFloatBean.getOriFSize(); ++i) {
                        insertDatas.add(quickFloatBean.getEnd());
                    }
                    if (CollectionUtils.isNotEmpty(insertDatas)) {
                        this.doAskExcuteInfo(this.getAskExcuteInfo(quickFloatBean.isRowFloat(), true, (List<Integer>)insertDatas, true, (IDataAreaSetting)m, (IFloatInfo)f));
                    }
                });
            }
        });
    }

    public void fillFloatMembers(List<IDimMember> dimMembers, FloatCellInfo floatCellInfo) {
        boolean rowFloat;
        int oIndex;
        int curOffset;
        int otherFStart;
        int start;
        List headerInfos;
        if (CollectionUtils.isEmpty(dimMembers) || floatCellInfo == null || this.getContext() == null) {
            return;
        }
        if (dimMembers.size() > 1) {
            boolean isRowFloat = floatCellInfo.isRelation();
            if (!isRowFloat) {
                isRowFloat = FloatTypeEnum.ROW == floatCellInfo.getiFloatInfo().getFloatType();
            }
            ArrayList<Integer> insertDatas = new ArrayList<Integer>(16);
            for (int i = 0; i < dimMembers.size() - 1; ++i) {
                insertDatas.add(isRowFloat ? floatCellInfo.getRow() : floatCellInfo.getCol());
            }
            this.doAskExcuteInfo(this.getAskExcuteInfo(true, true, insertDatas, true, floatCellInfo.getIDataAreaSetting(), floatCellInfo.getiFloatInfo()));
        }
        ISheet sheet = this.sm.getSheet();
        FloatMemberDisplayEnum displayEnum = FloatMemberDisplayEnum.NAME;
        Map rcDimEntryMap = null;
        this.initEasyInvoker(true);
        if (floatCellInfo.isRelation()) {
            headerInfos = floatCellInfo.getIDataAreaSetting().getColHeaders();
            RangeModel dataRangeModel = new RangeModel(floatCellInfo.getIDataAreaSetting().getAreaRange());
            start = dataRangeModel.getY_start();
            otherFStart = dataRangeModel.getX_start();
            curOffset = floatCellInfo.getRow() - start;
            oIndex = floatCellInfo.getCol() - dataRangeModel.getX_start();
            rowFloat = true;
        } else {
            QuickFloatBean qfb = new QuickFloatBean(floatCellInfo.getIDataAreaSetting(), floatCellInfo.getiFloatInfo());
            headerInfos = qfb.getHeaderInfos();
            rowFloat = qfb.isRowFloat();
            start = qfb.getDStart();
            otherFStart = qfb.getOtherFStart();
            curOffset = (rowFloat ? floatCellInfo.getRow() : floatCellInfo.getCol()) - start;
            oIndex = (rowFloat ? floatCellInfo.getCol() : floatCellInfo.getRow()) - qfb.getOtherFStart();
            displayEnum = FloatMemberDisplayEnum.getEnumByNumber((String)floatCellInfo.getiFloatInfo().getMemberDisplay());
            rcDimEntryMap = floatCellInfo.getiFloatInfo().groupFloatDimSetting();
        }
        for (int i = 0; i < dimMembers.size(); ++i) {
            for (int j = 0; j < headerInfos.size(); ++j) {
                IHeaderObject headerObject;
                IRowColDimensionEntry rcDimEntry;
                HeaderObject copyIHeaderObject = null;
                IHeaderInfo info = (IHeaderInfo)headerInfos.get(j);
                String dimNum = info.getRefDimension();
                if (StringUtils.isEmpty((CharSequence)dimNum)) {
                    dimNum = info.getNumber();
                }
                if (j == oIndex) {
                    IDimMember member = dimMembers.get(i);
                    if (member != null) {
                        copyIHeaderObject = new HeaderObject(member.getNumber(), member.getParentNum(), member.getViewNumber(), true);
                    }
                } else if (rcDimEntryMap != null && (rcDimEntry = (IRowColDimensionEntry)rcDimEntryMap.get(dimNum)) != null && !rcDimEntry.isFloat() && CollectionUtils.isNotEmpty((Collection)rcDimEntry.getMembers())) {
                    IDimensionMember fixMem = (IDimensionMember)rcDimEntry.getMembers().get(0);
                    copyIHeaderObject = new HeaderObject(fixMem.getNumber(), fixMem.getParentNum(), fixMem.getViewNumber(), false);
                } else if (j < oIndex && info.isDimension() && i != 0 && (headerObject = (IHeaderObject)info.getHeaderObjects().get(curOffset)) != null) {
                    copyIHeaderObject = HeaderObject.copyIHeaderObject((IHeaderObject)headerObject);
                }
                if (copyIHeaderObject == null) continue;
                Cell cell = rowFloat ? sheet.getCell(start + curOffset + i, otherFStart + j) : sheet.getCell(otherFStart + j, start + curOffset + i);
                info.getHeaderObjects().set(curOffset + i, copyIHeaderObject);
                this.fillSingleFloatMember(dimNum, (IHeaderObject)copyIHeaderObject, cell, displayEnum);
            }
        }
        this.refreshPropertyValue(floatCellInfo.getIDataAreaSetting(), floatCellInfo.getiFloatInfo(), curOffset, curOffset + dimMembers.size() - 1);
        this.startToInvoke();
    }

    public void fillSingleFloatMember(String dimNum, IHeaderObject headerObject, Cell cell, FloatMemberDisplayEnum displayEnum) {
        MemberBean memberBean;
        String val = headerObject.getNumber();
        if (FloatMemberDisplayEnum.NUMBER != displayEnum && StringUtils.isNotEmpty((CharSequence)headerObject.getViewNumber()) && (memberBean = this.findMemberBeanByNum(dimNum, headerObject.getViewNumber(), headerObject.getNumber())) != null) {
            val = FloatLogicHelper.getDisplayValue(displayEnum, memberBean.getNumber(), memberBean.getNameString(), memberBean.getBaseMemberBean().getShortName());
        }
        cell.setValue((Object)val);
        if (this.getSpreadEasyInvoker() != null) {
            this.getSpreadEasyInvoker().updataValue((ICell)cell, val);
        }
    }

    public RelationModelBean getRelationModel(String bizNum) {
        return RelationModelBeanProvider.getRelationModelBeanByNum((long)this.getModelId(), (String)bizNum);
    }

    @Override
    public void autoFloatRelationDataArea(IDataAreaSetting m, Map<String, RdResultSet> relationDataMap) {
        RelationModelBean relationModel;
        RelationAreaInfo relationAreaInfo = m.getRelationAreaInfo();
        if (relationAreaInfo != null && (relationModel = this.getRelationModel(relationAreaInfo.getRelationModel())) != null) {
            relationAreaInfo.getAutoFloatDataIds().clear();
            this.clearNoValueRowOrCol(m, null);
            RdResultSet rdResultSet = relationDataMap.get(m.getOriginalAreaRange());
            if (rdResultSet == null || rdResultSet.isEmpty()) {
                return;
            }
            RangeModel rangeModel = new RangeModel(m.getAreaRange());
            int end = rdResultSet.getFetchSize() + rangeModel.getY_start();
            ArrayList<Integer> addRows = new ArrayList<Integer>(16);
            for (int i = rangeModel.getY_end(); i < end; ++i) {
                addRows.add(rangeModel.getY_end());
            }
            if (CollectionUtils.isNotEmpty(addRows)) {
                this.doAskExcuteInfo(this.getAskExcuteInfo(true, true, addRows, true, m, null));
            }
            Map fieldBeanMap = relationModel.getFieldBeanMap();
            rangeModel = new RangeModel(m.getAreaRange());
            this.initEasyInvoker(true);
            ISheet sheet = this.sm.getSheet();
            for (int y = 0; y < rdResultSet.getRows().length; ++y) {
                RdRow rdRow = rdResultSet.getRows()[y];
                for (int x = 0; x < m.getColHeaders().size(); ++x) {
                    IHeaderInfo info;
                    Object val;
                    Long id;
                    Cell cell = null;
                    if (x == 0 && (id = Long.valueOf(rdRow.getPkId())) != 0L) {
                        relationAreaInfo.addAutoFloatDataId(id);
                        cell = sheet.getCell(rangeModel.getY_start() + y, rangeModel.getX_start());
                        CellUserObjectHelper.setAutoFloatRelationDataId((Cell)cell, (Long)id);
                    }
                    if ((val = this.getValveByColNum(info = (IHeaderInfo)m.getColHeaders().get(x), rdRow, fieldBeanMap, relationAreaInfo, y)) == null) continue;
                    if (cell == null) {
                        cell = sheet.getCell(rangeModel.getY_start() + y, rangeModel.getX_start() + x);
                    }
                    cell.setValue(val);
                    if (this.getSpreadEasyInvoker() == null) continue;
                    this.getSpreadEasyInvoker().updataValue(cell.getRow(), cell.getCol(), val);
                }
            }
            this.startToInvoke();
        }
    }

    private Object getValveByColNum(IHeaderInfo info, RdRow rdRow, Map<String, FieldBean> fieldBeanMap, RelationAreaInfo relationAreaInfo, int yOffset) {
        Object val = null;
        String colNum = info.getNumber();
        FieldBean fieldBean = fieldBeanMap.get(colNum);
        if (fieldBean == null) {
            return val;
        }
        switch (fieldBean.getTypeEnum()) {
            case DIMLIB: 
            case MODEL: {
                MemberBean memberBean;
                IHeaderObject ho = this.exchangeValToIHeaderObject(rdRow.getString(colNum), (IPageDimensionEntry)relationAreaInfo.getMemberScopes().get(colNum), fieldBean);
                info.getHeaderObjects().set(yOffset, ho);
                if (ho == null) break;
                val = ho.getNumber();
                if (StringUtils.isNotEmpty((CharSequence)ho.getName())) {
                    val = ho.getName();
                    break;
                }
                if (!StringUtils.isNotEmpty((CharSequence)ho.getViewNumber()) || (memberBean = this.findMemberBeanByNum(fieldBean.getDimension().getNumber(), ho.getViewNumber(), ho.getNumber())) == null) break;
                val = memberBean.getNameString();
                break;
            }
            case NOTHING: {
                val = rdRow.getValueByType(colNum);
                break;
            }
        }
        return val;
    }

    private MemberBean findMemberBeanByNum(String dimNun, String viewNum, String memNum) {
        return EpbsThreadCache.findMemberBeanByNum((long)this.getModelId(), (String)dimNun, (String)viewNum, (String)memNum);
    }

    private IHeaderObject exchangeValToIHeaderObject(String val, IPageDimensionEntry pageDimEntry, FieldBean fieldBean) {
        if (StringUtils.isNotEmpty((CharSequence)val)) {
            MemberBean memberBean;
            String[] split = val.split("@");
            if (split.length == 4) {
                return new HeaderObject(true, split[3], null);
            }
            if (pageDimEntry != null) {
                return new HeaderObject(true, val, pageDimEntry.getViewNumber());
            }
            if (RelationTypeEnum.DIMLIB == fieldBean.getTypeEnum()) {
                List memberScopes = fieldBean.getMemberScopes();
                if (CollectionUtils.isNotEmpty((Collection)memberScopes)) {
                    return new HeaderObject(true, val, ((IDimensionMember)memberScopes.get(0)).getViewNumber());
                }
            } else if (RelationTypeEnum.MODEL == fieldBean.getTypeEnum() && (memberBean = RelationModelBeanProvider.getMemberBean((FieldBean)fieldBean, (long)this.getModelId(), (String)val)) != null) {
                ViewBean viewBean = EpbsThreadCache.findViewBeanById((long)this.getModelId(), (long)memberBean.getViewId());
                HeaderObject ho = new HeaderObject(true, val, viewBean.getNumber());
                ho.setName(memberBean.getNameString());
                return ho;
            }
            return new HeaderObject(true, val, null);
        }
        return null;
    }
}

