/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.report.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.ReportContext;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.areasetting.IFloatInfo;
import kd.epm.emr.business.template.headerarea.IHeaderObject;
import kd.epm.emr.business.template.relation.RelationAreaInfo;
import kd.epm.emr.business.template.service.IOlapService;
import kd.epm.emr.business.template.service.ITranNumberService;
import kd.epm.emr.business.template.service.impl.OlapServiceImpl;
import kd.epm.emr.business.template.service.impl.TranNumberServiceImpl;
import kd.epm.emr.common.template.enums.FloatExpandTypeEnum;
import kd.epm.emr.common.template.enums.FloatTypeEnum;
import kd.epm.emr.formplugin.report.cache.DataTypeCacheInfo;
import kd.epm.emr.formplugin.report.cache.MemberGroupKey;
import kd.epm.emr.formplugin.report.helper.FloatLogicHelper;
import kd.epm.emr.formplugin.report.helper.SpreadMemberHelper;
import kd.epm.emr.formplugin.report.helper.TranNumberHelper;
import kd.epm.emr.formplugin.report.impl.RelationDataHandlerServiceImpl;
import kd.epm.emr.formplugin.report.service.floatreport.IFloatDataProviderService;
import kd.epm.epbs.business.olap.FacTabFieldDefEnum;
import kd.epm.epbs.business.olap.SQLBuilder;
import kd.epm.epbs.business.olap.bean.IMDResultSet;
import kd.epm.epbs.business.olap.bean.MDResultSet;
import kd.epm.epbs.business.olap.bean.MDResultSetReader;
import kd.epm.epbs.business.olap.bean.Row;
import kd.epm.epbs.business.relation.model.RdQueryComInfo;
import kd.epm.epbs.business.relation.model.RdResultSet;
import kd.epm.epbs.common.enums.DataTypeEnum;
import kd.epm.epbs.common.enums.RangeEnum;
import kd.epm.epbs.common.member.range.MemberRangeItem;
import kd.epm.epbs.common.model.IDimensionMember;
import kd.epm.epbs.common.model.PropertyValueEntry;
import kd.epm.epbs.common.model.bean.relation.FieldBean;
import kd.epm.epbs.common.model.bean.relation.RelationDimBean;
import kd.epm.epbs.common.model.bean.relation.RelationModelBean;
import kd.epm.epbs.common.model.bean.relation.RelationModelBeanProvider;
import kd.epm.epbs.common.model.bean.relation.RelationTypeEnum;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.util.RangeModel;
import kd.epm.epbs.common.util.TypeConversionUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class FloatDataProviderServiceImpl
implements IFloatDataProviderService {
    public ITranNumberService service;
    private ReportContext context;

    public FloatDataProviderServiceImpl(ReportContext context) {
        this.context = context;
    }

    public ReportContext getContext() {
        return this.context;
    }

    @Override
    public IOlapService getOlapService() {
        return new OlapServiceImpl(this.getContext());
    }

    @Override
    public Map<String, MDResultSetReader> queryMDResultSetReaderForReport(ISheetManager sm) {
        HashMap<String, MDResultSetReader> result = new HashMap<String, MDResultSetReader>(16);
        for (IDataAreaSetting m : sm.getAreaRanges()) {
            if (FloatTypeEnum.NONE == m.getFloatOnWhere()) continue;
            m.getFloatInfos().forEach(f -> {
                SQLBuilder sql = this.getSQLBuilderForFloatInfo(sm, m, (IFloatInfo)f);
                MDResultSetReader resultSet = FloatExpandTypeEnum.ALL == FloatExpandTypeEnum.getEnumByNumber((String)f.getExpandType()) ? (MDResultSetReader)this.getVirtualFloatData(sql, (IFloatInfo)f, true) : this.getOlapService().queryDataReader(sql);
                result.put(f.getOriginalRange(), resultSet);
            });
        }
        return result;
    }

    @Override
    public Map<String, MDResultSet> queryMDResultSetForReport(ISheetManager sm) {
        HashMap<String, MDResultSet> resultSetMap = new HashMap<String, MDResultSet>(16);
        for (IDataAreaSetting m : sm.getAreaRanges()) {
            if (FloatTypeEnum.NONE == m.getFloatOnWhere() || m.isRelation()) continue;
            m.getFloatInfos().forEach(f -> {
                SQLBuilder sql = this.getSQLBuilderForFloatInfo(sm, m, (IFloatInfo)f);
                MDResultSet resultSet = FloatExpandTypeEnum.ALL == FloatExpandTypeEnum.getEnumByNumber((String)f.getExpandType()) ? (MDResultSet)this.getVirtualFloatData(sql, (IFloatInfo)f, false) : this.getOlapService().queryData(sql, false);
                resultSetMap.put(f.getOriginalRange(), resultSet);
            });
        }
        return resultSetMap;
    }

    protected SQLBuilder getSQLBuilderForFloatInfo(ISheetManager sm, IDataAreaSetting m, IFloatInfo info) {
        SQLBuilder sql = new SQLBuilder(this.getContext().getCubeNum());
        sql.setModelId(this.getContext().getModelId());
        sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        List<String> dims = TranNumberHelper.addPageAndViewFilter(sql, sm, this.getTranNumberService());
        this.addAreaViewpointFilter(m, sql);
        m.getRowColDims().forEach(d -> {
            dims.remove(d);
            dims.add((String)d);
        });
        sql.addSelectField(dims.toArray(new String[0]));
        this.addFixMemberFilter(m, sql);
        this.addFilterFromFloatInfo(sql, info);
        this.addSpecialLogicFilter(sql, sm);
        return sql;
    }

    @Override
    public void addAreaViewpointFilter(IDataAreaSetting m, SQLBuilder sql) {
        TranNumberHelper.addAreaViewpointFilter(sql, m, this.getTranNumberService());
    }

    @Override
    public void addSpecialLogicFilter(SQLBuilder sql, ISheetManager sm) {
    }

    @Override
    public IMDResultSet getVirtualFloatData(SQLBuilder sql, IFloatInfo info, boolean isReader) {
        ArrayList carsDims = new ArrayList(16);
        info.getPartition().getRowColDimensionEntries().forEach(s -> carsDims.add(s.getDimension().getNumber()));
        Object resultSet = isReader ? this.getMDResultSetReader() : this.getMDResultSet();
        resultSet.makeup(sql, carsDims);
        return resultSet;
    }

    @Override
    public void addFilterFromFloatInfo(SQLBuilder sql, IFloatInfo info) {
        HashSet memNums = new HashSet(16);
        info.getPartition().getRowColDimensionEntries().forEach(d -> {
            String dimNum = d.getDimension().getNumber();
            d.getMembers().forEach(m -> this.addMemberNums(dimNum, (IDimensionMember)m, memNums));
            if (CollectionUtils.isNotEmpty((Collection)memNums)) {
                sql.addFilter(dimNum, memNums.toArray(new String[0]));
            }
            memNums.clear();
        });
    }

    @Override
    public void addMemberNums(String dimNum, IDimensionMember member, Set<String> memNums) {
        RangeEnum rangeEnum = RangeEnum.getRangeByVal((int)member.getScope());
        PropertyValueEntry valueEntry = member.getPropertyValue();
        if (valueEntry == null) {
            String tranNumber = this.getTranNumberService().getTranNumber(dimNum, member);
            if (RangeEnum.ONLY == rangeEnum) {
                memNums.add(tranNumber);
                return;
            }
            memNums.addAll(new MemberRangeItem(this.getContext().getModelId(), dimNum, member.getViewNumber(), tranNumber, rangeEnum, true).getMemberNums());
        } else {
            MemberRangeItem rangeItem = new MemberRangeItem(this.getContext().getModelId(), dimNum, member.getViewNumber(), valueEntry.getPropNum(), valueEntry.getNumber(), rangeEnum, true);
            rangeItem.setPropNumber(valueEntry.getPropNum());
            memNums.addAll(rangeItem.getMemberNums());
        }
    }

    @Override
    public ITranNumberService getTranNumberService() {
        if (this.service == null) {
            this.service = new TranNumberServiceImpl(this.getContext());
        }
        return this.service;
    }

    @Override
    public List<Row> getResultRowByFloatArea(ISheetManager sm, Map<String, MDResultSet> resultSetMap, IDataAreaSetting m, IFloatInfo floatInfo, Map<String, DataTypeCacheInfo> dataTypeMap) {
        MDResultSet resultSet = resultSetMap.get(floatInfo.getOriginalRange());
        List<Row> rows = new ArrayList<Row>(16);
        if (resultSet != null) {
            while (resultSet.next()) {
                rows.add(resultSet.getRow());
            }
        }
        if (CollectionUtils.isEmpty(rows)) {
            return rows;
        }
        rows = this.filterByFixMembers(rows, m, floatInfo);
        ArrayList<Row> realRows = new ArrayList<Row>(16);
        List floatDims = floatInfo.getDims(true);
        if (CollectionUtils.isNotEmpty((Collection)floatDims)) {
            Map<String, List<Row>> groupRows = rows.parallelStream().collect(Collectors.groupingBy(d -> {
                StringBuilder sb = new StringBuilder();
                for (String dim : floatDims) {
                    sb.append(d.getString(dim)).append(';');
                }
                return sb.deleteCharAt(sb.length() - 1).toString();
            }));
            groupRows.forEach((k, v) -> {
                if (v.stream().anyMatch(e -> this.filterRowByDataType((Row)e, m, floatInfo, dataTypeMap))) {
                    realRows.addAll((Collection<Row>)v);
                }
            });
        }
        return realRows;
    }

    @Override
    public boolean filterRowByDataType(Row e, IDataAreaSetting m, IFloatInfo f, Map<String, DataTypeCacheInfo> dataTypeMap) {
        try {
            BigDecimal vv = TypeConversionUtils.objToBigDecimal((Object)e.getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField()));
            if (vv != null && vv.compareTo(BigDecimal.ZERO) != 0) {
                for (Map.Entry<String, DataTypeCacheInfo> dt : dataTypeMap.entrySet()) {
                    if (DataTypeEnum.TXT != dt.getValue().getDataTypeByNum(dt.getKey(), e.getString(dt.getKey()))) continue;
                    return false;
                }
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        for (Map.Entry<String, DataTypeCacheInfo> dt : dataTypeMap.entrySet()) {
            if (DataTypeEnum.TXT != dt.getValue().getDataTypeByNum(dt.getKey(), e.getString(dt.getKey()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Row> sortRowsBySortSetting(List<Row> rows, IDataAreaSetting m, IFloatInfo f) {
        if (CollectionUtils.isNotEmpty((Collection)f.getSortDimInfos())) {
            // empty if block
        }
        return rows;
    }

    @Override
    public List<Row> filterByFixMembers(List<Row> rows, IDataAreaSetting m, IFloatInfo f) {
        int end;
        if (FloatExpandTypeEnum.ALL == FloatExpandTypeEnum.getEnumByNumber((String)f.getExpandType())) {
            return rows;
        }
        Map fixMemberMap = m.getFixMemberMap();
        if (MapUtils.isEmpty((Map)fixMemberMap) || fixMemberMap.size() == 1) {
            return rows;
        }
        ArrayList<String> fixDim = new ArrayList<String>(16);
        RangeModel dataRangeModel = new RangeModel(m.getAreaRange());
        if (FloatTypeEnum.ROW == f.getFloatType()) {
            fixDim.addAll(m.getColdims());
            end = dataRangeModel.getColSize();
        } else {
            fixDim.addAll(m.getRowdims());
            end = dataRangeModel.getRowSize();
        }
        ArrayList<Row> filterRows = new ArrayList<Row>(16);
        Map<MemberGroupKey, List<Row>> rowMap = FloatLogicHelper.groupRowMap(fixDim, rows);
        ArrayList<Object> objMembers = new ArrayList<Object>(16);
        for (int i = 0; i < end; ++i) {
            objMembers.clear();
            for (String s : fixDim) {
                IHeaderObject headerObject;
                if (fixMemberMap.get(s) == null || (headerObject = (IHeaderObject)((List)fixMemberMap.get(s)).get(i)) == null || !StringUtils.isNotEmpty((CharSequence)headerObject.getNumber())) continue;
                if (this.skipFixDimFilter(s, headerObject.getNumber(), fixDim)) {
                    return rows;
                }
                objMembers.add(this.getTranNumberService().getTranNumber(s, headerObject));
            }
            MemberGroupKey groupKey = MemberGroupKey.create(objMembers);
            List<Row> rowList = rowMap.get(groupKey);
            if (!CollectionUtils.isNotEmpty(rowList)) continue;
            filterRows.addAll(rowList);
        }
        return filterRows;
    }

    @Override
    public Map<String, RdResultSet> queryRelationData(ISheetManager sm) {
        HashMap<String, RdResultSet> resultSetMap = new HashMap<String, RdResultSet>(16);
        RelationDataHandlerServiceImpl rdHandlerService = new RelationDataHandlerServiceImpl();
        for (IDataAreaSetting areaSetting : sm.getAreaRanges()) {
            if (!areaSetting.isRelation()) continue;
            resultSetMap.put(areaSetting.getOriginalAreaRange(), rdHandlerService.queryData(this.buildRdQueryComInfo(areaSetting.getRelationAreaInfo(), areaSetting.getOriginalAreaRange()), 0, 10000));
        }
        return resultSetMap;
    }

    private RdQueryComInfo buildRdQueryComInfo(RelationAreaInfo raInfo, String areaRange) {
        RelationModelBean relationModel = this.getRelationModel(raInfo.getRelationModel());
        RdQueryComInfo queryComInfo = this.getSimpleRdQueryComInfo(relationModel.getId());
        Map fieldBeanMap = relationModel.getFieldBeanMap();
        HashMap<String, Set> memberMap = new HashMap<String, Set>(16);
        raInfo.getMemberScopes().forEach((k, v) -> {
            RelationDimBean dimBean;
            FieldBean fieldBean = (FieldBean)fieldBeanMap.get(k);
            if (fieldBean != null && (dimBean = fieldBean.getDimension()) != null) {
                HashSet numbers = new HashSet(16);
                v.getMembers().forEach(m -> SpreadMemberHelper.getMemberRangeItem(dimBean.getNumber(), m, this.getContext().getModelId()).matchItems(s -> numbers.add(s.getNumber())));
                if (CollectionUtils.isNotEmpty(numbers)) {
                    memberMap.put((String)k, numbers);
                }
            }
        });
        relationModel.getFieldBeanMap().forEach((k, v) -> {
            List viewIds;
            if (RelationTypeEnum.DIMLIB == v.getTypeEnum()) {
                HashSet memberNums = new HashSet(16);
                v.getMemberScopes().forEach(m -> SpreadMemberHelper.getMemberRangeItem(v.getDimension().getNumber(), m, this.getContext().getModelId()).matchItems(s -> memberNums.add(s.getNumber())));
                if (CollectionUtils.isNotEmpty(memberNums)) {
                    if (memberMap.get(k) != null) {
                        memberNums.retainAll((Collection)memberMap.get(k));
                    }
                    memberMap.put((String)k, memberNums);
                }
            } else if (RelationTypeEnum.MODEL == v.getTypeEnum() && CollectionUtils.isEmpty((Collection)((Collection)memberMap.get(k))) && CollectionUtils.isNotEmpty((Collection)(viewIds = v.getDimension().getViewIds()))) {
                EpbsMemberCache memberCache = EpbsMemberCacheHelper.get((long)this.getContext().getModelId(), (String)v.getDimension().getNumber());
                HashSet numbers = new HashSet(16);
                viewIds.forEach(vd -> memberCache.getMembers(vd.longValue()).forEach(m -> numbers.add(m.getNumber())));
                if (CollectionUtils.isNotEmpty(numbers)) {
                    memberMap.put((String)k, numbers);
                }
            }
        });
        memberMap.forEach((k, v) -> queryComInfo.addFilter(k, v.toArray(new Object[0])));
        queryComInfo.setSelects(raInfo.getCols());
        queryComInfo.setReport(true);
        queryComInfo.setTemplateaAreaInfo(String.join((CharSequence)"@", this.getContext().getTemplateNum(), this.getContext().getSheetName(), areaRange) + "@");
        return queryComInfo;
    }

    protected RdQueryComInfo getSimpleRdQueryComInfo(long bizModelId) {
        return new RdQueryComInfo(Long.valueOf(this.getContext().getModelId()), Long.valueOf(bizModelId));
    }

    public RelationModelBean getRelationModel(String bizNum) {
        return RelationModelBeanProvider.getRelationModelBeanByNum((long)this.getContext().getModelId(), (String)bizNum);
    }

    public boolean skipFixDimFilter(String dimNum, String memNum, List<String> fixDims) {
        return false;
    }

    @Override
    public void addFixMemberFilter(IDataAreaSetting m, SQLBuilder sql) {
        TranNumberHelper.getFixMemberFromHeader(m, this.getTranNumberService()).forEach((k, v) -> sql.addFilter(k, v.toArray(v.toArray(new String[0]))));
    }

    public MDResultSet getMDResultSet() {
        return new MDResultSet();
    }

    public MDResultSetReader getMDResultSetReader() {
        return new MDResultSetReader();
    }
}

