/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.report.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.olap.common.CellSet;
import kd.bos.olap.dataSources.SaveCommandInfo;
import kd.bos.olap.dataSources.SelectCommandInfo;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.QuickFloatBean;
import kd.epm.emr.business.template.ReportContext;
import kd.epm.emr.business.template.SpreadDataModelUtil;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.areasetting.IFloatInfo;
import kd.epm.emr.business.template.headerarea.IHeaderInfo;
import kd.epm.emr.business.template.headerarea.IHeaderObject;
import kd.epm.emr.business.template.helper.ReportMDDataHelper;
import kd.epm.emr.business.template.relation.RelationAreaInfo;
import kd.epm.emr.business.template.service.ITranNumberService;
import kd.epm.emr.business.template.service.impl.OlapServiceImpl;
import kd.epm.emr.business.template.service.impl.TranNumberServiceImpl;
import kd.epm.emr.common.spread.common.variant.Variant;
import kd.epm.emr.common.spread.domain.Domain;
import kd.epm.emr.common.spread.domain.PageDimDomain;
import kd.epm.emr.common.spread.domain.ViewPointDimDomain;
import kd.epm.emr.common.spread.model.IDimMember;
import kd.epm.emr.common.spread.model.IDimension;
import kd.epm.emr.common.spread.sheet.Cell;
import kd.epm.emr.common.spread.sheet.ISheet;
import kd.epm.emr.common.spread.util.CellUserObjectHelper;
import kd.epm.emr.common.template.Tuple;
import kd.epm.emr.common.template.enums.FloatTypeEnum;
import kd.epm.emr.formplugin.report.helper.FloatLogicHelper;
import kd.epm.emr.formplugin.report.helper.TranNumberHelper;
import kd.epm.emr.formplugin.report.impl.RelationDataHandlerServiceImpl;
import kd.epm.emr.formplugin.report.service.IMDDataHandlerService;
import kd.epm.epbs.business.olap.FacTabFieldDefEnum;
import kd.epm.epbs.business.olap.VerifyResult;
import kd.epm.epbs.business.relation.IRdQueryService;
import kd.epm.epbs.business.relation.model.RdRow;
import kd.epm.epbs.business.relation.model.RdSaveComInfo;
import kd.epm.epbs.common.enums.BizModelErTypeEnum;
import kd.epm.epbs.common.model.bean.relation.FieldBean;
import kd.epm.epbs.common.model.bean.relation.RelationModelBean;
import kd.epm.epbs.common.model.bean.relation.RelationModelBeanProvider;
import kd.epm.epbs.common.util.DateTimeUtils;
import kd.epm.epbs.common.util.ExcelUtils;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.RangeModel;
import kd.epm.epbs.common.util.TypeConversionUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class MDDataHandlerServiceImpl
implements IMDDataHandlerService {
    public ITranNumberService tranNumberService;
    public ReportContext context;

    public MDDataHandlerServiceImpl(ReportContext context) {
        this.context = context;
    }

    public ReportContext getContext() {
        return this.context;
    }

    @Override
    public void addSourceMeasure(SaveCommandInfo info, String cubeNum) {
        info.setMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
    }

    @Override
    public Tuple<SaveCommandInfo, CellSet> buildSaveCommandInfo(IDataAreaSetting m, Set<Tuple<List<String>, Object>> vals, ISheetManager sm) {
        SaveCommandInfo info = new SaveCommandInfo();
        this.addSourceMeasure(info, this.getContext().getCubeNum());
        List selectDimKey = m.getRowColDims();
        info.setDimensions(selectDimKey);
        ReportMDDataHelper.addFixDimension((Domain)sm.getFilterView().getPageDomain(), (SaveCommandInfo)info, (ITranNumberService)this.getTranNumberService());
        ReportMDDataHelper.addFixDimension((Domain)sm.getFilterView().getViewPointDomain(), (SaveCommandInfo)info, (ITranNumberService)this.getTranNumberService());
        ReportMDDataHelper.addFixDimension((List)m.getAreaViewpointmembentry(), (SaveCommandInfo)info, (ITranNumberService)this.getTranNumberService());
        CellSet cellSets = new CellSet(selectDimKey.toArray(new String[0]), new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        cellSets.setFromQuery(false);
        vals.forEach(t -> cellSets.set(((List)t.k).toArray(new String[0]), FacTabFieldDefEnum.FIELD_MONEY.getField(), t.v));
        return Tuple.newOne((Object)info, (Object)cellSets);
    }

    @Override
    public VerifyResult save(ISheetManager sm) {
        if (!sm.hasAreaRange()) {
            return null;
        }
        VerifyResult vr = this.verifyFloatData(sm);
        if (vr != null && !vr.isEmpty()) {
            return vr;
        }
        this.setCtxForTranNumberService(sm);
        HashMultimap<IDataAreaSetting, Tuple<List<String>, Object>> cellValue = this.collectMDCellValue(sm);
        this.filterMDCellValue(sm, cellValue);
        if (cellValue.isEmpty()) {
            return null;
        }
        vr = new VerifyResult();
        for (IDataAreaSetting m : sm.getAreaRanges()) {
            if (m.isRelation()) {
                vr.mergeVerifyResult(this.saveRelationData(m, sm));
                continue;
            }
            Set tuples = cellValue.removeAll((Object)m);
            if (CollectionUtils.isNotEmpty((Collection)tuples)) {
                Tuple<SaveCommandInfo, CellSet> comTuple = this.buildSaveCommandInfo(m, tuples, sm);
                if (comTuple.k != null && comTuple.v != null) {
                    vr.mergeVerifyResult(this.getOlapService().saveData((SaveCommandInfo)comTuple.k, (CellSet)comTuple.v, true, true));
                }
            }
            m.getDelFloatValues().clear();
        }
        return vr;
    }

    public VerifyResult saveRelationData(IDataAreaSetting m, ISheetManager sm) {
        VerifyResult vr = null;
        RelationAreaInfo raInfo = m.getRelationAreaInfo();
        List cols = raInfo.getCols();
        RangeModel rangeModel = new RangeModel(m.getAreaRange());
        List colHeaders = m.getColHeaders();
        int firstCol = rangeModel.getX_start();
        ISheet sheet = sm.getSheet();
        ArrayList<RdRow> rdRows = new ArrayList<RdRow>(16);
        RelationModelBean relationModel = this.getRelationModel(raInfo.getRelationModel());
        Set oldDataIds = raInfo.getAutoFloatDataIds();
        HashSet<Long> curDatas = new HashSet<Long>(16);
        int endCol = firstCol + colHeaders.size() - 1;
        for (int i = rangeModel.getY_start(); i <= rangeModel.getY_end(); ++i) {
            Long id2 = null;
            HashMap<String, Object> row = new HashMap<String, Object>(16);
            boolean isExitData = false;
            for (int j = firstCol; j <= endCol; ++j) {
                IHeaderObject ho;
                String colNum = (String)cols.get(j - firstCol);
                IHeaderInfo headerInfo = (IHeaderInfo)colHeaders.get(j - firstCol);
                Cell cell = sheet.getCell(i, j, false);
                Object val = null;
                boolean isChange = false;
                if (cell != null) {
                    isChange = cell.isChangeVal();
                    if (j == firstCol && IDUtils.isNotEmptyLong((Long)(id2 = Long.valueOf(CellUserObjectHelper.getAutoFloatRelationDataId((Cell)cell)))).booleanValue()) {
                        row.put(IRdQueryService.ID_FIELD, id2);
                        oldDataIds.remove(id2);
                    }
                    val = cell.getValue();
                }
                if (headerInfo.isDimension() && (ho = (IHeaderObject)headerInfo.getHeaderObjects().get(i - rangeModel.getY_start())) != null && StringUtils.isNotEmpty((CharSequence)ho.getNumber())) {
                    val = ho.getNumber();
                    if (StringUtils.isEmpty((CharSequence)ho.getViewNumber())) {
                        val = String.join((CharSequence)"@", this.getContext().getTemplateNum(), this.getContext().getSheetName(), m.getOriginalAreaRange(), val.toString());
                    }
                    isExitData = true;
                }
                if ((val = this.getValveFromCell(relationModel.getFieldBeanMap(), colNum, val, rangeModel.getAreaRangeStr())) != null) {
                    isExitData = true;
                }
                if (!isChange) continue;
                row.put(colNum, val);
            }
            if (isExitData) {
                if (!MapUtils.isNotEmpty(row)) continue;
                if (row.entrySet().stream().anyMatch(e -> !IRdQueryService.ID_FIELD.equals(e.getKey()))) {
                    rdRows.add(RdRow.buildRow(row, (int)i));
                    continue;
                }
                if (!IDUtils.isNotEmptyLong(id2).booleanValue()) continue;
                curDatas.add(id2);
                continue;
            }
            if (!IDUtils.isNotEmptyLong(id2).booleanValue()) continue;
            rdRows.add(RdRow.buildRow(id2, (int)i));
        }
        if (CollectionUtils.isNotEmpty((Collection)oldDataIds)) {
            oldDataIds.forEach(id -> rdRows.add(RdRow.buildRow((Long)id)));
        }
        if (CollectionUtils.isNotEmpty(rdRows)) {
            RdSaveComInfo saveComInfo = this.getSimpleRdSaveComInfo(relationModel.getId());
            saveComInfo.setRdRows(rdRows);
            saveComInfo.setInsertColumns(cols);
            new RelationDataHandlerServiceImpl().saveData(saveComInfo);
            rdRows.forEach(r -> {
                if (oldDataIds.contains(r.getPkId())) {
                    return;
                }
                Long id = r.getPkId();
                if (r.isDelete()) {
                    id = null;
                } else {
                    curDatas.add(id);
                }
                CellUserObjectHelper.setAutoFloatRelationDataId((Cell)sheet.getCell(r.getIndex(), firstCol), (Long)id);
            });
        }
        if (CollectionUtils.isNotEmpty(curDatas)) {
            raInfo.setAutoFloatDataIds(curDatas);
        }
        return vr;
    }

    private Object getValveFromCell(Map<String, FieldBean> fieldBeanMap, String colNum, Object obj, String areaMessage) {
        Object val = null;
        FieldBean fieldBean = fieldBeanMap.get(colNum);
        if (fieldBean != null && obj != null) {
            BizModelErTypeEnum typeEnum = BizModelErTypeEnum.getBizModelErTypeEnum((String)fieldBean.getDataType());
            try {
                switch (typeEnum) {
                    case NUMBER: {
                        BigDecimal bigDecimal = TypeConversionUtils.objToBigDecimal((Object)obj);
                        if (bigDecimal == null) break;
                        val = bigDecimal.stripTrailingZeros();
                        break;
                    }
                    case STRING: {
                        val = TypeConversionUtils.objToString((Object)obj);
                        break;
                    }
                    case DATETIME: {
                        val = DateTimeUtils.parseStrDate((String)obj.toString());
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u533a\u57df\u3010%1$s\u3011\u5b57\u6bb5\u3010%2$s\u3011\u7684\u5f55\u5165\u503c\u3010%3$s\u3011\u6570\u636e\u7c7b\u578b\u9519\u8bef\uff0c\u5e94\u4e3a\u3010%4$s\u3011\u3002", (String)"MDDataHandlerServiceImpl_0", (String)"epm-emr-formplugin", (Object[])new Object[0]), areaMessage, String.join((CharSequence)"|", fieldBean.getNumber(), fieldBean.getName()), obj, typeEnum.getDesc().getDescription()));
            }
        }
        return val;
    }

    public RdSaveComInfo getSimpleRdSaveComInfo(long bizModelId) {
        return new RdSaveComInfo(Long.valueOf(this.getContext().getModelId()), Long.valueOf(bizModelId));
    }

    public RelationModelBean getRelationModel(String bizNum) {
        return RelationModelBeanProvider.getRelationModelBeanByNum((long)this.getContext().getModelId(), (String)bizNum);
    }

    @Override
    public Map<String, Object> queryData(SelectCommandInfo queryInfo) {
        return this.getOlapService().queryData(queryInfo);
    }

    @Override
    public Map<String, Map<String, Object>> query(ISheetManager sm, IDataAreaSetting multiAreaSetting) {
        if (!sm.hasAreaRange()) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        ViewPointDimDomain viewPointDomain = sm.getFilterView().getViewPointDomain();
        PageDimDomain pageDomain = sm.getFilterView().getPageDomain();
        this.dealPageOrViewOrg((Domain)pageDomain);
        this.dealPageOrViewOrg((Domain)viewPointDomain);
        String[] measureKeys = new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()};
        if (sm.getUserObject("issource") != null) {
            measureKeys = new String[]{FacTabFieldDefEnum.FIELD_SOURCE.getField()};
        }
        HashMap<String, Map<String, Object>> allSets = new HashMap<String, Map<String, Object>>(16);
        this.setCtxForTranNumberService(sm);
        for (IDataAreaSetting m : sm.getAreaRanges()) {
            boolean isBreak = false;
            if (multiAreaSetting != null) {
                if (!m.getOriginalAreaRange().equals(multiAreaSetting.getOriginalAreaRange())) continue;
                isBreak = true;
            }
            List rowTuples = ReportMDDataHelper.genTuples((List)m.getRowHeaders());
            List colTuples = ReportMDDataHelper.genTuples((List)m.getColHeaders());
            if (CollectionUtils.isEmpty((Collection)rowTuples) || CollectionUtils.isEmpty((Collection)colTuples)) continue;
            SelectCommandInfo queryInfo = this.buildQueryFilter(m, sm, measureKeys);
            allSets.put(m.getOriginalAreaRange(), this.queryData(queryInfo));
            if (!isBreak) continue;
            break;
        }
        return allSets;
    }

    @Override
    public void filterMDCellValue(ISheetManager sm, HashMultimap<IDataAreaSetting, Tuple<List<String>, Object>> kvMaps) {
    }

    @Override
    public void addSpecialQueryFilter(ISheetManager sm, SelectCommandInfo queryInfo) {
    }

    public void addAreaViewpointFilter(IDataAreaSetting m, SelectCommandInfo queryInfo) {
        if (CollectionUtils.isNotEmpty((Collection)m.getAreaViewpointmembentry())) {
            m.getAreaViewpointmembentry().forEach(v -> queryInfo.addFilter(v.getDimension().getNumber(), new String[]{this.getTranNumberService().getTranNumber(v.getDimension().getNumber(), v.getMember())}));
        }
    }

    @Override
    public SelectCommandInfo buildQueryFilter(IDataAreaSetting m, ISheetManager sm, String[] measureKeys) {
        SelectCommandInfo queryInfo = new SelectCommandInfo();
        List selectDimKey = m.getRowColDims();
        queryInfo.addDims(selectDimKey.toArray(new String[0]));
        queryInfo.addMeasures(measureKeys);
        this.buildQueryFilter((Domain)sm.getFilterView().getViewPointDomain(), queryInfo);
        this.buildQueryFilter((Domain)sm.getFilterView().getPageDomain(), queryInfo);
        this.addAreaViewpointFilter(m, queryInfo);
        this.buildRowColQueryFilter(m.getRowHeaders(), queryInfo, sm);
        this.buildRowColQueryFilter(m.getColHeaders(), queryInfo, sm);
        this.addSpecialQueryFilter(sm, queryInfo);
        return queryInfo;
    }

    @Override
    public void dealPageOrViewOrg(Domain domain) {
    }

    public OlapServiceImpl getOlapService() {
        return new OlapServiceImpl(this.getContext());
    }

    @Override
    public ITranNumberService getTranNumberService() {
        if (this.tranNumberService == null) {
            this.tranNumberService = new TranNumberServiceImpl(this.getContext());
        }
        return this.tranNumberService;
    }

    public void buildQueryFilter(Domain domain, SelectCommandInfo queryInfo) {
        HashSet<String> memberSets = new HashSet<String>(16);
        ITranNumberService service = this.getTranNumberService();
        for (IDimension d : domain.getDimensions()) {
            for (IDimMember m : d.getMembers()) {
                if (m == null || m.isTemp() || !StringUtils.isNotEmpty((CharSequence)m.getNumber())) continue;
                memberSets.add(service.getTranNumber(m));
            }
            if (!CollectionUtils.isNotEmpty(memberSets)) continue;
            queryInfo.addFilter(d.getNumber(), memberSets.toArray(new String[0]));
            memberSets.clear();
        }
    }

    public void buildRowColQueryFilter(List<IHeaderInfo> headerInfos, SelectCommandInfo queryInfo, ISheetManager sm) {
        HashSet memberSets = new HashSet(16);
        ITranNumberService service = this.getTranNumberService();
        HashMap<String, IDimMember> dim2FilterMembs = new HashMap<String, IDimMember>(16);
        if (sm.getFilterView().getFilterDomain() != null) {
            for (IDimension dimension : sm.getFilterView().getFilterDomain().getDimensions()) {
                for (IDimMember member : dimension.getMembers()) {
                    dim2FilterMembs.put(dimension.getNumber(), member);
                }
            }
        }
        headerInfos.forEach(h -> {
            List headerObjects;
            if (h.isDimension() && CollectionUtils.isNotEmpty((Collection)(headerObjects = h.getHeaderObjects()))) {
                String dimNum = h.getNumber();
                IDimMember filterMember = (IDimMember)dim2FilterMembs.get(dimNum);
                headerObjects.forEach(ho -> {
                    if (ho == null) {
                        return;
                    }
                    if (ho.getObject("istemp") != null) {
                        return;
                    }
                    if (StringUtils.isNotEmpty((CharSequence)ho.getNumber())) {
                        if ("$Cur".equals(ho.getNumber())) {
                            if (filterMember != null) {
                                memberSets.add(service.getTranNumber(filterMember));
                            }
                        } else {
                            memberSets.add(service.getTranNumber(dimNum, ho));
                        }
                    }
                });
                if (CollectionUtils.isNotEmpty((Collection)memberSets)) {
                    queryInfo.addFilter(dimNum, memberSets.toArray(new String[0]));
                    memberSets.clear();
                }
            }
        });
    }

    public HashMultimap<IDataAreaSetting, Tuple<List<String>, Object>> collectMDCellValue(ISheetManager sm) {
        HashMultimap kvMaps = HashMultimap.create();
        ISheet sheet = sm.getSheet();
        ITranNumberService service = this.getTranNumberService();
        sm.getAreaRanges().forEach(m -> {
            if (m.isRelation()) {
                kvMaps.put(m, null);
                return;
            }
            ReportMDDataHelper.filterNotExitMembs((IDataAreaSetting)m, (ReportContext)this.getContext());
            HashMap rowColMap = new HashMap(16);
            Map delFloatValues = m.getDelFloatValues();
            if (!ReportMDDataHelper.filterIHeaderInfo((List)m.getRowHeaders(), rowColMap) || !ReportMDDataHelper.filterIHeaderInfo((List)m.getColHeaders(), rowColMap)) {
                return;
            }
            RangeModel dataRangeMode = new RangeModel(m.getAreaRange());
            ArrayList fDataRangeModels = new ArrayList(16);
            m.getFloatInfos().forEach(f -> fDataRangeModels.add(new QuickFloatBean(m, f).getFloatDataRange()));
            sheet.iteratorRangeCells(dataRangeMode, cell -> {
                Object val;
                List<String> rowColDimMembs;
                boolean isFloat = fDataRangeModels.stream().anyMatch(p -> p.checkIsInArea(cell.getRow(), cell.getCol()));
                if ((isFloat || cell.isChangeVal()) && CollectionUtils.isNotEmpty(rowColDimMembs = TranNumberHelper.getRowColDimMembs(service, m, cell.getRow(), cell.getCol())) && (SpreadDataModelUtil.notEquals(val = delFloatValues.remove(rowColDimMembs), (Variant)cell.getVariant()) || !isFloat && cell.isChangeVal())) {
                    kvMaps.put(m, (Object)Tuple.newOne(rowColDimMembs, (Object)cell.getValue()));
                }
            });
            if (MapUtils.isNotEmpty((Map)delFloatValues)) {
                delFloatValues.forEach((k, v) -> kvMaps.put(m, (Object)Tuple.newOne((Object)k, null)));
            }
        });
        return kvMaps;
    }

    @Override
    public Table<Integer, Integer, Object> updateCellValues(ISheetManager sm, RangeModel rangeModel, Map<String, Map<String, Object>> allCellSets, boolean packData) {
        HashBasedTable table = HashBasedTable.create();
        ISheet sheet = sm.getSheet();
        if (rangeModel != null) {
            Map<String, IDataAreaSetting> map = sm.getAreaRanges().stream().collect(Collectors.toMap(IDataAreaSetting::getOriginalAreaRange, v -> v));
            allCellSets.forEach((arg_0, arg_1) -> this.lambda$updateCellValues$13(map, rangeModel, packData, (Table)table, sheet, arg_0, arg_1));
        } else {
            sm.getAreaRanges().forEach(arg_0 -> this.lambda$updateCellValues$14(allCellSets, packData, (Table)table, sheet, arg_0));
        }
        return table;
    }

    private void setCellValue(boolean packData, Table<Integer, Integer, Object> table, ISheet sheet, IDataAreaSetting m, Map<String, Object> cellSets, List<RangeModel> rangeModels, int y, int x) {
        boolean isFloat = false;
        if (CollectionUtils.isNotEmpty(rangeModels)) {
            for (RangeModel p : rangeModels) {
                if (!(FloatTypeEnum.ROW == m.getFloatOnWhere() ? p.isRowInArea(y) : p.isColInArea(x))) continue;
                isFloat = true;
                break;
            }
        }
        this.updateSingleCellValue(packData, m, y, x, cellSets, sheet, table, isFloat);
    }

    private void updateSingleCellValue(boolean packdata, IDataAreaSetting m, int y, int x, Map<String, Object> cellSets, ISheet sheet, Table<Integer, Integer, Object> table, boolean isFloat) {
        Cell cell;
        List<String> membs = TranNumberHelper.getRowColDimMembs(this.getTranNumberService(), m, y, x);
        String combineKey = null;
        if (CollectionUtils.isNotEmpty(membs)) {
            combineKey = TranNumberHelper.getCombineKey(membs);
        }
        Object value = null;
        if (StringUtils.isNotEmpty((CharSequence)combineKey)) {
            value = cellSets.get(combineKey);
        }
        if ((cell = sheet.getCell(y, x, value != null)) != null) {
            if (packdata) {
                if (value != null) {
                    table.put((Object)y, (Object)x, value);
                }
            } else {
                cell.setValue(value);
                if (value != null && isFloat) {
                    m.addDelFloatValue(membs, value);
                }
            }
        }
    }

    public VerifyResult verifyFloatData(ISheetManager sm) {
        VerifyResult vr = null;
        for (IDataAreaSetting m : sm.getAreaRanges()) {
            if (m.isRelation()) {
                vr = this.verifyRelationData(sm, m);
            } else if (CollectionUtils.isNotEmpty((Collection)m.getFloatInfos())) {
                vr = this.verifyDimFloatData(sm, m);
            }
            if (vr == null || vr.isEmpty()) continue;
            return vr;
        }
        return vr;
    }

    public VerifyResult verifyDimFloatData(ISheetManager sm, IDataAreaSetting m) {
        VerifyResult verifyResult = new VerifyResult();
        for (IFloatInfo f : m.getFloatInfos()) {
            List<Integer> notCompleteMemRC = FloatLogicHelper.getHasValueNotCompleteMemRC(sm, m, f);
            if (!CollectionUtils.isNotEmpty(notCompleteMemRC)) continue;
            verifyResult.addVerifyMsg(ResManager.loadKDString((String)"\u6570\u636e\u533a\u57df\u3010%1$s\u3011\u4e2d%2$s\u8bf7\u8f93\u5165\u6d6e\u52a8\u6210\u5458\uff0c\u5426\u5219\u8be5\u6570\u636e\u4e0d\u4f1a\u5b58\u50a8\u3002", (String)"MDDataHandlerServiceImpl_1", (String)"epm-emr-formplugin", (Object[])new Object[]{m.getAreaRange(), ExcelUtils.spiltToExcelIndex(notCompleteMemRC, (FloatTypeEnum.ROW == f.getFloatType() ? 1 : 0) != 0).toString()}));
            return verifyResult;
        }
        return verifyResult;
    }

    public VerifyResult verifyRelationData(ISheetManager sm, IDataAreaSetting m) {
        VerifyResult vr = new VerifyResult();
        RelationAreaInfo raInfo = m.getRelationAreaInfo();
        List cols = raInfo.getCols();
        RangeModel rangeModel = new RangeModel(m.getAreaRange());
        List colHeaders = m.getColHeaders();
        RelationModelBean relationModel = this.getRelationModel(raInfo.getRelationModel());
        List mustInputFields = relationModel.getMustInputFields();
        List uniqueCheckNums = relationModel.getUniqueCheckNums();
        int firstCol = rangeModel.getX_start();
        ISheet sheet = sm.getSheet();
        HashMap rowMaps = new HashMap(16);
        Map fieldBeanMap = relationModel.getFieldBeanMap();
        int endCol = firstCol + colHeaders.size() - 1;
        for (int i = rangeModel.getY_start(); i <= rangeModel.getY_end(); ++i) {
            ArrayList uniqueVals = new ArrayList(16);
            HashMap<String, Object> valMap = new HashMap<String, Object>(16);
            boolean isExitData = false;
            for (int j = firstCol; j <= endCol; ++j) {
                String colNum = (String)cols.get(j - firstCol);
                IHeaderInfo headerInfo = (IHeaderInfo)colHeaders.get(j - firstCol);
                Cell cell = sheet.getCell(i, j, false);
                Object val = null;
                if (headerInfo.isDimension()) {
                    IHeaderObject ho = (IHeaderObject)headerInfo.getHeaderObjects().get(i - rangeModel.getY_start());
                    if (ho != null && StringUtils.isNotEmpty((CharSequence)ho.getNumber())) {
                        val = ho.getNumber();
                    }
                } else if (cell != null) {
                    val = cell.getValue();
                }
                valMap.put(colNum, val);
                isExitData = valMap.entrySet().stream().anyMatch(e -> e.getValue() != null && StringUtils.isNotEmpty((CharSequence)e.getValue().toString()));
            }
            if (!isExitData) continue;
            for (Map.Entry entry : valMap.entrySet()) {
                String k = (String)entry.getKey();
                Object v = entry.getValue();
                if (v == null && mustInputFields.contains(k)) {
                    FieldBean fieldBean = (FieldBean)fieldBeanMap.get(k);
                    if (fieldBean != null) {
                        vr.addVerifyMsg(String.format(ResManager.loadKDString((String)"\u6570\u636e\u533a\u57df\u3010%1$s\u3011\u4e2d\u7684\u5b57\u6bb5\u3010%2$s\u3011\u662f\u5fc5\u5f55\u9879\uff0c\u8bf7\u8865\u5145\u5b8c\u6574\u4fe1\u606f\u540e\u518d\u4fdd\u5b58\u3002", (String)"MDDataHandlerServiceImpl_2", (String)"epm-emr-formplugin", (Object[])new Object[0]), rangeModel.getAreaRangeStr(), String.join((CharSequence)"|", fieldBean.getNumber(), fieldBean.getName())));
                    }
                    return vr;
                }
                if (v == null) continue;
                try {
                    v = this.getValveFromCell(relationModel.getFieldBeanMap(), k, v, rangeModel.getAreaRangeStr());
                    if (!uniqueCheckNums.contains(k)) continue;
                    uniqueVals.add(v);
                }
                catch (Exception e2) {
                    vr.addVerifyMsg(e2.getMessage());
                    return vr;
                }
            }
            if (!CollectionUtils.isNotEmpty(uniqueVals)) continue;
            Integer index = (Integer)rowMaps.get(uniqueVals);
            if (index != null) {
                vr.addVerifyMsg(String.format(ResManager.loadKDString((String)"\u6570\u636e\u533a\u57df\u3010%1$s\u3011\u5b58\u5728\u91cd\u590d\u884c\uff1a\u884c%2$s\uff0c\u884c%3$s\uff1b\u8bf7\u8c03\u6574\u3002", (String)"MDDataHandlerServiceImpl_3", (String)"epm-emr-formplugin", (Object[])new Object[0]), rangeModel.getAreaRangeStr(), index + 1, i + 1));
                return vr;
            }
            rowMaps.put(uniqueVals, i);
        }
        return vr;
    }

    private /* synthetic */ void lambda$updateCellValues$14(Map allCellSets, boolean packData, Table table, ISheet sheet, IDataAreaSetting m) {
        m.getDelFloatValues().clear();
        Map cellSets = (Map)allCellSets.get(m.getOriginalAreaRange());
        if (cellSets == null) {
            return;
        }
        HashMap rowColMap = new HashMap(16);
        if (!ReportMDDataHelper.filterIHeaderInfo((List)m.getRowHeaders(), rowColMap) || !ReportMDDataHelper.filterIHeaderInfo((List)m.getColHeaders(), rowColMap)) {
            return;
        }
        List rangeModels = m.getFloatDataRangeModels();
        RangeModel dataRangeMode = new RangeModel(m.getAreaRange());
        for (int y = dataRangeMode.getY_start(); y <= dataRangeMode.getY_end(); ++y) {
            for (int x = dataRangeMode.getX_start(); x <= dataRangeMode.getX_end(); ++x) {
                this.setCellValue(packData, (Table<Integer, Integer, Object>)table, sheet, m, cellSets, rangeModels, y, x);
            }
        }
    }

    private /* synthetic */ void lambda$updateCellValues$13(Map map, RangeModel rangeModel, boolean packData, Table table, ISheet sheet, String key, Map value) {
        IDataAreaSetting dataAreaSetting = (IDataAreaSetting)map.get(key);
        if (dataAreaSetting == null) {
            return;
        }
        dataAreaSetting.getDelFloatValues().clear();
        RangeModel dataRange = new RangeModel(dataAreaSetting.getAreaRange());
        List rangeModels = dataAreaSetting.getFloatDataRangeModels();
        for (int y = rangeModel.getY_start(); y <= rangeModel.getY_end(); ++y) {
            if (!dataRange.isRowInArea(y)) continue;
            for (int x = rangeModel.getX_start(); x <= rangeModel.getX_end(); ++x) {
                if (!dataRange.isColInArea(x)) continue;
                this.setCellValue(packData, (Table<Integer, Integer, Object>)table, sheet, dataAreaSetting, value, rangeModels, y, x);
            }
        }
    }
}

