/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.report.multi;

import java.util.Iterator;
import kd.bos.form.IPageCache;
import kd.bos.util.StringUtils;
import kd.epm.emr.formplugin.report.multi.IReportTabModelDataProvider;
import kd.epm.emr.formplugin.report.multi.ReportTabInfo;
import kd.epm.emr.formplugin.report.multi.ReportTabManager;
import kd.epm.emr.formplugin.report.multi.ReportTabModel;
import kd.epm.epbs.common.util.ObjectSerialUtil;

public class ReportCacheService {
    private IPageCache cache;
    private IReportTabModelDataProvider dataProvider;
    private static final String KEY_TAB_MANAGER = "KEY_TAB_MANAGER";

    public ReportCacheService(IPageCache cache, IReportTabModelDataProvider dataProvider) {
        this.cache = cache;
        this.dataProvider = dataProvider;
    }

    public ReportTabModel getReportTabModel(ReportTabInfo tab) {
        String serial = this.cache.get(tab.getTabKey());
        ReportTabModel ci = null;
        if (StringUtils.isNotEmpty((String)serial)) {
            ci = (ReportTabModel)ObjectSerialUtil.deSerializedBytes((String)serial);
            ci.setPageCache(this.cache);
        } else {
            ci = this.queryAndCache(tab);
        }
        return ci;
    }

    public ReportTabModel getReportModelByForce(ReportTabInfo tab) {
        return this.queryAndCache(tab);
    }

    public ReportTabModel queryAndCache(ReportTabInfo tab) {
        ReportTabModel ci = this.dataProvider.query4Cache(tab, this.cache);
        this.cacheReportTabModel(ci);
        return ci;
    }

    public void cacheReportTabModel(ReportTabModel item) {
        item.lightCache();
    }

    public void cacheReportTabInfoManager(ReportTabManager manager) {
        this.cache.put(KEY_TAB_MANAGER, ObjectSerialUtil.toByteSerialized((Object)manager));
    }

    public ReportTabManager getReportTabInfoManager() {
        String serial = this.cache.get(KEY_TAB_MANAGER);
        if (StringUtils.isNotEmpty((String)serial)) {
            return (ReportTabManager)ObjectSerialUtil.deSerializedBytes((String)serial);
        }
        return null;
    }

    public void releaseTabManager(ReportTabManager m) {
        Iterator<ReportTabInfo> it = m.iterator();
        while (it.hasNext()) {
            this.release(it.next().getTabKey());
        }
        this.cache.remove(KEY_TAB_MANAGER);
    }

    public void release(String ... cacheKeys) {
        for (String k : cacheKeys) {
            this.cache.remove(k);
        }
    }
}

