/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.report.multi;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.epm.emr.formplugin.report.multi.ReportModelTypeEnum;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.ToStringHelper;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ReportTabInfo
implements Serializable {
    private static final long serialVersionUID = -8065859910169822267L;
    private String tabKey;
    private String tabName;
    private Object reportId;
    private Object templateId;
    private ReportModelTypeEnum modelType = ReportModelTypeEnum.TEMPLATE;
    private boolean isSelected = false;
    private Map<String, Map<String, Object>> pageViewFilterCache = new HashMap<String, Map<String, Object>>();
    private Map<String, Map<String, Object>> commonParams = new HashMap<String, Map<String, Object>>();
    private Map<String, Object> reportListRecordInfo = null;
    private boolean isReportListRecordModified = false;
    private String sourcetype = "";
    private int selRow = -1;
    private int selCol = -1;
    private boolean isSaveDim = false;
    private boolean isOnlyRead = false;

    public ReportTabInfo(String tabKey, String tabName, Object reportId, Object templateId) {
        this.tabKey = tabKey;
        this.tabName = tabName;
        this.reportId = reportId;
        this.templateId = templateId;
    }

    public ReportTabInfo(String tabKey, String tabName, Object reportId, Object templateId, ReportModelTypeEnum modelType) {
        this(tabKey, tabName, reportId, templateId);
        this.modelType = modelType;
    }

    public void setSourcetype(String sourcetype) {
        this.sourcetype = sourcetype;
    }

    public void putFilter(String key, Map<String, Object> value) {
        this.pageViewFilterCache.put(key, value);
    }

    public void removeFilter(String key) {
        this.pageViewFilterCache.remove(key);
    }

    public void putCommonParam(String key, Map<String, Object> value) {
        this.commonParams.put(key, value);
    }

    public Map<String, Object> getCommonParamByKey(String key) {
        return this.commonParams.get(key);
    }

    public Iterator<Map.Entry<String, Map<String, Object>>> filterIterator() {
        return this.pageViewFilterCache.entrySet().iterator();
    }

    public boolean containsFilterKey(String key) {
        return this.pageViewFilterCache.containsKey(key);
    }

    public Map<String, Object> getFilterVal(String key) {
        return this.pageViewFilterCache.get(key);
    }

    public String getTabName() {
        return this.tabName;
    }

    public void setTabName(String tabName) {
        this.tabName = tabName;
    }

    public String getTabKey() {
        return this.tabKey;
    }

    public void setTabKey(String tabKey) {
        this.tabKey = tabKey;
    }

    public Object getReportId() {
        return this.reportId;
    }

    public void setReportId(Object reportId) {
        this.reportId = reportId;
    }

    public ReportModelTypeEnum getModelType() {
        return this.modelType;
    }

    public Object getTemplateId() {
        return this.templateId;
    }

    public void setTemplateId(Object templateId) {
        this.templateId = templateId;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    public String toString() {
        return ToStringHelper.reflectionToString((Object)this);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.tabKey).toHashCode();
    }

    public boolean equals(Object obj) {
        boolean isEquals = false;
        if (obj instanceof ReportTabInfo) {
            ReportTabInfo o = (ReportTabInfo)obj;
            isEquals = new EqualsBuilder().append((Object)this.tabKey, (Object)o.getTabKey()).isEquals();
        }
        return isEquals;
    }

    public void setReportListStatus(String status) {
        this.setReportListInfo("reportstatus", status);
    }

    public void setReportListModifier(Long userId) {
        this.setReportListInfo("modifier", userId);
    }

    public void setReportListId(Long rptListId) {
        this.getListRecordInfo().put("id", rptListId);
    }

    public void setReportListModifytime(Date modifytime) {
        this.setReportListInfo("modifytime", modifytime);
    }

    public void setReportListInfo(String key, Object v) {
        if (this.reportListRecordInfo == null || !this.reportListRecordInfo.containsKey("id")) {
            return;
        }
        this.getListRecordInfo().put(key, v);
        this.isReportListRecordModified = true;
    }

    public void setReportListRptId(Object v) {
        this.setReportListInfo("report", v);
    }

    public Map<String, Object> getListRecordInfo() {
        if (this.reportListRecordInfo == null) {
            this.reportListRecordInfo = new HashMap<String, Object>();
        }
        return this.reportListRecordInfo;
    }

    public boolean isModifiedReportListRecord() {
        return this.isReportListRecordModified;
    }

    public boolean hasPageFilterCache() {
        return !this.pageViewFilterCache.isEmpty();
    }

    public void setSelectCell(int selRow, int selCol) {
        this.selRow = selRow;
        this.selCol = selCol;
    }

    public int getSelRow() {
        return this.selRow;
    }

    public int getSelCol() {
        return this.selCol;
    }

    public String getPageViewFilterString() {
        return ObjectSerialUtil.toByteSerialized(this.pageViewFilterCache);
    }

    public void revertPageViewFromString(String cacheStr) {
        if (StringUtils.isNotEmpty((String)cacheStr)) {
            this.pageViewFilterCache = (Map)ObjectSerialUtil.deSerializedBytes((String)cacheStr);
        }
    }

    public boolean isSaveDim() {
        return this.isSaveDim;
    }

    public void setSaveDim(boolean saveDim) {
        this.isSaveDim = saveDim;
    }

    public boolean isOnlyRead() {
        return this.isOnlyRead;
    }

    public void setOnlyRead(boolean onlyRead) {
        this.isOnlyRead = onlyRead;
    }
}

