/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.report.multi;

import java.io.Serializable;
import kd.bos.cache.ThreadCache;
import kd.bos.form.IPageCache;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.ITemplateModel;
import kd.epm.emr.business.template.TemplateInfo;
import kd.epm.emr.business.template.TemplateModelJSONUtil;
import kd.epm.emr.business.template.service.ITemplateMemberService;
import kd.epm.emr.business.template.service.impl.TemplateMemberServiceImpl;
import kd.epm.emr.business.template.service.impl.TemplateServiceImpl;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.ObjectSerialUtil;

public class ReportTabModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SPREAD_SERIAL = "_spreadserial";
    public static final String SPREAD_JSON = "_spreadjson";
    public static final String ORI_SPREAD_SERIAL = "_ori_spreadserial";
    public static final String REPORT_TAB_MODEL = "report_tab_model";
    private transient ISheetManager sm;
    private transient ITemplateModel templateModel;
    private String cacheKey;
    private transient String spreadJson;
    private transient String initSheetManagerSerial;
    private transient IPageCache cache;
    private transient boolean isOverWriteOriginalData = false;
    private Long templateId;
    public static final String TEMPLATE_CLASS = "templateClass";
    public static final String TEMPLATE_MEMBER_SERVICE_CLASS = "templateMemberServiceClass";

    public ReportTabModel(String cacheKey, IPageCache cache) {
        this.cacheKey = cacheKey;
        this.cache = cache;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setPageCache(IPageCache cache) {
        this.cache = cache;
    }

    public void setSheetManager(ISheetManager sm) {
        this.sm = sm;
    }

    public <T extends TemplateInfo> ITemplateModel getTemplateModel() {
        if (this.templateModel == null) {
            ITemplateMemberService templateMemberService = TemplateMemberServiceImpl.newInstance((String)this.cache.get(TEMPLATE_MEMBER_SERVICE_CLASS), (Long)IDUtils.toLong((Object)this.cache.get("KEY_MODEL_ID")));
            this.templateModel = TemplateServiceImpl.getInstance((ITemplateMemberService)templateMemberService).getTemplateModel(this.cache.get(TEMPLATE_CLASS), this.templateId);
        }
        return this.templateModel;
    }

    public void setTemplateModel(ITemplateModel templateModel) {
        this.templateModel = templateModel;
        this.templateId = templateModel.getTemplateBaseInfo().getId();
    }

    public void setSpreadJson(String spreadJson) {
        this.spreadJson = spreadJson;
    }

    public void setSpreadJson(String spreadJson, ISheetManager spread) {
        this.spreadJson = spreadJson;
        this.setInitSheetManagerSerial(TemplateModelJSONUtil.toJsonSheetManager((ISheetManager)spread));
        this.isOverWriteOriginalData = true;
    }

    public void setSpreadJson(String spreadJson, String spread) {
        this.spreadJson = spreadJson;
        this.setInitSheetManagerSerial(spread);
        this.isOverWriteOriginalData = true;
    }

    public void initReportTabModel(String spreadJson, String spread, ISheetManager psm, boolean isOverWriteOriginalData) {
        this.spreadJson = spreadJson;
        this.isOverWriteOriginalData = isOverWriteOriginalData;
        this.sm = psm == null ? TemplateModelJSONUtil.parseSheetManager((String)spread) : psm;
        if (this.sm.getFilterView() != null) {
            this.sm.setFilterView(null);
            spread = TemplateModelJSONUtil.toJsonSheetManager((ISheetManager)this.sm);
        }
        this.setInitSheetManagerSerial(spread);
    }

    public void setInitSheetManagerSerial(String initSheetManagerSerial) {
        this.initSheetManagerSerial = initSheetManagerSerial;
    }

    public ISheetManager getSheetManager() {
        if (this.sm == null) {
            String spreadSerial = this.cache.get(this.getCacheKey() + SPREAD_SERIAL);
            this.sm = spreadSerial != null ? TemplateModelJSONUtil.parseSheetManager((String)spreadSerial) : TemplateModelJSONUtil.parseSheetManager((String)this.getOriginalSheetManagerSerial());
        }
        return this.sm;
    }

    private String getOriginalSheetManagerSerial() {
        if (this.initSheetManagerSerial == null) {
            this.initSheetManagerSerial = this.cache.get(this.getCacheKey() + ORI_SPREAD_SERIAL);
            if (StringUtils.isEmpty((String)this.initSheetManagerSerial)) {
                this.initSheetManagerSerial = this.getTemplateModel().getTemplateBaseInfo().getData();
            }
        }
        return this.initSheetManagerSerial;
    }

    public String getSpreadJson() {
        if (this.spreadJson == null) {
            this.spreadJson = this.cache.get(this.getCacheKey() + SPREAD_JSON);
            if (StringUtils.isEmpty((String)this.spreadJson)) {
                this.spreadJson = this.getTemplateModel().getTemplateBaseInfo().getSpreadJson();
            }
        }
        return this.spreadJson;
    }

    public void reInitSheetManager() {
        ISheetManager initSm = TemplateModelJSONUtil.parseSheetManager((String)this.getOriginalSheetManagerSerial());
        initSm.setFilterView(this.getSheetManager().getFilterView());
        this.sm = initSm;
    }

    public void cache() {
        ThreadCache.put((Object)(REPORT_TAB_MODEL + this.cacheKey), (Object)this);
        this.cache.put(this.getCacheKey(), ObjectSerialUtil.toByteSerialized((Object)this));
        if (this.isOverWriteOriginalData) {
            if (this.initSheetManagerSerial != null) {
                this.cache.put(this.getCacheKey() + ORI_SPREAD_SERIAL, this.initSheetManagerSerial);
            }
            if (this.spreadJson != null) {
                this.cache.put(this.getCacheKey() + SPREAD_JSON, this.spreadJson);
            }
        }
        if (this.sm != null) {
            this.cache.put(this.getCacheKey() + SPREAD_SERIAL, TemplateModelJSONUtil.toJsonSheetManager((ISheetManager)this.sm));
        }
    }

    public void lightCache() {
        this.cache.put(this.getCacheKey(), ObjectSerialUtil.toByteSerialized((Object)this));
    }
}

