/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.rules;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.emr.business.rules.utils.RuleSaveHelper;
import kd.epm.emr.common.tree.RuleCategoryTreeBuilder;
import kd.epm.epbs.business.bd.model.ModelF7ParamContext;
import kd.epm.epbs.business.permission.util.DynamicObjectUtils;
import kd.epm.epbs.business.rules.models.RuleBean;
import kd.epm.epbs.business.rules.support.RuleUtil;
import kd.epm.epbs.business.userSelect.UserQuerySelectHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.OperationTypeInfo;
import kd.epm.epbs.common.constant.RuleConstant;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.enums.RuleStatusEnum;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import kd.epm.epbs.common.tree.DynamicTreeContext;
import kd.epm.epbs.common.util.JSONUtils;
import kd.epm.epbs.common.util.TXUtils;
import kd.epm.epbs.formplugin.treelist.AbstractTreeListF7Plugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.NotNull;

public class EmrRuleListPlugin
extends AbstractTreeListF7Plugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.getTreeView().addTreeNodeClickListener((TreeNodeClickListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("domain");
        if (null != basedataEdit) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"btn_addnew", "btn_edit", "btn_delete"});
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        super.beforeF7Select(event);
        if (this.getModelId() == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9'\u4f53\u7cfb'\u3002", (String)"EmrRuleListPlugin_0", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            event.setCancel(true);
        } else {
            Control control = (Control)event.getSource();
            if ("domain".equals(control.getKey())) {
                event.addCustomQFilter(new QFilter("model", "=", (Object)this.getModelId()));
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.beforeItemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar_new": {
                if ("2003687597250984960".equals(this.getSelectCategoryId())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5728\u81ea\u5b9a\u4e49\u5206\u7c7b\u4e0b\u65b0\u589e\u4e1a\u52a1\u89c4\u5219\u3002", (String)"EmrRuleListPlugin_1", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                boolean passed = this.checkNotNull();
                if (!passed) {
                    evt.setCancel(true);
                    return;
                }
                Map<String, Object> focusNode = this.getFocusCategoryNode();
                if (focusNode != null && !((Boolean)focusNode.get("isParent")).booleanValue()) break;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u5206\u7c7b\u8282\u70b9\u65b0\u589e\u89c4\u5219\u3002", (String)"EmrRuleListPlugin_2", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            case "bar_copy": {
                this.checkBeforeOperate(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u590d\u5236\u7684\u89c4\u5219\u3002", (String)"EmrRuleListPlugin_3", (String)"epm-emr-formplugin", (Object[])new Object[0]), evt);
                break;
            }
            case "bar_enable": {
                this.checkBeforeOperate(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u751f\u6548\u7684\u89c4\u5219\u3002", (String)"EmrRuleListPlugin_4", (String)"epm-emr-formplugin", (Object[])new Object[0]), evt);
                break;
            }
            case "bar_disable": {
                this.checkBeforeOperate(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u5931\u6548\u7684\u89c4\u5219\u3002", (String)"EmrRuleListPlugin_5", (String)"epm-emr-formplugin", (Object[])new Object[0]), evt);
                break;
            }
            case "bar_delete": {
                this.checkBeforeOperate(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8981\u5220\u9664\u7684\u89c4\u5219\u3002", (String)"EmrRuleListPlugin_6", (String)"epm-emr-formplugin", (Object[])new Object[0]), evt);
            }
        }
    }

    private void checkBeforeOperate(String s, BeforeItemClickEvent evt) {
        if (CollectionUtils.isEmpty(this.selectedRules())) {
            this.getView().showTipNotification(s);
            evt.setCancel(true);
        }
    }

    private boolean checkNotNull() {
        if (this.getModel().getValue("model") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9'\u4f53\u7cfb'\u3002", (String)"EmrRuleListPlugin_0", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.getModel().getValue("domain") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9'\u4e1a\u52a1\u6a21\u578b'\u3002", (String)"EmrRuleListPlugin_7", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        OperationTypeEnum operationType = null;
        switch (itemKey) {
            case "bar_new": {
                operationType = OperationTypeEnum.ADD;
                FormShowParameter formShowParameter = this.initFormShowParameter();
                formShowParameter.setStatus(OperationStatus.ADDNEW);
                Map<String, Object> focusNode = this.getFocusCategoryNode();
                formShowParameter.setCustomParam("categoryName", focusNode.get("text"));
                formShowParameter.setCustomParam("categoryId", focusNode.get("id"));
                formShowParameter.setCustomParam("rulesource", (Object)RuleStatusEnum.RuleSourceTypeEnum.MANUAL.getValue());
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bar_new"));
                this.getView().showForm(formShowParameter);
                break;
            }
            case "bar_refresh": {
                this.initTree();
                this.refresh();
                break;
            }
            case "bar_delete": {
                operationType = OperationTypeEnum.DELETE;
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u8ba4\u5220\u9664\uff1f", (String)"EmrRuleListPlugin_8", (String)"epm-emr-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("bar_delete", (IFormPlugin)this));
                break;
            }
            case "bar_copy": {
                operationType = OperationTypeEnum.COPY;
                DynamicObjectCollection ruleDys = QueryServiceHelper.query((String)"emr_rule_entity", (String)"number,sequence", (QFilter[])new QFilter("model", "=", (Object)this.getModelId()).and("domain", "=", this.getValue("domain_id")).toArray());
                List numbers = ruleDys.stream().map(dy -> dy.getString("number")).collect(Collectors.toList());
                int count = ruleDys.stream().map(dy -> dy.getInt("sequence")).max(Integer::compareTo).orElse(0);
                DynamicObject[] sourceRules = BusinessDataServiceHelper.load((Object[])this.selectedRules().toArray(), (DynamicObjectType)this.getBillList().getEntityType());
                ArrayList<DynamicObject> newRules = new ArrayList<DynamicObject>();
                HashMap<Long, Long> source2Target = new HashMap<Long, Long>();
                ArrayList<String> failedMessages = new ArrayList<String>(sourceRules.length);
                for (DynamicObject rule : sourceRules) {
                    DynamicObject newRuleDy = BusinessDataServiceHelper.newDynamicObject((String)"emr_rule_entity");
                    String number = rule.getString("number") + "copy";
                    if (RuleUtil.existNumber(numbers, (String)number)) {
                        failedMessages.add(String.format(ResManager.loadKDString((String)"'%1$s'\u89c4\u5219\u590d\u5236\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u7f16\u7801\u4e3a'%2$s'\u7684\u89c4\u5219\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u6267\u884c\u590d\u5236\u6216\u624b\u5de5\u65b0\u589e\u3002", (String)"EmrRuleListPlugin_9", (String)"epm-emr-formplugin", (Object[])new Object[0]), rule.getString("number"), number));
                        continue;
                    }
                    String name = String.format(ResManager.loadKDString((String)"%s\u590d\u5236", (String)"EmrRuleListPlugin_21", (String)"epm-emr-formplugin", (Object[])new Object[0]), rule.getString("name"));
                    if (number.length() > RuleConstant.MAX_NUMBER_LIMIT || name.length() > RuleConstant.MAX_NAME_LIMIT) {
                        failedMessages.add(String.format(ResManager.loadKDString((String)"'%s'\u89c4\u5219\u590d\u5236\u5931\u8d25\uff0c\u7f16\u7801\u6216\u540d\u79f0\u8d85\u8fc7\u6700\u5927\u5b57\u7b26\u6570\u91cf\u9650\u5236\uff0c\u8bf7\u8c03\u6574\u540e\u518d\u6267\u884c\u590d\u5236\u3002", (String)"EmrRuleListPlugin_11", (String)"epm-emr-formplugin", (Object[])new Object[0]), rule.getString("number")));
                        continue;
                    }
                    DynamicObjectUtils.copy((DynamicObject)rule, (DynamicObject)newRuleDy, (Set)Sets.newHashSet((Object[])new String[]{"id", "creator", "createtime", "modifier", "modifytime", "sequence", "entryentity.id", "segment_creator", "segment_createtime", "segment_modifier", "segment_modifytime"}));
                    newRuleDy.set("id", (Object)DB.genGlobalLongId());
                    newRuleDy.set("number", (Object)number);
                    newRuleDy.set("name", (Object)name);
                    newRuleDy.set("sequence", (Object)(++count));
                    newRuleDy.set("creator", (Object)RequestContext.get().getCurrUserId());
                    newRuleDy.getDynamicObjectCollection("entryentity").forEach(dy -> dy.set("segment_creator", (Object)RequestContext.get().getCurrUserId()));
                    source2Target.put(rule.getLong("id"), newRuleDy.getLong("id"));
                    newRules.add(newRuleDy);
                }
                if (CollectionUtils.isEmpty(failedMessages)) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"EmrRuleListPlugin_12", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                } else if (failedMessages.size() < sourceRules.length) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u90e8\u5206\u6210\u529f\uff0c\u5b58\u5728\u5931\u8d25\u8bb0\u5f55\u3002\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"EmrRuleListPlugin_22", (String)"epm-emr-formplugin", (Object[])new Object[0]), String.join((CharSequence)System.lineSeparator(), failedMessages)));
                } else {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u590d\u5236\u5931\u8d25\u3002\u9519\u8bef\u4fe1\u606f\uff1a%s", (String)"EmrRuleListPlugin_23", (String)"epm-emr-formplugin", (Object[])new Object[0]), String.join((CharSequence)System.lineSeparator(), failedMessages)));
                }
                DynamicObject[] ruleAssignDys = BusinessDataServiceHelper.load((String)"emr_rule_assigncategory", (String)"rule,categoryentity,category", (QFilter[])new QFilter("rule", "in", this.selectedRules()).and("category", "in", this.getCategoryIds()).toArray());
                ArrayList<DynamicObject> newRuleAssigns = new ArrayList<DynamicObject>(ruleAssignDys.length);
                for (DynamicObject ruleAssignDy : ruleAssignDys) {
                    DynamicObject newRuleAssignDy = BusinessDataServiceHelper.newDynamicObject((String)"emr_rule_assigncategory");
                    DynamicObjectUtils.copy((DynamicObject)ruleAssignDy, (DynamicObject)newRuleAssignDy, (Set)Sets.newHashSet((Object[])new String[]{"id", "rule"}));
                    newRuleAssignDy.set("rule_id", source2Target.get(ruleAssignDy.getLong("rule_id")));
                    newRuleAssignDy.set("creator", (Object)RequestContext.get().getCurrUserId());
                    newRuleAssigns.add(newRuleAssignDy);
                }
                DynamicObject[] ruleAssignTemplateDys = BusinessDataServiceHelper.load((String)"emr_rule_assigntemplate", (String)"rule,template,templategroup,executetype", (QFilter[])new QFilter("rule", "in", this.selectedRules()).toArray());
                ArrayList<DynamicObject> newRuleAssignTemplates = new ArrayList<DynamicObject>(ruleAssignTemplateDys.length);
                for (DynamicObject ruleAssignTemplateDy : ruleAssignTemplateDys) {
                    DynamicObject newRuleAssignTemplateDy = BusinessDataServiceHelper.newDynamicObject((String)"emr_rule_assigntemplate");
                    DynamicObjectUtils.copy((DynamicObject)ruleAssignTemplateDy, (DynamicObject)newRuleAssignTemplateDy, (Set)Sets.newHashSet((Object[])new String[]{"id", "rule"}));
                    newRuleAssignTemplateDy.set("rule_id", source2Target.get(ruleAssignTemplateDy.getLong("rule_id")));
                    newRuleAssignTemplateDy.set("creator", (Object)RequestContext.get().getCurrUserId());
                    newRuleAssignTemplates.add(newRuleAssignTemplateDy);
                }
                TXUtils.required(tx -> {
                    SaveServiceHelper.save((DynamicObject[])newRules.toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])newRuleAssigns.toArray(new DynamicObject[0]));
                    SaveServiceHelper.save((DynamicObject[])newRuleAssignTemplates.toArray(new DynamicObject[0]));
                });
                this.refresh();
                break;
            }
            case "bar_enable": 
            case "bar_disable": {
                DynamicObject[] targetRules = BusinessDataServiceHelper.load((Object[])this.selectedRules().toArray(), (DynamicObjectType)this.getBillList().getEntityType());
                boolean isEnable = "bar_enable".equals(itemKey);
                for (DynamicObject rule : targetRules) {
                    rule.set("status", (Object)(isEnable ? RuleStatusEnum.ENABLE.getStatus() : RuleStatusEnum.DISABLE.getStatus()));
                    rule.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    rule.set("modifytime", (Object)new Date());
                }
                SaveServiceHelper.save((DynamicObject[])targetRules);
                if (isEnable) {
                    operationType = OperationTypeEnum.ENABLE;
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u751f\u6548\u6240\u9009\u7684\u4e1a\u52a1\u89c4\u5219\u3002", (String)"EmrRuleListPlugin_15", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                } else {
                    operationType = OperationTypeEnum.DISABLE;
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u5931\u6548\u6240\u9009\u7684\u4e1a\u52a1\u89c4\u5219\u3002", (String)"EmrRuleListPlugin_16", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                }
                this.refresh();
                break;
            }
            case "bar_order": {
                FormShowParameter dialog = new FormShowParameter();
                dialog.setFormId("emr_rule_sort");
                dialog.getOpenStyle().setShowType(ShowType.Modal);
                dialog.setCustomParam("modelid", this.getModel().getValue("model_id"));
                dialog.setCustomParam("domainid", this.getModel().getValue("domain_id"));
                dialog.setCustomParam("hidedisabled", this.getModel().getValue("hidedisabled"));
                dialog.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "set_order"));
                operationType = new OperationTypeInfo("order", new MultiLangEnumBridge("\u6392\u5e8f", "EmrRuleListPlugin_24", "epm-emr-formplugin"));
                this.getView().showForm(dialog);
                break;
            }
            case "bar_executelog": {
                IFormView view = this.getView();
                IFormView mainPageView = view.getMainView();
                ListShowParameter listShowParameter = new ListShowParameter();
                String pageId = this.getView().getPageId() + this.getModelId();
                if (mainPageView != null && mainPageView.getView(pageId) != null) {
                    IFormView childView = mainPageView.getView(pageId);
                    childView.activate();
                    view.sendFormAction(childView);
                    return;
                }
                listShowParameter.setPageId(pageId);
                listShowParameter.setFormId("emr_rule_execrecordlist");
                listShowParameter.setBillFormId("emr_rule_executerecord");
                listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                listShowParameter.setCustomParam("model", this.getModel().getValue("model_id"));
                this.getView().showForm((FormShowParameter)listShowParameter);
            }
        }
        if (operationType != null) {
            this.writeLog((IOperationTypeInfo)operationType, null);
        }
    }

    private FormShowParameter initFormShowParameter() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("emr_rule_edit");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("model", this.getModel().getValue("model_id"));
        formShowParameter.setCustomParam("domain", this.getModel().getValue("domain_id"));
        formShowParameter.setCustomParam("categoryEntity", (Object)"emr_rule_category");
        return formShowParameter;
    }

    private Map<String, Object> getFocusCategoryNode() {
        return ((TreeView)this.getView().getControl("treeviewap")).getTreeState().getFocusNode();
    }

    private void refresh() {
        this.getBillList().clearSelection();
        this.getBillList().refresh();
    }

    public void afterCreateNewData(EventObject e) {
        long modelId = UserQuerySelectHelper.getRandomModelId((ModelF7ParamContext)this.getModelF7Param());
        this.getModel().setValue("model", (Object)modelId);
        this.getModel().setValue("domain", (Object)UserQuerySelectHelper.getRandomDomainId((long)modelId));
        super.afterCreateNewData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("model".equals(name) || "domain".equals(name)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            Object oldValue = e.getChangeSet()[0].getOldValue();
            if (Objects.isNull(newValue)) {
                this.getModel().beginInit();
                this.getModel().setValue(name, oldValue);
                this.getModel().endInit();
            } else if ("model".equals(name)) {
                this.getModel().setValue("domain", (Object)UserQuerySelectHelper.getRandomDomainId((long)((DynamicObject)newValue).getLong("id")));
            }
            this.initTree();
            this.refresh();
        }
        if ("hidedisabled".equals(name)) {
            this.refresh();
        }
    }

    protected DynamicTreeContext getDynamicTreeContext() {
        DynamicTreeContext context = new DynamicTreeContext("emr_rule_entity");
        context.setFocusTreeId("2005063722162241536");
        context.setqFilters(new QFilter("model", "in", Arrays.asList(0L, this.getModel().getValue("model_id"))).toArray());
        return context;
    }

    protected AbstractTreeBuilder getTreeBuilder(DynamicTreeContext context) {
        return new RuleCategoryTreeBuilder(context);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        boolean passed = this.checkNotNull();
        if (!passed) {
            evt.setCancel(true);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        DynamicObjectCollection ruleAssignDys = QueryServiceHelper.query((String)"emr_rule_assigncategory", (String)"rule", (QFilter[])new QFilter("category", "in", this.getCategoryIds()).toArray());
        List ruleIds = ruleAssignDys.stream().map(dy -> dy.getLong("rule")).collect(Collectors.toList());
        e.getQFilters().add(new QFilter("id", "in", ruleIds).and("domain", "=", this.getValue("domain_id")));
        if (((Boolean)this.getModel().getValue("hidedisabled")).booleanValue()) {
            e.getQFilters().add(new QFilter("status", "=", (Object)RuleStatusEnum.ENABLE.getStatus()));
        }
        e.setOrderBy("sequence");
    }

    private List<Long> getCategoryIds() {
        TreeNode rootWithCache = AbstractTreeBuilder.getRootWithCache((TreeView)this.getTreeView());
        TreeNode treeNode = rootWithCache.getTreeNode(this.getSelectCategoryId());
        if (treeNode == null || !treeNode.isLeaf()) {
            return new ArrayList<Long>();
        }
        return Collections.singletonList(NumberUtils.toLong((String)treeNode.getId()));
    }

    private TreeView getTreeView() {
        return (TreeView)this.getControl("treeviewap");
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        this.checkOperationPerm("hyperclick");
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("number".equals(fieldName)) {
            args.setCancel(true);
            String pageId = this.getView().getPageId() + this.getFocusRowPkId();
            IFormView view = this.getView();
            IFormView mainPageView = view.getMainView();
            if (ObjectUtils.isEmpty((Object)mainPageView) || ObjectUtils.isEmpty((Object)mainPageView.getView(pageId))) {
                FormShowParameter formShowParameter = this.initFormShowParameter();
                formShowParameter.setStatus(OperationStatus.EDIT);
                formShowParameter.setPageId(pageId);
                Object focusRowPkId = this.getFocusRowPkId();
                DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"emr_rule_entity");
                DynamicObjectCollection ruleAssignDys = QueryServiceHelper.query((String)"emr_rule_assigncategory", (String)"category", (QFilter[])new QFilter("rule", "=", focusRowPkId).toArray());
                List categoryIds = ruleAssignDys.stream().map(ruleAssignDy -> ruleAssignDy.getLong("category")).collect(Collectors.toList());
                Long ruleCategoryId = 0L;
                for (Long categoryId : this.getCategoryIds()) {
                    if (!categoryIds.contains(categoryId)) continue;
                    ruleCategoryId = categoryId;
                    break;
                }
                String ruleCategoryName = AbstractTreeBuilder.getRootWithCache((TreeView)this.getTreeView()).getTreeNode("" + ruleCategoryId).getText();
                RuleBean ruleBean = RuleSaveHelper.fromDynamicObject((DynamicObject)rule);
                ruleBean.setCategoryName(ruleCategoryName);
                ruleBean.setCategoryId("" + ruleCategoryId);
                formShowParameter.setCustomParam("rule", (Object)JSONUtils.toString((Object)ruleBean));
                this.getView().showForm(formShowParameter);
            } else {
                IFormView childView = mainPageView.getView(pageId);
                childView.activate();
                view.sendFormAction(childView);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("bar_delete".equals(messageBoxClosedEvent.getCallBackId()) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            List<Long> selectedIds = this.selectedRules();
            DeleteServiceHelper.delete((String)"emr_rule_entity", (QFilter[])new QFilter[]{new QFilter("id", "in", selectedIds)});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u5220\u9664\u6240\u9009\u7684\u4e1a\u52a1\u89c4\u5219\u3002", (String)"EmrRuleListPlugin_17", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            this.refresh();
        }
    }

    @NotNull
    private List<Long> selectedRules() {
        return this.getBillList().getSelectedRows().stream().map(listSelectedRow -> NumberUtils.toLong((String)("" + listSelectedRow.getPrimaryKeyValue()))).collect(Collectors.toList());
    }

    public void beforeClick(BeforeClickEvent evt) {
        String key;
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_addnew": 
            case "btn_edit": 
            case "btn_delete": {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5bf9\u89c4\u5219\u5206\u7c7b\u6811\u7684\u7f16\u8f91\u64cd\u4f5c\u3002", (String)"EmrRuleListPlugin_18", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        String key = ((ColumnDesc)e.getSource()).getKey();
        if ("templates".equals(key)) {
            long id = e.getRowData().getLong("id");
            QFilter filter = new QFilter("rule", "=", (Object)id);
            DynamicObjectCollection assignTemplates = QueryServiceHelper.query((String)"emr_rule_assigntemplate", (String)"template.name", (QFilter[])filter.toArray());
            StringJoiner stringJoiner = new StringJoiner(",");
            assignTemplates.stream().map(dy -> dy.getString("template.name")).forEach(stringJoiner::add);
            e.setFormatValue((Object)stringJoiner.toString());
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btn_addnew": {
                BaseShowParameter formShowParameter = new BaseShowParameter();
                formShowParameter.setStatus(OperationStatus.ADDNEW);
                formShowParameter.setFormId("emr_rule_category");
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u81ea\u5b9a\u4e49\u89c4\u5219\u5206\u7c7b", (String)"EmrRuleListPlugin_19", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                StyleCss styleCss = new StyleCss();
                styleCss.setWidth("600px");
                styleCss.setHeight("400px");
                formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
                formShowParameter.setCustomParam("parent", (Object)this.getSelectCategoryId());
                formShowParameter.setCustomParam("model", (Object)this.getModelId());
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
            case "btn_edit": {
                BaseShowParameter formShowParameter = new BaseShowParameter();
                formShowParameter.setStatus(OperationStatus.EDIT);
                formShowParameter.setFormId("emr_rule_category");
                formShowParameter.setPkId((Object)this.getSelectCategoryId());
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u7f16\u8f91\u81ea\u5b9a\u4e49\u89c4\u5219\u5206\u7c7b", (String)"EmrRuleListPlugin_20", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                StyleCss styleCss = new StyleCss();
                styleCss.setWidth("600px");
                styleCss.setHeight("400px");
                formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
                this.getView().showForm((FormShowParameter)formShowParameter);
            }
        }
    }

    private String getSelectCategoryId() {
        return this.getFocusNodeId();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("bar_new".equals(actionId) || "set_order".equals(actionId)) {
            this.refresh();
        }
    }
}

