/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.emr.common.tree.RuleCategoryTreeBuilder;
import kd.epm.epbs.common.enums.RuleStatusEnum;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import kd.epm.epbs.common.tree.DynamicTreeContext;
import kd.epm.epbs.formplugin.treelist.AbstractTreeListF7Plugin;
import org.apache.commons.lang3.math.NumberUtils;
import org.elasticsearch.common.Strings;

public class EmrRuleSortPlugin
extends AbstractTreeListF7Plugin {
    static final String ENTRYENTITY = "dimlist";
    static final String BTN_OK = "btnok";
    static final String PageId = "rule_sort_plugin";

    public void initialize() {
        TreeView tv = (TreeView)this.getView().getControl("treeviewap");
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.getTreeView().addTreeNodeClickListener((TreeNodeClickListener)this);
        if (this.getControl(ENTRYENTITY) != null) {
            this.addClickListeners(new String[]{BTN_OK});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    protected AbstractTreeBuilder getTreeBuilder(DynamicTreeContext context) {
        return new RuleCategoryTreeBuilder(context);
    }

    protected DynamicTreeContext getDynamicTreeContext() {
        DynamicTreeContext context = new DynamicTreeContext("emr_rule_entity");
        context.setFocusTreeId("2005063722162241536");
        context.setqFilters(new QFilter("model", "in", Arrays.asList(0L, this.getModelId())).toArray());
        return context;
    }

    public void click(EventObject evt) {
        String item = ((Control)evt.getSource()).getKey();
        if (item.equals(BTN_OK)) {
            this.btnOk();
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        boolean passed = this.checkNotNull();
        if (!passed) {
            evt.setCancel(true);
        }
        if (evt.getNodeId() == null || Strings.isNullOrEmpty((String)evt.getNodeId().toString())) {
            return;
        }
        long nodeId = Long.parseLong(evt.getNodeId().toString());
        if (nodeId == 0L) {
            return;
        }
        QFilter filter1 = new QFilter("category", "=", (Object)nodeId);
        DynamicObjectCollection ruleAssignDys = QueryServiceHelper.query((String)"emr_rule_assigncategory", (String)"rule", (QFilter[])new QFilter[]{filter1});
        List ruleIds = ruleAssignDys.stream().map(dy -> dy.getLong("rule")).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", ruleIds);
        filter.and(new QFilter("model", "=", (Object)this.getModelId()));
        filter.and(new QFilter("domain", "=", (Object)this.getDomainId()));
        if (((Boolean)this.getView().getFormShowParameter().getCustomParam("hidedisabled")).booleanValue()) {
            filter.and(new QFilter("status", "=", (Object)RuleStatusEnum.ENABLE.getStatus()));
        }
        DynamicObjectCollection rules = QueryServiceHelper.query((String)"emr_rule_entity", (String)"*", (QFilter[])new QFilter[]{filter}, (String)"sequence asc");
        this.doFillMappingData(rules);
    }

    private void doFillMappingData(DynamicObjectCollection mappings) {
        int size = mappings.size();
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
        entryEntity.clear();
        for (int i = 0; i < size; ++i) {
            DynamicObject addNew = entryEntity.addNew();
            DynamicObject dvo = (DynamicObject)mappings.get(i);
            addNew.set("id", dvo.get("id"));
            addNew.set("name", dvo.get("name"));
            addNew.set("number", dvo.get("number"));
            addNew.set("sequence", dvo.get("sequence"));
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private boolean checkNotNull() {
        if (this.getModelId() == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9'\u4f53\u7cfb'\u3002", (String)"EmrRuleSortPlugin_0", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (this.getDomainId() == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9'\u4e1a\u52a1\u6a21\u578b'\u3002", (String)"EmrRuleSortPlugin_1", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        DynamicObjectCollection ruleAssignDys = QueryServiceHelper.query((String)"emr_rule_assigncategory", (String)"rule", (QFilter[])new QFilter("category", "in", this.getCategoryIds()).toArray());
        List ruleIds = ruleAssignDys.stream().map(dy -> dy.getLong("rule")).collect(Collectors.toList());
        e.getQFilters().add(new QFilter("id", "in", ruleIds));
        if (((Boolean)this.getModel().getValue("hidedisabled")).booleanValue()) {
            e.getQFilters().add(new QFilter("status", "=", (Object)RuleStatusEnum.ENABLE.getStatus()));
        }
    }

    private List<Long> getCategoryIds() {
        TreeNode rootWithCache = AbstractTreeBuilder.getRootWithCache((TreeView)this.getTreeView());
        TreeNode treeNode = rootWithCache.getTreeNode(this.getSelectCategoryId());
        if (treeNode == null || rootWithCache.getId().equals(treeNode.getId())) {
            return new ArrayList<Long>();
        }
        if (treeNode.isLeaf()) {
            return Collections.singletonList(NumberUtils.toLong((String)treeNode.getId()));
        }
        ArrayList<Long> leafNodeIds = new ArrayList<Long>();
        EmrRuleSortPlugin.addLeafNode(treeNode, leafNodeIds);
        return leafNodeIds;
    }

    private static void addLeafNode(TreeNode treeNode, List<Long> leafNodeIds) {
        for (TreeNode child : treeNode.getChildren()) {
            if (child.isLeaf()) {
                leafNodeIds.add(NumberUtils.toLong((String)child.getId()));
                continue;
            }
            EmrRuleSortPlugin.addLeafNode(child, leafNodeIds);
        }
    }

    public long getModelId() {
        try {
            return (Long)this.getView().getFormShowParameter().getCustomParam("modelid");
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public long getDomainId() {
        try {
            return (Long)this.getView().getFormShowParameter().getCustomParam("domainid");
        }
        catch (Exception e) {
            return 0L;
        }
    }

    private String getSelectCategoryId() {
        return this.getTreeView().getTreeState().getFocusNodeId();
    }

    private TreeView getTreeView() {
        return (TreeView)this.getControl("treeviewap");
    }

    void btnOk() {
        try {
            DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRYENTITY);
            List ruleIds = entryEntity.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
            QFilter filter = new QFilter("id", "in", ruleIds);
            DynamicObject[] rules = BusinessDataServiceHelper.load((String)"emr_rule_entity", (String)"id, sequence", (QFilter[])new QFilter[]{filter}, (String)"sequence asc");
            ArrayList<Long> seqs = new ArrayList<Long>(rules.length);
            HashMap<Long, DynamicObject> dic = new HashMap<Long, DynamicObject>();
            for (DynamicObject obj : rules) {
                Long id = obj.getLong("id");
                Long seq = obj.getLong("sequence");
                seqs.add(seq);
                dic.put(id, obj);
            }
            ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject obj = (DynamicObject)entryEntity.get(i);
                Long id = obj.getLong("id");
                if (!dic.containsKey(id)) continue;
                DynamicObject val = (DynamicObject)dic.get(id);
                if (val.getLong("sequence") != ((Long)seqs.get(i)).longValue()) {
                    val.set("sequence", seqs.get(i));
                }
                result.add(val);
            }
            SaveServiceHelper.save((DynamicObject[])result.toArray(new DynamicObject[0]));
            this.getView().close();
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"EmrRuleSortPlugin_2", (String)"epm-emr-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg + e.getMessage());
        }
    }
}

