/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.rules.edit;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.emr.business.rules.models.Constants;
import kd.epm.emr.business.rules.utils.RuleSaveHelper;
import kd.epm.emr.common.model.cache.EmrModelCache;
import kd.epm.emr.common.model.cache.EmrModelCacheHelper;
import kd.epm.emr.formplugin.rules.base.AbstractRulePlugin;
import kd.epm.emr.formplugin.rules.base.RuleLogicHelper;
import kd.epm.epbs.business.permission.model.ModelPermHelper;
import kd.epm.epbs.business.rules.api.Rules;
import kd.epm.epbs.business.rules.models.PluginCallbackEvent;
import kd.epm.epbs.business.rules.models.RuleBean;
import kd.epm.epbs.business.rules.models.RuleExpressionItem;
import kd.epm.epbs.business.rules.models.RuleExpressionModel;
import kd.epm.epbs.business.rules.models.RuleFactor;
import kd.epm.epbs.business.rules.models.RuleLogic;
import kd.epm.epbs.business.rules.models.RuleOptionProps;
import kd.epm.epbs.business.rules.models.RuleScopeDim;
import kd.epm.epbs.business.rules.webapi.RuleExecuteServiceHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.bean.OperationTypeInfo;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.enums.RuleFactorFlagEnum;
import kd.epm.epbs.common.enums.RuleStatusEnum;
import kd.epm.epbs.common.enums.model.BizModelTypeEnum;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.util.JSONUtils;
import kd.epm.epbs.common.util.Pair;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebRulePlugin
extends AbstractRulePlugin {
    public static final String CALLBACK_FACTOR_SELECT = "factorcallback";
    public static final String CALLBACK_SCOPE_SELECT = "scopecallback";
    public static String SCOPEDF7 = "ScopedF7";
    static String PageId = "web_rule_plugin";
    private static final Log log = LogFactory.getLog(WebRulePlugin.class);

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT) {
            String rule = (String)this.getView().getFormShowParameter().getCustomParam("rule");
            this.getPageCache().put("rule", rule);
            RuleBean ruleBean = (RuleBean)JSONUtils.parse((String)rule, RuleBean.class);
            this.getModel().setValue("ruleid", (Object)ruleBean.getId());
            this.getModel().setValue("modelid", (Object)ruleBean.getModelId());
            this.getModel().setValue("domainid", (Object)ruleBean.getDomainId());
            this.getModel().setValue("rulenumber", (Object)ruleBean.getNumber());
            this.getModel().setValue("rulename", (Object)ruleBean.getName());
            this.getModel().setValue("rulecategory", (Object)ruleBean.getCategoryName());
            this.getModel().setValue("rulesource", (Object)ruleBean.getSourceType());
            this.getModel().setValue("rulestatus", (Object)ruleBean.getStatus());
            this.getModel().setValue("ruledesc", (Object)ruleBean.getDescription());
            if (CollectionUtils.isNotEmpty((Collection)ruleBean.getTemplates())) {
                DynamicObject[] assignTemplates;
                DynamicObjectCollection templates = new DynamicObjectCollection();
                for (DynamicObject assignTemplate : assignTemplates = BusinessDataServiceHelper.load((Object[])ruleBean.getTemplates().stream().map(p -> (Long)p.p1).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"emr_templateentity"))) {
                    templates.add((Object)assignTemplate);
                }
                this.getModel().setValue("templates", (Object)templates);
            }
            this.getPageCache().put("categoryId", ruleBean.getCategoryId());
            this.getPageCache().put("categoryEntity", ruleBean.getCategoryEntity());
            this.getPageCache().put("sequence", String.valueOf(ruleBean.getSequence()));
        } else {
            long modelId = this.getLongParamFromView("model");
            long domainId = this.getLongParamFromView("domain");
            String categoryName = (String)this.getView().getFormShowParameter().getCustomParam("categoryName");
            this.getModel().setValue("modelid", (Object)modelId);
            this.getModel().setValue("domainid", (Object)domainId);
            this.getModel().setValue("rulecategory", (Object)categoryName);
            long categoryId = this.getLongParamFromView("categoryId");
            String categoryEntity = (String)this.getView().getFormShowParameter().getCustomParam("categoryEntity");
            this.getPageCache().put("categoryId", "" + categoryId);
            this.getPageCache().put("categoryEntity", categoryEntity);
        }
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"modelid", "domainid", "rulecategory", "rulesource"});
        super.afterCreateNewData(e);
    }

    boolean checkIsSave(String logicStr) {
        try {
            List logics = JSONUtils.parseArray((String)logicStr, RuleLogic.class);
            RuleBean rule = this.getRule();
            if (rule.getId() == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u5185\u5bb9\uff0c\u8bf7\u5148\u6267\u884c\u4fdd\u5b58\u3002", (String)"WebRulePlugin_0", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            }
            rule.setLogics(logics);
            RuleBean oldRule = this.getOriginFromDB(Long.parseLong(rule.getId()));
            if (!RuleLogicHelper.equals(oldRule, rule)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u5185\u5bb9\uff0c\u8bf7\u5148\u6267\u884c\u4fdd\u5b58\u3002", (String)"WebRulePlugin_0", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            return false;
        }
        return true;
    }

    boolean checkIsSaveWithoutAlert(String logicStr) {
        try {
            List logics = JSONUtils.parseArray((String)logicStr, RuleLogic.class);
            RuleBean rule = this.getRule();
            if (rule.getId() == null) {
                return false;
            }
            rule.setLogics(logics);
            RuleBean ruleBean = this.getOriginFromDB(Long.parseLong(rule.getId()));
            if (!RuleLogicHelper.equals(ruleBean, rule)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    void refresh(JSONObject param) {
        try {
            String ruleStr = this.getStringOrDefault(param, "items", "");
            if (!this.checkIsSaveWithoutAlert(ruleStr)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u5185\u5bb9\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"WebRulePlugin_1", (String)"epm-emr-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("save_confirm", (IFormPlugin)this));
            } else {
                this.refresh();
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    void exit(JSONObject param) {
        try {
            String ruleStr = this.getStringOrDefault(param, "items", "");
            if (!this.checkIsSaveWithoutAlert(ruleStr)) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u5185\u5bb9\uff0c\u662f\u5426\u9000\u51fa\uff1f", (String)"WebRulePlugin_2", (String)"epm-emr-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("exit_confirm", (IFormPlugin)this));
            } else {
                this.getView().close();
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (Strings.isNullOrEmpty((String)actionId)) {
            return;
        }
        Object returnData = e.getReturnData();
        if (CALLBACK_FACTOR_SELECT.equals(actionId)) {
            if (returnData instanceof JSONObject) {
                DynamicObjectCollection collection = (DynamicObjectCollection)((JSONObject)returnData).get((Object)"collection");
                if (collection == null || collection.size() == 0) {
                    return;
                }
                ArrayList<RuleFactor> factors = new ArrayList<RuleFactor>();
                for (DynamicObject obj : collection) {
                    RuleScopeDim _obj;
                    RuleFactor factor = new RuleFactor();
                    long id = obj.getLong("id");
                    factor.setId(Long.toString(id));
                    factor.setName(obj.getString("name"));
                    factor.setNumber(obj.getString("number"));
                    String memberStr = obj.getString("memberstr");
                    String memberName = obj.getString("members");
                    if (!Strings.isNullOrEmpty((String)memberName) && !Strings.isNullOrEmpty((String)memberStr)) {
                        RuleFactor x = (RuleFactor)JSONUtils.parse((String)memberStr, RuleFactor.class);
                        if (x == null || x.getMembers() == null) continue;
                        factor.setMembers(x.getMembers());
                        factors.add(factor);
                    }
                    String field = obj.getString("field");
                    String fieldStr = obj.getString("fieldstr");
                    if (Strings.isNullOrEmpty((String)field) || Strings.isNullOrEmpty((String)fieldStr) || (_obj = (RuleScopeDim)JSONUtils.parse((String)fieldStr, RuleScopeDim.class)) == null || _obj.getMembers() == null) continue;
                    factor.setMembers(_obj.getMembers());
                    factors.add(factor);
                }
                if (factors.isEmpty()) {
                    return;
                }
                RuleOptionProps modelStr = (RuleOptionProps)((JSONObject)returnData).get((Object)"logicModel");
                RuleExpressionModel model = new RuleExpressionModel();
                if (modelStr != null) {
                    model.setId(modelStr.getValue());
                    model.setName(modelStr.getLabel());
                    model.setNumber(modelStr.getNumber());
                    if (Strings.isNullOrEmpty((String)model.getNumber())) {
                        try {
                            BizModelBean bizModelById = EmrModelCacheHelper.get((long)this.getModelId()).getBizModelById(Long.parseLong(model.getId()));
                            if (bizModelById != null) {
                                model.setNumber(bizModelById.getNumber());
                            }
                        }
                        catch (Exception ex) {
                            this.getView().showErrorNotification(ex.getMessage());
                        }
                    }
                }
                JSONObject obj = new JSONObject();
                obj.put("model", (Object)model);
                obj.put("factors", factors);
                String pk = (String)((JSONObject)returnData).get((Object)"primaryKey");
                PluginCallbackEvent result = new PluginCallbackEvent(Constants.ResponseType.DATA_FACTOR_SELECTOR.name(), (Object)obj, pk);
                this.SendToVue(result);
            }
        } else if (CALLBACK_SCOPE_SELECT.equals(actionId) && returnData instanceof JSONObject) {
            DynamicObjectCollection collection = (DynamicObjectCollection)((JSONObject)returnData).get((Object)"collection");
            if (collection == null || collection.isEmpty()) {
                return;
            }
            HashMap<String, RuleScopeDim> scopeDims = new HashMap<String, RuleScopeDim>();
            for (DynamicObject obj : collection) {
                RuleScopeDim scopeDim = new RuleScopeDim();
                long id = obj.getLong("id");
                scopeDim.setId(Long.toString(id));
                scopeDim.setName(obj.getString("name"));
                scopeDim.setNumber(obj.getString("number"));
                String memberStr = obj.getString("memberstr");
                String memberName = obj.getString("members");
                if (!Strings.isNullOrEmpty((String)memberName) && !Strings.isNullOrEmpty((String)memberStr)) {
                    RuleScopeDim dim = (RuleScopeDim)JSONUtils.parse((String)memberStr, RuleScopeDim.class);
                    if (dim == null || dim.getMembers() == null) continue;
                    if (dim.getMembers() != null && !dim.getMembers().isEmpty() || dim.getExcepts() != null && !dim.getExcepts().isEmpty()) {
                        scopeDim.setMembers(dim.getMembers());
                        scopeDim.setExcepts(dim.getExcepts());
                        scopeDims.put(scopeDim.getId(), scopeDim);
                    }
                }
                String field = obj.getString("field");
                String fieldStr = obj.getString("fieldstr");
                if (Strings.isNullOrEmpty((String)field) || Strings.isNullOrEmpty((String)fieldStr)) continue;
                RuleScopeDim _obj = (RuleScopeDim)JSONUtils.parse((String)fieldStr, RuleScopeDim.class);
                scopeDim.setMembers(_obj.getMembers());
                scopeDim.setExcepts(_obj.getExcepts());
                if ((scopeDim.getMembers() == null || scopeDim.getMembers().isEmpty()) && (scopeDim.getExcepts() == null || scopeDim.getExcepts().isEmpty())) continue;
                scopeDims.put(scopeDim.getId(), scopeDim);
            }
            if (scopeDims.isEmpty()) {
                return;
            }
            String pk = (String)((JSONObject)returnData).get((Object)"primaryKey");
            ArrayList scopes = new ArrayList(scopeDims.values());
            PluginCallbackEvent result = new PluginCallbackEvent(Constants.ResponseType.DATA_DIM_F7_RESULT.name(), scopes, pk);
            this.SendToVue(result);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String key = evt.getCallBackId();
        MessageBoxResult msResult = evt.getResult();
        if ("save_confirm".equals(key)) {
            if (MessageBoxResult.Yes == msResult) {
                this.SendToVue(new PluginCallbackEvent(Constants.ResponseType.DATA_SAVE.name(), null));
            } else {
                this.refresh();
            }
        } else if ("exit_confirm".equals(key) && MessageBoxResult.Yes == msResult) {
            this.getView().close();
        }
    }

    private void refresh() {
        String id = this.getRule().getId();
        if (Strings.isNullOrEmpty((String)id)) {
            return;
        }
        RuleBean ruleBean = this.getOriginFromDB(Long.parseLong(id));
        this.getModel().setValue("rulenumber", (Object)ruleBean.getNumber());
        this.getModel().setValue("rulename", (Object)ruleBean.getName());
        this.getModel().setValue("rulestatus", (Object)ruleBean.getStatus());
        this.getModel().setValue("ruledesc", (Object)ruleBean.getDescription());
        this.refreshCustomCtrl(ruleBean.getLogics());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"WebRulePlugin_3", (String)"epm-emr-formplugin", (Object[])new Object[0]));
    }

    @Override
    protected void dataInit() {
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.EDIT) {
            String ruleJson = (String)this.getView().getFormShowParameter().getCustomParam("rule");
            RuleBean ruleBean = (RuleBean)JSONUtils.parse((String)ruleJson, RuleBean.class);
            this.refreshCustomCtrl(ruleBean.getLogics());
        } else {
            super.dataInit();
        }
    }

    @Override
    public void customEvent(CustomEventArgs evt) {
        String eventName = evt.getEventName();
        String eventArgs = evt.getEventArgs();
        JSONObject param = JSONObject.parseObject((String)eventArgs);
        this.getPageCache().put("primaryKey", param.getString("primaryKey"));
        if (Strings.isNullOrEmpty((String)eventName)) {
            return;
        }
        ModelPermHelper.checkPermission((long)this.getModelId(), (String)this.getBizAppId(), (String)"emr_rule_edit", (String)"47150e89000000ac");
        if (eventName.equals(Constants.RequestType.EVENT_LOGIC_DISABLED.name())) {
            if (!this.checkPermModify()) {
                return;
            }
            this.disableLogic(eventArgs);
        } else if (eventName.equals(Constants.RequestType.EVENT_SAVE.name())) {
            this.saveRule(param);
        } else if (eventName.equals(Constants.RequestType.EVENT_LOGIC_DELETE.name())) {
            if (!this.checkPermModify()) {
                return;
            }
            this.deleteLogic(param);
        } else if (eventName.equals(Constants.RequestType.EVENT_LOGIC_SAVE.name())) {
            if (!this.checkPermModify()) {
                return;
            }
            this.saveLogic(param);
        } else if (eventName.equals(Constants.RequestType.EVENT_NEW_RULE.name())) {
            this.addSingleRuleLogic();
        } else if (eventName.equals(Constants.RequestType.EVENT_LOGIC_SUBMIT.name())) {
            if (!this.checkPermModify()) {
                return;
            }
            this.submitLogic(param);
        } else if (eventName.equals(Constants.RequestType.EVENT_DIM_F7.name())) {
            String pk = this.getStringOrDefault(param, "primaryKey", "");
            if (!Strings.isNullOrEmpty((String)pk)) {
                this.getPageCache().put("PRIMARY_KEY", pk);
                if (pk.startsWith("BizModelF7")) {
                    this.bizModelF7();
                } else if (pk.startsWith(SCOPEDF7)) {
                    String itemString = param.getString("ruleLogic");
                    RuleLogic logic = (RuleLogic)JSONUtils.parse((String)itemString, RuleLogic.class);
                    if (logic == null || logic.getLogicBelong() == null || Strings.isNullOrEmpty((String)logic.getLogicBelong().getValue())) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f52\u5c5e\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WebRulePlugin_4", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    Long belongId = Long.parseLong(logic.getLogicBelong().getValue());
                    FormShowParameter formShowParameter = this.initFormShowParameter(belongId);
                    formShowParameter.setCustomParam("primaryKey", (Object)pk);
                    formShowParameter.setCustomParam("expressIds", this.getSelectedExpressId(logic));
                    formShowParameter.setCustomParam("domainId", (Object)this.getDomainId());
                    formShowParameter.setCustomParam("scopes", (Object)JSONUtils.toString((Object)logic.getScope()));
                    formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_SCOPE_SELECT));
                    formShowParameter.setCaption(ResManager.loadKDString((String)"\u8303\u56f4\u9009\u62e9", (String)"FactorSelectorPlugin_0", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                    this.getView().showForm(formShowParameter);
                }
            }
        } else if (eventName.equals(Constants.RequestType.EVENT_FACTOR_SELECTOR.name())) {
            BizModelBean bizModel;
            String itemString = param.getString("ruleLogic");
            RuleFactorFlagEnum factorFrom = RuleFactorFlagEnum.getEnumFromValue((String)param.getString("factorFrom"));
            String primaryKey = param.getString("primaryKey");
            RuleLogic logic = (RuleLogic)JSONUtils.parse((String)itemString, RuleLogic.class);
            if (logic == null || logic.getLogicBelong() == null || Strings.isNullOrEmpty((String)logic.getLogicBelong().getValue())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f52\u5c5e\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WebRulePlugin_4", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                return;
            }
            RuleOptionProps logicModel = logic.getLogicBelong();
            Long belongId = Long.parseLong(logicModel.getValue());
            String expression = param.getString("expression");
            RuleExpressionItem item = (RuleExpressionItem)JSONUtils.parse((String)expression, RuleExpressionItem.class);
            if (item != null) {
                belongId = Long.parseLong(item.getModel().getId());
                RuleExpressionModel m = item.getModel();
                logicModel = new RuleOptionProps(m.getId(), m.getName(), m.getNumber());
                bizModel = BusinessDataServiceHelper.loadSingle((Object)logicModel.getValue(), (String)"emr_bizmodel");
                if (bizModel != null && !Strings.isNullOrEmpty((String)bizModel.getString("type"))) {
                    String type = bizModel.getString("type");
                    primaryKey = ("1".equals(type) ? "MuiltiDim" : "Expansion") + primaryKey;
                }
            }
            if (primaryKey.startsWith("Indicator")) {
                return;
            }
            EmrModelCache emrModelCache = EmrModelCacheHelper.get((long)this.getModelId());
            bizModel = (BizModelBean)emrModelCache.getBizModelMap().get(belongId);
            BizModelTypeEnum bizModelType = bizModel.getBizModelType();
            if (bizModelType == BizModelTypeEnum.MUITL && primaryKey.startsWith("Expansion")) {
                return;
            }
            if (bizModelType == BizModelTypeEnum.RELATION && primaryKey.startsWith("MuiltiDim")) {
                return;
            }
            FormShowParameter formShowParameter = this.initFormShowParameter(belongId);
            formShowParameter.setCustomParam("logicModel", (Object)logicModel);
            formShowParameter.setCustomParam("expression", (Object)expression);
            formShowParameter.setCustomParam("from", (Object)factorFrom);
            formShowParameter.setCustomParam("primaryKey", (Object)primaryKey);
            formShowParameter.setCustomParam("domainId", (Object)this.getDomainId());
            formShowParameter.setCustomParam("scopeIds", this.getSelectedScopeDimId(logic));
            String name = (primaryKey.startsWith("MuiltiDim") ? ResManager.loadKDString((String)"\u591a\u7ef4", (String)"WebRulePlugin_5", (String)"epm-emr-formplugin", (Object[])new Object[0]) : (primaryKey.startsWith("Expansion") ? ResManager.loadKDString((String)"\u5173\u7cfb", (String)"WebRulePlugin_6", (String)"epm-emr-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6307\u6807", (String)"WebRulePlugin_7", (String)"epm-emr-formplugin", (Object[])new Object[0]))) + "-" + (Objects.equals(factorFrom, RuleFactorFlagEnum.From) ? ResManager.loadKDString((String)"\u6765\u6e90", (String)"WebRulePlugin_8", (String)"epm-emr-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u76ee\u6807", (String)"WebRulePlugin_9", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            formShowParameter.setCaption(name);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_FACTOR_SELECT));
            this.getView().showForm(formShowParameter);
        } else if (eventName.equals(Constants.RequestType.EVENT_SUBMIT_ALL.name())) {
            this.submitAllLogic(param);
        } else if (eventName.equals(Constants.RequestType.EVENT_SWITCH_ENABLE.name())) {
            this.switchEnableStatus(param);
        } else if (eventName.equals(Constants.RequestType.EVENT_REFRESH.name())) {
            this.refresh(param);
        } else if (eventName.equals(Constants.RequestType.EVENT_EXIT.name())) {
            this.exit(param);
        } else if (eventName.equals(Constants.RequestType.EVENT_CHANGE_SEQ_CHECK.name())) {
            String ruleStr = this.getStringOrDefault(param, "items", "");
            if (!this.checkIsSave(ruleStr)) {
                return;
            }
            this.SendToVue(new PluginCallbackEvent(Constants.ResponseType.DATA_CHANGE_SEQ.name(), null));
        } else if (eventName.equals(Constants.RequestType.EVENT_LOGIC_DEBUG.name())) {
            if (!this.checkPermDebug()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4e1a\u52a1\u89c4\u5219\u201d\u7684\u201c\u8c03\u8bd5\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WebRulePlugin_34", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                return;
            }
            String id = (String)this.getModelValue("ruleid");
            if (StringUtils.isEmpty((CharSequence)id)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6267\u884c\u4fdd\u5b58\u3002", (String)"WebRulePlugin_10", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                return;
            }
            String itemString = param.getString("ruleLogic");
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("rulelogic", (Object)itemString);
            formShowParameter.setCustomParam("ruleId", (Object)id);
            formShowParameter.setCustomParam("modelId", (Object)String.valueOf(this.getModelId()));
            formShowParameter.setCustomParam("sequence", (Object)this.getPageCache().get("sequence"));
            formShowParameter.setFormId("emr_rule_debug");
            this.getView().showForm(formShowParameter);
        }
        this.writeLog((IOperationTypeInfo)new OperationTypeInfo("customEvent", new MultiLangEnumBridge("\u89c4\u5219\u903b\u8f91", "WebRulePlugin_35", "epm-emr-formplugin")), null);
    }

    HashSet<Long> getSelectedScopeDimId(RuleLogic logic) {
        if (logic == null || logic.getScope() == null || logic.getScope().isEmpty()) {
            return new HashSet<Long>();
        }
        HashSet<Long> ids = new HashSet<Long>();
        for (RuleScopeDim scope : logic.getScope()) {
            ids.add(Long.parseLong(scope.getId()));
        }
        return ids;
    }

    HashSet<Long> getSelectedExpressId(RuleLogic logic) {
        if (logic == null || logic.getExpressions() == null || logic.getExpressions().isEmpty()) {
            return new HashSet<Long>();
        }
        HashSet<Long> ids = new HashSet<Long>();
        for (RuleExpressionItem item : logic.getExpressions()) {
            if (item.getFactorFlag() == RuleFactorFlagEnum.From || item.getRuleFactors() == null || item.getRuleFactors().isEmpty()) continue;
            for (RuleFactor factor : item.getRuleFactors()) {
                ids.add(Long.parseLong(factor.getId() == null ? "0" : factor.getId()));
            }
        }
        return ids;
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        OperationTypeEnum typeInfo = null;
        switch (itemKey) {
            case "bar_addsegment": {
                typeInfo = OperationTypeEnum.ADD;
                this.addSingleRuleLogic();
                break;
            }
            case "bar_submit": {
                typeInfo = OperationTypeEnum.SUBMIT;
                this.SendToVue(new PluginCallbackEvent(Constants.ResponseType.DATA_SUBMIT_ALL.name(), (Object)new JSONObject()));
                break;
            }
            case "bar_enabled": {
                typeInfo = OperationTypeEnum.ENABLE;
                this.sendRuleStatus("1");
                break;
            }
            case "bar_disabled": {
                typeInfo = OperationTypeEnum.DISABLE;
                this.sendRuleStatus("0");
                break;
            }
            case "bar_copylogic": {
                typeInfo = OperationTypeEnum.COPY;
                this.copyLogic();
                break;
            }
            case "bar_setorder": {
                typeInfo = new OperationTypeInfo("order", new MultiLangEnumBridge("\u6392\u5e8f", "WebRulePlugin_36", "epm-emr-formplugin"));
                this.SendToVue(new PluginCallbackEvent(Constants.ResponseType.DATA_CHANGE_SEQ_CHECK.name(), null));
                break;
            }
            case "bar_debug": {
                String id = (String)this.getModelValue("ruleid");
                if (StringUtils.isEmpty((CharSequence)id)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6267\u884c\u4fdd\u5b58\u3002", (String)"WebRulePlugin_10", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                    return;
                }
                Map debugResult = RuleExecuteServiceHelper.executeBizRules((Rules)new Rules(this.getModelId(), NumberUtils.toLong((String)id), true));
                if (MapUtils.isEmpty((Map)debugResult)) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u8c03\u8bd5\u6210\u529f\u3002", (String)"WebRulePlugin_11", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getView().showErrorNotification(debugResult.values().toString());
                break;
            }
            case "bar_executelog": {
                String ruleId = (String)this.getModelValue("ruleid");
                IFormView view = this.getView();
                IFormView mainPageView = view.getMainView();
                ListShowParameter formShowParameter = new ListShowParameter();
                if (StringUtils.isNotEmpty((CharSequence)ruleId)) {
                    String pageId = this.getView().getPageId() + ruleId;
                    if (mainPageView != null && mainPageView.getView(pageId) != null) {
                        IFormView childView = mainPageView.getView(pageId);
                        childView.activate();
                        view.sendFormAction(childView);
                        return;
                    }
                    formShowParameter.setPageId(pageId);
                }
                formShowParameter.setFormId("emr_rule_execrecordlist");
                formShowParameter.setBillFormId("emr_rule_executerecord");
                formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                formShowParameter.setCustomParam("ruleId", (Object)ruleId);
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
            case "bar_refresh": {
                this.SendToVue(new PluginCallbackEvent(Constants.ResponseType.DATA_REFRESH.name(), (Object)new JSONObject()));
                break;
            }
            case "bar_close": {
                this.SendToVue(new PluginCallbackEvent(Constants.ResponseType.DATA_EXIT.name(), null));
                break;
            }
            case "bar_save": {
                typeInfo = OperationTypeEnum.SAVE;
                this.requestSave();
                break;
            }
        }
        if (typeInfo != null) {
            this.writeLog((IOperationTypeInfo)typeInfo, null);
        }
    }

    void addSingleRuleLogic() {
        JSONObject data = new JSONObject();
        Long domainId = this.getDomainId();
        Long modelId = this.getModelId();
        QFilter filter = new QFilter("businessdomainid", "=", (Object)domainId);
        filter.and("model", "=", (Object)modelId);
        DynamicObject model = QueryServiceHelper.queryOne((String)"emr_bizmodel", (String)"id,name,number", (QFilter[])new QFilter[]{filter});
        if (model != null) {
            RuleOptionProps props = new RuleOptionProps(model.getString("id"), model.getString("name"), model.getString("number"));
            data.put("belong", (Object)props);
        }
        String id = String.valueOf(ID.genLongId());
        String ruleNumber = (String)this.getModel().getValue("rulenumber");
        data.put("id", (Object)id);
        data.put("ruleNumber", (Object)ruleNumber);
        PluginCallbackEvent result = new PluginCallbackEvent(Constants.ResponseType.DATA_NEW_RULE.toString(), (Object)data);
        this.SendToVue(result);
    }

    void deleteLogic(JSONObject obj) {
        try {
            String item = this.getStringOrDefault(obj, "ruleLogic", "");
            if (Strings.isNullOrEmpty((String)item)) {
                return;
            }
            RuleLogic logic = (RuleLogic)JSONUtils.parse((String)item, RuleLogic.class);
            if (logic == null) {
                return;
            }
            RuleBean rule = this.getRule();
            if (rule.getId() != null) {
                logic.setRuleId(rule.getId());
                if (RuleSaveHelper.existRule((RuleLogic)logic)) {
                    RuleSaveHelper.deleteOneRuleLogic((RuleLogic)logic);
                }
            }
            obj.remove((Object)"ruleLogic");
            obj.put("id", (Object)logic.getId());
            PluginCallbackEvent result = new PluginCallbackEvent(Constants.ResponseType.DATA_LOGIC_DELETE.name(), (Object)obj);
            this.SendToVue(result);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"WebRulePlugin_12", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            this.writeLog((IOperationTypeInfo)OperationTypeEnum.DELETE, new MultiLangEnumBridge("\u5220\u9664\u89c4\u5219\u903b\u8f91%s", "WebRulePlugin_30", "epm-emr-formplugin", new Object[]{logic.getLogicCode()}));
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    void saveLogic(JSONObject param) {
        try {
            String itemString = param.getString("ruleLogic");
            RuleLogic logic = (RuleLogic)JSONUtils.parse((String)itemString, RuleLogic.class);
            if (logic == null) {
                return;
            }
            RuleBean rule = this.getRule();
            if (rule.getId() == null) {
                ArrayList<RuleLogic> array = new ArrayList<RuleLogic>();
                array.add(logic);
                rule.setLogics(array);
                if (!this.checkRuleInput(rule)) {
                    return;
                }
                RuleSaveHelper.saveOneRule((RuleBean)rule);
                this.afterSave(rule);
            } else {
                if (!this.checkLogicInput(logic)) {
                    return;
                }
                logic.setRuleId(rule.getId());
                RuleSaveHelper.saveOneRuleLogic((RuleLogic)logic);
            }
            JSONObject obj = new JSONObject();
            obj.put("id", (Object)logic.getId());
            PluginCallbackEvent result = new PluginCallbackEvent(Constants.ResponseType.DATA_LOGIC_SAVE.name(), (Object)obj);
            this.SendToVue(result);
            this.saveSuccess();
            this.writeLog((IOperationTypeInfo)OperationTypeEnum.SAVE, new MultiLangEnumBridge("\u4fdd\u5b58\u89c4\u5219\u903b\u8f91", "WebRulePlugin_32", "epm-emr-formplugin"));
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void afterSave(RuleBean rule) {
        this.setRuleId(Long.parseLong(rule.getId()));
        this.getPageCache().put("sequence", String.valueOf(rule.getSequence()));
    }

    void saveRule(JSONObject param) {
        try {
            String ruleStr = this.getStringOrDefault(param, "items", "");
            if (Strings.isNullOrEmpty((String)ruleStr)) {
                return;
            }
            List logics = JSONUtils.parseArray((String)ruleStr, RuleLogic.class);
            RuleBean rule = this.getRule();
            rule.setLogics(logics);
            if (!this.checkRuleInput(rule)) {
                return;
            }
            if (rule.getId() == null) {
                RuleSaveHelper.saveOneRule((RuleBean)rule);
                this.afterSave(rule);
            } else {
                DynamicObject r = BusinessDataServiceHelper.loadSingle((Object)rule.getId(), (String)"emr_rule_entity");
                rule.setSequence(r.getInt("sequence"));
                RuleSaveHelper.updateOneRule((RuleBean)rule);
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"WebRulePlugin_13", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            this.refreshCustomCtrl(logics);
            String primaryKey = this.getStringOrDefault(param, "primaryKey", "");
            if (!Strings.isNullOrEmpty((String)primaryKey) && "exit".equals(primaryKey)) {
                this.getView().close();
            }
            this.writeLog((IOperationTypeInfo)OperationTypeEnum.SAVE, new MultiLangEnumBridge("\u4fdd\u5b58\u89c4\u5219", "WebRulePlugin_33", "epm-emr-formplugin"));
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    void submitAllLogic(JSONObject param) {
        try {
            String ruleStr = this.getStringOrDefault(param, "items", "");
            if (Strings.isNullOrEmpty((String)ruleStr)) {
                return;
            }
            List logics = JSONUtils.parseArray((String)ruleStr, RuleLogic.class);
            if (logics == null || logics.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u903b\u8f91\u7247\u6bb5\u4e3a\u7a7a\u3002", (String)"WebRulePlugin_14", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            }
            RuleBean rule = this.getRule();
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)rule.getId(), (String)"emr_rule_entity");
            if (obj == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u89c4\u5219\u3002", (String)"WebRulePlugin_15", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            }
            for (RuleLogic logic : logics) {
                logic.setRuleId(rule.getId());
                logic.setDisplayStatus(RuleStatusEnum.RuleLogicStatusEnum.Submited);
            }
            rule.setLogics(logics);
            if (!this.checkRuleInput(rule)) {
                return;
            }
            DynamicObject r = BusinessDataServiceHelper.loadSingle((Object)rule.getId(), (String)"emr_rule_entity");
            rule.setSequence(r.getInt("sequence"));
            RuleSaveHelper.updateOneRule((RuleBean)rule);
            this.refreshCustomCtrl(logics);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5168\u90e8\u63d0\u4ea4\u6210\u529f\u3002", (String)"WebRulePlugin_16", (String)"epm-emr-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
        }
    }

    void submitLogic(JSONObject param) {
        try {
            String itemString = param.getString("ruleLogic");
            RuleLogic logic = (RuleLogic)JSONUtils.parse((String)itemString, RuleLogic.class);
            if (logic == null) {
                return;
            }
            logic.setDisplayStatus(RuleStatusEnum.RuleLogicStatusEnum.Submited);
            RuleBean rule = this.getRule();
            if (rule.getId() == null) {
                rule.logics = new ArrayList();
                rule.logics.add(logic);
                if (!this.checkRuleInput(rule)) {
                    return;
                }
                RuleSaveHelper.saveOneRule((RuleBean)rule);
                this.afterSave(rule);
            } else {
                if (!this.checkLogicInput(logic)) {
                    return;
                }
                logic.setRuleId(rule.getId());
                RuleSaveHelper.saveOneRuleLogic((RuleLogic)logic);
            }
            JSONObject data = new JSONObject();
            data.put("id", (Object)logic.getId());
            PluginCallbackEvent result = new PluginCallbackEvent(Constants.ResponseType.DATA_LOGIC_SUBMIT.name(), (Object)data);
            this.SendToVue(result);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"WebRulePlugin_17", (String)"epm-emr-formplugin", (Object[])new Object[0]));
    }

    void requestSave() {
        JSONObject data = new JSONObject();
        PluginCallbackEvent result = new PluginCallbackEvent(Constants.ResponseType.DATA_SAVE.toString(), (Object)data);
        this.SendToVue(result);
    }

    void disableLogic(String json) {
        JSONObject param = JSONObject.parseObject((String)json);
        String str = this.getStringOrDefault(param, "ruleLogic", "");
        if (Strings.isNullOrEmpty((String)str)) {
            return;
        }
        RuleLogic logic = (RuleLogic)JSONUtils.parse((String)str, RuleLogic.class);
        if (logic == null) {
            return;
        }
        RuleBean rule = this.getRule();
        if (rule.getId() == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u89c4\u5219\u672a\u4fdd\u5b58\uff0c\u8bf7\u5148\u4fdd\u5b58\u3002", (String)"WebRulePlugin_18", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)rule.getId(), (String)"emr_rule_entity");
        logic.setRuleId(rule.getId());
        if (obj == null) {
            ArrayList<RuleLogic> array = new ArrayList<RuleLogic>();
            array.add(logic);
            rule.setLogics(array);
            if (!this.checkRuleInput(rule)) {
                return;
            }
            RuleSaveHelper.saveOneRule((RuleBean)rule);
            this.afterSave(rule);
        } else {
            if (!this.checkLogicInput(logic)) {
                return;
            }
            RuleSaveHelper.saveOneRuleLogic((RuleLogic)logic);
        }
        this.getView().showSuccessNotification(logic.getIsEnable() ? ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"WebRulePlugin_19", (String)"epm-emr-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"WebRulePlugin_20", (String)"epm-emr-formplugin", (Object[])new Object[0]));
        JSONObject data = new JSONObject();
        data.put("id", (Object)logic.getId());
        PluginCallbackEvent result = new PluginCallbackEvent(Constants.ResponseType.DATA_LOGIC_DISABLED.name(), (Object)data);
        this.SendToVue(result);
    }

    String getStringOrDefault(JSONObject obj, String key, String defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj.containsKey((Object)key)) {
            return obj.getString(key);
        }
        return defaultValue;
    }

    private RuleBean getRule() {
        RuleBean rule = new RuleBean();
        String id = (String)this.getModelValue("ruleid");
        if (!Strings.isNullOrEmpty((String)id)) {
            rule.setId(id);
        }
        rule.setModelId(Long.toString(this.getModelId()));
        rule.setDomainId(Long.toString(this.getDomainId()));
        rule.setName((String)this.getModelValue("rulename"));
        rule.setNumber((String)this.getModelValue("rulenumber"));
        rule.setDescription((String)this.getModelValue("ruledesc"));
        rule.setSourceType((String)this.getModelValue("rulesource"));
        rule.setStatus((String)this.getModelValue("rulestatus"));
        rule.setCategoryName((String)this.getModelValue("rulecategory"));
        rule.setCategoryId(this.getPageCache().get("categoryId"));
        rule.setCategoryEntity(this.getPageCache().get("categoryEntity"));
        rule.setSequence(NumberUtils.toInt((String)this.getPageCache().get("sequence")));
        DynamicObjectCollection templates = (DynamicObjectCollection)this.getModel().getValue("templates");
        ArrayList ruleTemplates = new ArrayList();
        templates.forEach(template -> ruleTemplates.add(Pair.onePair((Object)template.getDynamicObject("fbasedataid").getLong("id"), (Object)template.getDynamicObject("fbasedataid").getLong("group"))));
        rule.setTemplates(ruleTemplates);
        return rule;
    }

    void setRuleId(Long id) {
        this.getModel().setValue("ruleid", (Object)id);
    }

    void saveSuccess() {
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"WebRulePlugin_13", (String)"epm-emr-formplugin", (Object[])new Object[0]));
    }

    boolean checkRuleInput(RuleBean rule) {
        try {
            if (Strings.isNullOrEmpty((String)rule.getNumber())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WebRulePlugin_21", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            }
            if (Strings.isNullOrEmpty((String)rule.getName())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WebRulePlugin_22", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            }
            List logics = rule.getLogics();
            if (logics != null && !logics.isEmpty()) {
                Map<String, Long> collect = logics.stream().collect(Collectors.groupingBy(x -> x.getLogicCode(), Collectors.counting()));
                long count = collect.values().stream().filter(x -> x >= 2L).count();
                if (count > 0L) {
                    Optional<Map.Entry> first = collect.entrySet().stream().filter(k -> (Long)k.getValue() >= 2L).findFirst();
                    String code = first.isPresent() ? (String)first.get().getKey() : "";
                    throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7f16\u7801\u4e3a%s\u7684\u89c4\u5219\u903b\u8f91\uff0c\u7f16\u7801\u65e0\u6cd5\u81ea\u52a8\u751f\u6210\uff0c\u9700\u8981\u624b\u5de5\u7ef4\u62a4\u3002", (String)"WebRulePlugin_23", (String)"epm-emr-formplugin", (Object[])new Object[]{code}));
                }
                for (RuleLogic item : logics) {
                    boolean b = this.checkLogicInput(item);
                    if (b) continue;
                    return false;
                }
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            return false;
        }
        return true;
    }

    boolean checkLogicInput(RuleLogic item) {
        try {
            if (Strings.isNullOrEmpty((String)item.getLogicName())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u903b\u8f91\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WebRulePlugin_24", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            }
            if (Strings.isNullOrEmpty((String)item.getLogicCode())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u903b\u8f91\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WebRulePlugin_25", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            }
            if (item.getLogicBelong() == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u903b\u8f91\u5f52\u5c5e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WebRulePlugin_26", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            this.getView().showErrorNotification(e.getMessage());
            return false;
        }
        return true;
    }

    void refreshCustomCtrl(List<RuleLogic> logics) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("RuleCategory", (Object)this.getPageCache().get("categoryEntity"));
        jsonObject.put("RuleLogics", logics);
        PluginCallbackEvent result = new PluginCallbackEvent(Constants.ResponseType.DATA_INIT.name(), (Object)jsonObject);
        this.SendToVue(result);
    }

    void switchEnableStatus(JSONObject param) {
        String ruleStr = this.getStringOrDefault(param, "items", "");
        if (!this.checkIsSave(ruleStr)) {
            return;
        }
        String status = this.getStringOrDefault(param, "primaryKey", "");
        if (!Strings.isNullOrEmpty((String)status)) {
            this.getModel().setValue("rulestatus", (Object)status);
            this.saveRule(param);
        }
    }

    public RuleBean getOriginFromDB(Long ruleId) {
        DynamicObject rule = BusinessDataServiceHelper.loadSingle((Object)ruleId, (String)"emr_rule_entity");
        RuleBean ruleBean = RuleSaveHelper.fromDynamicObject((DynamicObject)rule);
        RuleBean constRule = this.getRule();
        ruleBean.setCategoryId(constRule.getCategoryId());
        ruleBean.setCategoryName(constRule.getCategoryName());
        ruleBean.setCategoryEntity(constRule.getCategoryEntity());
        ruleBean.getLogics().forEach(x -> {
            x.setExpanded(false);
            x.setFocused(false);
        });
        return ruleBean;
    }

    void copyLogic() {
        JSONObject obj = new JSONObject();
        String id = String.valueOf(ID.genLongId());
        String ruleNumber = (String)this.getModel().getValue("rulenumber");
        obj.put("id", (Object)id);
        obj.put("ruleNumber", (Object)ruleNumber);
        PluginCallbackEvent result = new PluginCallbackEvent(Constants.ResponseType.DATA_COPY_LOGIC.name(), (Object)obj);
        this.SendToVue(result);
    }

    private FormShowParameter initFormShowParameter(Long bizModelId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("emr_rule_factors_select");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("modelid", (Object)this.getModelId());
        formShowParameter.setCustomParam("bizmodelid", (Object)bizModelId);
        return formShowParameter;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        Control templates = (Control)evt.getSource();
        String key = templates.getKey();
        if ("templates".equals(key)) {
            evt.addCustomQFilter(new QFilter("model", "=", (Object)this.getModelId()));
        }
    }

    long getDomainId() {
        return (Long)this.getModelValue("domainid_id");
    }

    boolean checkPermModify() {
        return ModelPermHelper.checkPermission((long)this.getModelId(), (String)this.getBizAppId(), (String)"emr_rule_list", (String)"4715a0df000000ac");
    }

    boolean checkPermDebug() {
        return ModelPermHelper.checkPermission((long)this.getModelId(), (String)this.getBizAppId(), (String)"emr_rule_list", (String)"49DRU4CE+T97");
    }

    void sendRuleStatus(String status) {
        PluginCallbackEvent result = new PluginCallbackEvent(Constants.ResponseType.DATA_SWITCH_ENABLE.name(), (Object)new JSONObject());
        result.primaryKey = status;
        this.SendToVue(result);
    }
}

