/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.spread;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.spread.event.ISpreadAction;
import kd.epm.emr.common.spread.control.ISpreadContainer;
import kd.epm.emr.common.spread.control.SpreadContainer;
import kd.epm.emr.common.spread.domain.view.SpreadSelector;
import kd.epm.emr.common.spread.domain.view.SpreadSheet;
import kd.epm.emr.common.spread.domain.view.event.EventConstant;
import kd.epm.emr.common.spread.domain.view.event.IAfterEventHandle;
import kd.epm.emr.common.spread.domain.view.event.IRegisterEvent;
import kd.epm.emr.common.spread.domain.view.event.ISpreadListener;
import kd.epm.emr.common.spread.domain.view.event.NotifyEvent;
import kd.epm.emr.common.spread.domain.view.event.NotifyListener;
import kd.epm.emr.common.spread.domain.view.event.SpreadEventChain;
import kd.epm.emr.common.spread.domain.view.js.SpreadProperties;
import kd.epm.emr.common.spread.listener.ISpreadBaseSupport;
import kd.epm.emr.formplugin.spread.AskExcuteInfo;
import kd.epm.emr.formplugin.spread.SpreadClientInvoker;
import kd.epm.emr.formplugin.spread.SpreadDataModel;
import kd.epm.epbs.common.util.MapInitHelper;
import kd.epm.epbs.formplugin.AbstractBaseFormPlugin;
import org.apache.commons.lang3.StringUtils;

public class SpreadBasePlugin
extends AbstractBaseFormPlugin
implements ISpreadBaseSupport,
IRegisterEvent,
ISpreadListener,
IAfterEventHandle {
    private static final String SPREAD_SELECTOR_CACHE_KEY = "spread_selector_cache_key";
    private static final String SPREAD_SHEET_CACHE_KEY = "spread_sheet_cache_key";
    public static final String SHEET_NAME = "Sheet1";
    private ISpreadContainer spreadContainer = null;
    private SpreadSelector spreadSelector = null;
    private SpreadSheet spreadSheet = null;
    private SpreadEventChain eventChain = new SpreadEventChain();
    protected List<Map<String, Object>> commands;

    public void initialize() {
        super.initialize();
        if (StringUtils.isNotEmpty((CharSequence)this.getSpreadKey())) {
            this.getView().addService(ISpreadAction.class, (Object)this.getSpreadDataModelService());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.initDefaultSpreadListener();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (StringUtils.isNotEmpty((CharSequence)this.getSpreadKey())) {
            ArrayList<Map> menuItems = new ArrayList<Map>(16);
            menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.insertRowOrColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
            menuItems.add(MapInitHelper.ofMap((Object)SpreadProperties.HideContextMenuItemsMethod.NAME.k(), (Object)SpreadProperties.ContextMenuItemNamesEnum.deleteRowOrColumns, (Object)SpreadProperties.HideContextMenuItemsMethod.ISHIDE.k(), (Object)true));
            SpreadClientInvoker.invokeHideContextMenuItems(this.getClientViewProxy(), this.getSpreadKey(), menuItems);
        }
    }

    public String getSpreadKey() {
        return null;
    }

    public ISpreadContainer getSpreadContainer() {
        if (this.spreadContainer == null) {
            this.spreadContainer = new SpreadContainer(this.getView(), this.getSpreadKey());
        }
        return this.spreadContainer;
    }

    public SpreadSelector getSpreadSelector() {
        return this.getSpreadSelector(null);
    }

    public SpreadSelector getSpreadSelector(String spreadKey) {
        if (this.spreadSelector != null && spreadKey != null && spreadKey.equals(this.spreadSelector.getSource())) {
            return this.spreadSelector;
        }
        String selectorSerial = this.getPageCache().get(StringUtils.isEmpty((CharSequence)spreadKey) ? SPREAD_SELECTOR_CACHE_KEY : SPREAD_SELECTOR_CACHE_KEY + spreadKey);
        if (!StringUtils.isNotEmpty((CharSequence)selectorSerial)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u5143\u683c\u533a\u57df\u3002", (String)"SpreadBasePlugin_0", (String)"epm-emr-formplugin", (Object[])new Object[0]));
        }
        this.spreadSelector = (SpreadSelector)this.deSerializedBytes(selectorSerial);
        return this.spreadSelector;
    }

    public void setSpreadSelector(SpreadSelector spreadSelector) {
        this.spreadSelector = spreadSelector;
        this.cacheSpreadSelector();
    }

    public void cacheSpreadSelector() {
        if (this.spreadSelector == null) {
            this.getPageCache().put(SPREAD_SELECTOR_CACHE_KEY, null);
        } else {
            String value = this.toByteSerialized(this.spreadSelector);
            this.getPageCache().put(SPREAD_SELECTOR_CACHE_KEY, value);
            if (StringUtils.isNotEmpty((CharSequence)this.spreadSelector.getSource())) {
                this.getPageCache().put(SPREAD_SELECTOR_CACHE_KEY + this.spreadSelector.getSource(), value);
            }
        }
    }

    public SpreadSheet getSpreadSheet() {
        if (this.spreadSheet != null) {
            return this.spreadSheet;
        }
        String selectorSerial = this.getPageCache().get(SPREAD_SHEET_CACHE_KEY);
        if (StringUtils.isNotEmpty((CharSequence)selectorSerial)) {
            this.spreadSheet = (SpreadSheet)this.deSerializedBytes(selectorSerial);
        }
        return this.spreadSheet;
    }

    public void setSpreadSheet(SpreadSheet spreadSheet) {
        this.spreadSheet = spreadSheet;
        this.cacheSpreadSheet();
    }

    public void cacheSpreadSheet() {
        if (this.spreadSheet == null) {
            this.getPageCache().put(SPREAD_SHEET_CACHE_KEY, null);
        } else {
            this.getPageCache().put(SPREAD_SHEET_CACHE_KEY, this.toByteSerialized(this.spreadSheet));
        }
    }

    protected ISpreadAction getSpreadDataModelService() {
        return new SpreadDataModel((AbstractFormPlugin)this);
    }

    public SpreadSheet getActiveSheet() {
        return new SpreadSheet(Integer.valueOf(0), SHEET_NAME);
    }

    public void registerBeforeEvent(EventConstant.ActionName name, NotifyListener ls) {
        this.eventChain.registerBeforeEvent(name, ls);
    }

    public void registerAfterEvent(EventConstant.ActionName name, NotifyListener ls) {
        this.eventChain.registerAfterEvent(name, ls);
    }

    public NotifyListener unregisterBeforeEvent(EventConstant.ActionName name) {
        return this.eventChain.unregisterBeforeEvent(name);
    }

    public NotifyListener unregisterAfterEvent(EventConstant.ActionName name) {
        return this.eventChain.unregisterAfterEvent(name);
    }

    public void doBeforeNotify(NotifyEvent event) {
        if (this.eventChain.containsBeforeActionName(event.getActionName()) && !event.isCancel()) {
            this.eventChain.getListener(true, event.getActionName()).doNotify(event);
        }
    }

    public void doAfterNotify(NotifyEvent event) {
        if (this.eventChain.containsAfterActionName(event.getActionName()) && !event.isCancel()) {
            this.eventChain.getListener(false, event.getActionName()).doNotify(event);
        }
    }

    public void doubleClickLockedCell(int row, int col) {
    }

    protected void mergeInvokeUpdateValueCommands(List<Map<String, Object>> item) {
        if (this.commands == null) {
            this.commands = new ArrayList<Map<String, Object>>();
        }
        this.commands.addAll(item);
    }

    protected void mergeInvokeUpdateValueCommands(Map<String, Object> item) {
        if (this.commands == null) {
            this.commands = new ArrayList<Map<String, Object>>();
        }
        this.commands.add(item);
    }

    public void afterSpreadEventHandle(EventConstant.ActionName actionName) {
        if (EventConstant.ActionName.UPDATE_VALUE == actionName && this.commands != null && this.getSpreadKey() != null) {
            SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), this.getSpreadKey(), this.commands);
        }
    }

    public void updateRowAndCol(AskExcuteInfo askExcuteInfo) {
        this.adjustMultiAreaSetting(askExcuteInfo);
        this.updateRowAndCol2View(this.getClientViewProxy(), this.getSpreadKey(), askExcuteInfo);
    }

    public void adjustMultiAreaSetting(AskExcuteInfo askExcuteInfo) {
    }

    public void updateRowAndCol2View(IClientViewProxy view, String spreadKey, AskExcuteInfo excuteinfo) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("status", true);
        map.put("isUndo", excuteinfo.isUndo());
        if (excuteinfo.getOperationdata().size() > 0) {
            if (excuteinfo.isCon()) {
                Collections.sort(excuteinfo.getOperationdata());
                ArrayList rangeList = new ArrayList();
                HashMap<String, Integer> data = new HashMap<String, Integer>();
                data.put("index", excuteinfo.getOperationdata().get(0));
                data.put("count", excuteinfo.getOperationdata().size());
                rangeList.add(data);
                map.put("data", rangeList);
            } else {
                map.put("data", excuteinfo.getOperationdata());
            }
        } else if (!excuteinfo.getBatchOperationData().isEmpty()) {
            ArrayList rangeList = new ArrayList();
            excuteinfo.getBatchOperationData().forEach(e -> {
                HashMap<String, Integer> data = new HashMap<String, Integer>();
                data.put("index", e.getOprtPosition());
                data.put("count", e.getSize());
                rangeList.add(data);
            });
            map.put("data", rangeList);
        }
        if (map.containsKey("data")) {
            if (excuteinfo.isRev()) {
                if (excuteinfo.getOperation() == 0) {
                    map.put("dir", "bottom");
                } else {
                    map.put("dir", "after");
                }
            }
            view.invokeControlMethod(spreadKey, excuteinfo.getMethod().getMethod(), new Object[]{map});
        }
    }

    private void initDefaultSpreadListener() {
        if (StringUtils.isEmpty((CharSequence)this.getSpreadKey())) {
            return;
        }
        this.registerBeforeEvent(EventConstant.ActionName.ADD_ROW, this::rowColOperationCheck);
        this.registerBeforeEvent(EventConstant.ActionName.ADD_COL, this::rowColOperationCheck);
        this.registerBeforeEvent(EventConstant.ActionName.REMOVE_COL, this::rowColOperationCheck);
        this.registerBeforeEvent(EventConstant.ActionName.REMOVE_ROW, this::rowColOperationCheck);
        this.registerAfterEvent(EventConstant.ActionName.ADD_ROW, e -> this.updateRowAndCol((AskExcuteInfo)e.getSource()));
        this.registerAfterEvent(EventConstant.ActionName.ADD_COL, e -> this.updateRowAndCol((AskExcuteInfo)e.getSource()));
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_COL, e -> this.updateRowAndCol((AskExcuteInfo)e.getSource()));
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_ROW, e -> this.updateRowAndCol((AskExcuteInfo)e.getSource()));
    }

    public void rowColOperationCheck(NotifyEvent notifyEvent) {
    }

    public void showFormulaPanel(int row, int col) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u516c\u5f0f\u7f16\u8f91\u3002", (String)"SpreadBasePlugin_1", (String)"epm-emr-formplugin", (Object[])new Object[0]));
    }

    public void cacheSpreadF7Selector(Integer row, Integer col, String source) {
        SpreadSelector spreadSelector = new SpreadSelector(row.intValue(), col.intValue(), 1, 1, source);
        this.getPageCache().put("spreadF7Click", this.toByteSerialized(spreadSelector));
    }

    public void cacheSpreadF7Selector(Integer row, Integer col) {
        SpreadSelector spreadSelector = new SpreadSelector(row.intValue(), col.intValue(), 1, 1);
        this.getPageCache().put("spreadF7Click", this.toByteSerialized(spreadSelector));
    }

    public SpreadSelector getSpreadF7Selector() {
        SpreadSelector spreadF7Selector = null;
        String spreadF7ClickStr = this.getPageCache().get("spreadF7Click");
        spreadF7Selector = StringUtils.isNotEmpty((CharSequence)spreadF7ClickStr) ? (SpreadSelector)this.deSerializedBytes(spreadF7ClickStr) : this.getSpreadSelector();
        return spreadF7Selector;
    }

    public void removeSpreadF7SelectorCache() {
        this.getPageCache().remove("spreadF7Click");
    }

    protected int getSelectorStartRow() {
        return this.getSpreadSelector().getStartRow();
    }

    protected int getSelectorStartCol() {
        return this.getSpreadSelector().getStartCol();
    }
}

