/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.spread;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.spread.F7ItemFillBackArgs;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.form.spread.Spread;
import kd.bos.form.spread.SpreadActionAdapter;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.SpreadDataModelUtil;
import kd.epm.emr.business.template.spread.IMultiSheetTemplateModelSupport;
import kd.epm.emr.common.spread.command.event.CellValueEvent;
import kd.epm.emr.common.spread.command.event.SpreadActionListener;
import kd.epm.emr.common.spread.domain.view.SpreadSelector;
import kd.epm.emr.common.spread.domain.view.event.EventConstant;
import kd.epm.emr.common.spread.domain.view.event.IAfterEventHandle;
import kd.epm.emr.common.spread.domain.view.event.ISpreadListener;
import kd.epm.emr.common.spread.domain.view.event.NotifyEvent;
import kd.epm.emr.common.spread.domain.view.js.SpreadProperties;
import kd.epm.emr.common.spread.listener.ISpreadBaseSupport;
import kd.epm.emr.common.spread.sheet.Cell;
import kd.epm.emr.common.spread.sheet.Sheet;
import kd.epm.emr.formplugin.spread.AskExcuteInfo;
import kd.epm.emr.formplugin.spread.ISheetModelSupplier;
import kd.epm.emr.formplugin.spread.SpreadBasePlugin;
import kd.epm.emr.formplugin.template.AbstractTemplateProcessPlugin;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.ThrowableHelper;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.collections4.MapUtils;

public class SpreadDataModel
extends SpreadActionAdapter {
    public SpreadDataModel(AbstractFormPlugin plugin) {
        super(plugin);
    }

    public void deleteRows(SpreadEvent event) {
    }

    public void deleteColumns(SpreadEvent event) {
    }

    public void addRows(SpreadEvent event) {
    }

    public void addColumns(SpreadEvent event) {
    }

    public void askExecute(SpreadEvent event) {
        Spread spread;
        SpreadPostDataInfo data;
        super.askExecute(event);
        ISheetManager sm = this.getSheetManager(event);
        if (sm != null && MapUtils.isNotEmpty((Map)(data = (spread = (Spread)event.getSource()).getPostDataInfo()).getInvokeParams())) {
            this.adjustExcuteInfo(data.getInvokeParams());
            AskExcuteInfo askExcuteInfo = new AskExcuteInfo(data);
            NotifyEvent notifyEvent = new NotifyEvent((Object)askExcuteInfo, askExcuteInfo.getActionname(), null);
            this.doBeforeNotify(notifyEvent);
            if (!notifyEvent.isCancel()) {
                this.doAfterNotify(askExcuteInfo, askExcuteInfo.getActionname());
                SpreadDataModel.adjustSheet(askExcuteInfo, sm);
                this.cacheSheetModel(sm);
            }
        }
    }

    private void adjustExcuteInfo(LinkedHashMap<String, Object> param) {
        String method = (String)param.get("method");
        if (SpreadProperties.InsertMethod.INSERTCOL.k().equals(method) || SpreadProperties.InsertMethod.INSERTROW.k().equals(method)) {
            if (param.get("data") instanceof List) {
                List val = (List)param.get("data");
                if (val.size() > 1) {
                    boolean isContinute = true;
                    for (int i = 1; i < val.size(); ++i) {
                        if ((Integer)val.get(i) == (Integer)val.get(i - 1) + 1) continue;
                        isContinute = false;
                        break;
                    }
                    if (isContinute) {
                        ArrayList<Integer> newval = new ArrayList<Integer>(val.size());
                        int insert = (Integer)val.get(0);
                        for (int i = 0; i < val.size(); ++i) {
                            newval.add(insert);
                        }
                        param.put("data", newval);
                    }
                }
            } else if (param.get("data") instanceof Map) {
                Map data = (Map)param.get("data");
                int selectIndex = (Integer)data.get("selectIndex");
                int oprtCount = (Integer)data.get("count");
                ArrayList<Integer> newval = new ArrayList<Integer>(oprtCount);
                for (int i = 0; i < oprtCount; ++i) {
                    newval.add(selectIndex);
                }
                param.put("data", newval);
            }
        }
    }

    public void selectedSpread(SpreadEvent event) {
        SpreadPostDataInfo data = event.getPostData();
        if (data.getSelRows() != null && !data.getSelRows().isEmpty() && data.getSelCols() != null && !data.getSelCols().isEmpty()) {
            SpreadBasePlugin s;
            Map status;
            this.modifySelectData(data);
            this.sortSelectData(data);
            int focusCellRow_st = (Integer)data.getSelRows().get(0);
            int focusCellRow_end = (Integer)data.getSelRows().get(data.getSelRows().size() - 1);
            int focusCellCol_st = (Integer)data.getSelCols().get(0);
            int focusCellCol_end = (Integer)data.getSelCols().get(data.getSelCols().size() - 1);
            SpreadSelector selector = new SpreadSelector(focusCellRow_st, focusCellCol_st, focusCellRow_end, focusCellCol_end, ((Control)event.getSource()).getKey());
            if (SpreadBasePlugin.class.isAssignableFrom(this.plugin.getClass()) && (status = (Map)(s = (SpreadBasePlugin)((Object)SpreadBasePlugin.class.cast(this.plugin))).getClientViewProxy().getViewState(s.getSpreadKey())) != null && status.containsKey("selections")) {
                List selections = (List)status.get("selections");
                selector.setSelections(selections);
            }
            if (this.plugin instanceof ISpreadBaseSupport) {
                SpreadSelector spreadSelector = new SpreadSelector(focusCellRow_st, focusCellCol_st, focusCellRow_end, focusCellCol_end, ((Control)event.getSource()).getKey());
                IClientViewProxy clientViewProxy = (IClientViewProxy)this.plugin.getView().getService(IClientViewProxy.class);
                Map status2 = (Map)clientViewProxy.getViewState(((Control)event.getSource()).getKey());
                if (status2 != null && status2.containsKey("selections")) {
                    List selections = (List)status2.get("selections");
                    selector.setSelections(selections);
                }
                ((ISpreadBaseSupport)ISpreadBaseSupport.class.cast(this.plugin)).setSpreadSelector(spreadSelector);
                if (this.plugin instanceof SpreadActionListener) {
                    ((SpreadActionListener)SpreadActionListener.class.cast(this.plugin)).cellClick(spreadSelector);
                }
            }
            NotifyEvent evtdelcol = new NotifyEvent((Object)data, EventConstant.ActionName.CELL_SELECT, null);
            this.doBeforeNotify(evtdelcol);
            if (!evtdelcol.isCancel()) {
                this.doAfterNotify(data, EventConstant.ActionName.CELL_SELECT);
            }
        }
    }

    private void modifySelectData(SpreadPostDataInfo data) {
        String selectorSerial = this.plugin.getPageCache().get("spread_selector_init");
        if (StringUtils.isNotEmpty((String)selectorSerial)) {
            SpreadSelector selector = (SpreadSelector)ObjectSerialUtil.deSerializedBytes((String)selectorSerial);
            ArrayList<Integer> selRows = new ArrayList<Integer>(10);
            ArrayList<Integer> selCols = new ArrayList<Integer>(10);
            for (int r = selector.getStartRow(); r <= selector.getEndRow(); ++r) {
                selRows.add(r);
            }
            for (int c = selector.getStartCol(); c <= selector.getEndCol(); ++c) {
                selCols.add(c);
            }
            data.setSelCols(selCols);
            data.setSelRows(selRows);
            this.plugin.getPageCache().remove("spread_selector_init");
        }
    }

    private void sortSelectData(SpreadPostDataInfo data) {
        data.getSelRows().sort(this.sortSmallTobig());
        data.getSelCols().sort(this.sortSmallTobig());
        int rowindex = data.getSelRows().indexOf(-1);
        int colindex = data.getSelCols().indexOf(-1);
        if (rowindex != -1) {
            data.getSelRows().remove(rowindex);
        }
        if (colindex != -1) {
            data.getSelCols().remove(colindex);
        }
    }

    public void updateCellValue(SpreadEvent event) {
        String source = ((Spread)event.getSource()).getKey();
        super.updateCellValue(event);
        boolean valueChanged = false;
        SpreadPostDataInfo data = event.getPostData();
        for (LinkedHashMap e : data.getValues()) {
            Integer r = (Integer)e.get("r");
            Integer c = (Integer)e.get("c");
            Object val = e.get("v");
            if (val instanceof Map) continue;
            Cell eCell = new Cell();
            eCell.setRow(r.intValue());
            eCell.setCol(c.intValue());
            CellValueEvent cellValueEvent = new CellValueEvent(null, val, eCell, source);
            if (this.plugin instanceof SpreadActionListener) {
                ((SpreadActionListener)this.plugin).cellValueUpdate(cellValueEvent);
                if (cellValueEvent.isCancel()) continue;
            }
            valueChanged = true;
        }
        if (this.plugin instanceof IMultiSheetTemplateModelSupport && valueChanged) {
            ((IMultiSheetTemplateModelSupport)this.plugin).cacheMultiSheetTemplateModel();
        }
        if (this.plugin instanceof AbstractTemplateProcessPlugin && (((AbstractTemplateProcessPlugin)this.plugin).getRowSpreadKey().equals(source) || ((AbstractTemplateProcessPlugin)this.plugin).getColSpreadKey().equals(source))) {
            return;
        }
        ISheetManager sm = null;
        try {
            sm = this.getSheetManager(event);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (sm != null && data.getValues() != null) {
            data.getValues().forEach(v -> {
                if (v.get("v") instanceof String) {
                    v.put("v", SpreadDataModelUtil.trim((String)v.get("v").toString()));
                }
            });
            Sheet sheet = (Sheet)sm.getSheet();
            NotifyEvent mulevt = new NotifyEvent((Object)sm, EventConstant.ActionName.UPDATE_MULVALUE, (Object)data);
            if (!data.getValues().isEmpty()) {
                this.doBeforeNotify(mulevt);
            }
            if (!mulevt.isCancel()) {
                for (LinkedHashMap e : data.getValues()) {
                    Object val = e.get("v");
                    if (!(val instanceof Number) && !(val instanceof String) && !(val instanceof Character) && val != null) continue;
                    Integer r = (Integer)e.get("r");
                    Integer c = (Integer)e.get("c");
                    Cell cell = sheet.getCell(r.intValue(), c.intValue());
                    val = SpreadDataModelUtil.dealValue(val);
                    NotifyEvent evt = new NotifyEvent((Object)cell, EventConstant.ActionName.UPDATE_VALUE, val);
                    this.doBeforeNotify(evt);
                    if (evt.isCancel()) continue;
                    if (evt.getCheckParam() != null) {
                        val = evt.getCheckParam();
                    }
                    if (!cell.setValue(val)) continue;
                    this.doAfterNotify(cell, EventConstant.ActionName.UPDATE_VALUE);
                }
                this.doAfterNotify(data, EventConstant.ActionName.UPDATE_MULVALUE);
            }
            this.doAfterEventHandle(EventConstant.ActionName.UPDATE_VALUE);
            this.cacheSheetModel(sm);
        }
    }

    private void doBeforeNotify(NotifyEvent evt) {
        if (ISpreadListener.class.isAssignableFrom(this.plugin.getClass())) {
            ((ISpreadListener)ISpreadListener.class.cast(this.plugin)).doBeforeNotify(evt);
        }
    }

    private void doAfterNotify(Object source, EventConstant.ActionName actionName) {
        if (ISpreadListener.class.isAssignableFrom(this.plugin.getClass())) {
            ((ISpreadListener)ISpreadListener.class.cast(this.plugin)).doAfterNotify(new NotifyEvent(source, actionName));
        }
    }

    private void doAfterEventHandle(EventConstant.ActionName actionName) {
        if (IAfterEventHandle.class.isAssignableFrom(this.plugin.getClass())) {
            ((IAfterEventHandle)IAfterEventHandle.class.cast(this.plugin)).afterSpreadEventHandle(actionName);
        }
    }

    public void updateFormula(SpreadEvent event) {
        List formulas;
        Spread spread;
        SpreadPostDataInfo data;
        ISheetManager sm = null;
        try {
            sm = this.getSheetManager(event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sm != null && (data = (spread = (Spread)event.getSource()).getPostDataInfo()).getInvokeParams() != null && data.getInvokeParams().get("formulas") != null && !(formulas = (List)data.getInvokeParams().get("formulas")).isEmpty()) {
            NotifyEvent mulevt = new NotifyEvent((Object)sm, EventConstant.ActionName.UPDATE_MULFORMULA, (Object)formulas);
            this.doBeforeNotify(mulevt);
            Sheet sheet = (Sheet)sm.getSheet();
            formulas.forEach(e -> {
                LinkedHashMap item = (LinkedHashMap)e;
                Cell cell = sheet.getCell(((Integer)item.get("r")).intValue(), ((Integer)item.get("c")).intValue());
                String val = (String)item.get("f");
                NotifyEvent evt = new NotifyEvent((Object)cell, EventConstant.ActionName.UPDATE_FORMULA, (Object)val);
                this.doBeforeNotify(evt);
                if (!evt.isCancel()) {
                    cell.setFormula(val);
                    this.doAfterNotify(cell, EventConstant.ActionName.UPDATE_FORMULA);
                }
            });
            this.doAfterNotify(formulas, EventConstant.ActionName.UPDATE_MULFORMULA);
            this.cacheSheetModel(sm);
        }
    }

    public void showCellDimInfo(SpreadEvent event) {
    }

    public void insertRangeRow(SpreadEvent event) {
        ISheetManager sm = this.getSheetManager(event);
        if (sm != null) {
            Spread spread = (Spread)event.getSource();
            SpreadPostDataInfo data = spread.getPostDataInfo();
            SpreadDataModel.insertRangeRows((Sheet)sm.getSheet(), data.getStartCol(), data.getEndCol(), data.getSelcIndex(), data.getOprtCount());
            this.cacheSheetModel(sm);
        }
    }

    public void insertRangeCols(SpreadEvent event) {
        ISheetManager sm = this.getSheetManager(event);
        if (sm != null) {
            Spread spread = (Spread)event.getSource();
            SpreadPostDataInfo data = spread.getPostDataInfo();
            SpreadDataModel.insertRangeCols((Sheet)sm.getSheet(), data.getStartRow(), data.getEndRow(), data.getSelcIndex(), data.getOprtCount());
            this.cacheSheetModel(sm);
        }
    }

    public void delRangeRow(SpreadEvent event) {
        ISheetManager sm = this.getSheetManager(event);
        if (sm != null) {
            Spread spread = (Spread)event.getSource();
            SpreadPostDataInfo data = spread.getPostDataInfo();
            SpreadDataModel.delRangeRows((Sheet)sm.getSheet(), data.getStartCol(), data.getEndCol(), data.getSelcIndex(), data.getOprtCount());
            this.cacheSheetModel(sm);
        }
    }

    public void delRangeCols(SpreadEvent event) {
        ISheetManager sm = this.getSheetManager(event);
        if (sm != null) {
            Spread spread = (Spread)event.getSource();
            SpreadPostDataInfo data = spread.getPostDataInfo();
            SpreadDataModel.delRangeCols((Sheet)sm.getSheet(), data.getStartRow(), data.getEndRow(), data.getSelcIndex(), data.getOprtCount());
            this.cacheSheetModel(sm);
        }
    }

    public static void insertRangeRows(Sheet sheet, int fromColIdx, int toColIdx, int selcRowindex, int rowCount) {
        sheet.insertRangeRows(fromColIdx, toColIdx, selcRowindex, rowCount);
    }

    public static void insertRangeCols(Sheet sheet, int fromRowIdx, int toRowIdx, int selcColindex, int colCount) {
        sheet.insertRangeCols(fromRowIdx, toRowIdx, selcColindex, colCount);
    }

    public static void delRangeRows(Sheet sheet, int fromColIdx, int toColIdx, int selcRowindex, int rowCount) {
        sheet.delRangeRows(fromColIdx, toColIdx, selcRowindex, rowCount);
    }

    public static void delRangeCols(Sheet sheet, int fromRowIdx, int toRowIdx, int selcColindex, int colCount) {
        sheet.delRangeCols(fromRowIdx, toRowIdx, selcColindex, colCount);
    }

    private ISheetManager getSheetManager(SpreadEvent event) {
        ISheetManager sm = null;
        if (ISheetModelSupplier.class.isAssignableFrom(this.plugin.getClass())) {
            sm = ((ISheetModelSupplier)ISheetModelSupplier.class.cast(this.plugin)).getSheetManager();
        }
        if (sm != null) {
            return sm;
        }
        IPageCache pageCache = this.plugin.getPageCache();
        String serial = pageCache.get("key_new_spread_model");
        if (serial != null) {
            sm = SpreadDataModelUtil.getSheetManager((String)serial);
        }
        if (sm == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230spread\u6a21\u578b\u5e8f\u5217\u3002", (String)"SpreadDataModel_0", (String)"epm-emr-formplugin", (Object[])new Object[0]));
        }
        return sm;
    }

    private void cacheIt(SpreadEvent event, String cacheKey, String serial) {
        IPageCache pageCache = this.plugin.getPageCache();
        pageCache.put(cacheKey + ((Spread)event.getSource()).getKey(), serial);
    }

    private void cacheSheetModel(ISheetManager sm) {
        if (!ISheetModelSupplier.class.isAssignableFrom(this.plugin.getClass())) {
            throw new KDBizException("not implement interface's method[cacheSheetModel] ");
        }
        ((ISheetModelSupplier)ISheetModelSupplier.class.cast(this.plugin)).cacheSheetManager(sm);
    }

    private Comparator<Integer> sortSmallTobig() {
        return new Comparator<Integer>(){

            @Override
            public int compare(Integer x, Integer y) {
                return Integer.compare(x, y);
            }
        };
    }

    public static void adjustSheet(AskExcuteInfo excuteinfo, ISheetManager sm) {
        Sheet sheet = (Sheet)sm.getSheet();
        switch (excuteinfo.getMethod().getMethod()) {
            case "deleteCol": {
                excuteinfo.getOperationdata().forEach(arg_0 -> ((Sheet)sheet).delColumn(arg_0));
                excuteinfo.getBatchOperationData().forEach(e -> {
                    for (int i = 0; i < e.getSize(); ++i) {
                        sheet.delColumn(e.getOprtPosition());
                    }
                });
                break;
            }
            case "insertCol": {
                excuteinfo.getOperationdata().forEach(e -> {
                    if (excuteinfo.isRev()) {
                        sheet.insertColumnToRight(e.intValue());
                    } else {
                        sheet.insertColumn(e.intValue());
                    }
                });
                excuteinfo.getBatchOperationData().forEach(e -> {
                    for (int i = 0; i < e.getSize(); ++i) {
                        if (excuteinfo.isRev()) {
                            sheet.insertColumnToRight(e.getOprtPosition());
                            continue;
                        }
                        sheet.insertColumn(e.getOprtPosition());
                    }
                });
                break;
            }
            case "deleteRow": {
                excuteinfo.getOperationdata().forEach(arg_0 -> ((Sheet)sheet).delRow(arg_0));
                excuteinfo.getBatchOperationData().forEach(e -> {
                    for (int i = 0; i < e.getSize(); ++i) {
                        sheet.delRow(e.getOprtPosition());
                    }
                });
                break;
            }
            case "insertRow": {
                excuteinfo.getOperationdata().forEach(e -> {
                    if (excuteinfo.isRev()) {
                        sheet.insertRowToBottom(e.intValue());
                    } else {
                        sheet.insertRow(e.intValue());
                    }
                });
                excuteinfo.getBatchOperationData().forEach(e -> {
                    for (int i = 0; i < e.getSize(); ++i) {
                        if (excuteinfo.isRev()) {
                            sheet.insertRowToBottom(e.getOprtPosition());
                            continue;
                        }
                        sheet.insertRow(e.getOprtPosition());
                    }
                });
                break;
            }
        }
    }

    public void getLookupData(SpreadEvent event) {
        if (event.getPostData().getInvokeParams() != null) {
            int r = (Integer)event.getPostData().getInvokeParams().get("r");
            int c = (Integer)event.getPostData().getInvokeParams().get("c");
            Map lookupDataInfo = (Map)event.getPostData().getInvokeParams().get("lookupInfo");
            LookUpDataArgs bean = new LookUpDataArgs();
            this.populateValues(bean, lookupDataInfo);
            bean.setR(r);
            bean.setC(c);
            if (bean.getValue() != null) {
                this.callPluginMethod("spreadF7LookUpData", bean);
            }
        }
    }

    public void setItemByIdFromClient(SpreadEvent event) {
        if (event.getPostData().getInvokeParams() != null) {
            F7ItemFillBackArgs bean = new F7ItemFillBackArgs();
            this.populateValues(bean, event.getPostData().getInvokeParams());
            this.callPluginMethod("setSpreadF7Item", bean);
        }
    }

    public void f7Click(SpreadEvent event) {
        if (event.getPostData().getInvokeParams() != null && event.getPostData().getInvokeParams().containsKey("cell")) {
            LinkedHashMap params = (LinkedHashMap)event.getPostData().getInvokeParams().get("cell");
            if (event.getSource() instanceof Spread) {
                params.put("source", ((Spread)event.getSource()).getKey());
            }
            this.callPluginMethod("spreadF7Click", params);
        }
    }

    protected void populateValues(Object populateBean, Map<String, ? extends Object> values) {
        try {
            BeanUtils.populate((Object)populateBean, values);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void invokePluginMethod(SpreadEvent event) {
        String methodName = (String)event.getPostData().getInvokeParams().get("invokemethod");
        if ("cornerTagClick".equals(methodName)) {
            return;
        }
        Object data = event.getPostData().getInvokeParams().get("data");
        try {
            MethodUtils.invokeMethod((Object)this.plugin, (String)methodName, data);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException var) {
            this.handleException(var);
        }
    }

    private void callPluginMethod(String methodName, LinkedHashMap<String, Object> invokeParams) {
        try {
            MethodUtils.invokeMethod((Object)this.plugin, (String)methodName, invokeParams);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.plugin.getView().showErrorNotification(ThrowableHelper.toString((Exception)e));
            throw new RuntimeException(e);
        }
    }

    public void callPluginMethod(String methodName, Object params) {
        try {
            MethodUtils.invokeMethod((Object)this.plugin, (String)methodName, (Object)params);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            this.plugin.getView().showErrorNotification(ThrowableHelper.toString((Exception)e));
            throw new RuntimeException(e);
        }
    }

    private void handleException(Exception e) {
        if (e != null && e.getCause() instanceof KDBizException) {
            throw (KDBizException)e.getCause();
        }
        throw new RuntimeException(e);
    }
}

