/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.spread;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kd.bos.form.IClientViewProxy;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.areasetting.IFloatInfo;
import kd.epm.emr.common.spread.domain.view.js.SpreadProperties;
import kd.epm.emr.common.spread.sheet.Cell;
import kd.epm.emr.common.spread.sheet.ISheet;
import kd.epm.emr.common.template.Tuple;
import kd.epm.emr.formplugin.spread.SpreadClientInvoker;
import kd.epm.epbs.common.util.ICell;
import kd.epm.epbs.common.util.MapInitHelper;
import kd.epm.epbs.common.util.RangeModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class SpreadEasyInvoker {
    private IClientViewProxy view;
    private String spreadKey;
    private LinkedHashMap<String, Object> orderlist;
    private boolean isBatch;

    public SpreadEasyInvoker(IClientViewProxy view, String spreadKey) {
        this.spreadKey = spreadKey;
        this.view = view;
        this.orderlist = new LinkedHashMap();
    }

    public void setBatch(boolean isBatch) {
        this.isBatch = isBatch;
    }

    public void startToInvoke() {
        Set<Map.Entry<String, Object>> set = this.orderlist.entrySet();
        for (Map.Entry<String, Object> s : set) {
            String key = s.getKey();
            if (key.contains(SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k())) {
                this.view.invokeControlMethod(this.spreadKey, SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k(), new Object[]{s.getValue()});
                continue;
            }
            if (key.contains(SpreadProperties.SetRowsHeightMethod.SETROWSHEIGHT.k())) {
                this.view.invokeControlMethod(this.spreadKey, SpreadProperties.SetRowsHeightMethod.SETROWSHEIGHT.k(), new Object[]{s.getValue()});
                continue;
            }
            if (key.contains(SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k())) {
                this.view.invokeControlMethod(this.spreadKey, SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k(), new Object[]{s.getValue()});
                continue;
            }
            if (SpreadProperties.AddContextMenuItemsMethod.ADDCONTENTMENUITEMS.k().equalsIgnoreCase(key)) {
                this.view.invokeControlMethod(this.spreadKey, SpreadProperties.AddContextMenuItemsMethod.ADDCONTENTMENUITEMS.k(), new Object[]{MapInitHelper.ofMap((Object)SpreadProperties.AddContextMenuItemsMethod.CALLBACK.k(), (Object)"invokeAction", (Object)SpreadProperties.AddContextMenuItemsMethod.ITEMS.k(), (Object)s.getValue())});
                continue;
            }
            if (key.contains(SpreadProperties.ResetCellMethod.RESETCELL.k())) {
                this.view.invokeControlMethod(this.spreadKey, key, new Object[]{MapInitHelper.ofMap((Object)SpreadProperties.ResetCellMethod.RANGE.k(), (Object)s.getValue())});
                continue;
            }
            this.view.invokeControlMethod(this.spreadKey, key, new Object[]{s.getValue()});
        }
        this.orderlist.clear();
    }

    public static void addContextSubMenuItem(String itemName, String itemText, String[] workArea, List<Map<String, Object>> subMenuItems) {
        HashMap<String, Object> subMenuItem = new HashMap<String, Object>(16);
        subMenuItem.put(SpreadProperties.AddContextMenuItemsMethod.NAME.k(), itemName);
        subMenuItem.put(SpreadProperties.AddContextMenuItemsMethod.TEXT.k(), itemText);
        subMenuItem.put(SpreadProperties.AddContextMenuItemsMethod.WORKAREA.k(), workArea);
        subMenuItems.add(subMenuItem);
    }

    public Map<String, Object> getOrderlist() {
        return this.orderlist;
    }

    public void setSingleSpan(int r, int c, int rc, int cc) {
        SpreadClientInvoker.invokeSetSpanMethod(this.view, this.spreadKey, SpreadEasyInvoker.packedStyleCellMap(SpreadEasyInvoker.getSingleRanges(r, rc, rc, cc), null));
    }

    public static List<Map<String, Object>> getSingleRanges(int r, int c, int rc, int cc) {
        ArrayList<Map<String, Object>> cells = new ArrayList<Map<String, Object>>(10);
        cells.add(SpreadEasyInvoker.packRangeFeature(r, c, rc, cc));
        return cells;
    }

    public void clearCellsStyle(int r, int c, int rc, int cc) {
        List<Map<String, Object>> cells = SpreadEasyInvoker.getSingleRanges(r, c, rc, cc);
        if (this.isBatch) {
            List<Map<String, Object>> oldMapList = (List<Map<String, Object>>)this.orderlist.get(SpreadProperties.ClearCellsStyleMethod.CLEARCELLSSTYLE.k());
            if (oldMapList == null) {
                oldMapList = cells;
            } else {
                oldMapList.addAll(cells);
            }
            this.orderlist.put(SpreadProperties.ClearCellsStyleMethod.CLEARCELLSSTYLE.k(), oldMapList);
        } else {
            SpreadClientInvoker.clearCellsStyle(this.view, this.spreadKey, cells);
        }
    }

    public void setSpan(int r, int c, int rc, int cc) {
        Map<String, Object> features = SpreadEasyInvoker.packedStyleCellMap(SpreadEasyInvoker.getSingleRanges(r, c, rc, cc), null);
        if (this.isBatch) {
            Map<String, Object> oldparam = (Map<String, Object>)this.orderlist.get(SpreadProperties.SetSpanMethod.SETSPAN.k());
            if (oldparam == null) {
                oldparam = features;
            } else {
                List rm = (List)oldparam.get(SpreadProperties.SetSpanMethod.RANGE.k());
                rm.add(SpreadEasyInvoker.packRangeFeature(r, c, rc, cc));
            }
            this.orderlist.put(SpreadProperties.SetSpanMethod.SETSPAN.k(), oldparam);
        } else {
            SpreadClientInvoker.invokeSetSpanMethod(this.view, this.spreadKey, features);
        }
    }

    public void updataValue(int r, int c, Object value) {
        Map<String, Object> valMap = SpreadEasyInvoker.packedUpdateCellMap(r, c, value);
        if (this.isBatch) {
            ArrayList<Map<String, Object>> oldparam = (ArrayList<Map<String, Object>>)this.orderlist.get(SpreadProperties.UpdataValueMethod.UPDATAVALUE.k());
            if (oldparam == null) {
                oldparam = new ArrayList<Map<String, Object>>();
            }
            oldparam.add(valMap);
            this.orderlist.put(SpreadProperties.UpdataValueMethod.UPDATAVALUE.k(), oldparam);
        } else {
            ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
            cellValues.add(valMap);
            SpreadClientInvoker.invokeUpdataValueMethod(this.view, this.spreadKey, cellValues);
        }
    }

    public void updataValue(ICell cell, Object value) {
        this.updataValue(cell.getRow(), cell.getCol(), value);
    }

    public void setFormula(int r, int c, Object value) {
        Map<String, Object> valMap = SpreadEasyInvoker.packedFormulaCellMap(r, c, value);
        if (this.isBatch) {
            ArrayList<Map<String, Object>> oldparam = (ArrayList<Map<String, Object>>)this.orderlist.get(SpreadProperties.SetFormulaMethod.SETFORMULA.k());
            if (oldparam == null) {
                oldparam = new ArrayList<Map<String, Object>>();
            }
            oldparam.add(valMap);
            this.orderlist.put(SpreadProperties.SetFormulaMethod.SETFORMULA.k(), oldparam);
        } else {
            ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
            cellValues.add(valMap);
            SpreadClientInvoker.invokeSetFormulaMethod(this.view, this.spreadKey, cellValues);
        }
    }

    public void setF7TypeCell(int r, int c, int rc, int cc, int selectType, int dst) {
        List<Map<String, Object>> items;
        Map<String, Integer> features;
        Map<String, Object> feature = SpreadEasyInvoker.packRangeFeature(r, c, rc, cc);
        String key = SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k() + selectType + dst;
        if (this.isBatch) {
            features = (Map)this.orderlist.get(key);
            items = new ArrayList();
            if (features != null) {
                items = (List)features.get(SpreadProperties.SetF7TypeCellMethod.RANGE.k());
            } else {
                features = new HashMap();
            }
        } else {
            features = new HashMap();
            items = new ArrayList<Map<String, Object>>();
        }
        items.add(feature);
        features.put(SpreadProperties.SetF7TypeCellMethod.RANGE.k(), (Integer)((Object)items));
        features.put(SpreadProperties.SetF7TypeCellMethod.SELECTTYPE.k(), selectType);
        features.put(SpreadProperties.SetF7TypeCellMethod.DISPLAYSTYLE.k(), dst);
        if (this.isBatch) {
            this.orderlist.put(key, features);
        } else {
            SpreadClientInvoker.invokeSetF7TypeCellMethod(this.view, this.spreadKey, features);
        }
    }

    public void lockCell(int r, int c, int rc, int cc) {
        Map<String, Object> cell = SpreadEasyInvoker.packRangeFeature(r, c, rc, cc);
        if (this.isBatch) {
            ArrayList<Map<String, Object>> cells = (ArrayList<Map<String, Object>>)this.orderlist.get(SpreadProperties.LockCellMethod.LOACKCELL.k());
            if (cells == null) {
                cells = new ArrayList<Map<String, Object>>();
            }
            cells.add(cell);
            this.orderlist.put(SpreadProperties.LockCellMethod.LOACKCELL.k(), cells);
        } else {
            ArrayList<Map<String, Object>> cells = new ArrayList<Map<String, Object>>();
            cells.add(cell);
            SpreadClientInvoker.invokeLockCellMethod(this.view, this.spreadKey, cells);
        }
    }

    public void lockCell(List<Map<String, Object>> cells) {
        if (!cells.isEmpty()) {
            if (this.isBatch) {
                ArrayList<Map<String, Object>> list = (ArrayList<Map<String, Object>>)this.orderlist.get(SpreadProperties.LockCellMethod.LOACKCELL.k());
                if (list == null) {
                    list = new ArrayList<Map<String, Object>>(16);
                }
                list.addAll(cells);
                this.orderlist.put(SpreadProperties.LockCellMethod.LOACKCELL.k(), list);
            } else {
                SpreadClientInvoker.invokeLockCellMethod(this.view, this.spreadKey, cells);
            }
        }
    }

    public void unlockCell(int r, int c, int rc, int cc) {
        Map<String, Object> cell = SpreadEasyInvoker.packRangeFeature(r, c, rc, cc);
        if (this.isBatch) {
            ArrayList<Map<String, Object>> cells = (ArrayList<Map<String, Object>>)this.orderlist.get(SpreadProperties.UnlockCellMethod.UNLOACKCELL.k());
            if (cells == null) {
                cells = new ArrayList<Map<String, Object>>();
            }
            cells.add(cell);
            this.orderlist.put(SpreadProperties.UnlockCellMethod.UNLOACKCELL.k(), cells);
        } else {
            ArrayList<Map<String, Object>> cells = new ArrayList<Map<String, Object>>();
            cells.add(cell);
            SpreadClientInvoker.invokeUnLockCellMethod(this.view, this.spreadKey, cells);
        }
    }

    public void setColumnsWidth(int col, int num) {
        List<Integer> cols;
        Map<String, Object> map;
        String key = SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k() + num;
        if (this.isBatch) {
            map = (Map)this.orderlist.get(key);
            cols = new ArrayList();
            if (map != null) {
                cols = (List)map.get(SpreadProperties.SetColumnsWidthMethod.INDEX.k());
            } else {
                map = new HashMap();
            }
        } else {
            map = new HashMap();
            cols = new ArrayList<Integer>();
        }
        cols.add(col);
        this.fillIndexAndNum(map, num, cols);
        if (this.isBatch) {
            this.orderlist.put(key, map);
        } else {
            SpreadClientInvoker.invokeSetColumsWidthMethod(this.view, this.spreadKey, map);
        }
    }

    private void fillIndexAndNum(Map<String, Object> map, int num, Object indexs) {
        map.put(SpreadProperties.SetColumnsWidthMethod.INDEX.k(), indexs);
        map.put(SpreadProperties.SetColumnsWidthMethod.NUM.k(), num);
    }

    public void setColumnsWidth(List<Integer> colIndexs, int num) {
        if (this.isBatch) {
            String key = SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k() + num;
            HashMap<String, Object> map = (HashMap<String, Object>)this.orderlist.get(key);
            List<Integer> oldcColindex = new ArrayList<Integer>();
            if (map != null) {
                oldcColindex = (List)map.get(SpreadProperties.SetColumnsWidthMethod.INDEX.k());
            } else {
                map = new HashMap<String, Object>();
            }
            oldcColindex.addAll(colIndexs);
            this.fillIndexAndNum(map, num, oldcColindex);
            this.orderlist.put(key, map);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            this.fillIndexAndNum(map, num, colIndexs);
            SpreadClientInvoker.invokeSetColumsWidthMethod(this.view, this.spreadKey, map);
        }
    }

    public void setRowsHeight(List<Integer> rowIndexs, int height) {
        if (this.isBatch) {
            String key = SpreadProperties.SetRowsHeightMethod.SETROWSHEIGHT.k() + height;
            HashMap<String, Object> map = (HashMap<String, Object>)this.orderlist.get(key);
            List<Integer> oldIndexs = new ArrayList(16);
            if (map != null) {
                oldIndexs = (List)map.get(SpreadProperties.SetRowsHeightMethod.INDEX.k());
            } else {
                map = new HashMap<String, Object>(16);
            }
            oldIndexs.addAll(rowIndexs);
            this.fillIndexAndNum(map, height, oldIndexs);
            this.orderlist.put(key, map);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            this.fillIndexAndNum(map, height, rowIndexs);
            SpreadClientInvoker.invokeSetRowsHeightMethod(this.view, this.spreadKey, map);
        }
    }

    public void setFrozenSheet(int r, int c, int tr, int tc, String flc, int si) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        features.put(SpreadProperties.SetFrozenSheetMethod.R.k(), r);
        features.put(SpreadProperties.SetFrozenSheetMethod.C.k(), c);
        features.put(SpreadProperties.SetFrozenSheetMethod.TR.k(), tr);
        features.put(SpreadProperties.SetFrozenSheetMethod.TC.k(), tc);
        features.put(SpreadProperties.SetFrozenSheetMethod.FLC.k(), flc);
        features.put(SpreadProperties.SetFrozenSheetMethod.SI.k(), si);
        SpreadClientInvoker.invokeSetFrozenSheetMethod(this.view, this.spreadKey, features);
    }

    public void setStyle(int r, int c, int rc, int cc, Map<String, Object> styleMap) {
        Map<String, Object> features = SpreadEasyInvoker.packedStyleCellMap(SpreadEasyInvoker.getSingleRanges(r, c, rc, cc), styleMap);
        if (this.isBatch) {
            ArrayList<Map<String, Object>> list = (ArrayList<Map<String, Object>>)this.orderlist.get(SpreadProperties.SetCellStyleMethod.SETCELLSTYLE.k());
            if (list == null) {
                list = new ArrayList<Map<String, Object>>(16);
                this.orderlist.put(SpreadProperties.SetCellStyleMethod.SETCELLSTYLE.k(), list);
            }
            list.add(features);
        } else {
            SpreadClientInvoker.invokeSetCellStyleMethod(this.view, this.spreadKey, Lists.newArrayList((Object[])new Map[]{features}));
        }
    }

    public void setStyle(List<Map<String, Object>> rangeList, Map<String, Object> styleMap) {
        Map<String, Object> features = SpreadEasyInvoker.packedStyleCellMap(rangeList, styleMap);
        if (this.isBatch) {
            ArrayList<Map<String, Object>> list = (ArrayList<Map<String, Object>>)this.orderlist.get(SpreadProperties.SetCellStyleMethod.SETCELLSTYLE.k());
            if (list == null) {
                list = new ArrayList<Map<String, Object>>(16);
                this.orderlist.put(SpreadProperties.SetCellStyleMethod.SETCELLSTYLE.k(), list);
            }
            list.add(features);
        } else {
            SpreadClientInvoker.invokeSetCellStyleMethod(this.view, this.spreadKey, Lists.newArrayList((Object[])new Map[]{features}));
        }
    }

    public static Map<String, Object> packedUpdateCellMap(int r, int c, Object value) {
        return SpreadEasyInvoker.packedCellMap(r, c, value, false);
    }

    public static Map<String, Object> packedFormulaCellMap(int r, int c, Object value) {
        return SpreadEasyInvoker.packedCellMap(r, c, value, true);
    }

    private static Map<String, Object> packedCellMap(int r, int c, Object val, boolean isFormula) {
        HashMap<String, Object> valMap = new HashMap<String, Object>();
        valMap.put(SpreadProperties.UpdataValueMethod.R.k(), r);
        valMap.put(SpreadProperties.UpdataValueMethod.C.k(), c);
        valMap.put(isFormula ? SpreadProperties.SetFormulaMethod.F.k() : SpreadProperties.UpdataValueMethod.V.k(), val);
        return valMap;
    }

    public static Map<String, Object> packedStyleCellMap(List<Map<String, Object>> rangeList, Map<String, Object> styleMap) {
        HashMap<String, Object> features = new HashMap<String, Object>(16);
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        if (MapUtils.isNotEmpty(styleMap)) {
            features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
        }
        return features;
    }

    public static Map<String, Object> packRangeFeature(int r, int c, int rc, int cc) {
        HashMap<String, Object> feature = new HashMap<String, Object>();
        feature.put(SpreadProperties.GetRangeValues.R.k(), r);
        feature.put(SpreadProperties.GetRangeValues.C.k(), c);
        feature.put(SpreadProperties.GetRangeValues.RC.k(), rc);
        feature.put(SpreadProperties.GetRangeValues.CC.k(), cc);
        return feature;
    }

    public Map<String, Object> packedMenuItemMap(String itemName, String itemText, String[] workArea) {
        HashMap<String, Object> item = new HashMap<String, Object>(10);
        item.put(SpreadProperties.AddContextMenuItemsMethod.NAME.k(), itemName);
        item.put(SpreadProperties.AddContextMenuItemsMethod.TEXT.k(), itemText);
        item.put(SpreadProperties.AddContextMenuItemsMethod.WORKAREA.k(), workArea);
        return item;
    }

    public static void setColumnVisble(IClientViewProxy view, String spreadKey, int[] colArray, boolean isVisible) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        features.put(SpreadProperties.SetColumnsVisible.COLS.k(), colArray);
        features.put(SpreadProperties.SetColumnsVisible.VALUE.k(), isVisible);
        SpreadClientInvoker.invokeSetColumnsVisibleMethod(view, spreadKey, features);
    }

    public static void setRowsVisble(IClientViewProxy view, String spreadKey, int[] rowArray, boolean isVisible) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        features.put(SpreadProperties.SetRowsVisible.ROWS.k(), rowArray);
        features.put(SpreadProperties.SetRowsVisible.VALUE.k(), isVisible);
        SpreadClientInvoker.invokeSetRowsVisibleMethod(view, spreadKey, features);
    }

    public void setWorksheetOptions(String optionkey, Object optionValue) {
        HashMap workSheetOptions = new HashMap();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(optionkey, optionValue);
        workSheetOptions.put(SpreadProperties.SetWorkSheetOptions.OPTIONS.k(), options);
        SpreadClientInvoker.invokeSetWorksheetOptions(this.view, this.spreadKey, Lists.newArrayList((Object[])new Map[]{workSheetOptions}));
    }

    public void addContextMenuItem(String itemName, String itemText, String[] workArea) {
        Map<String, Object> item = this.packedMenuItemMap(itemName, itemText, workArea);
        if (this.isBatch) {
            ArrayList<Map<String, Object>> list = (ArrayList<Map<String, Object>>)this.orderlist.get(SpreadProperties.AddContextMenuItemsMethod.ADDCONTENTMENUITEMS.k());
            if (list == null) {
                list = new ArrayList<Map<String, Object>>(16);
            }
            list.add(item);
            this.orderlist.put(SpreadProperties.AddContextMenuItemsMethod.ADDCONTENTMENUITEMS.k(), list);
        } else {
            ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(16);
            items.add(item);
            HashMap<String, Object> features = new HashMap<String, Object>();
            features.put(SpreadProperties.AddContextMenuItemsMethod.CALLBACK.k(), "invokeAction");
            features.put(SpreadProperties.AddContextMenuItemsMethod.ITEMS.k(), items);
            SpreadClientInvoker.addContextMenuItemsMethod(this.view, this.spreadKey, features);
        }
    }

    public void addContextMenuItemAndSubMenu(String itemName, String itemText, String[] workArea, List<Map<String, Object>> subMenuItems) {
        Map<String, Object> item = this.packedMenuItemMap(itemName, itemText, workArea);
        item.put(SpreadProperties.AddContextMenuItemsMethod.SUBMENU.k(), subMenuItems);
        if (this.isBatch) {
            ArrayList<Map<String, Object>> list = (ArrayList<Map<String, Object>>)this.orderlist.get(SpreadProperties.AddContextMenuItemsMethod.ADDCONTENTMENUITEMS.k());
            if (list == null) {
                list = new ArrayList<Map<String, Object>>(16);
            }
            list.add(item);
            this.orderlist.put(SpreadProperties.AddContextMenuItemsMethod.ADDCONTENTMENUITEMS.k(), list);
        } else {
            ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(16);
            items.add(item);
            HashMap<String, Object> features = new HashMap<String, Object>();
            features.put(SpreadProperties.AddContextMenuItemsMethod.CALLBACK.k(), "invokeAction");
            features.put(SpreadProperties.AddContextMenuItemsMethod.ITEMS.k(), items);
            SpreadClientInvoker.addContextMenuItemsMethod(this.view, this.spreadKey, features);
        }
    }

    public void invokeSetCellTag(List<Map<String, Object>> pointParms) {
        if (this.isBatch) {
            ArrayList<Map<String, Object>> list = (ArrayList<Map<String, Object>>)this.orderlist.get(SpreadProperties.P.setCellTag.getName());
            if (list == null) {
                list = new ArrayList<Map<String, Object>>(16);
            }
            list.addAll(pointParms);
            this.orderlist.put(SpreadProperties.P.setCellTag.getName(), list);
        } else {
            SpreadClientInvoker.invokeSetCellTag(this.view, this.spreadKey, pointParms);
        }
    }

    public void setHyperLinkCellSimple(int r, int c, int rc, int cc, String callBackName) {
        Map<String, Object> features = SpreadEasyInvoker.packedStyleCellMap(SpreadEasyInvoker.getSingleRanges(r, c, rc, cc), null);
        features.put(SpreadProperties.setHyperLinkCellMethod.CALLBACK.k(), "invokeAction");
        features.put(SpreadProperties.setHyperLinkCellMethod.INVOKEMETHOD.k(), callBackName);
        SpreadClientInvoker.setHyperLinkCellMethod(this.view, this.spreadKey, features);
    }

    public void setHyperLinkCellSimple(List<Map<String, Object>> rangeList, String callBackName) {
        Map<String, Object> features = SpreadEasyInvoker.packedStyleCellMap(rangeList, null);
        features.put(SpreadProperties.setHyperLinkCellMethod.CALLBACK.k(), "invokeAction");
        features.put(SpreadProperties.setHyperLinkCellMethod.INVOKEMETHOD.k(), callBackName);
        SpreadClientInvoker.setHyperLinkCellMethod(this.view, this.spreadKey, features);
    }

    public void lockAllToolbarItems(boolean islock, SpreadProperties.ToolbarItemNamesEnum ... items) {
        int lockinfo = islock ? 1 : 0;
        ArrayList<Map> toolbarItems = new ArrayList<Map>(items.length);
        for (SpreadProperties.ToolbarItemNamesEnum itemNamesEnum : items) {
            toolbarItems.add(MapInitHelper.ofMap((Object)SpreadProperties.LockToolbarItemsMethod.NAME.k(), (Object)itemNamesEnum, (Object)SpreadProperties.LockToolbarItemsMethod.ISLOCK.k(), (Object)lockinfo));
        }
        SpreadClientInvoker.invokeLockToolbarItems(this.view, this.spreadKey, toolbarItems);
    }

    public void batchDelRow(int startrow, int count) {
        LinkedHashMap<String, Object> map = SpreadEasyInvoker.packInsertMap(startrow, count);
        SpreadClientInvoker.invokeDelRow(this.view, this.spreadKey, map);
    }

    public void batchDelCol(int startrow, int count) {
        LinkedHashMap<String, Object> map = SpreadEasyInvoker.packInsertMap(startrow, count);
        SpreadClientInvoker.invokeDelCol(this.view, this.spreadKey, map);
    }

    private static LinkedHashMap<String, Object> packInsertMap(int startindex, int count) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(16);
        map.put("status", true);
        ArrayList rangeList = new ArrayList();
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        data.put("index", startindex);
        data.put("count", count);
        rangeList.add(data);
        map.put("data", rangeList);
        return map;
    }

    public void getRangeValuesFromSpread(ISheetManager sm) {
        ISheet sheet = sm.getSheet();
        int maxRowCount = sheet.getMaxRowCount();
        int maxColumnCount = sheet.getMaxColumnCount();
        Map<String, Object> features = SpreadEasyInvoker.packedStyleCellMap(SpreadEasyInvoker.getSingleRanges(0, 0, maxRowCount, maxColumnCount), null);
        features.put(SpreadProperties.GetRangeValues.COMPRESSION.k(), true);
        SpreadClientInvoker.invokeGetRangeValueMethod(this.view, this.spreadKey, features);
    }

    public void invokeF7OrLockCell(ISheetManager sm, boolean isReport) {
        this.setBatch(true);
        sm.getAreaRanges().forEach(m -> this.invokeF7OrLockCell((IDataAreaSetting)m, null, isReport));
        this.startToInvoke();
    }

    public void invokeF7OrLockCell(IDataAreaSetting areaSetting, IFloatInfo floatInfo, boolean isReport) {
        boolean isBreak = false;
        if (areaSetting.isRelation()) {
            Tuple tuple = areaSetting.getRelationFloatRanges();
            this.doF7OrLockCell(isReport, (List)tuple.k);
            this.doF7OrLockCell(false, (List)tuple.v);
            return;
        }
        if (floatInfo == null) {
            isBreak = true;
        }
        for (IFloatInfo info : areaSetting.getFloatInfos()) {
            if (!isBreak && !info.getOriginalRange().equals(floatInfo.getOriginalRange())) continue;
            Tuple tuple = areaSetting.getFloatDimRanges(info);
            this.doF7OrLockCell(isReport, (List)tuple.k);
            this.doF7OrLockCell(false, (List)tuple.v);
            if (isBreak) continue;
            return;
        }
    }

    public void doF7OrLockCell(boolean isF7, List<RangeModel> rangeModels) {
        if (CollectionUtils.isNotEmpty(rangeModels)) {
            rangeModels.forEach(r -> {
                if (isF7) {
                    this.setF7TypeCell(r.getY_start(), r.getX_start(), r.getRowSize(), r.getColSize(), 0, 0);
                } else {
                    this.lockCell(r.getY_start(), r.getX_start(), r.getRowSize(), r.getColSize());
                }
            });
        }
    }

    public void resetCellStyle(int r, int c, int rc, int cc) {
        List<Map<String, Object>> cells = SpreadEasyInvoker.getSingleRanges(r, c, rc, cc);
        if (this.isBatch) {
            List<Map<String, Object>> oldMapList = (List<Map<String, Object>>)this.orderlist.get(SpreadProperties.ResetCellMethod.RESETCELL.k());
            if (oldMapList == null) {
                oldMapList = cells;
            } else {
                oldMapList.addAll(cells);
            }
            this.orderlist.put(SpreadProperties.ResetCellMethod.RESETCELL.k(), oldMapList);
        } else {
            SpreadClientInvoker.invokeResetCellMethod(this.view, this.spreadKey, SpreadEasyInvoker.packedStyleCellMap(cells, null));
        }
    }

    public static void setCellStyleMethod(ISheetManager sm, IClientViewProxy clientViewProxy, String spreadKey, Map<String, Object> styleMap, boolean isOnlyDataArea, Predicate<Cell> predicate) {
        ArrayList<Map<String, Object>> rangeList = new ArrayList<Map<String, Object>>(16);
        if (!isOnlyDataArea) {
            sm.getSheet().iteratorCells(cell -> {
                if (predicate.test((Cell)cell)) {
                    rangeList.add(SpreadEasyInvoker.packRangeFeature(cell.getRow(), cell.getCol(), 1, 1));
                }
            });
        } else {
            sm.getAreaRanges().forEach(m -> sm.getSheet().iteratorRangeCells(new RangeModel(m.getAreaRange()), cell -> {
                if (predicate.test((Cell)cell)) {
                    rangeList.add(SpreadEasyInvoker.packRangeFeature(cell.getRow(), cell.getCol(), 1, 1));
                }
            }));
        }
        if (CollectionUtils.isNotEmpty(rangeList)) {
            SpreadClientInvoker.invokeSetCellStyleMethod(clientViewProxy, spreadKey, Lists.newArrayList((Object[])new Map[]{SpreadEasyInvoker.packedStyleCellMap(rangeList, styleMap)}));
        }
    }

    public void invokeCallBack(String callBackMethod) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put(SpreadProperties.CallBackActionMethod.CALLBACK.k(), "invokeAction");
        params.put(SpreadProperties.CallBackActionMethod.INVOKEMETHOD.k(), callBackMethod);
        SpreadClientInvoker.invokeCallBack(this.view, this.spreadKey, params);
    }
}

