/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.AfterMoveEntryEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.arearangedim.DefaultRowColDimensionEntry;
import kd.epm.emr.business.template.arearangedim.IRowColDimensionEntry;
import kd.epm.emr.business.template.areasetting.DataAreaSetting;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.areasetting.IFloatInfo;
import kd.epm.emr.business.template.dimension.BatchMembEntity;
import kd.epm.emr.business.template.dimension.IDimension;
import kd.epm.emr.business.template.dimension.RowColDimMember;
import kd.epm.emr.business.template.dimension.SortDiminfo;
import kd.epm.emr.business.template.headerarea.HeaderObject;
import kd.epm.emr.business.template.headerarea.IHeaderInfo;
import kd.epm.emr.business.template.partition.IRowColPartition;
import kd.epm.emr.business.template.partition.RowColPartition;
import kd.epm.emr.business.template.service.impl.TemplateMemberServiceImpl;
import kd.epm.emr.common.spread.command.rangedefined.CellArea;
import kd.epm.emr.common.template.EmrDefaultDimMember;
import kd.epm.emr.common.template.enums.SortTypeEnum;
import kd.epm.emr.formplugin.report.helper.SpreadMemberHelper;
import kd.epm.emr.formplugin.template.AbstractTemplateBasePlugin;
import kd.epm.emr.formplugin.template.helper.DimPropertyHelper;
import kd.epm.emr.formplugin.template.helper.TemplateProcessHelper;
import kd.epm.epbs.business.member.f7.NewF7Utils;
import kd.epm.epbs.business.model.f7.MemberF7Parameter;
import kd.epm.epbs.common.enums.RangeF7PropertyCataEnum;
import kd.epm.epbs.common.enums.model.DimTypeEnum;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.model.DefaultDimMember;
import kd.epm.epbs.common.model.IDimensionMember;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.PropValueBean;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsModelCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsPropCache;
import kd.epm.epbs.common.model.cache.EpbsPropCacheHelper;
import kd.epm.epbs.common.util.DynamicEnum;
import kd.epm.epbs.common.util.ExcelUtils;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.Point;
import kd.epm.epbs.common.util.RangeModel;
import kd.epm.epbs.common.util.SpreadAreaUtil;
import kd.epm.epbs.formplugin.AbstractBaseFormPlugin;
import kd.epm.epbs.formplugin.EpbsBaseFunction;
import kd.epm.epbs.formplugin.ICommunicateBtwForm;
import kd.epm.epbs.formplugin.model.memberf7.bean.EpbsSelectedMember;
import org.elasticsearch.common.util.set.Sets;

public abstract class AbstractFloatSettingPlugin
extends AbstractBaseFormPlugin
implements CellClickListener,
RowClickEventListener,
EpbsBaseFunction {
    protected static final Log log = LogFactory.getLog(AbstractFloatSettingPlugin.class);
    public static final String FLOATOFFSET = "floatoffset";
    public static final String FLOATRANGE = "floatrange";
    public static final String FLOATSIZE = "floatsize";
    public static final String SORTRULE = "sortrule";
    public static final String MEMBERDISPLAY = "memberdisplay";
    public static final String AREASETTING = "areaSetting";
    public static final String ENTRYENTITY = "entryentity";
    public static final String ITEM_KEY = "itemKey";
    public static final String CURRENT_INDEX_ROW = "currentIndexRow";
    public static final String BTN_CONFIRM = "btn_confirm";
    public static final String BTN_CANCEL = "btn_cancel";
    public static final String TOOLBARAPROWPARTION = "toolbaraprowpartion";
    public static final String NEWENTRY = "newentry";
    public static final String SELECTAREA = "selectarea";
    public static final String DATAAREA = "dataarea";
    public static final String SORTTOPSETTING = "sorttopsetting";
    public static final String ORDERBY = "orderby";
    public static final String TITLE = "title";
    public static final String SORTORDER = "sortorder";
    public static final String TOP = "top";
    public static final String FLOATSTARTPOS = "floatstartpos";
    public static final String EXPANDTYPE = "expandtype";
    private Set<String> ignoreChangeProperties = null;
    private IDataAreaSetting multiAreaSetting = null;
    private BatchMembEntity entityModel = null;
    private Map<String, String> fieldKeys = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAPROWPARTION});
        this.addClickListeners(new String[]{BTN_CONFIRM, BTN_CANCEL});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addCellClickListener((CellClickListener)this);
        entryGrid.addRowClickListener((RowClickEventListener)this);
        this.addClickListeners(new String[]{"dim0", "dim1", "dim2", "dim3", "dim4", "dim5", "dim6", "dim7", "dim8", "dim9", "dim10", "dim11", "dim12", "dim13", "dim14", "dim15", "dim16", "dim17", "dim18", "dim19", "dim20", "dim21", "dim22", SORTRULE});
    }

    public void afterCreateNewData(EventObject e) {
        String area = (String)this.getFormCustomParam(AREASETTING);
        if (StringUtils.isNotEmpty((String)area)) {
            this.initRCMembEntry();
            List<IFloatInfo> floatInfos = this.getFloatInfos(this.getMultiAreaSetting(), this.isRow());
            this.loadEntry(floatInfos);
            this.setDropDownList();
        }
        this.putParentViewCache("floatOffset", this.getModel().getValue(FLOATOFFSET) + "");
    }

    protected void setDropDownList() {
        IDataAreaSetting areaSetting = this.getMultiAreaSetting();
        List<String> list = TemplateProcessHelper.getFloatStartPos(areaSetting, this.isRow());
        ComboEdit comboEdit = (ComboEdit)this.getControl(FLOATSTARTPOS);
        ArrayList items = new ArrayList(10);
        ArrayList<String[]> keysAndValues = new ArrayList<String[]>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            String[] keysAndValue = new String[]{list.get(i), String.valueOf(i)};
            keysAndValues.add(keysAndValue);
        }
        keysAndValues.forEach(new DynamicEnum(items));
        comboEdit.setComboItems(items);
        Object floatOffsetObj = this.getModel().getValue(FLOATOFFSET);
        int floatOffset = 0;
        if (floatOffsetObj instanceof Integer) {
            floatOffset = (Integer)floatOffsetObj;
        }
        if (!items.isEmpty() && items.size() > floatOffset) {
            this.getModel().setValue(FLOATSTARTPOS, (Object)String.valueOf(items.size() - floatOffset - 1));
        }
    }

    protected void initRCMembEntry() {
        List allDims = this.getTemplateMemberService().getAllDims(Long.valueOf(this.getBizModelId()));
        if (allDims != null) {
            HashMap<String, IDimension> dimObjsMap = new HashMap<String, IDimension>(16);
            allDims.forEach(dimObj -> dimObjsMap.put(dimObj.getNumber(), (IDimension)dimObj));
            log.info("initRCMembEntry all number:{}", (Object)dimObjsMap.keySet().toString());
            this.initRCMembEntry(dimObjsMap);
        }
    }

    private void initRCMembEntry(Map<String, IDimension> dimObjs) {
        BatchMembEntity membsEntity = new BatchMembEntity();
        IDataAreaSetting as = this.getMultiAreaSetting();
        if (as == null) {
            return;
        }
        if (!this.isRow()) {
            TextEdit textEdit = (TextEdit)this.getControl(FLOATSIZE);
            textEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5217\u6570", (String)"AbstractFloatSettingPlugin_0", (String)"epm-emr-formplugin", (Object[])new Object[0])));
        }
        List dims = null;
        dims = this.isRow() ? as.getRowdims() : as.getColdims();
        if (dims != null) {
            log.info("dim row :{}", (Object)dims.toString());
            dims.forEach(d -> {
                IDimension obj = (IDimension)dimObjs.get(d);
                if (obj != null) {
                    membsEntity.addDimension(obj.getId().longValue(), obj.getNumber(), obj.getName(), obj.getDSeq().intValue(), obj.getMemberModel());
                }
            });
            HashMap<String, String> fieldKeys = new HashMap<String, String>(16);
            if (!membsEntity.getDimensions().isEmpty()) {
                int seq = 0;
                for (IDimension dim : membsEntity.getDimensions()) {
                    log.info("add textEdit:{}", (Object)("dim" + seq));
                    TextEdit textEdit = (TextEdit)this.getControl("dim" + seq++);
                    textEdit.setCaption(new LocaleString(dim.getName()));
                    textEdit.setVisible(null, true);
                    fieldKeys.put(dim.getNumber(), textEdit.getKey());
                }
            }
            this.cacheFieldKeys(fieldKeys);
        }
        this.cacheBatMembEntityModel(membsEntity);
    }

    protected List<IFloatInfo> getFloatInfos(IDataAreaSetting multiAreaSetting, boolean isRow) {
        ArrayList<IFloatInfo> floatInfos = new ArrayList<IFloatInfo>();
        if (multiAreaSetting.getFloatInfos() != null) {
            for (IFloatInfo floatInfo : multiAreaSetting.getFloatInfos()) {
                if (isRow && floatInfo.getRow_offset() > -1) {
                    floatInfos.add(floatInfo);
                    continue;
                }
                if (isRow || floatInfo.getCol_offset() <= -1) continue;
                floatInfos.add(floatInfo);
            }
        }
        return floatInfos;
    }

    protected void loadEntry(List<IFloatInfo> floatInfos) {
        if (floatInfos == null || floatInfos.isEmpty()) {
            return;
        }
        IDataModel dataModel = this.getModel();
        this.multiAreaSetting = this.getMultiAreaSetting();
        dataModel.setValue(FLOATOFFSET, (Object)floatInfos.get(0).getFloat_offset());
        dataModel.batchCreateNewEntryRow(ENTRYENTITY, floatInfos.size());
        int fs = 0;
        BatchMembEntity batchMembEntity = this.sync(this.multiAreaSetting, this.getBatMembEntityModel());
        List memberRows = batchMembEntity.getMemberRows();
        List dimensions = batchMembEntity.getDimensions();
        this.fieldKeys = this.getFieldKeys();
        List headerInfos = this.isRow() ? this.multiAreaSetting.getRowHeaders() : this.multiAreaSetting.getColHeaders();
        for (int i = 0; i < floatInfos.size(); ++i) {
            IFloatInfo floatInfo = floatInfos.get(i);
            fs = this.isRow() ? floatInfo.getRowEnd_offset() - floatInfo.getRow_offset() + 1 : floatInfo.getColEnd_offset() - floatInfo.getCol_offset() + 1;
            String floatRange = this.multiAreaSetting.getFloatRange(floatInfo, new RangeModel(this.multiAreaSetting.getAreaRange())).toString();
            RowColDimMember[] members = (RowColDimMember[])memberRows.get(i);
            dataModel.setValue(FLOATSIZE, (Object)fs, i);
            dataModel.setValue(FLOATRANGE, (Object)floatRange, i);
            dataModel.setValue(MEMBERDISPLAY, (Object)floatInfo.getMemberDisplay(), i);
            dataModel.setValue(EXPANDTYPE, (Object)floatInfo.getExpandType(), i);
            if ("1".equals(floatInfo.getExpandType())) {
                this.getView().setEnable(Boolean.valueOf(false), i, new String[]{FLOATSIZE});
            }
            dataModel.setValue(SORTRULE, (Object)this.getSortInfoName(floatInfo.getSortDimInfos(), headerInfos, floatRange, this.multiAreaSetting.getAreaRange()), i);
            for (int j = 0; j < members.length; ++j) {
                if (members[j] == null) continue;
                String dimNumber = ((IDimension)dimensions.get(j)).getNumber();
                dataModel.setValue(this.fieldKeys.get(dimNumber), (Object)this.getMembShowInfo(dimNumber, members[j]), i);
            }
        }
    }

    protected String getSortInfoName(List<SortDiminfo> sortInfoList, List<IHeaderInfo> headerInfos, String floatRange, String areaRange) {
        if (CollectionUtils.isEmpty(sortInfoList)) {
            return "";
        }
        String sortUP = ResManager.loadKDString((String)"\u5347\u5e8f", (String)"AbstractFloatSettingPlugin_1", (String)"epm-emr-formplugin", (Object[])new Object[0]);
        String sortDown = ResManager.loadKDString((String)"\u964d\u5e8f", (String)"AbstractFloatSettingPlugin_2", (String)"epm-emr-formplugin", (Object[])new Object[0]);
        String sortbyMem = ResManager.loadKDString((String)"\u6210\u5458\u987a\u5e8f", (String)"AbstractFloatSettingPlugin_3", (String)"epm-emr-formplugin", (Object[])new Object[0]);
        ArrayList<String> showList = new ArrayList<String>(sortInfoList.size());
        for (SortDiminfo sortInfo : sortInfoList) {
            StringBuilder sb = new StringBuilder();
            String orderBy = this.getOrderBy(floatRange, areaRange, headerInfos, sortInfo);
            String sortBy = "0".equals(sortInfo.getSortOrder()) ? sortUP : ("1".equals(sortInfo.getSortOrder()) ? sortDown : sortbyMem);
            sb.append(orderBy).append("\uff0c").append(sortBy);
            if (sortInfo.getTop() != null) {
                sb.append("\uff0cTOP\uff1a").append(sortInfo.getTop());
            }
            showList.add(sb.toString());
        }
        return String.join((CharSequence)"; \n", showList);
    }

    protected String getMembShowInfo(String dimNumber, RowColDimMember member) {
        if (member != null) {
            return TemplateProcessHelper.getMemberShowInfo(this.getModelId(), dimNumber, member.getMembers());
        }
        return null;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propKey = e.getProperty().getName();
        if (this.ignoreChangeProperties != null && this.ignoreChangeProperties.contains(propKey)) {
            return;
        }
        String currentIndexRow = this.getPageCache().get(CURRENT_INDEX_ROW);
        int index = -1;
        if (StringUtils.isNotEmpty((String)currentIndexRow)) {
            index = Integer.parseInt(currentIndexRow);
        }
        if (propKey.startsWith("dim")) {
            if (index == -1) {
                return;
            }
            if (e.getChangeSet()[0].getNewValue() == null || e.getChangeSet()[0].getNewValue() == "") {
                BatchMembEntity membersModel = this.getBatMembEntityModel();
                int fieldIndex = Integer.parseInt(propKey.substring(3));
                ((RowColDimMember[])membersModel.getMemberRows().get((int)index))[fieldIndex] = null;
                this.cacheBatMembEntityModel(membersModel);
            }
        } else {
            Object newValue = e.getChangeSet()[0].getNewValue();
            DynamicObject dynamicObject = e.getChangeSet()[0].getDataEntity();
            int entryRowIndex = dynamicObject.getDynamicObjectType() instanceof EntryType ? dynamicObject.getInt("seq") - 1 : 0;
            switch (propKey) {
                case "floatstartpos": {
                    IDataAreaSetting areaSetting = this.getMultiAreaSetting();
                    String rangeStart = areaSetting.getAreaRangeStart();
                    int startXY = this.isRow() ? ExcelUtils.pos2X((String)rangeStart) : ExcelUtils.pos2Y((String)rangeStart);
                    int headerSize = this.isRow() ? areaSetting.getRowHeaders().size() : areaSetting.getColHeaders().size();
                    int floatStartInit = startXY - headerSize;
                    if (floatStartInit < 0) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u884c\u7ef4\u5ea6\u9884\u7559\u6807\u9898\u884c\u5355\u5143\u683c\u7a7a\u95f4\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5\u8c03\u6574\u540e\u518d\u8bbe\u7f6e\u3002", (String)"AbstractFloatSettingPlugin_4", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    int newPos = newValue == null ? 0 : Integer.parseInt(newValue + "");
                    int newOffset = floatStartInit - newPos;
                    this.putParentViewCache("floatOffset", newOffset + "");
                    int cnt = this.getModel().getEntryRowCount(ENTRYENTITY);
                    if (cnt > 0) {
                        int i;
                        String[] updatedRange = new String[cnt];
                        CellArea selectorArea = null;
                        if (index == -1) {
                            index = 0;
                        }
                        for (i = 0; i < cnt; ++i) {
                            String range = (String)this.getModel().getValue(FLOATRANGE, i);
                            if (!StringUtils.isNotEmpty((String)range)) continue;
                            CellArea cellArea = new CellArea(range);
                            if (this.isRow()) {
                                cellArea.setC(newPos);
                            } else {
                                cellArea.setR(newPos);
                            }
                            updatedRange[i] = cellArea.toString();
                            if (i != index) continue;
                            if (this.isRow()) {
                                cellArea.setC(0);
                            } else {
                                cellArea.setR(0);
                            }
                            selectorArea = cellArea;
                        }
                        if (selectorArea != null) {
                            IFormView pv = this.getView().getParentView();
                            pv.getFormShowParameter().setCustomParam(FLOATRANGE, (Object)selectorArea.toString());
                            FormViewPluginProxy proxy = (FormViewPluginProxy)pv.getService(FormViewPluginProxy.class);
                            proxy.getPlugIns().forEach(plugin -> {
                                if (ICommunicateBtwForm.class.isAssignableFrom(plugin.getClass())) {
                                    ((ICommunicateBtwForm)ICommunicateBtwForm.class.cast(plugin)).communicateMsg();
                                }
                            });
                            this.getView().sendFormAction(pv);
                        }
                        areaSetting.getFloatInfos().forEach(fi -> {
                            if (this.isRow() && fi.getRow_offset() > -1) {
                                fi.setFloat_offset(newOffset);
                            } else if (!this.isRow() && fi.getCol_offset() > -1) {
                                fi.setFloat_offset(newOffset);
                            }
                        });
                        this.ignoreChangeProperties = Sets.newHashSet((Object[])new String[]{FLOATRANGE, FLOATOFFSET});
                        for (i = 0; i < cnt; ++i) {
                            this.getModel().setValue(FLOATRANGE, (Object)updatedRange[i], i);
                        }
                    }
                    this.getModel().setValue(FLOATOFFSET, (Object)newOffset);
                    break;
                }
                case "floatrange": {
                    String[] floatrangeSplit;
                    if (newValue == null || !StringUtils.isNotEmpty((String)((String)newValue)) || (floatrangeSplit = ((String)newValue).split(":")).length != 2) break;
                    Point startPoint = ExcelUtils.pos2Point((String)floatrangeSplit[0]);
                    Point endPoint = ExcelUtils.pos2Point((String)floatrangeSplit[1]);
                    this.ignoreChangeProperties = Collections.singleton(FLOATSIZE);
                    int floatsize = this.isRow() ? endPoint.y - startPoint.y + 1 : endPoint.x - startPoint.x + 1;
                    this.getModel().setValue(FLOATSIZE, (Object)String.valueOf(floatsize), entryRowIndex);
                    break;
                }
                case "floatsize": {
                    String[] floatrangeSplit;
                    String floatrange;
                    if (newValue == null || !StringUtils.isNotEmpty((String)(floatrange = dynamicObject.getString(FLOATRANGE))) || (floatrangeSplit = floatrange.split(":")).length != 2) break;
                    Point startPoint = ExcelUtils.pos2Point((String)floatrangeSplit[0]);
                    Point endPoint = ExcelUtils.pos2Point((String)floatrangeSplit[1]);
                    this.ignoreChangeProperties = Collections.singleton(FLOATRANGE);
                    String endPos = this.isRow() ? ExcelUtils.xy2Pos((int)endPoint.x, (int)(startPoint.y + (Integer)newValue - 1)) : ExcelUtils.xy2Pos((int)(startPoint.x + (Integer)newValue - 1), (int)endPoint.y);
                    this.getModel().setValue(FLOATRANGE, (Object)(floatrangeSplit[0] + ":" + endPos), entryRowIndex);
                    break;
                }
                case "sortrule": {
                    if (index == -1) {
                        return;
                    }
                    if (e.getChangeSet()[0].getNewValue() != null && e.getChangeSet()[0].getNewValue() != "") break;
                    BatchMembEntity membersModel = this.getBatMembEntityModel();
                    membersModel.getSortInfoList().set(index, null);
                    this.cacheBatMembEntityModel(membersModel);
                    break;
                }
                case "expandtype": {
                    if ("1".equals(newValue)) {
                        this.getView().setEnable(Boolean.valueOf(false), entryRowIndex, new String[]{FLOATSIZE});
                        this.getModel().setValue(FLOATSIZE, (Object)1, entryRowIndex);
                        break;
                    }
                    this.getView().setEnable(Boolean.valueOf(true), entryRowIndex, new String[]{FLOATSIZE});
                    break;
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String clickKey = ((Control)evt.getSource()).getKey();
        String currentIndexRow = this.getPageCache().get(CURRENT_INDEX_ROW);
        int index = -1;
        if (StringUtils.isNotEmpty((String)currentIndexRow)) {
            index = Integer.parseInt(currentIndexRow);
        }
        if (clickKey.equals(BTN_CONFIRM)) {
            if (this.validate()) {
                IDataAreaSetting areaSetting = this.getMultiAreaSetting();
                IDataAreaSetting newArea = this.sync(this.getBatMembEntityModel(), areaSetting);
                this.getView().returnDataToParent((Object)this.toByteSerialized(newArea));
                this.getView().close();
            }
        } else if (clickKey.equals(SORTRULE) && index != -1) {
            if (this.validate()) {
                this.openFloatSort(index);
            }
        } else if (clickKey.startsWith("dim") && index != -1) {
            this.openDimF7(clickKey, index);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        int rowIndex = cellClickEvent.getRow();
        this.getPageCache().put(CURRENT_INDEX_ROW, String.valueOf(rowIndex));
        if (fieldKey.equals(SORTRULE) || fieldKey.startsWith("dim")) {
            return;
        }
        if (FLOATRANGE.equals(fieldKey)) {
            this.putParentViewCache("pageId", this.getView().getPageId());
            this.putParentViewCache("floatRangeIndex", String.valueOf(cellClickEvent.getRow()));
        }
    }

    private void openFloatSort(int rowIndex) {
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        DynamicObject obj = this.getModel().getEntryRowEntity(ENTRYENTITY, eg.getSelectRows()[0]);
        BatchMembEntity batchMembEntity = this.getBatMembEntityModel();
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("epbs_floatsort_base");
        formShowParameter.setShowTitle(true);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SORTRULE));
        formShowParameter.setCustomParam("isRow", this.getFormCustomParam("isRow"));
        formShowParameter.setCustomParam("floatOffset", this.getModel().getValue(FLOATOFFSET));
        formShowParameter.setCustomParam(AREASETTING, this.getFormCustomParam(AREASETTING));
        formShowParameter.setCustomParam("modelid", (Object)this.getModelId());
        formShowParameter.setCustomParam(SELECTAREA, this.getModel().getValue(FLOATRANGE, rowIndex));
        formShowParameter.setCustomParam(DATAAREA, (Object)this.getMultiAreaSetting().getAreaRange());
        List sortDiminfoList = (List)batchMembEntity.getSortInfoList().get(rowIndex);
        if (CollectionUtils.isNotEmpty((Collection)sortDiminfoList)) {
            formShowParameter.setCustomParam(SORTTOPSETTING, (Object)this.toByteSerialized(sortDiminfoList));
        }
        this.getView().showForm(formShowParameter);
    }

    protected RowColDimMember toRowColDimMember(ListSelectedRowCollection rows) {
        RowColDimMember members = new RowColDimMember();
        if (CollectionUtils.isNotEmpty((Collection)rows)) {
            Map dataParams = rows.get(0).getDataMap();
            members.setViewId(IDUtils.toLong(dataParams.get("viewId")));
            members.setViewNumber((String)dataParams.get("viewNumber"));
            Object value = dataParams.get("chkfloat");
            if (value instanceof Boolean) {
                members.setFloat(((Boolean)value).booleanValue());
            } else {
                members.setFloat(false);
            }
            value = dataParams.get("chkaddnew");
            if (value instanceof Boolean) {
                members.setQuickAddNew(((Boolean)value).booleanValue());
            } else {
                members.setQuickAddNew(false);
            }
            Object _parent = dataParams.get("parent");
            if (_parent instanceof DynamicObject) {
                DynamicObject parent = (DynamicObject)_parent;
                DefaultDimMember defaultMember = new DefaultDimMember();
                defaultMember.setId(Long.valueOf(parent.getLong("id")));
                defaultMember.setNumber(parent.getString("number"));
                defaultMember.setName(parent.getString("name"));
                members.setDefaultParent((IDimensionMember)defaultMember);
            }
            for (ListSelectedRow row : rows) {
                EpbsSelectedMember member = (EpbsSelectedMember)row.getDataMap().get("selectMember");
                members.getMembers().add(AbstractFloatSettingPlugin.transMember(member));
            }
        }
        return members;
    }

    private static IDimensionMember transMember(EpbsSelectedMember selectData) {
        Long id = selectData.getId();
        String number = selectData.getNumber();
        String name = selectData.getName();
        EmrDefaultDimMember member = new EmrDefaultDimMember(id, name, number);
        member.setScope(selectData.getScope());
        member.setType(selectData.getType());
        member.setLongNumber(selectData.getLongNumber());
        member.setViewId(Long.valueOf(selectData.getViewId()));
        member.setViewNumber(selectData.getViewNumber());
        member.setParentNum(selectData.getParentNumber());
        return member;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ((actionId.equals("memberselect") || "floatEntitySelect".equals(actionId)) && closedCallBackEvent.getReturnData() instanceof ListSelectedRowCollection) {
            RowColDimMember backMemb = this.toRowColDimMember((ListSelectedRowCollection)closedCallBackEvent.getReturnData());
            if (backMemb == null) {
                return;
            }
            if (backMemb.getMembers().isEmpty()) {
                backMemb = null;
            }
            String fieldKey = this.getPageCache().get("currentEntityField");
            IDataModel dataModel = this.getModel();
            String cuurrentIndexRow = this.getPageCache().get(CURRENT_INDEX_ROW);
            int rowIndex = dataModel.getEntryCurrentRowIndex(ENTRYENTITY);
            if (StringUtils.isNotEmpty((String)cuurrentIndexRow)) {
                rowIndex = Integer.parseInt(cuurrentIndexRow);
            }
            BatchMembEntity membersModel = this.getBatMembEntityModel();
            int fieldIndex = Integer.parseInt(fieldKey.substring(3));
            ((RowColDimMember[])membersModel.getMemberRows().get((int)rowIndex))[fieldIndex] = backMemb;
            String dimNumber = ((IDimension)membersModel.getDimensions().get(fieldIndex)).getNumber();
            dataModel.setValue(fieldKey, (Object)this.getMembShowInfo(dimNumber, backMemb));
            this.cacheBatMembEntityModel(membersModel);
            this.getPageCache().remove(CURRENT_INDEX_ROW);
        } else if (actionId.equals(SORTRULE)) {
            Object returnData = closedCallBackEvent.getReturnData();
            String currentIndexRow = this.getPageCache().get(CURRENT_INDEX_ROW);
            IDataModel dataModel = this.getModel();
            int rowIndex = dataModel.getEntryCurrentRowIndex(ENTRYENTITY);
            if (StringUtils.isNotEmpty((String)currentIndexRow)) {
                rowIndex = Integer.parseInt(currentIndexRow);
            }
            BatchMembEntity membersModel = this.getBatMembEntityModel();
            if (returnData != null) {
                if ("reset".equals(returnData)) {
                    ((List)membersModel.getSortInfoList().get(rowIndex)).clear();
                    this.getModel().setValue(SORTRULE, (Object)"", rowIndex);
                } else if (returnData instanceof String) {
                    List temp = (List)this.deSerializedBytes((String)returnData);
                    String floatRange = (String)dataModel.getValue(FLOATRANGE, rowIndex);
                    membersModel.getSortInfoList().set(rowIndex, temp);
                    List headerInfos = this.isRow() ? this.getMultiAreaSetting().getRowHeaders() : this.getMultiAreaSetting().getColHeaders();
                    this.getModel().setValue(SORTRULE, (Object)this.getSortInfoName(temp, headerInfos, floatRange, this.getMultiAreaSetting().getAreaRange()), rowIndex);
                }
            }
            this.getView().updateView(SORTRULE, rowIndex);
            this.cacheBatMembEntityModel(membersModel);
            this.getPageCache().remove(CURRENT_INDEX_ROW);
        }
    }

    private String getOrderBy(String floatArea, String areaRange, List<IHeaderInfo> headerInfos, SortDiminfo sortDiminfo) {
        String temp = "";
        if (this.isRow()) {
            temp = ResManager.loadKDString((String)"\u5217", (String)"AbstractFloatSettingPlugin_5", (String)"epm-emr-formplugin", (Object[])new Object[0]);
            if (sortDiminfo.getSortType() == SortTypeEnum.DATA) {
                List list;
                int index = Integer.parseInt(sortDiminfo.getOrderBy());
                if (index < (list = (List)SpreadAreaUtil.getCol((String)areaRange)).size()) {
                    return (String)list.get(index) + temp;
                }
            } else {
                for (int i = 0; i < headerInfos.size(); ++i) {
                    List list;
                    IHeaderInfo hi = headerInfos.get(i);
                    if (!hi.getNumber().equals(sortDiminfo.getOrderBy()) || (sortDiminfo.getSortType() != SortTypeEnum.DIMENSION || !"Dimension".equals(hi.getType())) && (sortDiminfo.getSortType() != SortTypeEnum.PROPERTY || !"Property".equals(hi.getType())) || i >= (list = (List)SpreadAreaUtil.getCol((String)floatArea)).size()) continue;
                    return (String)list.get(i) + temp;
                }
            }
        } else {
            temp = ResManager.loadKDString((String)"\u884c", (String)"AbstractFloatSettingPlugin_6", (String)"epm-emr-formplugin", (Object[])new Object[0]);
            if (sortDiminfo.getSortType() == SortTypeEnum.DATA) {
                List list;
                int index = Integer.parseInt(sortDiminfo.getOrderBy());
                if (index < (list = (List)SpreadAreaUtil.getRow((String)areaRange)).size()) {
                    return (String)list.get(index) + temp;
                }
            } else {
                for (int i = 0; i < headerInfos.size(); ++i) {
                    List list;
                    IHeaderInfo hi = headerInfos.get(i);
                    if (!hi.getNumber().equals(sortDiminfo.getOrderBy()) || (sortDiminfo.getSortType() != SortTypeEnum.DIMENSION || !"Dimension".equals(hi.getType())) && (sortDiminfo.getSortType() != SortTypeEnum.PROPERTY || !"Property".equals(hi.getType())) || i >= (list = (List)SpreadAreaUtil.getRow((String)floatArea)).size()) continue;
                    return (String)list.get(i) + temp;
                }
            }
        }
        return "";
    }

    protected void openDimF7(String key, int currentIndexRow) {
        if (StringUtils.isEmpty((String)key) || currentIndexRow < 0) {
            return;
        }
        BatchMembEntity batchMembEntity = this.getBatMembEntityModel();
        int dimIndex = Integer.parseInt(key.substring(3, key.length()));
        if (batchMembEntity == null || batchMembEntity.getDimensions() == null || dimIndex < 0 || dimIndex >= batchMembEntity.getDimensions().size() || currentIndexRow >= batchMembEntity.getMemberRows().size()) {
            return;
        }
        IDimension dimsion = (IDimension)batchMembEntity.getDimensions().get(dimIndex);
        RowColDimMember[] rowMembs = (RowColDimMember[])batchMembEntity.getMemberRows().get(currentIndexRow);
        MemberF7Parameter f7Param = this.getMemberF7Parameter(this.getModelId(), dimsion.getId());
        DimTypeEnum dimTypeEnum = EpbsModelCacheHelper.get((long)this.getModelId()).getDimTypeEnumByDimNumber(dimsion.getNumber());
        if (DimTypeEnum.Currency == dimTypeEnum) {
            f7Param.addCustomCommFilter(new QFilter("number", "!=", (Object)"DC"));
        }
        RowColDimMember member = rowMembs[dimIndex];
        f7Param.setFloat(true);
        if (member != null) {
            f7Param.setFloat(member.isFloat());
            if (f7Param.isFloat()) {
                f7Param.setFloatAddNew(member.isQuickAddNew());
                if (member.isQuickAddNew() && member.getDefaultParent() != null) {
                    f7Param.setFloatParentId(member.getDefaultParent().getId());
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)member.getMembers())) {
                LinkedHashMap selected = Maps.newLinkedHashMapWithExpectedSize((int)member.getMembers().size());
                for (IDimensionMember _member : member.getMembers()) {
                    selected.put(_member.getId(), _member.getScope());
                }
                f7Param.setSelectIds((Map)selected);
            }
            if (StringUtils.isNotEmpty((String)member.getViewNumber())) {
                f7Param.setViewId(Long.valueOf(EpbsModelCacheHelper.get((long)this.getModelId()).getView(dimsion.getNumber(), member.getViewNumber()).getId()));
            }
        }
        f7Param.setBizModelId(this.getBizModelId());
        SpreadMemberHelper.addViewQFilterForF7Param(f7Param, new ArrayList<QFilter>(16), new ArrayList<Long>(16), true);
        this.getPageCache().put("currentEntityField", key);
        f7Param.setMultiSelect(true);
        f7Param.setEnableView(true);
        f7Param.setShowCustomProperty(true);
        f7Param.setClearSelectWhenChangeView(true);
        f7Param.setReturnAllData(true);
        f7Param.setVerifyPermission(true);
        f7Param.setCutTree(false);
        f7Param.setReturnClassName(ListSelectedRow.class.getName());
        NewF7Utils.openF8Float((IFormView)this.getView(), (AbstractMemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "memberselect"));
    }

    protected BatchMembEntity sync(IDataAreaSetting areaSetting, BatchMembEntity batchMembEntity) {
        if (areaSetting == null || batchMembEntity == null || batchMembEntity.getDimensions().isEmpty()) {
            return null;
        }
        HashMap<String, Integer> dimIndex = new HashMap<String, Integer>(16);
        for (int i = 0; i < batchMembEntity.getDimensions().size(); ++i) {
            dimIndex.put(((IDimension)batchMembEntity.getDimensions().get(i)).getNumber(), i);
        }
        List<IFloatInfo> floatInfos = this.getFloatInfos(areaSetting, this.isRow());
        for (int i = 0; i < floatInfos.size(); ++i) {
            IFloatInfo floatInfo = floatInfos.get(i);
            List rowColDimensionEntries = floatInfo.getPartition().getRowColDimensionEntries();
            RowColDimMember[] rowColDimMemberRow = new RowColDimMember[batchMembEntity.getDimensions().size()];
            for (int j = 0; j < rowColDimensionEntries.size(); ++j) {
                IRowColDimensionEntry rowColDimensionEntry = (IRowColDimensionEntry)rowColDimensionEntries.get(j);
                IDimension dimension = rowColDimensionEntry.getDimension();
                if (!dimIndex.containsKey(dimension.getNumber())) continue;
                Long viewId = rowColDimensionEntry.getViewId();
                String viewNumber = rowColDimensionEntry.getViewNumber();
                if (IDUtils.isNull((Long)viewId) && StringUtils.isNotEmpty((String)rowColDimensionEntry.getViewNumber())) {
                    viewId = EpbsModelCacheHelper.get((long)this.getModelId()).getView(dimension.getNumber(), rowColDimensionEntry.getViewNumber()).getId();
                }
                RowColDimMember member = new RowColDimMember();
                member.setFloat(rowColDimensionEntry.isFloat());
                member.setQuickAddNew(rowColDimensionEntry.isQuickAddNew());
                member.setMembers(this.accomplishMemberInfo(dimension.getNumber(), rowColDimensionEntry.getMembers()));
                if (member.isQuickAddNew() && rowColDimensionEntry.getDefaultParentNum() != null) {
                    MemberBean parentMem;
                    EpbsMemberCache memberCache = EpbsMemberCacheHelper.get((long)this.getModelId(), (String)dimension.getNumber());
                    MemberBean ppm = memberCache.getMember((parentMem = memberCache.getMember(viewId.longValue(), rowColDimensionEntry.getDefaultParentNum())).getParentId());
                    String parentNum = ppm == null ? parentMem.getNumber() : ppm.getNumber();
                    EmrDefaultDimMember emrDefaultDimMember = new EmrDefaultDimMember(Long.valueOf(parentMem.getId()), parentMem.getNameString(), parentMem.getNumber(), 10, viewId, rowColDimensionEntry.getViewNumber(), parentNum);
                    member.setDefaultParent((IDimensionMember)emrDefaultDimMember);
                }
                member.setViewId(viewId);
                member.setViewNumber(viewNumber);
                rowColDimMemberRow[((Integer)dimIndex.get((Object)dimension.getNumber())).intValue()] = member;
            }
            batchMembEntity.getMemberRows().add(rowColDimMemberRow);
            List sortDimInfos = floatInfo.getSortDimInfos();
            if (CollectionUtils.isEmpty((Collection)sortDimInfos)) {
                batchMembEntity.getSortInfoList().add(Collections.emptyList());
                continue;
            }
            batchMembEntity.getSortInfoList().add(floatInfo.getSortDimInfos());
        }
        this.cacheBatMembEntityModel(batchMembEntity);
        return batchMembEntity;
    }

    protected List<IDimensionMember> accomplishMemberInfo(String dimension, List<IDimensionMember> dimensionMembers) {
        if (dimensionMembers == null || dimensionMembers.isEmpty()) {
            return dimensionMembers;
        }
        boolean needAccomplish = dimensionMembers.stream().filter(e -> e.getId() == null || e.getName() == null).findAny().isPresent();
        if (!needAccomplish) {
            return dimensionMembers;
        }
        EpbsMemberCache memberCache = EpbsMemberCacheHelper.get((long)this.getModelId(), (String)dimension);
        EpbsPropCache propCache = EpbsPropCacheHelper.get((long)this.getModelId(), (String)dimension);
        dimensionMembers.forEach(e -> {
            if (e.getId() == null || e.getName() == null) {
                PropValueBean pb;
                if (e.getType() == null || RangeF7PropertyCataEnum.Member.getIndex().equals(e.getType())) {
                    MemberBean mb = memberCache.getMember(e.getViewNumber(), e.getNumber());
                    if (mb != null) {
                        e.setId(Long.valueOf(mb.getId()));
                        e.setName(mb.getNameString());
                    }
                } else if (RangeF7PropertyCataEnum.Property.getIndex().equals(e.getType()) && (pb = DimPropertyHelper.getPropValueBean(propCache, e.getLongNumber())) != null) {
                    e.setId(Long.valueOf(pb.getId()));
                    e.setName(pb.getNameString());
                }
            }
        });
        return dimensionMembers;
    }

    protected IDataAreaSetting sync(BatchMembEntity batchMembEntity, IDataAreaSetting areaSetting) {
        if (areaSetting == null || batchMembEntity == null || batchMembEntity.getDimensions().isEmpty()) {
            return areaSetting;
        }
        List rowHeaders = areaSetting.getRowHeaders();
        List colHeaders = areaSetting.getColHeaders();
        boolean isRow = this.isRow();
        int floatOffset = (Integer)this.getModel().getValue(FLOATOFFSET);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        List memberRows = batchMembEntity.getMemberRows();
        ArrayList<DataAreaSetting.FloatInfo> floatInfos = new ArrayList<DataAreaSetting.FloatInfo>(16);
        List dimensions = batchMembEntity.getDimensions();
        for (int i = 0; i < memberRows.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
            List sortInfos = (List)batchMembEntity.getSortInfoList().get(i);
            String[] floatRangeSplit = dynamicObject.getString(FLOATRANGE).split(":");
            if (floatRangeSplit.length != 2) continue;
            DataAreaSetting.FloatInfo floatInfo = new DataAreaSetting.FloatInfo();
            String floatPosStart = TemplateProcessHelper.getXYRelatedToAreaRange(areaSetting.getAreaRange(), floatRangeSplit[0]);
            String floatPosEnd = TemplateProcessHelper.getXYRelatedToAreaRange(areaSetting.getAreaRange(), floatRangeSplit[1]);
            if (floatPosStart != null && floatPosEnd != null) {
                int float_start_x = Integer.parseInt(floatPosStart.split(":")[0]);
                int float_end_x = Integer.parseInt(floatPosEnd.split(":")[0]);
                int float_start_y = Integer.parseInt(floatPosStart.split(":")[1]);
                int float_end_y = Integer.parseInt(floatPosEnd.split(":")[1]);
                if (isRow) {
                    floatInfo.setRow_offset(float_start_y);
                    floatInfo.setRowEnd_offset(float_end_y);
                } else {
                    floatInfo.setCol_offset(float_start_x);
                    floatInfo.setColEnd_offset(float_end_x);
                }
                floatInfo.setFloat_offset(floatOffset);
                RowColPartition partition = new RowColPartition();
                RowColDimMember[] rowMembs = (RowColDimMember[])memberRows.get(i);
                RowColDimMember memb = null;
                floatInfo.setSortDimInfos(sortInfos);
                for (int j = 0; j < rowMembs.length; ++j) {
                    IDimension dimension = (IDimension)dimensions.get(j);
                    DefaultRowColDimensionEntry dimensionEntry = new DefaultRowColDimensionEntry();
                    dimensionEntry.setDimension(dimension);
                    partition.addOneRowColDimensionEntry((IRowColDimensionEntry)dimensionEntry);
                    memb = rowMembs[j];
                    if (memb != null) {
                        boolean isFloatMember = memb.isFloat();
                        if (isFloatMember) {
                            dimensionEntry.setFloat(true);
                            dimensionEntry.setQuickAddNew(memb.isQuickAddNew());
                        }
                        int startOffset = isRow ? floatInfo.getRow_offset() : floatInfo.getCol_offset();
                        int endOffset = isRow ? floatInfo.getRowEnd_offset() : floatInfo.getColEnd_offset();
                        for (int index = startOffset; index <= endOffset; ++index) {
                            for (IHeaderInfo headerInfo : isRow ? rowHeaders : colHeaders) {
                                List headerObjects = headerInfo.getHeaderObjects();
                                headerObjects.set(index, new HeaderObject(true, null, null));
                            }
                        }
                        if (dimensionEntry.isQuickAddNew() && memb.getDefaultParent() != null) {
                            dimensionEntry.setDefaultParentNum(memb.getDefaultParent().getNumber());
                        }
                    } else {
                        throw new KDBizException(ResManager.loadKDString((String)"\u56fa\u5b9a\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractFloatSettingPlugin_7", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                    }
                    dimensionEntry.setViewNumber(memb.getViewNumber());
                    dimensionEntry.setMembers(memb.getMembers());
                    dimensionEntry.getMembers().forEach(arg_0 -> AbstractFloatSettingPlugin.lambda$sync$6((IRowColDimensionEntry)dimensionEntry, arg_0));
                }
                floatInfo.setPartition((IRowColPartition)partition);
                floatInfo.setMemberDisplay(dynamicObject.getString(MEMBERDISPLAY));
                floatInfo.setExpandType(dynamicObject.getString(EXPANDTYPE));
            }
            floatInfos.add(floatInfo);
        }
        ArrayList<IFloatInfo> oldInfos = new ArrayList<IFloatInfo>();
        if (isRow) {
            for (IFloatInfo floatInfo : areaSetting.getFloatInfos()) {
                if (floatInfo.getRow_offset() <= -1) continue;
                oldInfos.add(floatInfo);
                TemplateProcessHelper.setHeaderObjects(rowHeaders, () -> new HeaderObject(), floatInfo.getRow_offset(), floatInfo.getRowEnd_offset());
            }
        } else {
            for (IFloatInfo floatInfo : areaSetting.getFloatInfos()) {
                if (floatInfo.getCol_offset() <= -1) continue;
                oldInfos.add(floatInfo);
                TemplateProcessHelper.setHeaderObjects(colHeaders, () -> new HeaderObject(), floatInfo.getCol_offset(), floatInfo.getColEnd_offset());
            }
        }
        areaSetting.getFloatInfos().removeAll(oldInfos);
        if (!floatInfos.isEmpty()) {
            areaSetting.getFloatInfos().addAll(floatInfos);
        }
        areaSetting.refresh();
        return areaSetting;
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        this.getPageCache().put(CURRENT_INDEX_ROW, String.valueOf(row));
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        BatchMembEntity membsModel = this.getBatMembEntityModel();
        membsModel.delRows(e.getRowIndexs());
        this.cacheBatMembEntityModel(membsModel);
        this.putParentViewCache("pageId", this.getView().getPageId());
        this.putParentViewCache("floatRangeIndex", null);
    }

    public void afterMoveEntryUp(AfterMoveEntryEventArgs e) {
        BatchMembEntity membsModel = this.getBatMembEntityModel();
        membsModel.moveRow(e.getRowIndexs(), true);
        this.cacheBatMembEntityModel(membsModel);
    }

    public void afterMoveEntryDown(AfterMoveEntryEventArgs e) {
        BatchMembEntity membsModel = this.getBatMembEntityModel();
        membsModel.moveRow(e.getRowIndexs(), false);
        this.cacheBatMembEntityModel(membsModel);
    }

    protected boolean validate() {
        List rowColDimMembers;
        BatchMembEntity batchMembEntity;
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<String> floatRanges = new ArrayList<String>(16);
        IDataAreaSetting areaRange = this.getMultiAreaSetting();
        int floatOffset = (Integer)this.getModel().getValue(FLOATOFFSET);
        String validFloatRange = TemplateProcessHelper.getValidFloatRange(areaRange, floatOffset, this.isRow());
        if (dynamicObjects != null && dynamicObjects.size() > 0) {
            int i;
            for (i = 0; i < dynamicObjects.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(i);
                String floatRange = dynamicObject.getString(FLOATRANGE);
                String expandType = dynamicObject.getString(EXPANDTYPE);
                Integer floatSize = dynamicObject.getInt(FLOATSIZE);
                if (!TemplateProcessHelper.validateArea(floatRange) || !SpreadAreaUtil.isInArea((String)floatRange, (String)validFloatRange)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165%s\u5185\u7684\u6709\u6548\u533a\u57df", (String)"AbstractFloatSettingPlugin_8", (String)"epm-emr-formplugin", (Object[])new Object[]{validFloatRange}));
                    return false;
                }
                if ("1".equals(expandType) && floatSize != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d6e\u52a8\u5c55\u5f00\u65b9\u5f0f\u4e3a\u81ea\u52a8\u5c55\u5f00\u6240\u6709\u7ec4\u5408\u65f6\u6d6e\u52a8\u884c\u6216\u5217\u6570\u53ea\u80fd\u4e3a1\uff0c\u8bf7\u4fee\u6539\u7b2c%s\u884c\u6d6e\u52a8\u5c55\u5f00\u65b9\u5f0f\u6216\u6d6e\u52a8\u533a\u57df\u3002", (String)"AbstractFloatSettingPlugin_9", (String)"epm-emr-formplugin", (Object[])new Object[]{i + 1}));
                    return false;
                }
                floatRanges.add(floatRange);
            }
            if (floatRanges.size() > 1) {
                for (i = 0; i < floatRanges.size(); ++i) {
                    for (int j = i + 1; j < floatRanges.size(); ++j) {
                        if (!ExcelUtils.isOverlap((String)((String)floatRanges.get(i)), (String)((String)floatRanges.get(j)))) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d6e\u52a8\u533a\u57df%1$s\u4e0e%2$s\u5b58\u5728\u91cd\u53e0\u7684\u533a\u57df\u3002", (String)"AbstractFloatSettingPlugin_10", (String)"epm-emr-formplugin", (Object[])new Object[]{floatRanges.get(i), floatRanges.get(j)}));
                        return false;
                    }
                }
            }
        }
        if ((batchMembEntity = this.getBatMembEntityModel()) != null && (rowColDimMembers = batchMembEntity.getMemberRows()) != null && rowColDimMembers.size() > 0) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
            for (int i = 0; i < rowColDimMembers.size(); ++i) {
                RowColDimMember[] emrRowColDimMember = (RowColDimMember[])rowColDimMembers.get(i);
                boolean hasFloat = false;
                boolean fixMemberIsProperty = false;
                for (RowColDimMember m : emrRowColDimMember) {
                    List members;
                    if (m != null && (m.getMembers() == null || m.getMembers().size() == 0)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7ef4\u5ea6\u6210\u5458\u8bbe\u7f6e\u4e0d\u5b8c\u6574\u3002", (String)"AbstractFloatSettingPlugin_11", (String)"epm-emr-formplugin", (Object[])new Object[]{i + 1}));
                        return false;
                    }
                    if (m != null && !m.isFloat() && (fixMemberIsProperty = this.hasPropertyMember(members = m.getMembers()))) break;
                    if (m != null && m.isFloat()) {
                        hasFloat = true;
                        continue;
                    }
                    if (m != null) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c%s\u884c\u7ef4\u5ea6\u6210\u5458\u8bbe\u7f6e\u4e0d\u5b8c\u6574\u3002", (String)"AbstractFloatSettingPlugin_11", (String)"epm-emr-formplugin", (Object[])new Object[]{i + 1}));
                    return false;
                }
                if (fixMemberIsProperty) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c%s\u884c\u975e\u6d6e\u52a8\u6210\u5458\u4e0d\u5141\u8bb8\u9009\u62e9\u81ea\u5b9a\u4e49\u5c5e\u6027\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractFloatSettingPlugin_12", (String)"epm-emr-formplugin", (Object[])new Object[]{i + 1}));
                    return false;
                }
                if (hasFloat) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7b2c%s\u884c:\u8bf7\u81f3\u5c11\u8bbe\u7f6e\u4e00\u4e2a\u6d6e\u52a8\u6210\u5458\u3002", (String)"AbstractFloatSettingPlugin_13", (String)"epm-emr-formplugin", (Object[])new Object[]{i + 1}));
                return false;
            }
        }
        return true;
    }

    protected boolean hasPropertyMember(List<IDimensionMember> members) {
        if (members != null) {
            IDimensionMember iDimensionMember = members.stream().filter(x -> RangeF7PropertyCataEnum.Property.getIndex().equals(x.getType())).findAny().orElse(null);
            return iDimensionMember != null;
        }
        return false;
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (NEWENTRY.equals(evt.getOperateKey())) {
            int cnt = this.getModel().getEntryRowCount(ENTRYENTITY);
            this.putParentViewCache("pageId", this.getView().getPageId());
            this.putParentViewCache("floatRangeIndex", String.valueOf(cnt - 1));
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String rangeStr;
        String[] split;
        Object value;
        RowDataEntity rowDataEntity;
        BatchMembEntity membsModel = this.getBatMembEntityModel();
        membsModel.addRow();
        this.cacheBatMembEntityModel(membsModel);
        String itemKey = this.getPageCache().get(ITEM_KEY);
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if (rowDataEntities.length > 0 && StringUtils.isNotEmpty((String)itemKey) && (rowDataEntity = rowDataEntities[0]).getRowIndex() > 0 && (value = this.getModel().getValue(FLOATRANGE, rowDataEntity.getRowIndex() - 1)) != null && (split = (rangeStr = (String)value).split(":")).length > 1) {
            String startChar = split[0].replaceAll("[^a-zA-Z]", "");
            String endChar = split[1].replaceAll("[^a-zA-Z]", "");
            String endNumber = split[1].replaceAll("[^0-9]", "");
            if (StringUtils.isNotEmpty((String)startChar) && StringUtils.isNotEmpty((String)endChar) && StringUtils.isNotEmpty((String)endNumber)) {
                int endIndex = Integer.parseInt(endNumber);
                StringBuilder sb = new StringBuilder(startChar);
                sb.append(endIndex + 1).append(":").append(endChar).append(endIndex + 1);
                this.getModel().setValue(FLOATRANGE, (Object)sb.toString(), rowDataEntity.getRowIndex());
            }
        }
        this.getPageCache().remove(ITEM_KEY);
    }

    protected boolean isRow() {
        return "true".equals(this.getFormCustomParam("isRow"));
    }

    protected void putParentViewCache(String key, String value) {
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            FormViewPluginProxy pluginProxy = (FormViewPluginProxy)parentView.getService(FormViewPluginProxy.class);
            pluginProxy.getPlugIns().stream().anyMatch(f -> {
                if (AbstractTemplateBasePlugin.class.isAssignableFrom(f.getClass())) {
                    ((AbstractTemplateBasePlugin)f).getPageCache().put(key, value);
                    ((AbstractTemplateBasePlugin)f).pushCache();
                    return true;
                }
                return false;
            });
            this.getView().sendFormAction(parentView);
        }
    }

    public IDataAreaSetting getMultiAreaSetting() {
        if (this.multiAreaSetting == null) {
            String str = (String)this.getFormCustomParam(AREASETTING);
            if (StringUtils.isNotEmpty((String)str)) {
                this.multiAreaSetting = (IDataAreaSetting)this.deSerializedBytes(str);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u4f20\u5165\u6570\u636e\u533a\u57df\u8bbe\u7f6e\u3002", (String)"AbstractFloatSettingPlugin_14", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            }
        }
        return this.multiAreaSetting;
    }

    protected BatchMembEntity getBatMembEntityModel() {
        if (this.entityModel == null) {
            String cacheStr = this.getPageCache().get("entitymodel");
            if (cacheStr == null) {
                throw new KDBizException("get batch members entity model failed");
            }
            this.entityModel = (BatchMembEntity)this.deSerializedBytes(cacheStr);
        }
        return this.entityModel;
    }

    protected void cacheBatMembEntityModel(BatchMembEntity entityModel) {
        this.getPageCache().put("entitymodel", this.toByteSerialized(entityModel));
    }

    protected void cacheFieldKeys(Map<String, String> fieldKeys) {
        this.getPageCache().put("fieldKeys", SerializationUtils.toJsonString(fieldKeys));
    }

    protected Map<String, String> getFieldKeys() {
        if (this.fieldKeys != null) {
            return this.fieldKeys;
        }
        String str_fieldKeys = this.getPageCache().get("fieldKeys");
        if (StringUtils.isNotEmpty((String)str_fieldKeys)) {
            return (Map)SerializationUtils.fromJsonString((String)str_fieldKeys, Map.class);
        }
        return null;
    }

    public long getModelId() {
        return IDUtils.toLong((Object)this.getFormCustomParam("KEY_MODEL_ID"));
    }

    public long getBizModelId() {
        return IDUtils.toLong((Object)this.getFormCustomParam("bizModelId"));
    }

    public AbstractFormPlugin getPlugin() {
        return this;
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        this.getPageCache().put(ITEM_KEY, itemKey);
    }

    public abstract MemberF7Parameter getMemberF7Parameter(long var1, Long var3);

    public abstract TemplateMemberServiceImpl getTemplateMemberService();

    private static /* synthetic */ void lambda$sync$6(IRowColDimensionEntry dimensionEntry, IDimensionMember e) {
        e.setViewNumber(dimensionEntry.getViewNumber());
    }
}

