/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template;

import kd.bos.form.IPageCache;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.IMultiSheetTemplateModel;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.ITemplateModel;
import kd.epm.emr.business.template.MultiSheetTemplateModel;
import kd.epm.emr.business.template.SpreadDataModelUtil;
import kd.epm.emr.business.template.TemplateInfo;
import kd.epm.emr.business.template.TemplateModel;
import kd.epm.emr.business.template.TemplateModelJSONUtil;
import kd.epm.emr.business.template.spread.IMultiSheetTemplateModelSupport;
import kd.epm.emr.common.spread.command.event.SpreadActionListener;
import kd.epm.emr.formplugin.spread.ISheetModelSupplier;
import kd.epm.emr.formplugin.spread.SpreadBasePlugin;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.ReflectUtils;
import kd.epm.epbs.formplugin.IPageCacheProxy;
import kd.epm.epbs.formplugin.ISupportPageCacheProxy;

public class AbstractTemplateBasePlugin<T extends TemplateInfo>
extends SpreadBasePlugin
implements SpreadActionListener,
IMultiSheetTemplateModelSupport<T>,
ISheetModelSupplier,
ISupportPageCacheProxy {
    protected T templateBaseInfo = null;
    protected IMultiSheetTemplateModel<T> multiSheetTemplateModel = null;
    protected ITemplateModel<T> templateModel = null;
    protected ISheetManager sm;
    private IPageCache pageCacheProxy = null;
    private IPageCacheProxy.PageCacheProxy proxy;

    public Class<T> getTemplateClass() {
        return this.getClazz(0);
    }

    protected T getTemplateBaseInfoByCache() {
        String str = this.getPlugin().getPageCache().get("MULTISHEET_TEMPLATE_INFO");
        if (StringUtils.isEmpty((String)str)) {
            str = (String)this.getPlugin().getView().getFormShowParameter().getCustomParam("MULTISHEET_TEMPLATE_INFO");
        }
        TemplateInfo templateBaseInfo = StringUtils.isNotEmpty((String)str) ? (TemplateInfo)ObjectSerialUtil.deSerializedBytes((String)str) : (TemplateInfo)ReflectUtils.newInstance(this.getTemplateClass());
        return (T)templateBaseInfo;
    }

    protected IMultiSheetTemplateModel<T> getMultiSheetTemplateModelByCache(boolean needBaseInfo) {
        String template = this.getPlugin().getPageCache().get("MULTISHEET_TEMPLATE_MODEL");
        if (StringUtils.isEmpty((String)template)) {
            template = (String)this.getPlugin().getView().getFormShowParameter().getCustomParam("MULTISHEET_TEMPLATE_MODEL");
        }
        Object multiSheetTemplateModel = StringUtils.isEmpty((String)template) ? MultiSheetTemplateModel.getInstance() : TemplateModelJSONUtil.parseIMultiSheetTemplateModel((String)template);
        if (needBaseInfo) {
            multiSheetTemplateModel.setTemplateBaseInfo(this.getTemplateBaseInfo());
        }
        return multiSheetTemplateModel;
    }

    public T getTemplateBaseInfo() {
        if (this.templateBaseInfo == null) {
            this.templateBaseInfo = this.getTemplateBaseInfoByCache();
        }
        return this.templateBaseInfo;
    }

    public void cacheTemplateBaseInfo(T templateBaseInfo) {
        this.getPageCache().put("MULTISHEET_TEMPLATE_INFO", this.toByteSerialized(templateBaseInfo));
    }

    public IMultiSheetTemplateModel<T> getMultiSheetTemplateModel() {
        return this.getMultiSheetTemplateModel(false);
    }

    public IMultiSheetTemplateModel<T> getMultiSheetTemplateModel(boolean needBaseInfo) {
        if (this.multiSheetTemplateModel != null) {
            if (needBaseInfo && this.multiSheetTemplateModel.getTemplateBaseInfo() == null) {
                this.multiSheetTemplateModel.setTemplateBaseInfo(this.getTemplateBaseInfo());
            }
        } else {
            this.multiSheetTemplateModel = this.getMultiSheetTemplateModelByCache(needBaseInfo);
        }
        return this.multiSheetTemplateModel;
    }

    public void cacheMultiSheetTemplateModel() {
        this.cacheMultiSheetTemplateModel(false);
    }

    public void cacheMultiSheetTemplateModel(boolean isCacheBaseInfo) {
        if (this.multiSheetTemplateModel != null) {
            this.getPageCache().put("MULTISHEET_TEMPLATE_MODEL", TemplateModelJSONUtil.toJsonMulti(this.multiSheetTemplateModel));
            if (isCacheBaseInfo) {
                this.cacheTemplateBaseInfo(this.multiSheetTemplateModel.getTemplateBaseInfo());
            }
        }
    }

    public ITemplateModel<T> getTemplateModel() {
        if (this.templateModel != null) {
            return this.templateModel;
        }
        this.templateModel = this.getMultiSheetTemplateModel().getTemplateModels().computeIfAbsent(this.getActiveSheet().getSheetName(), f -> TemplateModel.getInstance());
        this.templateModel.setTemplateBaseInfo(this.getTemplateBaseInfo());
        return this.templateModel;
    }

    public void cacheTemplateModel() {
        if (this.templateModel != null) {
            this.getMultiSheetTemplateModel().getTemplateModels().put(this.getActiveSheet().getSheetName(), this.templateModel);
            this.cacheMultiSheetTemplateModel(true);
        }
    }

    @Override
    public ISheetManager getSheetManager() {
        if (this.sm != null) {
            return this.sm;
        }
        String s = this.getPageCache().get("key_new_spread_model");
        this.sm = StringUtils.isNotEmpty((String)s) ? SpreadDataModelUtil.getSheetManager((String)s) : (StringUtils.isNotEmpty((String)(s = (String)this.getFormCustomParam("key_new_spread_model"))) ? SpreadDataModelUtil.getSheetManager((String)s) : this.getTemplateModel().getSheetManager());
        return this.sm;
    }

    public void cacheSheetManager() {
        this.cacheSheetManager(this.getSheetManager());
    }

    @Override
    public void cacheSheetManager(ISheetManager sheetManager) {
        if (sheetManager != null) {
            this.sm = sheetManager;
            this.getPageCache().put("key_new_spread_model", SpreadDataModelUtil.toJson((ISheetManager)sheetManager));
        } else {
            this.sm = null;
            this.getPageCache().remove("key_new_spread_model");
        }
    }

    public IPageCache getPageCache() {
        if (this.isOpenPageCacheProxy()) {
            if (this.pageCacheProxy == null) {
                IPageCacheProxy.PageCacheProxy proxy2 = new IPageCacheProxy.PageCacheProxy(super.getPageCache());
                this.pageCacheProxy = proxy2.getProxy();
                this.proxy = proxy2;
                this.getView().addService(IPageCache.class, (Object)this.pageCacheProxy);
            }
            return this.pageCacheProxy;
        }
        return super.getPageCache();
    }

    public void pushCache() {
        this.forcePushCache();
    }

    protected void forcePushCache() {
        if (this.proxy != null) {
            this.beforeDestroy();
            this.proxy.pushCache();
        }
    }

    protected void beforeDestroy() {
    }

    public boolean isOpenPageCacheProxy() {
        return true;
    }

    public void destory() {
        if (this.isOpenPageCacheProxy() && this.proxy != null) {
            this.forcePushCache();
            this.getView().addService(IPageCache.class, (Object)this.proxy.getOriginalPageCache());
        }
        super.destory();
    }
}

