/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.emr.business.template.service.ITemplateCatalogService;
import kd.epm.emr.business.template.service.impl.TemplateCatalogServiceImpl;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.NumberRuleUtils;

public abstract class AbstractTemplateCatalogEditPlugin
extends AbstractBasePlugIn {
    protected static final String BTNOK = "btnok";

    protected ITemplateCatalogService getTemplateCatalogService() {
        return TemplateCatalogServiceImpl.getInstance();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long parentId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("parent"));
        this.getModel().setValue("parent", (Object)parentId);
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        this.getModel().setValue("model", (Object)modelId);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        if (evt.getSource() instanceof Save) {
            if (!this.validateInput()) {
                evt.setCancel(true);
                return;
            }
            if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
                int seq = this.getTemplateCatalogService().getCurrentSequence(this.getModel().getDataEntityType().getName(), this.getModelId(), this.getParendId());
                this.getModel().setValue("sequence", (Object)seq);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        boolean isSuccess = e.getOperationResult().getValidateResult().isSuccess();
        List ids = e.getOperationResult().getSuccessPkIds();
        if (e.getSource() instanceof Save && isSuccess) {
            this.getView().returnDataToParent((Object)ids);
            this.getView().close();
        }
    }

    protected boolean validateInput() {
        String number = (String)this.getModel().getValue("number");
        Long modelId = this.getModelId();
        Long pkId = (Long)((BillShowParameter)this.getView().getFormShowParameter()).getPkId();
        if (!NumberRuleUtils.checkNumber((String)number)) {
            this.getView().showTipNotification(NumberRuleUtils.getMessage());
            return false;
        }
        QFilter filter = new QFilter("number", "=", (Object)number).and("model", "=", (Object)modelId);
        if (IDUtils.isNotNull((Long)pkId)) {
            filter.and("id", "!=", (Object)pkId);
        }
        if (QueryServiceHelper.exists((String)this.getModel().getDataEntityType().getName(), (QFilter[])filter.toArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"AbstractTemplateCatalogEditPlugin_0", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected Long getModelId() {
        Long modelId = (Long)((DynamicObject)this.getModel().getValue("model")).getPkValue();
        return modelId;
    }

    protected Long getParendId() {
        Long parentId = (Long)((DynamicObject)this.getModel().getValue("parent")).getPkValue();
        return parentId;
    }
}

