/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.ITemplateModel;
import kd.epm.emr.business.template.TemplateInfo;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.dimension.DefaultDimension;
import kd.epm.emr.business.template.dimension.IDimension;
import kd.epm.emr.business.template.pagedim.DefaultPageDimensionEntry;
import kd.epm.emr.business.template.pagedim.IPageDimensionEntry;
import kd.epm.emr.business.template.quote.QuoteTypeEnum;
import kd.epm.emr.business.template.service.ITemplateMemberService;
import kd.epm.emr.business.template.viewpointdim.DefaultViewPointDimensionEntry;
import kd.epm.emr.business.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.emr.common.spread.domain.view.SpreadSheet;
import kd.epm.emr.common.template.enums.TemplateTypeEnum;
import kd.epm.emr.formplugin.template.AbstractTemplateBasePlugin;
import kd.epm.emr.formplugin.template.ITemplateDynamicPage;
import kd.epm.emr.formplugin.template.helper.SetFilterDimHelper;
import kd.epm.emr.formplugin.template.helper.TemplateDynamicPageHelper;
import kd.epm.epbs.business.model.f7.MemberF7Parameter;
import kd.epm.epbs.business.page.model.Area;
import kd.epm.epbs.business.page.model.Element;
import kd.epm.epbs.business.page.model.Page;
import kd.epm.epbs.business.page.model.TextEditElement;
import kd.epm.epbs.business.page.model.util.DragUtil;
import kd.epm.epbs.common.enums.RangeEnum;
import kd.epm.epbs.common.enums.model.BizModelTypeEnum;
import kd.epm.epbs.common.model.IBaseEntry;
import kd.epm.epbs.common.model.IDimensionMember;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.JSONUtils;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.Pair;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public abstract class AbstractTemplateDimSettingPlugin<T extends TemplateInfo>
extends AbstractTemplateBasePlugin<T>
implements BeforeF7SelectListener,
ITemplateDynamicPage {
    protected static final String ISEDIT = "edit";
    protected static final String CONFIRM = "confirm";
    protected static final String VIEWPANEL_SIGN = "viewpanel";
    protected static final String PAGEPANEL_SIGN = "pagepanel";
    protected static final String RANKPANEL_SIGN = "rankpanel";
    protected static final String ID_KEY = "id";
    protected static final String NAME_KEY = "name";
    protected static final String NUMBER_KEY = "number";
    protected static final String ENTITY_KEY = "entity";
    protected static final String SIGN_KEY = "sign";
    protected static final String PANEL_KEY = "panel";
    protected static final String VALUE_KEY = "value";
    protected static final String SHORTNUMBER_KEY = "shortnumber";
    protected static final String SCOPE_KEY = "scope";
    private List<IDimension> allDims;
    protected static final String ALLDIMS_KEY = "allDims";
    protected static final String ADD_AREAVIEW = "ADD_AREAVIEW";
    protected static final String BIZMODELS = "bizmodels";
    protected static final String BIZMODEL = "bizmodel";
    protected static final Set<String> DropPanel = Sets.newHashSet((Object[])new String[]{"viewpanel", "pagepanel", "rankpanel"});
    private TemplateDynamicPageHelper dynamicPageHelper;

    @Override
    public TemplateDynamicPageHelper getDynamicPageHelper() {
        if (this.dynamicPageHelper == null) {
            this.dynamicPageHelper = TemplateDynamicPageHelper.getInstance(this.getPageCache());
            this.dynamicPageHelper.setDropPanel(DropPanel);
        }
        return this.dynamicPageHelper;
    }

    protected SetFilterDimHelper getSetFilterDimHelper() {
        return SetFilterDimHelper.getInstance();
    }

    public abstract ITemplateMemberService getTemplateMemberService();

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_confirm", "btn_cancel"});
        this.addClickListeners(new String[]{"setfilterdim"});
        BasedataEdit dataEdit = (BasedataEdit)this.getControl(this.getBizModelSign());
        if (dataEdit != null) {
            dataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("currentsheet", (Object)this.getActiveSheet().getSheetName());
        this.initBizModel();
        this.refreshPage(false);
        this.getSetFilterDimHelper().loadFilterDimsCache(this.getTemplateModel(), this.getPageCache());
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String ctrlKey = e.getKey();
        if (this.checkControlKey(ctrlKey)) {
            this.onGetControlByTemplate(e);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        if ("drop".equals(name)) {
            String eventArgs = e.getEventArgs();
            this.dealElementDrop(eventArgs);
        }
    }

    public void click(EventObject evt) {
        String itemKey = ((Control)evt.getSource()).getKey();
        if (this.checkControlKey(itemKey)) {
            this.openDimF7Page(itemKey);
        }
        if ("setfilterdim".equals(itemKey)) {
            this.openSetFilterDimPage();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String itemKey = e.getProperty().getName();
        if (Objects.equals(this.getBizModelSign(), itemKey)) {
            this.refreshPage(true);
        }
        if (this.checkControlKey(itemKey)) {
            Map<String, String> elementMap = this.getDynamicPageHelper().getPointBySign(itemKey);
            String panel = elementMap.get(PANEL_KEY);
            String entity = elementMap.get(ENTITY_KEY);
            Object newValue = e.getChangeSet()[0].getNewValue();
            Object oldValue = e.getChangeSet()[0].getOldValue();
            Object value = this.getValue(itemKey);
            switch (panel) {
                case "viewpanel": {
                    if (newValue != null) break;
                    this.getDynamicPageHelper().putDimMemberValueAndUpdateAllPoint(itemKey, null, "");
                    break;
                }
                case "pagepanel": {
                    break;
                }
            }
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        super.beforePropertyChanged(e);
        String itemKey = e.getProperty().getName();
        if (this.checkControlKey(itemKey)) {
            Object oldValue;
            Map<String, String> elementMap = this.getDynamicPageHelper().getPointBySign(itemKey);
            String panel = elementMap.get(PANEL_KEY);
            String entity = elementMap.get(ENTITY_KEY);
            Object newValue = e.getChangeSet()[0].getNewValue();
            boolean isNoChange = newValue == (oldValue = e.getChangeSet()[0].getOldValue());
            Object value = this.getValue(itemKey);
            if (!isNoChange && value != null) {
                return;
            }
            switch (panel) {
                case "viewpanel": 
                case "pagepanel": {
                    if (newValue != null && !StringUtils.isEmpty((String)newValue.toString())) break;
                    this.getDynamicPageHelper().removeDimMemberValue(itemKey);
                    this.getDynamicPageHelper().updateAllPointMapBySign(itemKey, "");
                    break;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String opKey;
        super.afterDoOperation(eventArgs);
        switch (opKey = eventArgs.getOperateKey()) {
            case "confirm": {
                if (eventArgs.getOperationResult().isSuccess()) {
                    ThreadCache.put((Object)"unbind", (Object)true);
                    this.handlePageDataAndClose();
                    break;
                }
                List errorInfos = eventArgs.getOperationResult().getAllErrorOrValidateInfo();
                this.getView().showErrorNotification(((IOperateInfo)errorInfos.get(0)).getMessage());
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Pair result;
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if (this.checkControlKey(actionId) && null != (result = this.getTemplateMemberService().f7ClosedCallBack(actionId, evt.getReturnData()))) {
            if (null != result.p2) {
                Map<String, String> dimMap = this.getDynamicPageHelper().getPointBySign(actionId);
                ((List)result.p2).stream().filter(e -> StringUtils.isEmpty((String)((String)e.get(NUMBER_KEY)))).forEach(e -> {
                    IBaseEntry m = this.getTemplateMemberService().getMemberEntry(QuoteTypeEnum.getByValule((String)((String)e.get("type"))), (String)dimMap.get(NUMBER_KEY), IDUtils.toLong(e.get(ID_KEY)), (Object)IDUtils.toLong(e.get("view")));
                    if (null != m) {
                        e.put(NUMBER_KEY, m.getNumber());
                    }
                });
            }
            this.getDynamicPageHelper().putDimMemberValueAndUpdateAllPoint(actionId, result.p2, (String)result.p1);
            this.getModel().setValue(actionId, result.p1);
        }
        if ("callback_setfilterdim".equals(actionId)) {
            this.getSetFilterDimHelper().setFilterDimCallBack(evt, this.getPageCache());
        }
    }

    public long getModelId() {
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        if (IDUtils.isNull((Long)modelId)) {
            modelId = IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
        }
        return modelId;
    }

    public Long getBizDomainId() {
        Long id = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_BIZDOMAIN_ID"));
        if (IDUtils.isNull((Long)id)) {
            id = IDUtils.toLong((Object)this.getPageCache().get("KEY_BIZDOMAIN_ID"));
        }
        return id;
    }

    @Override
    public SpreadSheet getActiveSheet() {
        String activeSheet = (String)this.getFormCustomParam("currentsheet");
        if (StringUtils.isNotEmpty((String)activeSheet)) {
            return (SpreadSheet)JSONUtils.parse((String)activeSheet, SpreadSheet.class);
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u5f53\u524d\u9875\u7b7e\u3002", (String)"AbstractTemplateDimSettingPlugin_0", (String)"epm-emr-formplugin", (Object[])new Object[0]));
    }

    protected Set<String> getDefPageDims() {
        return this.getTemplateMemberService().getDefPageDims();
    }

    protected Set<String> getDefRankDims() {
        return this.getTemplateMemberService().getDefRankDims();
    }

    protected List<Map<String, String>> getDefDimMemberValue(Map<String, String> map) {
        String panelSign = map.get(PANEL_KEY);
        List<Map<String, String>> list = null;
        switch (panelSign) {
            case "viewpanel": {
                list = this.initDefaultValue(map, RangeEnum.ONLY.getIndStr(), this.getDefDimMemberNumber(map));
                break;
            }
            case "pagepanel": {
                if (this.getLockDims().contains(map.get(NUMBER_KEY))) {
                    return null;
                }
                list = this.initDefaultValue(map, RangeEnum.ALL_EXCLUDE.getIndStr(), map.get(NUMBER_KEY));
            }
        }
        return list;
    }

    protected String getDefDimMemberNumber(Map<String, String> map) {
        return this.getTemplateMemberService().getDefDimMember(map.get(ENTITY_KEY), map.get(SHORTNUMBER_KEY));
    }

    protected List<Map<String, String>> initDefaultValue(Map<String, String> map, String scope, String number) {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        String dimNumber = map.get(NUMBER_KEY);
        ViewBean viewBean = this.getTemplateMemberService().getDefView(dimNumber, this.getBizModelId());
        IBaseEntry member = this.getTemplateMemberService().getMemberEntry(QuoteTypeEnum.MEMBER, dimNumber, number, null != viewBean ? Long.valueOf(viewBean.getId()) : null);
        Long id = null != number ? member.getId() : null;
        String name = null != number ? member.getName() : null;
        String parentNum = AbstractTemplateDimSettingPlugin.getParentNum(number, member);
        Map<String, String> m = this.getDynamicPageHelper().getDimMemberMessageMap(id, number, name, Integer.parseInt(scope), null, IDUtils.toLong((Object)map.get("view")), parentNum);
        return Lists.newArrayList((Object[])new Map[]{m});
    }

    private static String getParentNum(String number, IBaseEntry member) {
        String parentNum = null;
        if (member instanceof IDimensionMember) {
            parentNum = ((IDimensionMember)member).getParentNum();
        }
        if (parentNum == null) {
            parentNum = number;
        }
        return parentNum;
    }

    protected String getBizModelSign() {
        return BIZMODEL;
    }

    protected void initBizModel() {
        this.getModel().setValue(this.getBizModelSign(), (Object)this.getBizModelId());
        this.getView().setEnable(Boolean.valueOf(!this.hasMultiModelAreaSetting()), new String[]{this.getBizModelSign()});
    }

    protected Long getBizModelId() {
        Long bizModelId = null;
        Object obj = this.getModel().getValue(this.getBizModelSign());
        if (obj instanceof DynamicObject) {
            bizModelId = ((DynamicObject)obj).getLong(ID_KEY);
        } else {
            Map bizModelMap;
            bizModelId = this.getTemplateModel().getBizModelId();
            if (IDUtils.isNull((Long)bizModelId) && MapUtils.isNotEmpty((Map)(bizModelMap = this.getTemplateMemberService().getBizModelMap()))) {
                Long bizDomainId = this.getBizDomainId();
                for (Map.Entry entry : bizModelMap.entrySet()) {
                    if (((BizModelBean)entry.getValue()).getBizModelType() != BizModelTypeEnum.MUITL || !((BizModelBean)entry.getValue()).isEnable()) continue;
                    if (IDUtils.isNotNull((Long)bizDomainId) && bizDomainId.equals(((BizModelBean)entry.getValue()).getBizModelDomainId())) {
                        return (Long)entry.getKey();
                    }
                    if (!IDUtils.isNull((Long)bizDomainId)) continue;
                    return (Long)entry.getKey();
                }
            }
        }
        return bizModelId;
    }

    protected void openDimF7Page(String itemKey) {
        Map<String, String> map = this.getDynamicPageHelper().getPointBySign(itemKey);
        String dimNumber = map.get(NUMBER_KEY);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, itemKey);
        MemberF7Parameter f7params = this.getDimF7Param(itemKey, dimNumber);
        if (itemKey.contains(VIEWPANEL_SIGN)) {
            this.getTemplateMemberService().openSingleF7(this.getDimByNumber(dimNumber), f7params, closeCallBack, this.getView());
        } else {
            this.getTemplateMemberService().openMultiF7(this.getDimByNumber(dimNumber), f7params, closeCallBack, this.getView());
        }
    }

    protected MemberF7Parameter getDimF7Param(String itemKey, String dimNumber) {
        List<Map<String, String>> selectValues = this.getDynamicPageHelper().getDimMemberValue(itemKey);
        LinkedHashMap selectRange = new LinkedHashMap(16);
        selectValues.stream().forEach(m -> selectRange.put(IDUtils.toLong(m.get(ID_KEY)), StringUtils.isNotEmpty((String)((String)m.get(SCOPE_KEY))) ? Integer.parseInt((String)m.get(SCOPE_KEY)) : RangeEnum.ONLY.getIndex()));
        Long viewId = CollectionUtils.isNotEmpty(selectValues) ? IDUtils.toLong((Object)selectValues.get(0).get("view")) : null;
        MemberF7Parameter p = this.getTemplateMemberService().getMemberF7Parameter(dimNumber, this.getBizModelId().longValue());
        p.setViewId(viewId);
        p.setSelectIds(selectRange);
        return p;
    }

    protected List<IDimension> getAllDims() {
        return this.getTemplateMemberService().getAllDims(this.getBizModelId());
    }

    protected List<IDimension> getAllDimsCache() {
        if (CollectionUtils.isEmpty(this.allDims)) {
            String seria = this.getPageCache().get(ALLDIMS_KEY);
            if (StringUtils.isNotEmpty((String)seria)) {
                this.allDims = (List)ObjectSerialUtil.deSerializedBytes((String)seria);
            } else {
                this.allDims = this.getAllDims();
                this.getPageCache().put(ALLDIMS_KEY, ObjectSerialUtil.toByteSerialized(this.allDims));
            }
        }
        return this.allDims;
    }

    protected void clearTemplateDimSetting() {
        ITemplateModel template = this.getTemplateModel();
        template.getViewpointmembentry().clear();
        template.getPagemembentry().clear();
        template.getRowcolDims().clear();
        this.getDynamicPageHelper().cleanAllPoint();
    }

    protected void refreshPage(boolean clear) {
        if (clear) {
            this.getPageCache().remove(ALLDIMS_KEY);
            this.clearTemplateDimSetting();
        }
        this.initDefaultInfo();
        this.initPage(this.getTemplateModel());
    }

    protected void initDefaultInfo() {
        ITemplateModel template = this.getTemplateModel();
        if (template.getViewpointmembentry().size() > 0 || template.getPagemembentry().size() > 0 || template.getRowcolDims().size() > 0) {
            return;
        }
        List<Map<String, String>> dims = this.getDefDims();
        dims.stream().filter(e -> VIEWPANEL_SIGN.equals(e.get(PANEL_KEY))).forEach(e -> {
            DefaultViewPointDimensionEntry viewPointDimensionEntry = new DefaultViewPointDimensionEntry();
            viewPointDimensionEntry.setDimension(this.getDynamicPageHelper().buildDimension((Map<String, String>)e));
            List<Map<String, String>> members = this.getDefDimMemberValue((Map<String, String>)e);
            if (CollectionUtils.isNotEmpty(members)) {
                viewPointDimensionEntry.setMember(this.buildDimensionMember(members.get(0)));
            }
            this.getDynamicPageHelper().putDimMemberValue((String)e.get(SIGN_KEY), members);
            template.getViewpointmembentry().add(viewPointDimensionEntry);
        });
        dims.stream().filter(e -> PAGEPANEL_SIGN.equals(e.get(PANEL_KEY))).forEach(e -> {
            DefaultPageDimensionEntry dimensionEntry = new DefaultPageDimensionEntry();
            dimensionEntry.setDimension(this.getDynamicPageHelper().buildDimension((Map<String, String>)e));
            List<Map<String, String>> members = this.getDefDimMemberValue((Map<String, String>)e);
            if (CollectionUtils.isNotEmpty(members)) {
                members.forEach(arg_0 -> this.lambda$null$6((IPageDimensionEntry)dimensionEntry, arg_0));
            }
            this.getDynamicPageHelper().putDimMemberValue((String)e.get(SIGN_KEY), members);
            template.getPagemembentry().add(dimensionEntry);
        });
        dims.stream().filter(e -> RANKPANEL_SIGN.equals(e.get(PANEL_KEY))).forEach(e -> template.getRowcolDims().add(e.get(NUMBER_KEY)));
        this.cacheTemplateModel();
    }

    protected boolean hasAreaSetting() {
        return this.getSheetManager().getAreaRanges().size() > 0;
    }

    protected boolean hasMultiModelAreaSetting() {
        for (IDataAreaSetting areaSetting : this.getSheetManager().getAreaRanges()) {
            if (areaSetting.isRelation()) continue;
            return true;
        }
        return false;
    }

    protected List<Map<String, String>> getDefDims() {
        List<IDimension> allDims = this.getAllDimsCache();
        Set<String> defaultPageDims = this.getDefPageDims();
        Set<String> defaultRankDims = this.getDefRankDims();
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(allDims.size());
        for (IDimension d : allDims) {
            if (defaultPageDims.contains(d.getNumber())) {
                list.add(this.getDynamicPageHelper().getDimMessageMap(PAGEPANEL_SIGN, d));
                continue;
            }
            if (defaultRankDims.contains(d.getNumber())) {
                list.add(this.getDynamicPageHelper().getDimMessageMap(RANKPANEL_SIGN, d));
                continue;
            }
            if (!this.isShowDim(VIEWPANEL_SIGN, d.getNumber())) continue;
            list.add(this.getDynamicPageHelper().getDimMessageMap(VIEWPANEL_SIGN, d));
        }
        return list;
    }

    public List<Map<String, String>> getPointEntry() {
        List<Map<String, String>> ap = this.getDynamicPageHelper().getAllPoint();
        if (CollectionUtils.isEmpty(ap)) {
            return this.getDefDims();
        }
        return ap;
    }

    protected void initPage(ITemplateModel template) {
        Page page = new Page();
        page.setChangeable(true);
        this.addArea(template, page, PAGEPANEL_SIGN, list -> this.buildPageDim(PAGEPANEL_SIGN, (ITemplateModel<T>)template, (List<Map<String, String>>)list));
        this.addArea(template, page, RANKPANEL_SIGN, list -> this.buildRankDim(RANKPANEL_SIGN, (ITemplateModel<T>)template, (List<Map<String, String>>)list));
        this.addArea(template, page, VIEWPANEL_SIGN, list -> this.buildViewDim(VIEWPANEL_SIGN, (ITemplateModel<T>)template, (List<Map<String, String>>)list));
        this.commomAction(page);
    }

    protected void addArea(ITemplateModel template, Page page, String panelSign, Consumer<List> consumer) {
        List<Map<String, String>> list = new ArrayList<Map<String, String>>(16);
        if (template == null) {
            List<Map<String, String>> allp = this.getDynamicPageHelper().getAllPoint();
            list = allp.stream().filter(e -> panelSign.equals(e.get(PANEL_KEY))).collect(Collectors.toList());
        } else {
            consumer.accept(list);
            this.getDynamicPageHelper().cacheAllPoint(list);
        }
        this.addArea(page, list, panelSign);
    }

    @Override
    public Element addAreaElement(Area area, Map<String, String> map, String panelSign) {
        String name = map.get(NAME_KEY);
        String elementSign = map.get(SIGN_KEY);
        String entityNumber = map.get(ENTITY_KEY);
        Element element = null;
        switch (panelSign) {
            case "viewpanel": {
                element = this.getDynamicElememt(name, elementSign, entityNumber, TextEditElement.class);
                break;
            }
            case "pagepanel": {
                element = this.getDynamicElememt(name, elementSign, entityNumber, TextEditElement.class);
                if (!this.getLockDims().contains(map.get(NUMBER_KEY))) break;
                element.setLock("new,edit");
                break;
            }
            case "rankpanel": {
                element = this.getDynamicElememt(name, elementSign, entityNumber, TextEditElement.class);
                ((TextEditElement)element).setEditStyle(0);
                element.setLock("new,edit");
                element.setCustomStyle(ap -> {
                    this.defaultStyle((ControlAp)ap);
                    ((FieldAp)ap).setShowTitle(false);
                    ap.setWidth(new LocaleString((name != null ? name.length() * 10 + 60 : 50) + "px"));
                    ap.getStyle().getPadding().setRight("7px");
                    ap.getStyle().getPadding().setLeft("7px");
                    ap.getStyle().getPadding().setTop("7px");
                    ap.getStyle().getMargin().setLeft("1px");
                    ap.getStyle().getMargin().setBottom("0px");
                });
                break;
            }
        }
        if (element != null) {
            area.addElement(element);
        }
        return element;
    }

    @Override
    public Object initElementValue(Map<String, String> map) {
        String panelSign = map.get(PANEL_KEY);
        String value = map.get(VALUE_KEY);
        if (RANKPANEL_SIGN.equals(panelSign)) {
            value = map.get(NAME_KEY);
        }
        return value;
    }

    protected Pair<String, List<Map<String, String>>> buildDimMessageValue(Map<String, String> map, Object dimEntry) {
        String value = map.get(NAME_KEY);
        String panelSign = map.get(PANEL_KEY);
        ArrayList members = null;
        switch (panelSign) {
            case "viewpanel": {
                IViewPointDimensionEntry viewEntry = (IViewPointDimensionEntry)dimEntry;
                IDimension dimension = this.getDimByNumber(viewEntry.getDimension().getNumber());
                Map<String, String> member = this.dimMemberToMap(dimension, viewEntry.getMember());
                value = member.get(NAME_KEY);
                if (!MapUtils.isNotEmpty(member)) break;
                members = Lists.newArrayList((Object[])new Map[]{member});
                break;
            }
            case "pagepanel": {
                IPageDimensionEntry pageEntry = (IPageDimensionEntry)dimEntry;
                IDimension dimension = this.getDimByNumber(pageEntry.getDimension().getNumber());
                members = pageEntry.getMembers().stream().map(e -> this.dimMemberToMap(dimension, (IDimensionMember)e)).collect(Collectors.toList());
                value = this.getMultiF7Results(members);
            }
        }
        return Pair.onePair((Object)value, members);
    }

    protected void buildViewDim(String panelSign, ITemplateModel<T> template, List<Map<String, String>> list) {
        if (CollectionUtils.isEmpty((Collection)template.getViewpointmembentry())) {
            return;
        }
        HashSet<String> numbers = new HashSet<String>(16);
        for (IViewPointDimensionEntry entry : template.getViewpointmembentry()) {
            String dimNumber = entry.getDimension().getNumber();
            IDimension dimension = this.getDimByNumber(dimNumber);
            if (dimension == null || !this.isShowDim(panelSign, dimNumber)) continue;
            Map<String, String> map = this.getDynamicPageHelper().getDimMessageMap(panelSign, dimension);
            Pair<String, List<Map<String, String>>> pair = this.buildDimMessageValue(map, entry);
            map.put(VALUE_KEY, (String)pair.p1);
            list.add(map);
            numbers.add(dimNumber);
            this.getDynamicPageHelper().putDimMemberValue(map.get(SIGN_KEY), pair.p2);
        }
        List<Map<String, String>> hasDims = this.getDynamicPageHelper().getAllPoint();
        if (hasDims != null) {
            hasDims.forEach(e -> numbers.add((String)e.get(NUMBER_KEY)));
        }
        this.getAllDimsCache().forEach(e -> {
            if (!numbers.contains(e.getNumber()) && this.isShowDim(panelSign, e.getNumber())) {
                list.add(this.getDynamicPageHelper().getDimMessageMap(panelSign, (IDimension)e));
            }
        });
    }

    protected void buildPageDim(String panelSign, ITemplateModel<T> template, List<Map<String, String>> list) {
        if (CollectionUtils.isEmpty((Collection)template.getPagemembentry())) {
            return;
        }
        for (IPageDimensionEntry entry : template.getPagemembentry()) {
            String dimNumber = entry.getDimension().getNumber();
            IDimension dimension = this.getDimByNumber(dimNumber);
            if (dimension == null || !this.isShowDim(panelSign, dimNumber)) continue;
            Map<String, String> map = this.getDynamicPageHelper().getDimMessageMap(panelSign, dimension);
            Pair<String, List<Map<String, String>>> pair = this.buildDimMessageValue(map, entry);
            map.put(VALUE_KEY, (String)pair.p1);
            list.add(map);
            this.getDynamicPageHelper().putDimMemberValue(map.get(SIGN_KEY), pair.p2);
        }
    }

    protected void buildRankDim(String panelSign, ITemplateModel<T> template, List<Map<String, String>> list) {
        if (CollectionUtils.isEmpty((Collection)template.getRowcolDims())) {
            return;
        }
        for (String dimNumber : template.getRowcolDims()) {
            IDimension dimension = this.getDimByNumber(dimNumber);
            if (dimension == null || !this.isShowDim(panelSign, dimNumber)) continue;
            Map<String, String> map = this.getDynamicPageHelper().getDimMessageMap(panelSign, dimension);
            map.put(VALUE_KEY, (String)this.buildDimMessageValue(map, (Object)dimNumber).p1);
            list.add(map);
        }
    }

    protected IDimension getDimByNumber(String dimNumber) {
        IDimension dimension = this.getTemplateMemberService().getDimension(dimNumber);
        return dimension;
    }

    protected boolean checkControlKey(String controlKey) {
        if (StringUtils.isEmpty((String)controlKey) || controlKey.endsWith("_id")) {
            return false;
        }
        return controlKey.contains("!");
    }

    protected boolean isShowDim(String panelSign, String dimNumber) {
        return true;
    }

    protected void dealElementDrop(String eventArgs) {
        String[] msg = DragUtil.translateMessage((String)eventArgs);
        String target = msg[0];
        String source = msg[1];
        if (!this.checkControlKey(source) || this.getControl(source) == null) {
            return;
        }
        if (this.beforeElementDrop(target, source)) {
            List<Map<String, String>> mapList = this.getDynamicPageHelper().getAllPoint();
            this.elementDrop(source, target, mapList);
            this.getDynamicPageHelper().updateAllPoint(mapList);
            this.initPage(null);
            this.getModel().setDataChanged(true);
            this.afterElementDrop(target, source);
        }
    }

    protected boolean beforeElementDrop(String target, String source) {
        String targetPanel = this.getDynamicPageHelper().getPanelForEventArgs(target);
        String sourcePanel = this.getDynamicPageHelper().getPanelForEventArgs(source);
        if (!(!this.hasMultiModelAreaSetting() || VIEWPANEL_SIGN.equals(sourcePanel) && RANKPANEL_SIGN.equals(targetPanel) || !RANKPANEL_SIGN.equals(sourcePanel) && !RANKPANEL_SIGN.equals(targetPanel))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u8bbe\u7f6e\u6570\u636e\u533a\u57df\uff0c\u4e0d\u5141\u8bb8\u6539\u53d8\u884c\u5217\u7ef4\u8bbe\u7f6e\u3002", (String)"AbstractTemplateDimSettingPlugin_1", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void afterElementDrop(String target, String source) {
        List<Map<String, String>> all = this.getPointEntry();
        if (CollectionUtils.isNotEmpty(all)) {
            Set<String> rangeDims = all.stream().filter(map -> RANKPANEL_SIGN.equalsIgnoreCase((String)map.get(PANEL_KEY))).map(v -> (String)v.get(NUMBER_KEY)).collect(Collectors.toSet());
            this.getSetFilterDimHelper().removeSetFilterDimsCache(rangeDims, this.getPageCache());
        }
    }

    protected String elementDrop(String source, String target, List<Map<String, String>> mapList) {
        Map<String, String> oldDimMap = this.getDynamicPageHelper().getPointBySign(source);
        String oldDisplayValue = oldDimMap.get(VALUE_KEY);
        List<Map<String, String>> oldMemberValue = this.getDynamicPageHelper().getDimMemberValue(source);
        String elementSign = this.getDynamicPageHelper().elementDrop(source, target, mapList, this);
        String targetPanel = this.getDynamicPageHelper().getPanelForEventArgs(target);
        String sourcePanel = this.getDynamicPageHelper().getPanelForEventArgs(source);
        if (VIEWPANEL_SIGN.equals(sourcePanel) && PAGEPANEL_SIGN.equals(targetPanel) && CollectionUtils.isNotEmpty(oldMemberValue)) {
            this.getDynamicPageHelper().putDimMemberValue(elementSign, oldMemberValue);
            mapList.stream().filter(e -> elementSign.equals(e.get(SIGN_KEY))).forEach(e -> e.put(VALUE_KEY, oldDisplayValue));
        }
        if (this.hasAreaSetting() && VIEWPANEL_SIGN.equals(sourcePanel) && RANKPANEL_SIGN.equals(targetPanel)) {
            List<Map<String, List<Map<String, String>>>> addAreaView = this.getAddAreaView();
            HashMap<String, List<Map<String, String>>> map = new HashMap<String, List<Map<String, String>>>(1);
            map.put(oldDimMap.get(NUMBER_KEY), oldMemberValue);
            addAreaView.add(map);
            this.getPageCache().put(ADD_AREAVIEW, SerializationUtils.toJsonString(addAreaView));
        }
        return elementSign;
    }

    protected void handlePageDataAndClose() {
        if (this.fillBackValidate()) {
            this.fillBackToTemplateModel();
            HashMap<String, Object> returnData = new HashMap<String, Object>(16);
            String templateModelStr = this.toByteSerialized(this.getTemplateModel());
            returnData.put("TEMPLATEMODEL", templateModelStr);
            this.fillBackToCustomParam(returnData);
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(returnData));
            this.getView().close();
        }
    }

    protected Set<String> getLockDims() {
        return Sets.newHashSet();
    }

    protected boolean fillBackValidate() {
        List<Map<String, String>> members;
        List<Map<String, String>> all = this.getPointEntry();
        List view = all.stream().filter(e -> VIEWPANEL_SIGN.equals(e.get(PANEL_KEY))).collect(Collectors.toList());
        List page = all.stream().filter(e -> PAGEPANEL_SIGN.equals(e.get(PANEL_KEY))).collect(Collectors.toList());
        List rank = all.stream().filter(e -> RANKPANEL_SIGN.equals(e.get(PANEL_KEY))).collect(Collectors.toList());
        for (Map entry : view) {
            members = this.getDynamicPageHelper().getDimMemberValue((String)entry.get(SIGN_KEY));
            if (!CollectionUtils.isEmpty(members)) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9690\u85cf\u7ef4\u6210\u5458\u3002", (String)"AbstractTemplateDimSettingPlugin_2", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return false;
        }
        for (Map entry : page) {
            members = this.getDynamicPageHelper().getDimMemberValue((String)entry.get(SIGN_KEY));
            if (!CollectionUtils.isEmpty(members) || this.getLockDims().contains(entry.get(NUMBER_KEY))) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9875\u9762\u7ef4\u6210\u5458\u3002", (String)"AbstractTemplateDimSettingPlugin_3", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (rank.size() < 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u81f3\u5c11\u9700\u4fdd\u75592\u4e2a\u7ef4\u5ea6\u3002", (String)"AbstractTemplateDimSettingPlugin_4", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void fillBackToTemplateModel() {
        List<Map<String, String>> all = this.getPointEntry();
        List<Map> view = all.stream().filter(e -> VIEWPANEL_SIGN.equals(e.get(PANEL_KEY))).collect(Collectors.toList());
        List<Map> page = all.stream().filter(e -> PAGEPANEL_SIGN.equals(e.get(PANEL_KEY))).collect(Collectors.toList());
        List rank = all.stream().filter(e -> RANKPANEL_SIGN.equals(e.get(PANEL_KEY))).collect(Collectors.toList());
        ITemplateModel templateModel = this.getTemplateModel();
        templateModel.setBizModelId(this.getBizModelId());
        templateModel.setBizModel(this.getTemplateMemberService().getBizModelNumber(templateModel.getBizModelId()));
        templateModel.getViewpointmembentry().clear();
        templateModel.getPagemembentry().clear();
        view.forEach(entry -> {
            DefaultViewPointDimensionEntry dimensionEntry = new DefaultViewPointDimensionEntry();
            dimensionEntry.setDimension(this.getDynamicPageHelper().buildDimension((Map<String, String>)entry));
            List<Map<String, String>> members = this.getDynamicPageHelper().getDimMemberValue((String)entry.get(SIGN_KEY));
            members.forEach(arg_0 -> this.lambda$null$28((IViewPointDimensionEntry)dimensionEntry, arg_0));
            templateModel.addViewpointmembentry((IViewPointDimensionEntry)dimensionEntry);
        });
        page.forEach(entry -> {
            DefaultPageDimensionEntry dimensionEntry = new DefaultPageDimensionEntry();
            dimensionEntry.setDimension(this.getDynamicPageHelper().buildDimension((Map<String, String>)entry));
            List<Map<String, String>> members = this.getDynamicPageHelper().getDimMemberValue((String)entry.get(SIGN_KEY));
            members.forEach(arg_0 -> this.lambda$null$30((IPageDimensionEntry)dimensionEntry, arg_0));
            if (CollectionUtils.isNotEmpty(members)) {
                dimensionEntry.setViewNumber(((IDimensionMember)dimensionEntry.getMembers().get(0)).getViewNumber());
                dimensionEntry.setViewId(((IDimensionMember)dimensionEntry.getMembers().get(0)).getViewId());
            }
            templateModel.addPagemembentry((IPageDimensionEntry)dimensionEntry);
        });
        templateModel.setRowcolDims(rank.stream().map(e -> (String)e.get(NUMBER_KEY)).collect(Collectors.toList()));
        templateModel.setTemplateType(TemplateTypeEnum.valueOf((int)Integer.parseInt(this.getModel().getValue("templatetype") + "")));
        this.sm = this.getSheetManager();
        List<Map<String, List<Map<String, String>>>> addAreaView = this.getAddAreaView();
        if (CollectionUtils.isNotEmpty(addAreaView)) {
            ArrayList<DefaultViewPointDimensionEntry> viewEntry = new ArrayList<DefaultViewPointDimensionEntry>(16);
            for (Map<String, List<Map<String, String>>> areaView : addAreaView) {
                Optional optional = areaView.entrySet().stream().findFirst();
                if (!optional.isPresent()) continue;
                Map.Entry e2 = (Map.Entry)optional.get();
                DefaultViewPointDimensionEntry viewPointDimensionEntry = new DefaultViewPointDimensionEntry();
                viewPointDimensionEntry.setDimension((IDimension)new DefaultDimension(null, null, (String)e2.getKey(), null));
                if (CollectionUtils.isNotEmpty((Collection)((Collection)e2.getValue()))) {
                    viewPointDimensionEntry.setMember(this.buildDimensionMember((Map)((List)e2.getValue()).get(0)));
                }
                viewEntry.add(viewPointDimensionEntry);
            }
            this.sm.getAreaRanges().forEach(e -> {
                if (!e.isRelation()) {
                    e.getAreaViewpointmembentry().addAll(viewEntry);
                }
            });
        }
        templateModel.setSheetManager(this.sm);
        List<Map> viewAndPage = all.stream().filter(e -> VIEWPANEL_SIGN.equals(e.get(PANEL_KEY)) || PAGEPANEL_SIGN.equals(e.get(PANEL_KEY))).collect(Collectors.toList());
        HashMap dimViews = Maps.newHashMap();
        viewAndPage.forEach(entry -> {
            Long viewId = this.getMemberF7ViewId((String)entry.get(SIGN_KEY));
            if (viewId != null) {
                dimViews.put(entry.get(NUMBER_KEY), viewId);
            }
        });
        templateModel.setDimViews((Map)dimViews);
        this.getSetFilterDimHelper().fillBack2TemplateModelFilterDims(templateModel, this.getPageCache());
    }

    protected void fillBackToCustomParam(Map<String, Object> returnData) {
    }

    protected void openSetFilterDimPage() {
        List<Map<String, String>> all = this.getPointEntry();
        if (CollectionUtils.isEmpty(all)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u7ef4\u5ea6\u3002", (String)"AbstractTemplateDimSettingPlugin_5", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Map<String, String>> rangeDims = all.stream().filter(map -> RANKPANEL_SIGN.equalsIgnoreCase((String)map.get(PANEL_KEY))).collect(Collectors.toList());
        if (rangeDims.size() == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u884c\u7ef4\u5217\u7ef4\u7ef4\u5ea6\u4e3a\u7a7a\u3002", (String)"AbstractTemplateDimSettingPlugin_6", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParam = this.getSetFilterDimHelper().getSetFilterDimFormShowParameter(rangeDims, this.getPageCache(), (AbstractFormPlugin)this);
        this.getView().showForm(showParam);
    }

    protected List<Map<String, List<Map<String, String>>>> getAddAreaView() {
        List list = null;
        String seria = this.getPageCache().get(ADD_AREAVIEW);
        list = StringUtils.isNotEmpty((String)seria) ? (List)SerializationUtils.fromJsonString((String)seria, List.class) : Lists.newArrayList();
        return list;
    }

    protected Map<String, String> dimMemberToMap(IDimension dimension, IDimensionMember dimensionMember) {
        String number;
        if (dimension == null || dimensionMember == null) {
            return Maps.newHashMap();
        }
        QuoteTypeEnum type = QuoteTypeEnum.getByValule((String)dimensionMember.getType());
        String dimNumber = dimension.getNumber();
        String dimMemberNumber = dimensionMember.getNumber();
        IBaseEntry member = this.getTemplateMemberService().getMemberEntry(type, dimNumber, dimensionMember.getId(), (Object)dimensionMember.getViewId());
        String id = member == null ? null : String.valueOf(member.getId());
        String name = member == null ? null : member.getName();
        String string = number = member == null ? null : member.getNumber();
        if (StringUtils.isEmpty((String)dimMemberNumber) && StringUtils.isNotEmpty((String)number)) {
            dimMemberNumber = number;
        }
        String parentNum = AbstractTemplateDimSettingPlugin.getParentNum(number, member);
        return this.getDynamicPageHelper().getDimMemberMessageMap(IDUtils.toLong((Object)id), dimMemberNumber, name, dimensionMember.getScope(), dimensionMember.getType(), dimensionMember.getViewId(), parentNum);
    }

    protected String getMultiF7Results(List<Map<String, String>> members) {
        return this.getTemplateMemberService().getMultiF7Results(members);
    }

    protected IDimensionMember buildDimensionMember(Map<String, String> map) {
        IDimensionMember member = this.getDynamicPageHelper().buildDimensionMember(map);
        if (IDUtils.isNotNull((Long)member.getViewId())) {
            ViewBean view = this.getTemplateMemberService().getView(member.getViewId());
            member.setViewNumber(null != view ? view.getNumber() : null);
        }
        return member;
    }

    protected Long getMemberF7ViewId(String f7Key) {
        Long viewId = IDUtils.toLong((Object)this.getPageCache().get(f7Key + "viewId"));
        return viewId;
    }

    private /* synthetic */ void lambda$null$30(IPageDimensionEntry dimensionEntry, Map e) {
        dimensionEntry.addOneMember(this.buildDimensionMember(e));
    }

    private /* synthetic */ void lambda$null$28(IViewPointDimensionEntry dimensionEntry, Map e) {
        dimensionEntry.setMember(this.buildDimensionMember(e));
    }

    private /* synthetic */ void lambda$null$6(IPageDimensionEntry dimensionEntry, Map m) {
        dimensionEntry.addOneMember(this.buildDimensionMember(m));
    }
}

