/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.TemplateInfo;
import kd.epm.emr.formplugin.template.AbstractTemplateBasePlugin;
import kd.epm.emr.formplugin.template.ITemplateParamService;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.NumberRuleUtils;
import org.apache.commons.collections4.MapUtils;

public abstract class AbstractTemplateEditPlugin<T extends TemplateInfo>
extends AbstractTemplateBasePlugin<T>
implements ITemplateParamService,
BeforeF7SelectListener {
    protected static final Log log = LogFactory.getLog(AbstractTemplateEditPlugin.class);
    protected static final String BTNOK = "btnok";
    protected static final String FLEXBASEINFO = "flexbaseinfo";
    protected static final String FLEXDESCRIPTION = "flexdescription";
    protected static final String RICH_TEXTEDITOR_AP = "richtexteditorap";
    protected static final String BTNCANCEL = "btncancel";
    protected Map<String, Object> customParams;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("templatecatalog");
        if (null != basedataEdit) {
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initPage();
        if (!this.isAddNewStatus()) {
            this.fillBackPage();
        }
        this.showParamsPage(this.setCustomParams());
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Button)evt.getSource()).getKey()) {
            case "btnok": {
                this.save();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String itemKey = ((BasedataEdit)evt.getSource()).getKey();
        if ("templatecatalog".equals(itemKey)) {
            evt.getCustomQFilters().add(new QFilter("model", "=", (Object)this.getModelId()));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String key;
        super.confirmCallBack(e);
        switch (key = e.getCallBackId()) {
            case "btncancel": {
                if (MessageBoxResult.Yes == e.getResult()) {
                    this.save();
                    break;
                }
                this.getModel().setDataChanged(false);
                this.getView().close();
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.isDataChange()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u754c\u9762\u6570\u636e\u5df2\u53d8\u66f4\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"AbstractTemplateEditPlugin_0", (String)"epm-emr-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(BTNCANCEL, (IFormPlugin)this));
            e.setCancel(true);
        }
    }

    protected void initPage() {
        this.getModel().setValue(this.getModelSign(), (Object)IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID")));
        this.getModel().setValue("templatecatalog", (Object)IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_TEMPLATE_CATALOG_ID")));
        String type = (String)this.getFormCustomParam("weave");
        if (type == null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXDESCRIPTION});
            if (IDUtils.isNotEmptyLong((Long)this.getTemplateBaseInfo().getGroup()).booleanValue()) {
                QFilter filter = new QFilter("id", "!=", (Object)this.getTemplateBaseInfo().getId());
                filter.and("group", "=", (Object)this.getTemplateBaseInfo().getGroup());
                boolean existHistoryVersion = QueryServiceHelper.exists((String)this.getTemplateBaseInfo().getDataEntityNumber(), (QFilter[])filter.toArray());
                this.getView().setEnable(Boolean.valueOf(!existHistoryVersion), new String[]{"number"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{FLEXBASEINFO});
        }
    }

    protected void fillBackPage() {
        Object templateBaseInfo = this.getTemplateBaseInfo();
        this.getModel().setValue("number", (Object)templateBaseInfo.getNumber());
        this.getModel().setValue("name", templateBaseInfo.getName());
        this.getModel().setValue("templatecatalog", (Object)templateBaseInfo.getTemplatecatalogId());
        this.getModel().setValue("templatetype", (Object)templateBaseInfo.getTemplatetype());
        this.getModel().setValue("status", (Object)templateBaseInfo.getStatus());
        this.getModel().setValue("versionnumber", (Object)templateBaseInfo.getVersionNumber());
        RichTextEditor rap = (RichTextEditor)this.getControl(RICH_TEXTEDITOR_AP);
        rap.setText(templateBaseInfo.getDescription());
    }

    protected T getTemplateBaseInfoFromPage() {
        Object templateBaseInfo = this.getTemplateBaseInfo();
        templateBaseInfo.getId();
        templateBaseInfo.setModelId(this.getModelId());
        templateBaseInfo.setNumber((String)this.getModel().getValue("number"));
        templateBaseInfo.setName(this.getModel().getValue("name"));
        DynamicObject catalog = (DynamicObject)this.getModel().getValue("templatecatalog");
        if (null != catalog) {
            templateBaseInfo.setTemplatecatalog((Object)IDUtils.toLong((Object)catalog.getPkValue()));
        }
        templateBaseInfo.setTemplatetype((String)this.getModel().getValue("templatetype"));
        templateBaseInfo.setStatus((String)this.getModel().getValue("status"));
        RichTextEditor rap = (RichTextEditor)this.getControl(RICH_TEXTEDITOR_AP);
        templateBaseInfo.setDescription(rap.getText());
        if (MapUtils.isNotEmpty(this.customParams)) {
            templateBaseInfo.setParamsByCustom(this.customParams);
        }
        if (IDUtils.isNull((long)templateBaseInfo.getGroup())) {
            templateBaseInfo.setGroup(DBServiceHelper.genGlobalLongId());
        }
        templateBaseInfo.setVersionNumber((BigDecimal)this.getModel().getValue("versionnumber"));
        return templateBaseInfo;
    }

    protected boolean checkPerm() {
        return true;
    }

    protected boolean validateInput() {
        this.customParams = this.getCustomParams(BTNOK);
        OrmLocaleValue name = (OrmLocaleValue)this.getModel().getValue("name");
        if (name == null || StringUtils.isEmpty((String)name.toString())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractTemplateEditPlugin_2", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return false;
        }
        String number = (String)this.getModel().getValue("number");
        if (!NumberRuleUtils.checkNumber((String)number)) {
            this.getView().showTipNotification(NumberRuleUtils.getMessage());
            return false;
        }
        QFilter filter = new QFilter("number", "=", (Object)number).and("model", "=", (Object)this.getModelId());
        if (QueryServiceHelper.exists((String)this.getTemplateBaseInfo().getDataEntityNumber(), (Object)this.getTemplateBaseInfo().getId())) {
            filter.and("id", "!=", (Object)this.getTemplateBaseInfo().getId());
            filter.and("group", "!=", (Object)this.getTemplateBaseInfo().getGroup());
        }
        if (QueryServiceHelper.exists((String)this.getTemplateBaseInfo().getDataEntityNumber(), (QFilter[])filter.toArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"AbstractTemplateEditPlugin_1", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void save() {
        if (this.checkPerm() && this.validateInput()) {
            T templateBaseInfo = this.getTemplateBaseInfoFromPage();
            this.getView().returnDataToParent((Object)this.toByteSerialized(templateBaseInfo));
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    protected boolean isDataChange() {
        return this.getModel().getDataChanged();
    }
}

