/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.TemplateInfo;
import kd.epm.emr.business.template.service.ITemplateCatalogService;
import kd.epm.emr.business.template.service.ITemplateService;
import kd.epm.emr.business.template.service.impl.TemplateCatalogServiceImpl;
import kd.epm.emr.business.template.service.impl.TemplateServiceImpl;
import kd.epm.emr.formplugin.template.ITemplateConstant;
import kd.epm.emr.formplugin.template.ITemplateForm;
import kd.epm.emr.formplugin.template.ITemplateOpenPage;
import kd.epm.emr.formplugin.template.helper.TemplateVersionHelper;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.enums.status.ResultStatusEnum;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import kd.epm.epbs.common.tree.DynamicTreeContext;
import kd.epm.epbs.common.tree.SimpleDynamicTreeBuilder;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;
import kd.epm.epbs.formplugin.AbstractBaseListPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public abstract class AbstractTemplateListPlugin<T extends TemplateInfo>
extends AbstractBaseListPlugin
implements TreeNodeClickListener,
ITemplateOpenPage,
ITemplateForm,
ITemplateConstant {
    protected static final Log log = LogFactory.getLog(AbstractTemplateListPlugin.class);
    protected boolean isInit = false;
    protected ITemplateService templateService;
    protected ITemplateCatalogService templateCatalogService;

    public ITemplateService getTemplateService() {
        if (null == this.templateService) {
            this.templateService = TemplateServiceImpl.getInstance(null);
        }
        return this.templateService;
    }

    public ITemplateCatalogService getTemplateCatalogService() {
        if (null == this.templateCatalogService) {
            this.templateCatalogService = TemplateCatalogServiceImpl.getInstance();
        }
        return this.templateCatalogService;
    }

    public void initialize() {
        super.initialize();
        this.getBillList().setBillFormId(this.getEpbsTemplateEntity());
        this.getTreeView().addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_addnew", "btn_delete", "btn_modify", "btn_up", "btn_down"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.isInit = true;
        this.showOrHideBtn();
        this.setDefaultModel();
        this.initCatalogRoot();
        this.refreshPage(null);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemkey = evt.getItemKey();
        if (!this.checkModel(itemkey)) {
            return;
        }
        switch (itemkey) {
            case "btn_addtemplate": {
                this.openTemplatePage();
                break;
            }
            case "btn_deltemplate": {
                if (!this.isSelectedRows() || !this.hasTmplateManagerPerm(this.getSelectedIds())) {
                    return;
                }
                this.deleteShowConfirm(new ConfirmCallBackListener(itemkey, (IFormPlugin)this));
                break;
            }
            case "btn_version": {
                this.openVersionPage();
                break;
            }
            case "btn_showhistory": 
            case "btn_hidehistory": {
                this.showBtnhistory(Objects.equals("btn_showhistory", itemkey), true);
                this.refreshBillList();
                break;
            }
            case "btn_refresh": {
                this.refreshPage(null);
            }
        }
    }

    public void click(EventObject evt) {
        String itemKey = ((Control)evt.getSource()).getKey();
        if (!this.checkModel(itemKey)) {
            return;
        }
        switch (itemKey) {
            case "btn_addnew": 
            case "btn_modify": {
                this.editCatalog(itemKey);
                break;
            }
            case "btn_delete": {
                this.deleteCatalogShowConfirm();
                break;
            }
            case "btn_up": 
            case "btn_down": {
                this.upAndDownCatalog(Objects.equals(itemKey, "btn_up"));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returndata = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "btn_addtemplate": {
                if (!(returndata instanceof String)) break;
                TemplateInfo templateBaseInfo = (TemplateInfo)this.deSerializedBytes((String)returndata);
                this.openTemplateProcessPage(templateBaseInfo, OperationStatus.ADDNEW);
                break;
            }
            case "btn_version": {
                if (!(returndata instanceof Long)) break;
                TemplateInfo templateBaseInfo = this.getTemplateService().getSimpleTemplateInfo(this.getTemplateClass(), (Long)returndata);
                this.openTemplateProcessPage(templateBaseInfo, OperationStatus.EDIT);
                break;
            }
            case "openTemplateProcessPage": {
                this.refreshBillList();
                break;
            }
            case "btn_addnew": 
            case "btn_modify": {
                if (!(returndata instanceof List)) break;
                String msg = Objects.equals(actionId, "btn_addnew") ? ResManager.loadKDString((String)"\u65b0\u589e\u6a21\u677f\u5206\u7c7b\u6210\u529f\u3002", (String)"AbstractTemplateListPlugin_0", (String)"epm-emr-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fee\u6539\u6a21\u677f\u5206\u7c7b\u6210\u529f\u3002", (String)"AbstractTemplateListPlugin_1", (String)"epm-emr-formplugin", (Object[])new Object[0]);
                this.getView().showSuccessNotification(msg);
                List ids = (List)returndata;
                this.refreshTree(CollectionUtils.isNotEmpty((Collection)ids) ? IDUtils.toString(ids.get(0)) : null);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        String callBackId;
        super.confirmCallBack(mbce);
        switch (callBackId = mbce.getCallBackId()) {
            case "btn_deltemplate": {
                if (MessageBoxResult.Yes != mbce.getResult()) break;
                this.deleteConfirm();
                break;
            }
            case "btn_delete": {
                if (MessageBoxResult.Yes != mbce.getResult()) break;
                this.deleteCatalogConfirm();
                this.refreshPage(this.getCatalogParentId());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "model": {
                this.initCatalogRoot();
                this.refreshPage(null);
                break;
            }
            case "treecheckbox": {
                this.refreshBillList();
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        this.openTemplateProcessPage((BillList)args.getHyperLinkClickEvent().getSource());
        args.setCancel(true);
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        super.listRowDoubleClick(evt);
        this.openTemplateProcessPage((BillList)evt.getSource());
        evt.setCancel(true);
    }

    public void setFilter(SetFilterEvent e) {
        QFilter filter = this.getCatalogQFilter(false);
        if (null == filter) {
            e.getQFilters().add(new QFilter("id", "=", (Object)-1));
            return;
        }
        e.getQFilters().add(filter);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.getPageCache().put("templatecatalogtree", (String)evt.getNodeId());
        this.refreshBillList();
    }

    public TreeView getTreeView() {
        return (TreeView)this.getView().getControl("templatecatalogtree");
    }

    protected boolean isAllChild() {
        Boolean isallchild = (Boolean)this.getModel().getValue("treecheckbox");
        return isallchild;
    }

    protected Long getCatalogId() {
        String catalog = this.getPageCache().get("templatecatalogtree");
        return IDUtils.toLong((Object)catalog);
    }

    protected List<Long> getCatalogIdsWithChild(boolean containSelf) {
        TreeNode treeNode = AbstractTreeBuilder.getRootWithCache((TreeView)this.getTreeView()).getTreeNode(this.getCatalogId().toString());
        List allNodeIds = AbstractTreeBuilder.getAllChildNodeIds((TreeNode)treeNode, (boolean)containSelf);
        return IDUtils.toLongs((List)allNodeIds);
    }

    protected QFilter getCatalogQFilter(boolean isContainNull) {
        List<Long> allNodeIds;
        Long catalogId = this.getCatalogId();
        if (IDUtils.isNull((Long)catalogId)) {
            return null;
        }
        QFilter filter = new QFilter("templatecatalog", "=", (Object)catalogId);
        if (isContainNull) {
            filter.or("templatecatalog", "in", (Object)new Object[]{0});
        }
        if (this.isAllChild() && !(allNodeIds = this.getCatalogIdsWithChild(false)).isEmpty()) {
            filter.or("templatecatalog", "in", allNodeIds);
        }
        return this.getTemplateIdsQFilter(filter);
    }

    protected QFilter getTemplateIdsQFilter(QFilter filter) {
        List<Object> templateIds;
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)this.getEpbsTemplateEntity(), (String)String.join((CharSequence)",", "id", "number", "versionnumber", "group"), (QFilter[])filter.toArray());
        Map<Long, DynamicObject> templateMap = dynamicObjects.stream().collect(Collectors.toMap(e -> e.getLong("id"), e -> e));
        if (this.isSupportVersion() && !this.isShowhistory()) {
            Collection<DynamicObject> values = templateMap.values();
            TemplateVersionHelper.filterVersionTemplateTree(values, this.getEpbsTemplateEntity());
            templateIds = values.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        } else {
            List selectIds;
            String seria = this.getPageCache().get("showhistory_ids");
            List list = selectIds = StringUtils.isNotEmpty((String)seria) ? (List)SerializationUtils.fromJsonString((String)seria, List.class) : null;
            if (CollectionUtils.isNotEmpty((Collection)selectIds)) {
                Collection<DynamicObject> values = templateMap.values();
                TemplateVersionHelper.filterVersionTemplateTree(values, this.getEpbsTemplateEntity(), selectIds);
                templateIds = values.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
            } else {
                templateIds = Lists.newArrayList(templateMap.keySet());
            }
        }
        return new QFilter("id", "in", (Object)templateIds);
    }

    protected boolean isSupportVersion() {
        return StringUtils.isNotEmpty((String)this.getEpbsTplVersionEdit()) && StringUtils.isNotEmpty((String)this.getEpbsTplVersionList());
    }

    protected boolean isShowhistory() {
        return Objects.equals(Boolean.TRUE.toString(), this.getPageCache().get("showhistory"));
    }

    protected void showBtnhistory(boolean isShowHistory, boolean isClick) {
        if (this.isSupportVersion()) {
            this.getView().setVisible(Boolean.valueOf(!isShowHistory), new String[]{"btn_showhistory"});
            this.getView().setVisible(Boolean.valueOf(isShowHistory), new String[]{"btn_hidehistory"});
            this.getPageCache().put("showhistory", Boolean.toString(isShowHistory));
            if (isShowHistory) {
                this.getPageCache().put("showhistory_ids", SerializationUtils.toJsonString((Object)this.getSelectedIds()));
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_version", "btn_showhistory", "btn_hidehistory"});
        }
    }

    protected void showOrHideBtn() {
        this.showBtnhistory(false, false);
    }

    protected void initCatalogRoot() {
        this.getTemplateCatalogService().createCatalogRoot(this.getEpbsTemplateCatalog(), Long.valueOf(this.getModelId()));
    }

    protected void refreshPage(String nodeId) {
        this.refreshTree(nodeId);
        this.refreshBillList();
        this.dealItemLogic();
    }

    protected DynamicTreeContext createTreeContext() {
        DynamicTreeContext context = new DynamicTreeContext(this.getEpbsTemplateCatalog());
        context.setSelectFields("id,number,name,parent");
        context.setOrderby("sequence");
        context.setqFilters(new QFilter("model", "=", (Object)this.getModelId()).toArray());
        return context;
    }

    protected void refreshTree(String nodeId) {
        DynamicTreeContext context = this.createTreeContext();
        AbstractTreeBuilder treeBuilder = new SimpleDynamicTreeBuilder(context).buildTree(this.getTreeView());
        treeBuilder.getRoot().setText(ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b", (String)"AbstractTemplateListPlugin_2", (String)"epm-emr-formplugin", (Object[])new Object[0]));
        if (StringUtils.isEmpty((String)nodeId)) {
            nodeId = treeBuilder.getRoot().getId();
        }
        context.setFocusTreeId(nodeId);
        treeBuilder.nodeClick();
    }

    protected void refreshBillList() {
        BillList billList = this.getBillList();
        billList.clearSelection();
        billList.setOrderBy(this.getListEntryOrderBy());
        FilterParameter fp = new FilterParameter();
        fp.setFilter(new QFilter("model", "=", (Object)this.getModelId()));
        billList.setQueryFilterParameter(fp);
        if (!this.isInit) {
            billList.refresh();
        }
    }

    protected String getListEntryOrderBy() {
        return "sequence,number,versionnumber desc";
    }

    protected boolean isSelectedRows() {
        return this.isSelectedRows(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"AbstractTemplateListPlugin_3", (String)"epm-emr-formplugin", (Object[])new Object[0]));
    }

    protected boolean isSelectedOneRow() {
        return this.isSelectedOneRow(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u9009\u62e9\u4e00\u4e2a\u6a21\u677f\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractTemplateListPlugin_4", (String)"epm-emr-formplugin", (Object[])new Object[0]));
    }

    protected Set<String> getCheckModelOp() {
        return checkModelOp;
    }

    protected boolean checkModel(String itemkey) {
        boolean hasModel = IDUtils.isNotNull((long)this.getModelId());
        if (!hasModel && this.getCheckModelOp().contains(itemkey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"AbstractTemplateListPlugin_5", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected boolean checkCatalog(Long catalogId) {
        if (IDUtils.isNull((Long)catalogId) && !this.isRootCatalog()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6a21\u677f\u5206\u7c7b\u3002", (String)"AbstractTemplateListPlugin_6", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return false;
        }
        return this.hasCategoryManagerPerm(catalogId);
    }

    protected void openTemplatePage() {
        Long catalogId = this.getCatalogId();
        if (this.checkCatalog(catalogId)) {
            String caption = ResManager.loadKDString((String)"\u901a\u7528\u6a21\u677f", (String)"AbstractTemplateListPlugin_7", (String)"epm-emr-formplugin", (Object[])new Object[0]);
            this.openTemplateBaseInfoPage("btn_addtemplate", caption, OperationStatus.ADDNEW, this.getModelId(), formShowParameter -> formShowParameter.setCustomParam("KEY_TEMPLATE_CATALOG_ID", (Object)catalogId));
        }
    }

    protected void openTemplateProcessPage(BillList billList) {
        if (this.hasTmplateManagerPerm(Collections.singleton((Long)billList.getFocusRowPkId()))) {
            TemplateInfo templateBaseInfo = this.getTemplateService().getSimpleTemplateInfo(this.getTemplateClass(), (Long)billList.getFocusRowPkId());
            this.openTemplateProcessPage(templateBaseInfo, OperationStatus.EDIT);
        }
    }

    protected void openTemplateProcessPage(TemplateInfo templateBaseInfo, OperationStatus operationStatus) {
        String caption = String.format(ResManager.loadKDString((String)"\u7f16\u8f91\u6a21\u677f-%s", (String)"AbstractTemplateListPlugin_8", (String)"epm-emr-formplugin", (Object[])new Object[0]), templateBaseInfo.getNameString());
        this.openTemplateProcessPage("openTemplateProcessPage", caption, operationStatus, templateBaseInfo, formShowParameter -> formShowParameter.setCustomParam("KEY_TEMPLATE_CATALOG_ENTITY", (Object)this.getEpbsTemplateCatalog()));
    }

    protected void openVersionPage() {
        if (!this.isSelectedRows() || !this.isSelectedOneRow()) {
            return;
        }
        Long templateId = (Long)this.getSelectedRows().getPrimaryKeyValues()[0];
        TemplateInfo templateBaseInfo = this.getTemplateService().getSimpleTemplateInfo(this.getTemplateClass(), templateId);
        String caption = String.format(ResManager.loadKDString((String)"\u7248\u672c\u5316-%1$s %2$s ", (String)"AbstractTemplateListPlugin_9", (String)"epm-emr-formplugin", (Object[])new Object[0]), templateBaseInfo.getNumber(), templateBaseInfo.getNameString());
        ListShowParameter formShowParameter = (ListShowParameter)this.openPage("btn_version", caption, ShowType.Modal, 1);
        formShowParameter.setFormId(this.getEpbsTplVersionList());
        formShowParameter.setBillFormId(this.getEpbsTemplateEntity());
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCustomParam("version_edit_formid", (Object)this.getEpbsTplVersionEdit());
        formShowParameter.setCustomParam("group", (Object)templateBaseInfo.getGroup());
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    protected void deleteShowConfirm(ConfirmCallBackListener confirmCallBack) {
        String msg = ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u6a21\u677f\uff1f", (String)"AbstractTemplateListPlugin_10", (String)"epm-emr-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, confirmCallBack);
    }

    protected void deleteConfirm() {
        if (!this.isSelectedRows()) {
            return;
        }
        List deleteIds = this.getSelectedIds();
        DynamicObjectCollection dyns = this.getTemplateService().queryTemplateDyns(this.getEpbsTemplateEntity(), (Collection)deleteIds, (List)Lists.newArrayList((Object[])new String[]{"number", "name", "versionnumber"}));
        this.getTemplateService().deleteTemplate(this.getTemplateClass(), (Collection)deleteIds);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AbstractTemplateListPlugin_11", (String)"epm-emr-formplugin", (Object[])new Object[0]));
        this.refreshBillList();
        String prefixTips = OperationTypeEnum.DELETE.getNameString();
        String suffixTips = ResultStatusEnum.SUCCESS.getName();
        for (DynamicObject d : dyns) {
            this.writeTemplateLog(OperationTypeEnum.DELETE, d, prefixTips, suffixTips);
        }
    }

    protected Class<T> getTemplateClass() {
        return this.getClazz(0);
    }

    protected boolean isRootCatalog() {
        return IDUtils.isNull((Long)IDUtils.toLong((Object)this.getCatalogParentId()));
    }

    protected String getCatalogParentId() {
        Map node = this.getTreeView().getTreeState().getFocusNode();
        return MapUtils.isNotEmpty((Map)node) ? (String)node.get("parentid") : null;
    }

    protected void editCatalog(String itemKey) {
        boolean isAddNew = Objects.equals(itemKey, "btn_addnew");
        if (!isAddNew && this.isRootCatalog()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u4fee\u6539\u3002", (String)"AbstractTemplateListPlugin_12", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!this.hasCategoryManagerPerm(this.getCatalogId())) {
            return;
        }
        Long pkId = !isAddNew ? this.getCatalogId() : null;
        this.openTemplateCatalogPage(itemKey, null, this.getEpbsTemplateCatalog(), pkId, this.getModelId(), formShowParameter -> {
            if (isAddNew) {
                formShowParameter.setCustomParam("parent", (Object)this.getCatalogId());
            }
        });
    }

    protected boolean hasTmplateManagerPerm(Collection<Long> tplIds) {
        return true;
    }

    protected boolean hasCategoryManagerPerm(Long cateId) {
        return true;
    }

    protected void deleteCatalogShowConfirm() {
        if (this.isRootCatalog()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u5220\u9664\u3002", (String)"AbstractTemplateListPlugin_13", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return;
        }
        List<Long> allCatalogIds = this.getCatalogIdsWithChild(true);
        if (QueryServiceHelper.exists((String)this.getEpbsTemplateEntity(), (QFilter[])new QFilter("templatecatalog", "in", allCatalogIds).toArray())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u4e0b\u5b58\u5728\u6a21\u677f\u4e0d\u5141\u8bb8\u5220\u9664\u5206\u7c7b\uff0c\u8bf7\u79fb\u52a8\u6a21\u677f\u540e\u518d\u64cd\u4f5c\u3002", (String)"AbstractTemplateListPlugin_14", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return;
        }
        String msg = ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\u6a21\u677f\u5206\u7c7b\uff1f", (String)"AbstractTemplateListPlugin_15", (String)"epm-emr-formplugin", (Object[])new Object[0]);
        this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("btn_delete", (IFormPlugin)this));
    }

    protected void deleteCatalogConfirm() {
        List<Long> allCatalogIds = this.getCatalogIdsWithChild(true);
        List numbers = this.getEntityDataNumber(this.getEpbsTemplateCatalog(), allCatalogIds.toArray());
        this.getTemplateCatalogService().deleteCatalog(this.getEpbsTemplateCatalog(), allCatalogIds, this.getEpbsTemplateEntity());
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6a21\u677f\u5206\u7c7b\u6210\u529f\u3002", (String)"AbstractTemplateListPlugin_16", (String)"epm-emr-formplugin", (Object[])new Object[0]));
        OperationLogUtil.writeLog((String)this.getBizAppId(), (String)this.getEpbsTemplateCatalog(), (IOperationTypeInfo)OperationTypeEnum.DELETE, (MultiLangEnumBridge)this.getOpDescriotionByNumber(numbers), (Long)this.getModelId());
    }

    protected void upAndDownCatalog(boolean isUp) {
        TreeNode parentNode;
        Long catalogId = this.getCatalogId();
        if (!this.checkCatalog(catalogId)) {
            return;
        }
        String selectNodeId = IDUtils.toString((Object)catalogId);
        TreeNode rootNode = AbstractTreeBuilder.getRootWithCache((TreeView)this.getTreeView());
        TreeNode selectNode = rootNode.getTreeNode(selectNodeId);
        if (selectNode == null) {
            return;
        }
        if (StringUtils.isEmpty((String)selectNode.getParentid()) || null == (parentNode = rootNode.getTreeNode(selectNode.getParentid())) || parentNode.getChildren().size() == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5206\u7c7b\u7684\u7236\u8282\u70b9\u53ea\u6709\u4e00\u4e2a\u4e0b\u7ea7\u8282\u70b9\uff0c\u4e0d\u80fd\u4e0a\u79fb\u4e0b\u79fb\u3002", (String)"AbstractTemplateListPlugin_17", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return;
        }
        List brothers = parentNode.getChildren();
        int index = brothers.indexOf(selectNode);
        if (isUp && index == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"AbstractTemplateListPlugin_18", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!isUp && index == brothers.size() - 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u4e0b\u5c42\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"AbstractTemplateListPlugin_19", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return;
        }
        String swapNodeId = ((TreeNode)brothers.get(isUp ? index - 1 : index + 1)).getId();
        this.getTemplateCatalogService().swapCatalogSeq(this.getEpbsTemplateCatalog(), IDUtils.toLong((Object)selectNodeId), IDUtils.toLong((Object)swapNodeId));
        this.refreshTree(selectNodeId);
        this.writeLog(this.getEpbsTemplateCatalog(), (IOperationTypeInfo)(isUp ? OperationTypeEnum.UP : OperationTypeEnum.DOWN), new Object[]{catalogId});
    }

    public void dealItemLogic() {
        boolean fromReport = this.fromReport();
        this.getView().setVisible(Boolean.valueOf(!fromReport), new String[]{"btn_addtemplate", "btn_deltemplate"});
        this.getView().setVisible(Boolean.valueOf(fromReport), new String[]{"btn_openreport"});
        this.getView().setEnable(Boolean.valueOf(!fromReport), new String[]{"btn_addnew", "btn_delete", "btn_modify", "btn_up", "btn_down"});
    }

    protected boolean fromReport() {
        return this.getFormCustomParam("fromReport") != null;
    }

    public void writeTemplateLog(OperationTypeEnum op, DynamicObject dyo, String prefixTips, String suffixTips) {
        String version = "V1.0";
        Object versionnumber = dyo.get("versionnumber");
        if (versionnumber instanceof BigDecimal) {
            version = TemplateVersionHelper.formatVersionNumber((BigDecimal)versionnumber);
        }
        this.writeLog((IOperationTypeInfo)op, OperationMsgUtil.getWithNumber((String)dyo.getString("number")));
    }
}

