/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.control.SplitDirection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.spread.F7ItemFillBackArgs;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.CellInfo;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.ITemplateModel;
import kd.epm.emr.business.template.MultiSheetTemplateModel;
import kd.epm.emr.business.template.ObjectConvertUtils;
import kd.epm.emr.business.template.ReportContext;
import kd.epm.emr.business.template.SequenceInfo;
import kd.epm.emr.business.template.TemplateInfo;
import kd.epm.emr.business.template.TemplateModelJSONUtil;
import kd.epm.emr.business.template.arearangedim.IRowColDimensionEntry;
import kd.epm.emr.business.template.areasetting.DataAreaSetting;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.areasetting.IFloatInfo;
import kd.epm.emr.business.template.dimension.DefaultDimension;
import kd.epm.emr.business.template.dimension.IDimension;
import kd.epm.emr.business.template.dimension.RowColDimMember;
import kd.epm.emr.business.template.headerarea.HeaderInfo;
import kd.epm.emr.business.template.headerarea.HeaderObject;
import kd.epm.emr.business.template.headerarea.IHeaderInfo;
import kd.epm.emr.business.template.headerarea.IHeaderObject;
import kd.epm.emr.business.template.pagedim.DefaultPageDimensionEntry;
import kd.epm.emr.business.template.pagedim.IPageDimensionEntry;
import kd.epm.emr.business.template.partition.IRowColPartition;
import kd.epm.emr.business.template.quote.QuoteTypeEnum;
import kd.epm.emr.business.template.relation.RelationAreaInfo;
import kd.epm.emr.business.template.service.ITemplateMemberService;
import kd.epm.emr.business.template.service.ITemplateService;
import kd.epm.emr.business.template.service.impl.TemplateServiceImpl;
import kd.epm.emr.business.template.viewpointdim.DefaultViewPointDimensionEntry;
import kd.epm.emr.business.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.emr.common.spread.command.event.CellValueEvent;
import kd.epm.emr.common.spread.command.rangedefined.CellArea;
import kd.epm.emr.common.spread.command.rangedefined.ContextMenuItemsEnum;
import kd.epm.emr.common.spread.command.rangedefined.OneCell;
import kd.epm.emr.common.spread.command.rangedefined.ToolBarItemsEnum;
import kd.epm.emr.common.spread.command.rangedefined.WorkbookOptions;
import kd.epm.emr.common.spread.command.style.AreasStyle;
import kd.epm.emr.common.spread.command.style.CellStyleInfo;
import kd.epm.emr.common.spread.command.style.SyncSpreadOption;
import kd.epm.emr.common.spread.control.ISpreadContainer;
import kd.epm.emr.common.spread.control.SpreadContainer;
import kd.epm.emr.common.spread.domain.view.SpreadSelector;
import kd.epm.emr.common.spread.domain.view.SpreadSheet;
import kd.epm.emr.common.spread.domain.view.event.EventConstant;
import kd.epm.emr.common.spread.domain.view.event.NotifyEvent;
import kd.epm.emr.common.spread.domain.view.js.SpreadProperties;
import kd.epm.emr.common.spread.model.DimMember;
import kd.epm.emr.common.spread.model.IDimMember;
import kd.epm.emr.common.spread.model.StatusBarModel;
import kd.epm.emr.common.spread.sheet.Cell;
import kd.epm.emr.common.spread.util.DataAndJsonTranslator;
import kd.epm.emr.common.template.EmrDefaultDimMember;
import kd.epm.emr.common.template.enums.FloatTypeEnum;
import kd.epm.emr.common.template.enums.TemplateShowTypeEnum;
import kd.epm.emr.common.template.enums.TemplateTypeEnum;
import kd.epm.emr.formplugin.report.helper.FloatLogicHelper;
import kd.epm.emr.formplugin.report.helper.SpreadMemberHelper;
import kd.epm.emr.formplugin.spread.AskExcuteInfo;
import kd.epm.emr.formplugin.spread.SpreadClientInvoker;
import kd.epm.emr.formplugin.spread.SpreadEasyInvoker;
import kd.epm.emr.formplugin.template.AbstractTemplateBasePlugin;
import kd.epm.emr.formplugin.template.ITemplateDynamicPage;
import kd.epm.emr.formplugin.template.ITemplateOpenPage;
import kd.epm.emr.formplugin.template.helper.DimPropertyHelper;
import kd.epm.emr.formplugin.template.helper.MarkSpecialCellHelper;
import kd.epm.emr.formplugin.template.helper.SequenceSettingHelper;
import kd.epm.emr.formplugin.template.helper.SpreadJsonHelper;
import kd.epm.emr.formplugin.template.helper.TemplateAreaManagerHelper;
import kd.epm.emr.formplugin.template.helper.TemplateDynamicPageHelper;
import kd.epm.emr.formplugin.template.helper.TemplateProcessHelper;
import kd.epm.emr.formplugin.template.helper.TemplateVersionHelper;
import kd.epm.epbs.business.member.f7.NewF7Utils;
import kd.epm.epbs.business.model.f7.MemberF7Parameter;
import kd.epm.epbs.business.page.model.Area;
import kd.epm.epbs.business.page.model.BaseEditElement;
import kd.epm.epbs.business.page.model.Element;
import kd.epm.epbs.business.page.model.Page;
import kd.epm.epbs.business.page.model.TextEditElement;
import kd.epm.epbs.business.page.model.util.DragUtil;
import kd.epm.epbs.common.bean.IOperationTypeInfo;
import kd.epm.epbs.common.cache.EpbsThreadCache;
import kd.epm.epbs.common.enums.MultiLangEnumBridge;
import kd.epm.epbs.common.enums.OperationTypeEnum;
import kd.epm.epbs.common.enums.RangeEnum;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.model.IBaseEntry;
import kd.epm.epbs.common.model.IDimensionMember;
import kd.epm.epbs.common.model.PropertyEntry;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.model.bean.relation.FieldBean;
import kd.epm.epbs.common.model.bean.relation.RelationDimBean;
import kd.epm.epbs.common.model.bean.relation.RelationModelBean;
import kd.epm.epbs.common.model.bean.relation.RelationTypeEnum;
import kd.epm.epbs.common.util.ExcelUtils;
import kd.epm.epbs.common.util.ICell;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.JSONUtils;
import kd.epm.epbs.common.util.MapInitHelper;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.OperationLogUtil;
import kd.epm.epbs.common.util.OperationMsgUtil;
import kd.epm.epbs.common.util.Pair;
import kd.epm.epbs.common.util.Point;
import kd.epm.epbs.common.util.RangeModel;
import kd.epm.epbs.common.util.SPArrayList;
import kd.epm.epbs.common.util.Tuple;
import kd.epm.epbs.formplugin.ICommunicateBtwForm;
import kd.epm.epbs.formplugin.model.memberf7.bean.EpbsSelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.bean.MultiF7Result;
import kd.epm.epbs.formplugin.pageinteraction.CommandParam;
import kd.epm.epbs.formplugin.pageinteraction.MainPage;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTemplateProcessPlugin<T extends TemplateInfo>
extends AbstractTemplateBasePlugin<T>
implements BeforeF7SelectListener,
AfterF7SelectListener,
ITemplateOpenPage,
ITemplateDynamicPage,
ICommunicateBtwForm,
MainPage {
    protected static final Log log = LogFactory.getLog(AbstractTemplateProcessPlugin.class);
    public static final String TOOLBARAP = "toolbarap";
    public static final String VIEW_DEFAULT = "VIEW_DEFAULT";
    public static final String VIEW_EDITAREA = "VIEW_EDITAREA";
    public static final String VIEW_EDITAREA_REL = "VIEW_EDITAREA_REL";
    public static final String BTN_BASEINFO = "btn_baseinfo";
    public static final String BTN_DIMSETTING = "btn_dimsetting";
    public static final String BTN_FLOATSETTING = "btn_floatsetting";
    public static final String AREAINFOPANEL = "areainfopanel";
    public static final String ROWDIMPANEL = "rowdimpanel";
    public static final String COLDIMPANEL = "coldimpanel";
    public static final String AREAVIEWPANEL = "areaviewpanel";
    public static final String BTN_SYNCSPREADS = "btn_syncspreads";
    public static final String BTN_SAVE = "btn_save";
    public static final String BTN_BACK = "btn_back";
    public static final String BTN_CLOSE = "btn_close";
    public static final String BTN_AREASETTING = "btn_areasetting";
    public static final String BTN_RELA_AREASETTING = "btn_rela_areasetting";
    public static final String BTN_IMPORTSTYLE = "btn_importstyle";
    public static final String BTN_IDENT_AREA = "btn_ident_area";
    public static final String CURRENTSHEET = "currentsheet";
    public static final String DATAAREAS = "dataareas";
    public static final String FIRSTGRID = "firstgrid";
    public static final String CALLBACK_SELECTAREA = "CALLBACK_SELECTAREA";
    public static final String CALLBACK_SELECTAREA_WITHBIZMODEL = "CALLBACK_SELECTAREA_WITHBIZMODEL";
    public static final String SELECT_AREA = "selectArea";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String TEMPLATEMODEL = "TEMPLATEMODEL";
    public static final String BACKCOLOR_F7CELL = "#66CDAA";
    public static final String BACKCOLOR_FLOATCELL = "#DBE5F1";
    public static final String BACKCOLOR_RED = "red";
    public static final String ON_FLOAT_SETTING = "onFloatSetting";
    public static final String IS_ROW = "isRow";
    public static final String ADDROWPROPLAB = "addrowproplab";
    public static final String ADDCOLPROPLAB = "addcolproplab";
    public static final String ADDCOLFIELDLAB = "addcolfieldlab";
    public static final String ADDROWDIMLAB = "addrowdimlab";
    public static final String ADDCOLDIMLAB = "addcoldimlab";
    public static final String ADDROWSEQLAB = "addrowseqlab";
    public static final String ADDCOLSEQLAB = "addcolseqlab";
    private static final String ISDATACHANGED = "isdatachanged";
    public static final String CACHE_DIMPROPERTYSELECTED = "CacheDimPropertySelected";
    protected static final Set<String> DropPanel = Sets.newHashSet((Object[])new String[]{"areaviewpanel", "rowdimpanel", "coldimpanel"});
    public static final String BTN_SEQSETTING = "btn_seqsetting";
    public static final String BTN_DEL_AREASETTING = "btn_del_areasetting";
    public static final String ROW_CELL_F7 = "rowCellF7";
    public static final String COL_CELL_F7 = "colCellF7";
    public static final String SPREADF7 = "spreadf7";
    public static final String ROW = "row";
    public static final String COL = "col";
    public static final String VIEW = "view";
    public static final String EPM_PREFIX = "epm_";
    public static final String allname = "map";
    public static final String CACHE_ALL_NUMBER = "cache_all_number";
    public static final String DIM_MAPS = "dimMaps";
    public static final String PROPERTY_MAPS = "propertyMaps";
    public static final String F7_SELECTIDS = "f7_selectIds";
    public static final String CURRENTBIZMODEL = "currentbizmodel";
    public static final String CURRENTBIZMODEL_ID = "currentbizmodel_id";
    public static final String SPREADF7CLICK_RELA = "spreadF7Click_rela";
    public static final String DropEventArgs = "dropEventArgs";
    private List<IDimension> allDims;
    protected static final String ALLDIMS_KEY = "allDims";
    private List<PropertyEntry> allPropertys;
    protected static final String ALLPROPERTYS_KEY = "allPropertys";
    public static final String CALLBACK_ROWPROPERTYSETTING = "CALLBACK_ROWPROPERTYSETTING";
    public static final String CALLBACK_COLPROPERTYSETTING = "CALLBACK_COLPROPERTYSETTING";
    public static final String CALLBACK_SETCOLFIELDS = "CALLBACK_SETCOLFIELDS";
    public static final String UNDERSCORE = "_";
    protected boolean exchangeElement;
    protected boolean dropConfirm;
    protected boolean hasInitDimsPanel;
    protected TemplateDynamicPageHelper dynamicPageHelper;
    protected ITemplateService templateService;
    private ISpreadContainer colSpreadContainer = null;
    private ISpreadContainer rowSpreadContainer = null;
    protected static String[] ITEMS_SELECT_AREA = new String[]{"btn_save", "btn_importstyle", "btn_baseinfo", "btn_dimsetting", "btn_areasetting", "btn_ident_area", "btn_syncspreads", "btn_back", "btn_close", "btn_seqsetting", "btn_del_areasetting", "btn_floatsetting"};
    protected static String[] ITEMS_VIEW_DEFAULT = new String[]{"btn_save", "btn_areasetting", "btn_dimsetting", "btn_seqsetting", "btn_del_areasetting", "btn_close"};
    protected static String[] ITEMS_VIEW_EDITAREA = new String[]{"btn_areasetting", "btn_syncspreads", "areainfopanel", "btn_back", "btn_floatsetting", "btn_del_areasetting", "addrowproplab", "addcolproplab"};
    protected static String[] ITEMS_VIEW_EDITAREA_REL = new String[]{"btn_areasetting", "btn_syncspreads", "areainfopanel", "btn_back", "btn_del_areasetting", "addcolfieldlab", "currentbizmodel"};
    protected static String[] ITEMS_ON_FLOAT_SETTING = new String[]{"btn_baseinfo", "btn_areasetting", "btn_del_areasetting", "btn_syncspreads", "areainfopanel", "btn_back", "btn_floatsetting", "btn_close", "addrowdimlab", "addcoldimlab", "addrowproplab", "addcolproplab"};
    private RelationModelBean relationModelBean = null;
    private Map<String, FieldBean> relaFieldMap = null;
    private Map<String, String> nameMap = null;
    private Map<String, String> numberMap = null;

    @Override
    public TemplateDynamicPageHelper getDynamicPageHelper() {
        if (this.dynamicPageHelper == null) {
            this.dynamicPageHelper = TemplateDynamicPageHelper.getInstance(this.getPageCache());
            this.dynamicPageHelper.setDropPanel(DropPanel);
        }
        return this.dynamicPageHelper;
    }

    public ITemplateService getTemplateService() {
        if (null == this.templateService) {
            this.templateService = TemplateServiceImpl.getInstance((ITemplateMemberService)this.getTemplateMemberService());
        }
        return this.templateService;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        this.addClickListeners(new String[]{ADDROWPROPLAB, ADDCOLPROPLAB, ADDROWDIMLAB, ADDCOLDIMLAB, ADDCOLFIELDLAB});
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), this.getSpreadKey(), "templateDataSave", "D", true, true, true);
        this.registerAfterEvent(EventConstant.ActionName.CELL_SELECT, this::sendMsgToFloatPage);
    }

    protected void sendMsgToFloatPage(NotifyEvent evt) {
        SpreadSelector selector;
        if (!this.isEditDataArea() && (selector = this.getSpreadSelector(this.getSpreadKey())) != null) {
            this.sendMsg(this.getView(), new CommandParam(this.getView().getFormShowParameter().getFormId(), this.getSeqFormId(), null, new Object[]{selector}));
        }
    }

    public void dealMsg(CommandParam com) {
    }

    @Override
    public void rowColOperationCheck(NotifyEvent notifyEvent) {
        try {
            TemplateAreaManagerHelper.rowColOperationCheck(notifyEvent, this.getSheetManager(), false, s -> this.getTemplateMemberService().getRelationModel(s));
        }
        catch (Exception e) {
            notifyEvent.setCancel(true);
            this.getView().showTipNotification(e.getMessage());
        }
    }

    @Override
    public void updateRowAndCol2View(IClientViewProxy view, String spreadKey, AskExcuteInfo excuteinfo) {
        super.updateRowAndCol2View(view, spreadKey, excuteinfo);
        if (this.isEditDataArea()) {
            super.updateRowAndCol2View(view, excuteinfo.getOperation() == 0 ? this.getRowSpreadKey() : this.getColSpreadKey(), excuteinfo);
            this.loadDataAreaComboItems(this.getSheetManager().getAreaRanges(), this.getActiveDataArea(), true);
        }
        MarkSpecialCellHelper.dealSpecialCells(this.getView(), this.getSpreadKey(), this.getSheetManager(), true, true);
    }

    @Override
    public void adjustMultiAreaSetting(AskExcuteInfo excuteinfo) {
        IDataAreaSetting areaSetting = this.getMultiAreaSetting();
        MarkSpecialCellHelper.dealSpecialCells(this.getView(), this.getSpreadKey(), this.getSheetManager(), false, true);
        HashSet<SequenceInfo> removeSequenceInfo = new HashSet<SequenceInfo>(16);
        TemplateAreaManagerHelper.adjustMultiAreaSetting(removeSequenceInfo, this.getSheetManager(), excuteinfo, false);
        TemplateAreaManagerHelper.correctionAreaSettings(this.getSheetManager());
        SequenceSettingHelper.adjustFromArea(removeSequenceInfo, this.getSheetManager().getAreaRanges());
        this.cacheSheetManager();
        this.getTemplateModel().setSheetManager(this.getSheetManager());
        this.cacheTemplateModel();
        if (this.isEditDataArea() && areaSetting != null) {
            if (TemplateProcessHelper.validateArea(areaSetting.getAreaRange())) {
                this.setActiveDataArea(areaSetting.getAreaRange());
            } else {
                List areaSettings = this.getSheetManager().getAreaRanges();
                if (CollectionUtils.isNotEmpty((Collection)areaSettings)) {
                    this.setActiveDataArea(((IDataAreaSetting)areaSettings.get(0)).getAreaRange());
                } else {
                    this.switchView(VIEW_DEFAULT);
                }
            }
        }
        this.setDataChanged(true);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.isAddNewStatus()) {
            this.processNewTemplate();
            this.initSheetManager();
        } else {
            this.processEditTemplate();
        }
        this.getSpreadContainer().lockToolbarItems((List)Lists.newArrayList((Object[])new ToolBarItemsEnum[]{ToolBarItemsEnum.DATAVALIDATION, ToolBarItemsEnum.CHECKFORMULA, ToolBarItemsEnum.UPLOADFILE, ToolBarItemsEnum.EXPORTFILE}), new ArrayList());
    }

    protected void processNewTemplate() {
        this.switchView(VIEW_DEFAULT);
        this.getSpreadContainer().rebuildSpread(DataAndJsonTranslator.getEmptySpreadJson((int)DataAndJsonTranslator.DEFAULT_ROWCOUNT, (int)DataAndJsonTranslator.DEFAULT_COLUMNCOUNT, (int)0, (int)0));
    }

    protected void initSheetManager() {
        this.getMultiSheetTemplateModel().setTemplateBaseInfo(this.getTemplateBaseInfo());
        this.getMultiSheetTemplateModel().addSheet(this.getActiveSheet().getSheetName(), 0);
        this.cacheMultiSheetTemplateModel();
        this.setDataChanged(true);
    }

    protected void switchView(String view) {
        if (this.beforeSwitchView(view)) {
            switch (view) {
                case "VIEW_DEFAULT": {
                    this.getView().setVisible(Boolean.valueOf(false), this.getToolBarItems(VIEW_EDITAREA));
                    this.getView().setVisible(Boolean.valueOf(false), this.getToolBarItems(VIEW_EDITAREA_REL));
                    this.getView().setVisible(Boolean.valueOf(true), this.getToolBarItems(VIEW_DEFAULT));
                    ((SplitContainer)this.getControl("splitcontainerap")).hidePanel(SplitDirection.left, true);
                    ((SplitContainer)this.getControl("splitcontainerap2")).hidePanel(SplitDirection.up, true);
                    this.syncSpreads(false);
                    break;
                }
                case "VIEW_EDITAREA": {
                    this.getView().setVisible(Boolean.valueOf(false), this.getToolBarItems(VIEW_DEFAULT));
                    this.getView().setVisible(Boolean.valueOf(false), this.getToolBarItems(VIEW_EDITAREA_REL));
                    this.getView().setVisible(Boolean.valueOf(true), this.getToolBarItems(VIEW_EDITAREA));
                    ((SplitContainer)this.getControl("splitcontainerap")).hidePanel(SplitDirection.left, false);
                    ((SplitContainer)this.getControl("splitcontainerap2")).hidePanel(SplitDirection.up, false);
                    this.syncSpreads(true);
                    break;
                }
                case "VIEW_EDITAREA_REL": {
                    this.getView().setVisible(Boolean.valueOf(false), this.getToolBarItems(VIEW_DEFAULT));
                    this.getView().setVisible(Boolean.valueOf(false), this.getToolBarItems(VIEW_EDITAREA));
                    this.getView().setVisible(Boolean.valueOf(true), this.getToolBarItems(VIEW_EDITAREA_REL));
                    ((SplitContainer)this.getControl("splitcontainerap")).hidePanel(SplitDirection.left, true);
                    ((SplitContainer)this.getControl("splitcontainerap2")).hidePanel(SplitDirection.up, false);
                    this.syncSpreads(true);
                }
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_SEQSETTING, BTN_FLOATSETTING});
        }
        this.afterSwitchView(view);
    }

    protected boolean beforeSwitchView(String view) {
        return true;
    }

    protected void afterSwitchView(String view) {
        this.setCurrentView(view);
        if (VIEW_EDITAREA.equals(view)) {
            // empty if block
        }
    }

    private String getCurrentView() {
        String currentView = this.getPageCache().get("currentView");
        if (StringUtils.isEmpty((String)currentView)) {
            currentView = VIEW_DEFAULT;
        }
        return currentView;
    }

    protected void setCurrentView(String view) {
        this.getPageCache().put("currentView", view);
    }

    protected void processEditTemplate() {
        this.switchView(VIEW_DEFAULT);
        Object templateBaseInfo = this.getTemplateBaseInfo();
        String spreadJson = templateBaseInfo.getSpreadJson();
        this.initTemplateModel(templateBaseInfo);
        this.getSpreadContainer().rebuildSpread(spreadJson);
    }

    protected void initTemplateModel(T templateBaseInfo) {
        this.templateModel = this.getTemplateService().getTemplateModel(templateBaseInfo);
        this.multiSheetTemplateModel = MultiSheetTemplateModel.getInstance();
        this.multiSheetTemplateModel.initTemplateModel(this.templateModel);
        this.cacheMultiSheetTemplateModel(true);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        String ctrlKey = e.getKey();
        if (this.checkControlKey(ctrlKey)) {
            this.onGetControlByTemplate(e);
        }
    }

    protected String getCurrentDimNumber(String controlKey) {
        IDimension dimension = this.getDimByCtrlKey(controlKey);
        if (dimension != null) {
            return dimension.getNumber();
        }
        return null;
    }

    protected IDimension getDimByCtrlKey(String ctrlKey) {
        String dimNumber;
        if (ctrlKey == null) {
            return null;
        }
        Map<String, String> map = this.getDynamicPageHelper().getPointBySign(ctrlKey);
        String string = dimNumber = null != map ? map.get("number") : null;
        if (StringUtils.isNotEmpty((String)dimNumber)) {
            IDimension dimension = this.getTemplateMemberService().getDimension(dimNumber);
            return dimension;
        }
        return null;
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_save": {
                this.clearInvalidCellValues();
                this.save();
                this.setDataChanged(false);
                break;
            }
            case "btn_importstyle": {
                break;
            }
            case "btn_baseinfo": {
                this.openTemplatePage();
                break;
            }
            case "btn_dimsetting": {
                this.showFormDimSetting();
                break;
            }
            case "btn_areasetting": 
            case "btn_rela_areasetting": {
                this.openAreaSetting(itemKey.equals(BTN_RELA_AREASETTING));
                break;
            }
            case "btn_ident_area": {
                this.getSpreadContainer().getSpreadJson("identArea");
                break;
            }
            case "btn_syncspreads": {
                this.getSpreadContainer().getSpreadJson("syncSpreads");
                break;
            }
            case "btn_floatsetting": {
                this.showFormFloatSetting();
                break;
            }
            case "btn_back": {
                this.switchView(VIEW_DEFAULT);
                this.clearDimsPanelCache();
                this.setCurrentBizModel(null);
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u533a\u57df\u8bbe\u7f6e\u5df2\u6682\u5b58\u3002", (String)"AbstractTemplateProcessPlugin_0", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                break;
            }
            case "btn_seqsetting": {
                this.openSeqSetting(this.getSpreadSelector(this.getSpreadKey()), this.getSheetManager().getAreaRanges());
                break;
            }
            case "btn_del_areasetting": {
                ArrayList<String> areas = new ArrayList<String>(16);
                if (VIEW_DEFAULT.equals(this.getCurrentView())) {
                    List<IDataAreaSetting> multiAreaSettings = this.getMultiAreaSettingsBySelect();
                    if (CollectionUtils.isNotEmpty(multiAreaSettings)) {
                        multiAreaSettings.forEach(m -> areas.add(m.getAreaRange()));
                    }
                } else {
                    IDataAreaSetting multiAreaSetting = this.getMultiAreaSetting();
                    if (multiAreaSetting != null) {
                        areas.add(multiAreaSetting.getAreaRange());
                    }
                }
                if (CollectionUtils.isNotEmpty(areas)) {
                    this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u662f\u5426\u786e\u5b9a\u5220\u9664\u6570\u636e\u533a\u57df%s\uff1f\u5982\u786e\u8ba4\u5c06\u5220\u9664\u8be5\u533a\u57df\u5185\u6240\u6709\u7ef4\u5ea6\u6210\u5458\u76f8\u5173\u8bbe\u7f6e\u4fe1\u606f\u3002", (String)"AbstractTemplateProcessPlugin_1", (String)"epm-emr-formplugin", (Object[])new Object[0]), areas), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(BTN_DEL_AREASETTING, (IFormPlugin)this));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0b\u62c9\u9009\u62e9\u6570\u636e\u533a\u57df\u540e\u518d\u64cd\u4f5c\u3002", (String)"AbstractTemplateProcessPlugin_2", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                break;
            }
        }
    }

    protected void clearInvalidCellValues() {
        LinkedList cells = new LinkedList();
        this.getSheetManager().getAreaRanges().forEach(e -> cells.addAll(TemplateProcessHelper.getCompletedCells(e)));
        if (!cells.isEmpty()) {
            this.getSpreadContainer().updateCellValue2(cells);
        }
        SpreadMemberHelper.updateCellsNotChange(this.getSheetManager());
        this.cacheSheetManager();
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "addrowproplab": {
                this.setDimProperty(true);
                break;
            }
            case "addcolproplab": {
                this.setDimProperty(false);
                break;
            }
            case "addcolfieldlab": {
                this.setColFields();
            }
        }
    }

    protected void setColFields() {
        ListShowParameter param = new ListShowParameter();
        param.setFormId("bos_listf7");
        param.setBillFormId(this.getRelationModelEntity());
        param.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        param.getOpenStyle().setInlineStyleCss(css);
        param.setShowApproved(true);
        param.setShowUsed(true);
        param.setLookUp(true);
        param.setShowFilter(false);
        param.setShowQuickFilter(false);
        param.setShowTitle(true);
        param.setMultiSelect(true);
        ListFilterParameter listFilter = new ListFilterParameter();
        listFilter.setQFilters((List)Lists.newArrayList((Object[])new QFilter[]{new QFilter("bizmodel", "=", (Object)this.getCurrentBizModelId()).and(new QFilter("type", "!=", (Object)Character.valueOf('3')))}));
        listFilter.setOrderBy("dseq");
        param.setListFilterParameter(listFilter);
        LinkedList<Long> ids = new LinkedList<Long>();
        List<String> colEntries = this.getRowColEntry(false);
        if (CollectionUtils.isNotEmpty(colEntries)) {
            for (String e : colEntries) {
                FieldBean field = this.getRelaFieldMap().get(this.getNumberMap().get(e));
                if (field == null) continue;
                ids.add(field.getId());
            }
            param.setSelectedRows(ids.toArray());
        }
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_SETCOLFIELDS));
        this.getView().showForm((FormShowParameter)param);
    }

    protected String getRelationModelEntity() {
        return "epbs_relationmodelentity";
    }

    protected void setDimProperty(boolean isRow) {
        String rangeSign = isRow ? ResManager.loadKDString((String)"\u884c", (String)"AbstractTemplateProcessPlugin_3", (String)"epm-emr-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5217", (String)"AbstractTemplateProcessPlugin_4", (String)"epm-emr-formplugin", (Object[])new Object[0]);
        FormShowParameter showParam = new FormShowParameter();
        List<Map<String, String>> rangeDims = this.getRangeDim(isRow);
        if (rangeDims.size() == 0) {
            String errStr = ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u5c5e\u6027\u4e3a\u7a7a\u3002", (String)"AbstractTemplateProcessPlugin_5", (String)"epm-emr-formplugin", (Object[])new Object[]{rangeSign});
            this.getView().showErrorNotification(errStr);
            return;
        }
        String caption = ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u5c5e\u6027\u8bbe\u7f6e", (String)"AbstractTemplateProcessPlugin_6", (String)"epm-emr-formplugin", (Object[])new Object[]{rangeSign});
        showParam.setCaption(caption);
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        showParam.setFormId("epbs_dimpropertysetting");
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("KEY_MODEL_ID", this.getModelId());
        params.put(DIM_MAPS, SerializationUtils.toJsonString(rangeDims));
        params.put(ALLPROPERTYS_KEY, SerializationUtils.serializeToBase64(this.getAllPropertysCache()));
        List<Map<String, String>> f7Items = this.getF7itemsByDim(rangeDims, true);
        String propertyMapsCache = "";
        if (f7Items.size() > 0) {
            propertyMapsCache = SerializationUtils.toJsonString(f7Items);
        }
        params.put(PROPERTY_MAPS, propertyMapsCache);
        showParam.setCustomParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, isRow ? CALLBACK_ROWPROPERTYSETTING : CALLBACK_COLPROPERTYSETTING);
        showParam.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParam);
    }

    private List<Map<String, String>> getF7itemsByDim(List<Map<String, String>> curDims, boolean isExists) {
        List<Map<String, String>> curF7Items = new ArrayList<Map<String, String>>(16);
        String areaCacheKey = this.getAreaCacheKey();
        String propertyMapsCache = this.getPageCache().get(areaCacheKey);
        if (!StringUtils.isEmpty((String)propertyMapsCache)) {
            List allF7Items = (List)SerializationUtils.fromJsonString((String)propertyMapsCache, List.class);
            curF7Items = this.filterF7itemsByDim(allF7Items, curDims, isExists);
        }
        return curF7Items;
    }

    public List<Map<String, String>> filterF7itemsByDim(List<Map<String, String>> allF7items, List<Map<String, String>> curDims, boolean isExists) {
        List dimNums = curDims.stream().map(dim -> (String)dim.get("number")).collect(Collectors.toList());
        ArrayList<Map<String, String>> curF7Items = new ArrayList<Map<String, String>>(16);
        for (Map<String, String> f7Item : allF7items) {
            if (isExists && dimNums.contains(f7Item.get("dimnum"))) {
                curF7Items.add(f7Item);
                continue;
            }
            if (isExists || dimNums.contains(f7Item.get("dimnum"))) continue;
            curF7Items.add(f7Item);
        }
        return curF7Items;
    }

    protected List<Map<String, String>> getRangeDim(boolean isRow) {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(16);
        List<String> curDims = this.getRowColEntry(isRow);
        if (CollectionUtils.isEmpty(curDims)) {
            return result;
        }
        for (String curDim : curDims) {
            IDimension dimension;
            if (this.isProperty(curDim) || null == (dimension = this.getTemplateMemberService().getDimension(this.getNumberMap().get(curDim)))) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dimension.getId() + "");
            map.put("name", dimension.getName());
            map.put("number", dimension.getNumber());
            map.put("entity", dimension.getMemberModel());
            map.put("seq", String.valueOf(dimension.getDSeq()));
            map.put("sign", dimension.getMemberModel());
            map.put("panel", "");
            result.add(map);
        }
        return result;
    }

    protected boolean isEditDataArea() {
        return !VIEW_DEFAULT.equals(this.getCurrentView());
    }

    protected void openAreaSetting(boolean isRela) {
        boolean selectArea = true;
        if (this.getTemplateType() == TemplateTypeEnum.FIX) {
            SpreadSelector selector = this.getSpreadSelector(this.getSpreadKey());
            if (selector != null && CollectionUtils.isNotEmpty(this.getMultiAreaSettingsBySelect())) {
                selectArea = false;
            }
            if (selectArea) {
                this.templateModel = this.getTemplateModel();
                if (!isRela && (this.templateModel == null || this.templateModel.getRowcolDims() == null || this.templateModel.getRowcolDims().isEmpty())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8fdb\u884c\u7ef4\u5ea6\u5e03\u5c40\u8bbe\u7f6e\u3002", (String)"AbstractTemplateProcessPlugin_7", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                } else if (this.checkCanNewArea(selector, this.getSheetManager().getAreaRanges(), isRela)) {
                    this.selectArea(isRela);
                }
            } else {
                this.setActiveDataArea(selector.getRect());
                this.getSpreadContainer().getSpreadJson("showAreaSetting");
            }
        }
    }

    public void openSeqSetting(SpreadSelector selector, List<IDataAreaSetting> multiAreaSettings) {
    }

    public String getSeqFormId() {
        return "epbs_template_seqsetting";
    }

    public void showAreaSetting(String spreadJson) {
        String dataArea = this.getActiveDataArea();
        if (StringUtils.isEmpty((String)dataArea)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u533a\u57df\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"AbstractTemplateProcessPlugin_8", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return;
        }
        List existingAreas = this.getSheetManager().getAreaRanges();
        IDataAreaSetting multiAreaSetting = this.getMultiAreaSetting();
        if (multiAreaSetting == null || !ExcelUtils.isOverlap((String)dataArea, (String)multiAreaSetting.getAreaRange())) {
            List<IDataAreaSetting> overlapAreas = TemplateProcessHelper.getListOverlapAreaRange(dataArea, existingAreas);
            if (CollectionUtils.isEmpty(overlapAreas)) {
                String message = TemplateAreaManagerHelper.setDataAreaBeforeCheck(dataArea, existingAreas);
                if (StringUtils.isNotEmpty((String)message)) {
                    this.getView().showErrorNotification(message);
                    return;
                }
                multiAreaSetting = this.defaultMultiAreaSetting(dataArea, this.getTemplateModel());
            } else {
                multiAreaSetting = overlapAreas.get(0);
            }
        }
        if (multiAreaSetting != null) {
            boolean isDefaultView = VIEW_DEFAULT.equals(this.getCurrentView());
            if (isDefaultView) {
                this.switchView(IDUtils.isNotNull((Long)this.getCurrentBizModelId()) ? VIEW_EDITAREA_REL : VIEW_EDITAREA);
            }
            String areaRange = multiAreaSetting.getAreaRange();
            this.getModel().setValue(CURRENTSHEET, (Object)this.getActiveSheet().getSheetName());
            this.setActiveDataArea(areaRange);
            this.loadDataAreaComboItems(existingAreas, areaRange, true);
            this.showAreaSetting(spreadJson, multiAreaSetting, true);
        }
    }

    protected void showAreaSetting(String spreadJson, IDataAreaSetting multiAreaSetting, boolean isFix) {
        if (multiAreaSetting != null) {
            String areaRange = multiAreaSetting.getAreaRange();
            this.setActiveDataArea(areaRange);
            if (multiAreaSetting.getRelationAreaInfo() != null) {
                this.setCurrentBizModel(this.getTemplateMemberService().getBizModelId(multiAreaSetting.getRelationAreaInfo().getRelationModel()));
            } else {
                this.setCurrentBizModel(this.getBizModelId());
            }
            this.switchView(this.isRelation() ? VIEW_EDITAREA_REL : VIEW_EDITAREA);
            this.getView().setVisible(Boolean.valueOf(isFix), new String[]{DATAAREAS});
            this.getView().setVisible(Boolean.valueOf(!isFix), new String[]{FIRSTGRID});
            this.initRowColDimsPanel(multiAreaSetting);
            if (isFix && StringUtils.isNotEmpty((String)spreadJson)) {
                JSONObject jsonObject = DataAndJsonTranslator.fromSpreadJson((String)spreadJson);
                JSONObject selectedSheet = DataAndJsonTranslator.getSelectedSheet((JSONObject)jsonObject);
                if (selectedSheet != null) {
                    Integer columnCount;
                    Integer rowCount = selectedSheet.getInteger("rowCount");
                    if (rowCount == null) {
                        rowCount = DataAndJsonTranslator.DEFAULT_ROWCOUNT;
                    }
                    if ((columnCount = selectedSheet.getInteger("columnCount")) == null) {
                        columnCount = DataAndJsonTranslator.DEFAULT_COLUMNCOUNT;
                    }
                    Integer leftCellIndex = selectedSheet.getInteger("leftCellIndex");
                    Integer topCellIndex = selectedSheet.getInteger("topCellIndex");
                    CellArea rowSpreadArea = new CellArea(0, 0, rowCount.intValue(), multiAreaSetting.getRowHeaders().size());
                    CellArea colSpreadArea = new CellArea(0, 0, this.isRelation() ? 2 : multiAreaSetting.getColHeaders().size(), columnCount.intValue());
                    this.cacheRowColSpreadArea(rowSpreadArea, colSpreadArea);
                    this.getRowSpreadContainer().rebuildSpread(DataAndJsonTranslator.getEmptySpreadJson((int)rowSpreadArea.getRc(), (int)rowSpreadArea.getCc(), (int)0, (int)(topCellIndex == null ? 0 : topCellIndex)));
                    this.getColSpreadContainer().rebuildSpread(DataAndJsonTranslator.getEmptySpreadJson((int)colSpreadArea.getRc(), (int)colSpreadArea.getCc(), (int)(leftCellIndex == null ? 0 : leftCellIndex), (int)0));
                    this.initRowHeightsAndColWidths(selectedSheet);
                    this.defaultRowColSpreads(this.getRowSpreadContainer());
                    this.defaultRowColSpreads(this.getColSpreadContainer());
                    SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getRowSpreadKey());
                    invoker.setWorksheetOptions(SpreadProperties.SetWorkSheetOptions.CLIPBOARDOPTIONS.k(), 1);
                    invoker.setWorksheetOptions("colHeaderAutoText", "blank");
                    invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getColSpreadKey());
                    invoker.setWorksheetOptions(SpreadProperties.SetWorkSheetOptions.CLIPBOARDOPTIONS.k(), 1);
                    invoker.setWorksheetOptions("rowHeaderAutoText", "blank");
                    MarkSpecialCellHelper.markSpecialCells(new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey()), multiAreaSetting, true);
                    this.refreshRowColSpreads(multiAreaSetting);
                }
            } else {
                this.getModel().setValue(FIRSTGRID, (Object)multiAreaSetting.getAreaRangeStart());
            }
            this.getSpreadContainer().closeToolbar();
            this.getSpreadContainer().setSelections(new CellArea(areaRange));
            if (TRUE.equals(this.getPageCache().get("switchArea"))) {
                this.getSpreadContainer().getSpreadJson("showAreaSetting");
                this.getPageCache().remove("switchArea");
            }
        }
    }

    private void syncSpreads(boolean sync) {
        this.getSpreadContainer().syncSpreads((List)Lists.newArrayList((Object[])new String[]{this.getRowSpreadKey()}), SyncSpreadOption.getOptions((boolean)true, (boolean)false, (boolean)true, (boolean)false, (boolean)true), sync);
        this.getSpreadContainer().syncSpreads((List)Lists.newArrayList((Object[])new String[]{this.getColSpreadKey()}), SyncSpreadOption.getOptions((boolean)false, (boolean)true, (boolean)false, (boolean)true, (boolean)true), sync);
    }

    protected void cacheRowColSpreadArea(CellArea rowSpreadArea, CellArea colSpreadArea) {
        this.getPageCache().put("rowSpreadArea", rowSpreadArea == null ? null : this.toByteSerialized(rowSpreadArea));
        this.getPageCache().put("colSpreadArea", colSpreadArea == null ? null : this.toByteSerialized(colSpreadArea));
    }

    protected CellArea[] getRowColSpreadArea() {
        CellArea[] cellAreas = new CellArea[2];
        String strRow = this.getPageCache().get("rowSpreadArea");
        String strCol = this.getPageCache().get("colSpreadArea");
        cellAreas[0] = StringUtils.isNotEmpty((String)strRow) ? (CellArea)this.deSerializedBytes(strRow) : null;
        cellAreas[1] = StringUtils.isNotEmpty((String)strCol) ? (CellArea)this.deSerializedBytes(strCol) : null;
        return cellAreas;
    }

    private void initRowHeightsAndColWidths(JSONObject selectedSheet) {
        List indexes;
        int i;
        if (selectedSheet == null) {
            return;
        }
        JSONObject sheetDefaults = selectedSheet.getJSONObject("defaults");
        JSONArray sheetRows = selectedSheet.getJSONArray("rows");
        JSONArray sheetCols = selectedSheet.getJSONArray("columns");
        if (sheetDefaults != null) {
            int rowHeight = sheetDefaults.getIntValue("rowHeight");
            int colWidth = sheetDefaults.getIntValue("colWidth");
            this.getRowSpreadContainer().setSheetDefaults(Integer.valueOf(rowHeight), Integer.valueOf(colWidth), 0);
            this.getColSpreadContainer().setSheetDefaults(Integer.valueOf(rowHeight), Integer.valueOf(colWidth), 0);
        }
        if (sheetRows != null) {
            HashMap<Integer, List> rowHeights = new HashMap<Integer, List>(16);
            for (i = 0; i < sheetRows.size(); ++i) {
                Integer size;
                if (!(sheetRows.get(i) instanceof JSONObject) || (size = ((JSONObject)sheetRows.get(i)).getInteger("size")) == null) continue;
                indexes = rowHeights.computeIfAbsent(size, f -> new ArrayList());
                indexes.add(i);
            }
            rowHeights.forEach((k, v) -> this.getRowSpreadContainer().setRowsHeight(v, k.intValue()));
        }
        if (sheetCols != null) {
            HashMap<Integer, List> colWidths = new HashMap<Integer, List>(16);
            for (i = 0; i < sheetCols.size(); ++i) {
                Integer size;
                if (!(sheetCols.get(i) instanceof JSONObject) || (size = ((JSONObject)sheetCols.get(i)).getInteger("size")) == null) continue;
                indexes = colWidths.computeIfAbsent(size, f -> new ArrayList());
                indexes.add(i);
            }
            colWidths.forEach((k, v) -> this.getColSpreadContainer().setColumnsWidth(v, k.intValue()));
        }
    }

    protected void initRowColDimsPanel(IDataAreaSetting multiAreaSetting) {
        this.initAreaDimProperty(multiAreaSetting);
        this.initDimsPanel(true);
    }

    protected void initAreaDimProperty(IDataAreaSetting ae) {
        String area = this.getAreaCacheKey();
        if (StringUtils.isNotEmpty((String)this.getPageCache().get(area)) || ae == null) {
            return;
        }
        ArrayList selectPropertyItems = Lists.newArrayList();
        this.initDimPropertyCache(COLDIMPANEL, ae.getColHeaders(), selectPropertyItems);
        this.initDimPropertyCache(ROWDIMPANEL, ae.getRowHeaders(), selectPropertyItems);
        this.getPageCache().put(area, SerializationUtils.toJsonString((Object)selectPropertyItems));
    }

    protected void initDimPropertyCache(String panelSign, List<IHeaderInfo> rowColHeaders, List<Map<String, String>> selectPropertyItems) {
        rowColHeaders.stream().filter(e -> "Property".equals(e.getType())).forEach(e -> {
            Map<String, String> map;
            String dimNumber;
            IDimension dimension;
            String propertyNumber = e.getNumber();
            PropertyEntry property = this.getPropertyByNumber(propertyNumber);
            if (property != null && (dimension = this.getDimByNumber(dimNumber = property.getRefDimNumber())) != null && (map = this.buildDimPropertyItemMap(panelSign, dimension, property)) != null) {
                selectPropertyItems.add(map);
                this.getDynamicPageHelper().putDimProperty(map.get("sign"), map);
            }
        });
    }

    protected Map<String, String> buildDimPropertyItemMap(String panelSign, IDimension dimension, PropertyEntry property) {
        String propertySign = this.getPropertySign(property.getNumber(), property.getRefDimNumber());
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("id", String.valueOf(property.getId()));
        map.put("name", property.getName());
        map.put("number", property.getNumber());
        map.put("key", String.join((CharSequence)"#", String.valueOf(dimension.getId()), String.valueOf(property.getId())));
        map.put("dseq", String.valueOf(property.getDseq()));
        map.put("dimid", String.valueOf(dimension.getId()));
        map.put("dimname", dimension.getName());
        map.put("dimnum", dimension.getNumber());
        map.put("sign", propertySign);
        return map;
    }

    protected void clearDimsPanelCache() {
        this.getDynamicPageHelper().cleanAllPoint();
        this.getPageCache().remove(this.getAreaCacheKey());
        this.getPageCache().remove(ROW);
        this.getPageCache().remove(COL);
        this.getPageCache().remove(VIEW);
    }

    protected void refreshRowColSpreads(IDataAreaSetting multiAreaSetting) {
        this.setCellF7Style(multiAreaSetting);
        this.fillRowColSpreads(multiAreaSetting);
    }

    protected void fillRowColSpreads(IDataAreaSetting multiAreaSetting) {
        if (multiAreaSetting != null) {
            IHeaderObject headerObject;
            int j;
            List headerObjects;
            IHeaderInfo headerInfo;
            int i;
            this.refreshHeaderDisplays(multiAreaSetting);
            CellArea cellArea = new CellArea(multiAreaSetting.getAreaRange());
            int rowStart = cellArea.getR();
            int colStart = cellArea.getC();
            List rowHeaders = multiAreaSetting.getRowHeaders();
            List colHeaders = multiAreaSetting.getColHeaders();
            LinkedList<OneCell> cells = new LinkedList<OneCell>();
            for (i = 0; i < rowHeaders.size(); ++i) {
                headerInfo = (IHeaderInfo)rowHeaders.get(i);
                cells.add(new OneCell(rowStart - 1, i, (Object)headerInfo.getName()));
                headerObjects = headerInfo.getHeaderObjects();
                if (headerObjects == null || headerObjects.isEmpty()) continue;
                for (j = 0; j < headerObjects.size(); ++j) {
                    headerObject = (IHeaderObject)headerObjects.get(j);
                    if (headerObject == null) continue;
                    cells.add(new OneCell(rowStart + j, i, (Object)headerObject.getName()));
                }
            }
            if (!cells.isEmpty()) {
                this.getRowSpreadContainer().updateCellValue2(cells);
                cells.clear();
            }
            if (multiAreaSetting.isRelation()) {
                for (i = 0; i < colHeaders.size(); ++i) {
                    headerInfo = (IHeaderInfo)colHeaders.get(i);
                    cells.add(new OneCell(0, colStart + i, (Object)headerInfo.getName()));
                    IHeaderObject ho = (IHeaderObject)headerInfo.getHeaderObjects().get(1);
                    if (ho == null) continue;
                    cells.add(new OneCell(1, colStart + i, (Object)ho.getName()));
                }
            } else {
                for (i = 0; i < colHeaders.size(); ++i) {
                    headerInfo = (IHeaderInfo)colHeaders.get(i);
                    cells.add(new OneCell(i, colStart - 1, (Object)headerInfo.getName()));
                    headerObjects = headerInfo.getHeaderObjects();
                    if (headerObjects == null || headerObjects.isEmpty()) continue;
                    for (j = 0; j < headerObjects.size(); ++j) {
                        headerObject = (IHeaderObject)headerObjects.get(j);
                        if (headerObject == null) continue;
                        cells.add(new OneCell(i, colStart + j, (Object)headerObject.getName()));
                    }
                }
            }
            if (!cells.isEmpty()) {
                this.getColSpreadContainer().updateCellValue2(cells);
            }
        }
    }

    protected void refreshHeaderDisplays(IDataAreaSetting dataAreaSetting) {
        if (dataAreaSetting != null) {
            List floatInfos = dataAreaSetting.getFloatInfos();
            HashMap<Integer, IFloatInfo> rowFloats = new HashMap<Integer, IFloatInfo>(16);
            HashMap<Integer, IFloatInfo> colFloats = new HashMap<Integer, IFloatInfo>(16);
            if (floatInfos != null) {
                for (IFloatInfo floatInfo : floatInfos) {
                    if (floatInfo.getRow_offset() >= 0) {
                        rowFloats.put(floatInfo.getRow_offset(), floatInfo);
                        continue;
                    }
                    if (floatInfo.getCol_offset() < 0) continue;
                    colFloats.put(floatInfo.getCol_offset(), floatInfo);
                }
            }
            HashMap<String, IPageDimensionEntry> scopesMap = new HashMap(16);
            if (dataAreaSetting.getRelationAreaInfo() != null) {
                scopesMap = dataAreaSetting.getRelationAreaInfo().getMemberScopes();
            }
            this.refreshHeaderDisplays(dataAreaSetting.getRowHeaders(), rowFloats, scopesMap);
            this.refreshHeaderDisplays(dataAreaSetting.getColHeaders(), colFloats, scopesMap);
            this.refreshMemberProperties(dataAreaSetting.getRowHeaders());
            this.refreshMemberProperties(dataAreaSetting.getColHeaders());
        }
    }

    protected void refreshMemberProperties(List<IHeaderInfo> headerInfos) {
        if (CollectionUtils.isNotEmpty(headerInfos)) {
            HashMap<String, Map<String, IHeaderInfo>> propHeadersMap = new HashMap<String, Map<String, IHeaderInfo>>(16);
            HashMap memIndexes = new HashMap(16);
            HashSet<String> dimsWithProp = new HashSet<String>(16);
            LinkedList<IHeaderInfo> dimHeaders = new LinkedList<IHeaderInfo>();
            for (IHeaderInfo headerInfo : headerInfos) {
                if ("Property".equals(headerInfo.getType()) && headerInfo.getRefDimension() != null) {
                    dimsWithProp.add(headerInfo.getRefDimension());
                    Map ph = propHeadersMap.computeIfAbsent(headerInfo.getRefDimension(), f -> new HashMap());
                    ph.put(headerInfo.getNumber(), headerInfo);
                    continue;
                }
                if (!headerInfo.isDimension()) continue;
                dimHeaders.add(headerInfo);
                List headerObjects = headerInfo.getHeaderObjects();
                HashSet<Integer> indexes = new HashSet<Integer>(16);
                for (int i = 0; i < headerObjects.size(); ++i) {
                    if (headerObjects.get(i) == null) continue;
                    indexes.add(i);
                }
                memIndexes.put(headerInfo.getNumber(), indexes);
            }
            dimHeaders.removeIf(e -> !dimsWithProp.contains(e.getNumber()));
            for (IHeaderInfo headerInfo : dimHeaders) {
                this.updateMemProps(headerInfo, (Set)memIndexes.get(headerInfo.getNumber()), propHeadersMap);
            }
        }
    }

    protected void updateMemProps(IHeaderInfo dimHeader, Set<Integer> indexes, Map<String, Map<String, IHeaderInfo>> propHeadersMap) {
        if (dimHeader == null || CollectionUtils.isEmpty(indexes) || MapUtils.isEmpty(propHeadersMap) || !propHeadersMap.containsKey(dimHeader.getNumber())) {
            return;
        }
        String dimNumber = dimHeader.getNumber();
        List headerObjects = dimHeader.getHeaderObjects();
        HashSet viewMemNumbers = new HashSet(16);
        indexes.forEach(i -> {
            IHeaderObject ho = (IHeaderObject)headerObjects.get((int)i);
            if (ho != null && ho.getNumber() != null) {
                viewMemNumbers.add(Pair.onePair((Object)ho.getViewNumber(), (Object)ho.getNumber()));
            }
        });
        Map memPropValues = this.getTemplateMemberService().getMemberPropValues(dimNumber, viewMemNumbers);
        Map<String, IHeaderInfo> ph = propHeadersMap.get(dimNumber);
        for (Integer i2 : indexes) {
            IHeaderObject ho = (IHeaderObject)headerObjects.get(i2);
            if (ho == null) {
                ph.forEach((k, v) -> v.getHeaderObjects().set(i2, null));
                continue;
            }
            Map propValues = (Map)memPropValues.get(ho.getNumber());
            if (propValues != null) {
                for (Map.Entry<String, IHeaderInfo> entry : ph.entrySet()) {
                    String propNum = entry.getKey();
                    IHeaderInfo propHeader = entry.getValue();
                    if (propValues.containsKey(propNum)) {
                        propHeader.getHeaderObjects().set(i2, new HeaderObject(false, propNum, (String)propValues.get(propNum), QuoteTypeEnum.PROPERTY.getValue()));
                        continue;
                    }
                    propHeader.getHeaderObjects().set(i2, null);
                }
                continue;
            }
            ph.forEach((k, v) -> v.getHeaderObjects().set(i2, null));
        }
    }

    protected void refreshHeaderDisplays(List<IHeaderInfo> headerInfos, Map<Integer, IFloatInfo> rowFloats, Map<String, IPageDimensionEntry> scopesMap) {
        String dimNumber = null;
        Object propNumber = null;
        for (int i = 0; i < headerInfos.size(); ++i) {
            FieldBean fieldBean;
            IHeaderInfo info = headerInfos.get(i);
            if (info == null) continue;
            if ("Dimension".equals(info.getType())) {
                dimNumber = info.getNumber();
                IDimension dimension = this.getDimByNumber(dimNumber);
                if (dimension == null) continue;
                info.setName(dimension.getName());
                if (CollectionUtils.isEmpty((Collection)info.getHeaderObjects())) continue;
                for (int j = 0; j < info.getHeaderObjects().size(); ++j) {
                    IRowColPartition partition;
                    IHeaderObject headerObject = (IHeaderObject)info.getHeaderObjects().get(j);
                    if (headerObject == null || StringUtils.isNotEmpty((String)headerObject.getName())) continue;
                    if (!headerObject.isFloat()) {
                        IBaseEntry member = this.getTemplateMemberService().getMemberEntry(QuoteTypeEnum.getByValule((String)headerObject.getType()), dimNumber, headerObject.getNumber(), (Object)headerObject.getViewNumber());
                        if (member == null) continue;
                        headerObject.setName(member.getName());
                        continue;
                    }
                    IFloatInfo floatInfo = rowFloats.get(j);
                    if (floatInfo == null || (partition = floatInfo.getPartition()) == null) continue;
                    for (IRowColDimensionEntry dimensionEntry : partition.getRowColDimensionEntries()) {
                        if (dimensionEntry.getDimension() == null || !dimensionEntry.getDimension().getNumber().equals(dimNumber)) continue;
                        headerObject.setName(this.getMembShowInfo(dimNumber, dimensionEntry));
                    }
                }
                continue;
            }
            if (StringUtils.isEmpty((String)info.getName()) && "Property".equals(info.getType()) && info.getNumber() != null && info.getRefDimension() != null) {
                PropertyEntry prop = this.getPropertyByNumber(info.getNumber());
                if (prop == null) continue;
                info.setName(prop.getName());
                continue;
            }
            if (!"RelField".equals(info.getType()) || info.getNumber() == null || (fieldBean = this.getRelaFieldMap().get(info.getNumber())) == null) continue;
            info.setName(fieldBean.getName());
            if (fieldBean.getDimension() == null || !scopesMap.containsKey(fieldBean.getNumber())) continue;
            IPageDimensionEntry pe = scopesMap.get(fieldBean.getNumber());
            HeaderObject ho = new HeaderObject(false, fieldBean.getNumber(), this.getMembShowInfo(fieldBean.getDimension().getNumber(), pe), QuoteTypeEnum.FIELD.getValue());
            ho.setViewId(pe.getViewId());
            ho.setNumber(pe.getViewNumber());
            info.getHeaderObjects().set(1, ho);
        }
    }

    protected void refreshHeaderDisplays() {
        IDataAreaSetting multiAreaSetting = this.getMultiAreaSetting();
        if (multiAreaSetting != null) {
            this.refreshHeaderDisplays(multiAreaSetting);
        }
    }

    protected void setCellF7Style(IDataAreaSetting multiAreaSetting) {
        if (multiAreaSetting != null) {
            CellArea dataCellArea = new CellArea(multiAreaSetting.getAreaRange());
            CellArea[] rowColSpreadArea = this.getRowColSpreadArea();
            RelationAreaInfo relationAreaInfo = multiAreaSetting.getRelationAreaInfo();
            if (relationAreaInfo != null) {
                this.getColSpreadContainer().lockCells(Collections.singletonList(rowColSpreadArea[1]));
                int colIndex = dataCellArea.getC();
                LinkedList<CellArea> floatCellAreas = new LinkedList<CellArea>();
                for (String col : relationAreaInfo.getCols()) {
                    FieldBean fb = this.getRelaFieldMap().get(col);
                    if (fb != null && fb.getTypeEnum() != RelationTypeEnum.NOTHING) {
                        floatCellAreas.add(new CellArea(1, colIndex, 1, 1));
                    }
                    ++colIndex;
                }
                this.getColSpreadContainer().setFListCellArea(floatCellAreas, false, false);
                this.getColSpreadContainer().unlockCells(floatCellAreas);
            } else {
                CellArea rowF7CellArea = new CellArea(dataCellArea.getR(), 0, dataCellArea.getRc(), multiAreaSetting.getRowHeaders().size());
                CellArea colF7CellArea = new CellArea(0, dataCellArea.getC(), multiAreaSetting.getColHeaders().size(), dataCellArea.getCc());
                this.setCellF7Style(this.getRowSpreadContainer(), rowF7CellArea);
                this.setCellF7Style(this.getColSpreadContainer(), colF7CellArea);
                this.setFloatCellStyle(multiAreaSetting, dataCellArea);
                this.getRowSpreadContainer().lockCells(Collections.singletonList(rowColSpreadArea[0]));
                this.getRowSpreadContainer().unlockCells(Collections.singletonList(rowF7CellArea));
                this.getColSpreadContainer().lockCells(Collections.singletonList(rowColSpreadArea[1]));
                this.getColSpreadContainer().unlockCells(Collections.singletonList(colF7CellArea));
            }
        }
    }

    protected void setFloatCellStyle(IDataAreaSetting multiAreaSetting, CellArea dataCellArea) {
        if (multiAreaSetting.getFloatInfos() != null) {
            AreasStyle areasStyle = new AreasStyle();
            areasStyle.setStyle(new CellStyleInfo().ofBkc(BACKCOLOR_FLOATCELL));
            LinkedList<CellArea> rowFloatCellAreas = new LinkedList<CellArea>();
            LinkedList<CellArea> colFloatCellAreas = new LinkedList<CellArea>();
            for (IFloatInfo floatInfo : multiAreaSetting.getFloatInfos()) {
                if (floatInfo.getRow_offset() > -1 && floatInfo.getRowEnd_offset() > -1) {
                    int rowStart = dataCellArea.getR() + floatInfo.getRow_offset();
                    int rowCount = floatInfo.getRowEnd_offset() - floatInfo.getRow_offset() + 1;
                    rowFloatCellAreas.add(new CellArea(rowStart, 0, rowCount, multiAreaSetting.getRowHeaders().size()));
                    continue;
                }
                if (floatInfo.getCol_offset() <= -1 || floatInfo.getColEnd_offset() <= -1) continue;
                int colStart = dataCellArea.getC() + floatInfo.getCol_offset();
                int colCount = floatInfo.getColEnd_offset() - floatInfo.getCol_offset() + 1;
                colFloatCellAreas.add(new CellArea(0, colStart, multiAreaSetting.getColHeaders().size(), colCount));
            }
            if (!rowFloatCellAreas.isEmpty()) {
                areasStyle.setRange(rowFloatCellAreas);
                this.getRowSpreadContainer().setCellStyle(Collections.singletonList(areasStyle));
            }
            if (!colFloatCellAreas.isEmpty()) {
                areasStyle.setRange(colFloatCellAreas);
                this.getColSpreadContainer().setCellStyle(Collections.singletonList(areasStyle));
            }
        }
    }

    protected void setCellF7Style(ISpreadContainer spreadContainer, CellArea cellArea, boolean clearData) {
        if (spreadContainer != null && cellArea != null) {
            AreasStyle areasStyle = new AreasStyle();
            areasStyle.setRange(Collections.singletonList(cellArea));
            areasStyle.setStyle(new CellStyleInfo().ofBkc(BACKCOLOR_F7CELL));
            spreadContainer.setCellStyle(Collections.singletonList(areasStyle));
            spreadContainer.setFListCellArea(cellArea.split(), true, false);
            if (clearData) {
                spreadContainer.updateCellValue2(cellArea.splitToCells());
            }
        }
    }

    protected void setCellF7Style(ISpreadContainer spreadContainer, CellArea cellArea) {
        this.setCellF7Style(spreadContainer, cellArea, true);
    }

    public IDataAreaSetting defaultMultiAreaSetting(String selectorArea, ITemplateModel templateModel) {
        IDataAreaSetting multiAreaSetting = null;
        if (StringUtils.isNotEmpty((String)selectorArea) && templateModel != null) {
            multiAreaSetting = this.isRelation() ? this.defaultAreaSetting(selectorArea, this.getCurrentBizModelId()) : this.defaultAreaSetting(selectorArea, templateModel);
            this.getSheetManager().addAreaRange(multiAreaSetting);
            this.cacheSheetManager();
        }
        return multiAreaSetting;
    }

    protected IDataAreaSetting defaultAreaSetting(String selectorArea, Long relModelId) {
        DataAreaSetting areaSetting = new DataAreaSetting();
        areaSetting.setAreaRange(selectorArea);
        int colCount = new CellArea(selectorArea).getCc();
        RelationModelBean modelBean = this.getRelationModelBean(relModelId);
        areaSetting.setRelationAreaInfo(new RelationAreaInfo(modelBean.getNumber()));
        if (CollectionUtils.isNotEmpty((Collection)modelBean.getColFields())) {
            int colIndex = 0;
            Map fm = modelBean.getFieldBeanMap();
            for (String fieldNumber : modelBean.getColFields()) {
                if (RelationTypeEnum.BASICDATA == ((FieldBean)fm.get(fieldNumber)).getTypeEnum()) continue;
                if (colIndex >= colCount) break;
                RelationDimBean rd = ((FieldBean)fm.get(fieldNumber)).getDimension();
                areaSetting.getColHeaders().add(new HeaderInfo("RelField", fieldNumber, rd != null ? rd.getNumber() : null));
                areaSetting.getRelationAreaInfo().getCols().add(fieldNumber);
                ++colIndex;
            }
        }
        areaSetting.refresh();
        return areaSetting;
    }

    @NotNull
    private IDataAreaSetting defaultAreaSetting(String selectorArea, ITemplateModel templateModel) {
        DataAreaSetting multiAreaSetting = new DataAreaSetting();
        multiAreaSetting.setAreaRange(selectorArea);
        List areaSettings = this.getSheetManager().getAreaRanges().stream().filter(e -> !e.isRelation()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(areaSettings)) {
            IDataAreaSetting copySetting = (IDataAreaSetting)areaSettings.get(areaSettings.size() - 1);
            ArrayList rowHeaders = new ArrayList(16);
            ArrayList colHeaders = new ArrayList(16);
            copySetting.getRowHeaders().forEach(h -> rowHeaders.add(new HeaderInfo(h.getId(), h.getNumber(), h.getName(), h.getType(), h.getRefDimension())));
            copySetting.getColHeaders().forEach(h -> colHeaders.add(new HeaderInfo(h.getId(), h.getNumber(), h.getName(), h.getType(), h.getRefDimension())));
            multiAreaSetting.setRowdims((List)Lists.newArrayList((Iterable)copySetting.getRowdims()));
            multiAreaSetting.setColdims((List)Lists.newArrayList((Iterable)copySetting.getColdims()));
            multiAreaSetting.setRowHeaders(rowHeaders);
            multiAreaSetting.setColHeaders(colHeaders);
            if (CollectionUtils.isNotEmpty((Collection)copySetting.getAreaViewpointmembentry())) {
                multiAreaSetting.getAreaViewpointmembentry().addAll(copySetting.getAreaViewpointmembentry());
            }
        } else {
            List rowColDims = templateModel.getRowcolDims();
            int size = rowColDims.size();
            if (rowColDims != null && size > 1) {
                ArrayList rowDims = Lists.newArrayListWithExpectedSize((int)1);
                ArrayList rowHeaders = Lists.newArrayListWithExpectedSize((int)1);
                ArrayList colDims = Lists.newArrayListWithExpectedSize((int)(size - 1));
                ArrayList colHeaders = Lists.newArrayListWithExpectedSize((int)(size - 1));
                for (int i = 0; i < size; ++i) {
                    String dimNumber = (String)rowColDims.get(i);
                    HeaderInfo headerInfo = new HeaderInfo("Dimension", dimNumber);
                    if (i == 0) {
                        rowDims.add(dimNumber);
                        rowHeaders.add(headerInfo);
                        continue;
                    }
                    colDims.add(dimNumber);
                    colHeaders.add(headerInfo);
                }
                multiAreaSetting.setRowdims((List)rowDims);
                multiAreaSetting.setRowHeaders((List)rowHeaders);
                multiAreaSetting.setColdims((List)colDims);
                multiAreaSetting.setColHeaders((List)colHeaders);
            }
        }
        return multiAreaSetting;
    }

    protected IDataAreaSetting buildFromRowColDimsPanel() {
        IDataAreaSetting old = this.getMultiAreaSetting();
        DataAreaSetting areaSetting = new DataAreaSetting();
        areaSetting.setAreaRange(this.getActiveDataArea());
        ArrayList<String> rowDims = new ArrayList<String>(16);
        ArrayList<String> colDims = new ArrayList<String>(16);
        ArrayList<IHeaderInfo> rowHeaders = new ArrayList<IHeaderInfo>(16);
        ArrayList<IHeaderInfo> colHeaders = new ArrayList<IHeaderInfo>(16);
        if (this.isRelation()) {
            this.addDimsAndHeaders(colDims, colHeaders, false);
            areaSetting.setColdims(colDims);
            areaSetting.setColHeaders(colHeaders);
            RelationAreaInfo ri = old.getRelationAreaInfo();
            if (ri != null) {
                ri.setCols(colDims);
                ri.getMemberScopes().entrySet().removeIf(e -> !colDims.contains(e.getKey()));
            }
            areaSetting.setRelationAreaInfo(ri);
            areaSetting.refresh();
        } else {
            this.addDimsAndHeaders(rowDims, rowHeaders, true);
            this.addDimsAndHeaders(colDims, colHeaders, false);
            areaSetting.setRowdims(rowDims);
            areaSetting.setColdims(colDims);
            areaSetting.setRowHeaders(rowHeaders);
            areaSetting.setColHeaders(colHeaders);
            List<IViewPointDimensionEntry> areaViewPoints = this.getAreaViewPoints();
            if (areaViewPoints != null && !areaViewPoints.isEmpty()) {
                areaSetting.getAreaViewpointmembentry().addAll(areaViewPoints);
            }
            if (old != null) {
                CellArea cellArea = new CellArea(areaSetting.getAreaRange());
                int rowCount = cellArea.getRc();
                int colCount = cellArea.getCc();
                Map<String, IHeaderInfo> oldHeadersWithFixMembers = this.getHeaderInfoMap(old, "Dimension", true);
                Map<String, IHeaderInfo> newHeaders = this.getHeaderInfoMap((IDataAreaSetting)areaSetting, "Dimension", false);
                if (!old.getFloatInfos().isEmpty()) {
                    List oldRows = old.getRowdims();
                    List oldCols = old.getColdims();
                    List newRows = areaSetting.getRowdims();
                    List newCols = areaSetting.getColdims();
                    boolean sameRowDims = oldRows.equals(newRows);
                    boolean sameColDims = oldCols.equals(newCols);
                    if (old.getFloatOnWhere() == FloatTypeEnum.ROW && sameRowDims || old.getFloatOnWhere() == FloatTypeEnum.COL && sameColDims || old.getFloatOnWhere() == FloatTypeEnum.ROWCOL && sameRowDims && sameColDims) {
                        areaSetting.setFloatInfos(old.getFloatInfos());
                        areaSetting.setFloatOnWhere(old.getFloatOnWhere());
                    } else {
                        boolean canSwitchRowDims = oldRows.size() == newRows.size() && oldRows.containsAll(newRows);
                        boolean canSwitchColDims = oldCols.size() == newCols.size() && oldCols.containsAll(newCols);
                        ArrayList<IFloatInfo> invalidFloatInfos = new ArrayList<IFloatInfo>(16);
                        for (IFloatInfo floatInfo : old.getFloatInfos()) {
                            int i;
                            IRowColPartition partition = floatInfo.getPartition();
                            List entries = partition.getRowColDimensionEntries();
                            HashMap entryMap = new HashMap(16);
                            entries.forEach(e -> entryMap.put(e.getDimension().getNumber(), e));
                            if (floatInfo.getRow_offset() > -1) {
                                if (canSwitchRowDims && entryMap.keySet().containsAll(newRows)) {
                                    for (i = 0; i < newRows.size(); ++i) {
                                        entries.set(i, entryMap.get(newRows.get(i)));
                                    }
                                    continue;
                                }
                                invalidFloatInfos.add(floatInfo);
                                continue;
                            }
                            if (floatInfo.getCol_offset() <= -1) continue;
                            if (canSwitchColDims && entryMap.keySet().containsAll(newCols)) {
                                for (i = 0; i < newCols.size(); ++i) {
                                    entries.set(i, entryMap.get(newCols.get(i)));
                                }
                                continue;
                            }
                            invalidFloatInfos.add(floatInfo);
                        }
                        if (!invalidFloatInfos.isEmpty()) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u6709\u6d6e\u52a8\u8bbe\u7f6e\u4e2d\u7684\u7ef4\u5ea6\u4e0e\u5f53\u524d\u7ef4\u5ea6\u4e0d\u5339\u914d\u3002", (String)"AbstractTemplateProcessPlugin_9", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                        }
                        areaSetting.setFloatInfos(old.getFloatInfos());
                        areaSetting.setFloatOnWhere(old.getFloatOnWhere());
                    }
                    areaSetting.refresh();
                }
                for (Map.Entry<String, IHeaderInfo> entry : oldHeadersWithFixMembers.entrySet()) {
                    int i;
                    int size;
                    IHeaderInfo headerInfo;
                    List headerObjects;
                    String dimNumber = entry.getKey();
                    if (!newHeaders.containsKey(dimNumber) || (headerObjects = (headerInfo = entry.getValue()).getHeaderObjects()) == null || (size = headerObjects.size()) <= 0) continue;
                    if (areaSetting.getRowdims().contains(headerInfo.getNumber()) && size >= rowCount) {
                        SPArrayList tempList = new SPArrayList(rowCount);
                        for (i = 0; i < rowCount; ++i) {
                            tempList.set(i, headerObjects.get(i));
                        }
                        headerObjects = tempList;
                    } else if (areaSetting.getColdims().contains(headerInfo.getNumber()) && size >= colCount) {
                        SPArrayList tempList = new SPArrayList(colCount);
                        for (i = 0; i < colCount; ++i) {
                            tempList.set(i, headerObjects.get(i));
                        }
                        headerObjects = tempList;
                    }
                    newHeaders.get(dimNumber).setHeaderObjects(headerObjects);
                }
            }
        }
        this.getSheetManager().replaceAreaRange(old, (IDataAreaSetting)areaSetting);
        this.cacheSheetManager();
        return areaSetting;
    }

    protected void syncSettingFromPanel() {
        IDataAreaSetting afterSync = this.buildFromRowColDimsPanel();
        if (afterSync != null && Boolean.TRUE.toString().equals(this.getPageCache().get("needRepaint"))) {
            this.getSpreadContainer().getSpreadJson("showAreaSetting");
        }
    }

    protected void needRepaint() {
        this.getPageCache().put("needRepaint", Boolean.TRUE.toString());
        this.setDataChanged(true);
    }

    protected List<IViewPointDimensionEntry> getAreaViewPoints() {
        ArrayList<IViewPointDimensionEntry> avps = new ArrayList<IViewPointDimensionEntry>(16);
        for (String view : this.getViewEntry()) {
            IDimension dim = this.getDimByNumber(this.getNumberMap().get(view));
            DefaultViewPointDimensionEntry viewPointDimensionEntry = new DefaultViewPointDimensionEntry();
            viewPointDimensionEntry.setDimension(dim);
            Map<String, String> value = this.getDynamicPageHelper().getDimMemberValueMap(this.reverseConvertSign(AREAVIEWPANEL, view));
            if (MapUtils.isNotEmpty(value)) {
                IDimensionMember member = this.getDynamicPageHelper().buildDimensionMember(value);
                member.setViewNumber(this.getViewNumber(member.getViewId()));
                viewPointDimensionEntry.setMember(member);
            }
            avps.add((IViewPointDimensionEntry)viewPointDimensionEntry);
        }
        return avps;
    }

    protected void addDimsAndHeaders(List<String> dimNumbers, List<IHeaderInfo> headerInfos, boolean isRow) {
        if (dimNumbers == null || headerInfos == null) {
            return;
        }
        List<String> rowCols = this.getRowColEntry(isRow);
        for (String rowcol : rowCols) {
            HeaderInfo headerInfo;
            QuoteTypeEnum type = this.getSignType(rowcol);
            if (type == QuoteTypeEnum.PROPERTY) {
                PropertyEntry propertyEntry = this.getPropertyByNumber(this.getNumberMap().get(rowcol));
                if (propertyEntry == null) continue;
                headerInfo = new HeaderInfo(propertyEntry.getId(), propertyEntry.getNumber(), propertyEntry.getName(), "Property", propertyEntry.getRefDimNumber());
            } else if (type == QuoteTypeEnum.MEMBER) {
                IDimension dim = this.getDimByNumber(this.getNumberMap().get(rowcol));
                if (dim == null) continue;
                dimNumbers.add(dim.getNumber());
                headerInfo = new HeaderInfo(dim.getId(), dim.getNumber(), dim.getName(), "Dimension", "");
            } else {
                FieldBean field = this.getRelaFieldMap().get(this.getNumberMap().get(rowcol));
                if (field == null) continue;
                dimNumbers.add(field.getNumber());
                RelationDimBean rd = field.getDimension();
                headerInfo = new HeaderInfo(Long.valueOf(field.getId()), field.getNumber(), field.getName(), "RelField", rd != null ? rd.getNumber() : null);
            }
            headerInfos.add((IHeaderInfo)headerInfo);
        }
    }

    public abstract ITemplateMemberService getTemplateMemberService();

    protected Long getBizModelId() {
        return IDUtils.toLong((Object)this.getTemplateModel().getBizModelId());
    }

    protected List<IDimension> getAllDims() {
        return this.getTemplateMemberService().getAllDims(this.getBizModelId());
    }

    protected List<IDimension> getAllDimsCache() {
        if (CollectionUtils.isEmpty(this.allDims)) {
            String seria = this.getPageCache().get(ALLDIMS_KEY);
            if (StringUtils.isNotEmpty((String)seria)) {
                this.allDims = (List)ObjectSerialUtil.deSerializedBytes((String)seria);
            } else {
                this.allDims = this.getAllDims();
                this.getPageCache().put(ALLDIMS_KEY, ObjectSerialUtil.toByteSerialized(this.allDims));
            }
        }
        return this.allDims;
    }

    protected <T extends IBaseEntry> T getEntryByNumber(String number, List<T> entry) {
        if (StringUtils.isEmpty((String)number) || CollectionUtils.isEmpty(entry)) {
            return null;
        }
        return (T)entry.stream().filter(e -> number.equals(e.getNumber())).findFirst().orElseGet(() -> null);
    }

    protected IDimension getDimByNumber(String dimNumber) {
        IDimension dimension = this.getTemplateMemberService().getDimension(dimNumber);
        return dimension;
    }

    protected String getPropertyEntity() {
        return this.getTemplateMemberService().getPropertyEntity();
    }

    protected List<PropertyEntry> getAllPropertys() {
        return this.getTemplateMemberService().getAllPropertys(this.getBizModelId(), null);
    }

    protected List<PropertyEntry> getAllPropertysCache() {
        if (CollectionUtils.isEmpty(this.allPropertys)) {
            String seria = this.getPageCache().get(ALLPROPERTYS_KEY);
            if (StringUtils.isNotEmpty((String)seria)) {
                this.allPropertys = (List)ObjectSerialUtil.deSerializedBytes((String)seria);
            } else {
                this.allPropertys = this.getAllPropertys();
                this.getPageCache().put(ALLPROPERTYS_KEY, ObjectSerialUtil.toByteSerialized(this.allPropertys));
            }
        }
        return this.allPropertys;
    }

    protected PropertyEntry getPropertyByNumber(String propNumber) {
        return this.getEntryByNumber(propNumber, this.getAllPropertysCache());
    }

    protected void defaultRowColSpreads(ISpreadContainer spreadContainer) {
        if (spreadContainer != null) {
            spreadContainer.hideContextMenuItems((List)Lists.newArrayList((Object[])new ContextMenuItemsEnum[]{ContextMenuItemsEnum.CUT, ContextMenuItemsEnum.CLEARCONTENTS, ContextMenuItemsEnum.PASTEOPTIONS, ContextMenuItemsEnum.FILTER, ContextMenuItemsEnum.SORT, ContextMenuItemsEnum.INSERTCOMMENT, ContextMenuItemsEnum.RICHTEXT, ContextMenuItemsEnum.CELLSFORMAT, ContextMenuItemsEnum.SETROWSHEIGHTVIEW, ContextMenuItemsEnum.SETCOLSWIDTHVIEW, ContextMenuItemsEnum.INSERTROWS, ContextMenuItemsEnum.INSERTCOLUMNS, ContextMenuItemsEnum.DELETEROWS, ContextMenuItemsEnum.DELETECOLUMNS, ContextMenuItemsEnum.HIDEROWS, ContextMenuItemsEnum.HIDECOLUMNS, ContextMenuItemsEnum.UNHIDEROWS, ContextMenuItemsEnum.UNHIDECOLUMNS, ContextMenuItemsEnum.INSERTROWMANY, ContextMenuItemsEnum.INSERTCOLUMNMANY, ContextMenuItemsEnum.INSERTROWORCOLUMNS, ContextMenuItemsEnum.DELETEROWORCOLUMNS, ContextMenuItemsEnum.PASTEFORMULA, ContextMenuItemsEnum.PASTEFORMULAFORMATTING, ContextMenuItemsEnum.CELLSFORMAT, ContextMenuItemsEnum.PASTEVALUESFORMATTING, ContextMenuItemsEnum.PASTEFORMATTING, ContextMenuItemsEnum.COPY, ContextMenuItemsEnum.PASTE, ContextMenuItemsEnum.PASTEALL, ContextMenuItemsEnum.PASTEVALUES}), null);
            spreadContainer.setToolbarExpandBtnVisible(Boolean.FALSE);
            spreadContainer.setStatusBarVisible(Boolean.FALSE);
            spreadContainer.setWorkbookOptions(new WorkbookOptions().ofShowVerticalScrollbar(Boolean.FALSE).ofShowHorizontalScrollbar(Boolean.FALSE).ofClipBoardOptions(Integer.valueOf(1)));
        }
    }

    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        if ("drop".equals(name)) {
            String eventArgs = e.getEventArgs();
            this.dealElementDrop(eventArgs);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Pair result;
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        Object returndata = closedCallBackEvent.getReturnData();
        switch (key) {
            case "btn_dimsetting": {
                Map returnData;
                String templateModelStr;
                String returnDataStr;
                if (closedCallBackEvent.getReturnData() == null || (returnDataStr = (String)closedCallBackEvent.getReturnData()) == null || (templateModelStr = (String)(returnData = (Map)SerializationUtils.fromJsonString((String)returnDataStr, Map.class)).get(TEMPLATEMODEL)) == null) break;
                this.templateModel = (ITemplateModel)this.deSerializedBytes(templateModelStr);
                this.cacheSheetManager(this.templateModel.getSheetManager());
                this.cacheTemplateModel();
                this.setDataChanged(true);
                break;
            }
            case "btn_floatsetting": {
                if (closedCallBackEvent.getReturnData() instanceof String) {
                    SpreadEasyInvoker invoker = new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey());
                    IDataAreaSetting oldMul = this.getMultiAreaSetting();
                    MarkSpecialCellHelper.markSpecialCells(invoker, oldMul, false);
                    IDataAreaSetting newAreaSet = (IDataAreaSetting)this.deSerializedBytes((String)closedCallBackEvent.getReturnData());
                    if (newAreaSet != null) {
                        this.refreshRowColSpreads(newAreaSet);
                        MarkSpecialCellHelper.markSpecialCells(invoker, newAreaSet, true);
                        newAreaSet.setSequenceInfos(oldMul.getSequenceInfos());
                    }
                    this.getSheetManager().replaceAreaRange(oldMul, newAreaSet);
                    this.cacheSheetManager();
                    this.setDataChanged(true);
                }
                this.setOnFloatSetting(null);
                this.controlSpreadAndBtn(ON_FLOAT_SETTING, false);
                break;
            }
            case "btn_baseinfo": {
                this.updateTemplateBaseInfo(returndata);
                break;
            }
            case "CALLBACK_SELECTAREA": 
            case "CALLBACK_SELECTAREA_WITHBIZMODEL": {
                if (TRUE.equals(this.getPageCache().get(SELECT_AREA)) && TRUE.equals(this.getPageCache().get("verifyArea"))) {
                    this.getPageCache().remove(SELECT_AREA);
                    this.getPageCache().remove("verifyArea");
                    if (CALLBACK_SELECTAREA_WITHBIZMODEL.equals(key) && !(returndata instanceof Long)) {
                        this.controlSpreadAndBtn(SELECT_AREA, false);
                        return;
                    }
                    this.clearDimsPanelCache();
                    this.setDataChanged(true);
                    if (this.getTemplateType() == TemplateTypeEnum.FIX) {
                        if (returndata instanceof Long) {
                            this.setCurrentBizModel((Long)returndata);
                        } else {
                            this.setCurrentBizModel(this.getBizModelId());
                        }
                        this.getSpreadContainer().getSpreadJson("showAreaSetting");
                    } else if (this.getTemplateType() == TemplateTypeEnum.DYNAMIC) {
                        IDataAreaSetting defaulted = this.defaultMultiAreaSetting(this.getActiveDataArea(), this.getTemplateModel());
                        this.showAreaSetting(null, defaulted, false);
                    }
                }
                this.controlSpreadAndBtn(SELECT_AREA, false);
                break;
            }
            case "callBack4SeqSetting": {
                this.controlSpreadAndBtn(VIEW_DEFAULT, false);
                break;
            }
            case "rowCellF7": 
            case "colCellF7": {
                this.handleCellF7ReturnValues(closedCallBackEvent);
                break;
            }
            case "CALLBACK_ROWPROPERTYSETTING": {
                this.propertySettingCallBack(closedCallBackEvent, true);
                break;
            }
            case "CALLBACK_COLPROPERTYSETTING": {
                this.propertySettingCallBack(closedCallBackEvent, false);
                break;
            }
            case "CALLBACK_SETCOLFIELDS": {
                this.colFieldsSettingCallBak(closedCallBackEvent);
                break;
            }
            case "spreadF7Click_rela": {
                this.spreadF7ClickCallBack_Rela(closedCallBackEvent);
                break;
            }
        }
        if (this.checkControlKey(key) && null != (result = this.getTemplateMemberService().f7ClosedCallBack(key, returndata))) {
            this.getDynamicPageHelper().putDimMemberValueAndUpdateAllPoint(key, CollectionUtils.isNotEmpty((Collection)((Collection)result.p2)) ? ((List)result.p2).get(0) : Maps.newHashMap(), (String)result.p1);
            this.needRepaint();
            this.syncSettingFromPanel();
        }
    }

    protected void spreadF7ClickCallBack_Rela(ClosedCallBackEvent evt) {
        if (evt.getReturnData() instanceof MultiF7Result) {
            MultiF7Result result = (MultiF7Result)evt.getReturnData();
            String fieldNumber = this.getSpreadF7SelectDimNumber();
            IDataAreaSetting areaSetting = this.getMultiAreaSetting();
            RelationAreaInfo ri = areaSetting.getRelationAreaInfo();
            if (StringUtils.isNotEmpty((String)fieldNumber) && ri != null) {
                if (!this.getRelaFieldMap().containsKey(fieldNumber)) {
                    return;
                }
                FieldBean fb = this.getRelaFieldMap().get(fieldNumber);
                DefaultPageDimensionEntry pe = new DefaultPageDimensionEntry();
                pe.setDimension((IDimension)new DefaultDimension(Long.valueOf(fb.getDimension().getId()), fb.getDimension().getName(), fb.getDimension().getNumber()));
                pe.setViewId(result.getViewId());
                pe.setViewNumber(result.getViewNumber());
                List selectedMembers = result.getSelectedMemberList();
                for (EpbsSelectedMember m : selectedMembers) {
                    pe.getMembers().add(new EmrDefaultDimMember(m.getId(), m.getName(), m.getNumber(), m.getScope(), Long.valueOf(m.getViewId()), m.getViewNumber(), m.getParentNumber()));
                }
                ri.getMemberScopes().put(fieldNumber, pe);
                this.setDataChanged(true);
                this.cacheSheetManager();
                SpreadSelector s = this.getSpreadF7Selector();
                if (s != null) {
                    this.getColSpreadContainer().updateCellValue2(Collections.singletonList(new OneCell(s.getStartRow(), s.getStartCol(), (Object)result.toString())));
                }
            }
        }
    }

    protected void setCurrentBizModel(Long id) {
        this.getModel().setValue(CURRENTBIZMODEL, (Object)id);
    }

    protected DynamicObject getCurrentBizModel() {
        return (DynamicObject)this.getModel().getValue(CURRENTBIZMODEL);
    }

    protected Long getCurrentBizModelId() {
        return (Long)this.getModel().getValue(CURRENTBIZMODEL_ID);
    }

    protected Long getBizDomainId() {
        Long bizDomainId = null;
        if (IDUtils.isNotNull((Long)this.getTemplateModel().getBizModelId())) {
            bizDomainId = this.getTemplateMemberService().getBizModel(this.getTemplateModel().getBizModelId()).getBizModelDomainId();
        } else {
            for (IDataAreaSetting areaSetting : this.getSheetManager().getAreaRanges()) {
                RelationModelBean rmb;
                if (areaSetting.getRelationAreaInfo() == null || (rmb = this.getTemplateMemberService().getRelationModel(areaSetting.getRelationAreaInfo().getRelationModel())) == null) continue;
                bizDomainId = rmb.getBizModelDomainId();
                break;
            }
        }
        return bizDomainId;
    }

    protected boolean isRelation() {
        DynamicObject bizModel = this.getCurrentBizModel();
        return bizModel != null && "2".equals(bizModel.getString("type"));
    }

    protected void colFieldsSettingCallBak(ClosedCallBackEvent closedCallBackEvent) {
        Object backData = closedCallBackEvent.getReturnData();
        if (backData instanceof ListSelectedRowCollection) {
            boolean isChange;
            ListSelectedRowCollection col = (ListSelectedRowCollection)backData;
            Map<String, String> numberMap = this.getNumberMap();
            Map<String, String> nameMap = this.getNameMap();
            ArrayList<String> newEntries = new ArrayList<String>();
            for (ListSelectedRow e : col) {
                String cacheKey = this.getItemCacheKey(e.getNumber(), QuoteTypeEnum.FIELD);
                newEntries.add(cacheKey);
                numberMap.put(cacheKey, e.getNumber());
                nameMap.put(this.getItemCacheKey(e.getName(), QuoteTypeEnum.FIELD), e.getName());
            }
            int colCount = new CellArea(this.getMultiAreaSetting().getAreaRange()).getCc();
            if (newEntries.size() > colCount) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bbe\u7f6e\u7684\u5b57\u6bb5\u6570\u91cf\u5e94\u5c0f\u4e8e\u6570\u636e\u533a\u57df\u5217\u6570\uff0c\u8bf7\u51cf\u5c11\u9009\u62e9\u7684\u5b57\u6bb5\u6216\u6269\u5927\u6570\u636e\u533a\u57df\u5217\u3002", (String)"AbstractTemplateProcessPlugin_10", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                return;
            }
            List<String> oldEntries = this.getRelationEntry();
            this.getPageCache().put(allname, SerializationUtils.toJsonString(nameMap));
            this.getPageCache().put(CACHE_ALL_NUMBER, SerializationUtils.toJsonString(numberMap));
            this.getPageCache().put(COL, SerializationUtils.toJsonString(newEntries));
            this.initDimsPanel(true);
            boolean bl = isChange = newEntries.size() != oldEntries.size() || !newEntries.containsAll(oldEntries);
            if (isChange) {
                this.needRepaint();
                MarkSpecialCellHelper.markSpecialCells(new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey()), this.getMultiAreaSetting(), false);
                this.syncSettingFromPanel();
            }
        }
    }

    protected void propertySettingCallBack(ClosedCallBackEvent closedCallBackEvent, boolean isRow) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (closedCallBackEvent.getReturnData() instanceof Map) {
            String areaCacheKey;
            Boolean isChange;
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            List selectedPropItems = (List)returnData.get("f7items");
            List dimsWithProps = (List)returnData.get("dims");
            IDataAreaSetting areaSetting = this.getMultiAreaSetting();
            if (areaSetting.hasFloat(isRow)) {
                List dimNumbers = isRow ? areaSetting.getRowdims() : areaSetting.getColdims();
                int[] reservedRowColSize = TemplateProcessHelper.getReservedHeaderSize(areaSetting);
                int checkHeaderSize = selectedPropItems.size() + dimNumbers.size();
                if (isRow && checkHeaderSize > reservedRowColSize[0]) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u884c\u5934\u4f4d\u7f6e\u672a\u9884\u7559\u8db3\u591f\uff0c\u4e0d\u80fd\u6dfb\u52a0\u65b0\u5c5e\u6027\u3002", (String)"AbstractTemplateProcessPlugin_11", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (!isRow && checkHeaderSize > reservedRowColSize[1]) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5217\u5934\u4f4d\u7f6e\u672a\u9884\u7559\u8db3\u591f\uff0c\u4e0d\u80fd\u6dfb\u52a0\u65b0\u5c5e\u6027\u3002", (String)"AbstractTemplateProcessPlugin_12", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if ((isChange = this.checkPropertyChange(areaCacheKey = this.getAreaCacheKey(), selectedPropItems, dimsWithProps)).booleanValue()) {
                this.needRepaint();
            }
            List<Object> allF7items = new ArrayList(16);
            allF7items = this.getF7itemsByDim(dimsWithProps, false);
            allF7items.addAll(selectedPropItems);
            List<String> rowcolList = this.getRowColEntry(isRow);
            this.removeProperty2RowcolList(allF7items, rowcolList, isRow);
            if (allF7items != null && allF7items.size() > 0) {
                String f7dimPropertyJson = SerializationUtils.toJsonString(allF7items);
                this.getPageCache().put(areaCacheKey, f7dimPropertyJson);
                Map<String, String> numberMap = this.getNumberMap();
                Map<String, String> nameMap = this.getNameMap();
                for (Map map : allF7items) {
                    this.addSelProperty2RowcolList(rowcolList, numberMap, nameMap, map);
                }
                this.getPageCache().put(allname, SerializationUtils.toJsonString(nameMap));
                this.getPageCache().put(CACHE_ALL_NUMBER, SerializationUtils.toJsonString(numberMap));
            } else {
                this.getPageCache().remove(areaCacheKey);
            }
            this.getPageCache().put(isRow ? ROW : COL, SerializationUtils.toJsonString(rowcolList));
            this.initDimsPanel(true);
            if (isChange.booleanValue()) {
                MarkSpecialCellHelper.markSpecialCells(new SpreadEasyInvoker(this.getClientViewProxy(), this.getSpreadKey()), areaSetting, false);
                this.syncSettingFromPanel();
            }
        }
    }

    private void addSelProperty2RowcolList(List<String> rowcolList, Map<String, String> numberMap, Map<String, String> nameMap, Map<String, String> f7item) {
        if (rowcolList == null || numberMap == null || nameMap == null || f7item == null) {
            return;
        }
        String f7itmNumber = f7item.get("number");
        String dimNum = f7item.get("dimnum");
        String sign = this.getPropertySign(f7itmNumber, dimNum);
        PropertyEntry propertyEntry = this.getPropertyByNumber(f7itmNumber);
        if (propertyEntry == null || dimNum == null) {
            return;
        }
        numberMap.put(sign, propertyEntry.getNumber());
        nameMap.put(sign, propertyEntry.getName());
        if (!rowcolList.contains(sign)) {
            int addIndex = -1;
            for (int i = 0; i < rowcolList.size(); ++i) {
                String rowcol = rowcolList.get(i);
                if (rowcol == null) continue;
                String rowcolNumber = numberMap.get(rowcol);
                PropertyEntry propertyEntryRow = this.getPropertyByNumber(rowcolNumber);
                if ((this.isProperty(rowcol) || !dimNum.equals(rowcolNumber)) && (!this.isProperty(rowcol) || propertyEntryRow == null || !dimNum.equals(propertyEntryRow.getRefDimNumber()))) continue;
                addIndex = i + 1;
            }
            if (addIndex > -1) {
                rowcolList.add(addIndex, sign);
                this.getDynamicPageHelper().putDimProperty(sign, f7item);
            }
        }
    }

    private void removeProperty2RowcolList(List<Map<String, String>> allF7items, List<String> rowcolList, boolean isRow) {
        if (allF7items == null || rowcolList == null) {
            return;
        }
        List<Map<String, String>> rangeDims = this.getRangeDim(isRow);
        List<Map<String, String>> selF7Items = this.getF7itemsByDim(rangeDims, true);
        HashSet<String> removePropertySigns = new HashSet<String>(16);
        Set allF7itemNumbers = allF7items.stream().map(e -> (String)e.get("number")).collect(Collectors.toSet());
        for (Map<String, String> selF7Item : selF7Items) {
            if (allF7itemNumbers.contains(selF7Item.get("number"))) continue;
            removePropertySigns.add(this.getPropertySign(selF7Item.get("number"), selF7Item.get("dimnum")));
        }
        rowcolList.removeIf(e -> this.isProperty((String)e) && removePropertySigns.contains(e));
        removePropertySigns.forEach(e -> this.getDynamicPageHelper().removeDimProperty((String)e));
    }

    private Boolean checkPropertyChange(String areaCacheKey, List<Map<String, String>> returnF7items, List<Map<String, String>> dims) {
        String curDimPropertyJson;
        String dimPropertyJson;
        Boolean result = false;
        IPageCache parentPageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String oldDimPropertyJson = parentPageCache.get(areaCacheKey);
        String string = dimPropertyJson = oldDimPropertyJson == null ? "" : oldDimPropertyJson;
        if (!StringUtils.isEmpty((String)oldDimPropertyJson)) {
            List allF7Items = (List)SerializationUtils.fromJsonString((String)oldDimPropertyJson, List.class);
            List<Map<String, String>> curF7Items = this.filterF7itemsByDim(allF7Items, dims, true);
            dimPropertyJson = SerializationUtils.toJsonString(curF7Items);
        }
        if (!(curDimPropertyJson = SerializationUtils.toJsonString(returnF7items)).equalsIgnoreCase(dimPropertyJson)) {
            result = true;
        }
        return result;
    }

    protected void handleCellF7ReturnValues(ClosedCallBackEvent closedCallBackEvent) {
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        boolean isRow = ROW_CELL_F7.equals(closedCallBackEvent.getActionId());
        Object result = closedCallBackEvent.getReturnData();
        if (result instanceof DynamicObject) {
            ListSelectedRowCollection rows = new ListSelectedRowCollection();
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue(((DynamicObject)result).get("id"));
            row.setNumber(((DynamicObject)result).getString("number"));
            row.setName(((DynamicObject)result).getString("name"));
            rows.add((Object)row);
            result = rows;
        } else if (result instanceof Map) {
            result = ((Map)result).get("result");
        } else if (result instanceof MultiF7Result) {
            List members = ((MultiF7Result)result).getSelectedMemberList();
            ListSelectedRowCollection rows = new ListSelectedRowCollection();
            if (CollectionUtils.isNotEmpty((Collection)members)) {
                members.forEach(e -> {
                    ListSelectedRow row = new ListSelectedRow((Object)e.getId());
                    row.setName(e.getName());
                    row.setNumber(e.getNumber());
                    row.setDataMap(MapInitHelper.ofMap((Object)"type", (Object)e.getType(), (Object)VIEW, (Object)e.getViewId(), (Object)"parentnum", (Object)e.getParentNumber()));
                    rows.add((Object)row);
                });
            }
            result = rows;
        }
        SpreadSelector selector = this.getSpreadF7Selector();
        int startRow = selector.getStartRow();
        int startCol = selector.getStartCol();
        if (result instanceof ListSelectedRowCollection) {
            this.handelCellF7ReturnValues_fixMembers(startRow, startCol, (ListSelectedRowCollection)result, isRow);
        }
    }

    protected void handelCellF7ReturnValues_fixMembers(int startRow, int startCol, ListSelectedRowCollection result, boolean isRow) {
        ArrayList<IDimensionMember> members = new ArrayList<IDimensionMember>(16);
        if (result == null || result.size() == 0) {
            this.updateTemplateModel_fix(startRow, startCol, null, isRow);
            this.setSpreadF7CellValue(startRow, startCol, null, isRow);
        } else {
            for (int i = 0; i < result.size(); ++i) {
                ListSelectedRow row = result.get(i);
                EmrDefaultDimMember dfMember = new EmrDefaultDimMember(IDUtils.toLong((Object)row.getPrimaryKeyValue()), row.getName(), row.getNumber(), RangeEnum.ONLY.getIndex());
                String type = null != row.getDataMap() ? (String)row.getDataMap().get("type") : null;
                String parentNum = null != row.getDataMap() ? (String)row.getDataMap().get("parentnum") : null;
                Long viewId = null != row.getDataMap() ? IDUtils.toLong(row.getDataMap().get(VIEW)) : null;
                dfMember.setType(StringUtils.isNotEmpty((String)type) ? type : null);
                dfMember.setParentNum(StringUtils.isNotEmpty((String)parentNum) ? parentNum : null);
                dfMember.setViewId(viewId);
                dfMember.setViewNumber(this.getViewNumber(viewId));
                members.add((IDimensionMember)dfMember);
            }
            List<IDimMember> updatedMembers = this.updateTemplateModel_fix(startRow, startCol, members, isRow);
            ArrayList<Object> names = new ArrayList<Object>(updatedMembers.size());
            updatedMembers.forEach(e -> names.add(e != null ? e.getName() : null));
            this.setSpreadF7CellValue(startRow, startCol, names, isRow);
        }
    }

    protected Map<Long, String> queryProInfo(Set<Long> ids) {
        return Collections.emptyMap();
    }

    protected String getMembShowInfo(String dimNumber, RowColDimMember emrRowColDimMember) {
        if (StringUtils.isNotEmpty((String)dimNumber) && emrRowColDimMember != null) {
            return TemplateProcessHelper.getMemberShowInfo(this.getModelId(), dimNumber, emrRowColDimMember.getMembers());
        }
        return "";
    }

    protected String getMembShowInfo(String dimNumber, IRowColDimensionEntry dimensionEntry) {
        RowColDimMember member = null;
        if (dimensionEntry != null) {
            member = new RowColDimMember();
            member.setFloat(dimensionEntry.isFloat());
            member.setMembers(dimensionEntry.getMembers());
            member.setViewId(dimensionEntry.getViewId());
            member.setViewNumber(dimensionEntry.getViewNumber());
        }
        return this.getMembShowInfo(dimNumber, member);
    }

    protected String getMembShowInfo(String dimNumber, IPageDimensionEntry pe) {
        RowColDimMember member = null;
        if (pe != null && CollectionUtils.isNotEmpty((Collection)pe.getMembers())) {
            member = new RowColDimMember();
            member.setViewId(pe.getViewId());
            member.setViewNumber(pe.getViewNumber());
            for (IDimensionMember pm : pe.getMembers()) {
                member.getMembers().add(new EmrDefaultDimMember(pm.getId(), pm.getName(), pm.getNumber(), pm.getScope(), pm.getViewId(), pm.getViewNumber(), pm.getParentNum()));
            }
        }
        return this.getMembShowInfo(dimNumber, member);
    }

    protected List<IDimMember> updateTemplateModel_fix(int r, int c, List<IDimensionMember> members, boolean isRow) {
        int headerIndex;
        ArrayList<IDimMember> updatedMembers = new ArrayList<IDimMember>(16);
        IDataAreaSetting multiAreaSetting = this.getMultiAreaSetting();
        if (multiAreaSetting == null) {
            return updatedMembers;
        }
        String f7SelectDimNumber = this.getSpreadF7SelectDimNumber();
        if (members != null && StringUtils.isEmpty((String)f7SelectDimNumber)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u7ef4\u5ea6\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractTemplateProcessPlugin_13", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return updatedMembers;
        }
        boolean updated = false;
        CellArea cellArea = new CellArea(multiAreaSetting.getAreaRange());
        int areaRowColIndex = isRow ? r - cellArea.getR() : c - cellArea.getC();
        int maxAreaRowColIndex = isRow ? cellArea.getRc() - 1 : cellArea.getCc() - 1;
        List headerInfos = isRow ? multiAreaSetting.getRowHeaders() : multiAreaSetting.getColHeaders();
        IHeaderInfo headerInfo = null;
        List headerObjects = null;
        int n = headerIndex = isRow ? c : r;
        if (headerInfos != null && headerInfos.size() > headerIndex && (headerInfo = (IHeaderInfo)headerInfos.get(headerIndex)) != null && (headerObjects = headerInfo.getHeaderObjects()) == null) {
            headerObjects = new SPArrayList();
            headerInfo.setHeaderObjects(headerObjects);
        }
        if (headerObjects == null) {
            return updatedMembers;
        }
        if (members == null || members.isEmpty()) {
            headerObjects.set(areaRowColIndex, null);
            updatedMembers.add(null);
            updated = true;
        } else {
            for (int i = 0; i < members.size(); ++i) {
                IHeaderObject headerObject;
                IDimensionMember member = members.get(i);
                if (member == null) continue;
                int index = areaRowColIndex + i;
                if (index > maxAreaRowColIndex || (headerObject = (IHeaderObject)headerObjects.get(index)) != null && headerObject.isFloat()) break;
                if (headerObject == null) {
                    headerObject = new HeaderObject();
                    headerObjects.set(index, headerObject);
                }
                headerObject.setNumber(member.getNumber());
                headerObject.setType(member.getType());
                headerObject.setViewNumber(this.getViewNumber(member.getViewId()));
                headerObject.setViewId(member.getViewId());
                headerObject.setViewNumber(member.getViewNumber());
                headerObject.setParentNum(member.getParentNum());
                updatedMembers.add((IDimMember)new DimMember(member.getName(), member.getNumber(), member.getViewId(), member.getViewNumber(), member.getParentNum()));
                updated = true;
            }
        }
        if (updated) {
            if (!DimPropertyHelper.getDimPropPosMap(headerInfo.getNumber(), headerInfos).isEmpty()) {
                List<ICell> propCells = DimPropertyHelper.setMemberProperties(r, c, headerInfo.getNumber(), updatedMembers, multiAreaSetting, this.getTemplateMemberService(), false);
                if (isRow) {
                    this.getRowSpreadContainer().updateCellValue2(propCells);
                } else {
                    this.getColSpreadContainer().updateCellValue2(propCells);
                }
            }
            this.cacheSheetManager();
            this.setDataChanged(true);
        }
        return updatedMembers;
    }

    protected void setSpreadF7CellValue(int r, int c, List<Object> values, boolean isRow) {
        ISpreadContainer spreadContainer;
        ISpreadContainer iSpreadContainer = spreadContainer = isRow ? this.getRowSpreadContainer() : this.getColSpreadContainer();
        if (values == null || values.isEmpty()) {
            spreadContainer.updateCellValue2((List)Lists.newArrayList((Object[])new ICell[]{new OneCell(r, c, null)}));
        } else {
            ArrayList<OneCell> eCells = new ArrayList<OneCell>(16);
            IDataAreaSetting area = this.getMultiAreaSetting();
            String[] areaRange = area.getAreaRange().split(":");
            Point endPoint = ExcelUtils.pos2Point((String)areaRange[1]);
            for (Object value : values) {
                if (r > endPoint.y || c > endPoint.x) break;
                eCells.add(new OneCell(r, c, value));
                if (isRow) {
                    ++r;
                    continue;
                }
                ++c;
            }
            spreadContainer.updateCellValue2((List)Lists.newArrayList(eCells));
        }
    }

    protected Map<String, IHeaderInfo> getHeaderInfoMap(IDataAreaSetting multiAreaSetting, String filterHeaderType, boolean hasHeaderObjects) {
        HashMap<String, IHeaderInfo> headerInfoMap = new HashMap<String, IHeaderInfo>(16);
        if (multiAreaSetting != null) {
            for (IHeaderInfo headerInfo : multiAreaSetting.getRowHeaders()) {
                if (filterHeaderType != null && !filterHeaderType.equals(headerInfo.getType()) || hasHeaderObjects && (headerInfo.getHeaderObjects() == null || headerInfo.getHeaderObjects().isEmpty())) continue;
                headerInfoMap.put(headerInfo.getNumber(), headerInfo);
            }
            for (IHeaderInfo headerInfo : multiAreaSetting.getColHeaders()) {
                if (filterHeaderType != null && !filterHeaderType.equals(headerInfo.getType()) || hasHeaderObjects && (headerInfo.getHeaderObjects() == null || headerInfo.getHeaderObjects().isEmpty())) continue;
                headerInfoMap.put(headerInfo.getNumber(), headerInfo);
            }
        }
        return headerInfoMap;
    }

    public void spreadF7Click(LinkedHashMap<String, Object> params) {
        if (params != null && !this.isOnFloatSetting()) {
            Integer row = (Integer)params.get("r");
            Integer col = (Integer)params.get("c");
            String source = (String)params.get("source");
            boolean isRow = this.getRowSpreadKey().equals(source);
            boolean isCol = this.getColSpreadKey().equals(source);
            this.cacheSpreadF7Selector(row, col, source);
            IDataAreaSetting areaSetting = this.getMultiAreaSetting();
            if (areaSetting != null) {
                CellArea cellArea = new CellArea(areaSetting.getAreaRange());
                RelationAreaInfo ri = areaSetting.getRelationAreaInfo();
                if (isCol && ri != null) {
                    int index = col - cellArea.getC();
                    IHeaderInfo hi = (IHeaderInfo)areaSetting.getColHeaders().get(index);
                    FieldBean fb = this.getRelaFieldMap().get(hi.getNumber());
                    if (fb != null && (fb.getTypeEnum() == RelationTypeEnum.DIMLIB || fb.getTypeEnum() == RelationTypeEnum.MODEL)) {
                        RelationDimBean dimension = fb.getDimension();
                        this.cacheSpreadF7SelectDimNumber(fb.getNumber());
                        MemberF7Parameter f7Param = this.getTemplateMemberService().getMemberF7Parameter(dimension.getNumber());
                        f7Param.setEnableView(true);
                        Long viewId = null;
                        IPageDimensionEntry pe = (IPageDimensionEntry)ri.getMemberScopes().get(fb.getNumber());
                        if (pe != null) {
                            viewId = this.getTemplateMemberService().getViewId(pe.getDimension().getNumber(), pe.getViewNumber());
                            if (CollectionUtils.isNotEmpty((Collection)pe.getMembers())) {
                                String dimNumber = pe.getDimension().getNumber();
                                this.getTemplateMemberService().fillMemberEntry(dimNumber, pe.getViewNumber(), pe.getMembers());
                                LinkedHashMap selectRange = new LinkedHashMap(16);
                                pe.getMembers().forEach(m -> selectRange.put(m.getId(), m.getScope()));
                                f7Param.setSelectIds(selectRange);
                            }
                        }
                        this.addRelationDimFilter(fb, f7Param);
                        f7Param.setMultiSelect(true);
                        f7Param.setViewId(viewId);
                        f7Param.setCutTree(false);
                        NewF7Utils.openF8((IFormView)this.getView(), (AbstractMemberF7Parameter)f7Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, SPREADF7CLICK_RELA));
                    }
                } else {
                    boolean isFloat = TemplateProcessHelper.isFloatOnRowCol(areaSetting, row, col, isRow);
                    if (isFloat) {
                        this.showFormFloatSetting();
                    } else {
                        String dimNumber = TemplateProcessHelper.getDimNumberOnRowCol(areaSetting, row, col, isRow);
                        if (StringUtils.isNotEmpty((String)dimNumber)) {
                            this.cacheSpreadF7SelectDimNumber(dimNumber);
                            String cellF7 = isRow ? ROW_CELL_F7 : (isCol ? COL_CELL_F7 : "");
                            MemberF7Parameter f7params = this.spreadF7ClickForSingleParam(dimNumber, this.getCellMember(isRow, row, col));
                            this.getTemplateMemberService().openSingleF7ForSpread(SPREADF7, this.getDimByNumber(dimNumber), f7params, new CloseCallBack((IFormPlugin)this, cellF7), this.getView());
                        }
                    }
                }
            }
        }
    }

    public void addRelationDimFilter(FieldBean fieldBean, MemberF7Parameter f7Param) {
        if (fieldBean != null) {
            List<Long> viewIds = new ArrayList<Long>(16);
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(16);
            if (RelationTypeEnum.DIMLIB == fieldBean.getTypeEnum() && CollectionUtils.isNotEmpty((Collection)fieldBean.getMemberScopes())) {
                qFilters.add(SpreadMemberHelper.getMemberRangeFilter(this.getModelId(), fieldBean.getDimension().getNumber(), fieldBean.getMemberScopes()));
                viewIds = SpreadMemberHelper.getViewIdsFromMemberScope(this.getModelId(), fieldBean.getDimension().getNumber(), fieldBean.getMemberScopes());
            } else if (RelationTypeEnum.MODEL == fieldBean.getTypeEnum() && CollectionUtils.isNotEmpty((Collection)fieldBean.getDimension().getViewIds())) {
                viewIds = fieldBean.getDimension().getViewIds();
            }
            SpreadMemberHelper.addViewQFilterForF7Param(f7Param, qFilters, viewIds, true);
        }
    }

    protected MemberF7Parameter spreadF7ClickForSingleParam(String dimNumber, IHeaderObject headerObject) {
        MemberF7Parameter p = this.getTemplateMemberService().getMemberF7Parameter(dimNumber, this.getBizModelId().longValue());
        if (null != headerObject) {
            ViewBean viewBean;
            QuoteTypeEnum typeEnum = QuoteTypeEnum.getByValule((String)headerObject.getType());
            IBaseEntry member = this.getTemplateMemberService().getMemberEntry(typeEnum, dimNumber, headerObject.getNumber(), (Object)headerObject.getViewNumber());
            if (null != member && IDUtils.isNotNull((Long)member.getId())) {
                p.setSelectIds((Set)Sets.newHashSet((Object[])new Long[]{member.getId()}));
            }
            if (IDUtils.isNotNull((Long)headerObject.getViewId())) {
                p.setViewId(IDUtils.toLong((Object)headerObject.getViewId()));
            } else if (StringUtils.isNotEmpty((String)headerObject.getViewNumber()) && (viewBean = EpbsThreadCache.findViewBeanByNum((long)this.getModelId(), (String)dimNumber, (String)headerObject.getViewNumber())) != null) {
                p.setViewId(Long.valueOf(viewBean.getId()));
            }
        }
        return p;
    }

    protected IHeaderObject getCellMember(boolean isRow, Integer r, Integer c) {
        int areaRowColIndex;
        IDataAreaSetting dataAreaSetting = this.getMultiAreaSetting();
        CellArea cellArea = new CellArea(dataAreaSetting.getAreaRange());
        List headerInfos = isRow ? dataAreaSetting.getRowHeaders() : dataAreaSetting.getColHeaders();
        int headerIndex = isRow ? c : r;
        int n = areaRowColIndex = isRow ? r - cellArea.getR() : c - cellArea.getC();
        if (headerIndex >= 0 && areaRowColIndex >= 0 && headerIndex < headerInfos.size() && areaRowColIndex < ((IHeaderInfo)headerInfos.get(headerIndex)).getHeaderObjects().size()) {
            return (IHeaderObject)((IHeaderInfo)headerInfos.get(headerIndex)).getHeaderObjects().get(areaRowColIndex);
        }
        return null;
    }

    public void spreadF7LookUpData(LookUpDataArgs args) {
        if (this.isOnFloatSetting() || this.isRelation()) {
            return;
        }
        SpreadSelector selector = this.getSpreadSelector();
        boolean isRow = this.getRowSpreadKey().equals(selector.getSource());
        boolean isCol = this.getColSpreadKey().equals(selector.getSource());
        if (!isRow && !isCol) {
            return;
        }
        int r = selector.getStartRow();
        int c = selector.getStartCol();
        IDataAreaSetting multiAreaSetting = this.getMultiAreaSetting();
        if (multiAreaSetting != null && !TemplateProcessHelper.isFloatOnRowCol(multiAreaSetting, r, c, isRow)) {
            String dimNumber;
            IDimension dimension;
            IHeaderInfo headerInfo;
            List headerInfos = isRow ? multiAreaSetting.getRowHeaders() : multiAreaSetting.getColHeaders();
            IHeaderInfo iHeaderInfo = headerInfo = isRow ? (IHeaderInfo)headerInfos.get(c) : (IHeaderInfo)headerInfos.get(r);
            if (headerInfo != null && (dimension = this.getDimByNumber(dimNumber = "Dimension".equals(headerInfo.getType()) ? headerInfo.getNumber() : null)) != null) {
                MemberF7Parameter f7Param = this.getTemplateMemberService().getMemberF7Parameter(dimNumber, this.getBizModelId().longValue());
                SpreadMemberHelper.spreadF7lookUpData(this.getClientViewProxy(), selector.getSource(), args, dimension.getMemberModel(), f7Param.listFilter().toFilter());
            }
        }
    }

    public void setSpreadF7Item(F7ItemFillBackArgs arg) {
        boolean isFloat;
        SpreadSelector selector = this.getSpreadSelector();
        boolean isRow = this.getRowSpreadKey().equals(selector.getSource());
        boolean isCol = this.getColSpreadKey().equals(selector.getSource());
        if (!isRow && !isCol) {
            return;
        }
        IDataAreaSetting multiAreaSetting = this.getMultiAreaSetting();
        if (multiAreaSetting == null) {
            return;
        }
        if (this.isRelation()) {
            if (StringUtils.isEmpty((String)arg.getNumber()) || StringUtils.isEmpty((String)arg.getName())) {
                this.clearScopeSetting(multiAreaSetting, arg.getC());
                this.getColSpreadContainer().updateCellValue2((List)Lists.newArrayList((Object[])new ICell[]{new Cell(arg.getR(), arg.getC(), null)}));
            } else {
                return;
            }
        }
        if (isFloat = TemplateProcessHelper.isFloatOnRowCol(multiAreaSetting, arg.getR(), arg.getC(), isRow)) {
            return;
        }
        String dimNumber = TemplateProcessHelper.getDimNumberOnRowCol(multiAreaSetting, arg.getR(), arg.getC(), isRow);
        if (StringUtils.isEmpty((String)dimNumber)) {
            return;
        }
        this.cacheSpreadF7SelectDimNumber(dimNumber);
        if (arg.getId() == 0L || StringUtils.isEmpty((String)arg.getName()) && StringUtils.isEmpty((String)arg.getNumber())) {
            this.updateTemplateModel_fix(arg.getR(), arg.getC(), null, isRow);
        } else {
            IDimensionMember dimMem = this.getTemplateMemberService().getDimMember(dimNumber, null, Long.valueOf(arg.getId()));
            this.updateTemplateModel_fix(arg.getR(), arg.getC(), Lists.newArrayList((Object[])new IDimensionMember[]{dimMem}), isRow);
        }
        this.cacheTemplateModel();
        this.setSpreadF7CellValue(arg.getR(), arg.getC(), Lists.newArrayList((Object[])new Object[]{arg.getName()}), isRow);
    }

    public String getSpreadF7SelectDimNumber() {
        return this.getPageCache().get("spreadF7ClickDimNumber");
    }

    public void cacheSpreadF7SelectDimNumber(String dimNumber) {
        this.getPageCache().put("spreadF7ClickDimNumber", dimNumber);
    }

    public String getSpreadF7SelectViewId() {
        return this.getPageCache().get("spreadF7ClickViewId");
    }

    public void cacheSpreadF7SelectViewId(String viewId) {
        this.getPageCache().put("spreadF7ClickViewId", viewId);
    }

    public void controlSpreadAndBtn(String type, boolean isHide) {
        this.getView().setEnable(Boolean.valueOf(!isHide), this.getToolBarItems(type));
        SpreadClientInvoker.invokeSpreadMenuItems(this.getClientViewProxy(), this.getSpreadKey(), isHide);
    }

    protected void openTemplatePage() {
        String caption = ResManager.loadKDString((String)"\u901a\u7528\u6a21\u677f", (String)"AbstractTemplateProcessPlugin_14", (String)"epm-emr-formplugin", (Object[])new Object[0]);
        this.openTemplateBaseInfoPage(BTN_BASEINFO, caption, OperationStatus.EDIT, this.getModelId(), formShowParameter -> formShowParameter.setCustomParam("MULTISHEET_TEMPLATE_INFO", (Object)TemplateInfo.toByteSerialized((Object)this.getTemplateBaseInfo().cloneBaseInfo())));
    }

    protected void showFormDimSetting() {
        String caption = ResManager.loadKDString((String)"\u7ef4\u5ea6\u8bbe\u7f6e", (String)"AbstractTemplateProcessPlugin_15", (String)"epm-emr-formplugin", (Object[])new Object[0]);
        FormShowParameter formShowParameter = this.openPage(BTN_DIMSETTING, caption, ShowType.Modal);
        formShowParameter.setFormId(this.getEpbsDimSetting());
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        if (this.hasAreaSettings()) {
            formShowParameter.setCustomParam("KEY_BIZDOMAIN_ID", (Object)this.getBizDomainId());
        }
        if (this.getPageCache().get("MULTISHEET_TEMPLATE_INFO") != null) {
            formShowParameter.setCustomParam("MULTISHEET_TEMPLATE_INFO", (Object)this.getPageCache().get("MULTISHEET_TEMPLATE_INFO"));
        } else {
            formShowParameter.setCustomParam("MULTISHEET_TEMPLATE_INFO", this.getView().getFormShowParameter().getCustomParam("MULTISHEET_TEMPLATE_INFO"));
        }
        if (this.getPageCache().get("MULTISHEET_TEMPLATE_MODEL") != null) {
            formShowParameter.setCustomParam("MULTISHEET_TEMPLATE_MODEL", (Object)this.getPageCache().get("MULTISHEET_TEMPLATE_MODEL"));
        } else {
            formShowParameter.setCustomParam("MULTISHEET_TEMPLATE_MODEL", this.getView().getFormShowParameter().getCustomParam("MULTISHEET_TEMPLATE_MODEL"));
        }
        if (this.getPageCache().get("key_new_spread_model") != null) {
            formShowParameter.setCustomParam("key_new_spread_model", (Object)this.getPageCache().get("key_new_spread_model"));
        } else {
            formShowParameter.setCustomParam("key_new_spread_model", this.getView().getFormShowParameter().getCustomParam("key_new_spread_model"));
        }
        SpreadSheet spreadSheet = this.getActiveSheet();
        if (spreadSheet != null) {
            formShowParameter.setCustomParam(CURRENTSHEET, (Object)JSONUtils.toString((Object)spreadSheet));
        }
        this.getView().showForm(formShowParameter);
    }

    protected void showFormFloatSetting() {
        SpreadSelector selector = this.getSpreadSelector();
        if (this.getSpreadSelector() == null) {
            return;
        }
        boolean isRow = this.getRowSpreadKey().equals(selector.getSource());
        boolean isCol = this.getColSpreadKey().equals(selector.getSource());
        if (!isRow && !isCol) {
            return;
        }
        if (!this.checkCanSetFloat(isRow)) {
            return;
        }
        this.refreshHeaderDisplays();
        FormShowParameter formShowParameter = this.getFloatSettingFormShowParams();
        formShowParameter.setCustomParam("areaSetting", (Object)this.toByteSerialized(this.getMultiAreaSetting()));
        formShowParameter.setCustomParam(IS_ROW, (Object)(isRow ? TRUE : FALSE));
        String pageId = this.getPageIdAndCache(this.getPageCache(), this.getEpbsFloatSetting(), true);
        this.getPageCache().put("pageId", pageId);
        formShowParameter.setPageId(pageId);
        this.setOnFloatSetting(isRow ? FloatTypeEnum.ROW.getVal() + "" : FloatTypeEnum.COL.getVal() + "");
        this.getView().showForm(formShowParameter);
        this.controlSpreadAndBtn(ON_FLOAT_SETTING, true);
    }

    protected boolean checkCanSetFloat(boolean isRow) {
        IDataAreaSetting multiAreaSetting = this.getMultiAreaSetting();
        if (multiAreaSetting == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u533a\u57df\u3002", (String)"AbstractTemplateProcessPlugin_16", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            return false;
        }
        List areaSettings = this.getSheetManager().getAreaRanges();
        int maxFloatOffset = TemplateProcessHelper.getMaxFloatOffset(multiAreaSetting, isRow);
        if (maxFloatOffset < 0) {
            if (isRow) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u884c\u7ef4\u5ea6\u9884\u7559\u6807\u9898\u884c\u5355\u5143\u683c\u7a7a\u95f4\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5\u8c03\u6574\u540e\u518d\u8bbe\u7f6e\u3002", (String)"AbstractTemplateProcessPlugin_17", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5217\u7ef4\u5ea6\u9884\u7559\u6807\u9898\u5217\u5355\u5143\u683c\u7a7a\u95f4\u4e0d\u8db3\uff0c\u8bf7\u68c0\u67e5\u8c03\u6574\u540e\u518d\u8bbe\u7f6e\u3002", (String)"AbstractTemplateProcessPlugin_18", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        if (multiAreaSetting != null && areaSettings.size() > 1) {
            String overlapType = TemplateProcessHelper.checkRowColOverlapOnAreas(areaSettings);
            if (isRow && (ROW.equals(overlapType) || "rowcol".equals(overlapType))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u6a2a\u5411\u6392\u5e03\u7684\u5176\u4ed6\u6570\u636e\u533a\u57df\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u884c\u6d6e\u52a8\u3002", (String)"AbstractTemplateProcessPlugin_19", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (!isRow && (COL.equals(overlapType) || "rowcol".equals(overlapType))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u7eb5\u5411\u6392\u5e03\u7684\u5176\u4ed6\u6570\u636e\u533a\u57df\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u5217\u6d6e\u52a8\u3002", (String)"AbstractTemplateProcessPlugin_20", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                return false;
            }
            for (IDataAreaSetting areaSetting : areaSettings) {
                if (areaSetting.getAreaRange().equals(multiAreaSetting.getAreaRange())) continue;
                FloatTypeEnum ft = areaSetting.getFloatOnWhere();
                if (isRow && (ft == FloatTypeEnum.COL || ft == FloatTypeEnum.ROWCOL)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6709\u5176\u4ed6\u6570\u636e\u533a\u57df\u8bbe\u7f6e\u4e86\u5217\u6d6e\u52a8\uff0c\u4e0d\u5141\u8bb8\u518d\u8bbe\u7f6e\u884c\u6d6e\u52a8\u3002", (String)"AbstractTemplateProcessPlugin_21", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (isRow || ft != FloatTypeEnum.ROW && ft != FloatTypeEnum.ROWCOL) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6709\u5176\u4ed6\u6570\u636e\u533a\u57df\u8bbe\u7f6e\u4e86\u884c\u6d6e\u52a8\uff0c\u4e0d\u5141\u8bb8\u518d\u8bbe\u7f6e\u5217\u6d6e\u52a8\u3002", (String)"AbstractTemplateProcessPlugin_22", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    protected boolean checkCanNewArea(SpreadSelector selector, List<IDataAreaSetting> areaRanges, boolean isRelation) {
        if (selector != null && areaRanges != null && !areaRanges.isEmpty()) {
            String rect = selector.getRect();
            for (IDataAreaSetting areaSetting : areaRanges) {
                String overlapType = TemplateProcessHelper.checkRowColOverlapOnAreaRanges(Lists.newArrayList((Object[])new String[]{rect, areaSetting.getAreaRange()}));
                if (isRelation && ROW.equals(overlapType)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u6a2a\u5411\u6392\u5e03\u7684\u5176\u4ed6\u6570\u636e\u533a\u57df\uff0c\u4e0d\u5141\u8bb8\u518d\u8bbe\u7f6e\u5173\u7cfb\u6570\u636e\u533a\u57df\u3002", (String)"AbstractTemplateProcessPlugin_23", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (FloatTypeEnum.ROWCOL == areaSetting.getFloatOnWhere()) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u884c\u5217\u540c\u65f6\u6d6e\u52a8\u7684\u6570\u636e\u533a\u57df\uff0c\u4e0d\u5141\u8bb8\u518d\u8bbe\u7f6e\u6570\u636e\u533a\u57df\u3002", (String)"AbstractTemplateProcessPlugin_24", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (FloatTypeEnum.ROW == areaSetting.getFloatOnWhere() && ROW.equals(overlapType)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u884c\u6d6e\u52a8\u7684\u6570\u636e\u533a\u57df\uff0c\u4e0d\u5141\u8bb8\u6a2a\u5411\u518d\u8bbe\u7f6e\u6570\u636e\u533a\u57df\u3002", (String)"AbstractTemplateProcessPlugin_25", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                    return false;
                }
                if (FloatTypeEnum.COL != areaSetting.getFloatOnWhere() || !COL.equals(overlapType)) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5217\u6d6e\u52a8\u7684\u6570\u636e\u533a\u57df\uff0c\u4e0d\u5141\u8bb8\u7eb5\u5411\u518d\u8bbe\u7f6e\u6570\u636e\u533a\u57df\u3002", (String)"AbstractTemplateProcessPlugin_26", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    protected FormShowParameter getFloatSettingFormShowParams() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(this.getEpbsFloatSetting());
        formShowParameter.setPageId(this.getView().getPageId() + this.getEpbsFloatSetting());
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCustomParam("bizModelId", (Object)this.getBizModelId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, BTN_FLOATSETTING);
        formShowParameter.setCloseCallBack(closeCallBack);
        return formShowParameter;
    }

    protected void setOnFloatSetting(String onFloatSetting) {
        this.getPageCache().put(ON_FLOAT_SETTING, onFloatSetting);
    }

    protected String getOnFloatSetting() {
        return this.getPageCache().get(ON_FLOAT_SETTING);
    }

    protected boolean isOnFloatSetting() {
        String floatType = this.getOnFloatSetting();
        return floatType != null && (floatType.equals(FloatTypeEnum.ROW.getVal() + "") || floatType.equals(FloatTypeEnum.COL.getVal() + ""));
    }

    public void identArea(Object params) {
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if (evt.getSource() instanceof BasedataEdit && SPREADF7.equals(((BasedataEdit)evt.getSource()).getKey())) {
            this.beforeF7SelectForSpread(evt);
        } else {
            this.beforeF7SelectForAreaView(evt);
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        String key = ((BasedataEdit)e.getSource()).getKey();
        String dimNumber = this.getCurrentDimNumber(key);
        Long viewId = this.getMemberF7ViewId(key);
        if (!SPREADF7.equals(key) && IDUtils.isNotNull((Long)viewId) && StringUtils.isNotEmpty((String)dimNumber)) {
            HashMap<String, Long> areaPVDimViews = null;
            String areaPVDimViewsStr = this.getPageCache().get("areaPVDimViews");
            areaPVDimViews = StringUtils.isNotEmpty((String)areaPVDimViewsStr) ? (HashMap<String, Long>)SerializationUtils.fromJsonString((String)areaPVDimViewsStr, Map.class) : new HashMap<String, Long>(16);
            areaPVDimViews.put(dimNumber, viewId);
            this.getPageCache().put("areaPVDimViews", SerializationUtils.toJsonString(areaPVDimViews));
        }
    }

    protected void beforeF7SelectForSpread(BeforeF7SelectEvent evt) {
    }

    protected void beforeF7SelectForAreaView(BeforeF7SelectEvent evt) {
    }

    public long getModelId() {
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        if (IDUtils.isNull((Long)modelId)) {
            modelId = IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID"));
        }
        return modelId;
    }

    @Override
    public AbstractFormPlugin getPlugin() {
        return super.getPlugin();
    }

    @Override
    public String getEpbsTemplateEntity() {
        return this.getTemplateBaseInfo().getDataEntityNumber();
    }

    @Override
    public String getEpbsTemplateProcess() {
        return this.getView().getFormShowParameter().getFormId();
    }

    @Override
    public String getEpbsDimSetting() {
        return (String)this.getFormCustomParam("KEY_TEMPLATE_DIMSETTING");
    }

    @Override
    public String getEpbsFloatSetting() {
        return (String)this.getFormCustomParam("KEY_TEMPLATE_FLOATSETTING");
    }

    public boolean hasAreaSettings() {
        return this.getSheetManager().hasAreaRange();
    }

    public TemplateTypeEnum getTemplateType() {
        this.templateModel = this.getTemplateModel();
        if (this.templateModel != null) {
            return this.templateModel.getTemplateType();
        }
        return null;
    }

    protected void save() {
        this.getSpreadContainer().getSpreadJson("saveSpreadJson");
    }

    public void saveSpreadJson(String spreadserial) {
        TemplateAreaManagerHelper.sortAreaSettings(this.getSheetManager());
        FloatLogicHelper.fixOriginalRange(this.getSheetManager(), false);
        SpreadJsonHelper.syncSpreadCellToSm(spreadserial, this.getSheetManager(), this.getActiveSheet().getSheetName());
        this.cacheSheetManager();
        this.getTemplateModel().setSheetManager(this.getSheetManager());
        this.cacheTemplateModel();
        boolean isSave = this.beforeSaveMultiSheetTemplateModel(spreadserial);
        if (isSave) {
            this.saveMultiSheetTemplateModel();
            this.afterSaveMultiSheetTemplateModel();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6a21\u677f\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractTemplateProcessPlugin_27", (String)"epm-emr-formplugin", (Object[])new Object[0]));
        }
    }

    public void syncSpreads(Object params) {
    }

    protected boolean beforeSaveMultiSheetTemplateModel(String spreadserial) {
        boolean catalogExist;
        BizModelBean bmb;
        String msg = "";
        Object templateBaseInfo = this.getTemplateBaseInfo();
        this.sm = this.getSheetManager();
        HashSet<String> areas_invalidAVP = new HashSet<String>(16);
        HashSet<String> areas_invalidRela = new HashSet<String>(16);
        HashSet<Tuple> invalidBizModels = new HashSet<Tuple>(16);
        boolean isValid = true;
        for (IDataAreaSetting areaSetting : this.sm.getAreaRanges()) {
            if (areaSetting.getAreaViewpointmembentry().stream().anyMatch(e -> e.getMember() == null)) {
                areas_invalidAVP.add(areaSetting.getAreaRange());
                isValid = false;
            }
            if (!areaSetting.isRelation()) continue;
            RelationModelBean rm = this.getTemplateMemberService().getRelationModel(areaSetting.getRelationAreaInfo().getRelationModel());
            if (!areaSetting.getRelationAreaInfo().getCols().containsAll(rm.getMustInputFields())) {
                areas_invalidRela.add(areaSetting.getAreaRange());
                isValid = false;
            }
            if (rm.getStatus()) continue;
            invalidBizModels.add(Tuple.create((Object)rm.getId(), (Object)rm.getNumber(), (Object)rm.getName()));
            isValid = false;
        }
        Long bizModelId = this.getBizModelId();
        if (IDUtils.isNotNull((Long)bizModelId) && (bmb = this.getTemplateMemberService().getBizModel(bizModelId)) != null && !bmb.isEnable()) {
            invalidBizModels.add(Tuple.create((Object)bmb.getId(), (Object)bmb.getNumber(), (Object)bmb.getNameString()));
            isValid = false;
        }
        if (!areas_invalidAVP.isEmpty()) {
            msg = ResManager.loadKDString((String)"\u6570\u636e\u533a\u57df%s\u4e2d\u672a\u8bbe\u7f6e\u533a\u57df\u9690\u85cf\u7ef4\u6210\u5458\uff0c\u8bf7\u8bbe\u7f6e\u5b8c\u6574\u540e\u518d\u4fdd\u5b58\u3002", (String)"AbstractTemplateProcessPlugin_28", (String)"epm-emr-formplugin", (Object[])new Object[]{areas_invalidAVP});
            this.getView().showErrorNotification(msg);
        }
        if (!areas_invalidRela.isEmpty()) {
            msg = ResManager.loadKDString((String)"\u6570\u636e\u533a\u57df%s\u4e2d\u672a\u8bbe\u7f6e\u5b8c\u6574\u7684\u5fc5\u5f55\u5b57\u6bb5\uff0c\u8bf7\u8bbe\u7f6e\u5b8c\u6574\u540e\u518d\u4fdd\u5b58\u3002", (String)"AbstractTemplateProcessPlugin_29", (String)"epm-emr-formplugin", (Object[])new Object[]{areas_invalidRela});
            this.getView().showErrorNotification(msg);
        }
        if (!invalidBizModels.isEmpty()) {
            msg = ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u5fc5\u987b\u4e3a\u201c\u542f\u7528\u201d\u72b6\u6001\uff0c\u5bf9\u5e94\u7684\u62a5\u8868\u6a21\u677f\u624d\u80fd\u4fdd\u5b58\u3002\u4e1a\u52a1\u6a21\u578b%s\u72b6\u6001\u4e3a\u7981\u7528\uff0c\u8bf7\u5148\u542f\u7528\u3002", (String)"AbstractTemplateProcessPlugin_30", (String)"epm-emr-formplugin", (Object[])new Object[]{invalidBizModels.stream().map(e -> (String)e.p3).collect(Collectors.toSet())});
            this.getView().showErrorNotification(msg);
        }
        if (!(catalogExist = QueryServiceHelper.exists((String)((String)this.getFormCustomParam("KEY_TEMPLATE_CATALOG_ENTITY")), (Object)templateBaseInfo.getTemplatecatalogId()))) {
            msg = ResManager.loadKDString((String)"\u6a21\u677f\u5206\u7c7b\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u540e\u518d\u4fdd\u5b58\u3002", (String)"AbstractTemplateProcessPlugin_31", (String)"epm-emr-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            isValid = false;
        }
        String data = TemplateModelJSONUtil.toJsonSheetManager((ISheetManager)this.sm);
        templateBaseInfo.addSingleTemplateSheet((String)this.getMultiSheetTemplateModel().getSheetNames().get(0));
        templateBaseInfo.setData(data);
        templateBaseInfo.setSpreadJson(spreadserial);
        templateBaseInfo.setTemplatetype(this.getTemplateShowType(this.sm));
        templateBaseInfo.setBusinessDomain(this.getBizDomainId());
        this.getMultiSheetTemplateModel().setTemplateBaseInfo(templateBaseInfo);
        return isValid;
    }

    protected void saveMultiSheetTemplateModel() {
        Object templateBaseInfo = this.getTemplateBaseInfo();
        List quotes = this.getTemplateService().buildMemberQuote(this.getTemplateModel(), this.getSheetManager());
        boolean isAdd = !QueryServiceHelper.exists((String)templateBaseInfo.getDataEntityNumber(), (Object)templateBaseInfo.getId());
        try (TXHandle required = TX.required((String)"saveTemplateModel");){
            try {
                this.getTemplateService().saveTemplate(templateBaseInfo, quotes);
                this.writeSaveLog(templateBaseInfo, isAdd);
            }
            catch (Exception ex) {
                required.markRollback();
                throw ex;
            }
        }
    }

    protected void afterSaveMultiSheetTemplateModel() {
        this.cacheMultiSheetTemplateModel(true);
    }

    public void cellClick(SpreadSelector selector) {
        super.cellClick(selector);
        if (VIEW_DEFAULT.equals(this.getCurrentView()) && TRUE.equals(this.getPageCache().get(SELECT_AREA))) {
            this.selectArea(selector);
        } else if (VIEW_EDITAREA.equals(this.getCurrentView()) && this.isOnFloatSetting()) {
            this.selectFloatRange(selector);
        }
        if (this.getSpreadKey().equals(selector.getSource()) && !selector.isMultiSelectCells()) {
            this.setReportStatusBar();
        }
    }

    protected void setReportStatusBar() {
        StatusBarModel statusBarModel = new StatusBarModel();
        CellInfo cellInfo = new CellInfo(this.getSelectorStartRow(), this.getSelectorStartCol(), this.getSheetManager(), new ReportContext(this.getModelId(), this.getBizModelId().longValue()));
        if (cellInfo.getAreaSetting() != null) {
            statusBarModel.setCellNameStr(cellInfo.getRCDimMemberMessage(true));
        } else {
            statusBarModel.setCellNameStr("");
        }
        SpreadClientInvoker.invokeSetDisplayContent(this.getClientViewProxy(), this.getSpreadKey(), statusBarModel);
    }

    public void cellValueUpdate(CellValueEvent cellValueEvent) {
        super.cellValueUpdate(cellValueEvent);
        boolean isRow = this.getRowSpreadKey().equals(cellValueEvent.getSource());
        boolean isCol = this.getColSpreadKey().equals(cellValueEvent.getSource());
        if (!isRow && !isCol) {
            return;
        }
        IDataAreaSetting areaSetting = this.getMultiAreaSetting();
        if (areaSetting == null) {
            return;
        }
        ISpreadContainer spreadContainer = isRow ? this.getRowSpreadContainer() : this.getColSpreadContainer();
        Cell cell = cellValueEvent.getCell();
        int r = cell.getRow();
        int c = cell.getCol();
        if (isCol && this.isRelation()) {
            if (r == 1 && (cellValueEvent.getNewValue() == null || StringUtils.isEmpty((String)(cellValueEvent.getNewValue() + "")))) {
                this.clearScopeSetting(areaSetting, c);
            } else {
                cellValueEvent.setCancel(true);
                this.getColSpreadContainer().updateCellValue2((List)Lists.newArrayList((Object[])new ICell[]{new Cell(r, c, null)}));
            }
            TemplateProcessHelper.resetCellStyle(this.getColSpreadContainer(), r, c, this.isRelation(), true);
        } else {
            IHeaderInfo headerInfo;
            int maxAreaRowColIndex;
            OneCell oneCell = new OneCell(r, c, cellValueEvent.getNewValue());
            CellArea cellArea = new CellArea(areaSetting.getAreaRange());
            int areaRowColIndex = isRow ? r - cellArea.getR() : c - cellArea.getC();
            int n = maxAreaRowColIndex = isRow ? cellArea.getRc() - 1 : cellArea.getCc() - 1;
            if (areaRowColIndex < 0 || areaRowColIndex > maxAreaRowColIndex) {
                return;
            }
            List headerInfos = isRow ? areaSetting.getRowHeaders() : areaSetting.getColHeaders();
            IHeaderInfo iHeaderInfo = headerInfo = isRow ? (IHeaderInfo)headerInfos.get(c) : (IHeaderInfo)headerInfos.get(r);
            if (headerInfo != null) {
                String dimNumber = "Dimension".equals(headerInfo.getType()) ? headerInfo.getNumber() : null;
                IDimension dimension = this.getDimByNumber(dimNumber);
                boolean isFloatCell = TemplateProcessHelper.isFloatOnRowCol(areaSetting, r, c, isRow);
                TemplateProcessHelper.resetCellStyle(spreadContainer, r, c, this.isRelation(), isFloatCell);
                if (isFloatCell) {
                    cellValueEvent.setCancel(true);
                    return;
                }
                if (dimension != null && !isFloatCell) {
                    this.cacheSpreadF7SelectDimNumber(dimNumber);
                    MemberF7Parameter f7Parameter = this.getTemplateMemberService().getMemberF7Parameter(dimNumber, this.getBizModelId().longValue());
                    String entity = dimension.getMemberModel();
                    QFilter qfNumberName = new QFilter("number", "=", (Object)(cellValueEvent.getNewValue() + "")).or(new QFilter("name", "=", (Object)(cellValueEvent.getNewValue() + "")));
                    String selectField = "id,number,name,view.id,view.number,parent.number";
                    DynamicObject memObj = null;
                    boolean multiMatch = false;
                    DynamicObject[] mems = BusinessDataServiceHelper.load((String)entity, (String)selectField, (QFilter[])new QFilter[]{f7Parameter.listFilter().toFilter(), qfNumberName});
                    if (mems != null) {
                        if (mems.length == 1) {
                            memObj = mems[0];
                        } else if (mems.length > 1) {
                            multiMatch = true;
                        }
                    }
                    if (memObj != null) {
                        EmrDefaultDimMember dimMem = new EmrDefaultDimMember(Long.valueOf(memObj.getLong("id")), memObj.getString("name"), memObj.getString("number"), RangeEnum.ONLY.getIndex(), Long.valueOf(memObj.getLong("view.id")), memObj.getString("view.number"), memObj.getString("parent.number"));
                        this.updateTemplateModel_fix(r, c, Lists.newArrayList((Object[])new IDimensionMember[]{dimMem}), isRow);
                    } else {
                        this.updateTemplateModel_fix(r, c, null, isRow);
                        if (cellValueEvent.getNewValue() != null) {
                            if (multiMatch) {
                                oneCell.setValue((Object)ResManager.loadKDString((String)"\u5b58\u5728\u591a\u4e2a\u76f8\u540c\u7ef4\u5ea6\u6210\u5458\u540d\u79f0\uff0c\u5efa\u8bae\u4f7f\u7528\u7ef4\u5ea6\u6210\u5458\u7f16\u7801\u590d\u5236\u7c98\u8d34:%s", (String)"AbstractTemplateProcessPlugin_32", (String)"epm-emr-formplugin", (Object[])new Object[]{cellValueEvent.getNewValue()}));
                            } else {
                                oneCell.setValue((Object)ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u4e0d\u5b58\u5728:%s", (String)"AbstractTemplateProcessPlugin_33", (String)"epm-emr-formplugin", (Object[])new Object[]{cellValueEvent.getNewValue()}));
                            }
                        }
                        spreadContainer.updateCellValue2((List)Lists.newArrayList((Object[])new ICell[]{oneCell}));
                    }
                } else {
                    oneCell.setValue(null);
                    spreadContainer.updateCellValue2((List)Lists.newArrayList((Object[])new ICell[]{oneCell}));
                }
            }
        }
    }

    private void clearScopeSetting(IDataAreaSetting areaSetting, int c) {
        CellArea cellArea = new CellArea(areaSetting.getAreaRange());
        IHeaderInfo hi = (IHeaderInfo)areaSetting.getColHeaders().get(c - cellArea.getC());
        RelationAreaInfo ri = areaSetting.getRelationAreaInfo();
        if (hi != null) {
            ri.getMemberScopes().remove(hi.getNumber());
            this.cacheSheetManager();
            this.setDataChanged(true);
        }
    }

    public String getActiveDataArea() {
        return this.getPageCache().get("activeDataArea");
    }

    public void setActiveDataArea(String area) {
        this.getPageCache().put("activeDataArea", area);
    }

    public IDataAreaSetting getMultiAreaSetting() {
        List<IDataAreaSetting> iDataAreaSettings;
        IDataAreaSetting multiAreaSetting = null;
        String dataArea = this.getActiveDataArea();
        if (StringUtils.isEmpty((String)dataArea) && this.isEditDataArea()) {
            dataArea = this.getSpreadSelector(this.getSpreadKey()).getRect();
        }
        if (CollectionUtils.isNotEmpty(iDataAreaSettings = TemplateProcessHelper.getListOverlapAreaRange(dataArea, this.getSheetManager().getAreaRanges()))) {
            multiAreaSetting = iDataAreaSettings.get(0);
        }
        return multiAreaSetting;
    }

    public List<IDataAreaSetting> getMultiAreaSettingsBySelect() {
        return TemplateProcessHelper.getListOverlapAreaRange(this.getSpreadSelector(this.getSpreadKey()).getRect(), this.getSheetManager().getAreaRanges());
    }

    @Override
    public String getSpreadKey() {
        return "spreadap";
    }

    public String getColSpreadKey() {
        return "colspreadap";
    }

    public String getRowSpreadKey() {
        return "rowspreadap";
    }

    public ISpreadContainer getColSpreadContainer() {
        if (this.colSpreadContainer == null) {
            this.colSpreadContainer = new SpreadContainer(this.getView(), this.getColSpreadKey());
        }
        return this.colSpreadContainer;
    }

    public ISpreadContainer getRowSpreadContainer() {
        if (this.rowSpreadContainer == null) {
            this.rowSpreadContainer = new SpreadContainer(this.getView(), this.getRowSpreadKey());
        }
        return this.rowSpreadContainer;
    }

    protected List<IDimension> getDimensionList() {
        return Collections.EMPTY_LIST;
    }

    protected void updateTemplateBaseInfo(Object returndata) {
        if (returndata instanceof String) {
            TemplateInfo returnTemplate = (TemplateInfo)this.deSerializedBytes((String)returndata);
            Object templateBaseInfo = this.getTemplateBaseInfo();
            templateBaseInfo.putAll((Map)returnTemplate);
            this.cacheTemplateBaseInfo(templateBaseInfo);
            this.setDataChanged(true);
        }
    }

    private void selectArea() {
        this.selectArea(false);
    }

    private void selectArea(boolean withBizModel) {
        FormShowParameter formShowParameter = new FormShowParameter();
        if (withBizModel) {
            formShowParameter.setFormId(this.getSelectAreaModelForm());
        } else {
            formShowParameter.setFormId("epbs_selectarea");
        }
        formShowParameter.setCustomParam("area", (Object)this.getSpreadSelector(this.getSpreadKey()).getRect());
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getModelId());
        formShowParameter.setCustomParam("KEY_BIZDOMAIN_ID", (Object)this.getBizDomainId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Floating);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, withBizModel ? CALLBACK_SELECTAREA_WITHBIZMODEL : CALLBACK_SELECTAREA);
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getPageCache().put("pageId", formShowParameter.getPageId());
        this.getView().showForm(formShowParameter);
        this.controlSpreadAndBtn(SELECT_AREA, true);
        this.getPageCache().put(SELECT_AREA, TRUE);
    }

    protected String getSelectAreaModelForm() {
        return null;
    }

    protected String[] getToolBarItems(String type) {
        String[] toolBarItems = null;
        switch (type) {
            case "selectArea": {
                toolBarItems = ITEMS_SELECT_AREA;
                break;
            }
            case "VIEW_DEFAULT": {
                toolBarItems = ITEMS_VIEW_DEFAULT;
                break;
            }
            case "VIEW_EDITAREA": {
                toolBarItems = ITEMS_VIEW_EDITAREA;
                break;
            }
            case "VIEW_EDITAREA_REL": {
                toolBarItems = ITEMS_VIEW_EDITAREA_REL;
                break;
            }
            case "onFloatSetting": {
                toolBarItems = ITEMS_ON_FLOAT_SETTING;
                break;
            }
        }
        return toolBarItems;
    }

    private void selectArea(SpreadSelector selector) {
        IFormView childFormView = this.getChildFormView(this.getPageCache().get("pageId"));
        if (selector != null && childFormView != null) {
            childFormView.getModel().setValue("area", (Object)selector.getRect());
            this.getView().sendFormAction(childFormView);
        }
    }

    private void selectFloatRange(SpreadSelector selector) {
        String onFloatSetting = this.getOnFloatSetting();
        IFormView childFormView = null;
        if (selector != null && StringUtils.isNotEmpty((String)onFloatSetting) && (childFormView = this.getChildFormView(this.getPageCache().get("pageId"))) != null) {
            boolean isCol;
            SpreadSelector spreadSelector = this.getSpreadSelector();
            boolean isRow = String.valueOf(FloatTypeEnum.ROW.getVal()).equals(onFloatSetting) && this.getRowSpreadKey().equals(spreadSelector.getSource());
            boolean bl = isCol = String.valueOf(FloatTypeEnum.COL.getVal()).equals(onFloatSetting) && this.getColSpreadKey().equals(spreadSelector.getSource());
            if ((isRow || isCol) && childFormView != null) {
                String index = this.getPageCache().get("floatRangeIndex");
                String floatoffsetStr = this.getPageCache().get("floatOffset");
                if (index != null) {
                    try {
                        IDataAreaSetting multiAreaSetting = this.getMultiAreaSetting();
                        if (multiAreaSetting != null) {
                            int floatOffset;
                            CellArea cellArea = new CellArea(multiAreaSetting.getAreaRange());
                            int n = floatOffset = floatoffsetStr == null ? 0 : Integer.parseInt(floatoffsetStr);
                            if (isRow) {
                                cellArea.setR(selector.getStartRow());
                                cellArea.setRc(selector.getEndRow() - selector.getStartRow() + 1);
                                cellArea.setC(cellArea.getC() - multiAreaSetting.getRowHeaders().size() - floatOffset);
                                cellArea.setCc(multiAreaSetting.getRowHeaders().size());
                            } else {
                                cellArea.setC(selector.getStartCol());
                                cellArea.setCc(selector.getEndCol() - selector.getStartCol() + 1);
                                cellArea.setR(cellArea.getR() - multiAreaSetting.getColHeaders().size() - floatOffset);
                                cellArea.setRc(multiAreaSetting.getColHeaders().size());
                            }
                            this.getSpreadContainer().setSelections(cellArea);
                            childFormView.getModel().setValue("floatrange", (Object)cellArea.toString(), Integer.parseInt(index));
                            this.getView().sendFormAction(childFormView);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private IFormView getChildFormView(String pageId) {
        IFormView mainPageView;
        IFormView childFormView = null;
        if (StringUtils.isNotEmpty((String)pageId) && (mainPageView = this.getView().getMainView()) != null) {
            childFormView = mainPageView.getView(pageId);
        }
        return childFormView;
    }

    public boolean communicateMsg() {
        if (this.isOnFloatSetting()) {
            String floatRange = (String)this.getFormCustomParam("floatrange");
            if (StringUtils.isNotEmpty((String)floatRange)) {
                RangeModel range = new RangeModel(floatRange);
                this.selectFloatRange(new SpreadSelector(range.getY_start(), range.getX_start(), range.getY_end(), range.getX_end()));
            }
        } else {
            String area = (String)this.getFormCustomParam("area");
            String msg = "";
            msg = StringUtils.isEmpty((String)area) ? ResManager.loadKDString((String)"\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractTemplateProcessPlugin_34", (String)"epm-emr-formplugin", (Object[])new Object[0]) : (area.indexOf(58) == -1 ? ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5355\u5143\u683c\u8303\u56f4\u3002", (String)"AbstractTemplateProcessPlugin_35", (String)"epm-emr-formplugin", (Object[])new Object[0]) : ExcelUtils.validateRange((String)area));
            if (StringUtils.isNotEmpty((String)msg)) {
                this.getView().showTipNotification(msg);
                this.getPageCache().put("verifyArea", FALSE);
                return false;
            }
            this.getPageCache().put("verifyArea", TRUE);
            this.setActiveDataArea(area);
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (DATAAREAS.equals(key)) {
            this.clearDimsPanelCache();
            this.setActiveDataArea((String)newValue);
            if (oldValue != null) {
                this.getSpreadContainer().getSpreadJson("showAreaSetting");
            }
            this.getPageCache().put("switchArea", TRUE);
        } else if (this.checkControlKey(key)) {
            if (newValue instanceof DynamicObject) {
                DynamicObject value = (DynamicObject)newValue;
                Long viewId = value.getDataEntityType().getProperties().containsKey((Object)"view_id") ? Long.valueOf(value.getLong("view_id")) : null;
                Map<String, String> map = this.getDynamicPageHelper().getDimMemberMessageMap(value.getLong("id"), value.getString("number"), value.getString("name"), RangeEnum.ONLY.getIndex(), QuoteTypeEnum.MEMBER.getValue(), viewId, ObjectConvertUtils.getParentNum((String)value.getString("longnumber")));
                this.getDynamicPageHelper().putDimMemberValue(key, map);
                this.syncSettingFromPanel();
            } else if (newValue == null) {
                this.getDynamicPageHelper().putDimMemberValue(key, null);
            }
        }
    }

    public void templateDataSave() {
        StringBuilder data = new StringBuilder(this.getPageCache().get("MULTISHEET_TEMPLATE_MODEL"));
        data.append(TemplateModelJSONUtil.toJsonSheetManager((ISheetManager)this.getSheetManager()));
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("epbs_textmsg");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("msg", (Object)data.toString());
        this.getView().showForm(formShowParameter);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getPageCache().get("isClose") == null && this.isDataChanged()) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6a21\u677f\u5185\u5bb9\u6539\u53d8\u4e14\u672a\u4fdd\u5b58\uff0c\u662f\u5426\u9000\u51fa\uff1f", (String)"AbstractTemplateProcessPlugin_36", (String)"epm-emr-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("isClose"));
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
            case "isClose": {
                if (!messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.getPageCache().put("isClose", TRUE);
                this.getView().close();
                break;
            }
            case "btn_del_areasetting": {
                if (MessageBoxResult.Yes != messageBoxClosedEvent.getResult()) break;
                this.deleteAreaSetting();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"AbstractTemplateListPlugin_11", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                this.setDataChanged(true);
                break;
            }
            case "drop_to_areaviewpanel": {
                if (MessageBoxResult.Yes != messageBoxClosedEvent.getResult()) break;
                this.dropConfirm = true;
                this.dealElementDrop(this.getPageCache().get(DropEventArgs));
            }
        }
    }

    public void deleteAreaSetting() {
        List areaSettings = this.getSheetManager().getAreaRanges();
        boolean isEditDataArea = this.isEditDataArea();
        ArrayList<IDataAreaSetting> removes = new ArrayList<IDataAreaSetting>(16);
        if (isEditDataArea) {
            IDataAreaSetting multiArea = this.getMultiAreaSetting();
            if (multiArea != null) {
                removes.add(multiArea);
            }
        } else {
            removes.addAll(this.getMultiAreaSettingsBySelect());
        }
        String nextArea = "";
        if (CollectionUtils.isNotEmpty(removes)) {
            MarkSpecialCellHelper.cacheOldSpread(this.getPageCache(), this.getSheetManager());
            areaSettings.removeIf(f -> removes.stream().anyMatch(m -> m.getAreaRange().equals(f.getAreaRange())));
            this.cacheSheetManager();
            this.getTemplateModel().setSheetManager(this.getSheetManager());
            this.cacheTemplateModel();
            if (isEditDataArea && CollectionUtils.isNotEmpty((Collection)areaSettings)) {
                nextArea = ((IDataAreaSetting)areaSettings.get(0)).getAreaRange();
            }
        }
        if (isEditDataArea) {
            if (StringUtils.isNotEmpty((String)nextArea)) {
                this.loadDataAreaComboItems(areaSettings, nextArea, true);
                this.setActiveDataArea(nextArea);
                this.getSpreadContainer().getSpreadJson("showAreaSetting");
            } else {
                this.switchView(VIEW_DEFAULT);
            }
        }
        MarkSpecialCellHelper.drawMarkPoint(this.getPageCache(), this.getView(), this.getSheetManager(), this.getSpreadKey(), true, true);
    }

    protected boolean isDataChanged() {
        String ischanged = this.getPageCache().get(ISDATACHANGED);
        return ischanged == null ? false : Boolean.parseBoolean(ischanged);
    }

    protected void setDataChanged(boolean dataChanged) {
        this.getPageCache().put(ISDATACHANGED, String.valueOf(dataChanged));
    }

    protected boolean checkControlKey(String controlKey) {
        if (StringUtils.isEmpty((String)controlKey) || controlKey.endsWith("_id")) {
            return false;
        }
        return controlKey.contains("!");
    }

    protected void initDimsPanel(boolean isInit) {
        if (this.hasInitDimsPanel) {
            return;
        }
        Page page = new Page();
        page.setChangeable(true);
        if (isInit) {
            this.getDynamicPageHelper().cleanAllPoint();
        }
        if (this.isRelation()) {
            this.addArea(isInit ? this.getRelationEntry() : null, page, COLDIMPANEL);
        } else {
            this.addArea(isInit ? this.getRowColEntry(false) : null, page, COLDIMPANEL);
            this.addArea(isInit ? this.getRowColEntry(true) : null, page, ROWDIMPANEL);
            this.addArea(isInit ? this.getViewEntry() : null, page, AREAVIEWPANEL);
        }
        this.commomAction(page);
        this.hasInitDimsPanel = true;
    }

    protected void addArea(List<String> dimNumbers, Page page, String panelSign) {
        List<Map<String, String>> list;
        if (dimNumbers == null) {
            List<Map<String, String>> allp = this.getDynamicPageHelper().getAllPoint();
            list = allp.stream().filter(e -> panelSign.equals(e.get("panel"))).collect(Collectors.toList());
        } else {
            list = dimNumbers.stream().map(e -> {
                Map<String, String> viewValue;
                QuoteTypeEnum signType = this.getSignType((String)e);
                Map<String, String> map = signType == QuoteTypeEnum.MEMBER ? this.getDimItemMap(panelSign, (String)e) : (signType == QuoteTypeEnum.PROPERTY ? this.getPropertyItemMap(panelSign, (String)e) : this.getFieldItemMap(panelSign, (String)e));
                if (AREAVIEWPANEL.equals(panelSign) && MapUtils.isNotEmpty(viewValue = this.getDynamicPageHelper().getDimMemberValueMap(map.get("sign")))) {
                    map.put("value", viewValue.get("id"));
                }
                return map;
            }).collect(Collectors.toList());
            this.getDynamicPageHelper().cacheAllPoint(list);
        }
        this.addArea(page, list, panelSign);
    }

    @Override
    public Element addAreaElement(Area area, Map<String, String> map, String panelSign) {
        String name = map.get("name");
        String elementSign = map.get("sign");
        String entityNumber = map.get("entity");
        Element element = null;
        switch (panelSign) {
            case "areaviewpanel": {
                element = this.getDynamicElememt(name, elementSign, entityNumber, BaseEditElement.class);
                element.setCustomStyle(ap -> {
                    this.defaultStyle((ControlAp)ap);
                    ((EntryFieldAp)ap).setFieldStyle(2);
                    ap.setHeight(new LocaleString("30px"));
                    ap.setWidth(new LocaleString("92%"));
                    this.getDynamicPageHelper().setStyleZero((ControlAp)ap);
                    ap.getStyle().getMargin().setLeft("10px");
                    ap.getStyle().getMargin().setTop("5px");
                });
                break;
            }
            case "rowdimpanel": 
            case "coldimpanel": {
                element = this.getDynamicElememt(name, elementSign, entityNumber, TextEditElement.class);
                ((TextEditElement)element).setFieldStyle(2);
                ((TextEditElement)element).setEditStyle(0);
                element.setLock("new,edit");
                element.setCustomStyle(ap -> {
                    this.defaultStyle((ControlAp)ap);
                    ((FieldAp)ap).setShowTitle(false);
                    ap.setTextAlign("center");
                    ap.setWidth(new LocaleString((name != null ? name.length() * 12 + 40 : 50) + "px"));
                    ap.setHeight(new LocaleString("30px"));
                    this.getDynamicPageHelper().setStyleZero((ControlAp)ap);
                    ap.getStyle().getMargin().setTop("5px");
                    if (!this.isProperty(elementSign)) {
                        ap.setFontWeight("bold");
                        ((FieldAp)ap).setFieldBackColor("#ffffff");
                    }
                });
            }
        }
        if (element != null) {
            area.addElement(element);
        }
        return element;
    }

    @Override
    public Object initElementValue(Map<String, String> map) {
        Map<String, String> memberMap;
        String panelSign = map.get("panel");
        Object value = map.get("value");
        if (ROWDIMPANEL.equals(panelSign) || COLDIMPANEL.equals(panelSign)) {
            value = map.get("name");
        }
        if (AREAVIEWPANEL.equals(panelSign) && MapUtils.isNotEmpty(memberMap = this.getDynamicPageHelper().getDimMemberValueMap(map.get("sign")))) {
            value = IDUtils.toLong((Object)memberMap.get("id"));
        }
        return value;
    }

    protected boolean isProperty(String sign) {
        return QuoteTypeEnum.PROPERTY == this.getSignType(sign);
    }

    protected QuoteTypeEnum getSignType(String sign) {
        if (StringUtils.isNotEmpty((String)sign)) {
            String[] p = sign.split("!");
            if (p.length == 2) {
                return QuoteTypeEnum.getByValule((String)p[1]);
            }
            return this.getDynamicPageHelper().getSignType(sign);
        }
        return null;
    }

    protected void dealElementDrop(String eventArgs) {
        if (StringUtils.isEmpty((String)eventArgs)) {
            return;
        }
        String[] msg = DragUtil.translateMessage((String)eventArgs);
        String target = msg[0];
        String source = msg[1];
        if (!this.checkControlKey(source) || this.getControl(source) == null) {
            return;
        }
        this.getPageCache().put(DropEventArgs, eventArgs);
        if (this.beforeElementDrop(target, source)) {
            List<Map<String, String>> mapList = this.getDynamicPageHelper().getAllPoint();
            this.elementDrop(source, target, mapList);
            this.getDynamicPageHelper().updateAllPoint(mapList);
            this.initDimsPanel(false);
            this.getModel().setDataChanged(true);
            this.afterElementDrop(target, source);
        }
        MarkSpecialCellHelper.drawMarkPoint(this.getPageCache(), this.getView(), this.getSheetManager(), this.getSpreadKey(), true, true);
    }

    protected void loadDataAreaComboItems(List<IDataAreaSetting> existingAreas, String areaRange, boolean flag) {
        if (flag) {
            ComboEdit comboEdit = (ComboEdit)this.getControl(DATAAREAS);
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
            items.add(new ComboItem(new LocaleString(areaRange), areaRange));
            if (CollectionUtils.isNotEmpty(existingAreas)) {
                existingAreas.forEach(m -> {
                    if (!m.getAreaRange().equals(areaRange)) {
                        items.add(new ComboItem(new LocaleString(m.getAreaRange()), m.getAreaRange()));
                    }
                });
            }
            Comparator<ComboItem> firstComparator = Comparator.comparingInt(c -> new RangeModel(c.getValue()).getY_start());
            Comparator<ComboItem> thanComparator = Comparator.comparingInt(c -> new RangeModel(c.getValue()).getX_start());
            items.sort(firstComparator.thenComparing(thanComparator));
            comboEdit.setComboItems(items);
        }
        this.getModel().setValue(DATAAREAS, (Object)areaRange);
    }

    protected boolean beforeElementDrop(String target, String source) {
        String targetPanel = this.getDynamicPageHelper().getPanelForEventArgs(target);
        String sourcePanel = this.getDynamicPageHelper().getPanelForEventArgs(source);
        if (!DropPanel.contains(targetPanel) || !DropPanel.contains(sourcePanel)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u533a\u57df\u4e0d\u5141\u8bb8\u62d6\u62fd\u3002", (String)"AbstractTemplateProcessPlugin_37", (String)"epm-emr-formplugin", (Object[])new Object[0]));
        }
        if (this.isProperty(source) && !Objects.equals(sourcePanel, targetPanel)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5c5e\u6027\u63a7\u4ef6\u4e0d\u5141\u8bb8\u62d6\u52a8\u5230\u5176\u4ed6\u9762\u677f\u3002", (String)"AbstractTemplateProcessPlugin_38", (String)"epm-emr-formplugin", (Object[])new Object[0]));
        }
        if (!Objects.equals(sourcePanel, targetPanel) && (CollectionUtils.isNotEmpty((Collection)this.getMultiAreaSetting().getFloatInfos()) || this.isOnFloatSetting())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u533a\u57df\u5df2\u8bbe\u7f6e\u6d6e\u52a8\uff0c\u4e0d\u5141\u8bb8\u62d6\u52a8\u5230\u5176\u4ed6\u9762\u677f\u3002", (String)"AbstractTemplateProcessPlugin_39", (String)"epm-emr-formplugin", (Object[])new Object[0]));
        }
        if (!Objects.equals(sourcePanel, targetPanel) && (ROWDIMPANEL.equals(sourcePanel) || COLDIMPANEL.equals(sourcePanel))) {
            List<Map<String, String>> allPoint = this.getDynamicPageHelper().getAllPoint();
            long sourceDimCount = this.getDynamicPageHelper().getAllPoint(allPoint, sourcePanel).stream().filter(e -> !this.isProperty((String)e.get("sign"))).count();
            long targetDimCount = this.getDynamicPageHelper().getAllPoint(allPoint, targetPanel).stream().filter(e -> !this.isProperty((String)e.get("sign"))).count();
            if (sourceDimCount == 1L && targetDimCount == 1L && !AREAVIEWPANEL.equals(targetPanel)) {
                this.exchangeElement = true;
            } else if (sourceDimCount == 1L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u884c\u7ef4\u548c\u5217\u7ef4\u81f3\u5c11\u9700\u8981\u6709\u4e00\u4e2a\u7ef4\u5ea6\u3002", (String)"AbstractTemplateProcessPlugin_40", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            }
        }
        if (!this.dropConfirm && !Objects.equals(sourcePanel, targetPanel) && (ROWDIMPANEL.equals(sourcePanel) || COLDIMPANEL.equals(sourcePanel)) && AREAVIEWPANEL.equals(targetPanel)) {
            List headerInfos = ROWDIMPANEL.equals(sourcePanel) ? this.getMultiAreaSetting().getRowHeaders() : this.getMultiAreaSetting().getColHeaders();
            Map<String, String> dimMap = this.getDynamicPageHelper().getPointBySign(source);
            IHeaderInfo headerInfo = headerInfos.stream().filter(e -> Objects.equals(e.getNumber(), dimMap.get("number"))).findFirst().orElseGet(() -> null);
            if (null != headerInfo && CollectionUtils.isNotEmpty((Collection)headerInfo.getHeaderObjects().stream().filter(e -> null != e && StringUtils.isNotEmpty((String)e.getNumber())).collect(Collectors.toList()))) {
                String msg = ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u5ea6\u8c03\u6574\u5230\u533a\u57df\u9690\u85cf\uff0c\u5bf9\u5e94\u7ef4\u5ea6\u8bbe\u7f6e\u7684\u6210\u5458\u5c06\u81ea\u52a8\u6e05\u9664\uff0c\u786e\u5b9a\u8981\u6267\u884c\u8c03\u6574\u5417\uff1f", (String)"AbstractTemplateProcessPlugin_41", (String)"epm-emr-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("drop_to_areaviewpanel", (IFormPlugin)this));
                return false;
            }
        }
        return true;
    }

    protected String elementDrop(String source, String target, List<Map<String, String>> mapList) {
        String targetPanel = this.getDynamicPageHelper().getPanelForEventArgs(target);
        String sourcePanel = this.getDynamicPageHelper().getPanelForEventArgs(source);
        List<String> targetAllSigns = this.getDynamicPageHelper().getAllPoint(mapList, targetPanel).stream().map(e -> (String)e.get("sign")).collect(Collectors.toList());
        String elementSign = this.getDynamicPageHelper().elementDrop(source, target, mapList, this);
        if (!Objects.equals(sourcePanel, targetPanel)) {
            List<String> delProperty;
            List<String> sorlist = mapList.stream().filter(e -> sourcePanel.equals(e.get("panel"))).map(e -> this.convertSign((Map<String, String>)e)).collect(Collectors.toList());
            if (AREAVIEWPANEL.equals(targetPanel)) {
                delProperty = this.clearPropertyByHasPropertyDimDrop(source, sorlist);
                mapList.removeIf(e -> sourcePanel.equals(e.get("panel")) && delProperty.contains(this.convertSign((Map<String, String>)e)));
            } else {
                delProperty = this.getPropertyByHasPropertyDimDrop(source, sorlist);
                delProperty.forEach(e -> this.getDynamicPageHelper().elementDrop(this.reverseConvertSign(sourcePanel, (String)e), target, mapList, this));
                if (this.exchangeElement) {
                    targetAllSigns.forEach(e -> this.getDynamicPageHelper().elementDrop((String)e, sourcePanel, mapList, this));
                }
            }
        }
        List collist = mapList.stream().filter(e -> COLDIMPANEL.equals(e.get("panel"))).map(e -> this.convertSign((Map<String, String>)e)).collect(Collectors.toList());
        List rowlist = mapList.stream().filter(e -> ROWDIMPANEL.equals(e.get("panel"))).map(e -> this.convertSign((Map<String, String>)e)).collect(Collectors.toList());
        List viewlist = mapList.stream().filter(e -> AREAVIEWPANEL.equals(e.get("panel"))).map(e -> this.convertSign((Map<String, String>)e)).collect(Collectors.toList());
        this.getPageCache().put(COL, SerializationUtils.toJsonString(collist));
        this.getPageCache().put(ROW, SerializationUtils.toJsonString(rowlist));
        this.getPageCache().put(VIEW, SerializationUtils.toJsonString(viewlist));
        return elementSign;
    }

    protected void afterElementDrop(String target, String source) {
        this.needRepaint();
        this.syncSettingFromPanel();
    }

    protected String getAreaCacheKey() {
        String result = "CacheDimPropertySelected_" + this.getActiveDataArea();
        return result;
    }

    protected String getAreaCacheKey(String area) {
        String result = "CacheDimPropertySelected_" + area;
        return result;
    }

    protected List<IDimension> getRankDim() {
        if (CollectionUtils.isEmpty((Collection)this.getTemplateModel().getRowcolDims())) {
            return null;
        }
        List dimNumbers = this.getTemplateModel().getRowcolDims();
        return this.getAllDimsCache().stream().filter(e -> dimNumbers.contains(e.getNumber())).collect(Collectors.toList());
    }

    protected RelationModelBean getRelationModelBean(Long relaModelId) {
        if (this.relationModelBean == null && this.isRelation()) {
            this.relationModelBean = this.getTemplateMemberService().getRelationModel(relaModelId);
        }
        return this.relationModelBean;
    }

    protected Map<String, FieldBean> getRelaFieldMap() {
        if (this.relaFieldMap == null) {
            RelationModelBean bean = this.getRelationModelBean(this.getCurrentBizModelId());
            this.relaFieldMap = null != bean ? bean.getFieldBeanMap() : Maps.newHashMap();
        }
        return this.relaFieldMap;
    }

    protected List<String> getRowColEntry(boolean isRow) {
        String rowCOl;
        String string = rowCOl = isRow ? ROW : COL;
        if (this.getPageCache().get(rowCOl) == null) {
            ArrayList<String> list = new ArrayList<String>();
            IDataAreaSetting ae = this.getMultiAreaSetting();
            List<IDimension> rank = this.getRankDim();
            if (ae == null) {
                rank.remove(rank.size() - 1);
                rank.forEach(e -> this.setDimInfoMapCache(e, list));
            } else {
                List rowColHeaders;
                List list2 = rowColHeaders = isRow ? ae.getRowHeaders() : ae.getColHeaders();
                if (CollectionUtils.isNotEmpty((Collection)rowColHeaders)) {
                    for (IHeaderInfo headerInfo : rowColHeaders) {
                        if ("Dimension".equals(headerInfo.getType())) {
                            this.setDimInfoMapCache(this.getDimByNumber(headerInfo.getNumber()), list);
                            continue;
                        }
                        if (!"Property".equals(headerInfo.getType())) continue;
                        this.setDimInfoMapCache(this.getPropertyByNumber(headerInfo.getNumber()), list);
                    }
                } else {
                    List dims = isRow ? ae.getRowdims() : ae.getColdims();
                    dims.forEach(e -> this.setDimInfoMapCache(this.getDimByNumber((String)e), list));
                }
            }
            this.getPageCache().put(rowCOl, SerializationUtils.toJsonString(list));
            this.getPageCache().put(allname, SerializationUtils.toJsonString(this.getNameMap()));
            this.getPageCache().put(CACHE_ALL_NUMBER, SerializationUtils.toJsonString(this.getNumberMap()));
        }
        List rp = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(rowCOl), List.class);
        return rp;
    }

    protected List<String> getViewEntry() {
        if (this.getPageCache().get(VIEW) == null) {
            ArrayList list = Lists.newArrayList();
            IDataAreaSetting ae = this.getMultiAreaSetting();
            if (ae != null && ae.getAreaViewpointmembentry() != null && !ae.getAreaViewpointmembentry().isEmpty()) {
                for (IViewPointDimensionEntry viewPointDimensionEntry : ae.getAreaViewpointmembentry()) {
                    IBaseEntry member;
                    IDimension dimension = this.getDimByNumber(viewPointDimensionEntry.getDimension().getNumber());
                    if (dimension == null) continue;
                    String cacheKey = this.setDimInfoMapCache(dimension, list);
                    if (viewPointDimensionEntry.getMember() == null || null == (member = this.getTemplateMemberService().getMemberEntry(QuoteTypeEnum.MEMBER, dimension.getNumber(), viewPointDimensionEntry.getMember().getNumber(), (Object)viewPointDimensionEntry.getMember().getViewNumber()))) continue;
                    Long viewId = member instanceof IDimensionMember ? ((IDimensionMember)member).getViewId() : null;
                    this.getDynamicPageHelper().putDimMemberValue(this.reverseConvertSign(AREAVIEWPANEL, cacheKey), this.getDynamicPageHelper().getDimMemberMessageMap(member.getId(), member.getNumber(), member.getName(), RangeEnum.ONLY.getIndex(), viewPointDimensionEntry.getMember().getType(), viewId, null));
                }
                this.getPageCache().put(VIEW, SerializationUtils.toJsonString((Object)list));
                this.getPageCache().put(allname, SerializationUtils.toJsonString(this.getNameMap()));
                this.getPageCache().put(CACHE_ALL_NUMBER, SerializationUtils.toJsonString(this.getNumberMap()));
                return list;
            }
            return new ArrayList<String>(16);
        }
        List cp = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(VIEW), List.class);
        return cp;
    }

    protected List<String> getRelationEntry() {
        String cacheKey = COL;
        if (this.getPageCache().get(cacheKey) == null) {
            ArrayList<String> list = new ArrayList<String>();
            IDataAreaSetting ae = this.getMultiAreaSetting();
            if (ae == null) {
                List<FieldBean> rank = this.getRelaFieldMap().entrySet().stream().map(e -> (FieldBean)e.getValue()).collect(Collectors.toList());
                rank.remove(rank.size() - 1);
                rank.forEach(e -> this.setDimInfoMapCache(e, list));
            } else {
                List rowColHeaders = ae.getColHeaders();
                if (CollectionUtils.isNotEmpty((Collection)rowColHeaders)) {
                    for (IHeaderInfo headerInfo : rowColHeaders) {
                        if ("RelField".equals(headerInfo.getType())) {
                            this.setDimInfoMapCache(this.getRelaFieldMap().get(headerInfo.getNumber()), list);
                            continue;
                        }
                        if (!"Property".equals(headerInfo.getType())) continue;
                    }
                } else {
                    List dims = ae.getColdims();
                    dims.forEach(e -> this.setDimInfoMapCache(this.getDimByNumber((String)e), list));
                }
            }
            this.getPageCache().put(cacheKey, SerializationUtils.toJsonString(list));
            this.getPageCache().put(allname, SerializationUtils.toJsonString(this.getNameMap()));
            this.getPageCache().put(CACHE_ALL_NUMBER, SerializationUtils.toJsonString(this.getNumberMap()));
        }
        List rp = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(cacheKey), List.class);
        return rp;
    }

    protected List<String> getRelationEntryNumbers() {
        List<String> entries = this.getRelationEntry();
        Map<String, String> numberMap = this.getNumberMap();
        return entries.stream().map(e -> (String)numberMap.get(e)).collect(Collectors.toList());
    }

    protected String getItemCacheKey(String number, QuoteTypeEnum type) {
        number = null != number ? number.toLowerCase() : null;
        type = null != type ? type : QuoteTypeEnum.MEMBER;
        return EPM_PREFIX + number + "!" + type.getValue();
    }

    protected String setDimInfoMapCache(Object entry, List<String> list) {
        if (null == entry) {
            return null;
        }
        String cacheKey = "";
        String number = "";
        String name = "";
        if (entry instanceof IDimension) {
            cacheKey = this.getItemCacheKey(((IDimension)entry).getNumber(), QuoteTypeEnum.MEMBER);
            number = ((IBaseEntry)entry).getNumber();
            name = ((IBaseEntry)entry).getName();
        } else if (entry instanceof PropertyEntry) {
            cacheKey = this.getPropertySign((PropertyEntry)entry);
            number = ((IBaseEntry)entry).getNumber();
            name = ((IBaseEntry)entry).getName();
        } else if (entry instanceof FieldBean) {
            cacheKey = this.getItemCacheKey(((FieldBean)entry).getNumber(), QuoteTypeEnum.FIELD);
            number = ((FieldBean)entry).getNumber();
            String nameObj = ((FieldBean)entry).getName();
            if (nameObj instanceof String) {
                name = nameObj;
            }
        }
        list.add(cacheKey);
        this.getNameMap().put(cacheKey, name);
        this.getNumberMap().put(cacheKey, number);
        return cacheKey;
    }

    private Map<String, String> getCacheMap(String cacheKey) {
        HashMap<String, String> map = null;
        String seria = this.getPageCache().get(cacheKey);
        if (StringUtils.isEmpty((String)seria)) {
            map = new HashMap(16);
            this.getPageCache().put(cacheKey, SerializationUtils.toJsonString(map));
        } else {
            map = (Map)SerializationUtils.fromJsonString((String)seria, Map.class);
        }
        return map;
    }

    protected Map<String, String> getNameMap() {
        if (this.nameMap == null) {
            this.nameMap = this.getCacheMap(allname);
        }
        return this.nameMap;
    }

    protected Map<String, String> getNumberMap() {
        if (this.numberMap == null) {
            this.numberMap = this.getCacheMap(CACHE_ALL_NUMBER);
        }
        return this.numberMap;
    }

    protected String convertSign(Map<String, String> map) {
        QuoteTypeEnum type = this.getDynamicPageHelper().getSignType(map.get("sign"));
        if (type == QuoteTypeEnum.PROPERTY) {
            PropertyEntry prop = this.getPropertyByNumber(map.get("number"));
            String refNumber = null != prop ? prop.getRefDimNumber() : "";
            return this.getPropertySign(map.get("number"), refNumber);
        }
        return this.getItemCacheKey(map.get("number"), type);
    }

    protected String reverseConvertSign(String panelSign, String sign) {
        String convertSign = null;
        QuoteTypeEnum type = this.getSignType(sign);
        switch (type) {
            case PROPERTY: {
                convertSign = this.getPropertyItemMap(panelSign, sign).get("sign");
                break;
            }
            case MEMBER: {
                convertSign = this.getDimItemMap(panelSign, sign).get("sign");
                break;
            }
            case FIELD: {
                convertSign = this.getFieldItemMap(panelSign, sign).get("sign");
            }
        }
        return convertSign;
    }

    protected String getPropertySign(String propertyNumber, String dimNumber) {
        PropertyEntry property = new PropertyEntry(null, null, propertyNumber);
        property.setRefDimNumber(dimNumber);
        return this.getPropertySign(property);
    }

    protected String getPropertySign(PropertyEntry property) {
        if (property == null) {
            return "";
        }
        return String.join((CharSequence)UNDERSCORE, this.getPropertyEntity(), property.getNumber().toLowerCase(), property.getRefDimNumber().toLowerCase(), "!" + QuoteTypeEnum.PROPERTY.getValue());
    }

    protected Map<String, String> getDimItemMap(String panelSign, String dimNumber) {
        IDimension dimension = this.getDimByNumber(this.getNumberMap().get(dimNumber));
        if (dimension == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6%s\u4e0d\u5b58\u5728\u3002", (String)"AbstractTemplateProcessPlugin_42", (String)"epm-emr-formplugin", (Object[])new Object[]{dimNumber}));
        }
        return this.getDynamicPageHelper().getDimMessageMap(panelSign, dimension);
    }

    protected Map<String, String> getPropertyItemMap(String panelSign, String propertyNumber) {
        PropertyEntry property = this.getPropertyByNumber(this.getNumberMap().get(propertyNumber));
        if (property == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u5c5e\u6027%s\u4e0d\u5b58\u5728\u3002", (String)"AbstractTemplateProcessPlugin_43", (String)"epm-emr-formplugin", (Object[])new Object[]{this.getNumberMap().get(propertyNumber)}));
        }
        return this.getDynamicPageHelper().getPropertyMessageMap(panelSign, property, this.getPropertyEntity());
    }

    protected Map<String, String> getFieldItemMap(String panelSign, String fieldNumber) {
        FieldBean field = this.getRelaFieldMap().get(this.getNumberMap().get(fieldNumber));
        if (field == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5173\u7cfb\u5b57\u6bb5%s\u4e0d\u5b58\u5728\u3002", (String)"AbstractTemplateProcessPlugin_44", (String)"epm-emr-formplugin", (Object[])new Object[]{this.getNumberMap().get(fieldNumber)}));
        }
        return this.getDynamicPageHelper().getFieldMessageMap(panelSign, field);
    }

    protected List<String> clearPropertyByHasPropertyDimDrop(String source, List<String> sorlist) {
        List<String> delProperty = this.getPropertyByHasPropertyDimDrop(source, sorlist);
        if (CollectionUtils.isEmpty(delProperty)) {
            return delProperty;
        }
        String sourceNumber = this.getDynamicPageHelper().getPointBySign(source).get("number");
        String areaCacheKey = this.getAreaCacheKey();
        String propertyCache = this.getPageCache().get(areaCacheKey);
        if (StringUtils.isNotEmpty((String)propertyCache)) {
            List propertyMap = (List)SerializationUtils.fromJsonString((String)propertyCache, List.class);
            propertyMap.removeIf(e -> sourceNumber.equals(e.get("dimnum")));
            this.getPageCache().put(areaCacheKey, SerializationUtils.toJsonString((Object)propertyMap));
        }
        return delProperty;
    }

    protected List<String> getPropertyByHasPropertyDimDrop(String source, List<String> sorlist) {
        ArrayList delProperty = Lists.newArrayList();
        if (source == null || sorlist == null) {
            return delProperty;
        }
        Set hasPropertyDimNumberSet = this.getTemplateMemberService().getAllPropertyRefDimNumbers(this.getTemplateModel().getBizModelId());
        String sourceNumber = this.getDynamicPageHelper().getPointBySign(source).get("number");
        if (!this.isProperty(source) && hasPropertyDimNumberSet.contains(sourceNumber)) {
            sorlist.forEach(e -> {
                PropertyEntry propertyEntry;
                if (this.isProperty((String)e) && (propertyEntry = this.getPropertyByNumber(this.getNumberMap().get(e))) != null && sourceNumber.equals(propertyEntry.getRefDimNumber())) {
                    delProperty.add(e);
                }
            });
        }
        return delProperty;
    }

    protected String getViewNumber(Long viewId) {
        if (IDUtils.isNull((Long)viewId)) {
            return null;
        }
        ViewBean view = this.getTemplateMemberService().getView(viewId);
        return null != view ? view.getNumber() : null;
    }

    protected Long getMemberF7ViewId(String f7Key) {
        Long viewId = IDUtils.toLong((Object)this.getPageCache().get(f7Key + "viewId"));
        return viewId;
    }

    protected String getTemplateShowType(ISheetManager sm) {
        TemplateShowTypeEnum type = TemplateShowTypeEnum.ONLY_TABLE;
        int areaCount = sm.getAreaRanges().size();
        int floatCount = 0;
        int relationCount = 0;
        for (IDataAreaSetting areaSetting : sm.getAreaRanges()) {
            if (CollectionUtils.isNotEmpty((Collection)areaSetting.getFloatInfos())) {
                ++floatCount;
            }
            if (!areaSetting.isRelation()) continue;
            ++relationCount;
        }
        if (floatCount == 0 && relationCount == 0 && areaCount > 0) {
            type = TemplateShowTypeEnum.FIX;
        } else if (floatCount > 0) {
            type = TemplateShowTypeEnum.FIX_FLOAT;
        } else if (relationCount > 0) {
            type = TemplateShowTypeEnum.FIX_RELA;
        } else if (this.getMultiSheetTemplateModel().getSheetNames().size() > 1) {
            type = TemplateShowTypeEnum.MULTI_SHEET;
        }
        return type.getValue();
    }

    protected void writeSaveLog(T template, boolean isAdd) {
        String version = TemplateVersionHelper.formatVersionNumber(template.getVersionNumber());
        OperationTypeEnum op = isAdd ? OperationTypeEnum.ADD : OperationTypeEnum.UPDATE;
        OperationLogUtil.writeLog((String)this.getBizAppId(), (String)template.getDataEntityNumber(), (IOperationTypeInfo)op, (MultiLangEnumBridge)OperationMsgUtil.getSaveSucTipWithNumber((String)template.getNumber()), (Long)this.getModelId());
    }
}

