/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.epm.epbs.common.model.PropertyEntry;
import kd.epm.epbs.common.util.IDUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class DimPropertySetting
extends AbstractFormPlugin
implements ClickListener,
BeforeF7SelectListener,
TreeNodeClickListener,
RowClickEventListener,
F7SelectedListRemoveListener {
    private static final String tree_dim = "dimtree";
    private static final String entry_Property = "propertyentity";
    private static final String CUSTOMPROPERTY = "customproperty";
    private static final String DIMENSION = "dimension";
    private static final String DIMENSION_NUMBER = "dimension_number";
    private static final String DIMENSION_NAME = "dimension_name";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String btn_OK = "btnok";
    private static final String f7selected_property = "f7selproperty";
    private static final String Cache_F7SelectedFlag = "CacheF7SelectedFlag";
    private static final String Cache_TreeModel = "CacheTreeModel";
    private static final String splitStr = "#";
    public static final String ROOT = "root";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{btn_OK});
        TreeView tree = (TreeView)this.getControl(tree_dim);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        EntryGrid propertyGrid = (EntryGrid)this.getControl(entry_Property);
        propertyGrid.addRowClickListener((RowClickEventListener)this);
        F7SelectedList selectedList = (F7SelectedList)this.getControl(f7selected_property);
        selectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        selectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initDimPropertyData();
        this.loadDimTree();
        this.initPropertyData();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        TreeView tree = (TreeView)evt.getSource();
        String key = tree.getKey();
        String focusNodeId = (String)evt.getNodeId();
        if (StringUtils.isEmpty((String)focusNodeId) || ROOT.equals(focusNodeId)) {
            this.getModel().deleteEntryData(entry_Property);
            return;
        }
        if (tree_dim.equals(key)) {
            this.loadCustomProperty(focusNodeId);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.saveF7items();
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        String key = ((EntryGrid)evt.getSource()).getKey();
        int row = evt.getRow();
        if (entry_Property.equals(key)) {
            this.rowClick(key, row);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent var1) {
    }

    public void RemoveClick(F7SelectedListRemoveEvent evt) {
        String selfOpFlag = this.isF7SelectedOp();
        Object param = evt.getParam();
        if ("1".equals(selfOpFlag)) {
            if (param == null) {
                this.deSelectRow(null);
            } else {
                this.deSelectRow(param.toString());
            }
        }
        if (param == null) {
            this.getPageCache().remove("CacheDimPropertySelected");
        } else {
            String removeIds = param.toString();
            List<String> removeIdList = Collections.singletonList(removeIds);
            this.removePropertySelected(removeIdList);
        }
    }

    private void deSelectRow(String rowKey) {
        EntryGrid propertyGrid = (EntryGrid)this.getControl(entry_Property);
        if (this.getModel().getEntryEntity(entry_Property) == null || this.getModel().getEntryEntity(entry_Property).size() == 0) {
            return;
        }
        int rowCount = this.getModel().getEntryEntity(entry_Property).size();
        int[] rowArr = propertyGrid.getSelectRows();
        List<Integer> rowList = this.getRowIdList(rowArr);
        ArrayList<Integer> selRowList = new ArrayList<Integer>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject curRow = this.getModel().getEntryRowEntity(entry_Property, i);
            String propertyId = curRow.getString(CUSTOMPROPERTY);
            String dimensionId = curRow.getString(DIMENSION);
            if (propertyId == null) continue;
            String keyStr = dimensionId + splitStr + propertyId;
            if (StringUtils.isEmpty((String)rowKey) || keyStr.equals(rowKey) || !rowList.contains(i)) continue;
            selRowList.add(i);
        }
        if (selRowList.size() > 0) {
            int[] selRowArr = selRowList.stream().mapToInt(Integer::valueOf).toArray();
            propertyGrid.selectRows(selRowArr, selRowArr[0]);
        } else {
            propertyGrid.selectRows(-1);
        }
    }

    private void setSelectRow() {
        String f7SelectedStr = this.getPageCache().get("CacheDimPropertySelected");
        if (StringUtils.isEmpty((String)f7SelectedStr)) {
            return;
        }
        List f7items = (List)SerializationUtils.fromJsonString((String)f7SelectedStr, List.class);
        List<String> keyList = f7items.stream().map(map -> (String)map.get("key")).collect(Collectors.toList());
        this.setSelectRow(keyList);
    }

    private void setSelectRow(List<String> rowKeys) {
        EntryGrid propertyGrid = (EntryGrid)this.getControl(entry_Property);
        if (this.getModel().getEntryEntity(entry_Property) == null || this.getModel().getEntryEntity(entry_Property).size() == 0) {
            return;
        }
        int rowCount = this.getModel().getEntryEntity(entry_Property).size();
        ArrayList<Integer> selRowList = new ArrayList<Integer>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            String keyStr;
            DynamicObject curRow = this.getModel().getEntryRowEntity(entry_Property, i);
            String propertyId = curRow.getString(CUSTOMPROPERTY);
            String dimensionId = curRow.getString(DIMENSION);
            if (StringUtils.isEmpty((String)propertyId) || StringUtils.isEmpty((String)dimensionId) || !rowKeys.contains(keyStr = dimensionId + splitStr + propertyId)) continue;
            selRowList.add(i);
        }
        if (selRowList.size() > 0) {
            int[] selRowArr = selRowList.stream().mapToInt(Integer::valueOf).toArray();
            propertyGrid.selectRows(selRowArr, selRowArr[0]);
        }
    }

    private void loadDimTree() {
        List<Map<String, String>> dims = this.getCurDims();
        if (dims.size() == 0) {
            return;
        }
        TreeView treeView = (TreeView)this.getControl(tree_dim);
        TreeNode root = new TreeNode("", ROOT, ResManager.loadKDString((String)"\u7ef4\u5ea6", (String)"DimPropertySetting_0", (String)"epm-emr-formplugin", (Object[])new Object[0]));
        root.setIsOpened(Boolean.TRUE.booleanValue());
        for (Map<String, String> dim : dims) {
            root.addChild(new TreeNode(ROOT, dim.get(NUMBER) + splitStr + dim.get("id"), dim.get(NAME)));
        }
        treeView.deleteAllNodes();
        treeView.addNode(root);
        treeView.setRootVisible(false);
        String treeNodeStr = SerializationUtils.toJsonString((Object)root);
        this.getPageCache().put(Cache_TreeModel, treeNodeStr);
        treeView.focusNode((TreeNode)root.getChildren().get(0));
        TreeView tree = (TreeView)this.getControl(tree_dim);
        TreeNodeEvent event = new TreeNodeEvent((Object)tree, (Object)root.getId(), (Object)((TreeNode)root.getChildren().get(0)).getId());
        this.treeNodeClick(event);
    }

    private void loadCustomProperty(String nodeId) {
        this.getModel().deleteEntryData(entry_Property);
        if (StringUtils.isEmpty((String)nodeId) || !nodeId.contains(splitStr)) {
            return;
        }
        List<PropertyEntry> allProps = this.getAllProps();
        if (CollectionUtils.isEmpty(allProps)) {
            return;
        }
        HashMap dimNumberNames = new HashMap(16);
        List<Map<String, String>> dims = this.getCurDims();
        dims.forEach(e -> dimNumberNames.put(e.get(NUMBER), e.get(NAME)));
        String[] nodeSplit = nodeId.split(splitStr);
        String dimNumber = nodeSplit[0];
        Long dimId = IDUtils.toLong((Object)nodeSplit[1]);
        List dimProps = allProps.stream().filter(e -> dimNumber.equals(e.getRefDimNumber())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(dimProps)) {
            int[] rows = this.getModel().batchCreateNewEntryRow(entry_Property, dimProps.size());
            int index = 0;
            for (int row : rows) {
                PropertyEntry propertyEntry = (PropertyEntry)dimProps.get(index);
                DynamicObject entryRow = this.getModel().getEntryRowEntity(entry_Property, row);
                entryRow.set(CUSTOMPROPERTY, (Object)propertyEntry.getId());
                entryRow.set(DIMENSION, (Object)dimId);
                entryRow.set(DIMENSION_NUMBER, (Object)dimNumber);
                entryRow.set(DIMENSION_NAME, dimNumberNames.get(dimNumber));
                entryRow.set(NAME, (Object)propertyEntry.getName());
                entryRow.set(NUMBER, (Object)propertyEntry.getNumber());
                ++index;
            }
        }
        this.getView().updateView(entry_Property);
        this.setSelectRow();
    }

    private void initPropertyData() {
        String f7SelectedStr = this.getPageCache().get("CacheDimPropertySelected");
        if (StringUtils.isEmpty((String)f7SelectedStr)) {
            return;
        }
        List f7items = (List)SerializationUtils.fromJsonString((String)f7SelectedStr, List.class);
        List<ValueTextItem> valueTextItems = this.getF7CtrlDataSource(f7items);
        F7SelectedList f7SelList = (F7SelectedList)this.getControl(f7selected_property);
        f7SelList.removeAllItems();
        f7SelList.addItems(valueTextItems);
        this.getView().updateView(entry_Property);
        this.getView().updateView(f7selected_property);
        this.setSelectRow();
    }

    private List<Integer> getRowIdList(int[] rowArr) {
        ArrayList<Integer> rowList = new ArrayList<Integer>(16);
        if (rowArr != null && rowArr.length > 0) {
            for (int rowId : rowArr) {
                rowList.add(rowId);
            }
        }
        return rowList;
    }

    private void rowClick(String key, int rowIndex) {
        this.getPageCache().put(Cache_F7SelectedFlag, "0");
        EntryGrid propertyGrid = (EntryGrid)this.getControl(entry_Property);
        int[] rowArr = propertyGrid.getSelectRows();
        List<Integer> rowList = this.getRowIdList(rowArr);
        if (this.getModel().getEntryEntity(entry_Property) == null || this.getModel().getEntryEntity(entry_Property).size() == 0) {
            return;
        }
        int rowCount = this.getModel().getEntryEntity(entry_Property).size();
        ArrayList<String> delKeys = new ArrayList<String>(rowCount);
        ArrayList<Map<String, String>> f7ItemMaps = new ArrayList<Map<String, String>>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject curRow = this.getModel().getEntryRowEntity(key, i);
            String propertyId = curRow.getString(CUSTOMPROPERTY);
            String dimensionId = curRow.getString(DIMENSION);
            if (StringUtils.isEmpty((String)propertyId) || StringUtils.isEmpty((String)dimensionId)) continue;
            if (!rowList.contains(i)) {
                String keyStr = dimensionId + splitStr + propertyId;
                delKeys.add(keyStr);
                continue;
            }
            Map<String, String> propertyMap = this.getF7ItemMap(curRow);
            f7ItemMaps.add(propertyMap);
        }
        if (delKeys.size() > 0) {
            this.removePropertySelected(delKeys);
        }
        if (f7ItemMaps.size() > 0) {
            this.addPropertySelected(f7ItemMaps);
        }
        this.getPageCache().remove(Cache_F7SelectedFlag);
    }

    public Map<String, String> getF7ItemMap(DynamicObject row) {
        LinkedHashMap<String, String> propertyMap = new LinkedHashMap<String, String>(16);
        propertyMap.put("id", row.getString(CUSTOMPROPERTY));
        propertyMap.put(NAME, row.getString(NAME));
        propertyMap.put(NUMBER, row.getString(NUMBER));
        propertyMap.put("dimid", row.getString(DIMENSION));
        propertyMap.put("dimname", row.getString(DIMENSION_NAME));
        propertyMap.put("dimnum", row.getString(DIMENSION_NUMBER));
        propertyMap.put("key", row.getString(DIMENSION) + splitStr + row.getString(CUSTOMPROPERTY));
        return propertyMap;
    }

    protected void addPropertySelected(List<Map<String, String>> f7ItemMaps) {
        ArrayList<Map<String, String>> f7items = new ArrayList(16);
        String f7SelectedStr = this.getPageCache().get("CacheDimPropertySelected");
        if (!StringUtils.isEmpty((String)f7SelectedStr)) {
            f7items = (List)SerializationUtils.fromJsonString((String)f7SelectedStr, List.class);
        }
        for (Map<String, String> f7itemMap : f7ItemMaps) {
            String key = f7itemMap.get("key");
            Boolean isExists = f7items.stream().anyMatch(f7item -> ((String)f7item.get("key")).equalsIgnoreCase(key));
            if (isExists.booleanValue()) continue;
            f7items.add(f7itemMap);
        }
        List<ValueTextItem> valueTextItems = this.getF7CtrlDataSource(f7items);
        F7SelectedList f7SelList = (F7SelectedList)this.getControl(f7selected_property);
        this.getModel().beginInit();
        f7SelList.removeAllItems();
        f7SelList.addItems(valueTextItems);
        this.getModel().endInit();
        if (f7items.size() > 0) {
            this.getPageCache().put("CacheDimPropertySelected", SerializationUtils.toJsonString(f7items));
        } else {
            this.getPageCache().remove("CacheDimPropertySelected");
        }
        this.getView().updateView(f7selected_property);
    }

    private List<ValueTextItem> getF7CtrlDataSource(List<Map<String, String>> f7items) {
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>(16);
        for (Map<String, String> f7item : f7items) {
            String textStr = f7item.get("dimname") + ":" + f7item.get(NAME);
            String value = f7item.get("key");
            ValueTextItem item = new ValueTextItem(value, textStr);
            valueTextItems.add(item);
        }
        return valueTextItems;
    }

    private void removePropertySelected(List<String> itemKeys) {
        F7SelectedList f7SelListCtrl = (F7SelectedList)this.getControl(f7selected_property);
        String f7SelectedStr = this.getPageCache().get("CacheDimPropertySelected");
        if (StringUtils.isEmpty((String)f7SelectedStr)) {
            return;
        }
        List f7items = (List)SerializationUtils.fromJsonString((String)f7SelectedStr, List.class);
        Iterator iterator = f7items.iterator();
        while (iterator.hasNext()) {
            Map f7 = (Map)iterator.next();
            if (!itemKeys.contains(f7.get("key"))) continue;
            iterator.remove();
        }
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>(16);
        for (int i = 0; i < f7items.size(); ++i) {
            Map f7 = (Map)f7items.get(i);
            ValueTextItem addvalue = new ValueTextItem((String)f7.get("key"), (String)f7.get(NAME));
            valueTextItems.add(addvalue);
        }
        f7SelListCtrl.addItems(valueTextItems);
        if (f7items.size() > 0) {
            this.getPageCache().put("CacheDimPropertySelected", SerializationUtils.toJsonString((Object)f7items));
        } else {
            this.getPageCache().remove("CacheDimPropertySelected");
        }
        this.getView().updateView(f7selected_property);
    }

    protected void saveF7items() {
        HashMap<String, List<Object>> returnData = new HashMap<String, List<Object>>(16);
        List f7items = new ArrayList(16);
        String f7SelectedStr = this.getPageCache().get("CacheDimPropertySelected");
        if (!StringUtils.isEmpty((String)f7SelectedStr)) {
            f7items = (List)SerializationUtils.fromJsonString((String)f7SelectedStr, List.class);
        }
        returnData.put("f7items", f7items);
        returnData.put("dims", this.getCurDims());
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    private void initDimPropertyData() {
        String propertySelected = (String)this.getView().getFormShowParameter().getCustomParam("propertyMaps");
        if (!StringUtils.isEmpty((String)propertySelected)) {
            this.getPageCache().put("CacheDimPropertySelected", propertySelected);
        }
    }

    private String isF7SelectedOp() {
        String result = this.getPageCache().get(Cache_F7SelectedFlag);
        if (result == null) {
            result = "1";
        }
        return result;
    }

    public List<Map<String, String>> getCurDims() {
        List<Map<String, String>> dims = new ArrayList<Map<String, String>>(16);
        String dimsStr = (String)this.getView().getFormShowParameter().getCustomParam("dimMaps");
        if (!StringUtils.isEmpty((String)dimsStr)) {
            dims = (List)SerializationUtils.fromJsonString((String)dimsStr, List.class);
        }
        return dims;
    }

    public List<PropertyEntry> getAllProps() {
        List<Object> props = new ArrayList<PropertyEntry>(16);
        String str = (String)this.getView().getFormShowParameter().getCustomParam("allPropertys");
        if (!StringUtils.isEmpty((String)str)) {
            props = (List)SerializationUtils.deSerializeFromBase64((String)str);
        }
        return props;
    }

    public Long getModelId() {
        Object modelObj = this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        if (modelObj == null) {
            return 0L;
        }
        return Long.valueOf(modelObj.toString());
    }
}

