/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.dimension.SortDiminfo;
import kd.epm.emr.business.template.headerarea.IHeaderInfo;
import kd.epm.emr.common.template.enums.SortTypeEnum;
import kd.epm.epbs.common.util.DynamicEnum;
import kd.epm.epbs.common.util.SpreadAreaUtil;
import kd.epm.epbs.formplugin.AbstractBaseFormPlugin;

public class FloatSortSettingPlugin
extends AbstractBaseFormPlugin {
    public static final String SELECTAREA = "selectarea";
    public static final String DATAAREA = "dataarea";
    public static final String SORTTOPSETTING = "sorttopsetting";
    public static final String ORDERBY = "orderby";
    public static final String TITLE = "title";
    public static final String SORTORDER = "sortorder";
    public static final String TOP = "top";
    public static final String ENTRYENTITY = "entryentity";
    public static final String UNDERSCORE = "_";
    private List<ComboItem> dropDownList = null;
    private Map<String, String> titles = null;
    private IDataAreaSetting multiAreaSetting = null;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setTitles();
        this.setDropDownList();
        this.initData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{TITLE});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        this.addClickListeners(new String[]{"btn-confirm"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        Object newValue = e.getChangeSet()[0].getNewValue();
        int selectRow = eg.getSelectRows()[0];
        if (TOP.equals(key) && newValue != null && StringUtils.isNotEmpty((String)newValue.toString())) {
            Integer top = this.getTop(newValue);
            if (!this.checkCanSetTop() && top != 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"TOP\u53ea\u80fd\u5728\u6570\u636e\u533a\u57df\u5185\u8bbe\u7f6e\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"FloatSortSettingPlugin_0", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(TOP, (Object)0, selectRow);
            }
        }
        if (SORTORDER.equals(key) && newValue != null && StringUtils.isNotEmpty((String)newValue.toString())) {
            Integer sortorder = this.getSortOrder(newValue);
            if (!this.checkCanSetMemberSort() && sortorder == 2) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u5458\u987a\u5e8f\u4ec5\u9002\u7528\u4e8e\u201c\u6d6e\u52a8\u6210\u5458\u201d\u5217\u3002", (String)"FloatSortSettingPlugin_1", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(SORTORDER, (Object)0, selectRow);
            }
        }
        if (ORDERBY.equals(key)) {
            this.getModel().setValue(TITLE, (Object)this.getTitles().get(newValue + ""), selectRow);
            if (!this.checkCanSetMemberSort()) {
                this.getModel().setValue(SORTORDER, (Object)0, selectRow);
            }
        }
    }

    protected boolean checkCanSetTop() {
        int selectRow;
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRow = eg.getSelectRows()[0]);
        if (dynamicObject != null) {
            String orderBy = dynamicObject.getString(ORDERBY);
            return !orderBy.contains(UNDERSCORE);
        }
        return false;
    }

    protected boolean checkCanSetMemberSort() {
        int selectRow;
        EntryGrid eg = (EntryGrid)this.getControl(ENTRYENTITY);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        DynamicObject dynamicObject = (DynamicObject)entryEntity.get(selectRow = eg.getSelectRows()[0]);
        if (dynamicObject != null) {
            String[] orderBySplit = dynamicObject.getString(ORDERBY).split(UNDERSCORE);
            return "Dimension".equals(orderBySplit[0]);
        }
        return false;
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btn-confirm".equals(key)) {
            this.actionConfirm();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        EntryGrid entry = (EntryGrid)this.getControl(ENTRYENTITY);
        switch (itemKey) {
            case "bar-add": {
                this.addEntryRow();
                break;
            }
            case "bar-del": {
                int[] selectRows = entry.getSelectRows();
                if (selectRows.length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"FloatSortSettingPlugin_2", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                    break;
                }
                this.getModel().deleteEntryRows(ENTRYENTITY, selectRows);
                break;
            }
        }
    }

    protected void actionConfirm() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<SortDiminfo> sortDiminfos = new ArrayList<SortDiminfo>(10);
        AtomicBoolean flag = new AtomicBoolean(true);
        ArrayList<String> list = new ArrayList<String>(10);
        boolean isAllowTop = true;
        for (DynamicObject object : entryEntity) {
            SortDiminfo sortDiminfo = new SortDiminfo();
            String orderByStr = object.get(ORDERBY) + "";
            String[] orderBySplit = orderByStr.split(UNDERSCORE);
            if (orderBySplit.length == 2) {
                sortDiminfo.setOrderBy(orderBySplit[1]);
                if ("Dimension".equals(orderBySplit[0])) {
                    sortDiminfo.setSortType(SortTypeEnum.DIMENSION);
                } else if ("Property".equals(orderBySplit[0])) {
                    sortDiminfo.setSortType(SortTypeEnum.PROPERTY);
                }
            } else {
                sortDiminfo.setOrderBy(orderByStr);
                sortDiminfo.setSortType(SortTypeEnum.DATA);
            }
            if (list.contains(orderByStr)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6392\u5e8f\u4f9d\u636e\u8bbe\u7f6e\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"FloatSortSettingPlugin_3", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                flag.set(false);
                break;
            }
            list.add(orderByStr);
            sortDiminfo.setSortOrder(object.get(SORTORDER) + "");
            Integer top = this.getTop(object.get(TOP));
            if (top == null) {
                top = 0;
            }
            if (top != 0 && !isAllowTop) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"TOP\u53ea\u80fd\u8bbe\u7f6e\u4e00\u6b21\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"FloatSortSettingPlugin_4", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                flag.set(false);
                break;
            }
            if (top != 0 && sortDiminfo.getSortType() != SortTypeEnum.DATA) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"TOP\u53ea\u80fd\u5728\u6570\u636e\u533a\u57df\u5185\u8bbe\u7f6e\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"FloatSortSettingPlugin_0", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                flag.set(false);
                break;
            }
            if (top != 0) {
                sortDiminfo.setTop(top);
                isAllowTop = false;
            }
            sortDiminfos.add(sortDiminfo);
        }
        if (flag.get()) {
            this.getView().returnDataToParent((Object)this.toByteSerialized(sortDiminfos));
            this.getView().close();
        }
    }

    protected Integer getSortOrder(Object obj) {
        try {
            return Integer.parseInt(obj.toString());
        }
        catch (Exception e) {
            return 0;
        }
    }

    protected Integer getTop(Object object) {
        try {
            return Integer.parseInt(object.toString());
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void initData() {
        List topSettingOrder;
        if (this.getFormCustomParam(SORTTOPSETTING) != null && (topSettingOrder = (List)this.deSerializedBytes((String)this.getFormCustomParam(SORTTOPSETTING))) != null && !topSettingOrder.isEmpty()) {
            String orderByVal = "";
            int[] rows = this.getView().getModel().batchCreateNewEntryRow(ENTRYENTITY, topSettingOrder.size());
            for (int i = 0; i < topSettingOrder.size(); ++i) {
                SortDiminfo sortDiminfo = (SortDiminfo)topSettingOrder.get(i);
                if (sortDiminfo.getSortType() == SortTypeEnum.DATA) {
                    orderByVal = sortDiminfo.getOrderBy();
                } else if (sortDiminfo.getSortType() == SortTypeEnum.DIMENSION) {
                    orderByVal = "Dimension_" + sortDiminfo.getOrderBy();
                } else if (sortDiminfo.getSortType() == SortTypeEnum.PROPERTY) {
                    orderByVal = "Property_" + sortDiminfo.getOrderBy();
                }
                this.getModel().setValue(ORDERBY, (Object)orderByVal, rows[i]);
                this.getModel().setValue(TITLE, (Object)this.getTitles().get(orderByVal), rows[i]);
                this.getModel().setValue(SORTORDER, (Object)sortDiminfo.getSortOrder(), rows[i]);
                this.getModel().setValue(TOP, (Object)sortDiminfo.getTop(), rows[i]);
            }
            this.getView().updateView(ENTRYENTITY);
        }
    }

    protected void setDropDownList() {
        List<String> list = this.getSelectRowFloatRowOrCol(this.getFloatArea(SELECTAREA));
        List headerInfos = this.isRow() ? this.getMultiAreaSetting().getRowHeaders() : this.getMultiAreaSetting().getColHeaders();
        int headerSize = headerInfos.size();
        int dataIndex = 0;
        list.addAll(this.getSelectRowFloatRowOrCol(this.getFloatArea(DATAAREA)));
        ComboEdit comboEdit = (ComboEdit)this.getControl(ORDERBY);
        ArrayList items = new ArrayList(10);
        ArrayList<String[]> keysAndValues = new ArrayList<String[]>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            String[] keysAndValue = new String[]{this.buildComboShowName(list.get(i)), i < headerSize ? ((IHeaderInfo)headerInfos.get(i)).getType() + UNDERSCORE + ((IHeaderInfo)headerInfos.get(i)).getNumber() : String.valueOf(dataIndex++)};
            keysAndValues.add(keysAndValue);
        }
        keysAndValues.forEach(new DynamicEnum(items));
        comboEdit.setComboItems(items);
        this.getPageCache().put("dropDownList", SerializationUtils.serializeToBase64(items));
    }

    protected List<ComboItem> getDropDownList() {
        String str;
        if (this.dropDownList == null && StringUtils.isNotEmpty((String)(str = this.getPageCache().get("dropDownList")))) {
            this.dropDownList = (List)SerializationUtils.deSerializeFromBase64((String)str);
        }
        return this.dropDownList;
    }

    protected void setTitles() {
        List headerInfos;
        HashMap<String, String> titles = new HashMap<String, String>(16);
        List list = headerInfos = this.isRow() ? this.getMultiAreaSetting().getRowHeaders() : this.getMultiAreaSetting().getColHeaders();
        if (headerInfos != null) {
            for (int i = 0; i < headerInfos.size(); ++i) {
                IHeaderInfo headerInfo = (IHeaderInfo)headerInfos.get(i);
                titles.put(headerInfo.getType() + UNDERSCORE + headerInfo.getNumber(), headerInfo.getName());
            }
        }
        this.getPageCache().put("titles", SerializationUtils.toJsonString(titles));
    }

    protected Map<String, String> getTitles() {
        if (this.titles == null) {
            String str = this.getPageCache().get("titles");
            this.titles = StringUtils.isNotEmpty((String)str) ? (Map<Object, Object>)SerializationUtils.fromJsonString((String)str, Map.class) : new HashMap<String, String>(16);
        }
        return this.titles;
    }

    protected String getFloatArea(String type) {
        if (this.getFormCustomParam(type) != null && StringUtils.isNotEmpty((String)((String)this.getFormCustomParam(type)))) {
            return (String)this.getFormCustomParam(type);
        }
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4ece\u7f13\u5b58\u4e2d\u83b7\u53d6%s\u5931\u8d25\uff0c\u8bf7\u9000\u51fa\u9875\u9762\u540e\u91cd\u8bd5\u3002", (String)"FloatSortSettingPlugin_5", (String)"epm-emr-formplugin", (Object[])new Object[0]), type));
        return null;
    }

    protected void addEntryRow() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(ENTRYENTITY);
        int row = entryEntity.size();
        this.dropDownList = this.getDropDownList();
        int size = this.dropDownList.size();
        if (size == row) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6700\u591a\u65b0\u589e%s\u884c\uff0c\u6ca1\u6709\u53ef\u65b0\u589e\u7684\u6570\u636e\u3002", (String)"FloatSortSettingPlugin_6", (String)"epm-emr-formplugin", (Object[])new Object[0]), size));
            return;
        }
        String orderBy = this.dropDownList.get(0).getValue();
        DynamicObject rowObj = new DynamicObject(entryEntity.getDynamicObjectType());
        rowObj.set(ORDERBY, (Object)orderBy);
        rowObj.set(TITLE, (Object)this.getTitles().get(orderBy));
        rowObj.set(SORTORDER, (Object)0);
        rowObj.set(TOP, (Object)0);
        this.getView().getModel().beginInit();
        this.getView().getModel().createNewEntryRow(ENTRYENTITY, row, rowObj);
        this.getView().getModel().endInit();
        this.getView().updateView(ENTRYENTITY, row);
    }

    protected String buildComboShowName(String in) {
        String name = this.isRow() ? ResManager.loadKDString((String)"\u5217", (String)"FloatSortSettingPlugin_7", (String)"epm-emr-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u884c", (String)"FloatSortSettingPlugin_8", (String)"epm-emr-formplugin", (Object[])new Object[0]);
        return in + name;
    }

    protected List<String> getSelectRowFloatRowOrCol(String selectarea) {
        return this.isRow() ? (List)SpreadAreaUtil.getCol((String)selectarea) : (List)SpreadAreaUtil.getRow((String)selectarea);
    }

    protected boolean isRow() {
        return "true".equals(this.getFormCustomParam("isRow"));
    }

    public IDataAreaSetting getMultiAreaSetting() {
        if (this.multiAreaSetting == null) {
            String str = (String)this.getFormCustomParam("areaSetting");
            if (StringUtils.isNotEmpty((String)str)) {
                this.multiAreaSetting = (IDataAreaSetting)this.deSerializedBytes(str);
            } else {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u4f20\u5165\u6570\u636e\u533a\u57df\u8bbe\u7f6e\u3002", (String)"FloatSortSettingPlugin_9", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            }
        }
        return this.multiAreaSetting;
    }
}

