/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template;

import java.util.function.Consumer;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.TemplateInfo;
import kd.epm.epbs.common.util.IDUtils;

public interface ITemplateOpenPage {
    public static final int SHOWPARAMETER_LIST = 1;
    public static final int SHOWPARAMETER_FORM = 2;
    public static final int SHOWPARAMETER_BILL = 3;
    public static final int SHOWPARAMETER_BASE = 4;

    public AbstractFormPlugin getPlugin();

    public String getEpbsTemplateEntity();

    public String getEpbsTemplateProcess();

    public String getEpbsDimSetting();

    public String getEpbsFloatSetting();

    default public FormShowParameter openPage(String actionId, String caption, ShowType showType) {
        return this.openPage(actionId, caption, showType, 2);
    }

    default public FormShowParameter openPage(String actionId, String caption, ShowType showType, int showparameter) {
        Object formShowParameter = null;
        formShowParameter = showparameter == 1 ? new ListShowParameter() : (showparameter == 3 ? new BillShowParameter() : (showparameter == 4 ? new BaseShowParameter() : new FormShowParameter()));
        formShowParameter.setParentPageId(this.getPlugin().getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(showType);
        if (showType == ShowType.MainNewTabPage) {
            formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        }
        if (StringUtils.isNotEmpty((String)caption)) {
            formShowParameter.setCaption(caption);
        }
        if (StringUtils.isNotEmpty((String)actionId)) {
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this.getPlugin(), actionId));
        }
        return formShowParameter;
    }

    default public void openTemplateBaseInfoPage(String actionId, String caption, OperationStatus status, Long modelId, Consumer<FormShowParameter> consumer) {
        FormShowParameter formShowParameter = this.openPage(actionId, caption, ShowType.Modal);
        formShowParameter.setFormId(this.getEpbsTemplateEntity());
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        formShowParameter.setStatus(status);
        if (null != consumer) {
            consumer.accept(formShowParameter);
        }
        this.getPlugin().getView().showForm(formShowParameter);
    }

    default public void openTemplateProcessPage(String actionId, String caption, OperationStatus status, TemplateInfo templateBaseInfo, Consumer<FormShowParameter> consumer) {
        IFormView mainview = this.getPlugin().getView().getMainView();
        String pageid = this.getPlugin().getView().getPageId() + templateBaseInfo.getTemplatecatalogId() + templateBaseInfo.getNumber();
        IFormView toshowview = null;
        toshowview = mainview != null ? mainview.getView(pageid) : this.getPlugin().getView().getView(pageid);
        if (toshowview == null) {
            FormShowParameter formShowParameter = this.openPage(actionId, caption, ShowType.MainNewTabPage);
            formShowParameter.setPageId(pageid);
            formShowParameter.setFormId(this.getEpbsTemplateProcess());
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)templateBaseInfo.getModelId());
            formShowParameter.setCustomParam("MULTISHEET_TEMPLATE_INFO", (Object)TemplateInfo.toByteSerialized((Object)templateBaseInfo));
            formShowParameter.setCustomParam("KEY_TEMPLATE_DIMSETTING", (Object)this.getEpbsDimSetting());
            formShowParameter.setCustomParam("KEY_TEMPLATE_FLOATSETTING", (Object)this.getEpbsFloatSetting());
            formShowParameter.setStatus(status);
            if (null != consumer) {
                consumer.accept(formShowParameter);
            }
            this.getPlugin().getView().showForm(formShowParameter);
        } else {
            toshowview.setStatus(status);
            toshowview.activate();
            this.getPlugin().getView().sendFormAction(toshowview);
        }
    }

    default public void openTemplateCatalogPage(String actionId, String caption, String entityNumber, Long pkId, Long modelId, Consumer<BillShowParameter> consumer) {
        BaseShowParameter formShowParameter = (BaseShowParameter)this.openPage(actionId, caption, ShowType.Modal, 4);
        formShowParameter.setFormId(entityNumber);
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)modelId);
        if (IDUtils.isNotNull((Long)pkId)) {
            formShowParameter.setPkId((Object)pkId);
            formShowParameter.setStatus(OperationStatus.EDIT);
        }
        if (null != consumer) {
            consumer.accept((BillShowParameter)formShowParameter);
        }
        this.getPlugin().getView().showForm((FormShowParameter)formShowParameter);
    }
}

