/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template.f7;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.emr.formplugin.template.f7.CommonLeftTreeF7Helper;
import kd.epm.emr.formplugin.template.f7.CommonRightF7Helper;
import kd.epm.emr.formplugin.template.f7.TplTreeF7Context;
import kd.epm.epbs.business.spi.IConsumerService;
import kd.epm.epbs.business.spi.IPluginProviderService;
import kd.epm.epbs.common.bean.EpbsContext;
import kd.epm.epbs.common.bean.IContext;
import kd.epm.epbs.common.page.CommandParam;
import kd.epm.epbs.common.util.EpbsOperationResult;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.control.EntryEntityUtils;
import org.apache.commons.lang3.StringUtils;

public class CommonRightF7Plugin
extends AbstractFormPlugin
implements SearchEnterListener,
RowClickEventListener,
HyperLinkClickListener,
EntryGridBindDataListener,
IPluginProviderService,
IConsumerService {
    private TplTreeF7Context context;

    public void initialize() {
        EntryGrid entryGrid;
        super.initialize();
        this.addClickListeners(new String[]{"btn_sure"});
        this.addClickListeners(new String[]{"listup", "listdown", "btn_moveup", "btn_movedown", "btn_remove", "btn_clearselected"});
        Search search = (Search)this.getControl("searchlist");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
        if ((entryGrid = (EntryGrid)this.getControl("entryentity")) != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void click(EventObject evt) {
        String clickKey;
        super.click(evt);
        switch (clickKey = ((Control)evt.getSource()).getKey()) {
            case "listup": {
                this.searchList(false);
                break;
            }
            case "listdown": {
                this.searchList(true);
                break;
            }
            case "btn_moveup": {
                EntryEntityUtils.moveEntryEntity((EntryGrid)((EntryGrid)this.getControl("entryentity")), (boolean)false);
                break;
            }
            case "btn_movedown": {
                EntryEntityUtils.moveEntryEntity((EntryGrid)((EntryGrid)this.getControl("entryentity")), (boolean)true);
                break;
            }
            case "btn_remove": {
                this.click_remove(evt);
                break;
            }
            case "btn_clearselected": {
                this.clearSelected(evt);
                break;
            }
            case "btn_sure": {
                this.click_submit(evt);
            }
        }
    }

    protected void searchList(boolean isDown) {
        Search search = (Search)this.getControl("searchlist");
        String searchTxt = search.getSearchKey();
        if (StringUtils.isEmpty((CharSequence)search.getSearchKey())) {
            return;
        }
        DynamicObjectCollection selMembers = this.getModel().getEntryEntity("entryentity");
        ArrayList<Integer> selectRows = new ArrayList<Integer>();
        if (selMembers != null && !selMembers.isEmpty()) {
            DynamicObject selMember;
            int rowIndex;
            int selRowIndex = -1;
            String _selRowIndex = this.getPageCache().get("CACHE_LIST_ROW_INDEX");
            if (StringUtils.isNotEmpty((CharSequence)_selRowIndex)) {
                try {
                    selRowIndex = Integer.parseInt(_selRowIndex);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (isDown) {
                int in = selMembers.size();
                for (int i = rowIndex = selRowIndex != -1 ? selRowIndex + 1 : 0; i < in; ++i) {
                    selMember = (DynamicObject)selMembers.get(i);
                    if (selMember == null || !CommonRightF7Helper.equalsSearchText(selMember, searchTxt)) continue;
                    this.getPageCache().put("CACHE_LIST_ROW_INDEX", String.valueOf(i));
                    selectRows.add(i);
                    break;
                }
            } else {
                for (int i = rowIndex = selRowIndex != -1 ? selRowIndex - 1 : selMembers.size() - 1; i >= 0; --i) {
                    selMember = (DynamicObject)selMembers.get(i);
                    if (selMember == null || !CommonRightF7Helper.equalsSearchText(selMember, searchTxt)) continue;
                    this.getPageCache().put("CACHE_LIST_ROW_INDEX", String.valueOf(i));
                    selectRows.add(i);
                    break;
                }
            }
        }
        if (selectRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u9879", (String)"CommonRightF7Plugin_0", (String)"epm-emr-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
        } else {
            EntryGrid entry = (EntryGrid)this.getControl("entryentity");
            if (entry != null) {
                int[] rows = selectRows.stream().mapToInt(x -> x).toArray();
                entry.selectRows(rows, 0);
            }
        }
    }

    protected void click_moveListUp(EventObject evt) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        if (entryGrid != null) {
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6210\u5458\u6570\u636e\u3002", (String)"CommonRightF7Plugin_1", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            } else {
                Arrays.stream(rows).forEach(rowIndex -> {
                    if (rowIndex == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u5904\u4e8e\u7b2c\u4e00\u884c\uff0c\u65e0\u6cd5\u7ee7\u7eed\u4e0a\u79fb", (String)"CommonRightF7Plugin_2", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                        return;
                    }
                });
                this.getModel().moveEntryRowsUp("entryentity", rows);
            }
        }
    }

    protected TplTreeF7Context getCtx() {
        if (this.context == null) {
            this.context = (TplTreeF7Context)((Object)CommonLeftTreeF7Helper.getCtx(this.getView()));
        }
        return this.context;
    }

    public EpbsOperationResult receiveMessage(IContext context) {
        if ("nodeSync".equals(context.getOpKey()) && context.getData() instanceof Map) {
            Map data = (Map)context.getData();
            Boolean check = (Boolean)data.get("check");
            TreeNode checkNode = (TreeNode)data.get("checkNode");
            DynamicObjectCollection dys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            if (check.booleanValue()) {
                if (!this.getCtx().isMulti() && !dys.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u591a\u9009\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"CommonRightF7Plugin_3", (String)"epm-emr-formplugin", (Object[])new Object[0]), Integer.valueOf(500));
                    return new EpbsOperationResult();
                }
                if (!dys.stream().anyMatch(e -> e.getString("id").equals(checkNode.getId()))) {
                    List nodes = (List)data.get("checkNodes");
                    TreeNode node = null;
                    for (TreeNode _node : nodes) {
                        if (!checkNode.getId().equals(_node.getId())) continue;
                        if (!this.getCtx().isMulti()) {
                            this.getModel().deleteEntryData("entryentity");
                        }
                        node = _node;
                        this.addEntryRow(node);
                        break;
                    }
                }
            } else {
                this.removeEntryRow(checkNode);
            }
        }
        return new EpbsOperationResult();
    }

    protected String getEntityNumber(TreeNode node) {
        return node.getData() == null ? null : node.getData().toString();
    }

    protected void addEntryRow(TreeNode node) {
        String entityNumber = this.getEntityNumber(node);
        if (StringUtils.isNotEmpty((CharSequence)entityNumber)) {
            int rowIndex = this.getModel().createNewEntryRow("entryentity");
            Set<Object> fields = Sets.newHashSet((Object[])new String[]{"id", "name", "number"});
            if (this.getCtx().getTplEntityNumber().equals(entityNumber)) {
                fields = ((EntryProp)this.getModel().getProperty("entryentity")).getDynamicCollectionItemPropertyType().getProperties().stream().map(e -> e.getName()).filter(e -> !e.equals("extfield") && !e.endsWith("_id") && !e.equals("seq")).collect(Collectors.toSet());
            }
            QFilter qFilter = new QFilter("id", "=", (Object)IDUtils.toLong((Object)node.getId()));
            DynamicObject dy = QueryServiceHelper.queryOne((String)entityNumber, (String)String.join((CharSequence)",", (Iterable<? extends CharSequence>)fields), (QFilter[])qFilter.toArray());
            if (dy != null) {
                for (String string : fields) {
                    this.getModel().setValue(string, dy.get(string), rowIndex);
                }
                this.getModel().setValue("extfield", (Object)entityNumber, rowIndex);
            }
        }
    }

    protected void removeEntryRow(TreeNode node) {
        DynamicObjectCollection dys = this.getModel().getEntryEntity("entryentity");
        ArrayList<Integer> list = new ArrayList<Integer>(10);
        for (int i = 0; i < dys.size(); ++i) {
            if (!((DynamicObject)dys.get(i)).getString("id").equals(node.getId())) continue;
            list.add(i);
        }
        if (!list.isEmpty()) {
            this.getModel().deleteEntryRows("entryentity", list.stream().mapToInt(x -> x).toArray());
        }
    }

    protected void click_remove(EventObject evt) {
        Optional optional = EntryEntityUtils.getSelectRowsWithValidate((EntryGrid)((EntryGrid)this.getControl("entryentity")));
        if (optional.isPresent()) {
            ArrayList<String> unCheckedIds = new ArrayList<String>(((int[])optional.get()).length);
            for (int row : (int[])optional.get()) {
                DynamicObject member = this.getModel().getEntryRowEntity("entryentity", row);
                if (member == null) continue;
                unCheckedIds.add(member.getString("id"));
            }
            this.getModel().deleteEntryRows("entryentity", (int[])optional.get());
            EpbsOperationResult epbsOperationResult = this.sendMessage(this.getView().getFormShowParameter().getFormId(), (IContext)new EpbsContext("delRowSyncNode", unCheckedIds));
        }
    }

    protected void clearSelected(EventObject evt) {
        List ids = this.getModel().getEntryEntity("entryentity").stream().map(e -> e.getString("id")).collect(Collectors.toList());
        this.getModel().deleteEntryData("entryentity");
        EpbsOperationResult result = this.sendMessage(this.getView().getFormShowParameter().getFormId(), (IContext)new EpbsContext("delRowSyncNode", ids));
    }

    protected void click_submit(EventObject evt) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!entryEntity.isEmpty()) {
            this.getView().returnDataToParent((Object)entryEntity);
        }
        this.getView().close();
    }

    public void entryRowClick(RowClickEvent evt) {
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
    }

    public void search(SearchEnterEvent evt) {
    }

    public CommandParam createCommandParam(String targetFormId, IContext context) {
        CommandParam commandParam = super.createCommandParam(targetFormId, context);
        commandParam.setSender("");
        return commandParam;
    }
}

