/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template.f7;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.emr.formplugin.template.f7.CommonLeftTreeF7Helper;
import kd.epm.emr.formplugin.template.f7.TplTreeF7Context;
import kd.epm.epbs.business.spi.IConsumerService;
import kd.epm.epbs.business.spi.IPluginProviderService;
import kd.epm.epbs.common.bean.EpbsContext;
import kd.epm.epbs.common.bean.IContext;
import kd.epm.epbs.common.enums.ShowTypeEnum;
import kd.epm.epbs.common.member.f7.tree.BaseTreeBuilder;
import kd.epm.epbs.common.page.CommandParam;
import kd.epm.epbs.common.tree.AbstractTreeBuilder;
import kd.epm.epbs.common.tree.TreeContext;
import kd.epm.epbs.common.tree.TreeSearchHelper;
import kd.epm.epbs.common.util.EpbsOperationResult;
import org.apache.commons.lang3.StringUtils;

public class CommonTreeF7Plugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeQueryListener,
TreeNodeCheckListener,
SearchEnterListener,
IPluginProviderService,
IConsumerService {
    public static final Log log = LogFactory.getLog(CommonTreeF7Plugin.class);
    private TreeNodeCheckEvent evt;
    private TplTreeF7Context context;

    public void initialize() {
        super.initialize();
        Search search = (Search)this.getControl("treesearch");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
        this.addClickListeners(new String[]{"treeup", "treedown"});
        TreeView treeView = (TreeView)this.getControl("lefttree");
        if (treeView != null) {
            BaseTreeBuilder.registerNodeListener((TreeView)treeView, (TreeNodeClickListener)this);
            BaseTreeBuilder.registerNodeCheckListener((TreeView)treeView, (TreeNodeCheckListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getCtx().setShowTypeEnum(ShowTypeEnum.getShowTypeByValue((String)((String)this.getModel().getValue("showtype"))));
        this.initLeftTree();
    }

    protected void initLeftTree() {
        AbstractTreeBuilder builder = CommonLeftTreeF7Helper.getTreeBuilder(this.getView(), (TreeContext)this.getCtx());
        TreeView treeView = (TreeView)this.getControl("lefttree");
        builder.buildTree(treeView);
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        super.propertyChanged(evt);
        switch (evt.getProperty().getName()) {
            case "showtype": {
                this.comboShowType(evt);
            }
        }
    }

    protected TplTreeF7Context getCtx() {
        if (this.context == null) {
            this.context = (TplTreeF7Context)((Object)CommonLeftTreeF7Helper.getCtx(this.getView()));
        }
        return this.context;
    }

    protected void comboShowType(PropertyChangedArgs evt) {
        ChangeData[] changeData = evt.getChangeSet();
        if (changeData == null || changeData.length == 0 || changeData[0].getNewValue() == null) {
            return;
        }
        log.info("begin-showType.");
        try {
            this.getCtx().setShowTypeEnum(ShowTypeEnum.getShowTypeByValue((String)evt.getChangeSet()[0].getNewValue().toString()));
            this.initLeftTree();
        }
        finally {
            log.info("end-showType.");
        }
    }

    public void click(EventObject evt) {
        String clickKey;
        super.click(evt);
        switch (clickKey = ((Control)evt.getSource()).getKey()) {
            case "treeup": 
            case "treedown": {
                Search search = (Search)this.getControl("treesearch");
                if (search == null || !StringUtils.isNotEmpty((CharSequence)search.getSearchKey())) break;
                this.searchTree(search.getSearchKey(), "treedown".equals(clickKey));
            }
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        if (StringUtils.isNotEmpty((CharSequence)nodeId)) {
            // empty if block
        }
    }

    public void treeNodeDoubleClick(TreeNodeEvent evt) {
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        AbstractTreeBuilder builder = CommonLeftTreeF7Helper.getTreeBuilder(this.getView(), (TreeContext)this.getCtx());
        TreeView treeView = (TreeView)this.getControl("lefttree");
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        boolean checked = evt.getChecked();
        String nodeId = (String)evt.getNodeId();
        if (nodeId == null || "root".equals(nodeId)) {
            return;
        }
        TreeView treeView = (TreeView)evt.getSource();
        TreeView.TreeState treeState = treeView.getTreeState();
        List checkedNodes = treeState.getCheckedNodes();
        TreeNode root = AbstractTreeBuilder.getRootWithCache((TreeView)treeView);
        List nodes = checkedNodes.stream().map(e -> root.getTreeNode(e.get("id").toString())).collect(Collectors.toList());
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("check", checked);
        param.put("checkNode", root.getTreeNode(nodeId));
        param.put("checkNodes", nodes);
        EpbsContext context = new EpbsContext("nodeSync", param);
        EpbsOperationResult res = this.sendMessage((IContext)context);
    }

    public void search(SearchEnterEvent evt) {
        Search _search = (Search)evt.getSource();
        String _text = evt.getText();
        if (_search == null || StringUtils.isEmpty((CharSequence)_text)) {
            return;
        }
        if ("treesearch".equals(_search.getKey())) {
            this.searchTree(_text, true);
        }
    }

    protected void searchTree(String searchText, boolean isDown) {
        TreeSearchHelper builder = new TreeSearchHelper((TreeView)this.getControl("lefttree"), searchText);
        if (!isDown) {
            builder.setMoveUp();
        }
        builder.search();
    }

    public EpbsOperationResult receiveMessage(IContext context) {
        if ("delRowSyncNode".equals(context.getOpKey())) {
            List data = (List)context.getData();
            TreeView treeView = (TreeView)this.getControl("lefttree");
            treeView.uncheckNodes(data);
        }
        return new EpbsOperationResult();
    }

    public CommandParam createCommandParam(String targetFormId, IContext context) {
        CommandParam commandParam = super.createCommandParam(targetFormId, context);
        commandParam.setSender("");
        return commandParam;
    }
}

