/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template.helper;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.headerarea.HeaderObject;
import kd.epm.emr.business.template.headerarea.IHeaderInfo;
import kd.epm.emr.business.template.headerarea.IHeaderObject;
import kd.epm.emr.business.template.quote.QuoteTypeEnum;
import kd.epm.emr.business.template.service.ITemplateMemberService;
import kd.epm.emr.common.spread.command.rangedefined.CellArea;
import kd.epm.emr.common.spread.command.rangedefined.OneCell;
import kd.epm.emr.common.spread.model.IDimMember;
import kd.epm.epbs.common.model.bean.PropValueBean;
import kd.epm.epbs.common.model.cache.EpbsPropCache;
import kd.epm.epbs.common.util.ICell;
import kd.epm.epbs.common.util.Pair;
import org.apache.commons.collections4.CollectionUtils;

public class DimPropertyHelper {
    public static Map<String, Integer> getDimPropPosMap(String dimNumber, List<IHeaderInfo> headerInfos) {
        LinkedHashMap<String, Integer> dimsIndex = new LinkedHashMap<String, Integer>(16);
        if (dimNumber != null && headerInfos != null) {
            for (int i = 0; i < headerInfos.size(); ++i) {
                IHeaderInfo headerInfo = headerInfos.get(i);
                if (headerInfo == null || !"Property".equals(headerInfo.getType()) || !dimNumber.equals(headerInfo.getRefDimension())) continue;
                dimsIndex.put(headerInfo.getNumber(), i);
            }
        }
        return dimsIndex;
    }

    public static Map<String, Integer> getDimPosMap(List<IHeaderInfo> headerInfos) {
        LinkedHashMap<String, Integer> dimsIndex = new LinkedHashMap<String, Integer>(16);
        if (headerInfos != null) {
            for (int i = 0; i < headerInfos.size(); ++i) {
                IHeaderInfo headerInfo = headerInfos.get(i);
                if (!headerInfo.isDimension()) continue;
                dimsIndex.put(headerInfo.getNumber(), i);
            }
        }
        return dimsIndex;
    }

    public static List<ICell> setMemberProperties(int r, int c, String dimNumber, List<IDimMember> members, IDataAreaSetting areaSetting, ITemplateMemberService memberService, boolean isReport) {
        LinkedList<ICell> cells = new LinkedList<ICell>();
        if (dimNumber == null || CollectionUtils.isEmpty(members) || areaSetting == null || memberService == null) {
            return cells;
        }
        boolean isRow = areaSetting.getRowdims().contains(dimNumber);
        CellArea cellArea = new CellArea(areaSetting.getAreaRange());
        int areaRowColIndex = isRow ? r - cellArea.getR() : c - cellArea.getC();
        int maxAreaRowColIndex = isRow ? cellArea.getRc() - 1 : cellArea.getCc() - 1;
        List headerInfos = isRow ? areaSetting.getRowHeaders() : areaSetting.getColHeaders();
        boolean isFloat = areaSetting.isFloat(areaRowColIndex, isRow);
        HashMap<String, IHeaderInfo> propHeadersMap = new HashMap<String, IHeaderInfo>(16);
        HashMap<String, Integer> propPosMap = new HashMap<String, Integer>(16);
        IHeaderInfo dimHeaderInfo = null;
        int dimPos = 0;
        List dimHeaderObjects = null;
        for (int i = 0; i < headerInfos.size(); ++i) {
            IHeaderInfo headerInfo = (IHeaderInfo)headerInfos.get(i);
            if ("Property".equals(headerInfo.getType()) && dimNumber.equals(headerInfo.getRefDimension())) {
                propHeadersMap.put(headerInfo.getNumber(), headerInfo);
                propPosMap.put(headerInfo.getNumber(), i);
                continue;
            }
            if (!headerInfo.isDimension() || !dimNumber.equals(headerInfo.getNumber())) continue;
            dimHeaderInfo = headerInfo;
            dimPos = i;
            dimHeaderObjects = headerInfo.getHeaderObjects();
        }
        if (dimHeaderInfo == null || dimHeaderObjects == null) {
            return cells;
        }
        Set viewMemNumbers = members.stream().filter(e -> e != null).map(o -> Pair.onePair((Object)o.getViewNumber(), (Object)o.getNumber())).collect(Collectors.toSet());
        Map memPropValues = memberService.getMemberPropValues(dimNumber, viewMemNumbers);
        int i = 0;
        for (IDimMember member : members) {
            if (areaRowColIndex + i > maxAreaRowColIndex) break;
            if (member == null) {
                dimHeaderObjects.set(areaRowColIndex + i, null);
                for (Map.Entry entry : propHeadersMap.entrySet()) {
                    int propPos = (Integer)propPosMap.get(entry.getKey());
                    if (isRow) {
                        cells.add((ICell)new OneCell(r + i, isReport ? c + propPos - dimPos : propPos, null));
                        continue;
                    }
                    cells.add((ICell)new OneCell(isReport ? r + propPos - dimPos : propPos, c + i, null));
                }
            } else {
                Map propValues;
                IHeaderObject ho = (IHeaderObject)dimHeaderObjects.get(areaRowColIndex + i);
                if (ho == null || member.getNumber() != null && !member.getNumber().equals(ho.getNumber())) {
                    dimHeaderObjects.set(areaRowColIndex + i, new HeaderObject(isFloat, member.getNumber(), member.getName(), QuoteTypeEnum.MEMBER.getValue(), member.getViewId(), member.getViewNumber(), member.getParentNum()));
                }
                if ((propValues = (Map)memPropValues.get(member.getNumber())) != null) {
                    for (Map.Entry entry : propHeadersMap.entrySet()) {
                        String propNum = (String)entry.getKey();
                        String propVal = (String)propValues.get(propNum);
                        IHeaderInfo propHeader = (IHeaderInfo)entry.getValue();
                        int propPos = (Integer)propPosMap.get(propHeader.getNumber());
                        if (propVal != null) {
                            if (isRow) {
                                cells.add((ICell)new OneCell(r + i, isReport ? c + propPos - dimPos : propPos, (Object)propVal));
                                continue;
                            }
                            cells.add((ICell)new OneCell(isReport ? r + propPos - dimPos : propPos, c + i, (Object)propVal));
                            continue;
                        }
                        if (isRow) {
                            cells.add((ICell)new OneCell(r + i, isReport ? c + propPos - dimPos : propPos, null));
                            continue;
                        }
                        cells.add((ICell)new OneCell(isReport ? r + propPos - dimPos : propPos, c + i, null));
                    }
                } else {
                    for (Map.Entry entry : propHeadersMap.entrySet()) {
                        int propPos = (Integer)propPosMap.get(entry.getKey());
                        if (isRow) {
                            cells.add((ICell)new OneCell(r + i, isReport ? c + propPos - dimPos : propPos, null));
                            continue;
                        }
                        cells.add((ICell)new OneCell(isReport ? r + propPos - propPos : propPos, c + i, null));
                    }
                }
            }
            ++i;
        }
        return cells;
    }

    public static Map<Integer, String> groupProIndexToDimMap(List<IHeaderInfo> headerInfos, Map<String, IHeaderInfo> dimHeaderInfoMap) {
        HashMap<Integer, String> map = new HashMap<Integer, String>(16);
        for (int i = 0; i < headerInfos.size(); ++i) {
            IHeaderInfo info = headerInfos.get(i);
            if ("Property".equals(info.getType())) {
                map.put(i, info.getRefDimension());
            }
            if (!info.isDimension()) continue;
            dimHeaderInfoMap.put(info.getNumber(), info);
        }
        return map;
    }

    public static PropValueBean getPropValueBean(EpbsPropCache propCache, String propValueLongNum) {
        String[] split;
        if (propCache != null && StringUtils.isNotEmpty((CharSequence)propValueLongNum) && (split = propValueLongNum.split("!")).length == 2) {
            return propCache.getProp(split[0]).getPropValue(split[1]);
        }
        return null;
    }
}

