/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.QuickFloatBean;
import kd.epm.emr.business.template.SequenceInfo;
import kd.epm.emr.business.template.SheetManager;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.areasetting.IFloatInfo;
import kd.epm.emr.formplugin.report.cache.MatchFloatOrRelationAreaInfo;
import kd.epm.emr.formplugin.spread.SpreadEasyInvoker;
import kd.epm.emr.formplugin.template.helper.SequenceSettingHelper;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.RangeModel;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MarkSpecialCellHelper {
    public static final String OLDSPREAD = "oldspread";
    public static final String DATAAREA_BC = "#66CDAA";
    public static final String FLOATAREA_BC = "red";

    public static void cacheOldSpread(IPageCache pageCache, ISheetManager sm) {
        pageCache.put(OLDSPREAD, ObjectSerialUtil.toByteSerialized((Object)sm));
    }

    public static void markSpecialCells(SpreadEasyInvoker invoker, IDataAreaSetting multiAreaSetting, boolean mark) {
        if (multiAreaSetting == null) {
            return;
        }
        List<Map<String, Object>> pointParms = MarkSpecialCellHelper.getMarkPointParms(new RangeModel(multiAreaSetting.getAreaRange()), DATAAREA_BC, mark);
        List floatInfos = multiAreaSetting.getFloatInfos();
        if (CollectionUtils.isNotEmpty((Collection)floatInfos)) {
            floatInfos.forEach(f -> pointParms.addAll(MarkSpecialCellHelper.getMarkPointParms(new QuickFloatBean(multiAreaSetting, f).getFloatRange(), FLOATAREA_BC, mark)));
        }
        invoker.invokeSetCellTag(pointParms);
    }

    public static void markSpecialCells(SpreadEasyInvoker invoker, IDataAreaSetting multiAreaSetting, IFloatInfo f, boolean mark) {
        QuickFloatBean qfb = new QuickFloatBean(multiAreaSetting, f);
        invoker.invokeSetCellTag(MarkSpecialCellHelper.getMarkPointParms(qfb.getFloatRange(), FLOATAREA_BC, mark));
    }

    public static void markSpecialCells(List<MatchFloatOrRelationAreaInfo> infos, SpreadEasyInvoker invoker, boolean isMark) {
        infos.forEach(info -> {
            if (info.getDStartOrEnd().booleanValue()) {
                invoker.invokeSetCellTag(MarkSpecialCellHelper.getMarkPointParms(new RangeModel(info.getAreaSetting().getAreaRange()), DATAAREA_BC, isMark));
            }
            if (info.getFStartOrEnd().booleanValue()) {
                MarkSpecialCellHelper.markSpecialCells(invoker, info.getAreaSetting(), info.getFloatInfo(), isMark);
            }
        });
        invoker.startToInvoke();
    }

    public static void dealSpecialCells(IFormView view, String spreadKey, ISheetManager sm, boolean isMark, boolean isFromTemplate) {
        List areaSettings = sm.getAreaRanges();
        SpreadEasyInvoker invoker = new SpreadEasyInvoker((IClientViewProxy)view.getService(IClientViewProxy.class), spreadKey);
        invoker.setBatch(true);
        if (CollectionUtils.isNotEmpty((Collection)areaSettings)) {
            ArrayList<SequenceInfo> sequenceInfos = new ArrayList<SequenceInfo>(16);
            areaSettings.forEach(m -> {
                MarkSpecialCellHelper.markSpecialCells(invoker, m, isMark);
                if (isFromTemplate && CollectionUtils.isNotEmpty((Collection)m.getSequenceInfos())) {
                    sequenceInfos.addAll(m.getSequenceInfos());
                }
            });
            if (CollectionUtils.isNotEmpty(sequenceInfos)) {
                SequenceSettingHelper.markSeqAreaCells(sequenceInfos, sm, isMark, invoker);
            }
        }
        invoker.startToInvoke();
    }

    public static void drawMarkPoint(IPageCache pageCache, IFormView view, ISheetManager sm, String spreadKey, boolean isclean, boolean isFromTemplate) {
        String s = pageCache.get(OLDSPREAD);
        if (StringUtils.isNotEmpty((CharSequence)s)) {
            SheetManager oldSm = (SheetManager)ObjectSerialUtil.deSerializedBytes((String)s);
            MarkSpecialCellHelper.dealSpecialCells(view, spreadKey, (ISheetManager)oldSm, false, isFromTemplate);
        }
        MarkSpecialCellHelper.dealSpecialCells(view, spreadKey, sm, true, isFromTemplate);
        if (isclean) {
            pageCache.remove(OLDSPREAD);
        }
    }

    public static List<Map<String, Object>> getMarkPointParms(RangeModel rangeModel, String color, boolean mark) {
        ArrayList<Map<String, Object>> markRedPoints = new ArrayList<Map<String, Object>>(16);
        if (rangeModel.getX_start() == rangeModel.getX_end() && rangeModel.getY_start() == rangeModel.getY_end()) {
            markRedPoints.add(MarkSpecialCellHelper.packedCellMap(rangeModel.getY_start(), rangeModel.getX_start(), mark, Lists.newArrayList((Object[])new Integer[]{0, 2}), color));
        } else {
            markRedPoints.add(MarkSpecialCellHelper.packedCellMap(rangeModel.getY_start(), rangeModel.getX_start(), mark, Lists.newArrayList((Object[])new Integer[]{0}), color));
            markRedPoints.add(MarkSpecialCellHelper.packedCellMap(rangeModel.getY_end(), rangeModel.getX_end(), mark, Lists.newArrayList((Object[])new Integer[]{2}), color));
        }
        return markRedPoints;
    }

    public static Map<String, Object> packedCellMap(int r, int c, boolean isNeedMark, List<Integer> indexs, String color) {
        HashMap<String, Object> features = new HashMap<String, Object>(16);
        features.put("r", r);
        features.put("c", c);
        features.put("st", isNeedMark);
        features.put("pos", indexs);
        features.put("bc", color);
        return features;
    }
}

