/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.ITemplateModel;
import org.apache.commons.collections4.CollectionUtils;

public class SetFilterDimHelper {
    public static final String DIMMAPS_KEY = "dimMaps";
    public static final String FILTERDIMS_KEY = "filterDims";
    public static final String CACHE_SET_FILTER_DIM = "CACHE_SET_FILTER_DIM";
    public static final String SET_FILTER_DIM = "setfilterdim";
    public static final String CALLBACK_SET_FILTER_DIM = "callback_setfilterdim";

    public static SetFilterDimHelper getInstance() {
        return InnerClass.instance;
    }

    public String getEpbsTplSetfilterDim() {
        return "epbs_tplsetfilterdim";
    }

    public FormShowParameter getSetFilterDimFormShowParameter(List<Map<String, String>> rangeDims, IPageCache pageCache, AbstractFormPlugin plugin) {
        String dimMaps = SerializationUtils.toJsonString(rangeDims);
        List<String> filterDims = this.getFilterDimsByCache(pageCache);
        String filterDimsCache = "";
        if (filterDims.size() > 0) {
            filterDimsCache = SerializationUtils.toJsonString(filterDims);
        }
        FormShowParameter showParam = new FormShowParameter();
        showParam.getOpenStyle().setShowType(ShowType.Modal);
        showParam.setFormId(this.getEpbsTplSetfilterDim());
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.put(DIMMAPS_KEY, dimMaps);
        params.put(FILTERDIMS_KEY, filterDimsCache);
        showParam.setCustomParams(params);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, CALLBACK_SET_FILTER_DIM);
        showParam.setCloseCallBack(closeCallBack);
        return showParam;
    }

    public List<String> getFilterDimsByCache(IPageCache pageCache) {
        List<String> filterDims = new ArrayList<String>(16);
        String filterDimsCache = pageCache.get(CACHE_SET_FILTER_DIM);
        if (StringUtils.isNotEmpty((String)filterDimsCache)) {
            filterDims = (List)SerializationUtils.fromJsonString((String)filterDimsCache, List.class);
        }
        return filterDims;
    }

    public void loadFilterDimsCache(ITemplateModel template, IPageCache pageCache) {
        if (template != null && CollectionUtils.isNotEmpty((Collection)template.getFilterDims())) {
            List filterDims = template.getFilterDims();
            if (filterDims != null && filterDims.size() > 0) {
                String f7dimSetFilterJson = SerializationUtils.toJsonString((Object)filterDims);
                pageCache.put(CACHE_SET_FILTER_DIM, f7dimSetFilterJson);
            } else {
                pageCache.remove(CACHE_SET_FILTER_DIM);
            }
        }
    }

    public void fillBack2TemplateModelFilterDims(ITemplateModel templateModel, IPageCache pageCache) {
        String f7dimFilterJson = pageCache.get(CACHE_SET_FILTER_DIM);
        if (StringUtils.isNotEmpty((String)f7dimFilterJson)) {
            List filterDimNumbers = (List)SerializationUtils.fromJsonString((String)f7dimFilterJson, List.class);
            templateModel.setFilterDims(filterDimNumbers);
        } else {
            templateModel.getFilterDims().clear();
        }
    }

    public void setFilterDimCallBack(ClosedCallBackEvent evt, IPageCache pageCache) {
        if (evt.getReturnData() == null) {
            return;
        }
        if (evt.getReturnData() instanceof String && StringUtils.isNotEmpty((String)((String)evt.getReturnData()))) {
            String returnData = (String)evt.getReturnData();
            List selDimNumbers = (List)SerializationUtils.fromJsonString((String)returnData, List.class);
            this.setSetFilterDimsCache(selDimNumbers, pageCache);
        }
    }

    public void setSetFilterDimsCache(List<String> f7Items, IPageCache pageCache) {
        if (f7Items != null && f7Items.size() > 0) {
            String f7dimSetFilterJson = SerializationUtils.toJsonString(f7Items);
            pageCache.put(CACHE_SET_FILTER_DIM, f7dimSetFilterJson);
        } else {
            pageCache.remove(CACHE_SET_FILTER_DIM);
        }
    }

    public void removeSetFilterDimsCache(Collection<String> rangeDims, IPageCache pageCache) {
        if (CollectionUtils.isEmpty(rangeDims)) {
            pageCache.remove(CACHE_SET_FILTER_DIM);
            return;
        }
        List<String> filterDims = this.getFilterDimsByCache(pageCache);
        if (CollectionUtils.isNotEmpty(filterDims)) {
            filterDims.removeIf(e -> !rangeDims.contains(e));
            this.setSetFilterDimsCache(filterDims, pageCache);
        }
    }

    private static class InnerClass {
        private static SetFilterDimHelper instance = new SetFilterDimHelper();

        private InnerClass() {
        }
    }
}

