/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template.helper;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.base.CharMatcher;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.common.spread.sheet.Cell;
import kd.epm.emr.common.spread.sheet.ISheet;
import kd.epm.emr.common.spread.sheet.Sheet;
import kd.epm.emr.common.spread.util.CellUserObjectHelper;
import kd.epm.epbs.common.util.ExcelUtils;
import kd.epm.epbs.common.util.ObjectSerialUtil;
import kd.epm.epbs.common.util.Pair;
import org.apache.commons.lang3.StringUtils;

public class SpreadJsonHelper {
    private static final String CELL_FORMULA = "formula";
    private static final String CELL_VALUE = "value";
    private static final String CELL_LOCKED = "locked";
    private static final String CELL_STYLE = "style";
    private static final String SHEETS = "sheets";
    private static final String DATA = "data";
    private static final String DATATABLE = "dataTable";
    private static String AMOUNT_PATTERN = "^\\(?((-?([0-9]+|[0-9]{1,3}(,[0-9]{3})*))(\\.[0-9]{1,})?)\\)?$";

    public static void syncSpreadCellToSm(String spreadJson, ISheetManager sm, String sheetName) {
        if (StringUtils.isEmpty((CharSequence)spreadJson)) {
            return;
        }
        JSONObject jsonObject = SpreadJsonHelper.parseObjectOrder(spreadJson);
        JSONObject dataTable = SpreadJsonHelper.getDataTable(jsonObject, sheetName);
        if (dataTable == null) {
            return;
        }
        SpreadJsonHelper.setTemplateLockedCellStatus(dataTable, sm);
        SpreadJsonHelper.syncValueAndFormulaToSm(sm, SpreadJsonHelper.collectValuesAndFormulas(dataTable), true, true, false);
    }

    private static boolean checkValueEqual(Object value1, Object value2, boolean isOnlyExcel) {
        if (value1 instanceof Number && value2 instanceof Number) {
            BigDecimal bigDecimal2;
            BigDecimal bigDecimal = new BigDecimal(value1.toString());
            return bigDecimal.compareTo(bigDecimal2 = new BigDecimal(value2.toString())) != 0;
        }
        if (value1 == value2) {
            return false;
        }
        if (value1 != null) {
            if (value2 != null) {
                return !value1.toString().trim().equals(value2.toString().trim());
            }
        } else if (isOnlyExcel && value2.toString().equals("0")) {
            return false;
        }
        return true;
    }

    private static Object syncValueAndFormulaToSm(ISheetManager sm, Table<String, String, Pair<Object, String>> table, boolean isUpdateValue, boolean isUpdateFormula, boolean isNeedTips) {
        StringBuilder stringBuffer = new StringBuilder();
        AtomicBoolean flag = new AtomicBoolean(false);
        if (!table.isEmpty()) {
            ArrayList areas = new ArrayList(16);
            sm.getAreaRanges().forEach(ps -> areas.add(ps.getAreaRange()));
            Sheet sheet = (Sheet)sm.getSheet();
            sheet.iteratorCells(cell -> {
                Pair pair = (Pair)table.remove((Object)(cell.getRow() + ""), (Object)(cell.getCol() + ""));
                String formula = null;
                String cellFormula = cell.getFormula() == null ? "" : cell.getFormula().trim();
                boolean isChange = false;
                boolean isOnlyExcel = false;
                if (pair != null) {
                    if (isUpdateFormula) {
                        String string = formula = pair.p2 == null ? "" : ((String)pair.p2).trim();
                        if (!formula.equals(cellFormula)) {
                            cell.setFormula(StringUtils.isNotEmpty((CharSequence)formula) ? formula : null);
                            isChange = true;
                        }
                    }
                    if (cell.hasFormula()) {
                        // empty if block
                    }
                    if (isUpdateValue) {
                        Object value = pair.p1;
                        Object cellValue = cell.getValue();
                        if (SpreadJsonHelper.checkValueEqual(cellValue, value, isOnlyExcel)) {
                            cell.setValue(value);
                            flag.set(true);
                        }
                    }
                } else {
                    isChange = cell.hasFormula();
                    if (cell.getValue() != null || isChange) {
                        flag.set(true);
                        cell.setValue(null);
                        cell.setFormula(null);
                    }
                }
                if (isNeedTips && isUpdateFormula && isChange) {
                    String str = String.format(ResManager.loadKDString((String)"\u5355\u5143\u683c%s\u540e\u7aef\u516c\u5f0f\u7531%1$s\u6539\u4e3a%2$s", (String)"SpreadJsonHelper_0", (String)"epm-emr-formplugin", (Object[])new Object[0]), ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow()), kd.bos.util.StringUtils.isEmpty((String)cellFormula) ? "null" : cellFormula, kd.bos.util.StringUtils.isNotEmpty((String)formula) ? formula : "null");
                    stringBuffer.append(str).append(";");
                }
            });
            if (!table.isEmpty()) {
                table.rowMap().forEach((row, v) -> v.forEach((col, pair) -> {
                    if (pair != null) {
                        Cell cell = sheet.getCell(Integer.parseInt(row), Integer.parseInt(col));
                        if (isUpdateValue && pair.p1 != null && StringUtils.isNotEmpty((CharSequence)pair.p1.toString())) {
                            flag.set(true);
                            cell.setValue(pair.p1);
                        }
                        if (isUpdateFormula && StringUtils.isNotEmpty((CharSequence)((CharSequence)pair.p2))) {
                            cell.setFormula(((String)pair.p2).trim());
                            if (isNeedTips) {
                                String str = String.format(ResManager.loadKDString((String)"\u5355\u5143\u683c%s\u540e\u7aef\u516c\u5f0f\u7531%1$s\u6539\u4e3a%2$s", (String)"SpreadJsonHelper_0", (String)"epm-emr-formplugin", (Object[])new Object[0]), ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow()), "null", ((String)pair.p2).trim());
                                stringBuffer.append(str).append(";");
                            }
                        }
                    }
                }));
            }
        }
        if (isUpdateFormula && !isUpdateValue && isNeedTips) {
            return stringBuffer.toString();
        }
        if (isUpdateValue && !isUpdateFormula) {
            return flag.get();
        }
        return null;
    }

    public static void setTemplateLockedCellStatus(JSONObject dataTable, ISheetManager sm) {
        if (dataTable == null) {
            return;
        }
        ISheet sheet = sm.getSheet();
        int maxRowCount = sheet.getMaxRowCount();
        int maxColumnCount = sheet.getMaxColumnCount();
        dataTable.forEach((row, v) -> {
            if (v instanceof JSONObject) {
                JSONObject cols = (JSONObject)v;
                cols.forEach((col, o) -> {
                    if (!(o instanceof JSONObject)) {
                        return;
                    }
                    JSONObject cell = (JSONObject)o;
                    if (!(cell.get((Object)CELL_STYLE) instanceof JSONObject)) {
                        return;
                    }
                    JSONObject style = (JSONObject)cell.get((Object)CELL_STYLE);
                    Boolean locked = false;
                    if (style.get((Object)CELL_LOCKED) instanceof Boolean) {
                        locked = (Boolean)style.get((Object)CELL_LOCKED);
                    }
                    Cell c = null;
                    if (locked.booleanValue() || Integer.parseInt(row) <= maxRowCount - 1 && Integer.parseInt(col) <= maxColumnCount - 1) {
                        c = sheet.getCell(Integer.parseInt(row), Integer.parseInt(col), locked.booleanValue());
                    }
                    if (c != null && !Boolean.valueOf(CellUserObjectHelper.isLock((Cell)c)).equals(locked)) {
                        CellUserObjectHelper.setLock((Cell)c, (boolean)locked);
                        c.setUserObject("c_l", (Object)true);
                    }
                });
            }
        });
    }

    private static Table<String, String, Pair<Object, String>> collectValuesAndFormulas(JSONObject dataJsonObj) {
        HashBasedTable table = HashBasedTable.create();
        for (Map.Entry row : dataJsonObj.entrySet()) {
            if (row == null) continue;
            for (Map.Entry cell : ((JSONObject)row.getValue()).entrySet()) {
                if (cell == null || !(cell.getValue() instanceof JSONObject)) continue;
                Object value = null;
                String formula = null;
                Object formulaObj = ((JSONObject)cell.getValue()).get((Object)CELL_FORMULA);
                Object valueObj = ((JSONObject)cell.getValue()).get((Object)CELL_VALUE);
                if (valueObj instanceof String && !valueObj.toString().contains("_calcError")) {
                    value = SpreadJsonHelper.trim(valueObj.toString());
                } else if (valueObj instanceof Number || valueObj instanceof Character || valueObj == null) {
                    value = valueObj;
                }
                if (formulaObj != null) {
                    formula = formulaObj.toString();
                }
                if (value == null && formula == null) continue;
                value = SpreadJsonHelper.dealValue(value);
                table.put(row.getKey(), cell.getKey(), (Object)Pair.onePair((Object)value, (Object)formula));
            }
        }
        return table;
    }

    public static JSONObject parseObjectOrder(String spreadJson) {
        return JSONObject.parseObject((String)ObjectSerialUtil.uncompress((String)spreadJson), (Feature[])new Feature[]{Feature.OrderedField});
    }

    public static JSONObject getDataTable(JSONObject object, String sheetname) {
        JSONObject sheets = (JSONObject)object.get((Object)SHEETS);
        JSONObject sheet = (JSONObject)sheets.values().iterator().next();
        if (sheets.containsKey((Object)sheetname)) {
            sheet = (JSONObject)sheets.get((Object)sheetname);
        }
        JSONObject data = (JSONObject)sheet.get((Object)DATA);
        return (JSONObject)data.get((Object)DATATABLE);
    }

    public static String trim(String str) {
        return CharMatcher.anyOf((CharSequence)" \u000b\f\u00a0\u0085\u1680\u180e\ufeff\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u200b\u2028\u2029\u202f\u205f\u3000").trimFrom((CharSequence)str);
    }

    public static Object dealValue(Object val) {
        if (val instanceof String && SpreadJsonHelper.isNotSupportExcelFormat(val.toString()) && !StringUtils.isNumeric((CharSequence)val.toString())) {
            String vdata = SpreadJsonHelper.removeAmountSign(val.toString().trim()).trim();
            boolean isNegative = vdata.startsWith("(");
            String validateData = vdata.replaceAll("\\(", "").replaceAll("\\)", "").replaceAll(",", "");
            if (!validateData.startsWith("-") && isNegative) {
                validateData = "-" + validateData;
            }
            val = new BigDecimal(validateData);
        }
        return val;
    }

    protected static boolean isNotSupportExcelFormat(String data) {
        return StringUtils.isNotEmpty((CharSequence)data) && Pattern.matches(AMOUNT_PATTERN, data.trim());
    }

    private static String removeAmountSign(String data) {
        return data.replaceAll("[\\\\$,S\\\\$,\u00a3,\u00a5]", "");
    }
}

