/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.epm.emr.business.template.ISheetManager;
import kd.epm.emr.business.template.SequenceInfo;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.areasetting.IFloatInfo;
import kd.epm.emr.business.template.relation.RelationAreaInfo;
import kd.epm.emr.common.spread.domain.view.builder.dynamic.event.AdjustRangeEvent;
import kd.epm.emr.common.spread.domain.view.event.NotifyEvent;
import kd.epm.emr.common.template.enums.FloatTypeEnum;
import kd.epm.emr.common.template.enums.RowColExcuteEnum;
import kd.epm.emr.formplugin.spread.AskExcuteInfo;
import kd.epm.epbs.common.util.ExcelUtils;
import kd.epm.epbs.common.util.RangeModel;
import org.apache.commons.collections4.CollectionUtils;

public class TemplateAreaManagerHelper {
    private static <RelationModelBean> int checkRelationDataArea(AskExcuteInfo info, RangeModel rangeModel, RelationAreaInfo relationAreaInfo, boolean isReport, Function<String, RelationModelBean> function) {
        boolean isRow = info.getOperation() == 0;
        boolean isAdd = RowColExcuteEnum.INSERTROW == info.getMethod() || RowColExcuteEnum.INSERTCOL == info.getMethod();
        List<Integer> datas = info.getOperationdata();
        int delRows = 0;
        if (function != null) {
            for (Integer s : datas) {
                if (isAdd) {
                    if (isRow || !isReport || !rangeModel.isColInArea(s.intValue())) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u5173\u7cfb\u533a\u57df\u5185\u4e0d\u5141\u8bb8\u63d2\u5165\u548c\u5220\u9664\u5217\u3002", (String)"TemplateAreaManagerHelper_0", (String)"epm-emr-formplugin", (Object[])new Object[0]));
                }
                if (isRow) {
                    if (!isReport || !rangeModel.isRowInArea(s.intValue())) continue;
                    ++delRows;
                    continue;
                }
                if (!rangeModel.isColInArea(s.intValue()) || !isReport) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u5173\u7cfb\u533a\u57df\u5185\u4e0d\u5141\u8bb8\u63d2\u5165\u548c\u5220\u9664\u5217\u3002", (String)"TemplateAreaManagerHelper_0", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            }
        }
        return delRows;
    }

    private static void checkFixDimDataArea(List<Integer> datas, RangeModel rangeModel, boolean isRow, IDataAreaSetting m) {
        boolean isNeedTips = false;
        for (Integer d : datas) {
            if ((!isRow || !rangeModel.isRowInArea(d.intValue())) && (isRow || !rangeModel.isColInArea(d.intValue()))) continue;
            if (FloatTypeEnum.NONE == m.getFloatOnWhere()) {
                isNeedTips = true;
                break;
            }
            if (FloatTypeEnum.ROW == m.getFloatOnWhere()) {
                if (isRow && (!isRow || m.getFloatInfos().stream().anyMatch(f -> m.getFloatRange(f, rangeModel).isRowInArea(d.intValue())))) continue;
                isNeedTips = true;
                break;
            }
            if (FloatTypeEnum.COL != m.getFloatOnWhere() || !isRow && (isRow || !m.getFloatInfos().stream().anyMatch(f -> m.getFloatRange(f, rangeModel).isColInArea(d.intValue())))) continue;
            isNeedTips = true;
            break;
        }
        if (isNeedTips) {
            throw new KDBizException(ResManager.loadKDString((String)"\u56fa\u5b9a\u533a\u57df\u5185\u4e0d\u5141\u8bb8\u63d2\u5165\u548c\u5220\u9664\u884c\u5217\u3002", (String)"TemplateAreaManagerHelper_1", (String)"epm-emr-formplugin", (Object[])new Object[0]));
        }
    }

    private static void checkFloatDimDataArea(IDataAreaSetting m, RangeModel rangeModel, AskExcuteInfo info, boolean isReport) {
        if (CollectionUtils.isNotEmpty((Collection)m.getFloatInfos())) {
            boolean isRow = info.getOperation() == 0;
            boolean isAdd = RowColExcuteEnum.INSERTROW == info.getMethod() || RowColExcuteEnum.INSERTCOL == info.getMethod();
            List<Integer> datas = info.getOperationdata();
            for (IFloatInfo f : m.getFloatInfos()) {
                int delRows = 0;
                RangeModel floatRange = m.getFloatRange(f, rangeModel);
                boolean isRowFloat = FloatTypeEnum.ROW == f.getFloatType();
                for (Integer data : datas) {
                    if (isAdd) {
                        if (isRow) {
                            if (!floatRange.isRowInArea(data.intValue()) || isRowFloat) continue;
                            throw new KDBizException(TemplateAreaManagerHelper.getRowOrColTips(isReport, false));
                        }
                        if (!isRowFloat || !floatRange.isColInArea(data.intValue())) continue;
                        throw new KDBizException(TemplateAreaManagerHelper.getRowOrColTips(isReport, true));
                    }
                    if (isRow) {
                        if (!floatRange.isRowInArea(data.intValue())) continue;
                        if (isRowFloat) {
                            ++delRows;
                            continue;
                        }
                        if (!isReport) continue;
                        throw new KDBizException(TemplateAreaManagerHelper.getRowOrColTips(isReport, false));
                    }
                    if (!floatRange.isColInArea(data.intValue())) continue;
                    if (!isRowFloat) {
                        ++delRows;
                        continue;
                    }
                    if (!isReport) continue;
                    throw new KDBizException(TemplateAreaManagerHelper.getRowOrColTips(isReport, true));
                }
                if (delRows == 0 || !isReport || (!isRowFloat || floatRange.getRowSize() != delRows) && (isRowFloat || floatRange.getColSize() != delRows)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0d\u8981\u5220\u9664\u5168\u90e8\u6d6e\u52a8\u533a\u57df\u884c/\u5217\u3002", (String)"TemplateAreaManagerHelper_2", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private static void checkDimDataArea(AskExcuteInfo info, RangeModel rangeModel, IDataAreaSetting m, boolean isReport) {
        if (isReport) {
            TemplateAreaManagerHelper.checkFixDimDataArea(info.getOperationdata(), rangeModel, info.getOperation() == 0, m);
        }
        TemplateAreaManagerHelper.checkFloatDimDataArea(m, rangeModel, info, isReport);
    }

    public static <RelationModelBean> void rowColOperationCheck(NotifyEvent notifyEvent, ISheetManager sm, boolean isReport, Function<String, RelationModelBean> function) {
        if (!sm.hasAreaRange()) {
            return;
        }
        AskExcuteInfo info = (AskExcuteInfo)notifyEvent.getSource();
        boolean isAdd = RowColExcuteEnum.INSERTROW == info.getMethod() || RowColExcuteEnum.INSERTCOL == info.getMethod();
        for (IDataAreaSetting m : sm.getAreaRanges()) {
            RangeModel rangeModel = new RangeModel(m.getAreaRange());
            if (m.isRelation()) {
                int delRows = TemplateAreaManagerHelper.checkRelationDataArea(info, rangeModel, m.getRelationAreaInfo(), isReport, function);
                if (!isReport || isAdd || rangeModel.getRowSize() != delRows) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0d\u8981\u5220\u9664\u5168\u90e8\u533a\u57df\u884c/\u5217\u3002", (String)"TemplateAreaManagerHelper_3", (String)"epm-emr-formplugin", (Object[])new Object[0]));
            }
            TemplateAreaManagerHelper.checkDimDataArea(info, rangeModel, m, isReport);
        }
    }

    private static String getRowOrColTips(boolean isReport, boolean isRow) {
        String tips = isReport ? (isRow ? ResManager.loadKDString((String)"\u884c\u6d6e\u52a8\u65f6\uff0c\u4e0d\u5141\u8bb8\u5728\u6d6e\u52a8\u533a\u57df\u63d2\u5165\u548c\u5220\u9664\u5217\u3002", (String)"TemplateAreaManagerHelper_4", (String)"epm-emr-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5217\u6d6e\u52a8\u65f6\uff0c\u4e0d\u5141\u8bb8\u5728\u6d6e\u52a8\u533a\u57df\u63d2\u5165\u548c\u5220\u9664\u884c\u3002", (String)"TemplateAreaManagerHelper_5", (String)"epm-emr-formplugin", (Object[])new Object[0])) : (isRow ? ResManager.loadKDString((String)"\u884c\u6d6e\u52a8\u65f6\uff0c\u4e0d\u5141\u8bb8\u5728\u6d6e\u52a8\u533a\u57df\u63d2\u5165\u5217\u3002", (String)"TemplateAreaManagerHelper_6", (String)"epm-emr-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5217\u6d6e\u52a8\u65f6\uff0c\u4e0d\u5141\u8bb8\u5728\u6d6e\u52a8\u533a\u57df\u63d2\u5165\u884c\u3002", (String)"TemplateAreaManagerHelper_7", (String)"epm-emr-formplugin", (Object[])new Object[0]));
        return tips;
    }

    public static String setDataAreaBeforeCheck(String selectArea, List<IDataAreaSetting> settings) {
        String msg = "";
        if (StringUtils.isEmpty((CharSequence)selectArea)) {
            msg = ResManager.loadKDString((String)"\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateAreaManagerHelper_8", (String)"epm-emr-formplugin", (Object[])new Object[0]);
        } else if (selectArea.indexOf(58) == -1) {
            msg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5355\u5143\u683c\u8303\u56f4\u3002", (String)"TemplateAreaManagerHelper_9", (String)"epm-emr-formplugin", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            return msg;
        }
        if (CollectionUtils.isNotEmpty(settings)) {
            RangeModel selectRange = new RangeModel(selectArea);
            for (IDataAreaSetting ps : settings) {
                String areaRange = ps.getAreaRange();
                if (ExcelUtils.isOverlap((String)areaRange, (String)selectArea)) continue;
                if (CollectionUtils.isNotEmpty((Collection)ps.getFloatInfos())) {
                    RangeModel rangeModel = new RangeModel(areaRange);
                    for (IFloatInfo f : ps.getFloatInfos()) {
                        RangeModel floatRange = ps.getFloatRange(f, rangeModel);
                        if (FloatTypeEnum.ROW == f.getFloatType()) {
                            if (selectRange.getY_start() > floatRange.getY_end() || selectRange.getY_end() < floatRange.getY_start()) continue;
                            return ResManager.loadKDString((String)"\u9009\u4e2d\u884c\u5b58\u5728\u6d6e\u52a8\u7684\u6570\u636e\u533a\u57df\uff0c\u4e0d\u652f\u6301\u5728\u5de6\u53f3\u65b0\u589e\u6570\u636e\u533a\u57df\u3002", (String)"TemplateAreaManagerHelper_10", (String)"epm-emr-formplugin", (Object[])new Object[0]);
                        }
                        if (selectRange.getX_start() > floatRange.getX_end() || selectRange.getX_end() < floatRange.getX_start()) continue;
                        return ResManager.loadKDString((String)"\u9009\u4e2d\u5217\u5b58\u5728\u6d6e\u52a8\u7684\u6570\u636e\u533a\u57df\uff0c\u4e0d\u652f\u6301\u5728\u4e0a\u4e0b\u65b0\u589e\u6570\u636e\u533a\u57df\u3002", (String)"TemplateAreaManagerHelper_11", (String)"epm-emr-formplugin", (Object[])new Object[0]);
                    }
                }
                if (CollectionUtils.isNotEmpty((Collection)ps.getSequenceInfos()) && ps.getSequenceInfos().stream().anyMatch(s -> ExcelUtils.isOverlap((String)selectArea, (String)s.getSeqArea()))) {
                    return ResManager.loadKDString((String)"\u9009\u4e2d\u533a\u57df\u4e0e\u884c\u6b21\u533a\u57df\u91cd\u5408\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u6570\u636e\u533a\u57df\u3002", (String)"TemplateAreaManagerHelper_12", (String)"epm-emr-formplugin", (Object[])new Object[0]);
                }
                if (FloatTypeEnum.ROWCOL != ps.getFloatOnWhere()) continue;
                return ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u884c\u5217\u540c\u65f6\u6d6e\u52a8\u7684\u6570\u636e\u533a\u57df\uff0c\u4e0d\u5141\u8bb8\u518d\u8bbe\u7f6e\u6570\u636e\u533a\u57df\u3002", (String)"TemplateAreaManagerHelper_13", (String)"epm-emr-formplugin", (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static void sortAreaSettings(ISheetManager sm) {
        Comparator<IDataAreaSetting> firstComparator = Comparator.comparingInt(c -> new RangeModel(c.getAreaRange()).getY_start());
        Comparator<IDataAreaSetting> thanComparator = Comparator.comparingInt(c -> new RangeModel(c.getAreaRange()).getX_start());
        if (sm.hasAreaRange()) {
            sm.getAreaRanges().sort(firstComparator.thenComparing(thanComparator));
            Comparator<IFloatInfo> firstComparator_float = Comparator.comparingInt(c -> c.getCol_offset());
            Comparator<IFloatInfo> thanComparator_float = Comparator.comparingInt(c -> c.getRow_offset());
            for (IDataAreaSetting areaSetting : sm.getAreaRanges()) {
                if (!CollectionUtils.isNotEmpty((Collection)areaSetting.getFloatInfos())) continue;
                areaSetting.getFloatInfos().sort(firstComparator_float.thenComparing(thanComparator_float));
            }
        }
    }

    public static void adjustMultiAreaSetting(Set<SequenceInfo> removeSequenceInfo, AdjustRangeEvent adjustRangeEvent, ISheetManager sm, boolean isFromReport) {
        sm.getAreaRanges().forEach(p -> {
            ArrayList oldInfos = new ArrayList(p.getSequenceInfos());
            p.adjustRange(adjustRangeEvent, isFromReport);
            RangeModel rangeModel = new RangeModel(p.getAreaRange());
            if (CollectionUtils.isNotEmpty(oldInfos)) {
                List newInfos = p.getSequenceInfos();
                if (rangeModel.getX_start() > rangeModel.getX_end() || rangeModel.getY_start() > rangeModel.getY_end() || CollectionUtils.isEmpty((Collection)newInfos)) {
                    removeSequenceInfo.addAll(oldInfos);
                } else if (CollectionUtils.isNotEmpty((Collection)newInfos)) {
                    for (int index = 0; index < newInfos.size(); ++index) {
                        if (newInfos.get(index) != null) continue;
                        removeSequenceInfo.add((SequenceInfo)oldInfos.get(index));
                    }
                    newInfos.removeIf(Objects::isNull);
                }
            }
        });
    }

    public static void adjustMultiAreaSetting(Set<SequenceInfo> removeSequenceInfo, ISheetManager sm, AskExcuteInfo askExcuteInfo, boolean isFromReport) {
        boolean deleteOrAdd = askExcuteInfo.getMethod() == RowColExcuteEnum.DELETECOL || askExcuteInfo.getMethod() == RowColExcuteEnum.DELETEROW;
        askExcuteInfo.getOperationdata().forEach(i -> TemplateAreaManagerHelper.adjustMultiAreaSetting(removeSequenceInfo, new AdjustRangeEvent(i.intValue(), askExcuteInfo.getOperation(), deleteOrAdd ? -1 : 1, askExcuteInfo.isCheck(), askExcuteInfo.isRev()), sm, isFromReport));
        askExcuteInfo.getBatchOperationData().forEach(dealdata -> TemplateAreaManagerHelper.adjustMultiAreaSetting(removeSequenceInfo, new AdjustRangeEvent(dealdata.getOprtPosition(), askExcuteInfo.getOperation(), dealdata.getSize() * (deleteOrAdd ? -1 : 1), askExcuteInfo.isCheck(), askExcuteInfo.isRev()), sm, isFromReport));
    }

    public static void correctionAreaSettings(ISheetManager sm) {
        List multiAreaSettings = sm.getAreaRanges();
        if (CollectionUtils.isNotEmpty((Collection)multiAreaSettings)) {
            HashSet removeAreas = new HashSet(16);
            multiAreaSettings.forEach(m -> {
                String[] area = m.getAreaRange().split(":");
                int startcol = ExcelUtils.pos2X((String)area[0]);
                int startrow = ExcelUtils.pos2Y((String)area[0]);
                int endcol = ExcelUtils.pos2X((String)area[1]);
                int endrow = ExcelUtils.pos2Y((String)area[1]);
                if (startrow < 0 || endrow < 0 || startrow > endrow || startcol > endcol) {
                    removeAreas.add(m);
                }
            });
            if (CollectionUtils.isNotEmpty(removeAreas)) {
                multiAreaSettings.removeAll(removeAreas);
            }
            sm.setAreaRanges(multiAreaSettings);
        }
    }
}

