/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.ControlAp;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.template.dimension.DefaultDimension;
import kd.epm.emr.business.template.dimension.IDimension;
import kd.epm.emr.business.template.quote.QuoteTypeEnum;
import kd.epm.emr.common.template.EmrDefaultDimMember;
import kd.epm.emr.formplugin.template.ITemplateDynamicPage;
import kd.epm.epbs.common.constant.TemplateConstant;
import kd.epm.epbs.common.model.IDimensionMember;
import kd.epm.epbs.common.model.PropertyEntry;
import kd.epm.epbs.common.model.bean.relation.FieldBean;
import kd.epm.epbs.common.util.IDUtils;

public class TemplateDynamicPageHelper
implements TemplateConstant {
    private static final Log log = LogFactory.getLog(TemplateDynamicPageHelper.class);
    private IPageCache pageCache;
    private Set<String> dropPanel = Sets.newHashSet();

    private TemplateDynamicPageHelper(IPageCache pageCache) {
        this.pageCache = pageCache;
    }

    public static TemplateDynamicPageHelper getInstance(IPageCache pageCache) {
        return new TemplateDynamicPageHelper(pageCache);
    }

    public IPageCache getPageCache() {
        return this.pageCache;
    }

    public void cleanAllPoint() {
        this.getPageCache().remove("allPoint");
    }

    public void updateAllPoint(List<Map<String, String>> list) {
        this.getPageCache().put("allPoint", SerializationUtils.toJsonString(list));
    }

    public void cacheAllPoint(List<Map<String, String>> list) {
        if (!list.isEmpty()) {
            ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>(16);
            List<Map<String, String>> ap = this.getAllPoint();
            if (ap != null) {
                mapList.addAll(ap);
            }
            mapList.addAll(list);
            this.updateAllPoint(mapList);
        }
    }

    public void updateAllPointMapBySign(String sign, String value) {
        List<Map<String, String>> ap = this.getAllPoint();
        if (ap != null) {
            ap.forEach(map -> {
                if (((String)map.get("sign")).equals(sign)) {
                    map.put("value", value);
                }
            });
            this.updateAllPoint(ap);
        }
    }

    public List<Map<String, String>> getAllPoint() {
        List list = null;
        String seria = this.getPageCache().get("allPoint");
        list = StringUtils.isNotEmpty((String)seria) ? (List)SerializationUtils.fromJsonString((String)seria, List.class) : Lists.newArrayList();
        return list;
    }

    public List<Map<String, String>> getAllPoint(String panelSign) {
        return this.getAllPoint(this.getAllPoint(), panelSign);
    }

    public List<Map<String, String>> getAllPoint(List<Map<String, String>> allPoint, String panelSign) {
        return allPoint.stream().filter(e -> panelSign.equals(e.get("panel"))).collect(Collectors.toList());
    }

    public Map<String, String> getPointBySign(String sign) {
        return this.getAllPoint().stream().filter(e -> sign.equals(e.get("sign"))).findFirst().orElseGet(() -> Maps.newHashMap());
    }

    public Map<String, String> getDimMessageMap(String panelSign, IDimension dimension) {
        return this.getDimMessageMap(panelSign, dimension, false);
    }

    public Map<String, String> getDimMessageMap(String panelSign, IDimension dimension, boolean isFilterDim) {
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("id", String.valueOf(dimension.getId()));
        map.put("name", dimension.getName());
        map.put("number", dimension.getNumber());
        map.put("shortnumber", dimension.getShortNumber());
        map.put("entity", dimension.getMemberModel());
        map.put("seq", String.valueOf(dimension.getDSeq()));
        map.put("panel", panelSign);
        map.put("sign", this.buildSign(dimension.getMemberModel(), dimension.getNumber(), panelSign, QuoteTypeEnum.MEMBER.getValue()));
        return map;
    }

    public Map<String, String> getPropertyMessageMap(String panelSign, PropertyEntry property, String propertyEntity) {
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("id", String.valueOf(property.getId()));
        map.put("name", property.getName());
        map.put("number", property.getNumber());
        map.put("seq", String.valueOf(property.getDseq()));
        map.put("panel", panelSign);
        map.put("sign", this.buildSign(propertyEntity, String.valueOf(property.getId()), panelSign, QuoteTypeEnum.PROPERTY.getValue()));
        return map;
    }

    public Map<String, String> getFieldMessageMap(String panelSign, FieldBean field) {
        HashMap<String, String> map = new HashMap<String, String>(10);
        map.put("id", String.valueOf(field.getId()));
        map.put("name", field.getName());
        map.put("number", field.getNumber());
        map.put("panel", panelSign);
        map.put("sign", this.buildSign(field.getDataEntityNumber(), field.getNumber(), panelSign, QuoteTypeEnum.FIELD.getValue()));
        return map;
    }

    public Map<String, String> getDimMemberMessageMap(Long memberId, String memberNumber, String memberName, int scope, String type, Long viewId, String parentNum) {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("id", IDUtils.toString((Object)memberId));
        map.put("number", memberNumber);
        map.put("name", memberName);
        map.put("scope", String.valueOf(scope));
        if (StringUtils.isNotEmpty((String)type)) {
            map.put("type", type);
        }
        map.put("view", IDUtils.toString((Object)viewId));
        map.put("parentnum", parentNum);
        return map;
    }

    public IDimension buildDimension(Map<String, String> map) {
        return new DefaultDimension(IDUtils.toLong((Object)map.get("id")), map.get("name"), map.get("number"), Integer.valueOf(Integer.parseInt(map.get("seq"))));
    }

    public IDimensionMember buildDimensionMember(Map<String, String> map) {
        EmrDefaultDimMember member = new EmrDefaultDimMember(IDUtils.toLong((Object)map.get("id")), map.get("name"), map.get("number"), Integer.parseInt(map.get("scope")));
        String type = map.get("type");
        if (StringUtils.isEmpty((String)type)) {
            type = QuoteTypeEnum.MEMBER.getValue();
        }
        member.setType(type);
        member.setViewId(IDUtils.toLong((Object)map.get("view")));
        member.setParentNum(map.get("parentnum"));
        return member;
    }

    public String buildSign(String entity, String number, String panelSign, String signType) {
        if (StringUtils.isNotEmpty((String)signType)) {
            panelSign = panelSign + "!" + signType;
        }
        return (entity + "!" + number + "!" + panelSign).toLowerCase(Locale.ENGLISH);
    }

    public QuoteTypeEnum getSignType(String sign) {
        String[] p;
        if (StringUtils.isNotEmpty((String)sign) && (p = sign.split("!")).length >= 4) {
            return QuoteTypeEnum.getByValule((String)p[3]);
        }
        return null;
    }

    public Set<String> getDropPanel() {
        return this.dropPanel;
    }

    public void setDropPanel(Set<String> dropPanel) {
        this.dropPanel = dropPanel;
    }

    public String getPanelForEventArgs(String ekey) {
        if (this.getDropPanel() != null && this.getDropPanel().contains(ekey)) {
            return ekey;
        }
        Map<String, String> targetElementMap = this.getPointBySign(ekey);
        return targetElementMap.get("panel");
    }

    public Map<String, String> cloneMap(Map<String, String> sourceMap) {
        HashMap<String, String> newMap = new HashMap<String, String>(sourceMap.size());
        newMap.putAll(sourceMap);
        return newMap;
    }

    private void putValue(String sign, Object value) {
        String valueStr = value instanceof String ? (String)value : (value != null ? SerializationUtils.toJsonString((Object)value) : "");
        this.getPageCache().put(sign, valueStr);
    }

    private <T> T getValue(String sign, Class<T> valueType) {
        Object t = null;
        String seria = this.getPageCache().get(sign);
        if (StringUtils.isNotEmpty((String)seria)) {
            t = SerializationUtils.fromJsonString((String)seria, valueType);
        }
        return (T)t;
    }

    public void putDimMemberValue(String sign, Object value) {
        this.putValue(sign, value);
    }

    public void putDimMemberValueAndUpdateAllPoint(String sign, Object value, String mapValue) {
        this.putDimMemberValue(sign, value);
        this.updateAllPointMapBySign(sign, mapValue);
    }

    public void removeDimMemberValue(String sign) {
        this.getPageCache().remove(sign);
    }

    public List<Map<String, String>> getDimMemberValue(String sign) {
        List list = this.getValue(sign, List.class);
        if (list == null) {
            list = Lists.newArrayList();
        }
        return list;
    }

    public Map<String, String> getDimMemberValueMap(String sign) {
        Map map = this.getValue(sign, Map.class);
        if (map == null) {
            map = Maps.newHashMap();
        }
        return map;
    }

    public void putDimProperty(String sign, Object value) {
        this.putValue(sign, value);
    }

    public Map<String, String> getDimProperty(String sign) {
        Map map = this.getValue(sign, Map.class);
        if (map == null) {
            map = Maps.newHashMap();
        }
        return map;
    }

    public void removeDimProperty(String sign) {
        this.getPageCache().remove(sign);
    }

    public String elementDrop(String source, String target, List<Map<String, String>> mapList, ITemplateDynamicPage page) {
        String targetPanel = target;
        String sourcePanel = "";
        int sourceNum = -1;
        int targetNum = -1;
        boolean isPanel = this.getDropPanel().contains(target);
        HashMap<String, String> sourceMap = new HashMap(16);
        for (int i = 0; i < mapList.size(); ++i) {
            Map<String, String> map = mapList.get(i);
            String s = map.get("sign");
            if (source.equals(s)) {
                sourcePanel = map.get("panel");
                sourceNum = i;
                sourceMap = map;
                continue;
            }
            if (isPanel || !target.equals(s)) continue;
            targetPanel = map.get("panel");
            targetNum = i;
        }
        ArrayList params = Lists.newArrayList((Object[])new Object[]{source, target, mapList});
        String elementSign = (String)sourceMap.get("sign");
        Map<String, String> cloneMap = this.cloneMap(sourceMap);
        if (isPanel && sourcePanel.equals(target)) {
            int insertIndex = this.customInsertIndex(1, params, mapList.size(), page);
            if (insertIndex <= sourceNum) {
                ++sourceNum;
            }
            mapList.add(insertIndex, cloneMap);
            mapList.remove(sourceNum);
        } else if (isPanel) {
            cloneMap.put("panel", target);
            cloneMap.put("sign", elementSign.replace(sourcePanel, targetPanel));
            cloneMap.put("value", "");
            int insertIndex = this.customInsertIndex(2, params, mapList.size(), page);
            mapList.add(insertIndex, cloneMap);
            this.deleteElementMap(mapList, source, page);
            elementSign = cloneMap.get("sign");
        } else if (!targetPanel.equals(sourcePanel)) {
            cloneMap.put("panel", targetPanel);
            cloneMap.put("value", "");
            cloneMap.put("sign", elementSign.replace(sourcePanel, targetPanel));
            int insertIndex = this.customInsertIndex(3, params, targetNum, page);
            mapList.add(insertIndex, cloneMap);
            this.deleteElementMap(mapList, source, page);
            elementSign = cloneMap.get("sign");
        } else {
            int insertIndex = this.customInsertIndex(4, params, targetNum, page);
            if (insertIndex <= sourceNum) {
                ++sourceNum;
            }
            mapList.add(insertIndex, cloneMap);
            mapList.remove(sourceNum);
        }
        return elementSign;
    }

    public Integer customInsertIndex(int type, List<Object> params, int defIndex, ITemplateDynamicPage page) {
        Integer index = null;
        if (page != null) {
            index = page.customInsertIndex(type, params, defIndex);
        }
        return index != null ? index : defIndex;
    }

    public void deleteElementMap(List<Map<String, String>> mapList, String sign, ITemplateDynamicPage page) {
        if (null != page) {
            page.deleteElementMap(mapList, sign);
        }
    }

    public void setStyleZero(ControlAp ap) {
        this.setStylePaddingZero(ap);
        this.setStyleMarginZero(ap);
    }

    public void setStylePaddingZero(ControlAp ap) {
        ap.getStyle().getPadding().setRight("0px");
        ap.getStyle().getPadding().setLeft("0px");
        ap.getStyle().getPadding().setTop("0px");
        ap.getStyle().getPadding().setBottom("0px");
    }

    public void setStyleMarginZero(ControlAp ap) {
        ap.getStyle().getMargin().setLeft("0px");
        ap.getStyle().getMargin().setBottom("0px");
        ap.getStyle().getMargin().setRight("0px");
        ap.getStyle().getMargin().setTop("0px");
    }
}

