/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template.helper;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.emr.business.template.areasetting.IDataAreaSetting;
import kd.epm.emr.business.template.areasetting.IFloatInfo;
import kd.epm.emr.business.template.headerarea.IHeaderInfo;
import kd.epm.emr.business.template.headerarea.IHeaderObject;
import kd.epm.emr.common.spread.command.rangedefined.CellArea;
import kd.epm.emr.common.spread.command.rangedefined.OneCell;
import kd.epm.emr.common.spread.command.style.AreasStyle;
import kd.epm.emr.common.spread.command.style.CellStyleInfo;
import kd.epm.emr.common.spread.control.ISpreadContainer;
import kd.epm.emr.common.template.enums.FloatTypeEnum;
import kd.epm.epbs.common.enums.RangeEnum;
import kd.epm.epbs.common.enums.RangeF7PropertyCataEnum;
import kd.epm.epbs.common.model.IDimensionMember;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.PropBean;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsMemberCacheHelper;
import kd.epm.epbs.common.model.cache.EpbsPropCache;
import kd.epm.epbs.common.model.cache.EpbsPropCacheHelper;
import kd.epm.epbs.common.util.ExcelUtils;
import kd.epm.epbs.common.util.ICell;
import kd.epm.epbs.common.util.Pair;
import kd.epm.epbs.common.util.Point;
import kd.epm.epbs.common.util.RangeModel;
import kd.epm.epbs.common.util.SpreadAreaUtil;
import org.apache.commons.collections4.CollectionUtils;

public class TemplateProcessHelper {
    public static final String ROW = "row";
    public static final String COL = "col";
    public static final String ROWCOL = "rowcol";

    public static boolean validateArea(String area) {
        if (StringUtils.isEmpty((CharSequence)area.trim())) {
            return false;
        }
        String[] startEndPos = area.split(":");
        if (startEndPos.length == 2) {
            try {
                Point startPoint = ExcelUtils.pos2Point((String)startEndPos[0]);
                Point endPoint = ExcelUtils.pos2Point((String)startEndPos[1]);
                return startPoint.x <= endPoint.x && startPoint.y <= endPoint.y;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static String getValidFloatRange(IDataAreaSetting areaSetting, int floatOffset, boolean isRow) {
        if (areaSetting != null && areaSetting.getAreaRange() != null) {
            int rowColCount;
            CellArea cellArea = new CellArea(areaSetting.getAreaRange());
            int n = rowColCount = isRow ? areaSetting.getRowHeaders().size() : areaSetting.getColHeaders().size();
            if (isRow) {
                cellArea.setC(cellArea.getC() - rowColCount - floatOffset);
                cellArea.setCc(rowColCount);
            } else {
                cellArea.setR(cellArea.getR() - rowColCount - floatOffset);
                cellArea.setRc(rowColCount);
            }
            return cellArea.toString();
        }
        return null;
    }

    public static int getMaxFloatOffset(IDataAreaSetting areaSetting, boolean isRow) {
        if (areaSetting != null && areaSetting.getAreaRange() != null) {
            CellArea cellArea = new CellArea(areaSetting.getAreaRange());
            if (isRow) {
                return cellArea.getC() - areaSetting.getRowHeaders().size();
            }
            return cellArea.getR() - areaSetting.getColHeaders().size();
        }
        return 0;
    }

    public static int[] getReservedHeaderSize(IDataAreaSetting areaSetting) {
        int[] reservedRowColSize = new int[2];
        if (areaSetting != null) {
            RangeModel rangeModel = new RangeModel(areaSetting.getAreaRange());
            int rowFloatOffset = 0;
            int colFloatOffset = 0;
            for (IFloatInfo floatInfo : areaSetting.getFloatInfos()) {
                if (floatInfo.getRow_offset() > -1) {
                    rowFloatOffset = floatInfo.getFloat_offset();
                    continue;
                }
                if (floatInfo.getCol_offset() <= -1) continue;
                colFloatOffset = floatInfo.getFloat_offset();
            }
            reservedRowColSize[0] = rangeModel.getX_start() - rowFloatOffset;
            reservedRowColSize[1] = rangeModel.getY_start() - colFloatOffset;
        }
        return reservedRowColSize;
    }

    public static List<String> getFloatStartPos(IDataAreaSetting areaSetting, boolean isRow) {
        List startRowCols = Collections.EMPTY_LIST;
        if (areaSetting != null && areaSetting.getAreaRange() != null) {
            CellArea cellArea = new CellArea(areaSetting.getAreaRange());
            int maxFloatOffset = -1;
            if (isRow) {
                maxFloatOffset = cellArea.getC() - areaSetting.getRowHeaders().size();
                if (maxFloatOffset >= 0) {
                    cellArea.setC(0);
                    cellArea.setCc(maxFloatOffset + 1);
                }
            } else {
                maxFloatOffset = cellArea.getR() - areaSetting.getColHeaders().size();
                if (maxFloatOffset >= 0) {
                    cellArea.setR(0);
                    cellArea.setRc(maxFloatOffset + 1);
                }
            }
            if (maxFloatOffset >= 0) {
                Collection collection = isRow ? SpreadAreaUtil.getCol((String)cellArea.toString(), (boolean)true) : SpreadAreaUtil.getRow((String)cellArea.toString(), (boolean)true);
                startRowCols = collection instanceof List ? (List)collection : new ArrayList(collection);
            }
        }
        return startRowCols;
    }

    public static String getDimNumberOnRowCol(IDataAreaSetting multiAreaSetting, int row, int col, boolean isRow) {
        String dimNumber = null;
        if (multiAreaSetting != null) {
            List headerInfos = isRow ? multiAreaSetting.getRowHeaders() : multiAreaSetting.getColHeaders();
            int index = isRow ? col : row;
            IHeaderInfo headerInfo = null;
            if (headerInfos.size() > index && (headerInfo = (IHeaderInfo)headerInfos.get(index)) != null && "Dimension".equals(headerInfo.getType())) {
                dimNumber = headerInfo.getNumber();
            }
        }
        return dimNumber;
    }

    public static boolean isFloatOnRowCol(IDataAreaSetting multiAreaSetting, int row, int col, boolean isRow) {
        List floatInfos;
        if (multiAreaSetting != null && (floatInfos = multiAreaSetting.getFloatInfos()) != null && !floatInfos.isEmpty()) {
            CellArea cellArea = new CellArea(multiAreaSetting.getAreaRange());
            int relatedRow = row - cellArea.getR();
            int relatedCol = col - cellArea.getC();
            for (IFloatInfo floatInfo : floatInfos) {
                if (isRow && relatedRow >= floatInfo.getRow_offset() && relatedRow <= floatInfo.getRowEnd_offset()) {
                    return true;
                }
                if (isRow || relatedCol < floatInfo.getCol_offset() || relatedCol > floatInfo.getColEnd_offset()) continue;
                return true;
            }
        }
        return false;
    }

    public static IFloatInfo getFloatInfo(int r, int c, IDataAreaSetting multiAreaSetting, boolean isRow) {
        block2: {
            List floatInfos;
            FloatTypeEnum floatOnWhere;
            block3: {
                floatOnWhere = multiAreaSetting.getFloatOnWhere();
                floatInfos = multiAreaSetting.getFloatInfos();
                if (floatInfos == null) break block2;
                if (!isRow || floatOnWhere != FloatTypeEnum.ROW && floatOnWhere != FloatTypeEnum.ROWCOL) break block3;
                for (IFloatInfo floatInfo : floatInfos) {
                    if (r < floatInfo.getRow_offset() || r > floatInfo.getRowEnd_offset()) continue;
                    return floatInfo;
                }
                break block2;
            }
            if (isRow || floatOnWhere != FloatTypeEnum.COL && floatOnWhere != FloatTypeEnum.ROWCOL) break block2;
            for (IFloatInfo floatInfo : floatInfos) {
                if (c < floatInfo.getCol_offset() || c > floatInfo.getColEnd_offset()) continue;
                return floatInfo;
            }
        }
        return null;
    }

    public static List<IDataAreaSetting> getListOverlapAreaRange(String tarArea, List<IDataAreaSetting> sourceAreas) {
        if (StringUtils.isEmpty((CharSequence)tarArea) || sourceAreas == null || sourceAreas.isEmpty()) {
            return null;
        }
        ArrayList<IDataAreaSetting> areaSettings = new ArrayList<IDataAreaSetting>(16);
        for (IDataAreaSetting e : sourceAreas) {
            if (!ExcelUtils.isOverlap((String)e.getAreaRangeWithFloat(), (String)tarArea)) continue;
            areaSettings.add(e);
        }
        return areaSettings;
    }

    public static String getXYRelatedToAreaRange(String areaRange, String absolutePosition) {
        if (StringUtils.isEmpty((CharSequence)areaRange) || StringUtils.isEmpty((CharSequence)absolutePosition)) {
            return null;
        }
        String[] areaStartEndPos = areaRange.split(":");
        if (areaStartEndPos.length == 2) {
            Point areaStartPoint = ExcelUtils.pos2Point((String)areaStartEndPos[0]);
            Point absPoint = ExcelUtils.pos2Point((String)absolutePosition);
            return absPoint.x - areaStartPoint.x + ":" + (absPoint.y - areaStartPoint.y);
        }
        return null;
    }

    public static String checkRowColOverlapOnAreas(List<IDataAreaSetting> areaSettings) {
        if (areaSettings == null || areaSettings.size() < 2) {
            return null;
        }
        List<String> areaRanges = areaSettings.stream().map(e -> e.getAreaRange()).collect(Collectors.toList());
        return TemplateProcessHelper.checkRowColOverlapOnAreaRanges(areaRanges);
    }

    public static String checkRowColOverlapOnAreaRanges(List<String> areaRanges) {
        if (areaRanges == null || areaRanges.size() < 2) {
            return null;
        }
        boolean rowOverlap = false;
        boolean colOverlap = false;
        for (int i = 0; i < areaRanges.size(); ++i) {
            for (int j = i + 1; j < areaRanges.size(); ++j) {
                String[] startEndPos2;
                String[] startEndPos1;
                String area1 = areaRanges.get(i);
                String area2 = areaRanges.get(j);
                if (!StringUtils.isNotEmpty((CharSequence)area1) || !StringUtils.isNotEmpty((CharSequence)area2) || (startEndPos1 = area1.split(":")).length != 2 || (startEndPos2 = area2.split(":")).length != 2) continue;
                Point startPoint1 = ExcelUtils.pos2Point((String)startEndPos1[0]);
                Point endPoint1 = ExcelUtils.pos2Point((String)startEndPos1[1]);
                Point startPoint2 = ExcelUtils.pos2Point((String)startEndPos2[0]);
                Point endPoint2 = ExcelUtils.pos2Point((String)startEndPos2[1]);
                if (startPoint1.y <= endPoint2.y && endPoint1.y >= startPoint2.y) {
                    rowOverlap = true;
                }
                if (startPoint1.x <= endPoint2.x && endPoint1.x >= startPoint2.x) {
                    colOverlap = true;
                }
                if (!rowOverlap || !colOverlap) continue;
                return ROWCOL;
            }
        }
        return rowOverlap && colOverlap ? ROWCOL : (rowOverlap ? ROW : (colOverlap ? COL : null));
    }

    public static void setHeaderObjects(List<IHeaderInfo> headerInfos, Supplier<IHeaderObject> supplier, int startIndex, int endIndex) {
        if (headerInfos != null && startIndex <= endIndex) {
            for (IHeaderInfo headerInfo : headerInfos) {
                for (int i = startIndex; i <= endIndex; ++i) {
                    headerInfo.getHeaderObjects().set(i, supplier.get());
                }
            }
        }
    }

    public static List<Integer> getCompletedIndexes(List<IHeaderInfo> headerInfos, String headerType, int size) {
        LinkedList<Integer> indexes = new LinkedList<Integer>();
        if (CollectionUtils.isNotEmpty(headerInfos) && headerType != null && size > 0) {
            for (int i = 0; i < size; ++i) {
                boolean noValue = false;
                for (IHeaderInfo hi : headerInfos) {
                    IHeaderObject ho;
                    List hos = hi.getHeaderObjects();
                    if (!headerType.equals(hi.getType()) || (ho = (IHeaderObject)hos.get(i)) != null && (!StringUtils.isEmpty((CharSequence)ho.getNumber()) || ho.isFloat())) continue;
                    noValue = true;
                    break;
                }
                if (noValue) continue;
                indexes.add(i);
            }
        }
        return indexes;
    }

    public static Pair<List<Integer>, List<Integer>> getCompletedIndexes(IDataAreaSetting areaSetting, boolean isAbs) {
        List<Object> rowIndexes = new LinkedList();
        List<Object> colIndexes = new LinkedList();
        if (areaSetting != null) {
            CellArea cellArea = new CellArea(areaSetting.getAreaRange());
            rowIndexes = TemplateProcessHelper.getCompletedIndexes(areaSetting.getRowHeaders(), "Dimension", cellArea.getRc());
            colIndexes = TemplateProcessHelper.getCompletedIndexes(areaSetting.getColHeaders(), "Dimension", cellArea.getCc());
            if (isAbs) {
                int rowStart = cellArea.getR();
                int colStart = cellArea.getC();
                rowIndexes = rowIndexes.stream().map(e -> e + rowStart).collect(Collectors.toList());
                colIndexes = colIndexes.stream().map(e -> e + colStart).collect(Collectors.toList());
            }
        }
        return Pair.onePair(rowIndexes, colIndexes);
    }

    public static List<ICell> getCompletedCells(IDataAreaSetting areaSetting) {
        return TemplateProcessHelper.getCompletedCells(areaSetting, true, true);
    }

    public static List<ICell> getCompletedCells(IDataAreaSetting areaSetting, boolean includeFloatRange, boolean includeRelationCols) {
        LinkedList<ICell> cells = new LinkedList<ICell>();
        Pair<List<Integer>, List<Integer>> rowCols = TemplateProcessHelper.getCompletedIndexes(areaSetting, true);
        for (Integer r : (List)rowCols.p1) {
            for (Integer c : (List)rowCols.p2) {
                cells.add((ICell)new OneCell(r.intValue(), c.intValue()));
            }
        }
        if (includeFloatRange) {
            areaSetting.getFloatInfos().forEach(f -> {
                RangeModel floatRangeModel = areaSetting.getFloatRange(f, new RangeModel(areaSetting.getAreaRange()));
                cells.addAll(new CellArea(floatRangeModel.toString()).splitToCells());
            });
        }
        if (includeRelationCols && areaSetting.isRelation()) {
            int colSize = areaSetting.getRelationAreaInfo().getCols().size();
            CellArea cellArea = new CellArea(areaSetting.getAreaRange());
            cellArea.setCc(colSize);
            cells.addAll(cellArea.splitToCells());
        }
        return cells;
    }

    public static String getMemberShowInfo(Long modelId, String dimNumber, List<IDimensionMember> members) {
        StringBuilder sb = new StringBuilder();
        if (modelId != null && dimNumber != null && CollectionUtils.isNotEmpty(members)) {
            String scopeJoin = ResManager.loadKDString((String)"\u7684", (String)"TemplateProcessHelper_0", (String)"epm-emr-formplugin", (Object[])new Object[0]);
            EpbsMemberCache memberCache = EpbsMemberCacheHelper.get((long)modelId, (String)dimNumber);
            EpbsPropCache propCache = EpbsPropCacheHelper.get((long)modelId, (String)dimNumber);
            members.forEach(m -> {
                if (StringUtils.isEmpty((CharSequence)m.getName()) && StringUtils.isNotEmpty((CharSequence)m.getNumber())) {
                    if (RangeF7PropertyCataEnum.Property.getIndex().equals(m.getType()) && StringUtils.isNotEmpty((CharSequence)m.getLongNumber())) {
                        String[] arr = m.getLongNumber().split("!");
                        PropBean propBean = propCache.getProp(arr[0]);
                        if (propBean != null && propBean.getPropValue(arr[1]) != null) {
                            sb.append(propBean.getPropValue(arr[1]).getNameString());
                        }
                    } else {
                        MemberBean mb = memberCache.getMember(m.getViewNumber(), m.getNumber());
                        if (mb != null) {
                            sb.append(mb.getNameString());
                        }
                    }
                } else {
                    sb.append(m.getName());
                }
                RangeEnum rangeEnum = RangeEnum.getRangeByVal((int)m.getScope());
                if (rangeEnum != RangeEnum.ONLY) {
                    sb.append(scopeJoin).append(rangeEnum.getName());
                }
                sb.append(",");
            });
            if (sb.lastIndexOf(",") == sb.length() - 1) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        return sb.toString();
    }

    public static void resetCellStyle(ISpreadContainer spreadContainer, int r, int c, boolean isRelation, boolean isFloat) {
        if (spreadContainer != null) {
            ArrayList cellAreas = Lists.newArrayList((Object[])new CellArea[]{new CellArea(r, c, 1, 1)});
            if (isRelation) {
                spreadContainer.setFListCellArea((List)cellAreas, false, false);
            } else {
                AreasStyle areasStyle = new AreasStyle();
                areasStyle.setStyle(new CellStyleInfo().ofBkc(isFloat ? "#DBE5F1" : "#66CDAA"));
                areasStyle.setRange((List)cellAreas);
                spreadContainer.setCellStyle(Collections.singletonList(areasStyle));
                spreadContainer.setFListCellArea((List)cellAreas, !isFloat, false);
            }
        }
    }
}

