/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.formplugin.template.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.emr.business.model.f7.EmrMemberF7Parameter;
import kd.epm.emr.business.template.dimension.DefaultDimension;
import kd.epm.emr.business.template.dimension.IDimension;
import kd.epm.emr.business.template.service.impl.TemplateMemberServiceImpl;
import kd.epm.emr.business.template.var.DefaultVar;
import kd.epm.emr.common.model.cache.EmrMemberCache;
import kd.epm.emr.common.model.cache.EmrMemberCacheHelper;
import kd.epm.emr.common.model.cache.EmrModelCacheHelper;
import kd.epm.emr.common.template.EmrDefaultDimMember;
import kd.epm.emr.formplugin.report.helper.SpreadMemberHelper;
import kd.epm.epbs.business.member.f7.NewF7Utils;
import kd.epm.epbs.business.model.f7.MemberF7Parameter;
import kd.epm.epbs.common.enums.RangeEnum;
import kd.epm.epbs.common.member.f7.AbstractMemberF7Parameter;
import kd.epm.epbs.common.model.IBaseEntry;
import kd.epm.epbs.common.model.IDimensionMember;
import kd.epm.epbs.common.model.PropertyEntry;
import kd.epm.epbs.common.model.PropertyValueEntry;
import kd.epm.epbs.common.model.bean.BizModelBean;
import kd.epm.epbs.common.model.bean.BizModelDimBean;
import kd.epm.epbs.common.model.bean.DimensionBean;
import kd.epm.epbs.common.model.bean.MemberBean;
import kd.epm.epbs.common.model.bean.MemberPropBean;
import kd.epm.epbs.common.model.bean.ViewBean;
import kd.epm.epbs.common.model.bean.relation.RelationModelBean;
import kd.epm.epbs.common.model.bean.relation.RelationModelBeanProvider;
import kd.epm.epbs.common.model.cache.EpbsMemberCache;
import kd.epm.epbs.common.model.cache.EpbsModelCache;
import kd.epm.epbs.common.model.cache.EpbsPropCache;
import kd.epm.epbs.common.model.cache.EpbsPropCacheHelper;
import kd.epm.epbs.common.util.IDUtils;
import kd.epm.epbs.common.util.Pair;
import kd.epm.epbs.common.util.QFBuilder;
import kd.epm.epbs.formplugin.model.memberf7.bean.EpbsSelectedMember;
import kd.epm.epbs.formplugin.model.memberf7.bean.MultiF7Result;
import org.apache.commons.collections4.CollectionUtils;

public class EmrTemplateMemberService
extends TemplateMemberServiceImpl {
    private EpbsModelCache modelCache = null;
    private EpbsMemberCache memberCache = null;
    private EpbsPropCache propCache = null;

    public EmrTemplateMemberService() {
    }

    public static EmrTemplateMemberService getInstance(Long modelId) {
        return new EmrTemplateMemberService(modelId);
    }

    public EmrTemplateMemberService(Long modelId) {
        super(modelId);
    }

    public Set<String> getDefPageDims() {
        HashSet<String> defaultPageDims = new HashSet<String>(16);
        return defaultPageDims;
    }

    public Set<String> getDefRankDims() {
        HashSet<String> defaultRankDims = new HashSet<String>(16);
        return defaultRankDims;
    }

    public String getDefDimMember(String memberModel, String shortNumber) {
        String number = null;
        return number;
    }

    public ViewBean getDefView(String dimNumber, Long bizModelId) {
        BizModelBean modelBean = this.getModelCache().getBizModelById(bizModelId.longValue());
        DimensionBean dimensionBean = this.getModelCache().getDimension(dimNumber);
        BizModelDimBean bizModelDimBean = (BizModelDimBean)modelBean.getDimMap().get(dimensionBean.getId());
        Long viewId = CollectionUtils.isNotEmpty((Collection)bizModelDimBean.getViewIds()) ? (Long)bizModelDimBean.getViewIds().get(0) : null;
        return IDUtils.isNotNull(viewId) ? this.getModelCache().getViewById(viewId.longValue()) : null;
    }

    public List<IDimension> getAllDims(Long bizModelId) {
        LinkedList<IDimension> result = new LinkedList<IDimension>();
        if (null == bizModelId) {
            return result;
        }
        Set dimIds = this.getModelCache().getBizModelById(bizModelId.longValue()).getDimensions();
        this.getModelCache().getDimensionMap().forEach((k, vd) -> {
            if (dimIds.contains(k)) {
                result.add(this.buildDimension((DimensionBean)vd));
            }
        });
        return result;
    }

    protected IDimension buildDimension(DimensionBean dimensionBean) {
        if (null != dimensionBean) {
            DefaultDimension dimension = new DefaultDimension(Long.valueOf(dimensionBean.getId()), dimensionBean.getNameString(), dimensionBean.getNumber(), Integer.valueOf(dimensionBean.getDseq()));
            dimension.setShortNumber(dimensionBean.getShortNumber());
            dimension.setMemberModel(this.getModelCache().getDimTypeById(dimensionBean.getDimTypeId()).getMemberTreemodel());
            return dimension;
        }
        return null;
    }

    public IDimension getDimension(String dimNumber) {
        DimensionBean dimensionBean = this.getModelCache().getDimension(dimNumber);
        return this.buildDimension(dimensionBean);
    }

    public IDimensionMember getDimMember(String dimNumber, String dimMemberNumber, Long dimMemberId) {
        return this.getDimMember(dimNumber, null, dimMemberId, null);
    }

    public IDimensionMember getDimMember(String dimNumber, String dimMemberNumber, Long dimMemberId, Long viewId) {
        EmrMemberCache memberCache = EmrMemberCacheHelper.get((long)this.getModelId(), (String)dimNumber);
        MemberBean member = null;
        if (StringUtils.isNotEmpty((String)dimMemberNumber) && IDUtils.isNotNull((Long)viewId)) {
            member = memberCache.getMember(viewId.longValue(), dimMemberNumber);
        } else if (null != dimMemberId && (member = memberCache.getMember(dimMemberId.longValue())) != null) {
            viewId = member.getViewId();
        }
        Long id = member == null ? null : Long.valueOf(member.getId());
        String number = member == null ? null : member.getNumber();
        String name = member == null ? null : member.getNameString();
        EmrDefaultDimMember dimensionMember = new EmrDefaultDimMember();
        dimensionMember.setId(id);
        dimensionMember.setNumber(number);
        dimensionMember.setName(name);
        if (IDUtils.isNotNull((Long)viewId)) {
            dimensionMember.setViewId(viewId);
            ViewBean view = this.getView(viewId);
            dimensionMember.setViewNumber(null != view ? view.getNumber() : null);
        }
        if (member != null && IDUtils.isNotNull((long)member.getParentId())) {
            dimensionMember.setParentNum(memberCache.getMember(member.getParentId()).getNumber());
        }
        return dimensionMember;
    }

    public String getPropertyEntity() {
        return "emr_propertydefined";
    }

    public List<PropertyEntry> getAllPropertys(Long bizModelId, List<String> dimNumbers) {
        DynamicObjectCollection propertyList;
        ArrayList propertys = Lists.newArrayList();
        QFBuilder builder = new QFBuilder();
        builder.add("model", "=", (Object)this.getModelId());
        if (CollectionUtils.isNotEmpty(dimNumbers)) {
            builder.add("dimension.number", "in", dimNumbers);
        }
        if ((propertyList = QueryServiceHelper.query((String)this.getPropertyEntity(), (String)"id,name,number,dimension.number,dseq", (QFilter[])builder.toArrays())) != null && !propertyList.isEmpty()) {
            propertyList.forEach(p -> {
                PropertyEntry propertyEntry = new PropertyEntry(Long.valueOf(p.getLong("id")), p.getString("name"), p.getString("number"), p.getString("dimension.number"));
                propertyEntry.setDseq(p.getInt("dseq"));
                propertys.add(propertyEntry);
            });
        }
        return propertys;
    }

    public PropertyValueEntry getPropertyValue(String dimNumber, String propValNumber, Long propValueId) {
        return null;
    }

    public Map<String, List<PropertyEntry>> getMemberProperties(String dimNumber, Set<String> memNumbers) {
        HashMap<String, List<PropertyEntry>> properties = new HashMap<String, List<PropertyEntry>>(memNumbers.size());
        return properties;
    }

    public Map<String, Map<String, String>> getMemberPropValues(String dimNumber, Set<Pair<String, String>> viewMemNumbers) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(16);
        if (CollectionUtils.isNotEmpty(viewMemNumbers)) {
            this.memberCache = this.getMemberCache(null, dimNumber);
            this.propCache = this.getPropCache(null, dimNumber);
            HashMap memId2Number = new HashMap(16);
            HashMap<Long, String> propId2Number = new HashMap<Long, String>(16);
            LinkedList memberPropBeans = new LinkedList();
            viewMemNumbers.forEach(e -> {
                MemberBean mb = this.memberCache.getMember((String)e.p1, (String)e.p2);
                if (mb != null) {
                    memId2Number.put(mb.getBaseMemberBean().getId(), mb.getNumber());
                    List propBeans = this.propCache.getMemberPropList(mb.getId());
                    if (CollectionUtils.isNotEmpty((Collection)propBeans)) {
                        memberPropBeans.addAll(propBeans);
                    }
                }
            });
            for (MemberPropBean e2 : memberPropBeans) {
                String propNumber;
                String memNumber = (String)memId2Number.get(e2.getMemberId());
                HashMap<String, String> propAndValue = (HashMap<String, String>)result.get(memNumber);
                if (propAndValue == null) {
                    propAndValue = new HashMap<String, String>(16);
                    result.put(memNumber, propAndValue);
                }
                if ((propNumber = (String)propId2Number.get(e2.getPropertyId())) == null) {
                    propNumber = this.propCache.getProp(e2.getPropertyId()).getNumber();
                    propId2Number.put(e2.getPropertyId(), propNumber);
                }
                if (e2.getPropValueBean() != null) {
                    propAndValue.put(propNumber, e2.getPropValueBean().getNameString());
                    continue;
                }
                propAndValue.put(propNumber, e2.getPropValue());
            }
        }
        return result;
    }

    public Map<String, Map<String, String>> getVarMap(Long bizModelId) {
        return null;
    }

    public IBaseEntry getVar(String dimNumber, String varNumber, Long varId) {
        IBaseEntry var = null;
        return var;
    }

    public Long getViewId(String dimNumber, String viewNumber) {
        if (StringUtils.isEmpty((String)dimNumber) || StringUtils.isEmpty((String)viewNumber)) {
            return null;
        }
        ViewBean viewBean = this.getModelCache().getView(dimNumber, viewNumber);
        return null != viewBean ? Long.valueOf(viewBean.getId()) : null;
    }

    public ViewBean getView(Long viewId) {
        return this.getModelCache().getViewById(viewId.longValue());
    }

    public Map<Long, BizModelBean> getBizModelMap() {
        return this.getModelCache().getBizModelMap();
    }

    public String getBizModelNumber(Long bizModelId) {
        if (IDUtils.isNull((Long)bizModelId)) {
            return null;
        }
        BizModelBean bizModelBean = this.getBizModel(bizModelId);
        return null != bizModelBean ? bizModelBean.getNumber() : null;
    }

    public Long getBizModelId(String bizModelNumber) {
        Map.Entry entry = this.getBizModelMap().entrySet().stream().filter(e -> Objects.equals(((BizModelBean)e.getValue()).getNumber(), bizModelNumber)).findFirst().orElseGet(() -> null);
        return null != entry ? (Long)entry.getKey() : null;
    }

    public BizModelBean getBizModel(Long bizModelId) {
        return this.getModelCache().getBizModelById(bizModelId.longValue());
    }

    public RelationModelBean getRelationModel(Long bizModelId) {
        return RelationModelBeanProvider.getRelationModelBeanById((long)this.getModelId(), (long)bizModelId);
    }

    public RelationModelBean getRelationModel(String bizNum) {
        return RelationModelBeanProvider.getRelationModelBeanByNum((long)this.getModelId(), (String)bizNum);
    }

    public String getCubeNumber(Long bizModelId) {
        return this.getModelCache().getBizModelById(bizModelId.longValue()).getCube();
    }

    public IBaseEntry getVarEntry(String dimKey, Long id, Map<String, Map<String, String>> varNumberNameMap) {
        DefaultVar var = new DefaultVar();
        if (null == id) {
            return var;
        }
        return var;
    }

    public EpbsModelCache getModelCache() {
        if (this.modelCache == null) {
            this.modelCache = EmrModelCacheHelper.get((long)this.getModelId());
        }
        return this.modelCache;
    }

    public EpbsMemberCache getMemberCache(Long dimId, String dimNumber) {
        if (this.memberCache == null) {
            this.memberCache = IDUtils.isNotNull((Long)dimId) ? EmrMemberCacheHelper.get((long)this.getModelId(), (long)dimId) : EmrMemberCacheHelper.get((long)this.getModelId(), (String)dimNumber);
        }
        return this.memberCache;
    }

    public EpbsPropCache getPropCache(Long dimId, String dimNumber) {
        if (this.propCache == null) {
            this.propCache = IDUtils.isNotNull((Long)dimId) ? EpbsPropCacheHelper.get((long)this.getModelId(), (long)dimId) : EpbsPropCacheHelper.get((long)this.getModelId(), (String)dimNumber);
        }
        return this.propCache;
    }

    public void openMultiF7(IDimension dimension, MemberF7Parameter f7params, CloseCallBack closeCallBack, IFormView formView) {
        if (dimension == null || this.getModelId() == null || closeCallBack == null || f7params == null) {
            return;
        }
        f7params.setMultiSelect(true);
        f7params.setEnableView(true);
        f7params.setClearSelectWhenChangeView(true);
        f7params.setReturnAllData(true);
        f7params.setVerifyPermission(true);
        f7params.setCutTree(false);
        NewF7Utils.openF8((IFormView)formView, (AbstractMemberF7Parameter)f7params, (CloseCallBack)closeCallBack);
    }

    public void openSingleF7(IDimension dimension, MemberF7Parameter f7params, CloseCallBack closeCallBack, IFormView formView) {
        if (dimension == null || this.getModelId() == null || closeCallBack == null || f7params == null) {
            return;
        }
        f7params.setMultiSelect(false);
        f7params.setEnableView(true);
        f7params.setReturnAllData(true);
        f7params.setVerifyPermission(true);
        f7params.setCutTree(false);
        NewF7Utils.openF7((IFormView)formView, (AbstractMemberF7Parameter)f7params, (CloseCallBack)closeCallBack);
    }

    public void openSingleF7ForAreaView(IDimension dimension, MemberF7Parameter f7params, CloseCallBack closeCallBack, IFormView formView) {
        if (dimension == null || this.getModelId() == null || f7params == null) {
            return;
        }
        BeforeF7SelectEvent e = (BeforeF7SelectEvent)formView.getFormShowParameter().getCustomParam("BeforeF7SelectEvent");
        f7params.setMultiSelect(false);
        f7params.setEnableView(true);
        f7params.setVerifyPermission(true);
        f7params.setCutTree(false);
        NewF7Utils.openF7((BeforeF7SelectEvent)e, (AbstractMemberF7Parameter)f7params, (CloseCallBack)closeCallBack);
    }

    public void openSingleF7ForSpread(String f7Key, IDimension dimension, MemberF7Parameter f7params, CloseCallBack closeCallBack, IFormView formView) {
        if (dimension == null || this.getModelId() == null || f7params == null) {
            return;
        }
        ListShowParameter formShowParameter = this.buildSpreadFormShowParameter(dimension);
        formShowParameter.setCloseCallBack(closeCallBack);
        BasedataEdit eb_singletreef7 = this.buildSpreadBasedataEdit(f7Key, dimension, formView);
        BeforeF7SelectEvent e = new BeforeF7SelectEvent((FieldEdit)eb_singletreef7, 0, null);
        e.setFormShowParameter((FormShowParameter)formShowParameter);
        f7params.setEnableView(true);
        f7params.setVerifyPermission(true);
        f7params.setCutTree(false);
        NewF7Utils.openF7((BeforeF7SelectEvent)e, (AbstractMemberF7Parameter)f7params);
        formView.showForm((FormShowParameter)formShowParameter);
    }

    private BasedataEdit buildSpreadBasedataEdit(String spreadKey, IDimension dimension, IFormView formView) {
        BasedataEdit eb_singletreef7 = new BasedataEdit();
        eb_singletreef7.setEntryKey(dimension.getMemberModel());
        eb_singletreef7.setKey(spreadKey);
        eb_singletreef7.setView(formView);
        formView.createControlIndex((List)Lists.newArrayList((Object[])new Control[]{eb_singletreef7}));
        return eb_singletreef7;
    }

    private ListShowParameter buildSpreadFormShowParameter(IDimension dimension) {
        ListShowParameter formShowParameter = ShowFormHelper.createShowListForm((String)dimension.getMemberModel(), (boolean)true);
        formShowParameter.setShowApproved(true);
        formShowParameter.setShowUsed(true);
        formShowParameter.setCustomParam("dimId", (Object)dimension.getId());
        formShowParameter.setCustomParam("isMul", (Object)true);
        formShowParameter.setCustomParam("dimNumber", (Object)dimension.getNumber());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        return formShowParameter;
    }

    public Pair<String, List<Map<String, String>>> f7ClosedCallBack(String actionId, Object returnData) {
        if (null == returnData) {
            return null;
        }
        ArrayList list = Lists.newArrayList();
        if (returnData instanceof MultiF7Result) {
            MultiF7Result multiF7Result = (MultiF7Result)returnData;
            List selectedMembers = multiF7Result.getSelectedMemberList();
            for (EpbsSelectedMember m : selectedMembers) {
                list.add(this.getDimMemberMessageMap(m.getId(), m.getNumber(), m.getName(), m.getScope(), m.getType(), m.getViewId(), m.getParentNumber()));
            }
        }
        String value = this.getMultiF7Results(list);
        return Pair.onePair((Object)value, (Object)list);
    }

    public String getMultiF7Results(List<Map<String, String>> members) {
        StringBuilder sb = new StringBuilder();
        for (Map<String, String> e : members) {
            if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)e.get("name"))) continue;
            this.buildMultiSelectF7ReturnValue(sb, e.get("name"), Integer.parseInt(e.get("scope")));
        }
        return this.getMultiSelectF7ReturnValue(sb);
    }

    private String getMultiSelectF7ReturnValue(StringBuilder sb) {
        if (sb == null || sb.length() == 0) {
            return " ";
        }
        return sb.indexOf(",") > 0 ? sb.substring(0, sb.length() - 1) : "";
    }

    private void buildMultiSelectF7ReturnValue(StringBuilder sb, String name, int val) {
        if (val == 0 || RangeEnum.getRangeByVal((int)val) == RangeEnum.ONLY) {
            sb.append(name).append(',');
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"EmrTemplateMemberService_0", (String)"epm-emr-formplugin", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(',');
        }
    }

    public MemberF7Parameter getMemberF7Parameter(long dimensionId) {
        return new EmrMemberF7Parameter(this.getModelId(), Long.valueOf(dimensionId));
    }

    public MemberF7Parameter getMemberF7Parameter(String dimensionNumber) {
        return new EmrMemberF7Parameter(this.getModelId(), dimensionNumber);
    }

    public MemberF7Parameter getMemberF7Parameter(String dimNum, long dimBizModelId) {
        List<Long> views;
        EmrMemberF7Parameter parameter = new EmrMemberF7Parameter(this.getModelId(), dimNum);
        if (dimBizModelId != 0L && CollectionUtils.isNotEmpty(views = SpreadMemberHelper.getViewIdsByDimNum(dimNum, this.getModelId(), dimBizModelId))) {
            parameter.setViewFilterList(views);
            parameter.addCustomCommFilter(SpreadMemberHelper.getViewQFilter(views));
        }
        return parameter;
    }
}

