/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.emr.common.spread.command.rangedefined;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import kd.epm.emr.common.spread.command.rangedefined.OneCell;
import kd.epm.epbs.common.util.ExcelUtils;
import kd.epm.epbs.common.util.ICell;
import kd.epm.epbs.common.util.Point;

public class CellArea
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int r;
    private int c;
    private int rc;
    private int cc;

    public CellArea(String area) {
        String[] ss = area.split(":");
        Point start = ExcelUtils.pos2Point((String)ss[0]);
        Point end = ss.length > 1 ? ExcelUtils.pos2Point((String)ss[1]) : ExcelUtils.pos2Point((String)ss[0]);
        this.r = start.y;
        this.c = start.x;
        this.rc = end.y - start.y + 1;
        this.cc = end.x - start.x + 1;
    }

    public CellArea(int rowStart, int colStart, int rows, int cols) {
        this.r = rowStart;
        this.c = colStart;
        this.rc = rows;
        this.cc = cols;
    }

    public int getR() {
        return this.r;
    }

    public void setR(int r) {
        this.r = r;
    }

    public int getC() {
        return this.c;
    }

    public void setC(int c) {
        this.c = c;
    }

    public int getRc() {
        return this.rc;
    }

    public void setRc(int rc) {
        this.rc = rc;
    }

    public int getCc() {
        return this.cc;
    }

    public void setCc(int cc) {
        this.cc = cc;
    }

    public List<CellArea> split() {
        LinkedList<CellArea> splitted = new LinkedList<CellArea>();
        for (int i = 0; i < this.rc; ++i) {
            for (int j = 0; j < this.cc; ++j) {
                splitted.add(new CellArea(this.r + i, this.c + j, 1, 1));
            }
        }
        return splitted;
    }

    public List<ICell> splitToCells() {
        LinkedList<ICell> splitted = new LinkedList<ICell>();
        for (int i = 0; i < this.rc; ++i) {
            for (int j = 0; j < this.cc; ++j) {
                splitted.add(new OneCell(this.r + i, this.c + j));
            }
        }
        return splitted;
    }

    public String toString() {
        return this.getRect(true);
    }

    public String getRect(boolean isRange) {
        String b;
        int x_start = this.c;
        int y_start = this.r;
        int x_end = this.c + this.cc - 1;
        int y_end = this.r + this.rc - 1;
        String a = ExcelUtils.xy2Pos((int)x_start, (int)y_start);
        if (a.equals(b = ExcelUtils.xy2Pos((int)x_end, (int)y_end)) && !isRange) {
            return a;
        }
        return a + ":" + b;
    }
}

